/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.rokovnik;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Rokovnik;
import com.dev63.restoran.model.RokovnikTipUnosa;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.resources.FontCache;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PregledRokovnika {
    private RestoranServer server;
    private Shell shell;
    private TableViewer listTable;
    private TableColumnLayout tableLayout;
    private List<Rokovnik> dataList;
    private Date odD;
    private Date doD;
    private Label comment;
    private Label datum;
    private Label vreme;
    private Label datumUnosa;
    private Label uneo;
    private Label tip;
    private Font labelFont;
    private Color labelForeG;
    private Font dataFont;

    public PregledRokovnika(Shell parent, Restoran restoran, Date from, Date to, RokovnikTipUnosa typeOfEntry) {
        this.server = restoran.getServer();
        this.odD = from;
        this.doD = to;
        this.shell = new Shell(parent, 2144);
        this.shell.setText("Pregled rokovnika");
        this.shell.setBounds(this.shell.getDisplay().getPrimaryMonitor().getBounds());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setMaximized(true);
        this.labelFont = FontCache.getFont("Arial", 12, 2);
        this.dataFont = FontCache.getFont("Arial", 12, 0);
        this.labelForeG = this.shell.getDisplay().getSystemColor(15);
        this.tableLayout = new TableColumnLayout();
        Composite c = new Composite((Composite)this.shell, 2048);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.bottom = new FormAttachment(100, -3);
        fd.right = new FormAttachment(66, 0);
        c.setLayoutData((Object)fd);
        c.setLayout((Layout)this.tableLayout);
        this.listTable = new TableViewer(c, 66052);
        this.listTable.getTable().setHeaderVisible(true);
        this.listTable.getTable().setLinesVisible(true);
        this.makeColumns();
        this.dataList = typeOfEntry == null ? this.server.findAllRokovnikForDateRange(this.odD, this.doD) : this.server.findAllRokovnikForDateRangeByType(this.odD, this.doD, typeOfEntry);
        this.listTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listTable.setInput(this.dataList);
        Composite c2 = new Composite((Composite)this.shell, 2048);
        FormData fd2 = new FormData();
        fd2.top = new FormAttachment(0, 3);
        fd2.left = new FormAttachment((Control)c, 3);
        fd2.bottom = new FormAttachment(100, -3);
        fd2.right = new FormAttachment(100, -3);
        c2.setLayoutData((Object)fd2);
        c2.setLayout((Layout)new GridLayout());
        Group g1 = new Group(c2, 16);
        g1.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_PODACI"));
        g1.setLayoutData((Object)new GridData(4, 4, true, false));
        g1.setLayout((Layout)new GridLayout(2, false));
        Label datumL = new Label((Composite)g1, 0);
        datumL.setFont(this.labelFont);
        datumL.setForeground(this.labelForeG);
        datumL.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM") + ":");
        datumL.setLayoutData((Object)this.makeGdLabel());
        this.datum = new Label((Composite)g1, 0);
        this.datum.setFont(this.dataFont);
        this.datum.setLayoutData((Object)this.makeGdData());
        Label vremeL = new Label((Composite)g1, 0);
        vremeL.setFont(this.labelFont);
        vremeL.setForeground(this.labelForeG);
        vremeL.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_VREME") + ":");
        vremeL.setLayoutData((Object)this.makeGdLabel());
        this.vreme = new Label((Composite)g1, 0);
        this.vreme.setFont(this.dataFont);
        this.vreme.setLayoutData((Object)this.makeGdData());
        Label datumUnosaL = new Label((Composite)g1, 0);
        datumUnosaL.setFont(this.labelFont);
        datumUnosaL.setForeground(this.labelForeG);
        datumUnosaL.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_UNOSA") + ":");
        datumUnosaL.setLayoutData((Object)this.makeGdLabel());
        this.datumUnosa = new Label((Composite)g1, 0);
        this.datumUnosa.setFont(this.dataFont);
        this.datumUnosa.setLayoutData((Object)this.makeGdData());
        Label uneoL = new Label((Composite)g1, 0);
        uneoL.setFont(this.labelFont);
        uneoL.setForeground(this.labelForeG);
        uneoL.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UNEO") + ":");
        uneoL.setLayoutData((Object)this.makeGdLabel());
        this.uneo = new Label((Composite)g1, 0);
        this.uneo.setFont(this.dataFont);
        this.uneo.setLayoutData((Object)this.makeGdData());
        Label tipL = new Label((Composite)g1, 0);
        tipL.setFont(this.labelFont);
        tipL.setForeground(this.labelForeG);
        tipL.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_TIP") + ":");
        tipL.setLayoutData((Object)this.makeGdLabel());
        this.tip = new Label((Composite)g1, 0);
        this.tip.setFont(this.dataFont);
        this.tip.setLayoutData((Object)this.makeGdData());
        Group g2 = new Group(c2, 16);
        g2.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_NAPOMENA"));
        g2.setLayoutData((Object)new GridData(4, 4, true, true));
        g2.setLayout((Layout)new FillLayout());
        this.comment = new Label((Composite)g2, 18496);
        this.comment.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.comment.setFont(this.dataFont);
        this.listTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                IStructuredSelection selection = (IStructuredSelection)PregledRokovnika.this.listTable.getSelection();
                Rokovnik fe = (Rokovnik)selection.getFirstElement();
                if (fe != null) {
                    PregledRokovnika.this.datum.setText(StatLogic.getDateString(fe.getDatum()));
                    PregledRokovnika.this.vreme.setText(StatLogic.getTimeString(fe.getVreme()));
                    PregledRokovnika.this.datumUnosa.setText(StatLogic.getDateTimeString(fe.getVreme()));
                    PregledRokovnika.this.uneo.setText(fe.getUneo());
                    PregledRokovnika.this.tip.setText(fe.getTipUnosa().getInterName());
                    PregledRokovnika.this.comment.setText(fe.getNapomena());
                }
            }
        });
        this.shell.layout();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    private GridData makeGdLabel() {
        GridData gd = new GridData(131072, 128, false, false);
        return gd;
    }

    public GridData makeGdData() {
        GridData gd = new GridData(4, 128, true, false);
        return gd;
    }

    public void makeColumns() {
        TableViewerColumn tcv = new TableViewerColumn(this.listTable, 0x1000000);
        tcv.getColumn().setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM"));
        this.tableLayout.setColumnData((Widget)tcv.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        tcv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rokovnik r = (Rokovnik)element;
                return StatLogic.getDateString(r.getDatum());
            }
        });
        tcv = new TableViewerColumn(this.listTable, 0x1000000);
        tcv.getColumn().setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_VREME"));
        this.tableLayout.setColumnData((Widget)tcv.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        tcv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rokovnik r = (Rokovnik)element;
                return StatLogic.getTimeString(r.getVreme());
            }
        });
        tcv = new TableViewerColumn(this.listTable, 0x1000000);
        tcv.getColumn().setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_TIP"));
        this.tableLayout.setColumnData((Widget)tcv.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        tcv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rokovnik r = (Rokovnik)element;
                return r.getTipUnosa().getInterName();
            }
        });
        tcv = new TableViewerColumn(this.listTable, 0x1000000);
        tcv.getColumn().setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_UNEO"));
        this.tableLayout.setColumnData((Widget)tcv.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        tcv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rokovnik r = (Rokovnik)element;
                return r.getUneo();
            }
        });
        tcv = new TableViewerColumn(this.listTable, 0x1000000);
        tcv.getColumn().setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_DATUM_UNOSA"));
        this.tableLayout.setColumnData((Widget)tcv.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, true));
        tcv.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Rokovnik r = (Rokovnik)element;
                return StatLogic.getDateTimeString(r.getDatumUnosa());
            }
        });
    }

    public static class PregledRokovnikaInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        private Combo tip;
        private Shell parent;
        private Shell shell;
        private RokovnikTipUnosa izabraniTip = null;

        public PregledRokovnikaInput(Shell owner, Restoran r) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.shell = new Shell(this.parent, 34912);
            this.shell.setText("Filteri za pregled rokovnika");
            this.shell.setLayout((Layout)new GridLayout());
            Composite panel1 = new Composite((Composite)this.shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)this.shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            final Image img = new Image((Device)this.shell.getDisplay(), ImagePath.getPath() + "/pregledV.gif");
            slika.setImage(img);
            slika.setLayoutData((Object)data);
            slika.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (img != null && !img.isDisposed()) {
                        img.dispose();
                    }
                }
            });
            data = new GridData();
            data.heightHint = 80;
            data.widthHint = 664 - img.getBounds().width;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Pregled Rokovnika");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("Ekran za odabir filtera za pregled rokovnika");
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos filtera");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa2 = new Group(panel2, 0);
            grupa2.setLayout((Layout)new GridLayout(2, false));
            grupa2.setText("Filter Pregleda");
            grupa2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            od.setText("Od datuma:");
            this.odDatuma = new DateInput2(parent2, "Od datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, this.shell));
            Label doD = new Label((Composite)grupa1, 0);
            doD.setText("Do datuma:");
            this.doDatuma = new DateInput2(parent2, "Do datuma", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, this.shell));
            Label art = new Label((Composite)grupa2, 0);
            art.setText("Tip unosa:");
            this.tip = new Combo((Composite)grupa2, 8);
            this.tip.add("Svi tipovi");
            for (RokovnikTipUnosa tipUnosa : RokovnikTipUnosa.values()) {
                this.tip.add(tipUnosa.getInterName());
            }
            this.tip.select(0);
            this.tip.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (tip.getSelectionIndex() < 1) {
                        izabraniTip = null;
                    } else {
                        izabraniTip = RokovnikTipUnosa.values()[tip.getSelectionIndex() - 1];
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            doD.setLayoutData((Object)data);
            art.setLayoutData((Object)data);
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            SWTContainerClass.setDimension(this.shell);
            this.shell.open();
        }

        private void cancel() {
            this.shell.close();
        }

        private void ok() {
            Date odD = new Date();
            Date doD = new Date();
            try {
                odD = this.odDatuma.getResult();
                doD = this.doDatuma.getResult();
            }
            catch (Exception e) {
                Logger.getLogger(PregledRokovnikaInput.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom parsiranja datuma za pregled rokovnika", e);
            }
            new PregledRokovnika(this.shell, this.restoran, odD, doD, this.izabraniTip);
        }
    }
}

