/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.radkonobara;

import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.backoffice.radkonobara.StoBMaster;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Rezervacija;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.StoPrikaz;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.swt.resources.FontCache;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PregledStolovi {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    private Restoran restoran;
    private RestoranServer server;
    private Integer brojStola = null;
    private Map<Integer, String> naziviStolova = new HashMap<Integer, String>();
    private Shell shell3;
    private Font fontGrafika;
    private Composite cGrafika;
    private GrafikSale aktivGrafik;
    private Map<Integer, Rezervacija> mapaRez;
    private List<Rezervacija> rezervacije;
    private String fontName = "Arial";
    private boolean fastfood;
    private boolean BMaster;

    public PregledStolovi(Shell shellMW, Restoran rest) {
        this.restoran = rest;
        this.server = this.restoran.getServer();
        this.BMaster = this.server.getSetting(Option.B_MASTER).booleanValue();
        this.reloadReservationMap();
        this.aktivGrafik = null;
        this.fastfood = BMTerminalSettings.getSetting(OptionBO.FAST_FOOD).booleanValue();
        this.shell3 = new Shell(shellMW, 32768);
        this.shell3.setLayout((Layout)new GridLayout(2, false));
        Font f = FontCache.getFont(this.fontName, 15, 1);
        this.fontGrafika = FontCache.getFont(this.fontName, 10, 1);
        GridData data = new GridData(768);
        data.heightHint = 60;
        Composite c1 = new Composite((Composite)this.shell3, 0);
        c1.setLayout((Layout)new GridLayout(6, false));
        c1.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 60;
        data.widthHint = 60;
        Composite c12 = new Composite((Composite)this.shell3, 0);
        c12.setLayout((Layout)new GridLayout(2, false));
        c12.setLayoutData((Object)data);
        Composite c123 = new Composite((Composite)this.shell3, 0);
        c123.setLayout((Layout)new GridLayout(2, false));
        c123.setLayoutData((Object)data);
        data = new GridData();
        data.widthHint = 50;
        data.heightHint = 50;
        data.verticalIndent = 5;
        data.horizontalIndent = 5;
        Button x = new Button(c12, 8);
        x.setText("X");
        x.setLayoutData((Object)data);
        x.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledStolovi.this.shell3.close();
            }
        });
        data = new GridData(1808);
        data.horizontalSpan = 2;
        Composite c22 = new Composite((Composite)this.shell3, 0);
        c22.setLayout((Layout)new GridLayout());
        c22.setLayoutData((Object)data);
        this.cGrafika = new Composite(c22, 0);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 2;
        data.verticalAlignment = 2;
        this.cGrafika.setLayoutData((Object)data);
        this.cGrafika.setLayout((Layout)new FillLayout());
        int i = 0;
        for (final GrafikSale gs : this.server.getGrafike()) {
            data = new GridData();
            data.widthHint = 150;
            data.heightHint = 50;
            data.verticalIndent = 5;
            data.horizontalIndent = 10;
            Button bgs = new Button(c1, 8);
            bgs.setLayoutData((Object)data);
            bgs.setText(gs.getNaziv());
            bgs.setFont(f);
            bgs.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    for (Control c : PregledStolovi.this.cGrafika.getChildren()) {
                        c.dispose();
                    }
                    PregledStolovi.this.activeGrafik(gs, PregledStolovi.this.cGrafika, PregledStolovi.this.fontGrafika, PregledStolovi.this.shell3, PregledStolovi.this.mapaRez);
                }
            });
            if (i != 0) continue;
            this.aktivGrafik = gs;
            ++i;
        }
        this.shell3.setMaximized(true);
        this.shell3.open();
        this.activeGrafik(this.aktivGrafik, this.cGrafika, this.fontGrafika, this.shell3, this.mapaRez);
        Timer tg = new Timer();
        tg.scheduleAtFixedRate((TimerTask)new GrafikRunner(), 2000L, 2000L);
        while (!this.shell3.isDisposed()) {
            if (this.shell3.getDisplay().readAndDispatch()) continue;
            this.shell3.getDisplay().sleep();
        }
        tg.cancel();
    }

    private void reloadReservationMap() {
        this.rezervacije = new LinkedList<Rezervacija>();
        this.mapaRez = new HashMap<Integer, Rezervacija>();
        try {
            this.rezervacije = this.server.getRezervacijeUpozorenje();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        for (Rezervacija r : this.rezervacije) {
            this.mapaRez.put(r.getBrStola(), r);
            System.out.println("Rez je " + r);
        }
    }

    private void activeGrafik(GrafikSale gs, Composite c2, Font f2, Shell shell3, Map<Integer, Rezervacija> mapaRez) {
        this.aktivGrafik = gs;
        List<StoPrikaz> stolovi = this.server.getSviStolovi();
        List<Sto> zStolovi = this.server.getStolove();
        for (StoPrikaz sto : stolovi) {
            String naziv = null;
            try {
                naziv = this.server.getNazivStola(sto.getBroj());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (naziv == null) continue;
            this.naziviStolova.put(sto.getBroj(), naziv);
        }
        Setting setting = this.server.getSetting(Option.PRIKAZ_ZADUZENJA_STOLA);
        boolean prikazZaduzenja = setting != null ? setting.booleanValue() : false;
        final Image[] bgImage = new Image[1];
        try {
            bgImage[0] = new Image((Device)shell3.getDisplay(), gs.getSlika());
        }
        catch (Exception e) {
            return;
        }
        GridData data = (GridData)c2.getLayoutData();
        data.widthHint = bgImage[0].getImageData().width;
        data.heightHint = bgImage[0].getImageData().height;
        c2.setLayoutData((Object)data);
        c2.getParent().layout();
        c2.layout();
        c2.setBackgroundImage(bgImage[0]);
        c2.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (bgImage[0] != null && !bgImage[0].isDisposed()) {
                    bgImage[0].dispose();
                }
            }
        });
        for (final StoPrikaz sp : this.server.getStolovePrikaz(gs)) {
            if (this.BMaster) {
                this.brojStola = sp.getBroj();
                List<StoBMaster> zauzetiStolovi = this.server.getBMasterZauzetiStolovi();
                Object stoBm = null;
                for (StoBMaster sto : zauzetiStolovi) {
                    if (this.brojStola.intValue() != sto.getBrojStola()) continue;
                    stoBm = sto;
                }
                String bs = this.naziviStolova.get(this.brojStola);
                if (bs == null) {
                    bs = "" + this.brojStola;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                Rezervacija r = mapaRez.get(this.brojStola);
                String rez = r != null ? sdf.format(r.getVreme().getTime()) + "\r\n Za: " + r.getBrOsoba() + " \r\n" + (r.getIme().length() > 10 ? r.getIme().substring(0, 10) : r.getIme()) + "\n" : "";
                Label label = new Label(c2, 0x1000040);
                if (stoBm != null) {
                    System.out.println("R je " + r);
                    label.setBackground(shell3.getDisplay().getSystemColor(1));
                    if (r != null) {
                        Calendar calTemp = Calendar.getInstance();
                        calTemp.setTime(r.getVreme().getTime());
                        Integer drgUpoz = this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_DRUGO) != null ? this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_DRUGO).intValue() : 0;
                        calTemp.add(12, -drgUpoz.intValue());
                        if (r.getVreme().getTime().getTime() < new Date().getTime()) {
                            label.setForeground(shell3.getDisplay().getSystemColor(9));
                        } else if (calTemp.getTime().getTime() < new Date().getTime()) {
                            label.setForeground(shell3.getDisplay().getSystemColor(11));
                        } else {
                            label.setForeground(shell3.getDisplay().getSystemColor(13));
                        }
                    } else {
                        label.setForeground(shell3.getDisplay().getSystemColor(3));
                    }
                    label.setFont(f2);
                    label.setText(rez + (this.fastfood ? "" : (bs.equals(this.brojStola.toString()) ? String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + " " : "")) + bs + "\n" + ((StoBMaster)stoBm).getSkrImeKonobara() + "\n" + (prikazZaduzenja ? Konstante.getNumber2(this.server.getStoZaduzenjeBMaster(this.brojStola)) : ""));
                } else {
                    label.setBackground(shell3.getDisplay().getSystemColor(1));
                    if (r != null) {
                        label.setForeground(shell3.getDisplay().getSystemColor(2));
                    } else {
                        label.setForeground(shell3.getDisplay().getSystemColor(5));
                    }
                    label.setText(rez + "\n" + (this.fastfood ? "" : (bs.equals(this.brojStola.toString()) ? String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + " " : "")) + " " + bs);
                    label.setFont(f2);
                }
                label.setBounds(sp.getX().intValue(), sp.getY().intValue(), sp.getSirina().intValue(), sp.getVisina().intValue());
                label.addListener(4, new Listener(){

                    public void handleEvent(Event e) {
                        PregledStolovi.this.brojStola = sp.getBroj();
                        PregledStolovi.this.makePregled(PregledStolovi.this.brojStola);
                    }
                });
                continue;
            }
            this.brojStola = sp.getBroj();
            Sto st = null;
            for (Sto sto : zStolovi) {
                if (this.brojStola.intValue() != sto.getBroj().intValue()) continue;
                st = sto;
            }
            String bs = this.naziviStolova.get(this.brojStola);
            if (bs == null) {
                bs = "" + this.brojStola;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            Rezervacija r = mapaRez.get(this.brojStola);
            String rez = r != null ? sdf.format(r.getVreme().getTime()) + "\r\n Za: " + r.getBrOsoba() + " \r\n" + (r.getIme().length() > 10 ? r.getIme().substring(0, 10) : r.getIme()) + "\n" : "";
            Label label = new Label(c2, 0x1000040);
            if (st != null) {
                System.out.println("R je " + r);
                label.setBackground(shell3.getDisplay().getSystemColor(1));
                if (r != null) {
                    Calendar calTemp = Calendar.getInstance();
                    calTemp.setTime(r.getVreme().getTime());
                    Integer drgUpoz = this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_DRUGO) != null ? this.server.getSetting(Option.REZERVACIJA_UPOZORENJE_DRUGO).intValue() : 0;
                    calTemp.add(12, -drgUpoz.intValue());
                    if (r.getVreme().getTime().getTime() < new Date().getTime()) {
                        label.setForeground(shell3.getDisplay().getSystemColor(9));
                    } else if (calTemp.getTime().getTime() < new Date().getTime()) {
                        label.setForeground(shell3.getDisplay().getSystemColor(11));
                    } else {
                        label.setForeground(shell3.getDisplay().getSystemColor(13));
                    }
                } else {
                    label.setForeground(shell3.getDisplay().getSystemColor(3));
                }
                label.setFont(f2);
                label.setText(rez + (this.fastfood ? "" : (bs.equals(this.brojStola.toString()) ? String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + " " : "")) + bs + "\n" + this.getKonobarNameByBrojStola(this.brojStola) + "\n" + (prikazZaduzenja ? Konstante.getNumber2(this.server.getStoZaduzenje(this.brojStola)) : ""));
            } else {
                label.setBackground(shell3.getDisplay().getSystemColor(1));
                if (r != null) {
                    label.setForeground(shell3.getDisplay().getSystemColor(2));
                } else {
                    label.setForeground(shell3.getDisplay().getSystemColor(5));
                }
                label.setText(rez + "\n" + (this.fastfood ? "" : (bs.equals(this.brojStola.toString()) ? String.format(this.barmasterText.getString("TEXT_STO"), new Object[0]) + " " : "")) + " " + bs);
                label.setFont(f2);
            }
            label.setBounds(sp.getX().intValue(), sp.getY().intValue(), sp.getSirina().intValue(), sp.getVisina().intValue());
            label.addListener(4, new Listener(){

                public void handleEvent(Event e) {
                    PregledStolovi.this.brojStola = sp.getBroj();
                    PregledStolovi.this.makePregled(PregledStolovi.this.brojStola);
                }
            });
        }
    }

    public String getKonobarNameByBrojStola(int brojStola) {
        Konobar k = this.server.getKonobarJPA(brojStola);
        return k.getSkrIme();
    }

    public void makePregled(int brojStola) {
        List<Tura> orderList;
        String title = this.server.getNazivStola(brojStola);
        if (title == null || title.length() == 0) {
            title = String.format(this.barmasterText.getString("TEXT_BROJ_SKR"), new Object[0]) + " " + brojStola;
        }
        if ((orderList = this.BMaster ? this.server.getNenaplaceneTureBMaster(brojStola) : this.server.getNenaplaceneTure(brojStola)).size() > 0) {
            TableOrdersDialog tod = new TableOrdersDialog(this.shell3, orderList, title);
            tod.open();
        }
    }

    private class TableTotal {
        private Double total;

        public TableTotal(Double total) {
            this.total = total;
        }

        public Double getTotal() {
            return this.total;
        }

        public void setTotal(Double total) {
            this.total = total;
        }
    }

    private class TableOrdersDialog
    extends Window {
        private List<Tura> orderList;
        private String tableTitle;
        private TableTotal tTotal;

        public TableOrdersDialog(Shell parentShell, List<Tura> orders, String tableTitle) {
            super(parentShell);
            this.orderList = orders;
            System.out.println("order size = " + orders.size());
            this.tableTitle = tableTitle;
            this.setBlockOnOpen(true);
        }

        public TableOrdersDialog(IShellProvider parentShell, List<Tura> orders, String tableTitle) {
            this(parentShell.getShell(), orders, tableTitle);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(String.format(PregledStolovi.this.barmasterText.getString("TEXT_PREGLED_PORUDZBINA_ZA_STO"), new Object[0]) + " " + this.tableTitle);
        }

        protected int getShellStyle() {
            int style = 34912;
            return style;
        }

        protected Point getInitialSize() {
            return new Point(640, 480);
        }

        protected Layout getLayout() {
            return new FillLayout();
        }

        protected Control createContents(Composite parent) {
            Composite cc = new Composite(parent, 0);
            cc.setLayout((Layout)new GridLayout());
            Composite c = new Composite(cc, 0);
            c.setLayoutData((Object)new GridData(4, 4, true, true));
            TableColumnLayout tcl = new TableColumnLayout();
            c.setLayout((Layout)tcl);
            TableViewer tv = new TableViewer(c, 66052);
            tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object o) {
                    List tList = (List)o;
                    LinkedList<Object> resList = new LinkedList<Object>();
                    Double tt = 0.0;
                    for (Tura t : tList) {
                        resList.add(t);
                        resList.add("");
                        Double total = 0.0;
                        for (StavkaRacuna sr : t.getStavkeSumarno()) {
                            resList.add(sr);
                            total = total + sr.getVrednost();
                        }
                        resList.add("");
                        resList.add(total);
                        tt = tt + total;
                    }
                    resList.add("");
                    resList.add(new TableTotal(tt));
                    Object[] oo = new Object[resList.size()];
                    for (int i = 0; i < resList.size(); ++i) {
                        oo[i] = resList.get(i);
                    }
                    return oo;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object o, Object o1) {
                }
            });
            TableViewerColumn tvc1 = new TableViewerColumn(tv, 16384);
            tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Tura) {
                        return String.format(PregledStolovi.this.barmasterText.getString("TEXT_PORUDZBINA"), new Object[0]);
                    }
                    if (element instanceof StavkaRacuna) {
                        return " - " + ((StavkaRacuna)element).getNaziv();
                    }
                    if (element instanceof Double) {
                        return String.format(PregledStolovi.this.barmasterText.getString("TEXT_UKUPNO"), new Object[0]) + ": ";
                    }
                    if (element instanceof TableTotal) {
                        return String.format(PregledStolovi.this.barmasterText.getString("TEXT_UKUPNO_NA_STOLU"), new Object[0]) + ": ";
                    }
                    return "";
                }
            });
            tcl.setColumnData((Widget)tvc1.getColumn(), (ColumnLayoutData)new ColumnWeightData(9, true));
            TableViewerColumn tvc2 = new TableViewerColumn(tv, 131072);
            tvc2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Tura) {
                        return "";
                    }
                    if (element instanceof StavkaRacuna) {
                        return StatLogic.getNumber02(((StavkaRacuna)element).getKolicina());
                    }
                    return "";
                }
            });
            tcl.setColumnData((Widget)tvc2.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, true));
            TableViewerColumn tvc3 = new TableViewerColumn(tv, 131072);
            tvc3.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Tura) {
                        return String.format(PregledStolovi.this.barmasterText.getString("TEXT_BROJ_SKR"), new Object[0]) + " " + ((Tura)element).getBrojTure();
                    }
                    if (element instanceof StavkaRacuna) {
                        return StatLogic.getNumber02(((StavkaRacuna)element).getCena());
                    }
                    if (element instanceof Double) {
                        return StatLogic.getNumber02((Double)element);
                    }
                    if (element instanceof TableTotal) {
                        return StatLogic.getNumber02(((TableTotal)element).getTotal());
                    }
                    return "";
                }
            });
            tcl.setColumnData((Widget)tvc3.getColumn(), (ColumnLayoutData)new ColumnWeightData(3, true));
            Button b = new Button(cc, 8);
            b.setText(String.format(PregledStolovi.this.barmasterText.getString("TEXT_IZLAZ"), new Object[0]));
            b.setFont(FontCache.getFont(PregledStolovi.this.fontName, 16, 0));
            b.setLayoutData((Object)new GridData(4, 4, true, false));
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableOrdersDialog.this.close();
                }
            });
            tv.setInput(this.orderList);
            return parent;
        }
    }

    private class GrafikRunner
    extends TimerTask {
        private GrafikRunner() {
        }

        @Override
        public void run() {
            PregledStolovi.this.reloadReservationMap();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    for (Control c : PregledStolovi.this.cGrafika.getChildren()) {
                        c.dispose();
                    }
                    PregledStolovi.this.activeGrafik(PregledStolovi.this.aktivGrafik, PregledStolovi.this.cGrafika, PregledStolovi.this.fontGrafika, PregledStolovi.this.shell3, PregledStolovi.this.mapaRez);
                }
            };
            PregledStolovi.this.shell3.getDisplay().asyncExec(r);
        }
    }
}

