/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.prodajnamesta;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.GrupaOdeljenja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTMessage;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpravljanjeProdajnimMestom
extends Window {
    private ProdajnoMesto input;
    private List<GrupaOdeljenja> grupe;
    private RestoranServer server;

    public UpravljanjeProdajnimMestom(Shell parentShell) {
        super(parentShell);
    }

    public UpravljanjeProdajnimMestom(IShellProvider shellProvider) {
        super(shellProvider);
    }

    protected Control createContents(Composite parent) {
        Composite cAll = new Composite(parent, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout());
        ScrolledComposite sc = new ScrolledComposite(cAll, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite cData = new Composite((Composite)sc, 0);
        cData.setLayout((Layout)new GridLayout(2, false));
        Label lNaziv = new Label(cData, 131136);
        lNaziv.setText(String.format(Konstante.getBundle().getString("TEXT_NAZIV"), new Object[0]));
        final TextInput2 naziv = new TextInput2(cData, "Naziv", false);
        Label lOznaka = new Label(cData, 131136);
        lOznaka.setText(String.format(Konstante.getBundle().getString("TEXT_OZNAKA"), new Object[0]));
        final TextInput2 oznaka = new TextInput2(cData, "Oznaka", false);
        Label lOpis = new Label(cData, 131136);
        lOpis.setText(String.format(Konstante.getBundle().getString("TEXT_OPIS"), new Object[0]));
        final Text opis = new Text(cData, 2626);
        Group cDepartments = new Group(cData, 0);
        cDepartments.setText("Odeljenja");
        cDepartments.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        cDepartments.setLayout((Layout)new GridLayout());
        Comparator<GrupaOdeljenja> cGO = new Comparator<GrupaOdeljenja>(){

            @Override
            public int compare(GrupaOdeljenja o1, GrupaOdeljenja o2) {
                return o1.getNaziv().compareTo(o2.getNaziv());
            }
        };
        LinkedList<GrupaOdeljenja> listaGrupa = new LinkedList<GrupaOdeljenja>(this.grupe);
        Collections.sort(listaGrupa, cGO);
        final HashMap depControlMap = new HashMap();
        for (GrupaOdeljenja grupaOdeljenja : listaGrupa) {
            List<Odeljenje> list = grupaOdeljenja.getOdeljenja();
            if (list == null || list.isEmpty() || grupaOdeljenja.getSkladista().booleanValue()) continue;
            Group g = new Group((Composite)cDepartments, 0);
            g.setLayoutData((Object)new GridData(4, 4, true, true));
            g.setLayout((Layout)new GridLayout(list.size() + 1, true));
            g.setText(grupaOdeljenja.getNaziv());
            g.setData((Object)grupaOdeljenja);
            LinkedList<Button> buttList = new LinkedList<Button>();
            Button bNone = new Button((Composite)g, 80);
            bNone.setData(null);
            bNone.setText(String.format(Konstante.getBundle().getString("TEXT_NIJEDNO"), new Object[0]));
            bNone.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
            buttList.add(bNone);
            for (Odeljenje odeljenje : list) {
                Button b = new Button((Composite)g, 80);
                b.setData((Object)odeljenje);
                b.setText(odeljenje.getNaziv());
                b.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
                buttList.add(b);
            }
            depControlMap.put(g, buttList);
        }
        GridData gdl = new GridData(0x1000000, 0x1000000, false, false);
        gdl.widthHint = 80;
        lNaziv.setLayoutData((Object)gdl);
        lOznaka.setLayoutData((Object)gdl);
        lOpis.setLayoutData((Object)gdl);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 200;
        naziv.getControl().setLayoutData((Object)gd);
        oznaka.getControl().setLayoutData((Object)gd);
        GridData gdo = new GridData(4, 4, true, false);
        gdo.minimumWidth = gd.minimumWidth;
        gdo.heightHint = 60;
        opis.setLayoutData((Object)gdo);
        sc.setContent((Control)cData);
        sc.setMinSize(cData.computeSize(-1, -1));
        Composite control = new Composite(cAll, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        control.setLayout((Layout)new GridLayout(2, true));
        Button okButt = Dugmici.getOkButton(control);
        ((GridData)okButt.getLayoutData()).grabExcessHorizontalSpace = true;
        okButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (UpravljanjeProdajnimMestom.this.input == null) {
                        UpravljanjeProdajnimMestom.this.input = new ProdajnoMesto();
                    }
                    UpravljanjeProdajnimMestom.this.input.setNaziv(naziv.getResult());
                    UpravljanjeProdajnimMestom.this.input.setOznaka(oznaka.getResult());
                    UpravljanjeProdajnimMestom.this.input.setOpis(opis.getText());
                    LinkedList<Odeljenje> list = new LinkedList<Odeljenje>();
                    for (Map.Entry entry : depControlMap.entrySet()) {
                        List buttons = (List)entry.getValue();
                        for (Button button : buttons) {
                            if (!button.getSelection() || button.getData() == null) continue;
                            list.add((Odeljenje)button.getData());
                        }
                    }
                    UpravljanjeProdajnimMestom.this.input.setOdeljenja(list);
                    UpravljanjeProdajnimMestom.this.input = UpravljanjeProdajnimMestom.this.server.createOrUpdateProdajnoMesto(UpravljanjeProdajnimMestom.this.input);
                    UpravljanjeProdajnimMestom.this.setReturnCode(0);
                    UpravljanjeProdajnimMestom.this.getShell().dispose();
                }
                catch (Exception ex) {
                    UpravljanjeProdajnimMestom.this.setReturnCode(1);
                    Logger.getLogger(UpravljanjeProdajnimMestom.class.getName()).log(Level.WARNING, ex.getMessage(), ex);
                    SWTMessage.showLocalizedWarningDialog(UpravljanjeProdajnimMestom.this.getShell(), ex.getMessage().length() > 0 ? ex.getMessage() : String.format(Konstante.getBundle().getString("TEXT_GRESKA"), new Object[0]));
                }
            }
        });
        Button cancelButt = Dugmici.getCancelButton(control);
        ((GridData)cancelButt.getLayoutData()).grabExcessHorizontalSpace = true;
        cancelButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpravljanjeProdajnimMestom.this.close();
            }
        });
        if (this.input != null) {
            naziv.setResult(this.input.getNaziv());
            oznaka.setResult(this.input.getOznaka());
            opis.setText(this.input.getOpis());
            for (Map.Entry entry : depControlMap.entrySet()) {
                List list = (List)entry.getValue();
                boolean exists = false;
                for (Button button : list) {
                    if (!this.input.getOdeljenja().contains(button.getData())) continue;
                    exists = true;
                    button.setSelection(true);
                }
                if (exists) continue;
                ((Button)list.get(0)).setSelection(true);
            }
        }
        return cAll;
    }

    public boolean close() {
        this.setReturnCode(1);
        this.input = null;
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format(Konstante.getBundle().getString("TEXT_UPRAVLJANJE_PRODAJNIM_MESTOM"), new Object[0]));
    }

    public void setInput(ProdajnoMesto input) {
        this.input = input;
    }

    public void setGrupe(List<GrupaOdeljenja> grupe) {
        this.grupe = grupe;
    }

    public ProdajnoMesto getInput() {
        return this.input;
    }

    public static void main(String[] args) {
        LinkedList<GrupaOdeljenja> grupe = new LinkedList<GrupaOdeljenja>();
        for (int i = 0; i < 3; ++i) {
            GrupaOdeljenja go = new GrupaOdeljenja();
            go.setNaziv("Grupa " + (i + 1));
            go.setOdeljenja(new LinkedList<Odeljenje>());
            for (int j = 0; j < i + 1; ++j) {
                Odeljenje od = new Odeljenje();
                od.setNaziv("Odeljenje " + (i * 3 + j + 1));
                go.getOdeljenja().add(od);
            }
            grupe.add(go);
        }
        ProdajnoMesto pm = new ProdajnoMesto();
        pm.setNaziv("Proba");
        pm.setOznaka("PRB");
        pm.setOpis("Ovo je probni materijal\nOvaj materijal nema nikakvu upotrebnu svrhu");
        LinkedList<Odeljenje> odeljenja = new LinkedList<Odeljenje>();
        odeljenja.add(((GrupaOdeljenja)grupe.get(0)).getOdeljenja().get(0));
        odeljenja.add(((GrupaOdeljenja)grupe.get(1)).getOdeljenja().get(1));
        odeljenja.add(((GrupaOdeljenja)grupe.get(2)).getOdeljenja().get(2));
        pm.setOdeljenja(odeljenja);
        UpravljanjeProdajnimMestom upm = new UpravljanjeProdajnimMestom((Shell)null);
        upm.setGrupe(grupe);
        upm.setInput(pm);
        upm.setBlockOnOpen(true);
        upm.open();
    }

    public void setServer(RestoranServer server) {
        this.server = server;
    }
}

