/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.prodajnamesta;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.backoffice.prodajnamesta.UpravljanjeProdajnimMestom;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.parts.TextInput2;
import com.dev63.restoran.swt.components.SWTMessage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpravljanjeKasom
extends Window {
    private Kasa input;
    private RestoranServer server;
    private boolean hostNameDisabled;

    public UpravljanjeKasom(Shell parentShell) {
        super(parentShell);
    }

    public UpravljanjeKasom(IShellProvider shellProvider) {
        super(shellProvider);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format(Konstante.getBundle().getString("TEXT_UPRAVLJANJE_KASOM"), new Object[0]));
    }

    protected Control createContents(Composite parent) {
        Composite cAll = new Composite(parent, 0);
        cAll.setLayout((Layout)new GridLayout(3, false));
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lProdajnoMesto = new Label(cAll, 131072);
        lProdajnoMesto.setText(String.format(Konstante.getBundle().getString("TEXT_PRODAJNO_MESTO"), new Object[0]));
        final ComboViewer prodajnoMesto = new ComboViewer(cAll, 8);
        prodajnoMesto.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ProdajnoMesto) {
                    ProdajnoMesto pm = (ProdajnoMesto)element;
                    return pm.getNaziv();
                }
                return "";
            }
        });
        prodajnoMesto.setContentProvider((IContentProvider)new ArrayContentProvider());
        prodajnoMesto.getCombo().setLayoutData((Object)new GridData(4, 4, true, true));
        List<ProdajnoMesto> list = this.getProdajnaMesta(0);
        prodajnoMesto.setInput(list);
        prodajnoMesto.setSelection((ISelection)new StructuredSelection((Object)list.get(0)));
        prodajnoMesto.setComparator(new ViewerComparator());
        Button bNew = Dugmici.getPlusButton(cAll);
        ((GridData)bNew.getLayoutData()).widthHint = 27;
        ((GridData)bNew.getLayoutData()).heightHint = 27;
        bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpravljanjeKasom.this.novoProdajnoMesto();
            }
        });
        Label lHostName = new Label(cAll, 131072);
        lHostName.setText(String.format(Konstante.getBundle().getString("TEXT_HOSTNAME"), new Object[0]));
        final TextInput2 hostName = new TextInput2(cAll, String.format(Konstante.getBundle().getString("TEXT_HOSTNAME"), new Object[0]), false);
        hostName.getControl().setEnabled(!this.hostNameDisabled);
        Label lOznaka = new Label(cAll, 131072);
        lOznaka.setText(String.format(Konstante.getBundle().getString("TEXT_OZNAKA_KASE"), new Object[0]));
        final TextInput2 oznaka = new TextInput2(cAll, String.format(Konstante.getBundle().getString("TEXT_OZNAKA_KASE"), new Object[0]), false);
        Label lOpis = new Label(cAll, 131072);
        lOpis.setText(String.format(Konstante.getBundle().getString("TEXT_OPIS_KASE"), new Object[0]));
        final Text opis = new Text(cAll, 2882);
        GridData gdl = new GridData(4, 0x1000000, false, false);
        gdl.widthHint = 80;
        lHostName.setLayoutData((Object)gdl);
        lProdajnoMesto.setLayoutData((Object)gdl);
        lOznaka.setLayoutData((Object)gdl);
        lOpis.setLayoutData((Object)gdl);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 200;
        prodajnoMesto.getCombo().setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false, 2, 1);
        gd.minimumWidth = 200;
        hostName.getControl().setLayoutData((Object)gd);
        oznaka.getControl().setLayoutData((Object)gd);
        oznaka.getControl().forceFocus();
        gd = new GridData(4, 4, true, true, 2, 1);
        gd.minimumHeight = 80;
        gd.minimumWidth = 200;
        opis.setLayoutData((Object)gd);
        if (this.input != null) {
            if (this.input.getProdajnoMesto() != null && prodajnoMesto.getCombo().getItemCount() > 0) {
                prodajnoMesto.setSelection((ISelection)new StructuredSelection((Object)this.input.getProdajnoMesto()));
            }
            if (this.input.getHostname() != null) {
                hostName.setResult(this.input.getHostname());
            }
            if (this.input.getOznaka() != null) {
                oznaka.setResult(this.input.getOznaka());
            }
            if (this.input.getOpis() != null) {
                opis.setText(this.input.getOpis());
            }
        }
        oznaka.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    String hn = null;
                    String oz = null;
                    String op = "";
                    ProdajnoMesto pm = null;
                    try {
                        hn = hostName.getResult();
                        oz = oznaka.getResult();
                        op = opis.getText();
                        pm = (ProdajnoMesto)((IStructuredSelection)prodajnoMesto.getSelection()).getFirstElement();
                        if (pm == null) {
                            throw new Exception(String.format(Konstante.getBundle().getString("PORUKA_PRODAJNO_MESTO_NE_MOZE_BITI_NEDEFINISANO"), new Object[0]));
                        }
                        if (UpravljanjeKasom.this.input == null) {
                            UpravljanjeKasom.this.input = new Kasa();
                        }
                        UpravljanjeKasom.this.input.setHostname(hn);
                        UpravljanjeKasom.this.input.setOpis(op);
                        UpravljanjeKasom.this.input.setOznaka(oz);
                        UpravljanjeKasom.this.input.setProdajnoMesto(pm);
                        UpravljanjeKasom.this.input = UpravljanjeKasom.this.server.createOrUpdateKasa(UpravljanjeKasom.this.input);
                        for (Odeljenje odeljenje : UpravljanjeKasom.this.server.getOdeljenjaBezMagacina()) {
                            UpravljanjeKasom.this.server.insertIntoKasa_Odeljenje(UpravljanjeKasom.this.input, odeljenje);
                        }
                        UpravljanjeKasom.this.getShell().dispose();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(UpravljanjeKasom.class.getName()).log(Level.SEVERE, null, ex);
                        SWTMessage.showLocalizedWarningDialog(UpravljanjeKasom.this.getShell(), ex.getMessage());
                    }
                }
            }
        });
        Composite control = new Composite(cAll, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        control.setLayout((Layout)new GridLayout(2, true));
        Button bOk = Dugmici.getOkButton(control);
        ((GridData)bOk.getLayoutData()).grabExcessHorizontalSpace = true;
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String hn = null;
                String oz = null;
                String op = "";
                ProdajnoMesto pm = null;
                try {
                    hn = hostName.getResult();
                    oz = oznaka.getResult();
                    op = opis.getText();
                    pm = (ProdajnoMesto)((IStructuredSelection)prodajnoMesto.getSelection()).getFirstElement();
                    if (pm == null) {
                        throw new Exception(String.format(Konstante.getBundle().getString("PORUKA_PRODAJNO_MESTO_NE_MOZE_BITI_NEDEFINISANO"), new Object[0]));
                    }
                    if (UpravljanjeKasom.this.input == null) {
                        UpravljanjeKasom.this.input = new Kasa();
                    }
                    UpravljanjeKasom.this.input.setHostname(hn);
                    UpravljanjeKasom.this.input.setOpis(op);
                    UpravljanjeKasom.this.input.setOznaka(oz);
                    UpravljanjeKasom.this.input.setProdajnoMesto(pm);
                    UpravljanjeKasom.this.input = UpravljanjeKasom.this.server.createOrUpdateKasa(UpravljanjeKasom.this.input);
                    if (!UpravljanjeKasom.this.server.isKasaOdeljenjeEmpty()) {
                        for (Odeljenje odeljenje : UpravljanjeKasom.this.server.getOdeljenjaBezMagacina()) {
                            UpravljanjeKasom.this.server.insertIntoKasa_Odeljenje(UpravljanjeKasom.this.input, odeljenje);
                        }
                    }
                    UpravljanjeKasom.this.getShell().dispose();
                }
                catch (Exception ex) {
                    Logger.getLogger(UpravljanjeKasom.class.getName()).log(Level.SEVERE, null, ex);
                    SWTMessage.showLocalizedWarningDialog(UpravljanjeKasom.this.getShell(), ex.getMessage());
                }
            }
        });
        Button bCancel = Dugmici.getCancelButton(control);
        ((GridData)bCancel.getLayoutData()).grabExcessHorizontalSpace = true;
        bCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpravljanjeKasom.this.setReturnCode(1);
                UpravljanjeKasom.this.close();
            }
        });
        return cAll;
    }

    private List<ProdajnoMesto> getProdajnaMesta(int count) {
        List<ProdajnoMesto> list;
        if (++count == 4) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).info("Odustato od unosa inicijalnog prodajnog mesta");
            this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
            this.server.fine("Izlazak iz programa sa Login prozora", ((Object)((Object)this)).getClass());
            System.exit(0);
        }
        if ((list = this.server.findAllProdajnoMesto()).isEmpty()) {
            SWTMessage.showLocalizedInfoDialog(this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_NIJE_PRONADJENO_NIJEDNO_PRODAJNO_MESTO_MORATE_UNETI_NOVO"), new Object[0]));
            this.novoProdajnoMesto(true, 0);
            return this.getProdajnaMesta(count);
        }
        return list;
    }

    private void novoProdajnoMesto() {
        this.novoProdajnoMesto(false, 0);
    }

    private void novoProdajnoMesto(boolean obligatory, int cancelCount) {
        UpravljanjeProdajnimMestom upm = new UpravljanjeProdajnimMestom(this.getShell());
        upm.setBlockOnOpen(true);
        upm.setGrupe(this.server.findAllGrupeOdeljenja());
        upm.setServer(this.server);
        if (upm.open() == 0) {
            return;
        }
        if (obligatory) {
            if (cancelCount < 3) {
                SWTMessage.showLocalizedWarningDialog(this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_MORATE_UNETI_NOVO_PRODAJNO_MESTO"), new Object[0]));
                this.novoProdajnoMesto(obligatory, ++cancelCount);
            } else {
                this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                this.server.fine("Izlazak iz programa sa Login prozora", ((Object)((Object)this)).getClass());
                this.getShell().getDisplay().dispose();
                System.exit(0);
            }
        }
    }

    public boolean close() {
        this.input = null;
        return super.close();
    }

    public Kasa getInput() {
        return this.input;
    }

    public void setInput(Kasa input) {
        this.input = input;
    }

    public void setHostNameDisabled(boolean hostNameDisabled) {
        this.hostNameDisabled = hostNameDisabled;
    }

    public void setServer(RestoranServer server) {
        this.server = server;
    }
}

