/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.parts;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class IzborStalnihGostiju
extends Window {
    private Font treeFont;
    private List<StalniGost> guests = new LinkedList<StalniGost>();
    private List<StalniGost> preSelectedGuests = new LinkedList<StalniGost>();
    private List<StalniGostiGrupa> groupsToChooseFrom = new LinkedList<StalniGostiGrupa>();
    private List<Object> input = new LinkedList<Object>();
    private boolean showBlocked = false;

    public IzborStalnihGostiju(Shell parentShell) {
        super(parentShell);
        this.init();
    }

    public IzborStalnihGostiju(IShellProvider shellProvider) {
        super(shellProvider);
        this.init();
    }

    private void init() {
        this.setBlockOnOpen(true);
        this.setShellStyle(34032);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.format(Konstante.getBundle().getString("TEXT_IZBOR_STALNIH_GOSTIJU"), new Object[0]));
        newShell.setMaximized(true);
    }

    protected Control createContents(Composite parent) {
        Composite cAll = new Composite(parent, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout(3, false));
        final CheckboxTreeViewer tv = new CheckboxTreeViewer(cAll, 2850);
        tv.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeFont = new Font((Device)this.getShell().getDisplay(), "Arial", 18, 0);
        tv.getTree().setFont(this.treeFont);
        tv.setContentProvider((IContentProvider)new SGGTreeContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(){

            public void update(ViewerCell vc) {
                Object element = vc.getElement();
                if (element instanceof StalniGostiGrupa) {
                    StalniGostiGrupa sgg = (StalniGostiGrupa)element;
                    vc.setText(sgg.getNaziv());
                } else if (element instanceof StalniGost) {
                    StalniGost sg = (StalniGost)element;
                    vc.setText(sg.getNaziv());
                }
            }
        });
        tv.setInput(this.input);
        tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    tv.setSubtreeChecked(event.getElement(), true);
                    tv.expandToLevel(event.getElement(), 2);
                } else {
                    tv.setSubtreeChecked(event.getElement(), false);
                }
            }
        });
        Composite cInfo = new Composite(cAll, 2048);
        cInfo.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)cInfo.getLayoutData()).horizontalIndent = 20;
        cInfo.setLayout((Layout)new GridLayout());
        Label lInfo = new Label(cInfo, 0x1000000);
        lInfo.setText(String.format(Konstante.getBundle().getString("TEXT_IZABRANI_STALNI_GOSTI"), new Object[0]) + ":");
        lInfo.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        final ScrolledComposite info = new ScrolledComposite(cInfo, 768);
        info.setExpandHorizontal(true);
        info.setExpandVertical(true);
        info.setLayoutData((Object)new GridData(4, 4, true, true));
        info.setBackgroundMode(2);
        final LinkedList tempList = new LinkedList();
        final ListViewer lv = new ListViewer((Composite)info, 4);
        lv.getList().setEnabled(false);
        lv.getList().setBackground(info.getBackground());
        lv.getList().setFont(this.treeFont);
        info.setContent((Control)lv.getList());
        info.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                info.setMinSize(info.computeSize(-1, -1));
            }

            public void controlResized(ControlEvent e) {
                info.setMinSize(lv.getList().computeSize(-1, -1));
            }
        });
        lv.setContentProvider((IContentProvider)new ArrayContentProvider());
        ViewerSorter vs = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ListViewer src = (ListViewer)viewer;
                LabelProvider lp = (LabelProvider)src.getLabelProvider();
                return lp.getText(e1).compareToIgnoreCase(lp.getText(e2));
            }
        };
        lv.setSorter(vs);
        lv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                StalniGost sg;
                String ret = "";
                if (element instanceof StalniGost && ((ret = (sg = (StalniGost)element).getSkrNaziv()) == null || ret.length() == 0 || ret.equalsIgnoreCase("null"))) {
                    ret = sg.getNaziv();
                }
                return ret;
            }
        });
        lv.setInput(tempList);
        for (StalniGost stalniGost : tempList) {
        }
        tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                tv.refresh();
                if (event.getChecked()) {
                    tv.expandToLevel(event.getElement(), 2);
                    tv.setSubtreeChecked(event.getElement(), true);
                } else {
                    tv.setSubtreeChecked(event.getElement(), false);
                }
                tempList.clear();
                Object[] items = tv.getCheckedElements();
                List<Object> iSel = Arrays.asList(items);
                if (!iSel.isEmpty()) {
                    for (Object object : iSel) {
                        if (!(object instanceof StalniGost)) continue;
                        StalniGost sg = (StalniGost)object;
                        System.out.println(sg.getNaziv());
                        tempList.add(sg);
                    }
                }
                lv.refresh();
                lv.getList().pack();
                info.setMinSize(info.computeSize(-1, -1));
            }
        });
        Composite control = new Composite(cAll, 0);
        control.setLayoutData((Object)new GridData(4, 4, false, true));
        control.setLayout((Layout)new GridLayout());
        Button bOk = Dugmici.getOkButton(control);
        bOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items = tv.getCheckedElements();
                List<Object> iSel = Arrays.asList(items);
                if (!iSel.isEmpty()) {
                    for (Object object : iSel) {
                        if (!(object instanceof StalniGost)) continue;
                        StalniGost sg = (StalniGost)object;
                        System.out.println(sg.getNaziv());
                        IzborStalnihGostiju.this.getGuests().add(sg);
                    }
                }
                IzborStalnihGostiju.this.close();
            }
        });
        Button bCanc = Dugmici.getCancelButton(control);
        bCanc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IzborStalnihGostiju.this.setGuests(new LinkedList<StalniGost>());
                IzborStalnihGostiju.this.close();
            }
        });
        return cAll;
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    public boolean close() {
        if (this.treeFont != null && !this.treeFont.isDisposed()) {
            this.treeFont.dispose();
        }
        return super.close();
    }

    public List<StalniGost> getStalniGosti() {
        return this.guests;
    }

    public void setInput(List<Object> input) {
        if (input == null) {
            input = new LinkedList<Object>();
        }
        this.input = input;
    }

    public List<StalniGost> getGuests() {
        return this.guests;
    }

    public void setGuests(List<StalniGost> guests) {
        this.guests = guests;
    }

    public Font getTreeFont() {
        return this.treeFont;
    }

    public void setTreeFont(Font treeFont) {
        this.treeFont = treeFont;
    }

    public List<StalniGostiGrupa> getGroupsToChooseFrom() {
        return this.groupsToChooseFrom;
    }

    public void setGroupsToChooseFrom(List<StalniGostiGrupa> groupsToChooseFrom) {
        this.groupsToChooseFrom = groupsToChooseFrom;
    }

    public boolean isShowBlocked() {
        return this.showBlocked;
    }

    public void setShowBlocked(boolean showBlocked) {
        this.showBlocked = showBlocked;
    }

    public void setPreSelectedGuests(List<StalniGost> preSelectedGuests) {
        this.preSelectedGuests = preSelectedGuests;
    }

    public static void main(String[] args) {
        IzborStalnihGostiju isg = new IzborStalnihGostiju((Shell)null);
        LinkedList<Object> in = new LinkedList<Object>();
        int i = 1;
        int g = 1;
        StalniGostiGrupa sgg = new StalniGostiGrupa();
        sgg.setNaziv("Grupa " + g++);
        sgg.setPreduzece(true);
        sgg.setStalniGosti(new LinkedList<StalniGost>());
        in.add(sgg);
        StalniGost sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sgg = new StalniGostiGrupa();
        sgg.setNaziv("Grupa " + g++);
        sgg.setPreduzece(true);
        sgg.setStalniGosti(new LinkedList<StalniGost>());
        in.add(sgg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setGrupa(sgg);
        sgg.getStalniGosti().add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setDobavljac(Boolean.TRUE);
        in.add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        sg.setDobavljac(Boolean.TRUE);
        in.add(sg);
        sg = new StalniGost();
        sg.setNaziv("Gost " + i++);
        in.add(sg);
        isg.setInput(in);
        isg.create();
        isg.getShell().setMaximized(true);
        isg.open();
    }

    private class SGGTreeContentProvider
    implements ITreeContentProvider {
        private StalniGostiGrupa dobavljaci = new StalniGostiGrupa();
        private StalniGostiGrupa ostali;

        public SGGTreeContentProvider() {
            this.dobavljaci.setPreduzece(true);
            this.dobavljaci.setNaziv(String.format(Konstante.getBundle().getString("TEXT_DOBAVLJACI"), new Object[0]));
            this.dobavljaci.setStalniGosti(new LinkedList<StalniGost>());
            this.ostali = new StalniGostiGrupa();
            this.ostali.setPreduzece(false);
            this.ostali.setNaziv(String.format(Konstante.getBundle().getString("TEXT_OSTALI"), new Object[0]));
            this.ostali.setStalniGosti(new LinkedList<StalniGost>());
        }

        public Object[] getElements(Object o) {
            LinkedList<StalniGostiGrupa> retList = new LinkedList<StalniGostiGrupa>();
            if (o instanceof Collection) {
                Collection coll = (Collection)o;
                if (!coll.isEmpty()) {
                    for (Object object : coll) {
                        if (object instanceof StalniGostiGrupa) {
                            StalniGostiGrupa sgg = (StalniGostiGrupa)object;
                            if (sgg.getStalniGosti().isEmpty() || retList.contains(sgg)) continue;
                            retList.add(sgg);
                            continue;
                        }
                        if (!(object instanceof StalniGost)) continue;
                        StalniGost stalniGost = (StalniGost)object;
                        if (stalniGost.getGrupa() != null) {
                            if (retList.contains(stalniGost.getGrupa())) continue;
                            retList.add(stalniGost.getGrupa());
                            continue;
                        }
                        if (stalniGost.getDobavljac() != null && stalniGost.getDobavljac().booleanValue()) {
                            if (this.dobavljaci.getStalniGosti().contains(stalniGost)) continue;
                            this.dobavljaci.getStalniGosti().add(stalniGost);
                            continue;
                        }
                        if (this.ostali.getStalniGosti().contains(stalniGost)) continue;
                        this.ostali.getStalniGosti().add(stalniGost);
                    }
                }
                if (!this.dobavljaci.getStalniGosti().isEmpty()) {
                    retList.add(this.dobavljaci);
                }
                if (!this.ostali.getStalniGosti().isEmpty()) {
                    retList.add(this.ostali);
                }
            }
            return retList.toArray();
        }

        public Object[] getChildren(Object o) {
            StalniGostiGrupa stalniGostiGrupa;
            LinkedList<StalniGost> list = new LinkedList<StalniGost>();
            if (o instanceof StalniGostiGrupa && (stalniGostiGrupa = (StalniGostiGrupa)o).getStalniGosti() != null) {
                list.addAll(stalniGostiGrupa.getStalniGosti());
            }
            return list.toArray();
        }

        public Object getParent(Object o) {
            StalniGostiGrupa parent = null;
            if (o instanceof StalniGost) {
                StalniGost stalniGost = (StalniGost)o;
                parent = stalniGost.getGrupa();
                if (parent == null && stalniGost.getDobavljac().booleanValue() && this.dobavljaci.getStalniGosti().contains(stalniGost)) {
                    parent = this.dobavljaci;
                } else if (parent == null && this.ostali.getStalniGosti().contains(stalniGost)) {
                    parent = this.ostali;
                }
            }
            return parent;
        }

        public boolean hasChildren(Object o) {
            StalniGostiGrupa stalniGostiGrupa;
            boolean ret = false;
            if (o instanceof StalniGostiGrupa && (stalniGostiGrupa = (StalniGostiGrupa)o).getStalniGosti() != null && !stalniGostiGrupa.getStalniGosti().isEmpty()) {
                ret = true;
            }
            return ret;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object o, Object o1) {
        }
    }
}

