/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.odeljenja;

import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.backoffice.odeljenja.UpravljanjeGrupomOdeljenja;
import com.dev63.restoran.model.GrupaOdeljenja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.swt.components.SWTMessage;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OdabirGrupeOdeljenjaZaOdeljenje
extends Window {
    private Odeljenje input;
    private List<GrupaOdeljenja> grupe;
    private RestoranServer server;
    private boolean primaryModal = false;

    public OdabirGrupeOdeljenjaZaOdeljenje(Shell parentShell) {
        super(parentShell);
    }

    public OdabirGrupeOdeljenjaZaOdeljenje(IShellProvider shellProvider) {
        super(shellProvider);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | (this.primaryModal ? 32768 : 0);
    }

    protected Control createContents(Composite parent) {
        Composite cAll = new Composite(parent, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout());
        Composite cData = new Composite(cAll, 0);
        cData.setLayoutData((Object)new GridData(4, 4, true, true));
        cData.setLayout((Layout)new GridLayout(2, false));
        Label lOdeljenje = new Label(cData, 131136);
        lOdeljenje.setText(String.format(Konstante.getBundle().getString("TEXT_ODELJENJE"), new Object[0]));
        Combo odeljenje = new Combo(cData, 12);
        odeljenje.add(this.input.getNaziv());
        odeljenje.select(0);
        Label lGrupa = new Label(cData, 131136);
        lGrupa.setText(String.format(Konstante.getBundle().getString("TEXT_GRUPA"), new Object[0]));
        final ComboViewer cvGrupa = new ComboViewer(cData, 12);
        cvGrupa.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String text = "";
                if (element instanceof GrupaOdeljenja) {
                    GrupaOdeljenja go = (GrupaOdeljenja)element;
                    text = go.getNaziv();
                }
                return text;
            }
        });
        cvGrupa.setContentProvider((IContentProvider)new ArrayContentProvider());
        Label lSpc = new Label(cData, 131136);
        Button bNovaGrupa = Dugmici.getPlusButton(cData);
        bNovaGrupa.setText(String.format(Konstante.getBundle().getString("TEXT_NOVA_GRUPA"), new Object[0]));
        bNovaGrupa.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpravljanjeGrupomOdeljenja ugo = new UpravljanjeGrupomOdeljenja(OdabirGrupeOdeljenjaZaOdeljenje.this.getShell());
                ugo.setBlockOnOpen(true);
                ugo.setServer(OdabirGrupeOdeljenjaZaOdeljenje.this.server);
                if (ugo.open() == 0) {
                    OdabirGrupeOdeljenjaZaOdeljenje.this.grupe = OdabirGrupeOdeljenjaZaOdeljenje.this.server.findAllGrupeOdeljenja();
                    cvGrupa.setInput((Object)OdabirGrupeOdeljenjaZaOdeljenje.this.grupe);
                    cvGrupa.refresh();
                }
            }
        });
        GridData lgd = new GridData(4, 0x1000000, false, false);
        lgd.widthHint = 80;
        lOdeljenje.setLayoutData((Object)lgd);
        lGrupa.setLayoutData((Object)lgd);
        lSpc.setLayoutData((Object)lgd);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 200;
        gd.minimumHeight = 20;
        odeljenje.setLayoutData((Object)gd);
        cvGrupa.getCombo().setLayoutData((Object)gd);
        ((GridData)bNovaGrupa.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)bNovaGrupa.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)bNovaGrupa.getLayoutData()).horizontalAlignment = 0x1000000;
        ((GridData)bNovaGrupa.getLayoutData()).verticalAlignment = 0x1000000;
        Composite control = new Composite(cAll, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        control.setLayout((Layout)new GridLayout(2, true));
        Button okButt = Dugmici.getOkButton(control);
        ((GridData)okButt.getLayoutData()).grabExcessHorizontalSpace = true;
        okButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection iSel = (IStructuredSelection)cvGrupa.getSelection();
                    if (iSel.getFirstElement() == null || !(iSel.getFirstElement() instanceof GrupaOdeljenja)) {
                        throw new Exception(String.format(Konstante.getBundle().getString("PORUKA_MORATE_IZABRATI_GRUPU_ODELJENJA_ZA_DATO_ODELJENJE"), new Object[0]));
                    }
                    GrupaOdeljenja go = (GrupaOdeljenja)iSel.getFirstElement();
                    OdabirGrupeOdeljenjaZaOdeljenje.this.input.setGrupaOdeljenja(go);
                    OdabirGrupeOdeljenjaZaOdeljenje.this.input = OdabirGrupeOdeljenjaZaOdeljenje.this.server.createOrUpdateOdeljenje(OdabirGrupeOdeljenjaZaOdeljenje.this.input);
                    OdabirGrupeOdeljenjaZaOdeljenje.this.setReturnCode(0);
                    OdabirGrupeOdeljenjaZaOdeljenje.this.getShell().dispose();
                }
                catch (Exception ex) {
                    Logger.getLogger(OdabirGrupeOdeljenjaZaOdeljenje.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    SWTMessage.showLocalizedMessageDialog(OdabirGrupeOdeljenjaZaOdeljenje.this.getShell(), ex.getMessage());
                    OdabirGrupeOdeljenjaZaOdeljenje.this.setReturnCode(1);
                }
            }
        });
        Button cancelButt = Dugmici.getCancelButton(control);
        ((GridData)cancelButt.getLayoutData()).grabExcessHorizontalSpace = true;
        cancelButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OdabirGrupeOdeljenjaZaOdeljenje.this.setReturnCode(1);
                OdabirGrupeOdeljenjaZaOdeljenje.this.close();
            }
        });
        cvGrupa.setInput(this.grupe);
        cvGrupa.refresh();
        return cAll;
    }

    public Odeljenje getInput() {
        return this.input;
    }

    public void setInput(Odeljenje input) {
        this.input = input;
    }

    public void setGrupe(List<GrupaOdeljenja> grupe) {
        this.grupe = grupe;
    }

    public void setServer(RestoranServer server) {
        this.server = server;
    }

    public void setPrimaryModal(boolean primaryModal) {
        this.primaryModal = primaryModal;
    }
}

