/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.backoffice.knjizenje;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Knjiziv;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.DoubleInput2;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.swt.components.SWTMessage;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PrikazKnjizenja
extends Window {
    private Knjiziv input;
    private RestoranServer server;

    public PrikazKnjizenja(Shell parentShell) {
        super(parentShell);
    }

    public PrikazKnjizenja(IShellProvider shellProvider) {
        super(shellProvider);
    }

    public PrikazKnjizenja(Shell parentShell, RestoranServer server) {
        super(parentShell);
        this.server = server;
    }

    public PrikazKnjizenja(IShellProvider shellProvider, RestoranServer server) {
        super(shellProvider);
        this.server = server;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Prikaz knjizenja");
    }

    protected Control createContents(Composite parent) {
        final Composite cAll = new Composite(parent, 0);
        cAll.setLayoutData((Object)new GridData(4, 4, true, true));
        cAll.setLayout((Layout)new GridLayout(2, false));
        Composite gtv = new Composite(cAll, 0);
        gtv.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tcl = new TableColumnLayout();
        gtv.setLayout((Layout)tcl);
        final TableViewer tvk = new TableViewer(gtv, 66308);
        tvk.getTable().setHeaderVisible(true);
        tvk.getTable().setLinesVisible(true);
        tvk.setContentProvider((IContentProvider)new ArrayContentProvider());
        CellLabelProvider ilp = new CellLabelProvider(){

            public void update(ViewerCell vc) {
                System.out.println("vc.getElement() = " + vc.getElement().getClass());
                if (vc.getElement() instanceof Knjizenje) {
                    Knjizenje knj = (Knjizenje)vc.getElement();
                    System.out.println("knj = " + knj);
                    System.out.println("vc.getColumnIndex() = " + vc.getColumnIndex());
                    switch (vc.getColumnIndex()) {
                        case 0: {
                            vc.setText(StatLogic.getDateString(knj.getDatumRealizacije()));
                            break;
                        }
                        case 1: {
                            vc.setText(StatLogic.getNumber02NG(knj.getRealizovaniIznos()));
                            break;
                        }
                        case 2: {
                            vc.setText(knj.getRealizovano() != false ? "DA" : "NE");
                            break;
                        }
                        case 3: {
                            vc.setText(knj.getNacinRealizacije() != null ? knj.getNacinRealizacije() : "");
                            break;
                        }
                        case 4: {
                            vc.setText(knj.getNapomena() != null ? knj.getNapomena() : "");
                            break;
                        }
                        default: {
                            vc.setText("/");
                        }
                    }
                }
            }
        };
        TableViewerColumn tvc1 = new TableViewerColumn(tvk, 16384);
        tvc1.getColumn().setText("Datum realizacije");
        tvc1.setLabelProvider(ilp);
        tcl.setColumnData((Widget)tvc1.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvc2 = new TableViewerColumn(tvk, 16384);
        tvc2.getColumn().setText("Realizovan iznos");
        tvc2.setLabelProvider(ilp);
        tcl.setColumnData((Widget)tvc2.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvc3 = new TableViewerColumn(tvk, 16384);
        tvc3.getColumn().setText("Realizacija kompletna");
        tvc3.setLabelProvider(ilp);
        tcl.setColumnData((Widget)tvc3.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvc4 = new TableViewerColumn(tvk, 16384);
        tvc4.getColumn().setText("Nacin realizacije");
        tvc4.setLabelProvider(ilp);
        tcl.setColumnData((Widget)tvc4.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        TableViewerColumn tvc5 = new TableViewerColumn(tvk, 16384);
        tvc5.getColumn().setText("Napomena");
        tvc5.setLabelProvider(ilp);
        tcl.setColumnData((Widget)tvc5.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 150, true));
        GridData inputData = new GridData(4, 4, true, false);
        inputData.heightHint = 25;
        inputData.widthHint = 120;
        Group gnk = new Group(cAll, 0);
        gnk.setText("Podaci");
        gnk.setLayoutData((Object)new GridData(4, 4, false, true));
        gnk.setLayout((Layout)new GridLayout(2, false));
        Label ldk = new Label((Composite)gnk, 131072);
        ldk.setText("Datum realizacije");
        ldk.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final DateInput2 datumRealizacije = new DateInput2((Composite)gnk, "Datum realizacije", new Date(this.server.getLastDateZD().getTime()), false, this.server);
        datumRealizacije.getControl().addMouseListener((MouseListener)new CalendarAdapter(datumRealizacije, this.getShell()));
        datumRealizacije.getControl().setLayoutData((Object)inputData);
        Label lir = new Label((Composite)gnk, 131072);
        lir.setText("Realizovani iznos");
        lir.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final DoubleInput2 iznosRealizacije = new DoubleInput2((Composite)gnk, "Realizovani iznos", (Double)0.0, true);
        iznosRealizacije.getControl().setLayoutData((Object)inputData);
        iznosRealizacije.setResult(this.calcRest());
        Label lrk = new Label((Composite)gnk, 131072);
        lrk.setText("Realizacija kompletna");
        lrk.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Button brk = new Button((Composite)gnk, 32);
        brk.setSelection(true);
        Label lnr = new Label((Composite)gnk, 131072);
        lnr.setText("Nacin realizacije");
        lnr.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Combo cNacin = new Combo((Composite)gnk, 4);
        cNacin.setLayoutData((Object)inputData);
        final List<String> naciniRealizacije = this.server.getNaciniRealizacije();
        for (String n : naciniRealizacije) {
            cNacin.add(n);
        }
        Label lrNapomena = new Label((Composite)gnk, 131072);
        lrNapomena.setText("Napomena:");
        lrNapomena.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Text rNapomena = new Text((Composite)gnk, 2114);
        rNapomena.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)rNapomena.getLayoutData()).heightHint = 80;
        Button bNew = new Button((Composite)gnk, 72);
        bNew.setText("Novo");
        bNew.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        ((GridData)bNew.getLayoutData()).widthHint = 120;
        ((GridData)bNew.getLayoutData()).heightHint = 40;
        Button bReal = new Button((Composite)gnk, 72);
        bReal.setLayoutData((Object)new GridData(0x1000000, 128, true, true));
        ((GridData)bReal.getLayoutData()).widthHint = 120;
        ((GridData)bReal.getLayoutData()).heightHint = 40;
        bReal.setText("Potvrdi realizaciju");
        bReal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Knjizenje k = null;
                IStructuredSelection iSel = (IStructuredSelection)tvk.getSelection();
                if (!iSel.isEmpty()) {
                    try {
                        k = (Knjizenje)iSel.getFirstElement();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.out);
                    }
                }
                if (k != null) {
                    int answer = SWTMessage.showLocalizedYesNoDialog(PrikazKnjizenja.this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_AZURIRATE_KNJIZENJE"), new Object[0]));
                    if (answer != 64) {
                        return;
                    }
                } else {
                    int answer;
                    k = new Knjizenje();
                    if (PrikazKnjizenja.this.input.getRealizovan() && (answer = SWTMessage.showLocalizedYesNoDialog(PrikazKnjizenja.this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UNESETE_NOVO_KNJIZENJE_ZA_VEC_REALIZOVANI_RACUN"), new Object[0]))) != 64) {
                        return;
                    }
                }
                try {
                    int answer;
                    if ((cNacin.getText() == null || cNacin.getText().length() == 0) && (answer = SWTMessage.showLocalizedYesNoDialog(PrikazKnjizenja.this.getShell(), String.format(Konstante.getBundle().getString("PORUKA_DA_LI_STE_SIGURNI_DA_ZELITE_DA_UNESETE_KNJIZENJE_BEZ_NACINA_REALIZACIJE"), new Object[0]))) != 64) {
                        return;
                    }
                    if (PrikazKnjizenja.this.input == null) {
                        throw new Exception("Racun knjizenja ne moze biti null");
                    }
                    if (PrikazKnjizenja.this.input instanceof Racun) {
                        Racun racun = (Racun)PrikazKnjizenja.this.input;
                        k.setRacun(racun);
                    } else if (PrikazKnjizenja.this.input instanceof Trebovanje) {
                        Trebovanje treb = (Trebovanje)PrikazKnjizenja.this.input;
                        k.setTrebovanje(treb);
                    } else if (PrikazKnjizenja.this.input instanceof Prijemnica) {
                        Prijemnica prij = (Prijemnica)PrikazKnjizenja.this.input;
                        k.setPrijemnica(prij);
                    } else if (PrikazKnjizenja.this.input instanceof Trosak) {
                        Trosak tros = (Trosak)PrikazKnjizenja.this.input;
                        k.setTrosak(tros);
                    } else {
                        throw new Exception("Instance of input not supported");
                    }
                    k.setDatumRealizacije(datumRealizacije.getResult());
                    k.setDatumUnosa(new Date());
                    k.setNacinRealizacije(cNacin.getText());
                    k.setNapomena(rNapomena.getText());
                    k.setRealizovaniIznos(iznosRealizacije.getResult());
                    k.setRealizovano(brk.getSelection());
                    k = PrikazKnjizenja.this.updateKnjizenje(k);
                    if (k.getRacun() != null) {
                        PrikazKnjizenja.this.input = k.getRacun();
                    } else if (k.getTrebovanje() != null) {
                        PrikazKnjizenja.this.input = k.getTrebovanje();
                    } else if (k.getPrijemnica() != null) {
                        PrikazKnjizenja.this.input = k.getPrijemnica();
                    } else if (k.getTrosak() != null) {
                        PrikazKnjizenja.this.input = k.getTrosak();
                    }
                    tvk.setInput((Object)PrikazKnjizenja.this.getKnjizenja());
                    tvk.refresh();
                    cAll.getShell().close();
                }
                catch (Exception ex) {
                    Logger.getLogger(PrikazKnjizenja.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                    SWTMessage.showMessageDialog(PrikazKnjizenja.this.getShell(), "Doslo je do greske prilikom azuriranja knjizenja", "Greska", 4);
                }
            }
        });
        bNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tvk.setSelection((ISelection)new StructuredSelection(new Object[0]));
                datumRealizacije.clear();
                iznosRealizacije.clear();
                iznosRealizacije.setResult(PrikazKnjizenja.this.calcRest());
                brk.setSelection(true);
                cNacin.setText("");
                cNacin.removeAll();
                naciniRealizacije.clear();
                naciniRealizacije.addAll(PrikazKnjizenja.this.server.getNaciniRealizacije());
                for (String n : naciniRealizacije) {
                    cNacin.add(n);
                }
            }
        });
        tvk.setInput(this.getKnjizenja());
        tvk.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent sce) {
                IStructuredSelection iSel = (IStructuredSelection)sce.getSelection();
                Object elem = iSel.getFirstElement();
                if (elem != null && elem instanceof Knjizenje) {
                    Knjizenje knjizenje = (Knjizenje)elem;
                    datumRealizacije.setResult(knjizenje.getDatumRealizacije());
                    iznosRealizacije.setResult(knjizenje.getRealizovaniIznos());
                    brk.setSelection(knjizenje.getRealizovano().booleanValue());
                    cNacin.removeAll();
                    naciniRealizacije.clear();
                    naciniRealizacije.addAll(PrikazKnjizenja.this.server.getNaciniRealizacije());
                    for (String n : naciniRealizacije) {
                        cNacin.add(n);
                    }
                    cNacin.setText(knjizenje.getNacinRealizacije() != null ? knjizenje.getNacinRealizacije() : "");
                }
            }
        });
        return cAll;
    }

    private Double calcRest() {
        Double rest = this.calcTotal();
        List<Knjizenje> knjiz = this.getKnjizenja();
        for (Knjizenje knjizenje : knjiz) {
            if (knjizenje.getRealizovano() != null && knjizenje.getRealizovano().booleanValue()) {
                rest = 0.0;
                break;
            }
            rest = rest - knjizenje.getRealizovaniIznos();
        }
        return rest;
    }

    private Double calcTotal() {
        Double total = 0.0;
        if (this.input instanceof Racun) {
            Racun racun = (Racun)this.input;
            total = racun.total();
        } else if (this.input instanceof Trebovanje) {
            Trebovanje trebovanje = (Trebovanje)this.input;
            total = trebovanje.getTotal();
        } else if (this.input instanceof Prijemnica) {
            Prijemnica prijemnica = (Prijemnica)this.input;
            total = prijemnica.getTotal();
        } else if (this.input instanceof Trosak) {
            Trosak trosak = (Trosak)this.input;
            total = trosak.getIznos();
        }
        return total;
    }

    public void setInput(Knjiziv input) {
        if (!(input instanceof Racun || input instanceof Trebovanje || input instanceof Prijemnica || input instanceof Trosak)) {
            throw new IllegalArgumentException("input must be instance of either Racun, Trebovanje, Prijemnica, Trosak");
        }
        this.input = input;
    }

    public Knjizenje updateKnjizenje(Knjizenje knjiz) throws Exception {
        return this.server.updateOrCreateKnjizenje(knjiz);
    }

    private List<Knjizenje> getKnjizenja() {
        LinkedList<Knjizenje> list = new LinkedList<Knjizenje>();
        if (this.input != null) {
            Trosak t;
            if (this.input instanceof Racun) {
                Racun r = (Racun)this.input;
                if (r.getKnjizenja() != null) {
                    list.addAll(r.getKnjizenja());
                }
            } else if (this.input instanceof Trebovanje) {
                Trebovanje t2 = (Trebovanje)this.input;
                if (t2.getKnjizenja() != null) {
                    list.addAll(t2.getKnjizenja());
                }
            } else if (this.input instanceof Prijemnica) {
                Prijemnica p = (Prijemnica)this.input;
                if (p.getKnjizenja() != null) {
                    list.addAll(p.getKnjizenja());
                }
            } else if (this.input instanceof Trosak && (t = (Trosak)this.input).getKnjizenja() != null) {
                list.addAll(t.getKnjizenja());
            }
        }
        System.out.println("list.size() = " + list.size());
        return list;
    }

    public void setServer(RestoranServer server) {
        this.server = server;
    }
}

