/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.FrontOffice3;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.DnevniUtrosak;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.ZD;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class Utrosci {
    public static List<DnevniUtrosak> utrosciPoRacunu(RestoranServer server, Racun racun) {
        Connection connection = server.getConnection();
        ArrayList<DnevniUtrosak> utrosci = new ArrayList<DnevniUtrosak>();
        String qsetQuery = "set @racunid =? ;";
        String query = "select ARTIKAL_ID, ROUND(sum(kolicina*putaotkuc*mera),4) as kolicina, ODELJENJA_ID, dodatno, \r\n\t\t\tcoalesce((select komadBPDV from trebovanjestavka ts\r\n\t\t\t\t\t\t\t\t\t\t\tleft join trebovanje t on ts.TREBOVANJE_ID = t.id\r\n\t\t\t\t\t\t\t\t\t\t\twhere ts.ARTIKAL_ID = trt.ARTIKAL_ID and trt.tip not in ('SLOZ','DODA') and \r\n\t\t\t\t\t\t\t\t\t\t\tt.datumTrebovanja = (SELECT max(t2.datumTrebovanja) from trebovanje t2 \r\n\t\t\t\t\t\t\t\t\t\t\t\tleft join trebovanjestavka ts2 on ts2.TREBOVANJE_ID = t2.id\r\n\t\t\t\t\t\t\t\t\t\t\t\twhere ts2.artikal_ID = trt.ARTIKAL_ID) limit 1),0) as nabavnaCena\r\n\r\nfrom (\r\nselect sr.artikal_id, sr.kolicina, a.mera, \r\n\t\t\t\t1 as putaotkuc, ao.ODELJENJA_ID, '0' as ttip,sr.id,a.tip,\r\n\t\t\t\t(case WHEN coalesce(r.crnoPlacanje,'') != ''  and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tr.naOsnovno = 0 then 1 else 0 end) as dodatno \r\n\t\tfrom stavkaracuna sr\r\n\t\tleft join artikal a on a.id = sr.artikal_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1\r\n\t\tleft join racun r on r.id = sr.RACUN_ID\r\n\t\tleft join kasa k on k.id = r.KASA_ID\r\n\t\tleft join kasa_odeljenje ko on ko.KASA_ID = k.id\r\n\t\twhere r.id = @racunid and \r\n\t\t\t\t\tao.ODELJENJA_ID = ko.ODELJENJA_ID and coalesce(r.id,0) != 0 and\r\n\t\t\t\t\ta.tip not in ('SLOZ','DODA') \r\n\t\tUNION\r\n\t\tselect i.sastojak_id,i.kolicina,1 as mera, sr.kolicina as putaotkuc, ao.ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t\t\t'1' as ttip, sr.id, a.tip,\r\n\t\t\t\t\t\t\t\t\t\t\t(case WHEN coalesce(r.crnoPlacanje,'') != '' and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tr.naOsnovno = 0 then 1 else 0 end) as dodatno\r\n\t\tfrom normativ i\r\n\t\tleft join artikal a on a.id = i.sastojak_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1\r\n\t\tleft join stavkaracuna sr on sr.artikal_id = i.artikal_id\r\n\t\tleft join artikal a2 on a2.id = sr.artikal_id\r\n\t\tleft join racun r on r.id = sr.RACUN_ID\r\n\t\tleft join normativartikal na on i.NORMATIVARTIKAL_ID = na.id\r\n\t\twhere r.id = @racunid and a2.tip != 'POLU' and \r\n\t\t\t\t\tao.ODELJENJA_ID = i.ODELJENJE_ID and coalesce(r.id,0) != 0 and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) \r\n\t\tUNION\r\n\t\tselect ii.sastojak_id,ii.kolicina,1 as mera, (i.kolicina * sr.kolicina) as putaotkuc, ao.ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t'2' as ttip, sr.id, a.tip,\r\n\t\t\t\t\t\t\t\t  (case WHEN coalesce(r.crnoPlacanje,'') != '' and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\tr.naOsnovno = 0 then 1 else 0 end) as dodatno\r\n\t\tfrom normativ i\r\n\t\tleft join stavkaracuna sr on sr.artikal_id = i.artikal_id\r\n\t\tleft join normativ ii on i.sastojak_id = ii.artikal_id\r\n\t\tleft join artikal a on a.id = ii.sastojak_id\r\n\t\tleft join artikal a3 on a3.id = i.sastojak_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1\r\n\t\tleft join racun r on r.id = sr.RACUN_ID\r\n\t\tleft join normativartikal na on ii.NORMATIVARTIKAL_ID = na.id\r\n\t\tleft join normativartikal na2 on i.NORMATIVARTIKAL_ID = na2.id\r\n\t\twhere r.id = @racunid and a3.tip != 'POLU' and \r\n\t\t\t\t\t ao.ODELJENJA_ID = ii.ODELJENJE_ID and coalesce(r.id,0) != 0 and ii.SASTOJAK_ID is not null and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna2.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) \r\n\t\tUNION\r\n\t\tselect iii.sastojak_id,iii.kolicina,1 as mera, (i.kolicina * ii.kolicina * sr.kolicina) as putaotkuc, ao.ODELJENJA_id, \r\n\t\t\t\t\t\t\t\t\t'3' as ttip, sr.id, a.tip,\r\n\t\t\t\t\t\t\t\t  (case WHEN coalesce(r.crnoPlacanje,'') != '' and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\tr.naOsnovno = 0 then 1 else 0 end) as dodatno\r\n\t\tfrom normativ i\r\n\t\tleft join stavkaracuna sr on sr.artikal_id = i.artikal_id\r\n\t\tleft join normativ ii on i.sastojak_id = ii.artikal_id\r\n\t\tleft join normativ iii on ii.sastojak_id = iii.artikal_id\r\n\t\tleft join artikal a on a.id = iii.sastojak_id\r\n\t\tleft join artikal a2 on a2.id = ii.sastojak_id\r\n\t\tleft join artikal a3 on a3.id = i.sastojak_id\r\n\t\tleft join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id and ao.ODELJENJA_ID > 1\r\n\t\tleft join racun r on r.id = sr.RACUN_ID\r\n\t\tleft join normativartikal na on iii.NORMATIVARTIKAL_ID = na.id\r\n\t\tleft join normativartikal na2 on ii.NORMATIVARTIKAL_ID = na2.id\r\n\t\tleft join normativartikal na3 on i.NORMATIVARTIKAL_ID = na3.id\r\n\t\twhere r.id = @racunid and a2.tip != 'POLU' and \r\n\t\t\t\t\t\ta3.tip != 'POLU' and \r\n\t\t\t\t\t  iii.ODELJENJE_ID = ao.ODELJENJA_ID and coalesce(r.id,0) != 0 and iii.SASTOJAK_ID is not null and \r\n\t\t\t\t\t\t\t\t\t\t\tna.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = iii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna2.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = ii.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) and \r\n\t\t\t\t\t\t\t\t\t\t\tna3.id = coalesce((SELECT naa.id\r\n\t\t\t\t\t\t\t\t\t\t\tFROM normativartikal naa \r\n\t\t\t\t\t\t\t\t\t\t\t\t\twhere naa.ARTIKAL_ID = i.ARTIKAL_ID and naa.aktivan = 1 and \r\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTIMESTAMPDIFF( SECOND, naa.datum, r.datum) > 0\r\n\t\t\t\t\t\t\t\tORDER BY TIMESTAMPDIFF( SECOND, naa.datum, r.datum) LIMIT 1 ),0) \r\n) as trt\r\nwhere tip not in ('SLOZ','DODA')\r\ngroup by artikal_id,odeljenja_id,dodatno,nabavnaCena";
        try {
            PreparedStatement ps = connection.prepareStatement(qsetQuery);
            ps.setLong(1, racun.getId());
            ps.execute();
            System.out.println(ps);
            ps = connection.prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DnevniUtrosak utrosak = new DnevniUtrosak();
                utrosak.setArtikal(server.getArtikal(rs.getLong("ARTIKAL_ID")));
                utrosak.setDodatno(rs.getBoolean("dodatno"));
                utrosak.setKolicina(rs.getDouble("kolicina"));
                utrosak.setOdeljenje(server.getOdeljenje(rs.getLong("ODELJENJA_ID")));
                utrosak.setZdBroj(racun.getZdBroj());
                utrosak.setNabavnaCena(rs.getDouble("nabavnaCena"));
                utrosci.add(utrosak);
            }
            return utrosci;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<DnevniUtrosak> upisaniUtrosci(long zdBroj, RestoranServer server) {
        Connection connection = server.getConnection();
        ArrayList<DnevniUtrosak> utrosci = new ArrayList<DnevniUtrosak>();
        String query = "SELECT * from dnevniutrosak du where du.zdbroj = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, zdBroj);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                DnevniUtrosak utrosak = new DnevniUtrosak();
                utrosak.setId(rs.getLong("id"));
                utrosak.setArtikal(server.getArtikal(rs.getLong("ARTIKAL_ID")));
                utrosak.setDodatno(rs.getBoolean("dodatno"));
                utrosak.setKolicina(rs.getDouble("kolicina"));
                utrosak.setOdeljenje(server.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                utrosak.setZdBroj(zdBroj);
                utrosak.setNabavnaCena(rs.getDouble("nabavnaCena"));
                utrosci.add(utrosak);
            }
            return utrosci;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return utrosci;
        }
    }

    public static boolean upisDnevnogUtroska(Racun racun, RestoranServer server) {
        StringBuilder sb = new StringBuilder();
        System.out.println("ovde kreiram utroske");
        List<DnevniUtrosak> utrosci = Utrosci.utrosciPoRacunu(server, racun);
        ZD poslednji = server.getZDbyDatum(racun.getDatum());
        for (StavkaRacuna sr : server.getStavke(racun.getId())) {
            sb.append(sr.getName());
            sb.append(" : ");
            sb.append(sr.getKolicina());
            sb.append(", ");
        }
        Logger.getLogger(FrontOffice3.class.getName()).info("Kreiranje utro\u0161aka za racun broj:" + racun.getBrojRacuna() + " datum:" + racun.getDatum() + "poslednji ZdBroj: " + poslednji.getZdBroj() + " Ra\u010dun ZdBroj: " + racun.getZdBroj() + "\n--------------------------------------------------------------------------------------------");
        boolean upis = false;
        List<Object> listaDU = new LinkedList();
        try {
            listaDU = Utrosci.upisaniUtrosci(racun.getZdBroj(), server);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        Logger.getLogger(FrontOffice3.class.getName()).info("Prodato: " + sb.toString() + "\n-------------------------------------------------------------------------------------------------------------");
        try {
            for (DnevniUtrosak du : utrosci) {
                boolean isti = false;
                DnevniUtrosak dUtrosak = null;
                for (DnevniUtrosak dnevniUtrosak : listaDU) {
                    System.out.println(dnevniUtrosak.getArtikal().getName());
                    if (du.getArtikal().getId() != dnevniUtrosak.getArtikal().getId() || du.getOdeljenje().getId() != dnevniUtrosak.getOdeljenje().getId() || !String.valueOf(du.isDodatno()).equals(String.valueOf(dnevniUtrosak.isDodatno()))) continue;
                    isti = true;
                    Logger.getLogger(FrontOffice3.class.getName()).info("Preneta kolicina iz DU:" + dnevniUtrosak.getKolicina() + " Dnevni Utrosak CikaNeca:" + du.getKolicina() + "\n-------------------------------------------------------------------------------------------------------------");
                    dnevniUtrosak.setKolicina(BigDecimal.valueOf(du.getKolicina() + dnevniUtrosak.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    dUtrosak = dnevniUtrosak;
                    break;
                }
                if (isti) {
                    server.updateDU(dUtrosak);
                    continue;
                }
                server.insertDU(du);
            }
            upis = true;
        }
        catch (Exception e) {
            Logger.getLogger(e.getMessage());
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }
}

