/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.parts.ObjectWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StavkeSumarno {
    public static final Logger LOGGER = Logger.getLogger(StavkeSumarno.class.getName());

    public static Map MakeMap(List<StavkaRacuna> s, Restoran restoran) {
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        HashMap<Odeljenje, ArrayList> mapa = new HashMap<Odeljenje, ArrayList>();
        List<StavkaRacuna> stavkeRacuna = StavkeSumarno.getSumarnoF(s);
        for (StavkaRacuna sr : stavkeRacuna) {
            LOGGER.log(Level.FINER, "MakeMap -> Stavka racuna {0}", sr.toString());
            Odeljenje o = restoran.getServer().getArtikal(sr.getArtikal().getName()).getOdeljenje();
            if (!odeljenja.contains(o)) {
                odeljenja.add(o);
                ArrayList<StavkaRacuna> sta = new ArrayList<StavkaRacuna>();
                sta.add(sr);
                mapa.put(o, sta);
                continue;
            }
            ArrayList stavke = (ArrayList)mapa.get(o);
            stavke.add(sr);
            mapa.put(o, stavke);
        }
        return mapa;
    }

    public static Map MakeMapForOrderPrint(List<StavkaRacuna> s) {
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        HashMap<Odeljenje, ArrayList> mapa = new HashMap<Odeljenje, ArrayList>();
        List<StavkaRacuna> stavkeRacuna = StavkeSumarno.getSumarnoF(s);
        for (StavkaRacuna sr : stavkeRacuna) {
            LOGGER.log(Level.FINER, "MakeMap -> Stavka racuna {0}", sr.toString());
            Odeljenje o = sr.getArtikal().getOdeljenje();
            if (!odeljenja.contains(o)) {
                odeljenja.add(o);
                ArrayList<StavkaRacuna> sta = new ArrayList<StavkaRacuna>();
                sta.add(sr);
                mapa.put(o, sta);
                continue;
            }
            ArrayList stavke = (ArrayList)mapa.get(o);
            stavke.add(sr);
            mapa.put(o, stavke);
        }
        return mapa;
    }

    public static Map MakeMapForOrderPrintForKasa(List<StavkaRacuna> s, Kasa kasa) {
        if (kasa == null) {
            return new HashMap();
        }
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        HashMap<Odeljenje, ArrayList> mapa = new HashMap<Odeljenje, ArrayList>();
        List<StavkaRacuna> stavkeRacuna = StavkeSumarno.getSumarnoF(s);
        for (StavkaRacuna sr : stavkeRacuna) {
            LOGGER.log(Level.FINER, "MakeMap -> Stavka racuna {0}", sr.toString());
            for (Odeljenje od : sr.getArtikal().getOdeljenja()) {
                if (!kasa.getProdajnoMesto().getOdeljenja().contains(od)) continue;
                if (!odeljenja.contains(od)) {
                    odeljenja.add(od);
                    ArrayList<StavkaRacuna> sta = new ArrayList<StavkaRacuna>();
                    sta.add(sr);
                    mapa.put(od, sta);
                    continue;
                }
                ArrayList stavke = (ArrayList)mapa.get(od);
                stavke.add(sr);
                mapa.put(od, stavke);
            }
        }
        return mapa;
    }

    public static Map MakeHMapForOrderPrintForKasa(List<StavkaRacuna> s, Kasa kasa) {
        if (kasa == null) {
            return new HashMap();
        }
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        HashMap<Odeljenje, ArrayList> mapa = new HashMap<Odeljenje, ArrayList>();
        LinkedList<StavkaRacuna> stavkeRacuna = new LinkedList<StavkaRacuna>(s);
        StavkeSumarno.condenseHList(s);
        for (StavkaRacuna sr : stavkeRacuna) {
            if (sr.getGlavnaStavka() != null) continue;
            LOGGER.log(Level.FINER, "MakeMap -> Stavka racuna {0}", sr.toString());
            for (Odeljenje od : sr.getArtikal().getOdeljenja()) {
                if (!kasa.getProdajnoMesto().getOdeljenja().contains(od)) continue;
                if (!odeljenja.contains(od)) {
                    odeljenja.add(od);
                    ArrayList<StavkaRacuna> sta = new ArrayList<StavkaRacuna>();
                    sta.add(sr);
                    mapa.put(od, sta);
                    continue;
                }
                ArrayList stavke = (ArrayList)mapa.get(od);
                stavke.add(sr);
                mapa.put(od, stavke);
            }
        }
        return mapa;
    }

    public static Map MakeMap2(Storno s, Restoran restoran) {
        ArrayList<Odeljenje> odeljenja = new ArrayList<Odeljenje>();
        HashMap<Odeljenje, ArrayList> mapa = new HashMap<Odeljenje, ArrayList>();
        List<StornoStavka> stavkeRacuna = s.getStavke();
        for (StornoStavka sr : stavkeRacuna) {
            Odeljenje o = sr.getArtikal().getOdeljenje();
            if (!odeljenja.contains(o)) {
                odeljenja.add(o);
                ArrayList<StornoStavka> sta = new ArrayList<StornoStavka>();
                sta.add(sr);
                mapa.put(o, sta);
                continue;
            }
            ArrayList stavke = (ArrayList)mapa.get(o);
            stavke.add(sr);
            mapa.put(o, stavke);
        }
        return mapa;
    }

    public static List<StavkaRacuna> getSumarno(List<StavkaRacuna> stavkeRacuna) {
        if (stavkeRacuna == null || stavkeRacuna.size() < 1) {
            return new ArrayList<StavkaRacuna>();
        }
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        ArrayList<Double> kolicine = new ArrayList<Double>();
        ArrayList<Tura> ture = new ArrayList<Tura>();
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna sr : stavkeRacuna) {
            if (sr == null) continue;
            if (!artikli.contains(sr.getArtikal())) {
                Artikal a = sr.getArtikal();
                a.setCena(sr.getCena());
                artikli.add(a);
                kolicine.add(sr.getKolicina());
                ture.add(sr.getTura());
                continue;
            }
            int i = artikli.indexOf(sr.getArtikal());
            Double kol = (Double)kolicine.get(i);
            kol = kol + sr.getKolicina();
            kolicine.set(i, kol);
        }
        for (int i = 0; i < artikli.size(); ++i) {
            StavkaRacuna rs = new StavkaRacuna();
            rs.setArtikal((Artikal)artikli.get(i));
            rs.setKolicina((double)((Double)kolicine.get(i)));
            rs.setTura((Tura)ture.get(i));
            rs.setBrojStola(stavkeRacuna.get(0).getBrojStola());
            rs.setCena(((Artikal)artikli.get(i)).getCena());
            rs.setNaziv(((Artikal)artikli.get(i)).getName());
            stavkeSumarno.add(rs);
        }
        return stavkeSumarno;
    }

    public static List<StavkaRacuna> getSumarnoF(List<StavkaRacuna> stavkeRacuna) {
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna stavka : stavkeRacuna) {
            boolean bl = true;
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getId() != stavka.getArtikal().getId() || temp.getCena() / 1.0 != stavka.getCena() / 1.0) continue;
                temp.setKolicina(temp.getKolicina() + stavka.getKolicina());
                bl = false;
            }
            if (!bl) continue;
            StavkaRacuna sr2 = new StavkaRacuna();
            sr2.setArtikal(stavka.getArtikal());
            sr2.setKolicina(stavka.getKolicina());
            sr2.setBrojStola(stavka.getBrojStola());
            sr2.setTura(stavka.getTura());
            sr2.setCena(stavka.getCenaBezPopusta());
            sr2.setNaziv(stavka.getNaziv());
            sr2.setRacun(stavka.getRacun());
            sr2.setPodStavke(stavka.getPodStavke());
            stavkeSumarno.add(sr2);
        }
        for (StavkaRacuna stavka : stavkeRacuna) {
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getCena() / 1.0 != temp.getCena() / 1.0) {
                    temp.setNaziv("* " + temp.getArtikal().getName());
                    continue;
                }
                if (stavka.getArtikal().getCena() / 1.0 == stavka.getCena() / 1.0) continue;
                stavka.setNaziv("* " + stavka.getArtikal().getName());
            }
        }
        return stavkeSumarno;
    }

    public static List<StavkaRacuna> getSumarnoFRastavljanje(Collection<StavkaRacuna> stavkeRacuna) {
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna stavka : stavkeRacuna) {
            boolean bl = true;
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getId() != stavka.getArtikal().getId() || temp.getCena() / 1.0 != stavka.getCena() / 1.0) continue;
                temp.setKolicinaZaRastavljanjeDesno(temp.getKolicinaZaRastavljanjeDesno() + stavka.getKolicinaZaRastavljanjeDesno());
                temp.setKolicinaZaRastavljanjeLevo(temp.getKolicinaZaRastavljanjeLevo() + stavka.getKolicinaZaRastavljanjeLevo());
                bl = false;
            }
            if (!bl) continue;
            StavkaRacuna sr2 = new StavkaRacuna();
            sr2.setArtikal(stavka.getArtikal());
            sr2.setKolicinaZaRastavljanjeDesno(stavka.getKolicinaZaRastavljanjeDesno());
            sr2.setKolicinaZaRastavljanjeLevo(stavka.getKolicinaZaRastavljanjeLevo());
            sr2.setBrojStola(stavka.getBrojStola());
            sr2.setTura(stavka.getTura());
            sr2.setCena(stavka.getCenaBezPopusta());
            sr2.setNaziv(stavka.getNaziv());
            sr2.setRacun(stavka.getRacun());
            stavkeSumarno.add(sr2);
        }
        for (StavkaRacuna stavka : stavkeRacuna) {
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getCena() / 1.0 != temp.getCena() / 1.0) {
                    temp.setNaziv("* " + temp.getArtikal().getName());
                    continue;
                }
                if (stavka.getArtikal().getCena() / 1.0 == stavka.getCena() / 1.0) continue;
                stavka.setNaziv("* " + stavka.getArtikal().getName());
            }
        }
        return stavkeSumarno;
    }

    public static List<StavkaRacuna> getSumarnoF(List<StavkaRacuna> stavkeRacuna, boolean withID) {
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna stavka : stavkeRacuna) {
            if (stavka.getArtikal().getCena() == 0.0 || stavka.getArtikal().getCena() == null) continue;
            boolean bl = true;
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getId() == stavka.getArtikal().getId() && temp.getCena() / 1.0 == stavka.getCena() / 1.0) {
                    temp.setKolicina(temp.getKolicina() + stavka.getKolicina());
                    bl = false;
                }
                if (temp.getArtikal().getCena() / 1.0 != temp.getCena() / 1.0) {
                    temp.setNaziv("* " + temp.getArtikal().getName());
                    continue;
                }
                if (stavka.getArtikal().getCena() / 1.0 == stavka.getCena() / 1.0 || stavka.getArtikal().getCena() == 0.0) continue;
                stavka.setNaziv("* " + stavka.getArtikal().getName());
            }
            if (!bl) continue;
            StavkaRacuna sr2 = new StavkaRacuna();
            if (withID) {
                sr2.setId(stavka.getId());
            }
            sr2.setArtikal(stavka.getArtikal());
            sr2.setKolicina(stavka.getKolicina());
            sr2.setBrojStola(stavka.getBrojStola());
            sr2.setTura(stavka.getTura());
            sr2.setCena(stavka.getCenaBezPopusta());
            sr2.setNaziv(stavka.getNaziv());
            sr2.setRacun(stavka.getRacun());
            stavkeSumarno.add(sr2);
        }
        return stavkeSumarno;
    }

    public static List<StavkaRacuna> getSumarnoFBezPopusta(List<StavkaRacuna> stavkeRacuna) {
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna stavka : stavkeRacuna) {
            boolean bl = true;
            for (StavkaRacuna temp : stavkeSumarno) {
                if (temp.getArtikal().getId() == stavka.getArtikal().getId() && temp.getCena() / 1.0 == stavka.getCena() / 1.0) {
                    temp.setKolicina(temp.getKolicina() + stavka.getKolicina());
                    bl = false;
                }
                if (temp.getArtikal().getCena() / 1.0 != temp.getCena() / 1.0) {
                    temp.setNaziv("* " + temp.getArtikal().getName());
                    continue;
                }
                if (stavka.getArtikal().getCena() / 1.0 == stavka.getCena() / 1.0) continue;
                stavka.setNaziv("* " + stavka.getArtikal().getName());
            }
            if (!bl) continue;
            StavkaRacuna sr2 = new StavkaRacuna();
            sr2.setArtikal(stavka.getArtikal());
            sr2.setKolicina(stavka.getKolicina());
            sr2.setBrojStola(stavka.getBrojStola());
            sr2.setTura(stavka.getTura());
            sr2.setCena(stavka.getCenaBezPopusta());
            sr2.setNaziv(stavka.getNaziv());
            stavkeSumarno.add(sr2);
        }
        return stavkeSumarno;
    }

    public static List<StavkaRacuna> getSumarnoPopust(List<StavkaRacuna> stavkeRacuna) {
        if (stavkeRacuna == null || stavkeRacuna.size() < 1) {
            return new ArrayList<StavkaRacuna>();
        }
        HashMap stavke = new HashMap();
        HashMap<Artikal, Double> pomocna = new HashMap<Artikal, Double>();
        ArrayList<StavkaRacuna> stavkeSumarno = new ArrayList<StavkaRacuna>();
        for (StavkaRacuna sr : stavkeRacuna) {
            StavkaRacuna rs;
            if (sr == null) continue;
            pomocna.clear();
            pomocna.put(sr.getArtikal(), sr.getCena());
            if (stavke.get(pomocna) == null) {
                rs = new StavkaRacuna();
                rs.setArtikal(sr.getArtikal());
                rs.setKolicina(sr.getKolicina());
                rs.setTura(sr.getTura());
                rs.setBrojStola(sr.getBrojStola());
                rs.setCena(sr.getCena());
                rs.setNaziv(sr.getNaziv());
                stavke.put(pomocna, rs);
                continue;
            }
            rs = (StavkaRacuna)stavke.get(pomocna);
            rs.setKolicina(rs.getKolicina() + sr.getKolicina());
            stavke.put(pomocna, rs);
        }
        for (StavkaRacuna sr : stavke.values()) {
            stavkeSumarno.add(sr);
        }
        Collections.sort(stavkeSumarno, Comparator.comparing(StavkaRacuna::getArtikal, Comparator.comparing(Artikal::getName)));
        return stavkeSumarno;
    }

    public static NacinPlacanja getNacin(String opis) {
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!np.name().equals(opis)) continue;
            return np;
        }
        return null;
    }

    public static TipArtikla getTipArtikla(String naziv) {
        for (TipArtikla ta : TipArtikla.values()) {
            if (!ta.name().equals(naziv)) continue;
            return ta;
        }
        return null;
    }

    public static int getVrednostStope(PoreskaGrupa pg, Restoran r) {
        for (ObjectWrapper ow : r.getStope()) {
            if (!ow.getData().equals(pg)) continue;
            return ow.getPercent();
        }
        return 0;
    }

    public static PoreskaGrupa getPoreskaStopa(int i) {
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            if (pg.getMetalinkCode() != i) continue;
            return pg;
        }
        return null;
    }

    public static List<String> getCrnaNaziviIzvestaji(RestoranServer server) {
        ArrayList<String> crna = new ArrayList<String>();
        for (CrnoPlacanje cp : server.readSvaCrnaPlacanja()) {
            crna.add(cp.getNaziv());
        }
        return crna;
    }

    public static void condenseHList(List<StavkaRacuna> list) {
        List order = list.stream().map(i -> System.identityHashCode(i)).collect(Collectors.toList());
        Map<Long, Map<Boolean, List<StavkaRacuna>>> artGroupedSubItemPresentParted = list.stream().collect(Collectors.groupingBy(i -> i.getArtikal().getId(), Collectors.partitioningBy(i -> i.getOpis() == null && i.getPodStavke().isEmpty())));
        List temp = artGroupedSubItemPresentParted.values().stream().flatMap(m -> m.entrySet().stream().flatMap(t -> StavkeSumarno.condenseAndFlatMap(t))).sorted(Comparator.comparing(System::identityHashCode, Comparator.comparing(i -> order.contains(i) ? Integer.valueOf(order.indexOf(i)) : null, Comparator.nullsLast(Comparator.naturalOrder())))).collect(Collectors.toList());
        list.clear();
        list.addAll(temp);
    }

    private static Stream<StavkaRacuna> condenseAndFlatMap(Map.Entry<Boolean, List<StavkaRacuna>> e) {
        Stream stream = e.getValue().stream();
        stream = e.getKey() == false ? stream : stream.reduce(StavkeSumarno::condense2Items).map(Stream::of).orElseGet(Stream::empty);
        return stream;
    }

    private static StavkaRacuna condense2Items(StavkaRacuna first, StavkaRacuna second) {
        first.setKolicina(first.getKolicina() + second.getKolicina());
        return first;
    }

    public static List<StavkaRacuna> cloneExpand(List<StavkaRacuna> list) {
        LinkedList<StavkaRacuna> tempList = new LinkedList<StavkaRacuna>();
        if (list != null) {
            for (StavkaRacuna parent : list) {
                StavkaRacuna tempParent = new StavkaRacuna(parent);
                tempList.add(tempParent);
                if (parent.getPodStavke() == null) continue;
                for (StavkaRacuna child : parent.getPodStavke()) {
                    StavkaRacuna temp = new StavkaRacuna(child);
                    tempList.add(temp);
                    temp.setGlavnaStavka(tempParent);
                }
            }
        }
        return tempList;
    }

    public static Double reduceItemInHList(StavkaRacuna sr, double kolicinaArtikla, List<StavkaRacuna> srHList) {
        if (srHList == null || sr == null) {
            return 0.0;
        }
        double amount = 0.0;
        ListIterator<StavkaRacuna> parentLI = srHList.listIterator();
        block0: while (parentLI.hasNext()) {
            boolean hasChildren;
            StavkaRacuna parent = parentLI.next();
            boolean bl = hasChildren = parent.getPodStavke() != null && !parent.getPodStavke().isEmpty();
            if (parent == sr) {
                if (kolicinaArtikla == Double.MAX_VALUE || parent.getKolicina() <= kolicinaArtikla) {
                    parentLI.remove();
                    amount += parent.getCena() * parent.getKolicina();
                    if (!hasChildren) break;
                    for (StavkaRacuna child : parent.getPodStavke()) {
                        amount += child.getKolicina() * child.getCena();
                    }
                    break;
                }
                if (hasChildren) {
                    double reducedCoeficient = kolicinaArtikla / parent.getKolicina();
                    for (StavkaRacuna child : parent.getPodStavke()) {
                        amount += reducedCoeficient * child.getKolicina() * child.getCena();
                        child.setKolicina((1.0 - reducedCoeficient) * child.getKolicina());
                    }
                }
                parent.setKolicina(parent.getKolicina() - kolicinaArtikla);
                amount += kolicinaArtikla * parent.getCena();
                break;
            }
            if (!hasChildren) continue;
            ListIterator<StavkaRacuna> childLI = parent.getPodStavke().listIterator();
            while (childLI.hasNext()) {
                StavkaRacuna child;
                child = childLI.next();
                if (child != sr) continue;
                kolicinaArtikla = parent.getKolicina() * kolicinaArtikla;
                if (kolicinaArtikla >= Double.MAX_VALUE || child.getKolicina() <= kolicinaArtikla) {
                    childLI.remove();
                    amount += child.getKolicina() * child.getCena();
                    break block0;
                }
                child.setKolicina(child.getKolicina() - kolicinaArtikla);
                amount += kolicinaArtikla * child.getCena();
                break block0;
            }
        }
        return amount;
    }
}

