/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.exceptions.CleanerCompanyNotDefinedException;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.model.controller.SettingController;
import com.dev63.restoran.model.dao.DAOProducer;
import com.dev63.restoran.model.dao.EntityDAO;
import com.dev63.restoran.model.dao.KasaDAO;
import com.dev63.restoran.model.dao.RacunDAO;
import com.dev63.restoran.model.dao.StavkaRacunaDAO;
import com.dev63.restoran.model.dao.TuraDAO;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Spremacica
implements AutoCloseable {
    private final List<Racun> zaCiscenje = new LinkedList<Racun>();
    private final StavkaRacunaDAO stavkaDao = DAOProducer.instance().produceDAO(StavkaRacunaDAO.class);
    private final RacunDAO racunDao = DAOProducer.instance().produceDAO(RacunDAO.class);

    public Racun pripremi(RestoranServer server) throws CleanerCompanyNotDefinedException {
        Integer firmaSpremacice = SettingController.loadInteger(Option.FIRMA_SPREMACICE);
        if (firmaSpremacice == null) {
            throw new CleanerCompanyNotDefinedException();
        }
        return this.pripremi(firmaSpremacice, server);
    }

    public Racun pripremiRacun(RestoranServer server, Konobar konobar) {
        Racun result = null;
        try (EntityDAO<StalniGost> stalniGostDao = DAOProducer.instance().produceGenericDAO(StalniGost.class);
             EntityDAO<Sto> stoDao = DAOProducer.instance().produceGenericDAO(Sto.class);
             KasaDAO kasaDao = DAOProducer.instance().produceDAO(KasaDAO.class);){
            NacinPlacanja nacinPlacanja = NacinPlacanja.GOTOVINA;
            Placanje placanje = new Placanje();
            placanje.setNacin(nacinPlacanja);
            placanje.setVreme(new Date());
            HashSet<Tura> ture = new HashSet<Tura>();
            List<StavkaRacuna> stavke = this.stavkaDao.stavkeZaPospremanjeFromSession();
            if (stavke.isEmpty()) {
                Racun racun = null;
                return racun;
            }
            Double suma = 0.0;
            for (StavkaRacuna stavka : stavke) {
                if (result == null) {
                    result = new Racun();
                    result.setKonobar(stavka.getRacun().getKonobar());
                    result.setBrojStola(stavka.getBrojStola());
                    result.setFiskalniOdstampan(Boolean.FALSE);
                    result.setCrnoPlacanje(null);
                    result.setStavke1(new LinkedList<StavkaRacuna>());
                    result.setDatum(placanje.getVreme());
                    result.setPopust(0.0);
                    result.setZatvoren(Boolean.FALSE);
                    result.setBrojRacuna(this.racunDao.nextFiscalBillNumber());
                    result.setKasa(kasaDao.getCurrentCounterFromSession());
                    placanje.setRacun(result);
                    result.setPlacanja(Arrays.asList(placanje));
                }
                if (!this.zaCiscenje.contains(stavka.getRacun())) {
                    this.zaCiscenje.add(stavka.getRacun());
                }
                StavkaRacuna sr = new StavkaRacuna();
                sr.setArtikal(stavka.getArtikal());
                sr.setKolicina(stavka.getKolicina());
                sr.setTura(stavka.getTura());
                sr.setBrojStola(stavka.getBrojStola());
                sr.setSaStola(null);
                sr.setNaziv(stavka.getNaziv());
                Double cena = stavka.getCena();
                sr.setRacun(result);
                sr.setCena(cena);
                result.getStavke1().add(sr);
                suma = suma + stavka.getVrednost();
                if (stavka.getTura() == null) continue;
                stavka.getTura().setRacun(result);
                ture.add(stavka.getTura());
            }
            result.setTure(new LinkedList<Tura>(ture));
            placanje.setIznos(suma);
            result.setStorniran(Boolean.FALSE);
            result.setNaOsnovno(Boolean.FALSE);
            result.setNapomena("");
        }
        return result;
    }

    public Racun pripremi(Integer stalniGostId, RestoranServer server) {
        StalniGost firmaSpremacice = null;
        Racun result = null;
        try (EntityDAO<StalniGost> stalniGostDao = DAOProducer.instance().produceGenericDAO(StalniGost.class);
             EntityDAO<Sto> stoDao = DAOProducer.instance().produceGenericDAO(Sto.class);
             KasaDAO kasaDao = DAOProducer.instance().produceDAO(KasaDAO.class);){
            if (stalniGostId != null) {
                firmaSpremacice = stalniGostDao.findByIdFromSession(stalniGostId);
            }
            NacinPlacanja nacinPlacanja = firmaSpremacice == null ? NacinPlacanja.CEK : NacinPlacanja.findByName(firmaSpremacice.getNacinPlacanja());
            Placanje placanje = new Placanje();
            placanje.setNacin(nacinPlacanja);
            placanje.setVreme(new Date());
            HashSet<Tura> ture = new HashSet<Tura>();
            List<StavkaRacuna> stavke = this.stavkaDao.stavkeZaPospremanjeFromSession();
            System.out.println("stavke.size() " + stavke.size());
            if (stavke.isEmpty()) {
                Racun racun = null;
                return racun;
            }
            Double suma = 0.0;
            for (StavkaRacuna stavka : stavke) {
                if (result == null) {
                    result = new Racun();
                    result.setKonobar(stavka.getRacun().getKonobar());
                    result.setBrojStola(stavka.getBrojStola());
                    result.setFiskalniOdstampan(Boolean.FALSE);
                    result.setCrnoPlacanje(null);
                    result.setStavke1(new LinkedList<StavkaRacuna>());
                    result.setDatum(placanje.getVreme());
                    result.setPopust(firmaSpremacice.getPopust());
                    result.setZatvoren(Boolean.FALSE);
                    result.setBrojRacuna(this.racunDao.nextFiscalBillNumber());
                    result.setKasa(kasaDao.getCurrentCounterFromSession());
                    if (firmaSpremacice != null) {
                        result.setStalniGost(firmaSpremacice);
                        if (firmaSpremacice.getNacinPlacanja().equals(NacinPlacanja.FAKTURA.name())) {
                            result.setBrojFakture(this.racunDao.nextInvoiceNumber());
                        }
                    }
                    placanje.setRacun(result);
                    result.setPlacanja(Arrays.asList(placanje));
                }
                if (!this.zaCiscenje.contains(stavka.getRacun())) {
                    this.zaCiscenje.add(stavka.getRacun());
                }
                StavkaRacuna sr = new StavkaRacuna();
                sr.setArtikal(stavka.getArtikal());
                sr.setKolicina(stavka.getKolicina());
                sr.setTura(stavka.getTura());
                sr.setBrojStola(stavka.getBrojStola());
                sr.setSaStola(null);
                sr.setNaziv(stavka.getNaziv());
                Double cena = stavka.getCena();
                sr.setRacun(result);
                sr.setCena(cena);
                result.getStavke1().add(sr);
                suma = suma + (stavka.getVrednost() - stavka.getVrednost() * result.getPopust() / 100.0);
                if (stavka.getTura() == null) continue;
                stavka.getTura().setRacun(result);
                ture.add(stavka.getTura());
            }
            result.setTure(new LinkedList<Tura>(ture));
            placanje.setIznos(suma);
            result.setStorniran(Boolean.FALSE);
            result.setNaOsnovno(Boolean.FALSE);
            result.setNapomena("");
            result.setZdBroj(server.getLastOpenZD().getZdBroj());
        }
        return result;
    }

    public Racun pobeli(RestoranServer server) {
        StalniGost firmaSpremacice = null;
        Racun result = null;
        try (EntityDAO<StalniGost> stalniGostDao = DAOProducer.instance().produceGenericDAO(StalniGost.class);
             EntityDAO<Sto> stoDao = DAOProducer.instance().produceGenericDAO(Sto.class);
             KasaDAO kasaDao = DAOProducer.instance().produceDAO(KasaDAO.class);){
            NacinPlacanja nacinPlacanja = NacinPlacanja.GOTOVINA;
            Placanje placanje = new Placanje();
            placanje.setNacin(nacinPlacanja);
            placanje.setVreme(new Date());
            HashSet<Tura> ture = new HashSet<Tura>();
            List<StavkaRacuna> stavke = this.stavkaDao.stavkeZaPospremanjeFromSession();
            if (stavke.isEmpty()) {
                Racun racun = null;
                return racun;
            }
            Double suma = 0.0;
            Konobar konobar = server.konobarByMeniPromet();
            for (StavkaRacuna stavka : stavke) {
                if (result == null) {
                    result = new Racun();
                    result.setKonobar(stavka.getRacun().getKonobar());
                    result.setBrojStola(stavka.getBrojStola());
                    result.setFiskalniOdstampan(Boolean.FALSE);
                    result.setCrnoPlacanje(null);
                    result.setStavke1(new LinkedList<StavkaRacuna>());
                    result.setDatum(placanje.getVreme());
                    result.setPopust(0.0);
                    result.setZatvoren(Boolean.TRUE);
                    result.setBrojRacuna(this.racunDao.nextFiscalBillNumber());
                    result.setKasa(kasaDao.getCurrentCounterFromSession());
                    if (firmaSpremacice != null) {
                        result.setStalniGost(firmaSpremacice);
                        result.setBrojFakture(this.racunDao.nextInvoiceNumber());
                    }
                    result.setZdBroj(server.getLastOpenZD().getZdBroj());
                    placanje.setRacun(result);
                    result.setPlacanja(Arrays.asList(placanje));
                }
                if (!this.zaCiscenje.contains(stavka.getRacun())) {
                    this.zaCiscenje.add(stavka.getRacun());
                }
                StavkaRacuna sr = new StavkaRacuna();
                sr.setArtikal(stavka.getArtikal());
                sr.setKolicina(stavka.getKolicina());
                sr.setTura(stavka.getTura());
                sr.setBrojStola(stavka.getBrojStola());
                sr.setSaStola(null);
                sr.setNaziv(stavka.getNaziv());
                Double cena = stavka.getCena();
                sr.setRacun(result);
                sr.setCena(cena);
                sr.setPocetak(new Timestamp(new Date().getTime()));
                sr.setKraj(new Timestamp(new Date().getTime()));
                sr.setPripremljena(true);
                result.getStavke1().add(sr);
                suma = suma + (stavka.getVrednost() - stavka.getVrednost() * result.getPopust() / 100.0);
                if (stavka.getTura() == null) continue;
                stavka.getTura().setRacun(result);
                ture.add(stavka.getTura());
            }
            result.setTure(new LinkedList<Tura>(ture));
            placanje.setIznos(suma);
            result.setStorniran(Boolean.FALSE);
            result.setNaOsnovno(Boolean.FALSE);
            result.setNapomena("");
        }
        return result;
    }

    public Racun pocisti(Racun result) {
        try (TuraDAO turaDao = DAOProducer.instance().produceDAO(TuraDAO.class);){
            result.setBrojRacuna(this.racunDao.nextFiscalBillNumber());
            result.setZatvoren(Boolean.TRUE);
            this.racunDao.startSessionTransaction();
            if (result.isFaktura()) {
                result.setBrojFakture(this.racunDao.getAndIncreaseNextInvoiceNumberInSession());
            }
            result.setStavke1(result.getStavke());
            this.racunDao.persistInSession(result);
            this.stavkaDao.batchMergeInSession(result.getStavke1());
            turaDao.batchMergeInSession(result.getTure());
            ListIterator<Racun> li = this.zaCiscenje.listIterator();
            while (li.hasNext()) {
                Racun cistka = li.next();
                if ((cistka = this.racunDao.refreshInSession(cistka)) == null) {
                    li.remove();
                    continue;
                }
                li.set(cistka);
            }
            for (Racun racun : this.zaCiscenje) {
                this.stavkaDao.batchRemoveInSession(racun.getStavke1());
            }
            this.racunDao.batchRemoveInSession(this.zaCiscenje);
            this.racunDao.commitSessionTransaction();
            Racun racun = result;
            return racun;
        }
    }

    public Racun pocistiGotovinu(Racun result) {
        try (TuraDAO turaDao = DAOProducer.instance().produceDAO(TuraDAO.class);){
            result.setBrojRacuna(this.racunDao.nextFiscalBillNumber());
            result.setZatvoren(Boolean.TRUE);
            this.racunDao.startSessionTransaction();
            if (result.isFaktura()) {
                result.setBrojFakture(this.racunDao.getAndIncreaseNextInvoiceNumberInSession());
            }
            result.setStavke1(result.getStavke());
            this.racunDao.persistInSession(result);
            this.stavkaDao.batchMergeInSession(result.getStavke1());
            turaDao.batchMergeInSession(result.getTure());
            ListIterator<Racun> li = this.zaCiscenje.listIterator();
            while (li.hasNext()) {
                Racun cistka = li.next();
                if ((cistka = this.racunDao.refreshInSession(cistka)) == null) {
                    li.remove();
                    continue;
                }
                li.set(cistka);
            }
            for (Racun racun : this.zaCiscenje) {
                this.stavkaDao.batchRemoveInSession(racun.getStavke1());
            }
            this.racunDao.batchRemoveInSession(this.zaCiscenje);
            this.racunDao.commitSessionTransaction();
            Racun racun = result;
            return racun;
        }
    }

    @Override
    public void close() {
        this.zaCiscenje.clear();
        this.stavkaDao.close();
        this.racunDao.close();
    }
}

