/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.PorudzbinaNit;
import com.dev63.restoran.RacunNit;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.TipArtikla;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SkidanjeNormativa {
    public static Map<Artikal, Double> razloziArtikalZaUtrosak(Artikal a, double kolicina, RestoranServer server, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        kolicina = BigDecimal.valueOf(kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue();
        if (a.getTip().equals((Object)TipArtikla.SLOZ) || a.getTip().equals((Object)TipArtikla.DODA)) {
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeni(a, mapa, kolicina, server, datum)).get(a) != null) {
                d = mapa.get(a);
                mapa.put(a, kolicina + d);
            } else {
                mapa.put(a, kolicina);
            }
        } else if (a.getTip().equals((Object)TipArtikla.PROD)) {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, BigDecimal.valueOf(a.getMera() * kolicina + d).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
        } else {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, BigDecimal.valueOf(kolicina + d).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
        }
        return mapa;
    }

    public static Map<Artikal, Double> razloziArtikal(Artikal a, double kolicina, RestoranServer server, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        if (a.getName().equals("PITA BOROVNICA")) {
            System.out.println(a.getName());
        }
        kolicina = BigDecimal.valueOf(kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue();
        if (a.getTip().equals((Object)TipArtikla.SLOZ)) {
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeni(a, mapa, kolicina, server, datum)).get(a) != null) {
                d = mapa.get(a);
                mapa.put(a, kolicina + d);
            }
        } else if (a.getTip().equals((Object)TipArtikla.PROD)) {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, BigDecimal.valueOf(a.getMera() * kolicina + d).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
        } else {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, BigDecimal.valueOf(kolicina + d).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
        }
        return mapa;
    }

    public static Map<Artikal, Map<Odeljenje, Double>> razloziArtikalPoOdeljenju(Artikal a, double kolicina, RestoranServer server, Odeljenje o, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Map<Odeljenje, Double>> mapa = new HashMap<Artikal, Map<Odeljenje, Double>>();
        kolicina = BigDecimal.valueOf(kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue();
        if (a.getTip().equals((Object)TipArtikla.SLOZ)) {
            Map<Odeljenje, Double> mapaOd;
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeniPoOdeljenju(a, mapa, kolicina, server, datum)).get(a) != null && mapa.get(a).get(0) != null) {
                d = mapa.get(a).get(o);
            }
            if ((mapaOd = mapa.get(o)) == null) {
                mapaOd = new HashMap<Odeljenje, Double>();
            }
            mapaOd.put(o, BigDecimal.valueOf(d + kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
            mapa.put(a, mapaOd);
        } else if (a.getTip().equals((Object)TipArtikla.PROD)) {
            Map<Odeljenje, Double> mapaOd;
            double d = 0.0;
            if (mapa.get(a) != null && mapa.get(a).get(0) != null) {
                d = mapa.get(a).get(o);
            }
            if ((mapaOd = mapa.get(o)) == null) {
                mapaOd = new HashMap<Odeljenje, Double>();
            }
            mapaOd.put(o, BigDecimal.valueOf(d + a.getMera() * kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
            mapa.put(a, mapaOd);
        } else if (a.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Odeljenje, Double> mapaOd;
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeniPoOdeljenju(a, mapa, kolicina, server, datum)).get(a) != null && mapa.get(a).get(0) != null) {
                d = mapa.get(a).get(o);
            }
            if ((mapaOd = mapa.get(o)) == null) {
                mapaOd = new HashMap<Odeljenje, Double>();
            }
            mapaOd.put(o, BigDecimal.valueOf(d + kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
            mapa.put(a, mapaOd);
        } else {
            Map<Odeljenje, Double> mapaOd;
            double d = 0.0;
            if (mapa.get(a) != null && mapa.get(a).get(0) != null) {
                d = mapa.get(a).get(o);
            }
            if ((mapaOd = mapa.get(o)) == null) {
                mapaOd = new HashMap<Odeljenje, Double>();
            }
            mapaOd.put(o, BigDecimal.valueOf(d + kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
            mapa.put(a, mapaOd);
        }
        return mapa;
    }

    public static Map<Artikal, Double> razloziArtikalZaOtpis(Artikal a, double kolicina, RestoranServer server, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        if (a.getTip().equals((Object)TipArtikla.SLOZ) || a.getTip().equals((Object)TipArtikla.DODA)) {
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeni(a, mapa, kolicina, server, datum)).get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, kolicina + d);
        } else {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, kolicina + d);
        }
        return mapa;
    }

    public static Map<Artikal, Double> razloziArtikalPoluproizvod(Artikal a, double kolicina, RestoranServer server, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        double d = 0.0;
        mapa = SkidanjeNormativa.razloziPoluproizvod(a, mapa, kolicina, server, datum);
        if (mapa.get(a) != null) {
            d = mapa.get(a);
        }
        mapa.put(a, -kolicina + d);
        return mapa;
    }

    public static Map<Artikal, Double> razloziArtikalPoluproizvodProizvodnja(Artikal a, double kolicina, RestoranServer server, Date datum) {
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        mapa = SkidanjeNormativa.razloziPoluproizvod(a, mapa, kolicina, server, datum);
        return mapa;
    }

    public static Map<Artikal, Double> razloziSlozeni(Artikal a, Map<Artikal, Double> m, double kolicina, RestoranServer server, Date datum) {
        HashMap<Artikal, Double> mapa = new HashMap();
        mapa = m;
        kolicina = BigDecimal.valueOf(kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue();
        List<Normativ> normativi = server.readNormativ(a, datum);
        for (Normativ n : normativi) {
            n.setSastojak((Artikal)server.getBase().find(Artikal.class, (Object)n.getSastojak().getId()));
            try {
                n.getSastojak().setNijeDeoSlozenog(Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SLOZ)) {
                SkidanjeNormativa.razloziSlozeni(n.getSastojak(), mapa, kolicina * BigDecimal.valueOf(n.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue(), server, datum);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.POLU)) {
                SkidanjeNormativa.razloziSlozeni(n.getSastojak(), mapa, kolicina * BigDecimal.valueOf(n.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue(), server, datum);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.PROD)) {
                double d = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d = (Double)mapa.get(n.getSastojak());
                }
                double kol = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), BigDecimal.valueOf(d + kol).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SIRO)) {
                double d1 = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d1 = (Double)mapa.get(n.getSastojak());
                }
                double kol1 = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), BigDecimal.valueOf(d1 + kol1).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                continue;
            }
            double d2 = 0.0;
            if (mapa.get(n.getSastojak()) != null) {
                d2 = (Double)mapa.get(n.getSastojak());
            }
            double kol2 = n.getKolicina() * kolicina;
            n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
            mapa.put(n.getSastojak(), BigDecimal.valueOf(d2 + kol2).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
        }
        return mapa;
    }

    public static Map<Artikal, Map<Odeljenje, Double>> razloziSlozeniPoOdeljenju(Artikal a, Map<Artikal, Map<Odeljenje, Double>> m, double kolicina, RestoranServer server, Date datumRacuna) {
        HashMap<Artikal, Map<Odeljenje, Double>> mapa = new HashMap();
        mapa = m;
        kolicina = BigDecimal.valueOf(kolicina).setScale(4, RoundingMode.HALF_EVEN).doubleValue();
        List<Normativ> normativi = server.readNormativ(a, datumRacuna);
        if (normativi != null) {
            for (Normativ n : normativi) {
                Map<Odeljenje, Double> mapaOd;
                try {
                    n.getSastojak().setNijeDeoSlozenog(Boolean.FALSE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (n.getSastojak().getTip().equals((Object)TipArtikla.SLOZ) || n.getSastojak().getTip().equals((Object)TipArtikla.DODA)) {
                    Logger.getLogger(SkidanjeNormativa.class.getName()).log(Level.INFO, "Artikal je " + a.getName() + ", sa ID=" + a.getId());
                    SkidanjeNormativa.razloziSlozeniPoOdeljenju(n.getSastojak(), mapa, kolicina * BigDecimal.valueOf(n.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue(), server, datumRacuna);
                    continue;
                }
                if (n.getSastojak().getTip().equals((Object)TipArtikla.PROD)) {
                    double d = 0.0;
                    if (mapa.get(n.getSastojak()) != null && ((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje()) != null) {
                        d = (Double)((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje());
                    }
                    double kol = n.getKolicina() * kolicina;
                    n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                    mapaOd = (HashMap<Odeljenje, Double>)mapa.get(n.getSastojak());
                    if (mapaOd == null) {
                        mapaOd = new HashMap<Odeljenje, Double>();
                    }
                    mapaOd.put(n.getOdeljenje(), BigDecimal.valueOf(d + kol).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    mapa.put(n.getSastojak(), mapaOd);
                    continue;
                }
                if (n.getSastojak().getTip().equals((Object)TipArtikla.SIRO)) {
                    double d1 = 0.0;
                    if (mapa.get(n.getSastojak()) != null && ((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje()) != null) {
                        d1 = (Double)((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje());
                    }
                    double kol1 = n.getKolicina() * kolicina;
                    n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                    mapaOd = (Map)mapa.get(n.getSastojak());
                    if (mapaOd == null) {
                        mapaOd = new HashMap();
                    }
                    mapaOd.put(n.getOdeljenje(), BigDecimal.valueOf(d1 + kol1).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    mapa.put(n.getSastojak(), mapaOd);
                    continue;
                }
                double d2 = 0.0;
                if (mapa.get(n.getSastojak()) != null && ((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje()) != null) {
                    d2 = (Double)((Map)mapa.get(n.getSastojak())).get(n.getOdeljenje());
                }
                double kol2 = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapaOd = (Map)mapa.get(n.getSastojak());
                if (mapaOd == null) {
                    mapaOd = new HashMap();
                }
                mapaOd.put(n.getOdeljenje(), BigDecimal.valueOf(d2 + kol2).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                mapa.put(n.getSastojak(), mapaOd);
            }
        }
        return mapa;
    }

    public static Map<Artikal, Double> razloziPoluproizvod(Artikal a, Map<Artikal, Double> m, double kolicina, RestoranServer server, Date datum) {
        HashMap<Artikal, Double> mapa = new HashMap();
        mapa = m;
        List<Normativ> normativi = server.readNormativ(a, datum);
        for (Normativ n : normativi) {
            try {
                n.getSastojak().setNijeDeoSlozenog(Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SLOZ) || n.getSastojak().getTip().equals((Object)TipArtikla.DODA)) {
                SkidanjeNormativa.razloziSlozeni(n.getSastojak(), mapa, kolicina * n.getKolicina(), server, datum);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.PROD) || n.getSastojak().getTip().equals((Object)TipArtikla.POLU)) {
                double d = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d = (Double)mapa.get(n.getSastojak());
                }
                double kol = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), d + kol);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SIRO)) {
                double d1 = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d1 = (Double)mapa.get(n.getSastojak());
                }
                double kol1 = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), d1 + kol1);
                continue;
            }
            double d2 = 0.0;
            if (mapa.get(n.getSastojak()) != null) {
                d2 = (Double)mapa.get(n.getSastojak());
            }
            double kol2 = n.getKolicina() * kolicina;
            n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
            mapa.put(n.getSastojak(), d2 + kol2);
        }
        return mapa;
    }

    public static void napraviKartice(Map<Artikal, Double> mapa, RestoranServer server, String dokument, int sekunde, Boolean crno, Odeljenje odeljenje) {
        Date date = Konstante.getDatumKartica(new Date(), server, sekunde);
        if (crno != null) {
            Konstante.executor.execute(new RacunNit(server, mapa, date, dokument, crno, odeljenje));
        } else {
            Konstante.executor.execute(new PorudzbinaNit(server, mapa, date, odeljenje));
        }
    }

    public static double napraviKarticeF(Map<Artikal, Double> mapa, RestoranServer server, String dokument, int sekunde, Boolean crno, Date datum) {
        double vrednost = 0.0;
        Date date = Konstante.getDatumKartica(datum, server, sekunde);
        for (Artikal a1 : mapa.keySet()) {
            Artikal a = server.getArtikal(a1.getName());
            a.setNijeDeoSlozenog(a1.getNijeDeoSlozenog());
            Odeljenje o = a.getOdeljenjeNormativ() == null ? a.getOdeljenje() : a.getOdeljenjeNormativ();
            Kartica kartica = server.getLastKartica(a, o, date, crno);
            if (kartica == null) {
                a.setOdeljenjeNormativ(o);
                kartica = new Kartica();
                kartica.setArtikal(a);
                kartica.setOdeljenje(o);
                kartica.setCrno(crno);
                kartica.setKolicina(-mapa.get(a).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                    kartica.setIzlazKOM((int)(mapa.get(a) / a.getMera()));
                }
                kartica.setDatum(date);
                kartica.setNabavnaCena(a.getTrenutnaNV());
                kartica.setDokument(dokument);
                server.addKartica(kartica);
                vrednost += a.getTrenutnaNV() != 0.0 ? a.getTrenutnaNV() : server.getLastNabavnaCenaBela(a, new Date()) * -kartica.getKolicina().doubleValue();
                continue;
            }
            a.setOdeljenjeNormativ(o);
            double kol = kartica.getKolicina();
            kartica.setKolicina(kol -= mapa.get(a).doubleValue());
            if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                int d = kartica.getIzlazKOM() != null ? kartica.getIzlazKOM() : 0;
                kartica.setIzlazKOM(d + (int)(mapa.get(a) / a.getMera()));
            }
            kartica.setNabavnaCena(a.getTrenutnaNV());
            server.updateKartica(kartica);
            vrednost += a.getTrenutnaNV() != 0.0 ? a.getTrenutnaNV() : server.getLastNabavnaCenaBela(a, new Date()) * mapa.get(a);
        }
        return vrednost;
    }

    public static List<Kartica> napraviKartice2(Map<Artikal, Double> mapa, RestoranServer server, Date d) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        Date date = Konstante.getDatumKartica(d, server, 35);
        for (Artikal a : mapa.keySet()) {
            Odeljenje o = a.getOdeljenjeNormativ() == null ? server.getOdeljenjeArtikalBezMag2(a.getId()).get(0) : a.getOdeljenjeNormativ();
            Kartica kartica = new Kartica();
            kartica = new Kartica();
            kartica.setArtikal(a);
            kartica.setOdeljenje(o);
            kartica.setKolicina(-mapa.get(a).doubleValue());
            if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                kartica.setIzlazKOM((int)(mapa.get(a) / a.getMera()));
            }
            kartica.setDatum(date);
            kartica.setNabavnaCena(a.getTrenutnaNV());
            kartice.add(kartica);
        }
        return kartice;
    }

    public static List<Kartica> napraviKarticeOdeljenje2(Map<Artikal, Double> mapa, RestoranServer server, Odeljenje odeljenje, Date d) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        Date date = Konstante.getDatumKartica(d, server, 35);
        for (Artikal a1 : mapa.keySet()) {
            try {
                Artikal a = server.getArtikal(a1.getName());
                Odeljenje o = a.getOdeljenjeNormativ() == null ? a.getOdeljenje() : a.getOdeljenjeNormativ();
                if (!o.equals(odeljenje)) continue;
                Kartica kartica = new Kartica();
                a.setOdeljenjeNormativ(o);
                kartica = new Kartica();
                kartica.setArtikal(a);
                kartica.setOdeljenje(o);
                kartica.setKolicina(-mapa.get(a).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                    kartica.setIzlazKOM((int)Math.round(mapa.get(a) / a.getMera()));
                }
                kartica.setDatum(date);
                kartica.setNabavnaCena(a.getTrenutnaNV());
                kartice.add(kartica);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                server.fine("Izlazak iz programa", SkidanjeNormativa.class);
                System.exit(0);
            }
        }
        return kartice;
    }

    public static List<Kartica> napraviKarticeOdeljenjeRek(Map<Artikal, Double> mapa, RestoranServer server, Odeljenje odeljenje, Date d) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        for (Artikal a1 : mapa.keySet()) {
            try {
                Artikal a = server.getArtikal(a1.getName());
                Odeljenje o = a.getOdeljenjeNormativ();
                Kartica kartica = new Kartica();
                a.setOdeljenjeNormativ(o);
                kartica.setArtikal(a);
                kartica.setOdeljenje(o);
                kartica.setKolicina(-mapa.get(a).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                    kartica.setIzlazKOM((int)Math.round(mapa.get(a) / a.getMera()));
                }
                kartica.setDatum(d);
                kartica.setNabavnaCena(a.getTrenutnaNV());
                kartice.add(kartica);
            }
            catch (Exception e) {
                e.printStackTrace();
                server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                server.fine("Izlazak iz programa", SkidanjeNormativa.class);
                System.exit(0);
            }
        }
        return kartice;
    }

    public static List<Kartica> napraviKarticeOdeljenjeRekPoOdeljenju(Map<Artikal, Map<Odeljenje, Double>> mapa, RestoranServer server, Odeljenje odeljenje, Date d) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        for (Artikal a1 : mapa.keySet()) {
            Map<Odeljenje, Double> mapaOd = mapa.get(a1);
            for (Odeljenje od : mapaOd.keySet()) {
                try {
                    Artikal a = server.getArtikal(a1.getName());
                    Odeljenje o = od;
                    Kartica kartica = new Kartica();
                    a.setOdeljenjeNormativ(o);
                    kartica.setArtikal(a);
                    kartica.setOdeljenje(o);
                    kartica.setKolicina(-mapa.get(a).get(o).doubleValue());
                    if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                        kartica.setIzlazKOM((int)Math.round(mapa.get(a).get(o) / a.getMera()));
                    }
                    kartica.setDatum(d);
                    kartica.setNabavnaCena(a.getTrenutnaNV());
                    kartice.add(kartica);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                    server.fine("Izlazak iz programa", SkidanjeNormativa.class);
                    System.exit(0);
                }
            }
        }
        return kartice;
    }

    public static List<Kartica> napraviKarticeOdeljenje22(Map<Artikal, Double> mapa, RestoranServer server, Odeljenje odeljenje, Date d) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        Date date = Konstante.getDatumKartica(d, server, 35);
        for (Artikal a : mapa.keySet()) {
            try {
                Odeljenje o = a.getOdeljenjeNormativ() == null ? server.getOdeljenjeArtikalBezMag2(a.getId()).get(0) : a.getOdeljenjeNormativ();
                if (!o.equals(odeljenje)) continue;
                Kartica kartica = new Kartica();
                a.setOdeljenjeNormativ(o);
                kartica = new Kartica();
                kartica.setArtikal(a);
                kartica.setOdeljenje(o);
                kartica.setKolicina(-mapa.get(a).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                    kartica.setIzlazKOM((int)(mapa.get(a) / a.getMera()));
                }
                kartica.setDatum(date);
                kartica.setNabavnaCena(a.getTrenutnaNV());
                kartice.add(kartica);
            }
            catch (Exception e) {
                e.printStackTrace();
                server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                server.fine("Izlazak iz programa", SkidanjeNormativa.class);
                System.exit(0);
            }
        }
        return kartice;
    }

    public static void napraviStornoKartice(Map<Artikal, Double> mapa, RestoranServer server) {
        server.refresh();
        try {
            Date date = Konstante.getDatumKartica(new Date(), server, 34);
            for (Artikal ar : mapa.keySet()) {
                Artikal a = server.ArtikalByName(ar.getName());
                Odeljenje o = a.getOdeljenjeNormativ() == null ? a.getOdeljenje() : a.getOdeljenjeNormativ();
                Logger.getLogger(SkidanjeNormativa.class.getName()).info("Storniranje artikla: [id]" + a.getId() + ", [odeljenje]" + a.getOdeljenje() + ", [odeljenjeNormativ]" + a.getOdeljenjeNormativ());
                Kartica kartica = server.getLastKartica(a, o, date, null);
                double kol = kartica.getKolicina();
                if ((kol += mapa.get(a).doubleValue()) == 0.0) {
                    server.deleteKartica(kartica);
                    continue;
                }
                kartica.setKolicina(kol);
                if (a.getTip().equals((Object)TipArtikla.PROD) && (a.getNijeDeoSlozenog() == null || a.getNijeDeoSlozenog().booleanValue())) {
                    kartica.setIzlazKOM(kartica.getIzlazKOM() + (int)(-mapa.get(a).doubleValue() / a.getMera()));
                }
                server.updateKartica(kartica);
            }
        }
        catch (Exception exc) {
            Logger.getLogger(SkidanjeNormativa.class.getName()).log(Level.SEVERE, null, exc);
        }
    }

    public static Map<Artikal, Double> razloziArtikal2(Artikal a, double kolicina, RestoranServer server, Map<Long, List<Normativ>> mapaN, Map<Long, Artikal> mapaA) {
        Logger.getLogger(SkidanjeNormativa.class.getName()).log(Level.FINER, "Razlaganje #2, artikal " + a.getName() + ", id = " + a.getId());
        a.setNijeDeoSlozenog(Boolean.TRUE);
        Map<Artikal, Double> mapa = new HashMap<Artikal, Double>();
        if (a.getTip().equals((Object)TipArtikla.SLOZ)) {
            double d = 0.0;
            if ((mapa = SkidanjeNormativa.razloziSlozeni2(a, mapa, kolicina, server, mapaN, mapaA)).get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, kolicina + d);
        } else if (a.getTip().equals((Object)TipArtikla.PROD)) {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, a.getMera() * kolicina + d);
        } else {
            double d = 0.0;
            if (mapa.get(a) != null) {
                d = mapa.get(a);
            }
            mapa.put(a, kolicina + d);
        }
        return mapa;
    }

    public static Map<Artikal, Double> razloziSlozeni2(Artikal a, Map<Artikal, Double> m, double kolicina, RestoranServer server, Map<Long, List<Normativ>> mapaN, Map<Long, Artikal> mapaA) {
        List<Normativ> normativi;
        HashMap<Artikal, Double> mapa = new HashMap();
        mapa = m;
        if (mapaN != null) {
            normativi = mapaN.get(a.getId());
            if (normativi == null) {
                normativi = server.getNormativiByLastNormativiArtikal(a.getId());
            }
        } else {
            normativi = server.getNormativiByLastNormativiArtikal(a.getId());
        }
        for (Normativ n : normativi) {
            System.out.println(server.getArtikal(n.getArtikal().getId()));
            if (mapaA == null) {
                n.setSastojak(server.getArtikal(n.getSastojak().getId()));
            } else if (mapaA.get(n.getSastojak().getId()) == null) {
                n.setSastojak(server.getArtikal(n.getSastojak().getId()));
            } else {
                n.setSastojak(mapaA.get(n.getSastojak().getId()));
            }
            try {
                n.getSastojak().setNijeDeoSlozenog(Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SLOZ) || n.getSastojak().getTip().equals((Object)TipArtikla.POLU)) {
                SkidanjeNormativa.razloziSlozeni2(n.getSastojak(), mapa, kolicina * n.getKolicina(), server, mapaN, mapaA);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.PROD)) {
                double d = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d = (Double)mapa.get(n.getSastojak());
                }
                double kol = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), d + kol);
                continue;
            }
            if (n.getSastojak().getTip().equals((Object)TipArtikla.SIRO)) {
                double d1 = 0.0;
                if (mapa.get(n.getSastojak()) != null) {
                    d1 = (Double)mapa.get(n.getSastojak());
                }
                double kol1 = n.getKolicina() * kolicina;
                n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
                mapa.put(n.getSastojak(), d1 + kol1);
                continue;
            }
            double d2 = 0.0;
            if (mapa.get(n.getSastojak()) != null) {
                d2 = (Double)mapa.get(n.getSastojak());
            }
            double kol2 = n.getKolicina() * kolicina;
            n.getSastojak().setOdeljenjeNormativ(n.getOdeljenje());
            mapa.put(n.getSastojak(), d2 + kol2);
        }
        return mapa;
    }
}

