/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.FrontOffice3;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.Logs;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.StavkeSumarno;
import com.dev63.restoran.Utrosci;
import com.dev63.restoran.apoteka.GlobRecRunner;
import com.dev63.restoran.backoffice.radkonobara.StoBMaster;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.db.BMDBUtil;
import com.dev63.restoran.db.queries.Queries;
import com.dev63.restoran.db.queries.QueryName;
import com.dev63.restoran.izvestaji.nivelacija.NivelacijaRow;
import com.dev63.restoran.jpa.JPAUtil;
import com.dev63.restoran.jpa.SingletonEmReference;
import com.dev63.restoran.license.UnosPiba;
import com.dev63.restoran.model.AdministracijaPopusta;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.ArtikalAtribut;
import com.dev63.restoran.model.ArtikalTarget;
import com.dev63.restoran.model.ArtikalText;
import com.dev63.restoran.model.Atribut;
import com.dev63.restoran.model.BObject;
import com.dev63.restoran.model.Brojac;
import com.dev63.restoran.model.Cena;
import com.dev63.restoran.model.CenaZaDan;
import com.dev63.restoran.model.Cenovnici;
import com.dev63.restoran.model.CenovniciStavka;
import com.dev63.restoran.model.Cenovnik;
import com.dev63.restoran.model.CenovnikDetalji;
import com.dev63.restoran.model.CenovnikStavka;
import com.dev63.restoran.model.CenovnikTip;
import com.dev63.restoran.model.Country;
import com.dev63.restoran.model.CrnoPlacanje;
import com.dev63.restoran.model.DnevniCenovnik;
import com.dev63.restoran.model.DnevniCenovnikStavka;
import com.dev63.restoran.model.DnevniUtrosak;
import com.dev63.restoran.model.DnevnoStanje;
import com.dev63.restoran.model.EvidencijaZaposlenih;
import com.dev63.restoran.model.GlavniMeni;
import com.dev63.restoran.model.GlavniMeniLogin;
import com.dev63.restoran.model.GlavniMeniPodgrupa;
import com.dev63.restoran.model.GlavniMeniPodgrupaLogin;
import com.dev63.restoran.model.GrafikSale;
import com.dev63.restoran.model.GrupaArtikala;
import com.dev63.restoran.model.GrupaOA;
import com.dev63.restoran.model.GrupaOdeljenja;
import com.dev63.restoran.model.GrupaTroskova;
import com.dev63.restoran.model.GrupaZaposlenih;
import com.dev63.restoran.model.HacapMagacini;
import com.dev63.restoran.model.IDKartica;
import com.dev63.restoran.model.Izvod;
import com.dev63.restoran.model.IzvodStavka;
import com.dev63.restoran.model.JediniceMere;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.KasaGrafik;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Komitent;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.KonobarTarget;
import com.dev63.restoran.model.LogRecord;
import com.dev63.restoran.model.Login;
import com.dev63.restoran.model.Meni;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.NormativArtikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Otpis;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.OtpisUtrosak;
import com.dev63.restoran.model.Placanje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Popis;
import com.dev63.restoran.model.Popust;
import com.dev63.restoran.model.PregledStolova;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.ProdajnoMesto;
import com.dev63.restoran.model.Proizvodnja;
import com.dev63.restoran.model.ProizvodnjaStavka;
import com.dev63.restoran.model.ProizvodnjaUtrosak;
import com.dev63.restoran.model.PrometArtikala;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Rezervacija;
import com.dev63.restoran.model.Rokovnik;
import com.dev63.restoran.model.RokovnikTipUnosa;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.Sifarnik;
import com.dev63.restoran.model.Sifra;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostPretplata;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.Stampac;
import com.dev63.restoran.model.StavkaPopisa;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.StoNaziv;
import com.dev63.restoran.model.StoPrikaz;
import com.dev63.restoran.model.Storno;
import com.dev63.restoran.model.StornoStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipBrojaca;
import com.dev63.restoran.model.TipDokumenta;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.TipTrebovanja;
import com.dev63.restoran.model.Trebovanje;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.model.Trosak;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.model.UtrosakDoc;
import com.dev63.restoran.model.UtrosakDocStavke;
import com.dev63.restoran.model.UtrosakDocUtrosak;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.model.Zaposleni;
import com.dev63.restoran.model.controller.KasaController;
import com.dev63.restoran.model.controller.SettingController;
import com.dev63.restoran.model.dao.DAOProducer;
import com.dev63.restoran.model.dao.EntityDAO;
import com.dev63.restoran.model.enums.MeniPodgrupe;
import com.dev63.restoran.patches.MeniPodgrupaPatch;
import com.dev63.restoran.setup.IzborDrzaveIJezika;
import com.dev63.restoran.sistem.parts.ThreeTypeWrapper;
import com.dev63.restoran.sistem.parts.TwoTypeWrapper;
import com.dev63.restoran.stampa.StampaStorna;
import com.dev63.restoran.swt.resources.BrandingCache;
import com.dev63.restoran.swt.resources.BrandingData;
import com.dev63.restoran.utils.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class RestoranServer {
    private EntityManager base;
    private SingletonEmReference baseReference;
    private EntityManagerFactory factory;
    private Login user;
    private static final Logger log = Logger.getLogger(RestoranServer.class.getName());
    ResultSet r;
    private static String p;
    int x = 0;
    private Query qGetLastKartica;
    private Query qGetArtikalByName;
    private Query qGetKomitentByName;
    private Query qGetKomitentBySG;
    private Query qGetKomitentById;
    Query qBeloZavrsnoStanjeZaOdeljenje;
    Query qCrnoZavrsnoStanjeZaOdeljenje;
    Query qZavrsnoStanjeZaOdeljenje;
    private GlobRecRunner receptRunner;
    private final Restoran restoran;
    private String dbUser;
    private String dbPass;
    private String schemaName;
    private Map<Object, EntityDAO> entityDAOMap;
    private Shell shell = null;
    Setting adrs = BMTerminalSettings.getSetting(OptionBO.ADRESA);
    Setting db = BMTerminalSettings.getSetting(OptionBO.BAZA);
    Setting lozinka = BMTerminalSettings.getSetting(OptionBO.PASS);
    Setting korisnik = BMTerminalSettings.getSetting(OptionBO.USER);
    private String dbserver = this.adrs.stringValue();
    private String database = this.db.stringValue();
    private String pass = this.lozinka.stringValue();
    private String useR = this.korisnik.stringValue();
    private Connection conn;

    public EntityManager getBase() {
        return this.baseReference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getAnalizaProdajePoSatima(Date datum1, Date datum2, EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap) {
        String procedura = "analiza_prodaje_po_satima";
        LinkedList<Map<String, Object>> ppaArticleData = new LinkedList<Map<String, Object>>();
        EntityManager em = this.getEM();
        if (!this.hasProcedure(procedura)) {
            this.createProcedurePoSatima();
        }
        try {
            String pBelap = "";
            String pCrnap = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            StringBuilder qBuilder = new StringBuilder("CALL `" + procedura + "`('" + new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(datum1) + "','" + new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(datum2) + "','" + pBelap + "', '" + pCrnap + "')");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            ppaArticleData.addAll(ppa.getResultList());
            LinkedList<Map<String, Object>> linkedList = ppaArticleData;
            return linkedList;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public RestoranServer(EntityManagerFactory factory, EntityManager manager, SingletonEmReference emReference, String putanja, Restoran restoran, String dbUser, String dbPass, String schemaName) {
        this.factory = factory;
        this.base = manager;
        this.baseReference = emReference;
        this.restoran = restoran;
        p = putanja;
        this.dbUser = dbUser;
        this.dbPass = dbPass;
        this.schemaName = schemaName;
        this.initData();
    }

    public <D extends EntityDAO> D createDAOInstance(Class<D> daoClass) {
        return DAOProducer.instance().produceDAO(daoClass);
    }

    private EntityManager getEM() {
        EntityManager em = this.factory.createEntityManager();
        em.setFlushMode(FlushModeType.COMMIT);
        return em;
    }

    public Connection getConnection() {
        try {
            if (this.conn == null || this.conn.isClosed()) {
                try {
                    this.conn = DriverManager.getConnection("jdbc:mysql://" + this.dbserver + "/" + this.database + "?user=" + this.useR + "&password=" + this.pass + "&useSSL=false&dontTrackOpenResources=true&zeroDateTimeBehavior=convertToNull&autoReconnect=true");
                }
                catch (SQLException e) {
                    LogUtils.severe(e, "Cannot connect to database server", new Object[0]);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.conn;
    }

    private void initData() {
        this.qCrnoZavrsnoStanjeZaOdeljenje = this.base.createQuery("SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum < :d and k.odeljenje = :od and k.artikal in :arts and k.artikal.tip <> :t and k.artikal.blokiran = false and (k.crno is not null and k.crno = true) group by k.artikal");
        this.qBeloZavrsnoStanjeZaOdeljenje = this.base.createQuery("SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum < :d and k.odeljenje = :od and k.artikal in :arts and k.artikal.tip <> :t and k.artikal.blokiran = false and (k.crno is null or k.crno = false) group by k.artikal");
        this.qZavrsnoStanjeZaOdeljenje = this.base.createQuery("SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum < :d and k.odeljenje = :od and k.artikal in :arts and k.artikal.tip <> :t and k.artikal.blokiran = false group by k.artikal");
        if (this.getSettings().size() < 1) {
            for (Option o : Option.values()) {
                if (o.getDiefault() == null) continue;
                Setting s = new Setting();
                s.setActual(o.getDiefault());
                s.setName(o.getName());
                this.changeSetting(s);
            }
        }
        Setting s = this.getSetting(Option.OBJEKAT_PIB);
        Setting ss = this.getSetting(Option.OBJEKAT_DRZAVA);
        if (ss == null || ss.stringValue() == null || ss.stringValue().length() == 0 || Country.findByEnumName(ss.stringValue()) == null) {
            Display display = Display.getCurrent();
            IzborDrzaveIJezika idj = new IzborDrzaveIJezika(display);
            if (idj.getCountry() == null || idj.getLanguage() == null) {
                if (display != null && !display.isDisposed()) {
                    display.dispose();
                }
                this.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                this.fine("Izlazak iz programa", this.getClass());
                System.exit(0);
            } else {
                BMTerminalSettings.setCurLanguage(idj.getLanguage().getName());
                if (ss == null) {
                    ss = new Setting();
                }
                ss.setName(Option.OBJEKAT_DRZAVA.getName());
                ss.setActual(idj.getCountry().name());
                this.changeSetting(ss);
            }
        }
        if (s == null || s.stringValue() == null || s.stringValue().length() == 0) {
            Display display = Display.getCurrent();
            UnosPiba up = new UnosPiba(display);
            if (up.getPib() == null || up.getPib().length() == 0) {
                if (display != null && !display.isDisposed()) {
                    display.dispose();
                }
                this.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                this.fine("Izlazak iz programa", this.getClass());
                System.exit(0);
            } else {
                if (s == null) {
                    s = new Setting();
                }
                s.setName(Option.OBJEKAT_PIB.getName());
                s.setActual(up.getPib());
                this.changeSetting(s);
                if (up.getPibPrefix() != null && up.getPibPrefix().length() > 0) {
                    Setting sss = this.getSetting(Option.OBJEKAT_PIB_PREFIX);
                    if (sss == null) {
                        sss = new Setting();
                    }
                    sss.setName(Option.OBJEKAT_PIB_PREFIX.getName());
                    sss.setActual(up.getPibPrefix());
                    this.changeSetting(ss);
                }
            }
        }
        if (this.readGlavniMeni().size() < 1) {
            this.initialGlavniMeni();
        }
        if (this.readGlavniMeniPodgrupe().size() < 1) {
            this.initialMeniPodgrupe();
        } else {
            MeniPodgrupaPatch patch = new MeniPodgrupaPatch(this);
            patch.insertMissingMeniPodgrupe();
        }
        if (this.readGlavniMeniLogin().isEmpty()) {
            this.initialGlavniMeniLogin();
        }
        if (this.readGlavniMeniPodgrupaLogin().isEmpty()) {
            this.initialGlavniMeniPodgrupaLogin();
        }
        if (this.readOdeljenje().size() < 1) {
            this.initialOdeljenja();
        }
        if (this.readGrupeStGosti().size() < 1) {
            this.initialStalniGostiGrupe();
        }
        if (this.readSvaCrnaPlacanja().size() < 1) {
            this.initialMedjuzbir();
        }
        if (this.getSifre().isEmpty()) {
            this.initialSifre();
        }
        this.qGetLastKartica = this.base.createQuery("SELECT k FROM Kartica k WHERE k.artikal = :artikal AND k.odeljenje = :o AND k.crno = :c and k.datum=:date");
        this.qGetArtikalByName = this.base.createQuery("SELECT o FROM Artikal o WHERE o.name = :n");
        this.qGetKomitentByName = this.base.createQuery("SELECT k FROM Komitent k WHERE k.naziv = :n");
        this.qGetKomitentBySG = this.base.createQuery("SELECT k FROM Komitent k WHERE k.sg = :sg");
        this.qGetKomitentById = this.base.createQuery("SELECT k FROM Komitent k WHERE k.id = :n");
        if (this.getSetting(Option.APOTEKA).booleanValue() && this.restoran.getServerBO().getSetting(OptionBO.APOTEKA_GR_INTEGRACIJA).booleanValue()) {
            this.receptRunner = new GlobRecRunner(this.base.getEntityManagerFactory().createEntityManager(), this.restoran, false);
            this.receptRunner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialSifre() {
        LinkedList<Sifra> sList = new LinkedList<Sifra>();
        Sifra ss = new Sifra();
        ss.setSifarnik(Sifarnik.ZAKLJUCENJE);
        ss.setSifra("999");
        sList.add(ss);
        ss = new Sifra();
        ss.setSifarnik(Sifarnik.PRESEK);
        ss.setSifra("888");
        sList.add(ss);
        ss = new Sifra();
        ss.setSifarnik(Sifarnik.PERIODICNI);
        ss.setSifra("777");
        sList.add(ss);
        ss = new Sifra();
        ss.setSifarnik(Sifarnik.IZLAZAK);
        ss.setSifra("9988");
        sList.add(ss);
        ss = new Sifra();
        ss.setSifarnik(Sifarnik.PROMETKONOB);
        ss.setSifra("333");
        sList.add(ss);
        EntityManager em = null;
        EntityTransaction trans = null;
        try {
            em = this.getEM();
            trans = em.getTransaction();
            trans.begin();
            for (Sifra sifra : sList) {
                em.persist((Object)sifra);
            }
            trans.commit();
        }
        catch (Exception ex) {
            if (trans != null && trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.SEVERE, "Greska kod unosa inicijalnih sifara", ex);
        }
        finally {
            if (em != null && em.isOpen()) {
                em.close();
            }
        }
    }

    public Setting getSetting(Option option) {
        if (option == null) {
            return null;
        }
        return SettingController.loadSettingOrDefault(option);
    }

    public List<Setting> getSettings() {
        return SettingController.loadAllCommonSettings();
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new IllegalArgumentException("Connection is null!");
        }
        return BMDBUtil.prepareStatement(conn, sql, params);
    }

    public void changeSetting(Setting in) {
        try {
            SettingController.saveSetting(in);
        }
        catch (Exception e) {
            LogUtils.warn(e, "Error changing setting!", new Object[0]);
        }
    }

    void initialGlavniMeni() {
        this.base.getTransaction().begin();
        GlavniMeni artikli = new GlavniMeni("Artikli");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Stalni Gosti");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Evidencija zaposlenih");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Izvestaji prodaje");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Zakonska dokumenta");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Izvestaji zaliha");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Pregled");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Analiza i statistika");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Planovi i realizacija");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Blagajna");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Finansijska operativa");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Korisnica podesavanja");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Servisne operacije");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Fiskalni uredjaj");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Rokovnik");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Grafik sale");
        this.base.persist((Object)artikli);
        artikli = new GlavniMeni("Rezervacije");
        this.base.persist((Object)artikli);
        this.base.getTransaction().commit();
    }

    void initialMeniPodgrupe() {
        GlavniMeniPodgrupa meniPodgrupa = null;
        this.base.getTransaction().begin();
        for (MeniPodgrupe mp : MeniPodgrupe.values()) {
            meniPodgrupa = new GlavniMeniPodgrupa(mp.getNaziv(), mp.getGrupaId(), mp.isVidljiv());
            this.base.persist((Object)meniPodgrupa);
        }
        this.base.getTransaction().commit();
    }

    void initialGlavniMeniLogin() {
        for (Login login : this.getLogins()) {
            for (GlavniMeni glavniMeni : this.readGlavniMeni()) {
                GlavniMeniLogin glavniMeniLogin = new GlavniMeniLogin();
                glavniMeniLogin.setLoginId(login.getId());
                glavniMeniLogin.setGlavniMeniId(glavniMeni.getId());
                this.base.getTransaction().begin();
                this.base.persist((Object)glavniMeniLogin);
                this.base.getTransaction().commit();
            }
        }
    }

    void initialGlavniMeniPodgrupaLogin() {
        for (Login login : this.getLogins()) {
            for (GlavniMeniPodgrupa gmp : this.readGlavniMeniPodgrupe()) {
                GlavniMeniPodgrupaLogin gmpLogin = new GlavniMeniPodgrupaLogin(login.getId(), gmp.getId(), gmp.getNaziv());
                this.base.getTransaction().begin();
                this.base.persist((Object)gmpLogin);
                this.base.getTransaction().commit();
            }
        }
    }

    void initialOdeljenja() {
        GrupaOdeljenja go = new GrupaOdeljenja();
        go.setNaziv(String.format(Konstante.getBundle().getString("TEXT_SKLADISTA"), new Object[0]).toUpperCase());
        go.setSkladista(Boolean.TRUE);
        Odeljenje o = new Odeljenje();
        o.setNaziv(String.format(Konstante.getBundle().getString("OD_MAGACIN"), new Object[0]));
        o.setKratkiNaziv(String.format(Konstante.getBundle().getString("TEXT_MAGACIN_SKR"), new Object[0]));
        o.setMagacin(Boolean.TRUE);
        o.setJelo(Boolean.FALSE);
        o.setPice(Boolean.FALSE);
        o.setSlika("C:\\BarMaster\\image\\odeljenja\\magacin.gif");
        o.setGrupaOdeljenja(go);
        this.base.getTransaction().begin();
        this.base.persist((Object)go);
        this.base.persist((Object)o);
        this.base.getTransaction().commit();
    }

    void initialMedjuzbir() {
        CrnoPlacanje cp = new CrnoPlacanje();
        cp.setNaziv(String.format(Konstante.getBundle().getString("CP_MEDJUZBIR"), new Object[0]));
        cp.setHeader1(String.format(Konstante.getBundle().getString("TEXT_MEDJUZBIR"), new Object[0]));
        cp.setHeader2("");
        cp.setHeader3("");
        cp.setFooter1("");
        cp.setFooter2("");
        cp.setFooter3("");
        cp.setBrKopija(1);
        cp.setSifra("999999999");
        cp.setStampac(null);
        cp.setMedjuZbir(Boolean.TRUE);
        cp.setPrikazEkran(Boolean.FALSE);
        cp.setPrikazIzvestaji(Boolean.TRUE);
        this.base.getTransaction().begin();
        this.base.persist((Object)cp);
        this.base.getTransaction().commit();
    }

    void initialStalniGostiGrupe() {
        this.base.getTransaction().begin();
        StalniGostiGrupa o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_INDIVIDUALNI_GOST"), new Object[0]), false, false);
        this.base.persist((Object)o);
        o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_PREDUZECE"), new Object[0]), true, false);
        this.base.persist((Object)o);
        o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_REPREZENTACIJA"), new Object[0]), false, false);
        this.base.persist((Object)o);
        o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_TOPLI_OBROK"), new Object[0]), false, false);
        this.base.persist((Object)o);
        o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_HOTELSKI_GOST"), new Object[0]), true, false);
        this.base.persist((Object)o);
        o = new StalniGostiGrupa(String.format(Konstante.getBundle().getString("SGG_NEPOZELJNI_GOST"), new Object[0]), false, true);
        this.base.persist((Object)o);
        this.base.getTransaction().commit();
    }

    public void addLogin(Login l) {
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
    }

    public void addZD(ZD zd) {
        this.base.getTransaction().begin();
        this.base.persist((Object)zd);
        this.base.getTransaction().commit();
    }

    public List<Login> getLogins() {
        Query query = this.base.createQuery("SELECT o FROM Login o ORDER BY o.name");
        return query.getResultList();
    }

    public StalniGost getSTGost(String s) {
        Query query = this.base.createQuery("SELECT s FROM StalniGost s where s.sifra=:s");
        query.setParameter("s", (Object)s);
        try {
            return (StalniGost)query.getSingleResult();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StalniGost getStalniGost(long id) {
        StalniGost k = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "SELECT s.* FROM stalnigost s where s.id=" + id + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                k = new StalniGost();
                StalniGostiGrupa sgg = this.getStalniGostGrupa(rs.getLong("GRUPA_ID"));
                k.setId(id);
                k.setAdersa(rs.getString("adersa"));
                k.setBanka1(rs.getString("banka1"));
                k.setBanka2(rs.getString("banka2"));
                k.setBanka3(rs.getString("banka3"));
                k.setBlokiran(rs.getBoolean("blokiran"));
                k.setBrlk(rs.getString("brlk"));
                k.setBrojKopijaPregleda(rs.getInt("brojKopijaPregleda"));
                k.setDobavljac(rs.getBoolean("dobavljac"));
                k.setEmail(rs.getString("email"));
                k.setFax(rs.getString("fax"));
                k.setJmbg(rs.getString("jmbg"));
                k.setLiceZaKontakt(rs.getString("liceZaKontakt"));
                k.setMaticniBroj(rs.getString("maticniBroj"));
                k.setMesto(rs.getString("mesto"));
                k.setMob(rs.getString("mob"));
                k.setNacinPlacanja(rs.getString("nacinPlacanja"));
                k.setNapomena(rs.getString("napomena"));
                k.setNaziv(rs.getString("naziv"));
                k.setPib(rs.getString("pib"));
                k.setPopust(rs.getDouble("popust"));
                k.setPoreskiObveznik(rs.getBoolean("poreskiObveznik"));
                k.setPretplata(rs.getDouble("pretplata"));
                k.setRegBrUSudu(rs.getString("regBrUSudu"));
                k.setSifra(rs.getString("sifra"));
                k.setSifraDelatnosti(rs.getString("sifraDelatnosti"));
                k.setSkrNaziv(rs.getString("skrNaziv"));
                k.setStampaPregleda(rs.getBoolean("stampaPregleda"));
                k.setTekuciRacun1(rs.getString("tekuciRacun1"));
                k.setTekuciRacun2(rs.getString("tekuciRacun2"));
                k.setTekuciRacun3(rs.getString("tekuciRacun3"));
                k.setTelefon(rs.getString("telefon"));
                k.setValutaPlacanja(rs.getInt("valutaPlacanja"));
                k.setWeb(rs.getString("web"));
                k.setStampa(rs.getBoolean("stampa"));
                k.setGrupa(sgg);
                k.setPoljoGazdinstvo(rs.getBoolean("poljoGazdinstvo"));
                k.setPoNabCenama(rs.getBoolean("poNabCenama"));
                k.setPoNabCenamaProcenat(rs.getDouble("poNabCenamaProcenat"));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return k;
    }

    public StalniGost getStalniGostBySifra(String sifra) {
        StalniGost sg = null;
        Query query = this.base.createQuery("SELECT s FROM StalniGost s where s.sifra = :sifra ");
        query.setParameter("sifra", (Object)sifra);
        try {
            sg = (StalniGost)query.getSingleResult();
            return sg;
        }
        catch (Exception e) {
            log.info("Stalni gost nije pronadjen.");
            return null;
        }
    }

    public List<StalniGost> getListStalniGost(String naziv) {
        Query query = this.base.createQuery("SELECT s FROM StalniGost s where s.naziv like '%" + naziv + "%' ");
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            log.info("Stalni gost nije pronadjen.");
            return null;
        }
    }

    public List<StalniGost> getListStalni(String naziv) {
        Query query = this.base.createQuery("SELECT s FROM StalniGost s where s.naziv = :s ");
        query.setParameter("s", (Object)naziv);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            log.info("Stalni gost nije pronadjen.");
            return null;
        }
    }

    public StalniGost getStalniGost(String naziv) {
        Query query = this.base.createQuery("SELECT s FROM StalniGost s where s.naziv=:s");
        query.setParameter("s", (Object)naziv);
        try {
            return (StalniGost)query.getSingleResult();
        }
        catch (Exception e) {
            log.info("Stalni gost nije pronadjen.");
            return null;
        }
    }

    public void deleteNenaplaceneStavkeTureSto(Integer bs) throws Exception {
        if (bs == null || bs < 0) {
            throw new IllegalArgumentException(String.format(Konstante.getBundle().getString("PORUKA_BROJ_STOLA_VAN_DOZVOLJENIH_VREDNOSTI"), new Object[0]));
        }
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        TypedQuery tqsr = em.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.brojStola = :bs AND sr.racun IS NULL", StavkaRacuna.class);
        tqsr.setParameter("bs", (Object)bs);
        TypedQuery tqt = em.createQuery("SELECT t FROM Tura t WHERE t.brojStola = :bs AND t.racun IS NULL", Tura.class);
        tqt.setParameter("bs", (Object)bs);
        TypedQuery tqs = em.createQuery("SELECT s FROM Sto s WHERE s.broj = :bs", Sto.class);
        System.out.println("bs = " + bs);
        tqs.setParameter("bs", (Object)bs);
        try {
            List stavke = tqsr.getResultList();
            List stolovi = tqs.getResultList();
            System.out.println("stolovi.size() = " + stolovi.size());
            List ture = tqt.getResultList();
            trans.begin();
            for (StavkaRacuna sr : stavke) {
                if (this.base != null && this.base.isOpen()) {
                    try {
                        StavkaRacuna ss = (StavkaRacuna)this.base.getReference(StavkaRacuna.class, (Object)sr.getId());
                        this.base.detach((Object)ss);
                    }
                    catch (Exception ss) {
                        // empty catch block
                    }
                }
                em.remove((Object)sr);
            }
            for (Tura t : ture) {
                if (this.base != null && this.base.isOpen()) {
                    try {
                        Tura tt = (Tura)this.base.getReference(Tura.class, (Object)t.getId());
                        this.base.detach((Object)tt);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                em.remove((Object)t);
            }
            for (Sto s : stolovi) {
                if (this.base != null && this.base.isOpen()) {
                    try {
                        Sto st = (Sto)this.base.getReference(Sto.class, (Object)s.getId());
                        this.base.detach((Object)st);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                em.remove((Object)s);
                System.out.println("s");
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            em.close();
            throw new Exception(String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STORNIRANJA_STAVKI"), new Object[0]), e);
        }
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNenaplaceneTure(Integer bs) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM tura WHERE( brojStola=" + bs + " and RACUN_ID IS NULL);";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKartica() {
        log.info("Brisanje tabele Kartica");
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        String insertString1 = "DELETE FROM kartica";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(insertString1);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKartica(String dokument) {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        String insertString1 = "DELETE FROM kartica WHERE dokument='" + dokument + "';";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(insertString1);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, null);
        }
    }

    public void deleteKarticaJPA(Date d1, Date d2) {
        log.log(Level.INFO, "Brisanje kartica za period od {0} do {1}", new Object[]{d1, d2});
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM Kartica k where k.datum BETWEEN :od AND :do");
        q.setParameter("od", d1, TemporalType.TIMESTAMP);
        q.setParameter("do", d2, TemporalType.TIMESTAMP);
        int deleted = q.executeUpdate();
        this.base.getTransaction().commit();
        log.log(Level.INFO, "Obrisano {0} kartica", deleted);
    }

    public void deleteStavkeRacuna(Racun r) {
        log.info("Brisanje stavki za racun od " + r.getDatum() + ", konobar: " + r.getKonobar().getPunoime());
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM StavkaRacuna sr where sr.racun = :r");
        q.setParameter("r", (Object)r);
        int del = q.executeUpdate();
        this.base.getTransaction().commit();
        log.info("Obrisano stavki: " + del);
    }

    public void deleteStavkeOtpisa(Otpis o) {
        log.info("Brisanje stavki za otpis od " + o.getDatum());
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM OtpisStavka os where os.otpis = :o");
        q.setParameter("o", (Object)o);
        int del = q.executeUpdate();
        this.base.getTransaction().commit();
        log.info("Obrisano stavki: " + del);
    }

    public void deleteStavkeOtpisaUtroska(Otpis o) {
        log.info("Brisanje stavki utroska za otpis od " + o.getDatum());
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM OtpisUtrosak ou where ou.otpis = :o");
        q.setParameter("o", (Object)o);
        int del = q.executeUpdate();
        this.base.getTransaction().commit();
        log.info("Obrisano stavki: " + del);
    }

    public void deleteTura(Racun r) {
        log.info("Brisanje tura za racun od " + r.getDatum() + ", konobar: " + r.getKonobar().getPunoime());
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM Tura t where t.racun = :r");
        q.setParameter("r", (Object)r);
        int del = q.executeUpdate();
        this.base.getTransaction().commit();
        log.info("Obrisano tura: " + del);
    }

    public long getRacunId(StavkaRacuna sr) {
        Connection conn = null;
        PreparedStatement ps = null;
        long id = 0L;
        String q = "select sr.RACUN_ID from stavkaracuna sr where sr.id = " + sr.getId() + " ";
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(q);
            this.r = ps.executeQuery();
            while (this.r.next()) {
                id = this.r.getLong("RACUN_ID");
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return id;
    }

    public void deleteRacun(long racunId) {
        Connection conn = null;
        PreparedStatement ps = null;
        String q = "delete from racun where racun.id = " + racunId + " ";
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(q);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteRacun(Racun r) {
        log.info("Brisanje racuna " + r);
        this.base.getTransaction().begin();
        Racun racun = (Racun)this.base.find(Racun.class, (Object)r.getId());
        this.base.remove((Object)racun);
        this.base.getTransaction().commit();
        log.info("Racun obrisan");
    }

    public void deleteRezervacijaDatum(Date d1) {
        log.info("Brisanje rezervacija za period do " + d1);
        this.base.getTransaction().begin();
        Query q = this.base.createQuery("DELETE FROM Rezervacija r where r.datum < :do");
        q.setParameter("do", d1, TemporalType.TIMESTAMP);
        int deleted = q.executeUpdate();
        this.base.getTransaction().commit();
        log.info("Obrisano " + deleted + " rezervacija");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKartica(Date d1, Date d2) {
        log.info("Brisanje kartica za period od " + d1 + " do " + d2);
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        String qString1 = "DELETE FROM kartica WHERE datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "' and odeljenje_id <> (select id from odeljenje  where naziv = 'MAGACIN');";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(qString1);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            log.warning("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, null);
        }
    }

    public void deleteKarticuPopisa(Date datum, Odeljenje o, boolean crno) {
        this.base.getTransaction().begin();
        String queryString = "delete from Kartica k where k.datum = :datum and k.crno = :crno and k.odeljenje =: odeljenje and k.dokument like :dokument";
        Query q = this.base.createQuery(queryString);
        q.setParameter("datum", (Object)datum);
        q.setParameter("crno", (Object)crno);
        q.setParameter("odeljenje", (Object)o);
        q.setParameter("dokument", (Object)"popis%");
        q.executeUpdate();
        this.base.getTransaction().commit();
    }

    public double getMedjuzbir(Konobar k, Date d1, Date d2) {
        Query query;
        double mz = 0.0;
        if (k != null) {
            query = this.base.createNativeQuery("SELECT * FROM StavkaRacuna sr \r\nJOIN tura t ON sr.TURA_ID = t.id\r\nWHERE sr.brojStola IN (SELECT s.broj from Sto s where s.KONOBAR_ID =? )\r\nand sr.RACUN_ID is NULL \r\nAND CAST(t.datum AS DATE) BETWEEN ? AND ?", StavkaRacuna.class);
            query.setParameter(1, (Object)k.getId());
            query.setParameter(2, (Object)d1);
            query.setParameter(3, (Object)d2);
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr where (sr.racun is null and (sr.tura.datum >= :d1 and sr.tura.datum <= :d2))");
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        List stavke = query.getResultList();
        if (stavke.size() < 1) {
            return 0.0;
        }
        for (StavkaRacuna sr : stavke) {
            mz += sr.getVrednost().doubleValue();
        }
        return mz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getLastDateZD() {
        EntityManager em = this.getEM();
        Date date = null;
        String selectString = "select datum from zd where zd.id = (select max(zd.id) from zd );";
        try {
            Query tqzd = em.createNativeQuery(selectString);
            List dList = tqzd.getResultList();
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                Date date1;
                date = date1 = (Date)iterator.next();
            }
        }
        catch (Exception ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            em.close();
        }
        return date;
    }

    public ZD getZDbyID(long id) {
        String query = "SELECT * FROM zd where zd.zdBroj = ? ORDER BY zd.id DESC LIMIT 1";
        Connection conn = this.getConnection();
        try {
            PreparedStatement pst = conn.prepareStatement(query);
            pst.setLong(1, id);
            System.out.println(pst);
            ResultSet rs = pst.executeQuery();
            rs.next();
            ZD zd = new ZD();
            zd.setId(rs.getLong("id"));
            zd.setDatum(rs.getDate("Datum"));
            zd.setPocetak(rs.getBoolean("pocetak"));
            zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
            zd.setZdBroj(rs.getLong("zdBroj"));
            return zd;
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public ZD getZDbyDatum(Date datum) {
        String query = "SELECT * FROM zd WHERE zd.datum = CAST(? AS DATE) AND zd.pocetak = 1 ORDER BY zd.id DESC LIMIT 1";
        Connection conn = this.getConnection();
        try {
            PreparedStatement pst = conn.prepareStatement(query);
            pst.setDate(1, new java.sql.Date(datum.getTime()));
            System.out.println(pst);
            ResultSet rs = pst.executeQuery();
            rs.next();
            ZD zd = new ZD();
            zd.setId(rs.getLong("id"));
            zd.setDatum(rs.getDate("Datum"));
            zd.setPocetak(rs.getBoolean("pocetak"));
            zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
            zd.setZdBroj(rs.getLong("zdBroj"));
            return zd;
        }
        catch (SQLException e1) {
            query = "SELECT zd.* FROM zd WHERE zd.pocetak = 1 and zd.datum = (select min(z.datum) from zd z where z.pocetak = 1)";
            try {
                PreparedStatement pst = conn.prepareStatement(query);
                System.out.println(pst);
                ResultSet rs = pst.executeQuery();
                rs.next();
                ZD zd = new ZD();
                zd.setId(rs.getLong("id"));
                zd.setDatum(rs.getDate("Datum"));
                zd.setPocetak(rs.getBoolean("pocetak"));
                zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
                zd.setZdBroj(rs.getLong("zdBroj"));
                return zd;
            }
            catch (SQLException e) {
                return null;
            }
        }
    }

    public ZD getNullZdBroj() {
        String query = "select * from zd z where z.zdBroj is null order by z.id desc limit 1 ";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            rs.next();
            ZD zd = new ZD();
            zd.setId(rs.getLong("id"));
            zd.setDatum(rs.getDate("Datum"));
            zd.setPocetak(rs.getBoolean("pocetak"));
            zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
            zd.setZdBroj(rs.getLong("zdBroj"));
            return zd;
        }
        catch (SQLException e1) {
            return null;
        }
    }

    public ZD getLastOpenZD() {
        String query = "SELECT * FROM zd ORDER BY zd.id DESC LIMIT 1 ";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            rs.next();
            ZD zd = new ZD();
            zd.setId(rs.getLong("id"));
            zd.setDatum(rs.getDate("Datum"));
            zd.setPocetak(rs.getBoolean("pocetak"));
            zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
            zd.setZdBroj(rs.getLong("zdBroj"));
            zd.setRekonstrukcija(rs.getBoolean("rekonstrukcija"));
            return zd;
        }
        catch (SQLException e1) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstDateZD() {
        EntityManager em = this.getEM();
        Date date = null;
        String selectString = "select zakljucenje from zd where zd.zakljucenje = (select min(zd.zakljucenje) from zd);";
        try {
            Query tqzd = em.createNativeQuery(selectString);
            List dList = tqzd.getResultList();
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                Date date1;
                date = date1 = (Date)iterator.next();
            }
        }
        catch (Exception ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            em.close();
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDatumisNotNUll() {
        String selectString = "select datum from zd where zd.zakljucenje = (select min(zd.zakljucenje) from zd ) and zdBroj is not null order by id desc ";
        try (EntityManager em = this.getEM();){
            Query tqzd = em.createNativeQuery(selectString);
            Date date = (Date)tqzd.getSingleResult();
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date gettDateZDWhereZDNull() {
        EntityManager em = this.getEM();
        Date date = null;
        String selectString = "select datum from zd where zd.zakljucenje = (select min(zd.zakljucenje) from zd ) and zdBroj is null;";
        try {
            Query tqzd = em.createNativeQuery(selectString);
            List dList = tqzd.getResultList();
            Iterator iterator = dList.iterator();
            while (iterator.hasNext()) {
                Date date1;
                date = date1 = (Date)iterator.next();
            }
        }
        catch (Exception ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            em.close();
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZdBrojisNotNUll() {
        EntityManager em = this.getEM();
        Object date = null;
        String selectString = "select zdBroj from zd where zd.zakljucenje = (select min(zd.zakljucenje) from zd ) and zdBroj is not null order by id desc;";
        try {
            Query tqzd = em.createNativeQuery(selectString);
            tqzd.setMaxResults(1);
            long l = (Long)tqzd.getSingleResult();
            return l;
        }
        catch (Exception ex) {
            System.err.println("SQLException: " + ex.getMessage());
            long l = 0L;
            return l;
        }
        finally {
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getZdBrojisNotNUllMax() {
        String selectString = "select zdBroj from zd where zd.zakljucenje = (select max(zd.zakljucenje) from zd where zd.zdBroj is not null) and zd.zdBroj is not null order by id desc;";
        try (EntityManager em = this.getEM();){
            Query tqzd = em.createNativeQuery(selectString);
            tqzd.setMaxResults(1);
            long l = (Long)tqzd.getSingleResult();
            return l;
        }
    }

    public List<ZD> getAllZDList() {
        Query query = this.base.createQuery("SELECT zd FROM ZD zd ");
        return query.getResultList();
    }

    public List<ZD> getAllZDListGroupByZDBroj(Date datum) {
        String query = "SELECT zd.* FROM ZD zd WHERE zd.Datum >= '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' GROUP BY zd.zdBroj ";
        LinkedList<ZD> lista = new LinkedList<ZD>();
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            System.out.println(pStatement);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                ZD zd = new ZD();
                zd.setId(rs.getLong("id"));
                zd.setDatum(rs.getDate("Datum"));
                zd.setPocetak(rs.getBoolean("pocetak"));
                zd.setZakljucenje(rs.getTimestamp("zakljucenje"));
                zd.setZdBroj(rs.getLong("zdBroj"));
                lista.add(zd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public List<ZD> getAllZDListZdBrojNUll() {
        Query query = this.base.createQuery("SELECT zd FROM ZD zd where zd.zdBroj IS NULL");
        return query.getResultList();
    }

    public boolean isZDPocetak() {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        Boolean b = Boolean.FALSE;
        String selectString = "select pocetak from zd where zd.id = (select max(zd.id) from zd );";
        try {
            tempStmt = conn.createStatement();
            ResultSet rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                b = rs.getBoolean("pocetak");
            }
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return b;
    }

    public boolean isEmptyDateZDZakljucenje(Date d1, Date d2) {
        if (Konstante.getOnlyDate(d2).equals(Konstante.getOnlyDate(new Date()))) {
            return false;
        }
        Query query = this.base.createQuery("SELECT zd FROM ZD zd WHERE zd.zakljucenje <= :d2 and zd.zakljucenje >= :d1 ");
        Calendar c = Calendar.getInstance();
        c.setTime(d2);
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList().size() < 1;
    }

    public boolean isEmptyDateZD(Date d1, Date d2) {
        if (Konstante.getOnlyDate(d2).equals(Konstante.getOnlyDate(new Date()))) {
            return false;
        }
        Query query = this.base.createQuery("SELECT zd FROM ZD zd WHERE zd.datum <= :d2 and zd.datum >= :d1 ");
        Calendar c = Calendar.getInstance();
        c.setTime(d2);
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList().size() < 1;
    }

    public boolean isBeforeDateZD(Date d2) {
        Query query = this.base.createQuery("SELECT zd FROM ZD zd WHERE zd.datum <= :d2 ");
        query.setParameter("d2", (Object)d2);
        return query.getResultList().size() < 1;
    }

    public boolean isAfterDateZD(Date d2) {
        Query query = this.base.createQuery("SELECT zd FROM ZD zd WHERE zd.datum > :d2 ");
        query.setParameter("d2", (Object)d2);
        return query.getResultList().size() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getKrajnjiBezKorekcije(Date date) {
        Date d = null;
        if (Konstante.getOnlyDate(date).equals(Konstante.getOnlyDate(new Date()))) {
            d = new Date();
            return d;
        }
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select zakljucenje from zd where zd.id = (select min(zd.id) from zd where (zd.datum ='" + Konstante.getSQLDateFormat(date) + "' and zd.pocetak='" + 0 + "'));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        if (d == null) {
            d = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Date getKrajnji(Date date) {
        Date d = null;
        if (Konstante.getOnlyDate(date).equals(Konstante.getOnlyDate(new Date()))) {
            d = new Date();
            return d;
        }
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select zakljucenje from zd where zd.id = (select min(zd.id) from zd where (zd.datum >='" + Konstante.getSQLDateFormat(date) + "' and zd.pocetak='" + 0 + "'));";
        try {
            stmt = conn.createStatement();
            System.out.println(stmt.toString());
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException sQLException) {
            this.proveriKonekciju(stmt, conn, rs);
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        if (d == null) {
            d = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(13, 0);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPocetniBezKorekcije(Date date) {
        Date date2 = Konstante.getOnlyDate(date);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp d = null;
        String selectString = "select zakljucenje from zd where zd.id =((select min(zd.id) from zd where (zd.datum >= '" + Konstante.getSQLDateFormat(date2) + "' and zd.pocetak='" + 1 + "')));";
        ++this.x;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            if (d == null) {
                this.proveriKonekciju(stmt, conn, rs);
                conn = this.getConnection();
                selectString = "select zakljucenje from zd where zd.id =(select max(zd.id) from zd where (zd.datum <= '" + Konstante.getSQLDateFormat(date2) + "' and zd.pocetak='" + 1 + "'));";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(selectString);
                while (rs.next()) {
                    d = rs.getTimestamp(1);
                }
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPocetni(Date date) {
        Date date2 = Konstante.getOnlyDate(date);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp d = null;
        String selectString = "select zakljucenje from zd where zd.id =((select min(zd.id) from zd where (zd.datum >= '" + Konstante.getSQLDateFormat(date2) + "' and zd.pocetak='" + 1 + "')));";
        ++this.x;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            if (d == null) {
                this.proveriKonekciju(stmt, conn, rs);
                conn = this.getConnection();
                selectString = "select zakljucenje from zd where zd.id =(select max(zd.id) from zd where (zd.datum <= '" + Konstante.getSQLDateFormat(date2) + "' and zd.pocetak='" + 1 + "'));";
                stmt = conn.createStatement();
                rs = stmt.executeQuery(selectString);
                while (rs.next()) {
                    d = rs.getTimestamp(1);
                }
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(13, 0);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPoslednjiPocetni() {
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp d = null;
        String selectString = "select zakljucenje from zd where (zd.id =(select max(zd.id) from zd) and zd.pocetak=1);";
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, this.conn, rs);
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPoslednjiSravnjeniPopis() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp d = null;
        String selectString = "select max(datum) from popis where sravnjenje = 1;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return d;
    }

    public Popis getPoslednjiSravnjeniPopisZaOdeljenje(Long odeljenjeId) {
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        String selectString = "SELECT * FROM popis p WHERE p.sravnjenje = 1 AND p.ODELJENJE_ID = ? AND p.crno = 0 ORDER BY p.id DESC LIMIT 1";
        try {
            ps = conn.prepareStatement(selectString);
            ps.setLong(1, odeljenjeId);
            rs = ps.executeQuery();
            Popis popis = null;
            while (rs.next()) {
                popis = new Popis();
                popis.setId(rs.getLong("id"));
                popis.setBroj(rs.getInt("broj"));
                popis.setCrno(rs.getBoolean("crno"));
                popis.setDatum(rs.getTimestamp("datum"));
                popis.setObaStanja(rs.getBoolean("obaStanja"));
                popis.setSravnjenje(rs.getBoolean("sravnjenje"));
                popis.setUser(rs.getString("user"));
                popis.setOdeljenje(this.getOdeljenje(odeljenjeId));
            }
            rs.close();
            ps.close();
            return popis;
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPoslednjiSravnjeniPopisByDate(Date datum) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Timestamp d = null;
        String selectString = "select datum from popis where sravnjenje = 1 and DATE(datum) <= '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' order by datum desc limit 1";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d = rs.getTimestamp(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return d;
    }

    public void addStoPrikaz(StoPrikaz sp) {
        this.base.getTransaction().begin();
        this.base.persist((Object)sp);
        this.base.getTransaction().commit();
    }

    public List<StoPrikaz> getStolovePrikaz() {
        Query query = this.base.createQuery("SELECT o FROM StoPrikaz o ");
        return query.getResultList();
    }

    public List<StoPrikaz> getStolovePrikaz(GrafikSale gs) {
        Query query = this.base.createQuery("SELECT o FROM StoPrikaz o WHERE o.grafik=:g");
        query.setParameter("g", (Object)gs);
        return query.getResultList();
    }

    public double getStoZaduzenje(int brojStola) {
        Query query = this.base.createQuery("select sum(sr.kolicina * sr.cena) from StavkaRacuna sr where sr.brojStola = : bs and sr.racun is null");
        query.setParameter("bs", (Object)brojStola);
        try {
            return Double.valueOf(query.getSingleResult().toString());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public double getStoZaduzenjeBMaster(int brojStola) {
        String query = "select sum(sr.kolicina * sr.cena) AS total from stavkaracuna sr\r\nJOIN racun r ON sr.RACUN_ID = r.id\r\nwhere sr.brojStola = ? AND r.zatvoren = 0";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setInt(1, brojStola);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getDouble("total");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Konobar getKonobarJPA(int bs) {
        Query q = this.base.createQuery("Select s from Sto s where s.broj = :bs");
        q.setParameter("bs", (Object)bs);
        try {
            Sto s = (Sto)q.getSingleResult();
            if (s != null) {
                this.base.refresh((Object)s);
                return s.getKonobar();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<GrafikSale> getGrafikeJPA() {
        EntityManager em = this.getEM();
        TypedQuery tqgs = em.createQuery("SELECT DISTINCT gs FROM GrafikSale gs JOIN FETCH gs.stolovi ORDER BY gs.id", GrafikSale.class);
        List resultList = tqgs.getResultList();
        em.close();
        return resultList;
    }

    public GrafikSale getgrafikById(long gsID) {
        Query q = this.base.createQuery("SELECT gs FROM GrafikSale gs WHERE gs.id = :id");
        q.setParameter("id", (Object)gsID);
        try {
            return (GrafikSale)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrafikSale> getGrafike() {
        ArrayList<GrafikSale> gs = new ArrayList<GrafikSale>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id,naziv,slika from grafiksale ;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                GrafikSale g = new GrafikSale();
                g.setId(this.r.getLong(1));
                g.setNaziv(this.r.getString(2));
                g.setSlika(this.r.getString(3));
                gs.add(g);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return gs;
    }

    public boolean getPostojiSto(int bs) {
        boolean s = false;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id from sto where sto.broj=" + bs + ";";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                s = true;
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return s;
    }

    public Artikal ArtikalByBC(String name) {
        Query q = this.base.createQuery("SELECT a FROM Artikal a WHERE a.barCode = :name AND a.blokiran = false");
        q.setParameter("name", (Object)name);
        try {
            return (Artikal)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<Normativ> readArtikleZaSastojak(Artikal a) {
        Query q = this.base.createNativeQuery("SELECT n.*\r\nfrom normativ n \r\nJOIN normativartikal na ON n.NORMATIVARTIKAL_ID = na.id\r\nwhere n.SASTOJAK_ID = ? \r\nAND n.id = ((select max(id) from normativ where ARTIKAL_ID = n.ARTIKAL_ID and SASTOJAK_ID = n.SASTOJAK_ID))\r\nAND n.NORMATIVARTIKAL_ID = (SELECT MAX(id) FROM normativartikal WHERE ARTIKAL_ID = n.ARTIKAL_ID)", Normativ.class);
        q.setParameter(1, (Object)a.getId());
        for (Object o : q.getResultList()) {
            this.base.refresh(o);
        }
        return q.getResultList();
    }

    public Login getLogin(String sifra) {
        Query query = this.base.createQuery("SELECT l FROM Login l WHERE (l.pass = :sifra AND l.admin = true )");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (Login)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Login getLogin2(String sifra) {
        Query query = this.base.createQuery("SELECT l FROM Login l WHERE l.pass = :sifra ");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (Login)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Login getLoginServis(String sifra) {
        Query query = this.base.createQuery("SELECT l FROM Login l WHERE (l.pass = :sifra AND l.service = true )");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (Login)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void deleteLogin(Login l) {
        this.base.getTransaction().begin();
        Login lo = (Login)this.base.find(Login.class, (Object)l.getId());
        this.base.remove((Object)lo);
        this.base.getTransaction().commit();
    }

    public void deleteTS(Trebovanje t) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM trebovanjestavka WHERE TREBOVANJE_ID = " + t.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.log(Level.SEVERE, "SQLException: {0}", ex.getMessage());
        }
    }

    public void insertPModeljenje(ProdajnoMesto pm, Odeljenje od) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into prodajnomesto_odeljenje value(" + pm.getId() + "," + od.getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.log(Level.SEVERE, "SQLException: {0}", ex.getMessage());
        }
    }

    public void deletePModeljenje(Odeljenje od) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM prodajnomesto_odeljenje WHERE ODELJENJA_ID = " + od.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.log(Level.SEVERE, "SQLException: {0}", ex.getMessage());
        }
    }

    public void deletePS(Prijemnica p) {
        Connection conn = this.getConnection();
        String insertString1 = "DELETE FROM prijemnicastavka WHERE prijemnica_ID = " + p.getId() + ";";
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void setProdajnuCenu() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update prijemnicastavka ps set ps.prodajnaCena = COALESCE((select a.cena from artikal a where a.id = ps.ARTIKAL_ID), 0.0) where ps.prodajnaCena is null";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void deletePS(PrijemnicaStavka ps) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM prijemnicastavka WHERE id = " + ps.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void deleteTS(TrebovanjeStavka t) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM trebovanjestavka WHERE id = " + t.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void deleteTrebovanje(Trebovanje t) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM trebovanje WHERE id = " + t.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void updateTS(TrebovanjeStavka l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateLogin(Login l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    Login checkLogin(String uname, String pass) {
        if (uname.equals("servis") && pass.equals("2222")) {
            Login login = new Login();
            login.setAdmin(Boolean.TRUE);
            login.setService(Boolean.TRUE);
            login.setName("SERVIS");
            return login;
        }
        Query query = this.base.createQuery("SELECT DISTINCT o FROM Login o WHERE o.name = :name AND o.pass = :pass");
        query.setParameter("name", (Object)uname);
        query.setParameter("pass", (Object)pass);
        try {
            return (Login)query.getSingleResult();
        }
        catch (NoResultException e) {
            query = this.base.createQuery("SELECT DISTINCT o FROM Login o");
            if (query.getResultList().size() < 1) {
                Login login = new Login();
                login.setAdmin(Boolean.TRUE);
                login.setService(Boolean.TRUE);
                login.setName("SETUP");
                return login;
            }
            return null;
        }
    }

    public void setUser(Login user) {
        this.user = user;
    }

    public Login getUser() {
        return this.user;
    }

    public List<GrupaOA> getGrupeAtributa() {
        Query query = this.base.createQuery("SELECT ga FROM GrupaOA ga ORDER BY ga.naziv");
        return query.getResultList();
    }

    public List<Atribut> getGrupaAtributa() {
        Query query = this.base.createQuery("SELECT at FROM Atribut at ORDER BY at.naziv");
        return query.getResultList();
    }

    public GrupaOA getGrupaAO(long id) {
        Query query = this.base.createQuery("SELECT ga FROM GrupaOA ga where ga.id = :id");
        query.setParameter("id", (Object)id);
        return (GrupaOA)query.getSingleResult();
    }

    public List<Artikal> getSlozeni(PodgrupaArtikala pa) {
        Query query = this.base.createQuery("SELECT a FROM Artikal a WHERE (a.podgrupa = :pa AND (a.tip = :t1  OR a.tip =:t2))ORDER BY a.name");
        query.setParameter("pa", (Object)pa);
        query.setParameter("t1", (Object)TipArtikla.POLU);
        query.setParameter("t2", (Object)TipArtikla.SLOZ);
        return query.getResultList();
    }

    public List<Artikal> getSlozeni(List<Odeljenje> o) {
        Query query;
        if (o != null) {
            query = this.base.createQuery("SELECT a FROM Artikal a WHERE (a.odeljenja in :o AND (a.tip = :t1  OR a.tip =:t2))ORDER BY a.name");
            query.setParameter("o", o);
        } else {
            query = this.base.createQuery("SELECT a FROM Artikal a WHERE (a.tip = :t1  OR a.tip =:t2)ORDER BY a.name");
        }
        query.setParameter("t1", (Object)TipArtikla.POLU);
        query.setParameter("t2", (Object)TipArtikla.SLOZ);
        return query.getResultList();
    }

    public List<TrebovanjeStavka> getStavkeTrSaPolupr(Date day, Odeljenje o, boolean crno) {
        Query query = this.base.createQuery("SELECT ts FROM TrebovanjeStavka ts WHERE ((ts.trebovanje.datum = :d AND ts.trebovanje.odeljenje = :o) AND (ts.artikal.tip=:t and ts.trebovanje.crno = :c))");
        query.setParameter("d", (Object)day);
        query.setParameter("o", (Object)o);
        query.setParameter("t", (Object)TipArtikla.POLU);
        query.setParameter("c", (Object)crno);
        return query.getResultList();
    }

    public List<GrupaZaposlenih> getGrupeZaposlenih() {
        Query query = this.base.createQuery("SELECT ga FROM GrupaZaposlenih ga ORDER BY ga.naziv");
        return query.getResultList();
    }

    public GrupaZaposlenih getGrupeZaposlenihByID(long id) {
        Query query = this.base.createQuery("SELECT ga FROM GrupaZaposlenih ga WHERE ga.i = :id ORDER BY ga.naziv");
        query.setParameter("id", (Object)id);
        return (GrupaZaposlenih)query.getSingleResult();
    }

    public List<Zaposleni> getZaposleni() {
        Query query = this.base.createQuery("SELECT ga FROM Zaposleni ga");
        return query.getResultList();
    }

    public List<TipDokumenta> getTipDokumenta() {
        Query query = this.base.createQuery("SELECT td FROM TipDokumenta td");
        return query.getResultList();
    }

    public List<StoNaziv> getStoNaziv() {
        Query query = this.base.createQuery("SELECT ga FROM StoNaziv ga");
        return query.getResultList();
    }

    public StoNaziv getStoNazivByID(int broj) {
        try {
            Query query = this.base.createQuery("SELECT ga FROM StoNaziv ga WHERE ga.broj = :broj");
            query.setParameter("broj", (Object)broj);
            return (StoNaziv)query.getSingleResult();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Rezervacija> getRezervacije() {
        Query query = this.base.createQuery("SELECT ga FROM Rezervacija ga order by ga.datum desc  ");
        return query.getResultList();
    }

    public List<Rezervacija> getKomitente() {
        Query query = this.base.createQuery("SELECT DISTINCT rk FROM Rezervacija rk order by rk.ime");
        return query.getResultList();
    }

    public List<Rezervacija> proveraRezervacije(int bs, Calendar od, Calendar doo, long id) {
        Query query = this.base.createQuery("SELECT ga FROM Rezervacija ga where ga.brStola = :bs and ga.datum >= :od and ga.datum <= :doo and ga.id <> :id");
        query.setParameter("bs", (Object)bs);
        query.setParameter("od", (Object)od);
        query.setParameter("doo", (Object)doo);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public List<Rezervacija> proveraRezervacije(int bs, Calendar od, Calendar doo) {
        Query query = this.base.createQuery("SELECT ga FROM Rezervacija ga where ga.brStola = :bs and ga.datum >= :od and ga.datum <= :doo ");
        query.setParameter("bs", (Object)bs);
        query.setParameter("od", (Object)od);
        query.setParameter("doo", (Object)doo);
        return query.getResultList();
    }

    public List<Atribut> getAtribute() {
        Query query = this.base.createQuery("SELECT ga FROM Atribut ga");
        return query.getResultList();
    }

    public void addGrupaOA(GrupaOA l) {
        log.info("Dodavanje grupeOA: " + l);
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
    }

    public GrupaOA updateGrupaOA(GrupaOA l) {
        log.info("Izmena grupeOA " + l);
        this.base.getTransaction().begin();
        l = (GrupaOA)this.base.merge((Object)l);
        this.base.getTransaction().commit();
        return l;
    }

    public void deleteGrupaOA(GrupaOA l) {
        log.info("Brisanje grupeOA: " + l);
        this.base.getTransaction().begin();
        GrupaOA gt = (GrupaOA)this.base.find(GrupaOA.class, (Object)l.getId());
        this.base.remove((Object)gt);
        this.base.getTransaction().commit();
    }

    public List<Trosak> getTroskoveClassic() {
        LinkedList<Trosak> troskovi = new LinkedList<Trosak>();
        String q = "Select t.* from trosak t";
        Connection conn = null;
        Statement st = null;
        try {
            conn = this.getConnection();
            st = conn.createStatement();
            this.r = st.executeQuery(q);
            while (this.r.next()) {
                Trosak t = new Trosak();
                t.setId(this.r.getLong("id"));
                t.setDan(this.r.getDate("dan"));
                t.setDatumPlacanja(this.r.getDate("datumPlacanja"));
                t.setIznos(this.r.getDouble("iznos"));
                t.setNacinPlacanja(this.r.getString("nacinPlacanja"));
                t.setNaziv(this.r.getString("naziv"));
                t.setPorez(this.r.getDouble("porez"));
                t.setValutaPlacanja(this.r.getDate("valutaPlacanja"));
                t.setGrupa((GrupaTroskova)this.base.find(GrupaTroskova.class, (Object)this.r.getLong("GRUPA_ID")));
                troskovi.add(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return troskovi;
    }

    public List<Long> getIdTroskova() {
        Query query = this.base.createQuery("SELECT ga.id FROM Trosak ga");
        return query.getResultList();
    }

    public List<Trosak> getTroskove() {
        log.finer("Citanje svih troskova");
        Query query = this.base.createQuery("SELECT ga FROM Trosak ga");
        return query.getResultList();
    }

    public Map<Artikal, Double> getArtikalZavrsnoStanje(Date datum, boolean osnovno, boolean dodatno) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        String tmp = "";
        if (!osnovno && !dodatno) {
            return ret;
        }
        tmp = osnovno && !dodatno ? "and (k.crno is null or k.crno = false)" : (!osnovno && dodatno ? "and k.crno = true" : "");
        String q = "SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum < :d and k.artikal.tip <> :t and k.artikal.blokiran = false " + tmp + " group by k.artikal";
        Query query = this.base.createQuery(q);
        query.setParameter("d", (Object)datum);
        query.setParameter("t", (Object)TipArtikla.SLOZ);
        List oo = query.getResultList();
        for (Object[] o : oo) {
            ret.put((Artikal)o[0], (double)Double.valueOf(o[1].toString()));
        }
        return ret;
    }

    public Map<Artikal, Double> getArtikalZavrsnoStanjeZaOdeljenje(Date datum, boolean osnovno, boolean dodatno, Odeljenje odeljenje) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        String tmp = "";
        Query query = null;
        if (!osnovno && !dodatno) {
            return ret;
        }
        query = osnovno && !dodatno ? this.qBeloZavrsnoStanjeZaOdeljenje : (!osnovno && dodatno ? this.qCrnoZavrsnoStanjeZaOdeljenje : this.qZavrsnoStanjeZaOdeljenje);
        for (Parameter param : query.getParameters()) {
            param = null;
        }
        System.out.println();
        System.out.println("Datum je " + datum.toString());
        System.out.println();
        query.setParameter("d", (Object)datum);
        query.setParameter("od", (Object)odeljenje);
        query.setParameter("arts", odeljenje.getArtikli());
        query.setParameter("t", (Object)TipArtikla.SLOZ);
        List oo = query.getResultList();
        for (Object[] o : oo) {
            ret.put((Artikal)o[0], (double)Double.valueOf(o[1].toString()));
        }
        return ret;
    }

    public Map<Artikal, Double> getArtikalUlazZaOdeljenje(Date datum1, Date datum2, boolean osnovno, boolean dodatno, Odeljenje odeljenje) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        String tmp = "";
        if (!osnovno && !dodatno) {
            return ret;
        }
        tmp = osnovno && !dodatno ? "and (k.crno is null or k.crno = false)" : (!osnovno && dodatno ? "and k.crno = true" : "");
        String q = "SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum between :d1 and :d2 and k.odeljenje = :od and k.kolicina > 0 and k.artikal.tip <> :t and k.artikal.blokiran = false " + tmp + " group by k.artikal";
        Query query = this.base.createQuery(q);
        query.setParameter("d1", (Object)datum1);
        query.setParameter("d2", (Object)datum2);
        query.setParameter("od", (Object)odeljenje);
        query.setParameter("t", (Object)TipArtikla.SLOZ);
        List oo = query.getResultList();
        for (Object[] o : oo) {
            ret.put((Artikal)o[0], (double)Double.valueOf(o[1].toString()));
        }
        return ret;
    }

    public Map<Artikal, Double> getArtikalIzlazZaOdeljenje(Date datum1, Date datum2, boolean osnovno, boolean dodatno, Odeljenje odeljenje) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        String tmp = "";
        if (!osnovno && !dodatno) {
            return ret;
        }
        tmp = osnovno && !dodatno ? "and (k.crno is null or k.crno = false)" : (!osnovno && dodatno ? "and k.crno = true" : "");
        String q = "SELECT k.artikal, SUM(k.kolicina) FROM Kartica k where k.datum between :d1 and :d2 and k.odeljenje = :od and k.kolicina < 0 and k.artikal.tip <> :t and k.artikal.blokiran = false " + tmp + " group by k.artikal";
        Query query = this.base.createQuery(q);
        query.setParameter("d1", (Object)datum1);
        query.setParameter("d2", (Object)datum2);
        query.setParameter("od", (Object)odeljenje);
        query.setParameter("t", (Object)TipArtikla.SLOZ);
        List oo = query.getResultList();
        for (Object[] o : oo) {
            ret.put((Artikal)o[0], (double)Double.valueOf(o[1].toString()));
        }
        return ret;
    }

    public Map<Artikal, Double> getArtikalPocetnoStanje(Date d, Odeljenje o, boolean c) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        String qs = "select ds.artikalID, SUM(ds.beloUlaz - ds.beloIzlaz) from DnevnoStanje ds where ds.datum < :d and ds.odeljenje = :o group by ds.artikalID";
        if (c) {
            qs = "select ds.artikalID, SUM(ds.crnoUlaz - ds.crnoIzlaz) from DnevnoStanje ds where ds.datum < :d and ds.odeljenje = :o group by ds.artikalID";
        }
        Query q = this.base.createQuery(qs);
        q.setParameter("d", (Object)d);
        q.setParameter("o", (Object)o);
        List oo = q.getResultList();
        for (Object[] ob : oo) {
            ret.put((Artikal)ob[0], (double)Double.valueOf(ob[1].toString()));
        }
        return ret;
    }

    public List<Trosak> getTroskove(Date d1, Date d2, List<GrupaTroskova> g, String pretraga) {
        String q = "SELECT ga FROM Trosak ga WHERE ga.dan >= :d1 AND ga.dan <= :d2";
        if (g != null && !g.isEmpty()) {
            q = q + " and ga.grupa in :g";
        }
        if (pretraga.length() > 0) {
            q = q + " and ga.naziv LIKE'%" + pretraga + "%'";
        }
        log.finer("Citanje troskova za period od : " + d1 + " do " + d2);
        Query query = this.base.createQuery(q);
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        if (g != null && !g.isEmpty()) {
            query.setParameter("g", g);
        }
        return query.getResultList();
    }

    public void addTrosak(Trosak l) {
        log.info("Dodavanje troska: " + l);
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
        log.fine("Trosak dodat: " + l);
    }

    public void updateTrosak(Trosak l) {
        log.info("Izmena troska " + l);
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
        log.fine("Izmenjen trosak: " + l);
    }

    public void deleteTrosak(Trosak l) {
        log.info("Brisanje troska: " + l);
        this.base.getTransaction().begin();
        Trosak gt = (Trosak)this.base.find(Trosak.class, (Object)l.getId());
        this.base.remove((Object)gt);
        this.base.getTransaction().commit();
        log.fine("Obrisan trosak: " + l);
    }

    public List<GrupaTroskova> getGrupeTroskova() {
        Query query = this.base.createQuery("SELECT ga FROM GrupaTroskova ga");
        return query.getResultList();
    }

    public Konobar getKonobarMeniPromet() {
        Query q = this.base.createQuery("SELECT k FROM Konobar k WHERE k.prometNaMeniPromet = :bo");
        q.setParameter("bo", (Object)true);
        try {
            return (Konobar)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Konobar getKonobar(String ime) {
        Query q = this.base.createQuery("SELECT k FROM Konobar k WHERE k.punoIme = :ime");
        q.setParameter("ime", (Object)ime);
        try {
            return (Konobar)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Konobar getKonobar(String password, String ime) {
        Query q = this.base.createQuery("SELECT k FROM Konobar k WHERE k.sifra=:password AND k.punoIme = :ime");
        q.setParameter("password", (Object)password);
        q.setParameter("ime", (Object)ime);
        try {
            return (Konobar)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public EvidencijaZaposlenih getEZ(String ime) {
        Query q = this.base.createQuery("SELECT e FROM EvidencijaZaposlenih e WHERE ( e.ime = :ime and e.odlazak is null)");
        q.setParameter("ime", (Object)ime);
        try {
            return (EvidencijaZaposlenih)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refresh() {
    }

    public String getKonobar(int bs) {
        String s = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select skrIme from konobar where konobar.id=(select KONOBAR_ID from sto where sto.broj=" + bs + ");";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                s = rs.getString(1);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String msg) {
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        LogRecord rec = new LogRecord();
        rec.setDan(new Date());
        rec.setVreme(new Date());
        rec.setUname(this.user != null ? this.user.getName() : "LOGIN");
        rec.setWhat(msg);
        try {
            trans.begin();
            em.persist((Object)rec);
            trans.commit();
        }
        catch (Exception ex) {
            Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, "Gre\u0161ka kod upisivanja audit loga u bazu. Dmitre proveri encoding log tabele i izvr\u0161i skriptu za promenu engine-a i encodinga", ex);
        }
        finally {
            em.close();
        }
    }

    public List<Artikal> sviArtikli() {
        Query q = this.base.createQuery("SELECT a FROM Artikal a ORDER BY a.name");
        return q.getResultList();
    }

    public List<Artikal> sviArtikliBezBlokiranih() {
        Query q = this.base.createQuery("SELECT a FROM Artikal a where a.blokiran = :f ORDER BY a.name");
        q.setParameter("f", (Object)Boolean.FALSE);
        return q.getResultList();
    }

    public List<Artikal> sviArtikliBezBlokiranihBezSirovina() {
        Query q = this.base.createQuery("SELECT a FROM Artikal a where a.blokiran = :f AND (a.tip<>:s) ORDER BY a.name");
        q.setParameter("f", (Object)Boolean.FALSE);
        q.setParameter("s", (Object)TipArtikla.SIRO);
        return q.getResultList();
    }

    public Odeljenje getOdeljenje(String naziv) {
        Query query = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.naziv = :n");
        query.setParameter("n", (Object)naziv);
        return (Odeljenje)query.getSingleResult();
    }

    public List<Odeljenje> getOdeljenjaBezMagacina() {
        Query query = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.naziv <> :n");
        query.setParameter("n", (Object)"MAGACIN");
        return query.getResultList();
    }

    public ArtikalText updateArtikalText(ArtikalText art) {
        this.base.getTransaction().begin();
        try {
            if (this.base.find(ArtikalText.class, (Object)art.getId()) == null) {
                this.base.persist((Object)art);
            } else {
                this.base.merge((Object)art);
            }
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return art;
    }

    public ArtikalText getArtikalText(Artikal a) {
        Query q = this.base.createQuery("SELECT at FROM ArtikalText at WHERE at.artikalId = :a");
        q.setParameter("a", (Object)a.getId());
        if (q.getSingleResult() != null) {
            return (ArtikalText)q.getSingleResult();
        }
        return null;
    }

    public Artikal getArtikal(String naziv) {
        this.qGetArtikalByName.setParameter("n", (Object)naziv);
        System.out.println(naziv);
        return (Artikal)this.qGetArtikalByName.getSingleResult();
    }

    public void deleteProizvodnju(Proizvodnja p) {
        this.base.getTransaction().begin();
        this.base.remove((Object)p);
        this.base.getTransaction().commit();
    }

    public void deleteUtrosakDoc(UtrosakDoc ud) {
        this.base.getTransaction().begin();
        this.base.remove(this.base.getReference(UtrosakDoc.class, (Object)ud.getId()));
        this.base.getTransaction().commit();
    }

    public void deleteOtpis(Otpis otpis) {
        this.base.getTransaction().begin();
        this.base.remove(this.base.getReference(Otpis.class, (Object)otpis.getId()));
        this.base.getTransaction().commit();
    }

    public Komitent getKomitent(String naziv) {
        this.qGetKomitentByName.setParameter("n", (Object)naziv);
        return (Komitent)this.qGetKomitentByName.getSingleResult();
    }

    public Komitent getKomitentBySG(StalniGost sg) {
        Query query = this.base.createQuery("SELECT k FROM Komitent k where k.sg = :sg ");
        query.setParameter("sg", (Object)sg);
        try {
            return (Komitent)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public Komitent getKomitentById(Long id) {
        this.qGetKomitentById.setParameter("n", (Object)id);
        return (Komitent)this.qGetKomitentById.getSingleResult();
    }

    public List<Artikal> ArtikliZaFO(PodgrupaArtikala pga) {
        Query query = this.base.createQuery("SELECT a FROM Artikal a WHERE((a.podgrupa = :pga AND a.blokiran=false) AND (a.tip=:p OR a.tip=:s OR a.tip=:pp OR a.tip=:dd)) ORDER BY a.prioritet, a.id");
        query.setParameter("p", (Object)TipArtikla.PROD);
        query.setParameter("s", (Object)TipArtikla.SLOZ);
        query.setParameter("pp", (Object)TipArtikla.POLU);
        query.setParameter("dd", (Object)TipArtikla.DODA);
        query.setParameter("pga", (Object)pga);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            query = this.base.createQuery("SELECT a FROM Artikal a WHERE((a.podgrupa=:pga AND a.blokiran=false) AND (a.tip=:p OR a.tip=:s OR a.tip=:pp OR a.tip=:dd)) ORDER BY a.name");
            query.setParameter("p", (Object)TipArtikla.PROD);
            query.setParameter("s", (Object)TipArtikla.SLOZ);
            query.setParameter("pp", (Object)TipArtikla.POLU);
            query.setParameter("dd", (Object)TipArtikla.DODA);
            query.setParameter("pga", (Object)pga);
            return query.getResultList();
        }
    }

    public List<Artikal> ArtikliZaFONaziv(PodgrupaArtikala pga) {
        Query query = this.base.createQuery("SELECT a FROM Artikal a WHERE((a.podgrupa=:pga AND a.blokiran=false) AND (a.tip=:p OR a.tip=:s OR a.tip=:pp OR a.tip=:dd)) ORDER BY a.name, a.id");
        query.setParameter("p", (Object)TipArtikla.PROD);
        query.setParameter("s", (Object)TipArtikla.SLOZ);
        query.setParameter("pp", (Object)TipArtikla.POLU);
        query.setParameter("dd", (Object)TipArtikla.DODA);
        query.setParameter("pga", (Object)pga);
        return query.getResultList();
    }

    public List<Artikal> ArtikliZaFO() {
        Query query = this.base.createQuery("SELECT a FROM Artikal a WHERE (a.blokiran=false AND(a.tip=:p OR a.tip=:s OR a.tip=:pp OR a.tip=:dd)) ORDER BY a.name");
        query.setParameter("p", (Object)TipArtikla.PROD);
        query.setParameter("s", (Object)TipArtikla.SLOZ);
        query.setParameter("pp", (Object)TipArtikla.POLU);
        query.setParameter("dd", (Object)TipArtikla.DODA);
        return query.getResultList();
    }

    public Artikal addArtikal(Artikal artikal) {
        this.base.getTransaction().begin();
        this.base.persist((Object)artikal);
        this.base.getTransaction().commit();
        return artikal;
    }

    public void addGrupaArtikala(GrupaArtikala grupa) {
        this.base.getTransaction().begin();
        this.base.persist((Object)grupa);
        this.base.getTransaction().commit();
    }

    public void addPopis(Popis popis) {
        this.base.getTransaction().begin();
        this.base.persist((Object)popis);
        this.base.getTransaction().commit();
    }

    public void addPopis1(Popis p) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into popis values(null," + p.getBroj() + "," + p.getCrno() + ",'" + Konstante.getSQLDateFormat(p.getDatum()) + "'," + p.getSravnjenje() + ",'" + p.getUser() + "'," + p.getOdeljenje().getId() + ");";
        System.out.println(insertString1);
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            log.warning("SQLException: " + ex.getMessage());
        }
    }

    public Popis updatePopis(Popis popis) {
        this.base.getTransaction().begin();
        popis = (Popis)this.base.merge((Object)popis);
        this.base.getTransaction().commit();
        return popis;
    }

    public void updateEZ(EvidencijaZaposlenih ez) {
        this.base.getTransaction().begin();
        this.base.merge((Object)ez);
        this.base.getTransaction().commit();
    }

    public void addGrupaStGostiju(StalniGostiGrupa grupa) {
        this.base.getTransaction().begin();
        this.base.persist((Object)grupa);
        this.base.getTransaction().commit();
    }

    public void addSalnitGost(StalniGost sg) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        Long GrupaId = sg.getGrupa() != null ? sg.getGrupa().getId() : null;
        String insertString1 = null;
        insertString1 = sg.getNacinPlacanja() == null ? "insert into stalnigost values(null,'" + sg.getAdersa() + "','" + sg.getBanka1() + "','" + sg.getBanka2() + "','" + sg.getBanka3() + "'," + sg.isBlokiran() + ",'" + sg.getBrlk() + "'," + sg.getDobavljac() + ",'" + sg.getEmail() + "','" + sg.getFax() + "','" + sg.getJmbg() + "','" + sg.getLiceZaKontakt() + "','" + sg.getMaticniBroj() + "','" + sg.getMesto() + "','" + sg.getMob() + "'," + null + ",'" + sg.getNapomena() + "','" + sg.getNaziv() + "','" + sg.getPib() + "'," + sg.getPopust() + "," + sg.getPoreskiObveznik() + "," + sg.getPretplata() + ",'" + sg.getRegBrUSudu() + "','" + sg.getSifra() + "','" + sg.getSifraDelatnosti() + "','" + sg.getSkrNaziv() + "','" + sg.getTekuciRacun1() + "','" + sg.getTekuciRacun2() + "','" + sg.getTekuciRacun3() + "','" + sg.getTelefon() + "'," + sg.getValutaPlacanja() + ",'" + sg.getWeb() + "'," + GrupaId + ")" : "insert into stalnigost values(null,'" + sg.getAdersa() + "','" + sg.getBanka1() + "','" + sg.getBanka2() + "','" + sg.getBanka3() + "'," + sg.isBlokiran() + ",'" + sg.getBrlk() + "'," + sg.getDobavljac() + ",'" + sg.getEmail() + "','" + sg.getFax() + "','" + sg.getJmbg() + "','" + sg.getLiceZaKontakt() + "','" + sg.getMaticniBroj() + "','" + sg.getMesto() + "','" + sg.getMob() + "','" + sg.getNacinPlacanja() + "','" + sg.getNapomena() + "','" + sg.getNaziv() + "','" + sg.getPib() + "'," + sg.getPopust() + "," + sg.getPoreskiObveznik() + "," + sg.getPretplata() + ",'" + sg.getRegBrUSudu() + "','" + sg.getSifra() + "','" + sg.getSifraDelatnosti() + "','" + sg.getSkrNaziv() + "','" + sg.getTekuciRacun1() + "','" + sg.getTekuciRacun2() + "','" + sg.getTekuciRacun3() + "','" + sg.getTelefon() + "'," + sg.getValutaPlacanja() + ",'" + sg.getWeb() + "'," + GrupaId + ")";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public List<Artikal> readSveArtikle(List<Odeljenje> o) {
        Query query = this.base.createQuery("SELECT a FROM Artikal a WHERE a.odeljenja in :o");
        query.setParameter("o", o);
        return query.getResultList();
    }

    public List<GrupaArtikala> readGrupeArtikala() {
        Query query = this.base.createQuery("SELECT g FROM GrupaArtikala g");
        return query.getResultList();
    }

    public List<GrafikSale> readGrafikSale() {
        Query query = this.base.createQuery("SELECT g FROM GrafikSale g");
        return query.getResultList();
    }

    public List<GrupaArtikala> readGrupePrioritet() {
        Query query = this.base.createQuery("SELECT g FROM GrupaArtikala g ORDER BY g.prioritet");
        return query.getResultList();
    }

    public List<GrupaArtikala> readGrupePrioritetPrikazNaEkran() {
        Query query = this.base.createQuery("SELECT g FROM GrupaArtikala g WHERE g.prikazNaEkran = :t ORDER BY g.prioritet");
        query.setParameter("t", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrupaArtikala> readGrupePrioritetPrikazNaEkran2() {
        ArrayList<GrupaArtikala> grupe = new ArrayList<GrupaArtikala>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "SELECT id,skrNaziv,slika FROM grupaartikala WHERE prikazNaEkran=" + Boolean.TRUE + " ORDER BY prioritet;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                GrupaArtikala ga = new GrupaArtikala();
                ga.setId(this.r.getLong(1));
                ga.setSkrNaziv(this.r.getString(2));
                ga.setSlika(this.r.getString(3));
                grupe.add(ga);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return grupe;
    }

    public List<GrupaArtikala> readGrupeNazivPrikazNaEkran() {
        Query query = this.base.createQuery("SELECT g FROM GrupaArtikala g WHERE g.prikazNaEkran = :t ORDER BY g.naziv");
        query.setParameter("t", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    public GrupaArtikala readGrupeNaziv(String s) {
        Query query = this.base.createQuery("SELECT g FROM GrupaArtikala g where g.naziv = :s");
        query.setParameter("s", (Object)s);
        return (GrupaArtikala)query.getSingleResult();
    }

    public List<StalniGostiGrupa> readGrupeStalniGostiPreduzece() {
        Query query = this.base.createQuery("SELECT DISTINCT g FROM StalniGostiGrupa g LEFT OUTER JOIN FETCH g.stalniGosti where g.naziv = 'PREDUZECE' ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<StalniGostiGrupa> readGrupeStGosti() {
        Query query = this.base.createQuery("SELECT DISTINCT g FROM StalniGostiGrupa g LEFT OUTER JOIN FETCH g.stalniGosti ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<StalniGostiGrupa> readGrupeStGostiDescById() {
        Query query = this.base.createQuery("SELECT DISTINCT g FROM StalniGostiGrupa g LEFT OUTER JOIN FETCH g.stalniGosti ORDER BY g.id desc");
        return query.getResultList();
    }

    public List<CenovnikTip> readCenovnikTip() {
        Query query = this.base.createQuery("SELECT c FROM CenovnikTip c ORDER BY c.id");
        return query.getResultList();
    }

    public List<Komitent> readKomitenti() {
        Query query = this.base.createQuery("SELECT DISTINCT k FROM Komitent k ORDER BY k.naziv");
        return query.getResultList();
    }

    public List<Komitent> searchKomitenti(String string) {
        Query query = this.base.createQuery("SELECT DISTINCT k FROM Komitent k WHERE k.naziv LIKE'%" + string + "%' OR k.pib LIKE'%" + string + "%' ORDER BY k.naziv");
        return query.getResultList();
    }

    public List<StalniGost> searchStalniGost(String string) {
        Query query = this.base.createQuery("SELECT DISTINCT sg FROM StalniGost sg WHERE (sg.grupa.naziv = 'PREDUZECE' OR sg.grupa.id = 2 OR sg.kupac = true) AND (sg.naziv LIKE'%" + string + "%' OR sg.pib LIKE'%" + string + "%') ORDER BY sg.naziv");
        return query.getResultList();
    }

    public List<StalniGost> readStalniGostiKupci() {
        Query query = this.base.createQuery("SELECT g FROM StalniGost g WHERE g.dobavljac = false AND g.grupa.naziv = 'PREDUZECE' ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<StalniGost> readStalniGostiPreduzeca() {
        Query query = this.base.createQuery("SELECT g FROM StalniGost g WHERE g.dobavljac = true ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<StalniGost> readStalniGostiByGroup(StalniGostiGrupa sgg) {
        Query query = this.base.createQuery("SELECT g FROM StalniGost g WHERE g.grupa = :sgg ORDER BY g.naziv");
        query.setParameter("sgg", (Object)sgg);
        return query.getResultList();
    }

    public List<StalniGost> readStalniGostiFromRacun() {
        Query query = this.base.createQuery("SELECT DISTINCT r.stalniGost FROM Racun r where r.stalniGost.grupa.preduzece = true ORDER BY r.stalniGost.naziv");
        return query.getResultList();
    }

    public List<StalniGost> readStalniGosti() {
        Query query = this.base.createQuery("SELECT g FROM StalniGost g ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<GrupaZaposlenih> readGrupeZaposlenih() {
        Query query = this.base.createQuery("SELECT g FROM GrupaZaposlenih g ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<String> readZaposleni(GrupaZaposlenih gz) {
        ArrayList<String> artikli = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "SELECT ime FROM zaposleni WHERE GRUPA_ID=" + gz.getId() + ";";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                artikli.add(rs.getString(1));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return artikli;
    }

    public String readZaposleni(String s) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String z = null;
        String selectString = "SELECT ime FROM zaposleni WHERE sifra=" + s + ";";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                z = rs.getString(1);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return z;
    }

    public double readCenaZaposlenog(String s) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        double z = 0.0;
        String selectString = "SELECT cenaSata FROM zaposleni WHERE ime='" + s + "';";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                z = rs.getDouble(1);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return z;
    }

    public List<Zaposleni> readZaposleni2() {
        Query query = this.base.createQuery("SELECT z FROM Zaposleni z");
        return query.getResultList();
    }

    public List<String> readZaposleni() {
        ArrayList<String> artikli = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "SELECT ime FROM zaposleni";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                artikli.add(rs.getString(1));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return artikli;
    }

    public void updateGrupaArtikala(GrupaArtikala grupa) {
        this.base.getTransaction().begin();
        this.base.merge((Object)grupa);
        this.base.getTransaction().commit();
    }

    public void updateGrupaStGosti(StalniGostiGrupa grupa) {
        this.base.getTransaction().begin();
        this.base.merge((Object)grupa);
        this.base.getTransaction().commit();
    }

    public void updateStGost(StalniGost grupa) {
        this.base.getTransaction().begin();
        this.base.merge((Object)grupa);
        this.base.getTransaction().commit();
    }

    public GrupaArtikala deleteGrupaArtikala(GrupaArtikala grupa) {
        this.base.getTransaction().begin();
        GrupaArtikala ga = (GrupaArtikala)this.base.find(GrupaArtikala.class, (Object)grupa.getId());
        this.base.remove((Object)ga);
        this.base.getTransaction().commit();
        return grupa;
    }

    public StalniGostiGrupa deleteGrupaStGosti(StalniGostiGrupa grupa) {
        this.base.getTransaction().begin();
        StalniGostiGrupa ga = (StalniGostiGrupa)this.base.find(StalniGostiGrupa.class, (Object)grupa.getId());
        this.base.remove((Object)ga);
        this.base.getTransaction().commit();
        return grupa;
    }

    public StalniGostiGrupa findGrupaStGosti(String grupa) {
        Query q = this.base.createQuery("SELECT g FROM StalniGostiGrupa g WHERE g.naziv = :a");
        q.setParameter("a", (Object)grupa);
        return (StalniGostiGrupa)q.getResultList().get(0);
    }

    public StalniGost deleteStGost(StalniGost grupa) {
        this.base.getTransaction().begin();
        StalniGost ga = (StalniGost)this.base.find(StalniGost.class, (Object)grupa.getId());
        this.base.remove((Object)ga);
        this.base.getTransaction().commit();
        return grupa;
    }

    public void addPodrupaArtikala(PodgrupaArtikala grupa) {
        this.base.getTransaction().begin();
        this.base.persist((Object)grupa);
        this.base.getTransaction().commit();
    }

    public List<PodgrupaArtikala> readPodgrupeArtikala() {
        Query query = this.base.createQuery("SELECT g FROM PodgrupaArtikala g ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<PodgrupaArtikala> readPodgrupeArtikalaPlusArtikli() {
        Query query = this.base.createQuery("SELECT DISTINCT g FROM PodgrupaArtikala g JOIN FETCH g.artikli ORDER BY g.naziv");
        return query.getResultList();
    }

    public List<EvidencijaZaposlenih> readEvidencijaZaposlenih(Date d1, Date d2) {
        Query query = this.base.createQuery("SELECT e FROM EvidencijaZaposlenih e  where(e.datum>= :d1 and e.datum<= :d2)");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<EvidencijaZaposlenih> readEvidencijaZaposlenih(Date d1) {
        Query query = this.base.createQuery("SELECT e FROM EvidencijaZaposlenih e  where e.datum= :d1 ORDER BY e.ime");
        query.setParameter("d1", (Object)d1);
        return query.getResultList();
    }

    public List<EvidencijaZaposlenih> readNeodjavljeneZaposlene() {
        Query query = this.base.createQuery("SELECT e FROM EvidencijaZaposlenih e  where e.odlazak is null");
        return query.getResultList();
    }

    public List<EvidencijaZaposlenih> readTrenutnoPrijavljeni() {
        Query query = this.base.createQuery("SELECT e FROM EvidencijaZaposlenih e  where e.odjavljen = false ");
        return query.getResultList();
    }

    public List<PodgrupaArtikala> readPodgrupePoPrioritetu() {
        Query query = this.base.createQuery("SELECT g FROM PodgrupaArtikala g ORDER BY g.prioritet");
        return query.getResultList();
    }

    public PodgrupaArtikala getPodgrupuArtikala(String naziv) {
        Query query = this.base.createQuery("SELECT pgr FROM PodgrupaArtikala pgr WHERE  pgr.naziv = :naziv ");
        query.setParameter("naziv", (Object)naziv);
        return (PodgrupaArtikala)query.getSingleResult();
    }

    public List<PodgrupaArtikala> readPodgrupeArtikala(GrupaArtikala grupa) {
        Query query = this.base.createQuery("SELECT o FROM PodgrupaArtikala o WHERE  o.grupa = :grupa ORDER BY o.prioritet");
        query.setParameter("grupa", (Object)grupa);
        return query.getResultList();
    }

    public List<StoPrikaz> readStolovi(GrafikSale gs) {
        Query query = this.base.createQuery("SELECT sp FROM StoPrikaz sp WHERE sp.grafik = :gs ORDER BY sp.id asc");
        query.setParameter("gs", (Object)gs);
        return query.getResultList();
    }

    public List<Integer> sviStoloviIzRacuna() {
        Query query = this.base.createQuery("select distinct r.brojStola from Racun r order by r.brojStola asc");
        return query.getResultList();
    }

    public List<StoPrikaz> getSviStolovi() {
        Query query = this.base.createQuery("SELECT sp FROM StoPrikaz sp  ORDER BY sp.id asc");
        return query.getResultList();
    }

    public List<PodgrupaArtikala> readPodgrupeArtikalaNaziv(GrupaArtikala grupa) {
        Query query = this.base.createQuery("SELECT o FROM PodgrupaArtikala o WHERE  o.grupa = :grupa ORDER BY o.naziv");
        query.setParameter("grupa", (Object)grupa);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PodgrupaArtikala> readPodgrupeArtikala2(Long grupaID, boolean poNazivu) {
        ArrayList<PodgrupaArtikala> pa = new ArrayList<PodgrupaArtikala>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = poNazivu ? "SELECT id,skrNaziv,slika FROM podgrupaartikala WHERE GRUPA_ID = " + grupaID + " ORDER BY skrNaziv;" : "SELECT id,skrNaziv,slika FROM podgrupaartikala WHERE GRUPA_ID = " + grupaID + " ORDER BY prioritet;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                PodgrupaArtikala p = new PodgrupaArtikala();
                p.setId(this.r.getLong(1));
                p.setSkrNaziv(this.r.getString(2));
                p.setSlika(this.r.getString(3));
                pa.add(p);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return pa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> readArtikle2(Long pgID, boolean poNazivu) {
        ArrayList<Artikal> pa = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = poNazivu ? "SELECT id,skrNaziv,slika,name,cena,dozvoljenPopust,poreskaGrupa,tip,mera, jedinicamere FROM artikal WHERE (PODGRUPA_ID = " + pgID + " and blokiran = " + Boolean.FALSE + " and (tip like 'PROD' or tip like 'SLOZ' or tip like 'POLU' or tip like 'DODA')) ORDER BY skrNaziv, id ASC;" : "SELECT id,skrNaziv,slika,name,cena,dozvoljenPopust,poreskaGrupa,tip,mera, jedinicamere FROM artikal WHERE (PODGRUPA_ID = " + pgID + " and blokiran = " + Boolean.FALSE + " and (tip like 'PROD' or tip like 'SLOZ' or tip like 'POLU' or tip like 'DODA')) ORDER BY prioritet, id ASC;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                Artikal a = new Artikal();
                a.setId(this.r.getLong(1));
                a.setSkrNaziv(this.r.getString(2));
                a.setSlika(this.r.getString(3));
                a.setName(this.r.getString(4));
                a.setCena(this.r.getDouble(5));
                a.setTip(StavkeSumarno.getTipArtikla(this.r.getString(8)));
                a.setDozvoljenPopust(this.r.getBoolean(6));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(this.r.getInt(7)));
                a.setMera(this.r.getDouble(9));
                a.setJedinicaMere(this.r.getString(10));
                pa.add(a);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return pa;
    }

    public List<Artikal> readArtikle2(Long pgID, boolean poNazivu, List<String> listaZaNePrikazivanje, List<Long> kasa_artikli, Kasa kasa) {
        List paTemp = new ArrayList();
        ArrayList<Artikal> pa = new ArrayList<Artikal>();
        Query q = null;
        q = poNazivu ? this.base.createQuery("SELECT  a FROM Artikal a WHERE(a.blokiran=:f and a.podgrupa = :p) AND a.tip<>:tip ORDER BY a.name") : this.base.createQuery("SELECT  a FROM Artikal a WHERE(a.blokiran=:f and a.podgrupa = :p) AND a.tip<>:tip ORDER BY a.prioritet, a.id");
        q.setParameter("p", this.getBase().find(PodgrupaArtikala.class, (Object)pgID));
        q.setParameter("f", (Object)Boolean.FALSE);
        q.setParameter("tip", (Object)TipArtikla.SIRO);
        paTemp = q.getResultList();
        if (BrandingCache.getBrand() != BrandingData.TRADEMASTER) {
            for (Artikal a : paTemp) {
                if (listaZaNePrikazivanje.contains(String.valueOf(a.getId())) || this.getSetting(Option.SISTEM_VISE_KASA).booleanValue() && !kasa_artikli.contains(a.getId())) continue;
                for (Odeljenje o : kasa.getOdeljenja()) {
                    if (!a.getOdeljenja().contains(o) || pa.contains(a)) continue;
                    pa.add(a);
                }
            }
        }
        return BrandingCache.getBrand() != BrandingData.TRADEMASTER ? pa : paTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> readArtikle2(Long pgID, boolean poNazivu, boolean popust) {
        ArrayList<Artikal> pa = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = poNazivu ? "SELECT id,skrNaziv,slika,name,cena,dozvoljenPopust,poreskaGrupa,tip,mera FROM artikal WHERE (PODGRUPA_ID = " + pgID + " and blokiran = " + Boolean.FALSE + ") ORDER BY name;" : "SELECT id,skrNaziv,slika,name,cena,dozvoljenPopust,poreskaGrupa,tip,mera FROM artikal WHERE (PODGRUPA_ID = " + pgID + " and blokiran = " + Boolean.FALSE + ") ORDER BY prioritet;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                Artikal a = new Artikal();
                a.setId(this.r.getLong(1));
                a.setSkrNaziv(this.r.getString(2));
                a.setSlika(this.r.getString(3));
                a.setName(this.r.getString(4));
                a.setCena(this.r.getDouble(5));
                a.setTip(StavkeSumarno.getTipArtikla(this.r.getString(8)));
                a.setDozvoljenPopust(this.r.getBoolean(6));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(this.r.getInt(7)));
                a.setMera(this.r.getDouble(9));
                pa.add(a);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return pa;
    }

    public List<StalniGost> readStalneGoste(StalniGostiGrupa grupa, boolean blokirani) {
        Query query = null;
        if (grupa == null) {
            query = this.base.createQuery("SELECT o FROM StalniGost o WHERE o.blokiran = :blokirani ORDER BY o.naziv");
            query.setParameter("blokirani", (Object)blokirani);
        } else {
            query = this.base.createQuery("SELECT o FROM StalniGost o WHERE(o.grupa = :grupa AND o.blokiran = :blokirani ) ORDER BY o.naziv");
            query.setParameter("grupa", (Object)grupa);
            query.setParameter("blokirani", (Object)blokirani);
        }
        return query.getResultList();
    }

    public List<StalniGost> readStalneGoste(StalniGostiGrupa grupa) {
        Query query = this.base.createQuery("SELECT o FROM StalniGost o WHERE(o.grupa = :grupa AND o.blokiran = false) ORDER BY o.naziv");
        query.setParameter("grupa", (Object)grupa);
        return query.getResultList();
    }

    public List<StalniGost> readNepozeljneStalneGoste() {
        Query query = this.base.createQuery("SELECT o FROM StalniGost o WHERE  o.blokiran = true ORDER BY o.naziv");
        return query.getResultList();
    }

    public List<StalniGost> readStalneGoste(String grupa) {
        Query query = this.base.createQuery("SELECT o FROM StalniGost o WHERE  o.grupa.naziv = :grupa ORDER BY o.naziv");
        query.setParameter("grupa", (Object)grupa);
        return query.getResultList();
    }

    public List<StalniGost> readStalneGosteBezSifre(StalniGostiGrupa grupa) {
        Query query = this.base.createQuery("SELECT o FROM StalniGost o WHERE(  o.grupa = :grupa and o.sifra = :s AND o.blokiran = FALSE) ORDER BY o.naziv");
        query.setParameter("grupa", (Object)grupa);
        query.setParameter("s", (Object)"");
        return query.getResultList();
    }

    public List<StalniGost> readStalneGosteBezSifre(StalniGostiGrupa grupa, String s) {
        Query query = this.base.createQuery("SELECT o FROM StalniGost o WHERE(  o.grupa = :grupa and o.sifra = :sifra AND o.blokiran = FALSE) AND (o.naziv LIKE'%" + s + "%' OR o.adersa LIKE'%" + s + "%' OR o.mesto LIKE'%" + s + "%' OR o.telefon LIKE'%" + s + "%' OR o.mob LIKE'%" + s + "%' OR o.email LIKE'%" + s + "%') ORDER BY o.naziv");
        query.setParameter("grupa", (Object)grupa);
        query.setParameter("sifra", (Object)"");
        query.setMaxResults(100);
        return query.getResultList();
    }

    public List<StalniGost> readStalneGosteBezSifreStatement(StalniGostiGrupa grupa, String s) {
        ArrayList<StalniGost> guests = new ArrayList<StalniGost>();
        String query = "SELECT * FROM stalnigost sg \nWHERE sg.GRUPA_ID = ?  AND sg.sifra ='' AND sg.blokiran = 0\n AND (sg.naziv LIKE'%" + s + "%' OR sg.adersa LIKE'%" + s + "%'  OR sg.mesto LIKE'%" + s + "%'\n OR sg.telefon LIKE'%" + s + "%' OR sg.mob LIKE'%" + s + "%' OR sg.email LIKE'%" + s + "%') \n ORDER BY sg.naziv LIMIT 30";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, grupa.getId());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StalniGost sgGost = new StalniGost();
                sgGost.setId(rs.getLong("id"));
                sgGost.setAdersa(rs.getString("adresa"));
                sgGost.setBlokiran(rs.getBoolean("blokiran"));
                sgGost.setBrojKopijaPregleda(rs.getInt("brojKopijaPregleda"));
                sgGost.setEmail(rs.getString("email"));
                sgGost.setMaticniBroj(rs.getString("maticniBroj"));
                sgGost.setMesto(rs.getString("mesto"));
                sgGost.setMob(rs.getString("mob"));
                sgGost.setNaziv(rs.getString("naziv"));
                sgGost.setSkrNaziv(rs.getString("skrNaziv"));
                sgGost.setPib(rs.getString("pib"));
                sgGost.setStampa(rs.getBoolean("stampa"));
                sgGost.setStampaPregleda(rs.getBoolean("stampaPregleda"));
                sgGost.setTelefon(rs.getString("telefon"));
                sgGost.setGrupa(this.getStalniGostGrupa(rs.getLong("GRUPA_ID")));
                guests.add(sgGost);
            }
            return guests;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updatePodgrupaArtikala(PodgrupaArtikala grupa) {
        this.base.getTransaction().begin();
        this.base.merge((Object)grupa);
        this.base.getTransaction().commit();
    }

    public void deletePodgrupaArtikala(PodgrupaArtikala grupa) {
        this.base.getTransaction().begin();
        PodgrupaArtikala ga = (PodgrupaArtikala)this.base.find(PodgrupaArtikala.class, (Object)grupa.getId());
        this.base.remove((Object)ga);
        this.base.getTransaction().commit();
    }

    public List<Artikal> readArtikliBezSlozenihIPolupr() {
        Query q = this.base.createQuery("SELECT  a FROM Artikal a WHERE(a.blokiran=:f and( a.tip<>:tip1 and a.tip<>:tip2))");
        q.setParameter("tip1", (Object)TipArtikla.SLOZ);
        q.setParameter("tip2", (Object)TipArtikla.POLU);
        q.setParameter("f", (Object)Boolean.FALSE);
        return q.getResultList();
    }

    public List<Artikal> readArtikliBezSlozenihIPolupr(List<Odeljenje> o) {
        Query q = this.base.createQuery("SELECT  a FROM Artikal a WHERE ((a.tip<>:tip1 and a.blokiran=:f) and((a.tip<>:tip2 and a.odeljenja in :o) ORDER BY a.name");
        q.setParameter("tip1", (Object)TipArtikla.SLOZ);
        q.setParameter("tip2", (Object)TipArtikla.POLU);
        q.setParameter("o", o);
        q.setParameter("f", (Object)Boolean.FALSE);
        return q.getResultList();
    }

    public List<Artikal> readArtikal(PodgrupaArtikala o) {
        Query query = this.base.createQuery("SELECT o FROM Artikal o WHERE  o.podgrupa = :grupa ORDER BY o.name");
        query.setParameter("grupa", (Object)o);
        return query.getResultList();
    }

    public List<Artikal> readArtikal(List<Artikal> artikli) {
        String ids = "(";
        for (int i = 0; i < artikli.size(); ++i) {
            ids = ids + artikli.get(i).getId().toString();
            ids = i != artikli.size() - 1 ? ids + "," : ids + ")";
        }
        Query query = this.base.createQuery("SELECT o FROM Artikal o WHERE  o.id IN " + ids + "  ORDER BY o.name");
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readArtikal(Long oID, String tip) {
        ArrayList<String> mapa = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String naziv = "";
        String selectString = tip != null ? "SELECT name FROM artikal WHERE( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID=" + oID + ") and artikal.tip='" + tip + "' ) ORDER BY artikal.name;" : "SELECT name FROM artikal WHERE artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID=" + oID + ") ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                naziv = rs.getString(1);
                mapa.add(naziv);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> readArtikal2(Long oID, String tip) {
        ArrayList<List<String>> artikli = new ArrayList<List<String>>();
        ArrayList<String> mapa = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = tip != null ? "SELECT name,jedinicaMere,tip,COALESCE(cena, 0) AS cena FROM artikal WHERE( (artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID=" + oID + ") and artikal.tip='" + tip + "')and artikal.blokiran ='0' ) ORDER BY artikal.name;" : "SELECT name,jedinicaMere,tip, COALESCE(cena, 0) AS cena FROM artikal WHERE (artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID=" + oID + ") and artikal.blokiran = 0) ORDER BY artikal.name;";
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery(selectString);
            System.out.println(selectString);
            while (rs.next()) {
                mapa = new ArrayList();
                mapa.add(rs.getString("name"));
                mapa.add(rs.getString("jedinicaMere"));
                mapa.add(rs.getString("cena"));
                mapa.add(rs.getString("tip"));
                artikli.add(mapa);
            }
            rs.close();
            stmt.close();
            this.conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, this.conn, rs);
        }
        return artikli;
    }

    public List<List<String>> readBlokiraneArtikle(Long oID) {
        ArrayList<List<String>> artikli = new ArrayList<List<String>>();
        ArrayList<String> mapa = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "SELECT name,jedinicaMere,tip,COALESCE(cena, 0) AS cena FROM artikal WHERE (artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID=" + oID + ") and artikal.blokiran = 1) ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa = new ArrayList();
                mapa.add(rs.getString("name"));
                mapa.add(rs.getString("jedinicaMere"));
                mapa.add(rs.getString("cena"));
                mapa.add(rs.getString("tip"));
                artikli.add(mapa);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return artikli;
    }

    public Artikal updateArtikal(Artikal a) {
        this.base.getTransaction().begin();
        try {
            a = (Artikal)this.base.merge((Object)a);
            List goaList = new LinkedList();
            if (a.getId() != null) {
                TypedQuery goatq = this.base.createQuery("SELECT goa FROM GrupaOA goa WHERE :a MEMBER OF goa.artikli", GrupaOA.class);
                goatq.setParameter("a", (Object)a);
                goaList = goatq.getResultList();
            } else {
                this.base.getTransaction().rollback();
            }
            LinkedList<GrupaOA> newGoaList = new LinkedList<GrupaOA>();
            for (GrupaOA goa : a.getGrupeOA()) {
                GrupaOA goaa = (GrupaOA)this.base.find(GrupaOA.class, (Object)goa.getId());
                if (goaa == null) continue;
                newGoaList.add(goaa);
            }
            for (GrupaOA goa : newGoaList) {
                goa = (GrupaOA)this.base.merge((Object)goa);
            }
            for (GrupaOA goa : newGoaList) {
                if (goa.getAtributi().contains(a)) continue;
                goa.getAtributi().add(a);
            }
            a.setGrupeOA(newGoaList);
            System.out.println("Update u Server");
            this.base.refresh((Object)a);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            Konstante.getPoruka3(this.shell, "Doslo je do greske prilikom rukovanja sa artiklom. Proverite ime mozda vec postoji!");
            this.base.getTransaction().rollback();
        }
        return a;
    }

    public void addOdeljenje(Odeljenje odeljenje) {
        this.base.getTransaction().begin();
        this.base.persist((Object)odeljenje);
        this.base.getTransaction().commit();
    }

    public void deleteOdeljenje(Odeljenje odeljenje) {
        this.base.getTransaction().begin();
        Odeljenje od = (Odeljenje)this.base.find(Odeljenje.class, (Object)odeljenje.getId());
        this.base.remove((Object)od);
        this.base.getTransaction().commit();
    }

    public Odeljenje updateOdeljenje(Odeljenje odeljenje) {
        this.base.getTransaction().begin();
        odeljenje = (Odeljenje)this.base.merge((Object)odeljenje);
        this.base.getTransaction().commit();
        return odeljenje;
    }

    public Map<Artikal, List<Double>> getMapZaArtikal(Date from, Date to, Konobar kon, Artikal artikal) {
        HashMap<Artikal, List<Double>> mapa = new HashMap<Artikal, List<Double>>();
        double cena = 0.0;
        double kolicina = 0.0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d1 = this.getPocetni(from);
        Date d2 = this.getKrajnji(to);
        String q = "Select sr.cena as cena, sum(sr.kolicina) as kolicina from stavkaracuna sr left join racun r  on r.id = sr.RACUN_ID where r.datum BETWEEN '" + sdf.format(d1) + "' and '" + sdf.format(d2) + "' and sr.ARTIKAL_ID = " + artikal.getId() + " and r.KONOBAR_ID = " + kon.getId() + " ";
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(q);
            rs = ps.executeQuery();
            rs.next();
            cena = rs.getLong("cena") != 0L ? (double)rs.getLong("cena") : 0.0;
            kolicina = rs.getLong("kolicina") != 0L ? (double)rs.getLong("kolicina") : 0.0;
            LinkedList<Double> lista = new LinkedList<Double>();
            lista.add(cena);
            lista.add(kolicina);
            mapa.put(artikal, lista);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapa;
    }

    public double getSumOdeljenje(Date from, Date to, Odeljenje o) {
        double suma = 0.0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d1 = this.getPocetni(from);
        Date d2 = this.getKrajnji(to);
        String q = "Select sum((sr.cena-(sr.cena*(r.popust*a.dozvoljenPopust/100)))*sr.kolicina) as suma from stavkaracuna sr left join racun r on r.id = sr.RACUN_ID left join artikal a on a.id = sr.ARTIKAL_ID left join artikal_odeljenje ao on ao.ARTIKLI_ID = a.id where r.zatvoren = 1 and storniran = 0 and r.datum BETWEEN '" + sdf.format(d1) + "' and '" + sdf.format(d2) + "' and ao.ODELJENJA_ID = " + o.getId() + " ";
        System.out.println(q);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(q);
            rs = ps.executeQuery();
            rs.next();
            suma = rs.getDouble("suma");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return suma;
    }

    public List<GlavniMeni> readGlavniMeni() {
        Query query = this.base.createQuery("SELECT g FROM GlavniMeni g order by g.id");
        return query.getResultList();
    }

    public List<GlavniMeniPodgrupa> readGlavniMeniPodgrupe() {
        Query query = this.base.createQuery("SELECT pg FROM GlavniMeniPodgrupa pg order by pg.id");
        return query.getResultList();
    }

    public GlavniMeni readGlavniMeniByNaziv(String naziv) {
        Query query = this.base.createQuery("SELECT g FROM GlavniMeni g WHERE g.naziv = :naziv");
        query.setParameter("naziv", (Object)naziv);
        try {
            return (GlavniMeni)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public GlavniMeniPodgrupa readGlavniMeniPodgrupaByNaziv(String naziv) {
        Query query = this.base.createQuery("SELECT gmp FROM GlavniMeniPodgrupa gmp WHERE gmp.naziv = :naziv");
        query.setParameter("naziv", (Object)naziv);
        try {
            return (GlavniMeniPodgrupa)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<GlavniMeniLogin> readGlavniMeniLogin() {
        Query query = this.base.createQuery("SELECT g FROM GlavniMeniLogin g order by g.id");
        return query.getResultList();
    }

    public List<GlavniMeniPodgrupaLogin> readGlavniMeniPodgrupaLogin() {
        Query query = this.base.createQuery("SELECT pg FROM GlavniMeniPodgrupaLogin pg order by pg.id");
        return query.getResultList();
    }

    public List<GlavniMeniLogin> readGlavniMeniLoginByLoginId(long id) {
        Query query = this.base.createQuery("SELECT g FROM GlavniMeniLogin g WHERE g.loginId = :id");
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public List<GlavniMeniPodgrupaLogin> readGlavniMeniPodgrupaLoginByLoginId(long id) {
        Query query = this.base.createQuery("SELECT gmp FROM GlavniMeniPodgrupaLogin gmp WHERE gmp.LoginId = :id");
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    public List<Odeljenje> readOdeljenje() {
        Query query = this.base.createQuery("SELECT o FROM Odeljenje o order by o.id");
        return query.getResultList();
    }

    public List<HacapMagacini> readHacapMagacine() {
        Query q = this.base.createQuery("SELECT m FROM HacapMagacini m WHERE m.blokiran = :b ");
        q.setParameter("b", (Object)Boolean.FALSE);
        return q.getResultList();
    }

    public List<Odeljenje> readOdeljenjeBezMag() {
        Query query = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o <> :m");
        query.setParameter("m", (Object)this.returnMagacin());
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> readOdeljenjaIDBezMag() {
        ArrayList<Long> lista = new ArrayList<Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id from odeljenje where odeljenje.naziv<>'MAGACIN';";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                lista.add(rs.getLong(1));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Odeljenje> readOdeljenjeBezMag2() {
        ArrayList<Odeljenje> mapa = new ArrayList<Odeljenje>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,naziv from odeljenje where odeljenje.naziv<>'MAGACIN';";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(1));
                o.setNaziv(rs.getString(2));
                mapa.add(o);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getArtikliPoKasaId(Kasa kasa) {
        ArrayList<Long> lista = new ArrayList<Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select ka.ARTIKLI_ID from kasa_artikli ka where ka.KASA_ID = " + kasa.getId() + " ;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                lista.add(rs.getLong(1));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikli(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id, name from artikal where ( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false) ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliLagerLista(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false) and artikal.tip IN ('SIRO', 'POLU', 'PROD') ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliVPfaktura(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + " ) AND artikal.tip <> 'SIRO' AND artikal.tip <> 'DODA' AND artikal.blokiran = false ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliZaUtrosak(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false) ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliZaOtpisSlozenih(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.tip not in ('POTR') and artikal.blokiran = false) ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliOdeljenje2(Long odeljenjeID) {
        ArrayList<Artikal> mapa = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera,blokiran, podgrupa_id from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false)ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                a.setBlokiran(rs.getBoolean("blokiran"));
                a.setPodgrupa(this.getpodgrupaById(rs.getLong("podgrupa_id")));
                mapa.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getArtikliIDOdeljenje2(Long odeljenjeID) {
        ArrayList<Long> mapa = new ArrayList<Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false)ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.add(rs.getLong(1));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getArtikliBezSlozISirOdeljenje2(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and (artikal.tip<>'SLOZ' and artikal.tip<>'SIRO')));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public Map<Long, Artikal> readArtikliBezSlozISir(Odeljenje odeljenje, PodgrupaArtikala podgrupa) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        String queryString = "SELECT a FROM Artikal a INNER JOIN a.odeljenja o WHERE o.id = :artikalOdeljenje AND (a.blokiran = false AND a.tip<>:sloz AND a.tip<>:sir AND a.podgrupa = :pga)";
        Query query = this.base.createQuery(queryString);
        query.setParameter("artikalOdeljenje", (Object)odeljenje.getId());
        query.setParameter("pga", (Object)podgrupa);
        query.setParameter("sloz", (Object)TipArtikla.SLOZ);
        query.setParameter("sir", (Object)TipArtikla.SIRO);
        for (Object obj : query.getResultList()) {
            Artikal a = (Artikal)obj;
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    public Map<Long, Artikal> readArtikliBezSlozISir(Odeljenje odeljenje) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        String queryString = "SELECT a FROM Artikal a INNER JOIN a.odeljenja o WHERE o.id = :artikalOdeljenje AND (a.blokiran = false AND a.tip<>:sloz AND a.tip<>:sir AND a.tip <> :potr)";
        Query query = this.base.createQuery(queryString);
        query.setParameter("artikalOdeljenje", (Object)odeljenje.getId());
        query.setParameter("sloz", (Object)TipArtikla.SLOZ);
        query.setParameter("sir", (Object)TipArtikla.SIRO);
        query.setParameter("potr", (Object)TipArtikla.POTR);
        for (Object obj : query.getResultList()) {
            Artikal a = (Artikal)obj;
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    public Map<Long, Artikal> readArtikliSirovine(Odeljenje odeljenje, PodgrupaArtikala podgrupa) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        String queryString = "SELECT a FROM Artikal a INNER JOIN a.odeljenja o WHERE o.id = :artikalOdeljenje AND (a.blokiran = false AND a.tip = :sir AND a.podgrupa = :pga)";
        Query query = this.base.createQuery(queryString);
        query.setParameter("artikalOdeljenje", (Object)odeljenje.getId());
        query.setParameter("pga", (Object)podgrupa);
        query.setParameter("sir", (Object)TipArtikla.SIRO);
        for (Object obj : query.getResultList()) {
            Artikal a = (Artikal)obj;
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    public Map<Long, Artikal> readArtikliSirovine(Odeljenje odeljenje) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        String queryString = "SELECT a FROM Artikal a INNER JOIN a.odeljenja o WHERE o.id = :artikalOdeljenje AND (a.blokiran = false AND a.tip = :sir)";
        Query query = this.base.createQuery(queryString);
        query.setParameter("artikalOdeljenje", (Object)odeljenje.getId());
        query.setParameter("sir", (Object)TipArtikla.SIRO);
        for (Object obj : query.getResultList()) {
            Artikal a = (Artikal)obj;
            mapa.put(a.getId(), a);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getArtikliSamoSlozeni(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera,barCode from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and artikal.tip = 'SLOZ' ));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                a.setBarCode(rs.getString(9));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getArtikliBezSlozOdeljenje2(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera,barCode from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and artikal.tip<>'SLOZ' ));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                a.setBarCode(rs.getString(9));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public Map<Long, Artikal> getArtikliBezSlozOdeljenjeOrderedByNameJPA2(Long odeljenjeID) {
        LinkedHashMap<Long, Artikal> mapa = new LinkedHashMap<Long, Artikal>();
        EntityManager em = this.base;
        try {
            TypedQuery tqa = em.createQuery("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND a.tip <> :sloz AND (EXISTS(SELECT od FROM Odeljenje od WHERE od.id = :odId and od MEMBER OF a.odeljenja)) ORDER BY a.name", Artikal.class);
            tqa.setParameter("odId", (Object)odeljenjeID);
            tqa.setParameter("sloz", (Object)TipArtikla.SLOZ);
            for (Artikal art : tqa.getResultList()) {
                mapa.put(art.getId(), art);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            mapa = new LinkedHashMap();
        }
        return mapa;
    }

    public Map<Long, Artikal> getArtikliBezSlozOdeljenjeOrderedByNameJPA(Long odeljenjeID) {
        LinkedHashMap<Long, Artikal> mapa = new LinkedHashMap<Long, Artikal>();
        EntityManager em = this.base;
        try {
            TypedQuery tqa = em.createQuery("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND a.tip <> :sloz AND a.tip <> :doda AND a.tip <> :potr AND (EXISTS(SELECT od FROM Odeljenje od WHERE od.id = :odId and od MEMBER OF a.odeljenja)) ORDER BY a.name", Artikal.class);
            tqa.setParameter("odId", (Object)odeljenjeID);
            tqa.setParameter("sloz", (Object)TipArtikla.SLOZ);
            tqa.setParameter("doda", (Object)TipArtikla.DODA);
            tqa.setParameter("potr", (Object)TipArtikla.POTR);
            for (Artikal art : tqa.getResultList()) {
                mapa.put(art.getId(), art);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
            mapa = new LinkedHashMap();
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getArtikliSirovineOdeljenje2(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and artikal.tip = 'SIRO'));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public Map<Long, Artikal> getSviArtikliOdeljenje2JPA(Long odeljenjeID) {
        LinkedHashMap<Long, Artikal> ret = new LinkedHashMap<Long, Artikal>();
        EntityManager em = this.getEM();
        try {
            TypedQuery q = em.createQuery("SELECT a.id, a FROM Artikal a WHERE a.odeljenja.id = :odId AND a.blokiran = FALSE AND a.tip <> TipArtikla.POTR ORDER BY a.name", Object[].class);
            q.setParameter("odId", (Object)odeljenjeID);
            for (Object[] row : q.getResultList()) {
                Long id = (Long)row[0];
                Artikal art = (Artikal)row[1];
                ret.put(id, art);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, MessageFormat.format("Gre\u0161ka kod \u010ditanja artikala za odeljenje (id = {0}):\n {1}", odeljenjeID, ex.getMessage()), ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getSviArtikliOdeljenje2(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera,jelo,pice from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false );";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                a.setJelo(rs.getBoolean(9));
                a.setPice(rs.getBoolean(10));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, String> getSviArtikliOdeljenje3(Odeljenje odeljenje, String tipovi, boolean blok) {
        TreeMap<Long, String> mapa = new TreeMap<Long, String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select name, coalesce(barcode,'-ne_postoji-') as barCode from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID in (" + (odeljenje == null ? "select id from artikal" : odeljenje.getId()) + ")) and artikal.blokiran = " + blok + " and artikal.tip in (" + tipovi + ")) and barcode is not null and length(barcode) > 0 order by barCode;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(Long.parseLong(rs.getString(2)), rs.getString(1));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getListaSviArtikliOdeljenje3(Odeljenje odeljenje, String tipovi, boolean blok) {
        ArrayList<Artikal> lista = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select name, tip, barcode, artikal.cena from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID in (" + (odeljenje == null ? "select id from artikal" : odeljenje.getId()) + ")) and artikal.blokiran = " + blok + " and artikal.tip in (" + tipovi + ")) order by coalesce(barCode+0, 7653423452652) asc;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setName(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setBarCode(rs.getString(3));
                a.setCena(rs.getDouble(4));
                lista.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return lista;
    }

    public Map<Long, Artikal> getArtikliBezSirovinaOdeljenje2JPA(Long odeljenjeID) {
        LinkedHashMap<Long, Artikal> ret = new LinkedHashMap<Long, Artikal>();
        EntityManager em = this.getEM();
        try {
            TypedQuery q = em.createQuery("SELECT a.id, a FROM Artikal a WHERE a.odeljenja.id = :odId AND a.blokiran = FALSE AND a.tip <> TipArtikla.SIRO AND a.tip <> TipArtikla.POTR ORDER BY a.name", Object[].class);
            q.setParameter("odId", (Object)odeljenjeID);
            for (Object[] row : q.getResultList()) {
                Long id = (Long)row[0];
                Artikal art = (Artikal)row[1];
                ret.put(id, art);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, MessageFormat.format("Gre\u0161ka kod \u010ditanja artikala za odeljenje (id = {0}):\n {1}", odeljenjeID, ex.getMessage()), ex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Artikal> getArtikliBezSirovinaOdeljenje2(Long odeljenjeID) {
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera,jelo,pice from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = false and artikal.tip <> 'SIRO');";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                a.setJelo(rs.getBoolean(9));
                a.setPice(rs.getBoolean(10));
                mapa.put(a.getId(), a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Odeljenje> getOdeljenjeArtikalBezMag2(Long artikalID) {
        ArrayList<Odeljenje> mapa = new ArrayList<Odeljenje>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,naziv from odeljenje where( odeljenje.id in (select ODELJENJA_ID from artikal_odeljenje where ARTIKLI_ID = " + artikalID + ") and odeljenje.naziv<>'MAGACIN');";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Odeljenje a = new Odeljenje();
                a.setId(rs.getLong(1));
                a.setNaziv(rs.getString(2));
                mapa.add(a);
            }
            if (mapa.isEmpty()) {
                Logger.getLogger(RestoranServer.class.getName()).log(Level.INFO, "Nije pronadjen zapis u tabeli artikal_odeljenje za artikal id = " + artikalID);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DnevnoStanje> getDnevnaStanja() {
        ArrayList<DnevnoStanje> mapa = new ArrayList<DnevnoStanje>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Object l = null;
        String selectString = "select id,artikal from dnevnostanje where artikalID IS NULL;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                DnevnoStanje a = new DnevnoStanje();
                a.setId(rs.getLong(1));
                a.setArtikal(rs.getString(2));
                mapa.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNazivStola(int broj) {
        log.info("Reading naziv from stonaziv for broj: " + broj);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String naziv = null;
        String selectString = "select naziv from stonaziv where stonaziv.broj = " + broj + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            rs.next();
            naziv = rs.getString(1);
            rs.close();
            log.finest("Found record in stonaziv with broj = " + broj + ". Returning naziv: " + naziv);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.warning("Cannot find recorn in stonaziv with broj = " + broj + ". Returning null.");
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return naziv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getPoluproizvodi(Odeljenje o) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where(( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + o.getId() + ")) and (artikal.tip = 'POLU' and artikal.blokiran = false))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliBezSloz(Long odeljenjeID) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where(( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ")) and (artikal.tip<>'SLOZ' and artikal.blokiran = false))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliBezSloz(Long odeljenjeID1, Long odeljenjeID2) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( (artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID1 + ") and (artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID2 + "))) and (artikal.tip<>'" + (Object)((Object)TipArtikla.SLOZ) + "' and artikal.blokiran = false))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliBezSloz(Long odeljenjeID, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and ( artikal.tip<>'SLOZ' and (artikal.blokiran = false and artikal.name LIKE '" + s + "%')))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliBezSlozByNameBarCode(Long odeljenjeID, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where artikal.tip<>'SLOZ' and artikal.blokiran = false and (artikal.name like '%" + s + "%' OR artikal.barcode like '%" + s + "%') and artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliBezSlozByTacanBarCodeIliNaziv(Long odeljenjeID, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where artikal.tip<>'SLOZ' and artikal.blokiran = false and (artikal.name = '" + s + "' OR artikal.barcode = '" + s + "') and artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getPoluproizvodiByNameBarCode(Long odeljenjeID, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and ( artikal.tip='POLU' and (artikal.blokiran = false and (artikal.name LIKE '%" + s + "%' OR artikal.barcode LIKE '%" + s + "%'))))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikli(Long odeljenjeID, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and artikal.name LIKE '%" + s + "%'))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public List<Artikal> readArtikliByNameOrBarcode(String nameOrBarcode) {
        Query q = this.base.createQuery("SELECT a FROM Artikal a WHERE (a.barCode LIKE :name OR a.name LIKE :name) AND (a.tip = :prod OR a.tip = :sloz)");
        q.setParameter("name", (Object)("%" + nameOrBarcode + "%"));
        q.setParameter("prod", (Object)TipArtikla.PROD);
        q.setParameter("sloz", (Object)TipArtikla.SLOZ);
        return q.getResultList();
    }

    public List<Artikal> readArtikliByBarcode(String nameOrBarcode) {
        Query q = this.base.createQuery("SELECT a FROM Artikal a WHERE a.barCode = :name AND (a.tip = :prod OR a.tip = :sloz)");
        q.setParameter("name", (Object)nameOrBarcode);
        q.setParameter("prod", (Object)TipArtikla.PROD);
        q.setParameter("sloz", (Object)TipArtikla.SLOZ);
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getKomitentiByNameOrTelefOrEmail(String s) {
        String selectString;
        String ime;
        Long id;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        TreeMap<String, Long> mapa;
        block6: {
            mapa = new TreeMap<String, Long>();
            conn = this.getConnection();
            stmt = null;
            rs = null;
            id = null;
            ime = "";
            selectString = "select rk.id, rk.ime from rezervacijekomitent rk where ((rk.ime LIKE '%" + s + "%') OR (rk.telefon LIKE '%" + s + "%') OR (rk.email LIKE '%" + s + "%')) ORDER BY rk.ime;";
            if (conn != null) break block6;
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            this.proveriKonekciju(stmt, conn, rs);
            return treeMap;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                ime = rs.getString(2);
                mapa.put(ime, id);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliByName(String s) {
        String selectString;
        String naziv;
        Long id;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        TreeMap<String, Long> mapa;
        block6: {
            mapa = new TreeMap<String, Long>();
            conn = this.getConnection();
            stmt = null;
            rs = null;
            id = null;
            naziv = "";
            selectString = "select id,name from artikal where artikal.name LIKE '%" + s + "%' ORDER BY artikal.name;";
            if (conn != null) break block6;
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            this.proveriKonekciju(stmt, conn, rs);
            return treeMap;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliByNameOrBarcodeSlozeni(Long odeljenjeID, String s) {
        String selectString;
        String naziv;
        Long id;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        TreeMap<String, Long> mapa;
        block6: {
            mapa = new TreeMap<String, Long>();
            conn = this.getConnection();
            stmt = null;
            rs = null;
            id = null;
            naziv = "";
            selectString = "select id,name from artikal where artikal.tip = 'SLOZ' and ( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and (artikal.name LIKE '%" + s + "%' OR artikal.barcode LIKE '%" + s + "%')))ORDER BY artikal.name;";
            if (conn != null) break block6;
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            this.proveriKonekciju(stmt, conn, rs);
            return treeMap;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getStalniGostByName(String s) {
        String selectString;
        String naziv;
        Long id;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        TreeMap<String, Long> mapa;
        block6: {
            mapa = new TreeMap<String, Long>();
            conn = this.getConnection();
            stmt = null;
            rs = null;
            id = null;
            naziv = "";
            selectString = "Select sg.id, sg.naziv from stalnigost sg where sg.naziv LIKE '%" + s + "%'  OR sg.pib LIKE '%" + s + "%' OR sg.sifra LIKE '%" + s + "%'";
            if (conn != null) break block6;
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            this.proveriKonekciju(stmt, conn, rs);
            return treeMap;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, Long> getArtikliByNameOrBarcode(Long odeljenjeID, String s) {
        String selectString;
        String naziv;
        Long id;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        TreeMap<String, Long> mapa;
        block6: {
            mapa = new TreeMap<String, Long>();
            conn = this.getConnection();
            stmt = null;
            rs = null;
            id = null;
            naziv = "";
            selectString = "select id,name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and (artikal.blokiran = false and (artikal.name LIKE '%" + s + "%' OR artikal.barcode LIKE '%" + s + "%')))ORDER BY artikal.name;";
            if (conn != null) break block6;
            TreeMap<String, Long> treeMap = new TreeMap<String, Long>();
            this.proveriKonekciju(stmt, conn, rs);
            return treeMap;
        }
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    public SortedMap<String, Long> getArtikli(Long odeljenjeID1, Long odeljenjeID2, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where((artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID1 + ") and artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID2 + "))and (artikal.blokiran = false and artikal.name LIKE '" + s + "%'))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return mapa;
    }

    public SortedMap<String, Long> getArtikliByNameOrBarCode(Long odeljenjeID1, Long odeljenjeID2, String s) {
        TreeMap<String, Long> mapa = new TreeMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id,name from artikal where((artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID1 + ") and artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID2 + "))and (artikal.blokiran = false and (artikal.name LIKE '%" + s + "%' OR artikal.barcode LIKE '%" + s + "%')))ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return mapa;
    }

    public List<String> getArtikliBezSlozenih(Long odeljenjeID) {
        ArrayList<String> mapa = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        Object id = null;
        String naziv = "";
        String selectString = "select name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.tip<>'SLOZ') ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                naziv = rs.getString(1);
                mapa.add(naziv);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return mapa;
    }

    public List<String> getSlozeniArtikli(Long odeljenjeID) {
        ArrayList<String> mapa = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String naziv = "";
        String selectString = "select name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and artikal.blokiran = 0 and (artikal.tip='SLOZ' OR artikal.tip='POLU' OR artikal.tip = 'DODA' OR (artikal.tip = 'PROD' AND artikal.mera <> 1))) ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                naziv = rs.getString(1);
                mapa.add(naziv);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return mapa;
    }

    public List<String> getArtikliBezSlozenihPG(Long podgrupaID) {
        ArrayList<String> mapa = new ArrayList<String>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        Object id = null;
        String naziv = "";
        String selectString = "select name from artikal where( artikal.id in (select ARTIKLI_ID from artikal_odeljenje where PODGRUPA_ID = " + podgrupaID + ") and artikal.tip<>'SLOZ') ORDER BY artikal.name;";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                naziv = rs.getString(1);
                mapa.add(naziv);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return mapa;
    }

    public List<AdministracijaPopusta> readAdministracijaPopusti() {
        Query query = this.base.createQuery("SELECT o FROM AdministracijaPopusta o");
        return query.getResultList();
    }

    public List<Stampac> readStampac() {
        Query query = this.base.createQuery("SELECT o FROM Stampac o");
        return query.getResultList();
    }

    public Stampac getStampacByNaziv(String naziv) {
        Query query = this.base.createQuery("SELECT o FROM Stampac o WHERE o.bnaziv = :naziv");
        query.setParameter("naziv", (Object)naziv);
        try {
            return (Stampac)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String readZbirniStampac() {
        Query query = this.base.createQuery("SELECT o.naziv FROM Stampac o WHERE o.stampaZbirnu=:t");
        query.setParameter("t", (Object)Boolean.TRUE);
        try {
            return (String)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getStampacTipByNaziv(String naziv) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String res = "";
        String selectString = "select tip from stampac where naziv = '" + naziv + "';";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                res = rs.getString(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return res;
    }

    public String readIzvestajiStampac() {
        Query query = this.base.createQuery("SELECT o.naziv FROM Stampac o WHERE o.stampaIzvestaje=:t");
        query.setParameter("t", (Object)Boolean.TRUE);
        try {
            return (String)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Stampac readGotovinskiStampacObject() throws Exception {
        TypedQuery query = this.base.createQuery("SELECT o FROM Stampac o WHERE o.stampaGotovinski=:t", Stampac.class);
        query.setParameter("t", (Object)Boolean.TRUE);
        query.setMaxResults(1);
        try {
            return (Stampac)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Doslo je do greske pri trazenju stampaca za gotovinski", e);
        }
    }

    public Stampac readIzvestajiStampacObject() throws Exception {
        TypedQuery query = this.base.createQuery("SELECT o FROM Stampac o WHERE o.stampaIzvestaje=:t", Stampac.class);
        query.setParameter("t", (Object)Boolean.TRUE);
        query.setMaxResults(1);
        try {
            return (Stampac)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Doslo je do greske pri trazenju stampaca za izvestaje", e);
        }
    }

    public void addAdministracijaPopust(AdministracijaPopusta ap) {
        this.base.getTransaction().begin();
        this.base.persist((Object)ap);
        this.base.getTransaction().commit();
    }

    public void deleteAdministracijaPopusta(AdministracijaPopusta ap) {
        this.base.getTransaction().begin();
        ap = (AdministracijaPopusta)this.base.find(AdministracijaPopusta.class, (Object)ap.getId());
        this.base.remove((Object)ap);
        this.base.getTransaction().commit();
    }

    public void updateAdministracijaPopusta(AdministracijaPopusta ap) {
        this.base.getTransaction().begin();
        this.base.merge((Object)ap);
        this.base.getTransaction().commit();
    }

    public void addStampac(Stampac stampac) {
        this.base.getTransaction().begin();
        this.base.persist((Object)stampac);
        this.base.getTransaction().commit();
    }

    public void deleteStampac(Stampac stampac) {
        this.base.getTransaction().begin();
        Stampac s = (Stampac)this.base.find(Stampac.class, (Object)stampac.getId());
        this.base.remove((Object)s);
        this.base.getTransaction().commit();
    }

    public void updateStampac(Stampac l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public List<JediniceMere> readJedMere() {
        Query query = this.base.createQuery("SELECT o FROM JediniceMere o");
        return query.getResultList();
    }

    public void addAtribut(Atribut at) {
        this.base.getTransaction().begin();
        this.base.persist((Object)at);
        this.base.getTransaction().commit();
    }

    public void addArtikalAtribut(ArtikalAtribut aa) {
        this.base.getTransaction().begin();
        this.base.persist((Object)aa);
        this.base.getTransaction().commit();
    }

    public void updateAtribut(Atribut at) {
        this.base.getTransaction().begin();
        this.base.merge((Object)at);
        this.base.getTransaction().commit();
    }

    public List<Atribut> listaArtikalAtribut(long id) {
        Query query = this.base.createQuery("SELECT aa FROM ArtikalAtribut aa WHERE aa.artikalID=:id group by aa.atributID");
        query.setParameter("id", (Object)id);
        return this.getAtributFromArtikalAtribut(query.getResultList());
    }

    public List<Atribut> getAtributFromArtikalAtribut(List rs) {
        ArrayList<Atribut> listaAtributa = new ArrayList<Atribut>();
        for (int i = 0; i < rs.size(); ++i) {
            long id = ((ArtikalAtribut)rs.get(i)).getAtributID();
            Query query = this.base.createQuery("SELECT a FROM Atribut a WHERE a.id=:id order by a.naziv");
            query.setParameter("id", (Object)id);
            listaAtributa.add((Atribut)query.getResultList().get(0));
        }
        return listaAtributa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getListGrafiksKasa(Kasa k) {
        LinkedList<Long> lista = new LinkedList<Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select kg.grafikID from kasa_grafici kg left join kasa k on k.id = kg.kasaID where k.id = " + k.getId() + " order BY kg.prioritet ";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                Long l = this.r.getLong("grafikID");
                lista.add(l);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KasaGrafik> getGrafikeOdKase(Kasa k) {
        LinkedList<KasaGrafik> lista = new LinkedList<KasaGrafik>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "Select * from kasa_grafici k where k.kasaID = " + k.getId() + " ";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                KasaGrafik kg = new KasaGrafik();
                kg.setId(this.r.getLong("id"));
                kg.setKasaID(this.r.getLong("kasaID"));
                kg.setGraficiID(this.r.getLong("grafikID"));
                kg.setPrioritet(this.r.getInt("prioritet"));
                lista.add(kg);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return lista;
    }

    public void deleteAtribut(Atribut at) {
        log.info("Brisanje atributa: " + at);
        this.base.getTransaction().begin();
        this.base.remove((Object)at);
        this.base.getTransaction().commit();
        log.fine("Obrisan atribut: " + at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteArikalAtribut(long artId, long atrId) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "DELETE FROM artikal_atribut WHERE  artikalID=" + artId + " and atributID= " + atrId + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(selectString);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKasaGrafik(Kasa k) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insert = "DELETE FROM kasa_grafici WHERE kasaID = " + k.getId() + " ;";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insert);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBazeSemArtikal() {
        String procedura = "delete_tables_exc_artikal";
        EntityManager em = this.getEM();
        if (!this.hasProcedure(procedura)) {
            this.createProcedureDeleteAllFromBaseExclArtikal();
        }
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String qBuilder = "CALL `delete_tables_exc_artikal`()";
            stmt.executeQuery(qBuilder);
        }
        catch (Exception ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArtikalPoreskaGrupa(int i) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insert = "update artikal a set a.poreskaGrupa = " + i + " WHERE a.id <> 0";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insert);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKasaGrafikSale(Kasa k, GrafikSale gs, int prioritet) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insert = "INSERT INTO kasa_grafici(id, kasaId, grafikID, prioritet) VALUES(null, " + k.getId() + "," + gs.getId() + "," + prioritet + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insert);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    public void addJedMere(JediniceMere l) {
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
    }

    public void addCenovnici(Cenovnici c) {
        this.base.getTransaction().begin();
        this.base.persist((Object)c);
        this.base.getTransaction().commit();
    }

    public void addGrupaTroskova(GrupaTroskova l) {
        log.info("Dodavanje grupe troskova: " + l);
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
        log.fine("Grupa troskova dodata: " + l);
    }

    public GrupaTroskova updateGrupaTroskova(GrupaTroskova l) {
        log.info("Izmena grupe troskova " + l);
        this.base.getTransaction().begin();
        l = (GrupaTroskova)this.base.merge((Object)l);
        this.base.getTransaction().commit();
        log.fine("Izmenjena grupa troskova: " + l);
        return l;
    }

    public void deleteGrupaTroskova(GrupaTroskova l) {
        log.info("Brisanje grupe troskova: " + l);
        this.base.getTransaction().begin();
        GrupaTroskova gt = (GrupaTroskova)this.base.find(GrupaTroskova.class, (Object)l.getId());
        this.base.remove((Object)gt);
        this.base.getTransaction().commit();
        log.fine("Obrisana grupa troskova: " + l);
    }

    public void addTipDokumenta(TipDokumenta t) {
        this.base.getTransaction().begin();
        this.base.persist((Object)t);
        this.base.getTransaction().commit();
    }

    public void addStoNaziv(StoNaziv l) {
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateStoNaziv(StoNaziv l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateJedMere(JediniceMere l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateZaposleni(Zaposleni l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateGrupaZaposlenih(GrupaZaposlenih l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void deleteJedMere(JediniceMere l) {
        this.base.getTransaction().begin();
        JediniceMere jm = (JediniceMere)this.base.find(JediniceMere.class, (Object)l.getId());
        this.base.remove((Object)jm);
        this.base.getTransaction().commit();
    }

    public void deleteZaposleni(Zaposleni l) {
        this.base.getTransaction().begin();
        Zaposleni jm = (Zaposleni)this.base.find(Zaposleni.class, (Object)l.getId());
        this.base.remove((Object)jm);
        this.base.getTransaction().commit();
    }

    public void deleteGrupaZaposelnih(GrupaZaposlenih l) {
        this.base.getTransaction().begin();
        GrupaZaposlenih jm = (GrupaZaposlenih)this.base.find(GrupaZaposlenih.class, (Object)l.getId());
        this.base.remove((Object)jm);
        this.base.getTransaction().commit();
    }

    public void deleteStoNaziv(StoNaziv l) {
        this.base.getTransaction().begin();
        StoNaziv jm = (StoNaziv)this.base.find(StoNaziv.class, (Object)l.getId());
        this.base.remove((Object)jm);
        this.base.getTransaction().commit();
    }

    public void addNormativ(Normativ l) {
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.flush();
        this.base.getTransaction().commit();
    }

    public void updateJPANormativ(Normativ l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateNormativ(Normativ n) {
        log.info(new Date() + "-Azuriranje normativa");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update normativ SET kolicina=" + n.getKolicina() + " WHERE normativ.id=" + n.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
            this.base.refresh((Object)n);
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "-Normativ azuriran");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNormativJPA(Normativ n) {
        log.info(new Date() + "-Azuriranje normativa");
        String insertString1 = "update normativ SET kolicina=" + n.getKolicina() + " WHERE normativ.id=" + n.getId();
        Normativ temp = null;
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            temp = n.getId() == null ? n : (!em.contains((Object)n) ? (Normativ)em.find(Normativ.class, (Object)n.getId()) : n);
            if (temp != null) {
                if (!em.contains((Object)n.getArtikal())) {
                    temp.setArtikal((Artikal)em.find(Artikal.class, (Object)n.getArtikal().getId()));
                } else {
                    temp.setArtikal(n.getArtikal());
                }
                if (!em.contains((Object)n.getSastojak())) {
                    temp.setSastojak((Artikal)em.find(Artikal.class, (Object)n.getSastojak().getId()));
                } else {
                    temp.setSastojak(n.getSastojak());
                }
                if (!em.contains((Object)n.getOdeljenje())) {
                    temp.setOdeljenje((Odeljenje)em.find(Odeljenje.class, (Object)n.getOdeljenje().getId()));
                } else {
                    temp.setOdeljenje(n.getOdeljenje());
                }
                temp.setKolicina(n.getKolicina());
            }
            trans.begin();
            temp = (Normativ)em.merge((Object)temp);
            trans.commit();
            if (this.base.contains((Object)n)) {
                this.base.refresh((Object)n);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        log.info(new Date() + "-Normativ azuriran");
    }

    public void updateDnevnoStanje(Long id, Long artikalId) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update dnevnostanje SET artikalID=" + artikalId + " WHERE dnevnostanje.id=" + id;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "-Normativ azuriran");
    }

    public void deleteNormativ(Normativ n) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM normativ WHERE normativ.id=" + n.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.warning("SQLException: " + ex.getMessage());
        }
    }

    public List<Normativ> readNormativJPA(Artikal a, Date datum) {
        try {
            Query q = this.base.createQuery("SELECT n FROM Normativ n WHERE n.artikal = :a and n.sastojak.blokiran = false and n.normativArtikal = :id");
            q.setParameter("a", (Object)a);
            q.setParameter("id", (Object)this.getNormativArtikalLastByArtikalID(a.getId(), datum));
            return q.getResultList();
        }
        catch (NoResultException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Normativ> readNormativ(Artikal a, Date datum) {
        ArrayList<Normativ> lista = new ArrayList<Normativ>();
        String query = "SELECT n.* FROM normativ n left join artikal a on a.id = n.SASTOJAK_ID WHERE n.ARTIKAL_ID = ? and n.NORMATIVARTIKAL_ID = ? and a.blokiran is false";
        Connection conn = this.getConnection();
        try {
            PreparedStatement pst = conn.prepareStatement(query);
            NormativArtikal naArtikal = this.getNormativArtikalLastByArtikalID(a.getId(), datum);
            if (naArtikal != null) {
                System.out.println("a.getId()" + a.getId());
                pst.setLong(1, a.getId());
                pst.setLong(2, naArtikal.getId());
                System.out.println(pst);
                ResultSet rs = pst.executeQuery();
                while (rs.next()) {
                    Normativ normativ = new Normativ();
                    normativ.setId(rs.getLong("id"));
                    normativ.setKolicina(rs.getDouble("kolicina"));
                    normativ.setArtikal(this.getArtikal(rs.getLong("ARTIKAL_ID")));
                    normativ.setOdeljenje(this.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                    normativ.setSastojak(this.getArtikal(rs.getLong("SASTOJAK_ID")));
                    normativ.setNormativArtikal(this.getNormativArtikal(rs.getLong("NORMATIVARTIKAL_ID")));
                    lista.add(normativ);
                }
            }
            return lista;
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public List<Stampac> getOdabraniStampaci(Artikal input) {
        LinkedList<Stampac> lista = new LinkedList<Stampac>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String q = "Select s.* from stampac s left join artikal_stampac ast on ast.STAMPAC_ID = s.id where ast.ARTIKLI_ID = " + input.getId();
        conn = this.getConnection();
        try {
            ps = conn.prepareStatement(q);
            rs = ps.executeQuery();
            while (rs.next()) {
                Stampac s = new Stampac();
                s.setId(rs.getLong("id"));
                s.setBrojKopijaZbirne(rs.getInt("brojKopijaZbirne"));
                s.setKodnaStrana(rs.getString("kodnaStrana"));
                s.setNaziv(rs.getString("naziv"));
                s.setStampaIzvestaje(rs.getBoolean("stampaIzvestaje"));
                s.setStampaZbirnu(rs.getBoolean("stampaZbirnu"));
                s.setBlankoLinija(rs.getInt("blankoLinija"));
                s.setBnaziv(rs.getString("bnaziv"));
                s.setBrojKopijaPorudzbine(rs.getInt("brojKopijaPorudzbine"));
                lista.add(s);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public Object readDNormativ(Artikal a) {
        Query q = this.base.createQuery("SELECT n FROM DnevniNormativ n WHERE n.artikal = :a");
        q.setParameter("a", (Object)a);
        try {
            return q.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<StalniGost> allDobavljaci() {
        Query query = this.base.createQuery("SELECT d FROM StalniGost d where (d.grupa is null and d.dobavljac = :t) ORDER BY d.naziv");
        query.setParameter("t", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    public Boolean vratiMagacin() {
        boolean rez = false;
        try {
            Query qm1 = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.magacin = TRUE");
            List odLista = qm1.getResultList();
            rez = !odLista.isEmpty();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Doslo je do greske prilikom trazenja magacina", e);
        }
        return rez;
    }

    public Odeljenje returnMagacin() {
        Odeljenje mag = null;
        try {
            Query qm1 = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.magacin = TRUE");
            List odLista = qm1.getResultList();
            if (odLista.isEmpty()) {
                Query qm2 = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.naziv = :magName");
                qm2.setParameter("magName", (Object)String.format(Konstante.getBundle().getString("OD_MAGACIN"), new Object[0]));
                odLista = qm2.getResultList();
                if (odLista.isEmpty()) {
                    Query qm3 = this.base.createQuery("SELECT o FROM Odeljenje o WHERE o.naziv = 'MAGACIN'");
                    odLista = qm3.getResultList();
                    if (!odLista.isEmpty()) {
                        mag = (Odeljenje)odLista.get(0);
                    }
                } else {
                    mag = (Odeljenje)odLista.get(0);
                }
            } else {
                mag = (Odeljenje)odLista.get(0);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Doslo je do greske prilikom trazenja magacina", e);
        }
        return mag;
    }

    public Zaposleni getZaposleni(String ime) {
        Query q = this.base.createQuery("SELECT z FROM Zaposleni z WHERE z.ime = :i");
        q.setParameter("i", (Object)ime);
        try {
            return (Zaposleni)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Kartica getLastNullKartica(Artikal artikal, Odeljenje o, Date date) {
        try {
            Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.artikal = :artikal AND k.odeljenje = :o) AND( k.crno IS NULL and k.datum=:date))");
            q.setParameter("artikal", (Object)artikal);
            q.setParameter("o", (Object)o);
            q.setParameter("date", (Object)date);
            return (Kartica)q.getSingleResult();
        }
        catch (Exception nre) {
            return null;
        }
    }

    public Kartica getLastKartica(Artikal artikal, Odeljenje o, Date date, Boolean crno) {
        Kartica returnKartica = null;
        try {
            this.qGetLastKartica.setParameter("artikal", (Object)artikal);
            this.qGetLastKartica.setParameter("o", (Object)o);
            this.qGetLastKartica.setParameter("date", (Object)date);
            this.qGetLastKartica.setParameter("c", (Object)crno);
            returnKartica = (Kartica)this.qGetLastKartica.getSingleResult();
        }
        catch (Exception nre) {
            log.warning("Kartica nije pronadjena! Vraca se null referenca.");
        }
        return returnKartica;
    }

    public void addKarticaJPA(Kartica k) {
        this.base.getTransaction().begin();
        this.base.persist((Object)k);
        this.base.getTransaction().commit();
        log.info("Nova kartica dodata");
    }

    public void addKartice(List<Kartica> list) {
        if (list.size() > 0) {
            log.info("Dodavanje grupe kartica: " + list.size());
            this.base.getTransaction().begin();
            for (int i = 0; i < list.size(); ++i) {
                Kartica k = list.get(i);
                this.base.persist((Object)list.get(i));
                if (i % 500 != 0) continue;
                this.base.getTransaction().commit();
                this.base.getTransaction().begin();
            }
            this.base.getTransaction().commit();
            log.info("Grupa kartica dodata");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKarticeNew(List<Kartica> list) {
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            if (list.size() > 0) {
                log.info("Dodavanje grupe kartica: " + list.size());
                trans.begin();
                for (int i = 0; i < list.size(); ++i) {
                    Kartica k = list.get(i);
                    if (k != null && k.getArtikal() != null && k.getOdeljenje() != null) {
                        if (!em.contains((Object)k.getArtikal())) {
                            Artikal art = (Artikal)em.find(Artikal.class, (Object)k.getArtikal().getId());
                            if (art != null) {
                                k.setArtikal(art);
                            } else {
                                log.info("preskocena kartica jer nije pronadjen artikal sa id = " + k.getArtikal().getId());
                                continue;
                            }
                        }
                        if (!em.contains((Object)k.getOdeljenje())) {
                            Odeljenje od = (Odeljenje)em.find(Odeljenje.class, (Object)k.getOdeljenje().getId());
                            if (od != null) {
                                k.setOdeljenje(od);
                            } else {
                                log.info("preskocena kartica jer nije pronadjeno odeljenje sa id = " + k.getOdeljenje().getId());
                                continue;
                            }
                        }
                        em.persist((Object)k);
                    } else if (k == null) {
                        log.info("preskocena null kartica u grupi");
                    } else if (k.getArtikal() == null) {
                        log.info("preskocena kartica sa null artiklom");
                    } else if (k.getOdeljenje() == null) {
                        log.info("preskocena kartica sa null odeljenjem");
                    }
                    if (i % 500 != 0) continue;
                    trans.commit();
                    trans.begin();
                }
                trans.commit();
                if (this.base != null && this.base.isOpen()) {
                    this.base.clear();
                }
                log.info("Grupa kartica dodata");
            }
        }
        catch (Exception ex) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.SEVERE, "Greska kod dodavanja grupe kartica", ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void updateKartice(List<Kartica> list) {
        if (list.size() > 0) {
            try {
                while (this.base.getTransaction().isActive()) {
                }
                log.info("Dodavanje grupe kartica: " + list.size());
                this.base.getTransaction().begin();
                for (int i = 0; i < list.size(); ++i) {
                    this.base.merge((Object)list.get(i));
                    this.base.flush();
                    this.base.clear();
                    log.info("Dodata kartica sa r.br " + (i + 1) + " iz grupe");
                    if (i % 500 != 0) continue;
                    this.base.getTransaction().commit();
                    this.base.getTransaction().begin();
                }
                log.info("Po\u010deta potvrda prenosa u bazu");
                this.base.getTransaction().commit();
                log.info("Grupa kartica dodata");
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
            }
        }
    }

    public void addStavkePopisa(List<StavkaPopisa> list) {
        log.info("Dodavanje grupe stavki popisa: " + list.size());
        this.base.getTransaction().begin();
        for (int i = 0; i < list.size(); ++i) {
            this.base.persist((Object)list.get(i));
            if (i % 500 != 0) continue;
            this.base.getTransaction().commit();
            this.base.getTransaction().begin();
        }
        this.base.getTransaction().commit();
        log.info("Grupa stavki popisa dodata");
    }

    public void addProizvodnja(Proizvodnja p) {
        log.info("Dodavanje proizvodnje");
        this.base.getTransaction().begin();
        this.base.persist((Object)p);
        this.base.getTransaction().commit();
        log.info("Proizvodnja dodata");
    }

    public void addOtpisJPA(Otpis o) {
        log.info("Dodavanje otpisa");
        this.base.getTransaction().begin();
        this.base.persist((Object)o);
        this.base.getTransaction().commit();
        log.info("Otpis dodat");
    }

    public void addProizvodnjaStavka(ProizvodnjaStavka ps) {
        log.info("Dodavanje stavke proizvodnje");
        this.base.getTransaction().begin();
        this.base.persist((Object)ps);
        this.base.getTransaction().commit();
        log.info("Stavka proizvodnje dodata");
    }

    public void addKartica(Kartica k) {
        log.info("Dodavanje kartice");
        this.base.getTransaction().begin();
        this.base.persist((Object)k);
        this.base.getTransaction().commit();
        log.info("Dodata kartica " + k.toString());
    }

    public void addKarticaNoCommit(Kartica k) {
        log.info("Dodavanje kartice");
        this.base.persist((Object)k);
        log.info("Dodata kartica " + k.toString());
    }

    public void addDnevnaStanja(List<DnevnoStanje> list) {
        log.info("Dodavanje grupe dnevnih stanja: " + list.size());
        this.base.getTransaction().begin();
        for (int i = 0; i < list.size(); ++i) {
            this.base.persist((Object)list.get(i));
            if (i % 200 != 0) continue;
            this.base.getTransaction().commit();
            this.base.getTransaction().begin();
        }
        this.base.getTransaction().commit();
        log.info("Grupa dnevnih stanja dodata");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDnevnoStanje(DnevnoStanje k) {
        log.info("Dodavanje dnevnog stanja za datum " + k.getDatum());
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into dnevnostanje values(null,'" + k.getArtikal() + "'," + k.getArtikalID() + "," + k.getBeloIzlaz() + "," + k.getBeloUlaz() + "," + k.getCrnoIzlaz() + "," + k.getCrnoUlaz() + ",'" + Konstante.getSQLFormat(k.getDatum()) + "'," + k.getOdeljenje().getId() + ")";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
        log.info(new Date() + "-dnevno stanje dodato");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZaposleni2(Zaposleni k) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into zaposleni values(null,'" + k.getAdresa() + "'," + k.getCenaSata() + ",'" + k.getFixni() + "','" + k.getIme() + "','" + k.getLk() + "','" + k.getMaticniBroj() + "','" + k.getMob() + "','" + k.getSifra() + "'," + k.getGrupa() + ")";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public void addZaposleni(Zaposleni k) {
        this.base.getTransaction().begin();
        this.base.persist((Object)k);
        this.base.getTransaction().commit();
    }

    public void addEvidencijaZaposlenih(EvidencijaZaposlenih k) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into evidencijazaposlenih values(null," + k.getCenaSata() + ",'" + Konstante.getSQLDateFormat(k.getDatum()) + "','" + Konstante.getSQLFormat(k.getDolazak()) + "','" + k.getIme() + "'," + k.isOdjavljen() + ",Null)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "-Kartica dodata");
    }

    public void deleteDnevnoStanje() {
        log.info("Brisanje tabele dnevnog stanja");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM dnevnostanje";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void deleteDnevnoStanje(Date datum) {
        log.info("Brisanje dnevnog stanja za datum " + datum);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM dnevnostanje WHERE datum='" + Konstante.getSQLDateFormat(datum) + "';";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getDnevnoStanjeBelo(Date datum, Odeljenje o, String pomocniString) {
        log.info(new Date() + "-get belo");
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(dnevnostanje.beloUlaz-dnevnostanje.beloIzlaz)from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "') GROUP BY artikalID;" : "select artikalID,sum(dnevnostanje.beloUlaz-dnevnostanje.beloIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "') GROUP BY artikalID;";
        try {
            System.out.println("Dnevno stanje belo je : " + selectString);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDnevnoStanjeBelo(Artikal a, Date datum, Odeljenje o) {
        log.info(new Date() + "-get belo");
        double d = 0.0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select sum(dnevnostanje.beloUlaz-dnevnostanje.beloIzlaz)from dnevnostanje where (dnevnostanje.artikalID =" + a.getId() + " and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "');" : "select sum(dnevnostanje.beloUlaz-dnevnostanje.beloIzlaz) from dnevnostanje where (dnevnostanje.artikalID =" + a.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "');";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d += rs.getDouble(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDnevnoStanjeMagBelo(Artikal a, Date datum, Odeljenje o) {
        log.info(new Date() + "-get belo");
        double d = 0.0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select sum(kartica.kolicina) from kartica where (kartica.ARTIKAL_ID =" + a.getId() + " and kartica.ODELJENJE_ID =" + o.getId() + " and kartica.datum <'" + Konstante.getSQLDateFormat(datum) + "' and (kartica.crno = 0 or kartica.crno = null));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                d += rs.getDouble(1);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDnevnoStanjeCrno(Artikal a, Date datum, Odeljenje o) {
        log.info(new Date() + "-get crno");
        double d = 0.0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = o != null ? "select sum(dnevnostanje.crnoUlaz-dnevnostanje.crnoIzlaz)from dnevnostanje where (dnevnostanje.artikalID =" + a.getId() + " and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "');" : "select sum(dnevnostanje.crnoUlaz-dnevnostanje.crnoIzlaz) from dnevnostanje where (dnevnostanje.artikalID =" + a.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "');";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                d += this.r.getDouble(1);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDnevnoStanjeMagCrno(Artikal a, Date datum, Odeljenje o) {
        log.info(new Date() + "-get crno");
        double d = 0.0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select sum(kartica.kolicina) from kartica where (kartica.ARTIKAL_ID =" + a.getId() + " and kartica.ODELJENJE_ID =" + o.getId() + " and kartica.datum <'" + Konstante.getSQLDateFormat(datum) + "' and kartica.crno > 0);";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                d += this.r.getDouble(1);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getPeriodicnoStanjeBeloUlaz(Date datum1, Date datum2, Odeljenje o, String pomocniString) {
        log.info(new Date() + "-get belo ulaz");
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(beloUlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "')  GROUP BY artikalID;" : "select artikalID,sum(beloUlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and (dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "')) GROUP BY artikalID;";
        try {
            System.out.println("P stanje belo ulaz je : " + selectString);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getPeriodicnoStanjeBeloIzlaz(Date datum1, Date datum2, Odeljenje o, String pomocniString) {
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        log.info(new Date() + "-get belo izlaz");
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(beloIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "') GROUP BY artikalID;" : "select artikalID,sum(beloIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "') GROUP BY artikalID;";
        try {
            System.out.println("P stanje belo izlaz je : " + selectString);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getDnevnoStanjeCrno(Date datum, Odeljenje o, String pomocniString) {
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(dnevnostanje.crnoUlaz-dnevnostanje.crnoIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "') GROUP BY artikalID;" : "select artikalID,sum(dnevnostanje.crnoUlaz-dnevnostanje.crnoIzlaz) from dnevnostanje where (dnevnostanje.artikalID = (" + pomocniString + ") and dnevnostanje.datum <'" + Konstante.getSQLDateFormat(datum) + "')GROUP BY artikalID;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getPeriodicnoStanjeCrnoUlaz(Date datum1, Date datum2, Odeljenje o, String pomocniString) {
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(crnoUlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "') GROUP BY artikalID;" : "select artikalID,sum(crnoUlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "') GROUP BY artikalID;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getPeriodicnoStanjeCrnoIzlaz(Date datum1, Date datum2, Odeljenje o, String pomocniString) {
        log.info("get crno");
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = o != null ? "select artikalID,sum(crnoIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.ODELJENJE_ID =" + o.getId() + " and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "') GROUP BY artikalID;" : "select artikalID,sum(crnoIzlaz) from dnevnostanje where (dnevnostanje.artikalID in (" + pomocniString + ") and dnevnostanje.datum >='" + Konstante.getSQLDateFormat(datum1) + "' and dnevnostanje.datum <='" + Konstante.getSQLDateFormat(datum2) + "')GROUP BY artikalID;";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public void addNormativJPAPersist(Normativ n) {
        this.base.getTransaction().begin();
        this.base.persist((Object)n);
        this.base.flush();
        this.base.getTransaction().commit();
    }

    public Long addNormativ(Normativ n, Long sastID) {
        log.info(new Date() + " - Dodavanje normativa za " + n.getArtikal().getName());
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into normativ values(null," + Double.valueOf(n.getKolicina()) + "," + n.getArtikal().getId() + "," + n.getOdeljenje().getId() + "," + sastID + ")";
        String selectString = "select id from normativ where normativ.id = (select max(id) from normativ)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            log.warning("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "-Normativ dodat");
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStavkaPopisa(StavkaPopisa sp) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into stavkapopisa (id,stanje0,stanje1,POPIS_ID,ARTIKAL_ID) values(null," + Double.valueOf(sp.getStanje0()) + "," + sp.getStanje1() + "," + sp.getPopis().getId() + "," + sp.getArtikal().getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public void addArtikalOdeljenje(Artikal a, Odeljenje o) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into artikal_odeljenje values(" + a.getId() + "," + o.getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void updateKartica(Kartica k) {
        log.info(new Date() + " - Azuriranje kartice " + k.toString());
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update kartica SET kolicina = " + k.getKolicina() + ", izlazKOM = " + k.getIzlazKOM() + " WHERE kartica.id = " + k.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + " - Kartica azurirana");
    }

    public void updateKarticaNoCommit(Kartica k) {
        log.info(new Date() + " - Azuriranje kartice " + k.toString());
        this.base.merge((Object)k);
        log.info(new Date() + " - Kartica azurirana");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePopisSravnjenje(Popis p) {
        log.info(new Date() + "-Azuriranje popisa");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update popis SET sravnjenje=" + p.getSravnjenje() + " WHERE popis.id=" + p.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public void updateArtikalNV(Artikal a) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update artikal SET trenutnaNV=" + a.getTrenutnaNV() + " WHERE artikal.id=" + a.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            log.severe("SQLException: " + ex.getMessage());
        }
    }

    public void deleteKartica(Kartica k) {
        log.info("Brisanje kartice " + k);
        this.base.getTransaction().begin();
        Kartica ka = (Kartica)this.base.find(Kartica.class, (Object)k.getId());
        this.base.remove((Object)ka);
        this.base.getTransaction().commit();
        log.info(" Kartica obrisana");
    }

    public void addPrijemnicaStavka(PrijemnicaStavka ps) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into prijemnicastavka values(null," + ps.getKolicina() + "," + ps.getKomad() + "," + ps.getVrednost() + "," + ps.getArtikal().getId() + "," + ps.getPrijemnica().getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void addPrijemnica(Prijemnica ps) {
        this.base.getTransaction().begin();
        this.base.persist((Object)ps);
        this.base.getTransaction().commit();
    }

    public Long addTrebovanje(Trebovanje ps) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        Long izID = ps.getIz() != null ? ps.getIz().getId() : null;
        Long uID = ps.getU() != null ? ps.getU().getId() : null;
        Long dobID = ps.getDobavljac() != null ? ps.getDobavljac().getId() : null;
        boolean nardz = false;
        StringBuilder stringBuilder = new StringBuilder().append("aaa");
        ps.getTip().getTipDokumenta();
        System.out.println(stringBuilder.append((Object)TipTrebovanja.DokumentAtribut.NARUDZ).toString());
        ps.getTip().getTipDokumenta();
        if (TipTrebovanja.DokumentAtribut.NARUDZ != null) {
            ps.getIz().setId(null);
        }
        String insertString1 = "insert into trebovanje values(null,'" + ps.getBrTrebovanja() + "'," + ps.getCrno() + ",'" + Konstante.getSQLFormat(ps.getDatumTrebovanja()) + "','" + Konstante.getSQLFormat(ps.getDatumUnosa()) + "','" + ps.getOpis() + "','" + ps.getUname() + "'," + dobID + "," + izID + "," + uID + ");";
        String selectString = "select id from trebovanje where trebovanje.id = (select max(id) from trebovanje)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return id;
    }

    public void saveUtrosakDoc(UtrosakDoc ud) {
        this.base.getTransaction().begin();
        this.base.persist((Object)ud);
        this.base.getTransaction().commit();
    }

    public void updateUtrosakDoc(UtrosakDoc ud) {
        this.base.getTransaction().begin();
        this.base.merge((Object)ud);
        this.base.getTransaction().commit();
    }

    public Long addUtrosakDoc(UtrosakDoc ps) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into utrosakdoc values(null,'" + ps.getBroj() + "'," + ps.isCrno() + ",'" + Konstante.getSQLFormat(ps.getDatum()) + "','" + ps.getOpis() + "','" + ps.getUname() + "'," + ps.getOdeljenje().getId() + ");";
        String selectString = "select id from utrosakdoc where utrosakdoc.id = (select max(id) from otpis)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return id;
    }

    public Long addOtpis(Otpis ps) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into otpis values(null,'" + ps.getBroj() + "'," + ps.isCrno() + ",'" + Konstante.getSQLFormat(ps.getDatum()) + "','" + ps.getOpis() + "','" + ps.getUname() + "'," + ps.getOdeljenje().getId() + ");";
        String selectString = "select id from otpis where otpis.id = (select max(id) from otpis)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return id;
    }

    public Long getArtikalId(String name) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id from artikal where artikal.name='" + name + "';";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return id;
    }

    public Odeljenje getOdeljenjeJPA(Long id) {
        return (Odeljenje)this.base.find(Odeljenje.class, (Object)id);
    }

    public Odeljenje getOdeljenje(Long id) {
        Odeljenje o = new Odeljenje();
        o.setId(id);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select naziv,kratkiNaziv from odeljenje where odeljenje.id='" + id + "';";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                o.setNaziv(rs.getString(1));
                o.setKratkiNaziv(rs.getString(2));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return o;
    }

    public Artikal getArtikal(Long id) {
        Query query = this.getBase().createQuery("SELECT a FROM Artikal a WHERE a.id=:id");
        query.setParameter("id", (Object)id);
        try {
            return (Artikal)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public double getArtikalCena(Long id) {
        String query = "SELECT cena FROM Artikal a WHERE a.id=?";
        double cena = 0.0;
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            cena = rs.getLong("cena");
            return cena;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return cena;
        }
    }

    public Artikal getArtikalJPA(String naziv) {
        TypedQuery q = this.base.createQuery("SELECT entity FROM Artikal entity WHERE entity.name = :naziv", Artikal.class).setParameter("naziv", (Object)naziv);
        q.setMaxResults(1);
        try {
            return (Artikal)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            this.warning("Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja artikla sa slede\u0107im nazivom >>> " + naziv);
            return null;
        }
    }

    public ArtikalTarget addArtikalTarget(Artikal a, Konobar k, String nagradaNovac, String nagradaProcenat) {
        ArtikalTarget at = new ArtikalTarget();
        at.setArtikal(a);
        at.setKonobar(k);
        at.setNagradaNovac(nagradaNovac);
        at.setNagradaProcenat(nagradaProcenat);
        this.base.getTransaction().begin();
        this.base.persist((Object)at);
        this.base.getTransaction().commit();
        return at;
    }

    public void removeArtikalTarget(ArtikalTarget at) {
        this.base.getTransaction().begin();
        this.base.remove((Object)at);
        this.base.getTransaction().commit();
    }

    public List<Artikal> getArtikalFromArtikalTarget(Konobar k) {
        LinkedList<Artikal> at = new LinkedList();
        Query q = this.base.createQuery("SELECT DISTINCT at.artikal from ArtikalTarget at WHERE at.konobar = :k");
        q.setParameter("k", (Object)k);
        at = q.getResultList();
        return at;
    }

    public List<ArtikalTarget> getArtikalTarget(Konobar k) {
        LinkedList<ArtikalTarget> at = new LinkedList();
        Query q = this.base.createQuery("SELECT DISTINCT at from ArtikalTarget at WHERE at.konobar = :k");
        q.setParameter("k", (Object)k);
        at = q.getResultList();
        return at;
    }

    public ArtikalTarget readArtikalTarget(Artikal a, Konobar k) {
        ArtikalTarget at = new ArtikalTarget();
        Query q = this.base.createQuery("SELECT at from ArtikalTarget at WHERE at.artikal = :a and at.konobar = :k");
        q.setParameter("a", (Object)a);
        q.setParameter("k", (Object)k);
        at = (ArtikalTarget)q.getSingleResult();
        return at;
    }

    public List<ArtikalTarget> getArtikalTarget(Artikal a, Konobar k) {
        LinkedList<ArtikalTarget> at = new LinkedList();
        Query q = this.base.createQuery("SELECT at from ArtikalTarget at WHERE at.artikal = :a and at.konobar = :k");
        q.setParameter("a", (Object)a);
        q.setParameter("k", (Object)k);
        at = q.getResultList();
        return at;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Artikal getArtikal2(String naziv) {
        Artikal a = new Artikal();
        a.setName(naziv);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena from artikal where artikal.name='" + naziv.replace("'", "''") + "';";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return a;
    }

    public Normativ getNormativJPA(Artikal artikal, Artikal sastojak) throws Exception {
        TypedQuery q = this.base.createQuery("SELECT n FROM Normativ n WHERE n.artikal = :artikal AND n.sastojak = :sastojak", Normativ.class);
        q = q.setParameter("artikal", (Object)artikal).setParameter("sastojak", (Object)sastojak);
        q = q.setMaxResults(1);
        try {
            return (Normativ)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja normativa za artikal ID = " + artikal.getId() + " i sastojak ID = " + sastojak.getId(), e);
        }
    }

    public Normativ getNormativ(Artikal id1, Artikal id2) {
        Normativ n = new Normativ();
        n.setArtikal(id1);
        n.setSastojak(id2);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id,ODELJENJE_ID from normativ where (ARTIKAL_ID=" + id1.getId() + " and SASTOJAK_ID=" + id2.getId() + ");";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                n.setId(rs.getLong(1));
                n.setOdeljenje(this.getOdeljenje(rs.getLong(2)));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return n;
    }

    public List<Normativ> getFullNormativ(Artikal a) {
        List<Object> ret = new LinkedList();
        LinkedList<Normativ> retN = new LinkedList<Normativ>();
        LinkedList<Long> retNew = new LinkedList<Long>();
        ret = this.getNormativiByLastNormativiArtikal(a.getId());
        for (Normativ normativ : ret) {
            retNew.add(normativ.getId());
        }
        ListIterator<Long> i = retNew.listIterator();
        while (i.hasNext()) {
            Long l = (Long)i.next();
            for (Normativ norma : this.getNormativiByLastNormativiArtikal(l)) {
                i.add(norma.getId());
            }
        }
        for (Long l : retNew) {
            Normativ normativ = this.getNormativById(l);
            System.out.println(normativ.getSastojak() + " " + (Object)((Object)normativ.getSastojak().getTip()));
            if (normativ.getSastojak().getTip().equals((Object)TipArtikla.SLOZ) || normativ.getSastojak().getTip().equals((Object)TipArtikla.DODA)) continue;
            retN.add(normativ);
        }
        return retN;
    }

    public Normativ getNormativSingle(Artikal s, Artikal a) {
        Query q = this.base.createQuery("select n from Normativ n where n.sastojak = :s and n.artikal = :a");
        q.setParameter("s", (Object)s);
        q.setParameter("a", (Object)a);
        Normativ ret = (Normativ)q.getSingleResult();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Normativ> getNormativi(Long artikalId) {
        Artikal a = new Artikal();
        a.setId(artikalId);
        ArrayList<Normativ> normativi = new ArrayList<Normativ>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,kolicina,ODELJENJE_ID,SASTOJAK_ID from normativ where ARTIKAL_ID=" + artikalId + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Normativ n = new Normativ();
                n.setArtikal(a);
                n.setId(rs.getLong(1));
                n.setKolicina(rs.getDouble(2));
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(3));
                n.setOdeljenje(o);
                Artikal s = new Artikal();
                s.setId(rs.getLong(4));
                n.setSastojak(s);
                normativi.add(n);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return normativi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Normativ> getNormativiByLastNormativiArtikal(Long artikalId) {
        Artikal a = new Artikal();
        a.setId(artikalId);
        ArrayList<Normativ> normativi = new ArrayList<Normativ>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select n.* from normativ n left join artikal a on a.id = n.SASTOJAK_ID where n.ARTIKAL_ID = " + artikalId + " and a.blokiran is false and n.NORMATIVARTIKAL_ID = (select na.id from normativartikal na where na.ARTIKAL_ID = n.ARTIKAL_ID order by na.id desc limit 1);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Normativ n = new Normativ();
                n.setArtikal(this.getArtikal(rs.getLong("ARTIKAL_ID")));
                n.setId(rs.getLong(1));
                n.setKolicina(rs.getDouble("kolicina"));
                n.setOdeljenje(this.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                n.setSastojak(this.getArtikal(rs.getLong("SASTOJAK_ID")));
                n.setNormativArtikal(this.getNormativArtikal(rs.getLong("NORMATIVARTIKAL_ID")));
                normativi.add(n);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return normativi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Normativ getNormativById(Long artikalId) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,kolicina,ARTIKAL_ID,ODELJENJE_ID,SASTOJAK_ID from normativ where id =" + artikalId + ";";
        Normativ n = new Normativ();
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            rs.next();
            n.setId(rs.getLong(1));
            n.setKolicina(rs.getDouble(2));
            n.setArtikal(this.getArtikal(rs.getLong(3)));
            Odeljenje o = new Odeljenje();
            o.setId(rs.getLong(4));
            n.setOdeljenje(o);
            n.setSastojak(this.getArtikal(rs.getLong(5)));
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Normativ> getNormativiBelo(Date d1, Date d2) {
        ArrayList<Normativ> normativi = new ArrayList<Normativ>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')));";
        String selectString = "select id,kolicina,ODELJENJE_ID,SASTOJAK_ID,ARTIKAL_ID from normativ where normativ.ARTIKAL_ID in " + pomocniString + ";";
        try {
            PreparedStatement ps = conn.prepareStatement(selectString);
            System.out.println(ps);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Normativ n = new Normativ();
                Artikal a = new Artikal();
                a.setId(rs.getLong(5));
                n.setArtikal(a);
                n.setId(rs.getLong(1));
                n.setKolicina(rs.getDouble(2));
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(3));
                n.setOdeljenje(o);
                Artikal s = new Artikal();
                s.setId(rs.getLong(4));
                n.setSastojak(s);
                normativi.add(n);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return normativi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliNormativiBelo2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')))";
        String pomocniString2 = "(select SASTOJAK_ID from normativ where normativ.ARTIKAL_ID in " + pomocniString + ")";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,name,mera,id from artikal where artikal.id in " + pomocniString2 + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setName(rs.getString(5));
                a.setMera(rs.getDouble(6));
                a.setId(rs.getLong(7));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliNormativiCrno2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NOT NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')))";
        String pomocniString2 = "(select SASTOJAK_ID from normativ where normativ.ARTIKAL_ID in " + pomocniString + ")";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,name,mera,id from artikal where artikal.id in " + pomocniString2 + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setName(rs.getString(5));
                a.setMera(rs.getDouble(6));
                a.setId(rs.getLong(7));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Normativ> getNormativiCrno(Date d1, Date d2) {
        ArrayList<Normativ> normativi = new ArrayList<Normativ>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NOT NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')));";
        String selectString = "select id,kolicina,ODELJENJE_ID,SASTOJAK_ID,ARTIKAL_ID from normativ where normativ.ARTIKAL_ID in " + pomocniString + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Normativ n = new Normativ();
                Artikal a = new Artikal();
                a.setId(rs.getLong(5));
                n.setArtikal(a);
                n.setId(rs.getLong(1));
                n.setKolicina(rs.getDouble(2));
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(3));
                n.setOdeljenje(o);
                Artikal s = new Artikal();
                s.setId(rs.getLong(4));
                n.setSastojak(s);
                normativi.add(n);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return normativi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliStavkeBelo2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')));";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where artikal.id in " + pomocniString + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliKarticeBelo2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString2 = "(select id from odeljenje where naziv = 'MAGACIN')";
        String pomocniString1 = "(select ARTIKAL_ID from kartica where ((datum BETWEEN '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "' AND dokument IS NOT NULL) AND (crno = " + 0 + " AND ODELJENJE_ID <> " + pomocniString2 + ")));";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where artikal.id in " + pomocniString1 + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliKarticeCrno2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString2 = "(select id from odeljenje where naziv = 'MAGACIN')";
        String pomocniString1 = "(select ARTIKAL_ID from kartica where ((datum BETWEEN '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "' AND dokument IS NOT NULL) AND (crno = " + 1 + " AND ODELJENJE_ID <> " + pomocniString2 + ")));";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where artikal.id in " + pomocniString1 + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineBelo2(Date d1, Date d2) {
        log.info("Citanje osnovnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID, sum(kolicina) from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje  IS NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')) GROUP BY ARTIKAL_ID);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(pomocniString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineBelo2(Date d1, Date d2, Odeljenje o) {
        log.info("Citanje osnovnog prometa za period " + d1 + " do " + d2 + " za odeljenje " + o);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID, sum(kolicina) from stavkaracuna where RACUN_ID in (select id from racun where ((racun.crnoPlacanje IS NULL OR racun.crnoPlacanje LIKE '%HOTEL%' OR racun.naOsnovno = 0 ) AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')) and artikal_id in (select artikli_id from artikal_odeljenje where odeljenja_id = " + o.getId() + ") GROUP BY ARTIKAL_ID);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(pomocniString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineOsnovneRekonstrukcija(Date d1, Date d2) {
        log.info("Citanje osnovnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        EntityManager em = this.getEM();
        TypedQuery query = em.createQuery("SELECT sr.artikal.id, SUM(sr.kolicina) FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje IS NULL OR sr.racun.crnoPlacanje LIKE '%HOTEL%' OR sr.racun.naOsnovno = :o) AND sr.racun.datum BETWEEN :d1 AND :d2 AND sr.artikal IS NOT NULL AND sr.racun.kasa is null GROUP BY sr.artikal.id", Object[].class);
        query.setParameter("d1", d1, TemporalType.TIMESTAMP);
        query.setParameter("d2", d2, TemporalType.TIMESTAMP);
        query.setParameter("o", (Object)Boolean.TRUE);
        try {
            List lista = query.getResultList();
            System.out.println("lista.size() = " + lista.size());
            for (Object[] objects : lista) {
                Long artId = (Long)objects[0];
                Double kol = (Double)objects[1];
                System.out.println("artId = " + artId);
                System.out.println("kol = " + kol);
                System.out.println("");
                if (!mapa.containsKey(artId)) {
                    mapa.put(artId, 0.0);
                }
                mapa.put(artId, StatLogic.round((Double)mapa.get(artId) + kol, 4));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Greska prilikom citanja osnovnog prometa za period " + d1 + " -> " + d2, ex);
            mapa = new HashMap();
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<Long, Double>> getArtikliKolicineOsnovneRekonstrukcijaNova(Date d1, Date d2) {
        log.info("Citanje osnovnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Map<Long, Double>> mapa = new HashMap<Long, Map<Long, Double>>();
        EntityManager em = this.getEM();
        TypedQuery query = em.createQuery("SELECT sr.artikal, sr.racun.kasa, SUM(sr.kolicina) FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje IS NULL OR sr.racun.crnoPlacanje LIKE '%HOTEL%' OR sr.racun.naOsnovno = :o ) AND sr.racun.datum BETWEEN :d1 AND :d2 AND sr.artikal IS NOT NULL AND sr.racun.kasa IS NOT NULL GROUP BY sr.artikal, sr.racun.kasa", Object[].class);
        query.setParameter("d1", d1, TemporalType.TIMESTAMP);
        query.setParameter("d2", d2, TemporalType.TIMESTAMP);
        query.setParameter("o", (Object)Boolean.TRUE);
        try {
            List lista = query.getResultList();
            System.out.println("lista.size() = " + lista.size());
            for (Object[] objects : lista) {
                Artikal art = (Artikal)objects[0];
                Kasa k = (Kasa)objects[1];
                Double kol = (Double)objects[2];
                Odeljenje od = null;
                for (Odeljenje odeljenje : art.getOdeljenja()) {
                    if (!k.getProdajnoMesto().getOdeljenja().contains(odeljenje)) continue;
                    od = odeljenje;
                    break;
                }
                if (od == null) continue;
                Long artId = art.getId();
                System.out.println("artId = " + artId);
                System.out.println("kol = " + kol);
                System.out.println("od.getId() = " + od.getId());
                if (mapa.get(artId) == null) {
                    mapa.put(artId, new HashMap());
                }
                Map tmpMap = (Map)mapa.get(artId);
                Double tmpKol = 0.0;
                if (tmpMap.get(od.getId()) != null) {
                    tmpKol = (Double)tmpMap.get(od.getId());
                }
                tmpKol = tmpKol + kol;
                tmpMap.put(od.getId(), StatLogic.round(tmpKol, 4));
                mapa.put(artId, tmpMap);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Greska prilikom citanja osnovnog prometa za period " + d1 + " -> " + d2, ex);
            mapa = new HashMap();
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Map<Long, Double>> getArtikliKolicineDodatneRekonstrukcijaNova(Date d1, Date d2) {
        log.info("Citanje osnovnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Map<Long, Double>> mapa = new HashMap<Long, Map<Long, Double>>();
        EntityManager em = this.getEM();
        TypedQuery query = em.createQuery("SELECT sr.artikal, sr.racun.kasa, SUM(sr.kolicina) FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje IS NOT NULL AND sr.racun.crnoPlacanje NOT LIKE '%HOTEL%' AND sr.racun.naOsnovno = :o ) AND sr.racun.datum BETWEEN :d1 AND :d2 AND sr.artikal IS NOT NULL AND sr.racun.kasa IS NOT NULL GROUP BY sr.artikal, sr.racun.kasa", Object[].class);
        query.setParameter("d1", d1, TemporalType.TIMESTAMP);
        query.setParameter("d2", d2, TemporalType.TIMESTAMP);
        query.setParameter("o", (Object)Boolean.FALSE);
        try {
            List lista = query.getResultList();
            System.out.println("lista.size() = " + lista.size());
            for (Object[] objects : lista) {
                Artikal art = (Artikal)objects[0];
                Kasa k = (Kasa)objects[1];
                Double kol = (Double)objects[2];
                Odeljenje od = null;
                for (Odeljenje odeljenje : art.getOdeljenja()) {
                    if (!k.getProdajnoMesto().getOdeljenja().contains(odeljenje)) continue;
                    od = odeljenje;
                    break;
                }
                if (od == null) {
                    System.out.println("cont");
                    System.out.println("artId = " + art.getId());
                    System.out.println("kol = " + kol);
                    System.out.println("k.getId() = " + k.getId());
                    System.out.println("----");
                    continue;
                }
                Long artId = art.getId();
                System.out.println("artId = " + artId);
                System.out.println("kol = " + kol);
                System.out.println("od.getId() = " + od.getId());
                if (mapa.get(artId) == null) {
                    mapa.put(artId, new HashMap());
                }
                Map tmpMap = (Map)mapa.get(artId);
                Double tmpKol = 0.0;
                if (tmpMap.get(od.getId()) != null) {
                    tmpKol = (Double)tmpMap.get(od.getId());
                }
                tmpKol = tmpKol + kol;
                tmpMap.put(od.getId(), StatLogic.round(tmpKol, 4));
                mapa.put(artId, tmpMap);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Greska prilikom citanja osnovnog prometa za period " + d1 + " -> " + d2, ex);
            mapa = new HashMap();
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        System.out.println("mapa.size() = " + mapa.size());
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineDodatneRekonstrukcija(Date d1, Date d2) {
        log.info("Citanje dodatnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        EntityManager em = this.getEM();
        TypedQuery query = em.createQuery("SELECT sr.artikal.id, SUM(sr.kolicina) FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje IS NOT NULL AND sr.racun.crnoPlacanje NOT LIKE '%HOTEL%' AND sr.racun.naOsnovno = :o ) AND sr.racun.datum BETWEEN :d1 AND :d2 AND sr.artikal IS NOT NULL AND sr.racun.kasa IS NULL GROUP BY sr.artikal.id", Object[].class);
        query.setParameter("d1", d1, TemporalType.TIMESTAMP);
        query.setParameter("d2", d2, TemporalType.TIMESTAMP);
        query.setParameter("o", (Object)Boolean.FALSE);
        try {
            List lista = query.getResultList();
            System.out.println("lista.size() = " + lista.size());
            for (Object[] objects : lista) {
                Long artId = (Long)objects[0];
                System.out.println("artId = " + artId);
                Double kol = (Double)objects[1];
                System.out.println("kol = " + kol);
                System.out.println("");
                if (!mapa.containsKey(artId)) {
                    mapa.put(artId, 0.0);
                }
                mapa.put(artId, StatLogic.round((Double)mapa.get(artId) + kol, 4));
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Greska prilikom citanja dodatnog prometa za period " + d1 + " -> " + d2, ex);
            mapa = new HashMap();
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineCrno2(Date d1, Date d2) {
        log.info("Citanje dodatnog prometa za period " + d1 + " do " + d2);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID,sum(kolicina) from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NOT NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')) GROUP BY ARTIKAL_ID);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(pomocniString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineCrno2(Date d1, Date d2, Odeljenje o) {
        log.info("Citanje dodatnog prometa za period " + d1 + " do " + d2 + " za odeljenje " + o);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID,sum(kolicina) from stavkaracuna where RACUN_ID in (select id from racun where ((racun.crnoPlacanje IS NOT NULL AND racun.crnoPlacanje NOT LIKE '%HOTEL%')AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')) and artikal_id in (select artikli_id from artikal_odeljenje where odeljenja_id = " + o.getId() + ") GROUP BY ARTIKAL_ID);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(pomocniString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Artikal> getArtikliStavkeCrno2(Date d1, Date d2) {
        ArrayList<Artikal> artikli = new ArrayList<Artikal>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID from stavkaracuna where RACUN_ID in (select id from racun where (racun.crnoPlacanje IS NOT NULL AND racun.datum BETWEEN  '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "')));";
        String selectString = "select jedinicaMere,tip,trenutnaNV,poreskaGrupa,id,cena,name,mera from artikal where artikal.id in " + pomocniString + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Artikal a = new Artikal();
                a.setJedinicaMere(rs.getString(1));
                a.setTip(StavkeSumarno.getTipArtikla(rs.getString(2)));
                a.setTrenutnaNV(rs.getDouble(3));
                a.setPoreskaGrupa(StavkeSumarno.getPoreskaStopa(rs.getInt(4)));
                a.setId(rs.getLong(5));
                a.setCena(rs.getDouble(6));
                a.setName(rs.getString(7));
                a.setMera(rs.getDouble(8));
                artikli.add(a);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return artikli;
    }

    public List<Kartica> getKarticeZaDan(Date datum) {
        log.info("Iscitavanje kartica za datum " + datum);
        Query query = this.base.createQuery("SELECT o FROM Kartica o WHERE o.datum = :d");
        query.setParameter("d", (Object)datum);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Kartica> getKarticeZaDanDPUBelo2(Date d1, Date d2) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select id from odeljenje where naziv = 'MAGACIN')";
        String selectString = "select ARTIKAL_ID,ODELJENJE_ID,kolicina,dokument from kartica where ((datum BETWEEN '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "' AND dokument IS NOT NULL) AND (crno = " + 0 + " AND ODELJENJE_ID <> " + pomocniString + "));";
        try {
            System.out.println("");
            System.out.println("select = " + selectString);
            System.out.println("");
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Kartica k = new Kartica();
                Artikal a = new Artikal();
                a.setId(rs.getLong(1));
                k.setArtikal(a);
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(2));
                k.setOdeljenje(o);
                k.setKolicina(rs.getDouble(3));
                k.setDokument(rs.getString(4));
                kartice.add(k);
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return kartice;
    }

    public List<Kartica> getKarticeZaDane(Date pocetni, Date zavrsni, boolean crno) {
        String jpaQueryKartice = "SELECT k FROM Kartica k WHERE k.datum BETWEEN :d1 AND :d2 AND LENGTH(k.dokument) > 0 AND k.crno = :crno AND k.odeljenje <> :m";
        Query q = this.base.createQuery(jpaQueryKartice);
        q.setParameter("d1", (Object)pocetni);
        q.setParameter("d2", (Object)zavrsni);
        q.setParameter("crno", (Object)crno);
        q.setParameter("m", (Object)this.returnMagacin());
        return q.getResultList();
    }

    public List<Kartica> readKartice(Date zaDan, Boolean crno, Odeljenje odeljenje) {
        String selectString = "SELECT k FROM Kartica k WHERE k.datum LIKE :datum AND k.crno = :crno AND k.odeljenje = :odeljenje";
        Query q = this.base.createQuery(selectString);
        q.setParameter("datum", (Object)zaDan);
        q.setParameter("crno", (Object)crno);
        q.setParameter("odeljenje", (Object)odeljenje);
        return q.getResultList();
    }

    public List<Kartica> readKarticaSaDokumentom(String dokument) {
        String queryString = "SELECT k FROM Kartica k WHERE k.dokument = :dokument AND k.odeljenje <> :m";
        Query q = this.base.createQuery(queryString);
        q.setParameter("dokument", (Object)dokument);
        q.setParameter("m", (Object)this.returnMagacin());
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Kartica> getKarticeZaDanDPUCrno2(Date d1, Date d2) {
        ArrayList<Kartica> kartice = new ArrayList<Kartica>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select id from odeljenje where naziv = 'MAGACIN')";
        String selectString = "select ARTIKAL_ID,ODELJENJE_ID,kolicina from kartica where ((datum BETWEEN '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "'AND dokument IS NOT NULL) AND (crno = " + 1 + " AND ODELJENJE_ID <> " + pomocniString + "));";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                Kartica k = new Kartica();
                Artikal a = new Artikal();
                a.setId(rs.getLong(1));
                k.setArtikal(a);
                Odeljenje o = new Odeljenje();
                o.setId(rs.getLong(2));
                k.setOdeljenje(o);
                k.setKolicina(rs.getDouble(3));
                kartice.add(k);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return kartice;
    }

    public List<Prijemnica> readPrijemnicePoDatumima(Date d1, Date d2, StalniGost k, boolean n) {
        Query q;
        if (k != null) {
            q = this.base.createQuery("SELECT DISTINCT p FROM Prijemnica p LEFT JOIN FETCH p.knjizenja WHERE p.datumPrijemnice BETWEEN :d1 and :d2 AND p.dobavljac = :k" + (n ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.prijemnica = p AND k.realizovano = true) ORDER BY p.datumPrijemnice" : " ORDER BY p.datumPrijemnice"));
            q.setParameter("d1", (Object)d1);
            q.setParameter("d2", (Object)d2);
            q.setParameter("k", (Object)k);
        } else {
            q = this.base.createQuery("SELECT DISTINCT p FROM Prijemnica p LEFT JOIN p.knjizenja k WHERE p.datumPrijemnice BETWEEN :d1 and :d2" + (n ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.prijemnica = p AND k.realizovano = true) ORDER BY p.datumPrijemnice" : " ORDER BY p.datumPrijemnice"));
            q.setParameter("d1", (Object)d1);
            q.setParameter("d2", (Object)d2);
        }
        System.out.println(q.toString());
        return q.getResultList();
    }

    public List<Prijemnica> readPrijemnice() {
        Query q = this.base.createQuery("SELECT p FROM Prijemnica p ORDER BY p.datumPrijemnice");
        return q.getResultList();
    }

    public List<Prijemnica> readPrijemnice(Date datum) {
        log.info("Citanje prijemnica za datum " + datum);
        Query q = this.base.createQuery("SELECT p FROM Prijemnica p WHERE p.datumPrijemnice = :d");
        q.setParameter("d", (Object)datum);
        return q.getResultList();
    }

    public List<Popis> readPopis(Date d, Date d2, Odeljenje o, boolean crno) {
        Query q = this.base.createQuery("SELECT p FROM Popis p WHERE (p.datum BETWEEN :d AND :d2) AND p.crno = :c AND p.odeljenje = :o");
        q.setParameter("d", (Object)d);
        q.setParameter("d2", (Object)d2);
        q.setParameter("o", (Object)o);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Popis> readPopis(Date d, Date d2, Odeljenje o) {
        Query q = this.base.createQuery("SELECT p FROM Popis p WHERE (p.datum BETWEEN :d AND :d2) AND p.odeljenje = :o");
        q.setParameter("d", (Object)d);
        q.setParameter("d2", (Object)d2);
        q.setParameter("o", (Object)o);
        return q.getResultList();
    }

    public List getStavkePopisa(Popis p, boolean lastPrice) {
        LinkedList<StavkaPopisa> list = new LinkedList<StavkaPopisa>();
        String query = "SELECT imeArtikla, jedinicaMere, \nstanje, ROUND ((stanje * jedinicnaNabavnaVrednost),2)AS vrednostPopisaStanje, \npopis,  ROUND((popis * jedinicnaNabavnaVrednost),2) AS vrednostPopisaPopis,\nROUND((popis * prodajnaCena),2) AS prodajnaVrednost,\njedinicnaNabavnaVrednost, ARTIKAL_ID, razlika, poreskaGrupa\nFROM (SELECT  a.name AS imeArtikla, a.jedinicaMere, sp.stanje0 AS stanje, sp.stanje1 AS popis,\n\t(SELECT COALESCE((Select ROUND(ts.komadBPDV,2)  from trebovanjestavka ts \n\t\tJOIN trebovanje t ON ts.TREBOVANJE_ID = t.id\n\t\tWHERE t.tip IN('DIREKTNO_SA_KNJIZ','DIREKTNO_BEZ_KNJIZ','IZ_MAGACINA') \n\t\tAND t.crno = 0 AND t.datumTrebovanja <= ? and\n\t\tts.ARTIKAL_ID = a.id order by ts.id desc limit 1),0)) AS jedinicnaNabavnaVrednost,\n\t(SELECT COALESCE((Select ts.prodajnaVrednost  from trebovanjestavka ts \n\t\tJOIN trebovanje t ON ts.TREBOVANJE_ID = t.id\n\t\tWHERE t.tip IN('DIREKTNO_SA_KNJIZ','DIREKTNO_BEZ_KNJIZ','IZ_MAGACINA') \n\t\tAND t.crno = 0 AND t.datumTrebovanja <= ? and\n\t\tts.ARTIKAL_ID = a.id order by ts.id desc limit 1),0)) AS prodajnaCena ,\nROUND(sp.stanje1 - sp.stanje0,4) as razlika, a.id AS ARTIKAL_ID, a.poreskaGrupa\nFROM  stavkapopisa sp \nJOIN popis p ON sp.POPIS_ID = p.id\nJOIN artikal a ON sp.ARTIKAL_ID = a.id\nWHERE p.id = ?\nORDER BY a.name) AS trt";
        Connection conn = this.getConnection();
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(p.getDatum().getTime()));
            ps.setDate(2, new java.sql.Date(p.getDatum().getTime()));
            ps.setLong(3, p.getId());
            System.out.println(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkaPopisa sp = new StavkaPopisa();
                Artikal art = new Artikal();
                sp.setImeArtikla(rs.getString("ImeArtikla"));
                sp.setJedinicaMere(rs.getString("jedinicaMere"));
                sp.setStanje(rs.getDouble("stanje"));
                sp.setVrednostPopisaStanje(rs.getDouble("vrednostPopisaStanje"));
                sp.setPopisPo(rs.getDouble("popis"));
                sp.setVrednostPopisaPopis(rs.getDouble("vrednostPopisaPopis"));
                sp.setJedinicnaNabavnaVrednost(rs.getDouble("jedinicnaNabavnaVrednost"));
                sp.setProdajnaVrednost(rs.getDouble("prodajnaVrednost"));
                sp.setRazlika(rs.getDouble("razlika"));
                art = (Artikal)this.base.find(Artikal.class, (Object)rs.getLong("ARTIKAL_ID"));
                sp.setArtikal(art);
                list.add(sp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return list;
    }

    public List getStavkePopisa_0(Popis p, boolean lastPrice) {
        LinkedList<StavkaPopisa> list = new LinkedList<StavkaPopisa>();
        String query = "SELECT DISTINCT  a.name as imeArtikla, a.jedinicaMere as jedinicaMere, ROUND(sp.stanje0,4) as stanje, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje0, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje0 ),4)  as vrednostPopisaStanje, ROUND(sp.stanje1,4) as 'popis', ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje1, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje1 ), 4) as vrednostPopisaPopis, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )),4) as jedinicnaNabavnaVrednost,  ROUND(COALESCE((sp.stanje1 / a.mera) * (IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 ))) , 0),4) as prodajnaVrednost, ROUND(sp.stanje1 - sp.stanje0,4) as razlika\tFROM stavkapopisa sp left join artikal a on a.id = sp.ARTIKAL_ID left join trebovanjestavka ts on ts.ARTIKAL_ID = a.id where sp.POPIS_ID =" + p.getId() + " AND a.poreskaGrupa = 1  group by a.name";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                StavkaPopisa sp = new StavkaPopisa();
                sp.setImeArtikla(rs.getString(1));
                sp.setJedinicaMere(rs.getString(2));
                sp.setStanje(rs.getDouble(3));
                sp.setVrednostPopisaStanje(rs.getDouble(4));
                sp.setPopisPo(rs.getDouble(5));
                sp.setVrednostPopisaPopis(rs.getDouble(6));
                sp.setJedinicnaNabavnaVrednost(rs.getDouble(7));
                sp.setProdajnaVrednost(rs.getDouble(8));
                sp.setRazlika(rs.getDouble(9));
                list.add(sp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return list;
    }

    public List getStavkePopisa_10(Popis p, boolean lastPrice) {
        LinkedList<StavkaPopisa> list = new LinkedList<StavkaPopisa>();
        String query = "SELECT DISTINCT  a.name as imeArtikla, a.jedinicaMere as jedinicaMere, ROUND(sp.stanje0,4) as stanje, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje0, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje0 ),4)  as vrednostPopisaStanje, ROUND(sp.stanje1,4) as 'popis', ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje1, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje1 ), 4) as vrednostPopisaPopis, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )),4) as jedinicnaNabavnaVrednost,  ROUND(COALESCE((sp.stanje1 / a.mera) * (IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 ))) , 0),4) as prodajnaVrednost, ROUND(sp.stanje1 - sp.stanje0,4) as razlika\tFROM stavkapopisa sp left join artikal a on a.id = sp.ARTIKAL_ID left join trebovanjestavka ts on ts.ARTIKAL_ID = a.id where sp.POPIS_ID =" + p.getId() + " AND a.poreskaGrupa = 4  group by a.name";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                StavkaPopisa sp = new StavkaPopisa();
                sp.setImeArtikla(rs.getString(1));
                sp.setJedinicaMere(rs.getString(2));
                sp.setStanje(rs.getDouble(3));
                sp.setVrednostPopisaStanje(rs.getDouble(4));
                sp.setPopisPo(rs.getDouble(5));
                sp.setVrednostPopisaPopis(rs.getDouble(6));
                sp.setJedinicnaNabavnaVrednost(rs.getDouble(7));
                sp.setProdajnaVrednost(rs.getDouble(8));
                sp.setRazlika(rs.getDouble(9));
                list.add(sp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return list;
    }

    public List getStavkePopisa_20(Popis p, boolean lastPrice) {
        LinkedList<StavkaPopisa> list = new LinkedList<StavkaPopisa>();
        String query = "SELECT DISTINCT  a.name as imeArtikla, a.jedinicaMere as jedinicaMere, ROUND(sp.stanje0,4) as stanje, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje0, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje0 ),4)  as vrednostPopisaStanje, ROUND(sp.stanje1,4) as 'popis', ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1) * sp.stanje1, (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )* sp.stanje1 ), 4) as vrednostPopisaPopis, ROUND(IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 )),4) as jedinicnaNabavnaVrednost,  ROUND(COALESCE((sp.stanje1 / a.mera) * (IF(" + lastPrice + ",(Select ts.komadBPDV  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id  and ts.komadBPDV <> 0 group by ts.id desc limit 1), (Select AVG(ts.komadBPDV)  from trebovanjestavka ts where ts.ARTIKAL_ID =a.id and ts.komadBPDV <> 0 ))) , 0),4) as prodajnaVrednost, ROUND(sp.stanje1 - sp.stanje0,4) as razlika\tFROM stavkapopisa sp left join artikal a on a.id = sp.ARTIKAL_ID left join trebovanjestavka ts on ts.ARTIKAL_ID = a.id where sp.POPIS_ID =" + p.getId() + " AND a.poreskaGrupa = 3  group by a.name";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                StavkaPopisa sp = new StavkaPopisa();
                sp.setImeArtikla(rs.getString(1));
                sp.setJedinicaMere(rs.getString(2));
                sp.setStanje(rs.getDouble(3));
                sp.setVrednostPopisaStanje(rs.getDouble(4));
                sp.setPopisPo(rs.getDouble(5));
                sp.setVrednostPopisaPopis(rs.getDouble(6));
                sp.setJedinicnaNabavnaVrednost(rs.getDouble(7));
                sp.setProdajnaVrednost(rs.getDouble(8));
                sp.setRazlika(rs.getDouble(9));
                list.add(sp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return list;
    }

    public List<Popis> readPopisClassic(Date d) {
        LinkedList<Popis> popisi = new LinkedList<Popis>();
        String select = "Select p.* from popis p where p.datum = '" + d + "' ";
        Connection conn = this.getConnection();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(select);
            while (rs.next()) {
                Popis sp = new Popis();
                sp.setId(rs.getLong("id"));
                sp.setBroj(rs.getInt("broj"));
                sp.setCrno(rs.getBoolean("crno"));
                sp.setDatum(rs.getDate("datum"));
                sp.setObaStanja(rs.getBoolean("obaStanja"));
                sp.setOdeljenje(this.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                sp.setSravnjenje(rs.getBoolean("sravnjenje"));
                sp.setUser(rs.getString("user"));
                popisi.add(sp);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return popisi;
    }

    public List<Popis> readPopis(Date d) {
        Query q = this.base.createQuery("SELECT p FROM Popis p WHERE p.datum = :d");
        q.setParameter("d", (Object)d);
        return q.getResultList();
    }

    public Popis getPopis(Date datum, int broj, boolean crno) {
        Query q = this.base.createQuery("SELECT p FROM Popis p WHERE p.datum = :d AND p.broj = :b AND p.crno = :crno");
        q.setParameter("d", (Object)datum);
        q.setParameter("b", (Object)broj);
        q.setParameter("crno", (Object)crno);
        Popis p = null;
        try {
            p = (Popis)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
        return p;
    }

    public Popis getPopisLager(Date datum, Odeljenje o, boolean osnovnoDodatno) {
        Query q = this.getBase().createQuery("SELECT p FROM Popis p WHERE p.datum = (SELECT max(p.datum) FROM Popis p WHERE p.datum <= :d AND p.odeljenje = :o and p.crno = :osnovnoDodatno AND p.sravnjenje = TRUE)  AND p.odeljenje = :o and p.crno = :osnovnoDodatno AND p.sravnjenje = TRUE order by p.id desc").setMaxResults(1);
        q.setParameter("d", (Object)datum);
        q.setParameter("o", (Object)o);
        q.setParameter("osnovnoDodatno", (Object)osnovnoDodatno);
        System.out.println(q);
        Popis p = null;
        try {
            p = (Popis)q.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
        return p;
    }

    public List<UtrosakDoc> readUtrosakDoc(Date d) {
        log.info("Citanje UtrosakDoc od datuma " + d);
        LinkedList<UtrosakDoc> lista = new LinkedList<UtrosakDoc>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date pocetni = this.getPocetni(d);
        String d1 = sdf.format(pocetni);
        String q = "SELECT o.* FROM UtrosakDoc o WHERE o.datum  BETWEEN '" + d1 + "' and now()";
        Connection con = null;
        PreparedStatement ps = null;
        System.out.println(q.toString());
        con = this.getConnection();
        try {
            ps = con.prepareStatement(q);
            this.r = ps.executeQuery();
            while (this.r.next()) {
                UtrosakDoc o = new UtrosakDoc();
                o.setId(this.r.getLong("id"));
                o.setBroj(this.r.getString("broj"));
                o.setDatum(this.r.getDate("datum"));
                o.setOpis(this.r.getString("opis"));
                o.setUname(this.r.getString("uname"));
                o.setCrno(this.r.getBoolean("crno"));
                o.setOdeljenje(this.getOdeljenje(this.r.getLong("ODELJENJE_ID")));
                o.setStavke(this.getUtrosakDocStavke(o));
                lista.add(o);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public List<UtrosakDoc> readUtrosakDoc(Date d, Date d2, Odeljenje od, boolean crno) {
        log.info("Citanje UtrosakDoc za odeljenje " + od + " i datum " + d + " i " + d2);
        LinkedList<UtrosakDoc> otpisi = new LinkedList<UtrosakDoc>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date pocetni = this.getPocetni(d);
        Date krajnji = this.getKrajnji(d2);
        String d1 = sdf.format(pocetni);
        String d2a = sdf.format(krajnji);
        String q = "SELECT o.* FROM UtrosakDoc o WHERE o.datum  BETWEEN '" + d1 + "' and '" + d2a + "' AND (o.crno = " + crno + " AND o.ODELJENJE_ID = " + od.getId() + ")";
        Connection con = null;
        PreparedStatement ps = null;
        System.out.println(q.toString());
        con = this.getConnection();
        try {
            ps = con.prepareStatement(q);
            this.r = ps.executeQuery();
            while (this.r.next()) {
                UtrosakDoc o = new UtrosakDoc();
                o.setId(this.r.getLong("id"));
                o.setBroj(this.r.getString("broj"));
                o.setDatum(this.r.getDate("datum"));
                o.setOpis(this.r.getString("opis"));
                o.setUname(this.r.getString("uname"));
                o.setCrno(this.r.getBoolean("crno"));
                otpisi.add(o);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return otpisi;
    }

    public List<Otpis> readOtpisa(Date d, Date d2, Odeljenje od, boolean crno) {
        log.info("Citanje otpisa za odeljenje " + od + " i datum " + d + " i " + d2);
        LinkedList<Otpis> otpisi = new LinkedList<Otpis>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String d1 = sdf.format(d);
        String d2a = sdf.format(d2);
        String q = "SELECT o.* FROM Otpis o WHERE o.datum  BETWEEN '" + d1 + "' and '" + d2a + "' AND (o.crno = " + crno + " AND o.ODELJENJE_ID = " + od.getId() + ")";
        Connection con = null;
        PreparedStatement ps = null;
        System.out.println(q.toString());
        con = this.getConnection();
        try {
            ps = con.prepareStatement(q);
            this.r = ps.executeQuery();
            while (this.r.next()) {
                Otpis o = new Otpis();
                o.setId(this.r.getLong("id"));
                o.setBroj(this.r.getString("broj"));
                o.setDatum(this.r.getDate("datum"));
                o.setOpis(this.r.getString("opis"));
                o.setUname(this.r.getString("uname"));
                o.setCrno(this.r.getBoolean("crno"));
                otpisi.add(o);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return otpisi;
    }

    public List<UtrosakDoc> readUtrosakDoc(Date d, Odeljenje o, boolean crno) {
        log.info("Citanje utroska za odeljenje i datum " + d);
        Date p = this.getPocetni(d);
        Date k = this.getKrajnji(d);
        Query q = this.base.createQuery("SELECT p FROM UtrosakDoc p WHERE (p.datum BETWEEN :d1 AND :d2 AND (p.crno = :c AND p.odeljenje = :o))");
        q.setParameter("d1", (Object)p);
        q.setParameter("d2", (Object)k);
        q.setParameter("o", (Object)o);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Otpis> readOtpis(Date d, Odeljenje o, boolean crno) {
        log.info("Citanje otpisa za odeljenje i datum " + d);
        Query q = this.base.createQuery("SELECT p FROM Otpis p WHERE (p.datum = :d AND (p.crno = :c AND p.odeljenje = :o))");
        q.setParameter("d", (Object)d);
        q.setParameter("o", (Object)o);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Otpis> readOtpisFromDate(Date d) {
        log.info("Citanje otpisa za odeljenje i datum " + d);
        Query q = this.base.createQuery("SELECT o FROM Otpis o WHERE o.datum between :d and :d1");
        q.setParameter("d", (Object)d);
        q.setParameter("d1", (Object)new Date());
        System.out.println(q);
        return q.getResultList();
    }

    public List<Proizvodnja> readProizvodnja(Date d, Odeljenje o, boolean crno) {
        log.info("Citanje proizvodnji za odeljenje " + o + " i datum " + d);
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE (p.datum = :d AND(p.crno = :c AND p.odeljenje = :o))");
        q.setParameter("d", (Object)d);
        q.setParameter("o", (Object)o);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Proizvodnja> readProizvodnja(Date d) {
        log.info("Citanje proizvodnji za odeljenje  i datum " + d);
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE p.datum between :d and :d1");
        q.setParameter("d", (Object)d);
        q.setParameter("d1", (Object)new Date());
        return q.getResultList();
    }

    public Proizvodnja readProizvodnja(long id) {
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE p.id =:id");
        q.setParameter("id", (Object)id);
        return (Proizvodnja)q.getSingleResult();
    }

    public List<Proizvodnja> readProizvodnja(Odeljenje o, Date day1, Date day2, boolean crno) {
        log.info("Citanje proizvodnji za odeljenje " + o);
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE (p.crno = :c AND p.odeljenje = :o) AND p.datum BETWEEN :d1 and :d2 ");
        q.setParameter("o", (Object)o);
        q.setParameter("d1", (Object)day1);
        q.setParameter("d2", (Object)day2);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Proizvodnja> readProizvodnjaByZD(Odeljenje o, Date day1, boolean crno) {
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE (p.crno = :c AND p.odeljenje = :o) AND p.datum = :d1");
        q.setParameter("o", (Object)o);
        q.setParameter("d1", (Object)day1);
        q.setParameter("c", (Object)crno);
        return q.getResultList();
    }

    public List<Proizvodnja> readProizvodnja(Odeljenje o) {
        log.info("Citanje proizvodnji za odeljenje " + o);
        Query q = this.base.createQuery("SELECT p FROM Proizvodnja p WHERE p.odeljenje = :o");
        q.setParameter("o", (Object)o);
        return q.getResultList();
    }

    public List<Kartica> readKartice(Artikal artikal, Odeljenje odeljenje) {
        Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE (k.artikal = :artikal AND k.odeljenje =:odeljenje) ORDER BY k.datum ASC");
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("artikal", (Object)artikal);
        return q.getResultList();
    }

    public List<Kartica> readKarticeBele2(Artikal artikal, Date d1, Date d2) {
        Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE (k.artikal = :artikal AND (k.crno IS NULL OR k.crno = false) AND k.datum BETWEEN :d1 AND :d2) ORDER BY k.datum ASC");
        q.setParameter("artikal", (Object)artikal);
        q.setParameter("d1", (Object)d1);
        q.setParameter("d2", (Object)d2);
        return q.getResultList();
    }

    public List<Kartica> readKarticeBele(Artikal artikal, Odeljenje odeljenje) {
        Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE (k.artikal = :artikal AND k.odeljenje =:odeljenje AND (k.crno IS NULL OR k.crno = false)) ORDER BY k.datum ASC");
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("artikal", (Object)artikal);
        return q.getResultList();
    }

    public List<Kartica> readKarticeCrne(Artikal artikal, Odeljenje odeljenje) {
        Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE (k.artikal = :artikal AND k.odeljenje =:odeljenje AND k.crno = true) ORDER BY k.datum ASC");
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("artikal", (Object)artikal);
        return q.getResultList();
    }

    public List<Kartica> readKartice(Artikal artikal, Date d1, Date d2, Boolean crno, Boolean belo, Odeljenje odeljenje) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT k FROM Kartica k WHERE (k.artikal = :artikal AND k.odeljenje =:odeljenje) AND k.datum BETWEEN :d1 AND :d2 ");
        if (crno.booleanValue() && !belo.booleanValue()) {
            sb.append("AND k.crno = true ORDER BY k.datum ASC");
        }
        if (!crno.booleanValue() && belo.booleanValue()) {
            sb.append("AND k.crno = false ORDER BY k.datum ASC");
        }
        if (crno.booleanValue() && belo.booleanValue()) {
            sb.append("ORDER BY k.datum ASC");
        }
        Query q = this.base.createQuery(sb.toString());
        q.setParameter("artikal", (Object)artikal);
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("d1", (Object)d1);
        q.setParameter("d2", (Object)d2);
        return q.getResultList();
    }

    public List<Kartica> readKartice(Artikal artikal, Odeljenje odeljenje, Date day1) {
        Query q = this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.artikal = :artikal AND k.odeljenje =:odeljenje)  AND k.datum <:day1) ORDER BY k.datum ASC");
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("artikal", (Object)artikal);
        q.setParameter("day1", (Object)day1);
        return q.getResultList();
    }

    public List<Kartica> readKartice(Date day1, Odeljenje odeljenje) {
        Query q = null;
        Date pocetak = this.getPocetni(day1);
        Date kraj = this.getKrajnji(day1);
        q = this.base.createQuery("SELECT k FROM Kartica k WHERE k.odeljenje = :odeljenje AND (k.datum BETWEEN :pocetak AND :kraj) ORDER BY k.datum ASC");
        q.setParameter("odeljenje", (Object)odeljenje);
        q.setParameter("pocetak", (Object)pocetak);
        q.setParameter("kraj", (Object)kraj);
        return q.getResultList();
    }

    public List<Kartica> readKarticeDPU(Date day1, Odeljenje odeljenje, boolean belo, boolean crno) {
        Query q = null;
        if (odeljenje != null) {
            q = belo && crno ? this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje) AND (k.dokument <>:null AND k.datum <:day1)) ORDER BY k.datum ASC") : (belo ? this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje AND k.crno=false) AND (k.dokument <>:null AND k.datum <:day1)) ORDER BY k.datum ASC") : this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje AND k.crno=true) AND (k.dokument <>:null AND k.datum <:day1)) ORDER BY k.datum ASC"));
            q.setParameter("odeljenje", (Object)odeljenje);
        } else {
            q = belo && crno ? this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje.naziv<>:magacin AND k.dokument<>:null)AND k.datum <:day1) ORDER BY k.datum ASC") : (belo ? this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje <> :magacin AND k.dokument<>:null)AND (k.crno = false AND k.datum <:day1)) ORDER BY k.datum ASC") : this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje <> :magacin AND k.dokument<>:null)AND (k.crno = true AND k.datum <:day1)) ORDER BY k.datum ASC"));
            q.setParameter("magacin", (Object)this.returnMagacin());
        }
        q.setParameter("day1", (Object)day1);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeDPU(Date day1, List<NacinPlacanja> np) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE ((sr.racun.placanja in :np AND sr.racun.crnoPlacanje=:null)AND (sr.tura.datum <:day1))");
        q.setParameter("day1", (Object)day1);
        q.setParameter("np", np);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeDPUCrno(Date day1, String crno) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje=:crno AND sr.tura.datum <:day1)");
        q.setParameter("day1", (Object)day1);
        q.setParameter("crno", (Object)crno);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeCrno(Date day1, Date day2) {
        Query q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun.datum between :day1 AND :day2 AND sr.racun.crnoPlacanje is not null");
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        return q.getResultList();
    }

    public List<Kartica> readKarticeZaDanDPU(Date day1, Date day2, Odeljenje odeljenje, boolean belo, boolean crno) {
        Query q = null;
        if (odeljenje != null) {
            q = belo && crno ? this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje) AND (k.dokument <>:null AND k.datum BETWEEN :day1 AND :day2)) ORDER BY k.datum ASC") : (belo ? this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje AND k.crno= false) AND (k.dokument <>:null AND k.datum BETWEEN :day1 AND :day2)) ORDER BY k.datum ASC") : this.base.createQuery("SELECT k FROM Kartica k WHERE ((k.odeljenje =:odeljenje AND k.crno= true) AND (k.dokument <>:null AND k.datum BETWEEN :day1 AND :day2)) ORDER BY k.datum ASC"));
            q.setParameter("odeljenje", (Object)odeljenje);
        } else {
            q = belo && crno ? this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje.naziv<>:magacin AND k.dokument<>:null)AND k.datum BETWEEN :day1 AND :day2) ORDER BY k.datum ASC") : (belo ? this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje <> :magacin AND k.dokument<>:null)AND (k.crno = false AND k.datum BETWEEN :day1 AND :day2)) ORDER BY k.datum ASC") : this.base.createQuery("SELECT k FROM Kartica k WHERE((k.odeljenje <> :magacin AND k.dokument<>:null)AND (k.crno = true AND k.datum BETWEEN :day1 AND :day2)) ORDER BY k.datum ASC"));
            q.setParameter("magacin", (Object)this.returnMagacin());
        }
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeZaDanDPU(Date day1, Date day2, List<NacinPlacanja> np) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje=:null AND sr.racun.placanja in (SELECT p FROM Placanje p WHERE p.nacin in :np) AND (sr.racun.datum BETWEEN :day1 AND :day2))");
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        q.setParameter("np", np);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeZaDanDPU(Date day1, Date day2) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :day1 AND :day2)");
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeZaDanDPUCrno(Date day1, Date day2, String crno) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje=:crno AND sr.tura.datum BETWEEN :day1 AND :day2)");
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        q.setParameter("crno", (Object)crno);
        return q.getResultList();
    }

    public List<StavkaRacuna> readStavkeZaDanDPUCrno(Date day1, Date day2) {
        Query q = null;
        q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje is not null AND sr.racun.datum BETWEEN :day1 AND :day2)");
        q.setParameter("day1", (Object)day1);
        q.setParameter("day2", (Object)day2);
        return q.getResultList();
    }

    public List<PrijemnicaStavka> readStavkePrijemnice(Prijemnica p) {
        Query q = this.base.createQuery("SELECT ps FROM PrijemnicaStavka ps WHERE ps.prijemnica = :p");
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    public List<PrijemnicaStavka> getStavkePrijemnice(Date d1, Date d2) {
        Query query = null;
        query = this.base.createQuery("SELECT ps FROM PrijemnicaStavka ps WHERE ps.prijemnica.datumPrijemnice BETWEEN :d1 AND :d2");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public Artikal ArtikalByName(String name) {
        Query q = this.base.createQuery("SELECT a FROM Artikal a WHERE a.name = :name");
        q.setParameter("name", (Object)name);
        return (Artikal)q.getSingleResult();
    }

    public Normativ returnNormativ(Artikal artikal, Artikal sastojak) {
        Query q = this.base.createQuery("SELECT n FROM Normativ n WHERE( n.artikal = :artikal AND n.sastojak = :sastojak)");
        q.setParameter("artikal", (Object)artikal);
        q.setParameter("sastojak", (Object)sastojak);
        return (Normativ)q.getSingleResult();
    }

    public boolean proveriNazivCenovnik(String naziv) {
        Query q = this.base.createQuery("SELECT c FROM Cenovnik c WHERE c.naziv = :naziv");
        q.setParameter("naziv", (Object)naziv);
        try {
            q.getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    public boolean proveriNazivArtikal(String naziv) {
        Query q = this.base.createQuery("SELECT c FROM Artikal c WHERE c.name = :naziv");
        q.setParameter("naziv", (Object)naziv);
        try {
            q.getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    public boolean proveriNazivBarcode(String barCode) {
        Query q = this.base.createQuery("SELECT c FROM Artikal c WHERE c.barCode = :barCode");
        q.setParameter("barCode", (Object)barCode);
        try {
            q.getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
            return false;
        }
    }

    public Artikal addArtikal2JPAMerge(Artikal a) {
        this.base.getTransaction().begin();
        a = (Artikal)this.base.merge((Object)a);
        this.base.getTransaction().commit();
        return a;
    }

    public void addKomitent(Komitent k) {
        this.base.getTransaction().begin();
        this.base.persist((Object)k);
        this.base.getTransaction().commit();
    }

    public void updateKomitent(Komitent k) {
        this.base.getTransaction().begin();
        this.base.merge((Object)k);
        this.base.getTransaction().commit();
    }

    public void addSG(StalniGost k) {
        this.base.getTransaction().begin();
        this.base.persist((Object)k);
        this.base.getTransaction().commit();
    }

    public Long addArtikal2JPA(Artikal a) {
        this.base.getTransaction().begin();
        a = (Artikal)this.base.merge((Object)a);
        this.base.getTransaction().commit();
        return a.getId();
    }

    public void addArtikal2JPAPersist(Artikal a) {
        this.base.getTransaction().begin();
        this.base.persist((Object)a);
        this.base.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addArtikal2(Artikal a) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String slika = a.getSlika() != null ? "'" + a.getSlika().replace("\\", "\\\\") + "'" : null;
        String barcode = a.getBarCode() != null ? "'" + a.getBarCode() + "'" : null;
        String selectString = "select id from artikal where artikal.id = (select max(id) from artikal)";
        String insertString1 = "INSERT INTO artikal VALUES(null," + barcode + "," + a.getBlokiran() + "," + a.getCena() + "," + a.getDozvoljenPopust() + ",'" + a.getJedinicaMere() + "'," + a.getJelo() + "," + a.getMera() + "," + a.getMinLager() + ",'" + a.getName() + "'," + a.getNijeDeoSlozenog() + "," + a.getPice() + "," + a.getPoreskaGrupa().getMetalinkCode() + "," + a.getPrioritet() + ",'" + a.getSkrNaziv() + "'," + slika + ",'" + a.getTip().name() + "'," + a.getTrenutnaNV() + "," + a.getOdeljenjeNormativ().getId() + "," + a.getPodgrupa().getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            rs.close();
            stmt.close();
            conn.close();
            this.proveriKonekciju(stmt, conn, rs);
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
                this.proveriKonekciju(stmt, conn, rs);
            }
            catch (Throwable throwable) {
                this.proveriKonekciju(stmt, conn, rs);
                throw throwable;
            }
        }
        return id;
    }

    public void updateArtikal2(Artikal a) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String slika = a.getSlika() != null ? "'" + a.getSlika().replace("\\", "\\\\") + "'" : null;
        String barcode = a.getBarCode() != null ? "'" + a.getBarCode() + "'" : null;
        String insertString1 = "INSERT INTO artikal VALUES(null," + barcode + "," + a.getBlokiran() + "," + a.getCena() + "," + a.getDozvoljenPopust() + ",'" + a.getJedinicaMere() + "'," + a.getJelo() + "," + a.getMera() + "," + a.getMinLager() + ",'" + a.getName() + "'," + a.getNijeDeoSlozenog() + "," + a.getPice() + "," + a.getPoreskaGrupa().getMetalinkCode() + "," + a.getPrioritet() + ",'" + a.getSkrNaziv() + "'," + slika + ",'" + a.getTip().name() + "'," + a.getTrenutnaNV() + "," + a.getOdeljenjeNormativ().getId() + "," + a.getPodgrupa().getId() + ") WHERE artikal.id = " + a.getId() + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeQuery(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void addArtikalOdeljenje2(Long aID, Long oID) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "INSERT INTO artikal_odeljenje VALUES(" + aID + "," + oID + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void deleteArtikalOdeljenje2(Long aID) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM artikal_odeljenje WHERE ARTIKLI_ID = " + aID + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void setBrojUtrosakDoc(int broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + (broj - 1) + " WHERE setting.name = 'utrosakdoc.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void incrementBrojUtrosakDoc(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'utrosakdoc.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojUtrosakDoc() {
        String s = null;
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"utrosakdoc.broj.sledeci");
        try {
            s = (String)query.getSingleResult();
        }
        catch (Exception ex) {
            Setting se = new Setting();
            se.setActual("1");
            se.setName("utrosakdoc.broj.sledeci");
            this.changeSetting(se);
            s = se.getActual();
        }
        return new Integer(s);
    }

    public Integer sledeciBrojUtrosakDoc2() {
        String s = null;
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"utrosakdoc2.broj.sledeci");
        try {
            s = (String)query.getSingleResult();
        }
        catch (Exception ex) {
            Setting se = new Setting();
            se.setActual("1");
            se.setName("utrosakdoc2.broj.sledeci");
            this.changeSetting(se);
            s = se.getActual();
        }
        return new Integer(s);
    }

    public void incrementBrojUtrosakDoc2(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'utrosakdoc2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void setBrojOtpisa(int broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + (broj - 1) + " WHERE setting.name = 'otpis.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void incrementBrojOtpisa(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'otpis.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojOtpisa() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"otpis.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public Integer sledeciBrojOtpisa2() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"otpis2.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public void incrementBrojOtpisa2(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'otpis2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojPrijem() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"prijemnica.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public void incrementBrojPrijem(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'prijemnica.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojPrijem2() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"prijemnica2.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public void incrementBrojPrijem2(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'prijemnica2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojFakture() {
        log.finer("Sledeci broj fakture");
        Connection conn = this.getConnection();
        Statement stmt = null;
        Integer broj = -1;
        String insertString1 = "select actual from setting WHERE setting.name = 'faktura.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(insertString1);
            while (rs.next()) {
                broj = Integer.valueOf(rs.getString("actual"));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "Sledeci broj fakture pronadjen");
        return broj;
    }

    public void incrementBrojFakture(String broj) {
        log.fine("povecanje broja fakture " + broj);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'faktura.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void incrementBrojProfakture(String broj) {
        log.fine("povecanje broja profakture");
        SettingController.saveSetting(Option.PROFAKTURA_SLEDECI_BROJ, (Object)broj);
    }

    public Integer sledeciBrojPopisa() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        Integer broj = -1;
        String insertString1 = "select actual from setting WHERE setting.name = 'popis.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(insertString1);
            while (rs.next()) {
                broj = Integer.valueOf(rs.getString("actual"));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return broj;
    }

    public void incrementBrojPopisa(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'popis.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojPopisa2() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        Integer broj = -1;
        String insertString1 = "select actual from setting WHERE setting.name = 'popis2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(insertString1);
            while (rs.next()) {
                broj = Integer.valueOf(rs.getString("actual"));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        return broj;
    }

    public void incrementBrojPopisa2(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'popis2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojTreb() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"trebovanje.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public void incrementBrojTreb(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'trebovanje.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojTreb2() {
        Query query = this.base.createQuery("SELECT o.actual FROM Setting o WHERE o.name = :name");
        query.setParameter("name", (Object)"trebovanje2.broj.sledeci");
        String s = (String)query.getSingleResult();
        return new Integer(s);
    }

    public void incrementBrojTreb2(String broj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'trebovanje2.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Trebovanje updateTrebovanje(Trebovanje t) throws Exception {
        try {
            this.base.getTransaction().begin();
            t = (Trebovanje)this.base.merge((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom a\u017euriranja trebovanja", e);
        }
        finally {
            return t;
        }
    }

    public void updateStavka(TrebovanjeStavka t) {
        if (t.getId() != null) {
            this.base.getTransaction().begin();
            this.base.merge((Object)t);
            this.base.getTransaction().commit();
        } else {
            this.base.getTransaction().begin();
            this.base.persist((Object)t);
            this.base.getTransaction().commit();
        }
    }

    public void updateTrebovanjeDobavljac(Trebovanje t, StalniGost d) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update trebovanje SET DOBAVLJAC_ID=" + d.getId() + " WHERE trebovanje.id =" + t.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Prijemnica updatePrijemnica(Prijemnica p) throws Exception {
        try {
            this.base.getTransaction().begin();
            p = (Prijemnica)this.base.merge((Object)p);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom a\u017euriranja prijemnice.", e);
        }
        finally {
            return p;
        }
    }

    public void updatePrijemnicaDobavljac(Prijemnica t, StalniGost d) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update prijemnica SET DOBAVLJAC_ID=" + d.getId() + " WHERE prijemnicae.id =" + t.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public Integer sledeciBrojTure() {
        log.finer("Sledeci broj ture");
        Connection conn = this.getConnection();
        Statement stmt = null;
        Integer broj = -1;
        String insertString1 = "select actual from setting WHERE setting.name = 'tura.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(insertString1);
            while (rs.next()) {
                broj = Integer.valueOf(rs.getString("actual"));
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "Sledeci broj ture pronadjen");
        return broj;
    }

    public void incrementBrojTure(String broj) {
        log.fine("povecanje broja ture");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update setting SET actual=" + broj + " WHERE setting.name = 'tura.broj.sledeci'";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void addHH(Popust t) {
        log.info("Unos novog happy houra");
        this.base.getTransaction().begin();
        this.base.persist((Object)t);
        this.base.getTransaction().commit();
        log.info("Unet novi happy hour");
    }

    public void updateHH(Popust h) {
        log.info("Izmena happy houra: " + h);
        this.base.getTransaction().begin();
        this.base.merge((Object)h);
        this.base.getTransaction().commit();
    }

    public List<Popust> getHH() {
        Query query = this.base.createQuery("SELECT ga FROM Popust ga");
        return query.getResultList();
    }

    public void deleteHH(Popust h) {
        log.info("Brisanje happy houra: " + h);
        this.base.getTransaction().begin();
        Popust hh = (Popust)this.base.find(Popust.class, (Object)h.getId());
        this.base.remove((Object)hh);
        this.base.getTransaction().commit();
    }

    public void deletePrijemnica(Prijemnica p) {
        log.info("Brisanje prijemnice: " + p);
        this.base.getTransaction().begin();
        Prijemnica pp = (Prijemnica)this.base.find(Prijemnica.class, (Object)p.getId());
        this.base.remove((Object)pp);
        this.base.getTransaction().commit();
    }

    public void addTrebovanjeStavka(TrebovanjeStavka ts) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into trebovanjestavka values(null," + ts.getKolicina() + "," + ts.getKomad() + "," + ts.getPdvStopa() + "," + ts.getArtikal().getId() + "," + ts.getTrebovanje().getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void addUtrosakDocStavka(UtrosakDocStavke uds) {
        this.base.getTransaction().begin();
        this.base.persist((Object)uds);
        this.base.getTransaction().commit();
    }

    public void addOtpisStavka(OtpisStavka os) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into otpisstavka values(null," + os.getKolicina() + "," + os.getVrednost() + "," + os.getArtikal().getId() + "," + os.getOtpis().getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void addOtpisStavkaJPA(OtpisStavka os) {
        this.base.getTransaction().begin();
        this.base.persist((Object)os);
        this.base.getTransaction().commit();
    }

    public List<Trebovanje> readTrebovanja() {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t ORDER BY t.datumTrebovanja");
        return q.getResultList();
    }

    public List<Trebovanje> readTrebovanja(Odeljenje o2) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE t.u=:o2 ORDER BY t.datumTrebovanja");
        q.setParameter("o2", (Object)o2);
        return q.getResultList();
    }

    public List<Trebovanje> readTrebovanja(Odeljenje o2, Date datum) {
        log.info("Citanje trebovanja za odeljenje i datum " + datum);
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE (t.u=:o2 OR (t.u IS NULL AND t.iz = :o2)) AND t.datumTrebovanja = :d ORDER BY t.datumTrebovanja");
        q.setParameter("o2", (Object)o2);
        q.setParameter("d", (Object)datum);
        return q.getResultList();
    }

    public List<Trebovanje> readUlaznaTrebovanja(Odeljenje odeljenje, Date datum, boolean crno) {
        LinkedList<Trebovanje> lista = new LinkedList<Trebovanje>();
        String query = "SELECT t.* FROM trebovanje t WHERE t.U_ID = ? AND t.datumTrebovanja = ? AND t.crno = ? ORDER BY t.datumTrebovanja";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            pStatement.setLong(1, odeljenje.getId());
            pStatement.setString(2, new SimpleDateFormat("yyyy-MM-dd").format(datum));
            pStatement.setBoolean(3, crno);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Trebovanje trebovanje = this.getTrebovanjeByID(rSet.getLong("id"));
                lista.add(trebovanje);
            }
        }
        catch (SQLException e) {
            return null;
        }
        return lista;
    }

    public List<Prijemnica> readPrijemnice(Date datum, boolean crno) {
        LinkedList<Prijemnica> lista = new LinkedList<Prijemnica>();
        String query = "SELECT p.* FROM prijemnica p WHERE  p.datumPrijemnice = ? AND p.crno = ? ORDER BY p.datumPrijemnice";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            pStatement.setString(1, new SimpleDateFormat("yyyy-MM-dd").format(datum));
            pStatement.setBoolean(2, crno);
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Prijemnica prijemnica = new Prijemnica();
                prijemnica.setId(rSet.getLong("id"));
                prijemnica.setBrPrijemnice(rSet.getString("brPrijemnice"));
                prijemnica.setDatumPrijemnice(rSet.getDate("datumPrijemnice"));
                prijemnica.setCrno(rSet.getBoolean("crno"));
                lista.add(prijemnica);
            }
        }
        catch (SQLException e) {
            return null;
        }
        return lista;
    }

    public List<Trebovanje> readIzlaznaTrebovanja(Odeljenje odeljenje, Date datum, boolean crno) {
        LinkedList<Trebovanje> lista = new LinkedList<Trebovanje>();
        String query = "SELECT t.* FROM trebovanje t WHERE t.IZ_ID = ? AND t.datumTrebovanja = ? AND t.crno = ? ORDER BY t.datumTrebovanja";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            pStatement.setLong(1, odeljenje.getId());
            pStatement.setString(2, new SimpleDateFormat("yyyy-MM-dd").format(datum));
            pStatement.setBoolean(3, crno);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                Trebovanje trebovanje = this.getTrebovanjeByID(rSet.getLong("id"));
                lista.add(trebovanje);
            }
        }
        catch (SQLException e) {
            return null;
        }
        return lista;
    }

    public List<Trebovanje> readTrebovanjaDirDobavljac(Odeljenje o2, StalniGost d) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE (t.u=:o2  and t.dobavljac = :d) ORDER BY t.datumTrebovanja");
        q.setParameter("o2", (Object)o2);
        q.setParameter("d", (Object)d);
        return q.getResultList();
    }

    public List<Trebovanje> readMedjuTrebovanja(Odeljenje o1, Odeljenje o2) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE(t.iz<>:o1  AND t.u=:o2) AND t.brTrebovanja not like '%POV' ORDER BY t.datumTrebovanja");
        q.setParameter("o1", (Object)o1);
        q.setParameter("o2", (Object)o2);
        return q.getResultList();
    }

    public List<Trebovanje> readPovratnice(Odeljenje o2) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE(t.iz=:o2  AND t.u<>:o2) AND t.brTrebovanja like '%POV' ORDER BY t.datumTrebovanja");
        q.setParameter("o2", (Object)o2);
        return q.getResultList();
    }

    public List<TrebovanjeStavka> readStavkeTrebovanja(Trebovanje t) {
        Query q = this.base.createQuery("SELECT t FROM TrebovanjeStavka t WHERE t.trebovanje = :t");
        q.setParameter("t", (Object)t);
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getStavkeTrebovanja(Long trebovanjeID) {
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select ARTIKAL_ID,kolicina from trebovanjestavka where  TREBOVANJE_ID = " + trebovanjeID + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getStavkePrijemnice(Long trebovanjeID) {
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select ARTIKAL_ID,kolicina from prijemnicastavka where  prijemnica_ID = " + trebovanjeID + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnevnoStanje getDSBelo(Long artikalID, Date datum) {
        DnevnoStanje ds = new DnevnoStanje();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,beloUlaz from dnevnostanje where  (artikalID = " + artikalID + " and datum = '" + Konstante.getSQLDateFormat(datum) + "');";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            if (rs.next()) {
                ds.setId(rs.getLong(1));
                ds.setBeloUlaz(rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDSBelo(Long id, Double kol) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update dnevnostanje SET beloUlaz=" + kol + " WHERE dnevnostanje.id=" + id + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public List<ProizvodnjaUtrosak> readProizvodnjaUtrosak(Proizvodnja p) {
        Query q = this.base.createQuery("SELECT pu FROM ProizvodnjaUtrosak pu WHERE pu.proizvodnja = :p");
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    public List<ProizvodnjaStavka> readStavkePregledaProizvodnje(Proizvodnja p) {
        Query q = this.base.createQuery("SELECT ps FROM ProizvodnjaStavka ps WHERE ps.proizvodnja = :p");
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    public Double countUtrosakDocStavke(UtrosakDoc o) {
        Query q = this.base.createQuery("SELECT sum(os.vrednost) FROM UtrosakDocStavke os WHERE os.utrosakDoc = :o");
        q.setParameter("o", (Object)o);
        Double rez = (Double)q.getSingleResult();
        return rez;
    }

    public Double countStavkeOtpisa(Otpis o) {
        Query q = this.base.createQuery("SELECT sum(os.vrednost) FROM OtpisStavka os WHERE os.otpis = :o");
        q.setParameter("o", (Object)o);
        Double rez = (Double)q.getSingleResult();
        return rez;
    }

    public List<UtrosakDocStavke> readUtrosakDocStavke(UtrosakDoc o) {
        Query q = this.base.createQuery("SELECT os FROM UtrosakDocStavke os WHERE os.utrosakDoc = :o");
        q.setParameter("o", (Object)o);
        return q.getResultList();
    }

    public List<OtpisStavka> readStavkeOtpisa(Otpis o) {
        Query q = this.base.createQuery("SELECT os FROM OtpisStavka os WHERE os.otpis = :o");
        q.setParameter("o", (Object)o);
        return q.getResultList();
    }

    public List<ProizvodnjaStavka> readStavkeProizvodnje(Proizvodnja p) {
        Query q = this.base.createQuery("SELECT t FROM ProizvodnjaStavka t WHERE t.proizvodnja = :p");
        q.setParameter("p", (Object)p);
        return q.getResultList();
    }

    public List<OtpisStavka> getStavkeOtpisa(Date d1, Date d2) {
        Query query = null;
        query = this.base.createQuery("SELECT os FROM OtpisStavka os WHERE os.otpis.datum BETWEEN :d1 AND :d2");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnevnoStanje getDSCrno(Long artikalID, Date datum) {
        DnevnoStanje ds = new DnevnoStanje();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,crnoUlaz from dnevnostanje where  (artikalID = " + artikalID + " and datum = '" + Konstante.getSQLDateFormat(datum) + "');";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            if (rs.next()) {
                ds.setId(rs.getLong(1));
                ds.setCrnoUlaz(rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDSCrno(Long id, Double kol) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update dnevnostanje SET crnoUlaz=" + kol + " WHERE dnevnostanje.id=" + id + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public List<KonobarTarget> readTargete() {
        Query query = this.base.createQuery("SELECT kt FROM KonobarTarget kt");
        return query.getResultList();
    }

    public List<KonobarTarget> readTargete(Konobar k) {
        Query query = this.base.createQuery("SELECT kt FROM KonobarTarget kt where kt.konobar = :k");
        query.setParameter("k", (Object)k);
        return query.getResultList();
    }

    public KonobarTarget addTarget(KonobarTarget kt) {
        this.base.getTransaction().begin();
        this.base.persist((Object)kt);
        this.base.getTransaction().commit();
        return kt;
    }

    public void deleteTarget(KonobarTarget kt) {
        this.base.getTransaction().begin();
        this.base.remove((Object)kt);
        this.base.getTransaction().commit();
    }

    public Konobar addKonobar(Konobar konobar) {
        LinkedList<Kasa> list = new LinkedList<Kasa>();
        if (konobar.getKase() != null) {
            for (Kasa kasa : konobar.getKase()) {
                if (kasa == null || kasa.getId() == null) continue;
                if (!this.base.contains((Object)kasa)) {
                    kasa = (Kasa)this.base.find(Kasa.class, (Object)kasa.getId());
                }
                if (kasa == null) continue;
                list.add(kasa);
            }
        }
        konobar.setKase(list);
        this.base.getTransaction().begin();
        this.base.persist((Object)konobar);
        this.base.getTransaction().commit();
        return konobar;
    }

    public Rezervacija addRezervacija(Rezervacija rezervacija) {
        try {
            if (this.base.contains((Object)rezervacija)) {
                this.base.detach((Object)rezervacija);
            }
            this.base.getTransaction().begin();
            this.base.persist((Object)rezervacija);
            this.base.getTransaction().commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rezervacija;
    }

    public void updateRezervacija(Rezervacija rezervacija) {
        this.base.getTransaction().begin();
        this.base.merge((Object)rezervacija);
        this.base.getTransaction().commit();
    }

    public void deleteRezervacija(Rezervacija rezervacija) {
        this.base.getTransaction().begin();
        Rezervacija r = (Rezervacija)this.base.find(Rezervacija.class, (Object)rezervacija.getId());
        this.base.remove((Object)r);
        this.base.getTransaction().commit();
    }

    public void addGrupaZaposlenih(GrupaZaposlenih gz) {
        this.base.getTransaction().begin();
        this.base.persist((Object)gz);
        this.base.getTransaction().commit();
    }

    public void deleteUtrosakDocStavke(UtrosakDocStavke activeStavka) {
        this.base.getTransaction().begin();
        this.base.remove((Object)activeStavka);
        this.base.getTransaction().commit();
    }

    public void deleteUtrosakDocUtrosak(UtrosakDocUtrosak activeStavka) {
        this.base.getTransaction().begin();
        this.base.remove((Object)activeStavka);
        this.base.getTransaction().commit();
    }

    public void deleteOtpisStavka(OtpisStavka activeStavka) {
        this.base.getTransaction().begin();
        this.base.remove((Object)activeStavka);
        this.base.getTransaction().commit();
    }

    public void deleteProizvodnjaStavka(ProizvodnjaStavka activeStavka) {
        this.base.getTransaction().begin();
        this.base.remove((Object)activeStavka);
        this.base.getTransaction().commit();
    }

    public void deleteProizvodnjaUtrosak(ProizvodnjaUtrosak proizvodnjaUtrosak) {
        this.base.getTransaction().begin();
        this.base.remove((Object)proizvodnjaUtrosak);
        this.base.getTransaction().commit();
    }

    public List<Konobar> readKonobarFromKonobarTarget() {
        Query query = this.base.createQuery("SELECT DISTINCT kt.konobar FROM KonobarTarget kt where kt.konobar.blokiranje = false");
        return query.getResultList();
    }

    public List<Konobar> readKonobarFromArtikalTarget() {
        Query query = this.base.createQuery("SELECT DISTINCT at.konobar FROM ArtikalTarget at where at.konobar.blokiranje = false");
        return query.getResultList();
    }

    public List<Konobar> readSveKonobar() {
        Query query = this.base.createQuery("SELECT k FROM Konobar k");
        return query.getResultList();
    }

    public List<Konobar> readKonobarRacun(Date d1, Date d2) {
        d1 = this.getPocetni(d1);
        d2 = this.getKrajnji(d2);
        Query query = this.base.createQuery("SELECT DISTINCT r.konobar FROM Racun r where r.datum between :d1 and :d2 ");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Konobar> readAllKonobar() {
        Query query = this.base.createQuery("SELECT k FROM Konobar k ");
        return query.getResultList();
    }

    public List<Konobar> readKonobar() {
        Query query = this.base.createQuery("SELECT k FROM Konobar k where k.blokiranje = false");
        return query.getResultList();
    }

    public List<StalniGost> readBlokiraneStalneGoste() {
        Query query = this.base.createQuery("SELECT sg FROM StalniGost sg where sg.blokiran = true ORDER BY sg.naziv ");
        return query.getResultList();
    }

    public List<Konobar> readBlokiraneKonobare() {
        Query query = this.base.createQuery("SELECT k FROM Konobar k where k.blokiranje = true");
        return query.getResultList();
    }

    public Konobar updateKonobar(Konobar konobar) {
        LinkedList<Kasa> list = new LinkedList<Kasa>();
        LinkedList<GrafikSale> gsList = new LinkedList<GrafikSale>();
        if (konobar.getKase() != null) {
            for (Kasa kasa : konobar.getKase()) {
                if (kasa == null || kasa.getId() == null) continue;
                if (!this.base.contains((Object)kasa)) {
                    kasa = (Kasa)this.base.find(Kasa.class, (Object)kasa.getId());
                }
                if (kasa == null) continue;
                list.add(kasa);
            }
        }
        if (konobar.getGrafici() != null) {
            for (GrafikSale gs : konobar.getGrafici()) {
                if (gs == null || gs.getId() == null) continue;
                if (!this.base.contains((Object)gs)) {
                    gs = (GrafikSale)this.base.find(GrafikSale.class, (Object)gs.getId());
                }
                if (gs == null) continue;
                gsList.add(gs);
            }
        }
        konobar.setKase(list);
        this.base.getTransaction().begin();
        konobar = (Konobar)this.base.merge((Object)konobar);
        this.base.getTransaction().commit();
        return konobar;
    }

    public void deleteKonobar(Konobar konobar) {
        this.base.getTransaction().begin();
        Konobar k = (Konobar)this.base.find(Konobar.class, (Object)konobar.getId());
        this.base.remove((Object)k);
        this.base.getTransaction().commit();
    }

    public void addCrnoPlacanje(CrnoPlacanje cp) {
        this.base.getTransaction().begin();
        this.base.persist((Object)cp);
        this.base.getTransaction().commit();
    }

    public List<CrnoPlacanje> readCrnaPlacanjaIzvestaji() {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp WHERE cp.prikazIzvestaji = true");
        return query.getResultList();
    }

    public List<CrnoPlacanje> readCrnaPlacanjaEkran() {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp WHERE cp.prikazEkran = true");
        return query.getResultList();
    }

    public List<String> readCrnaPlacanjaNazivi() {
        Query query = this.base.createQuery("SELECT cp.naziv FROM CrnoPlacanje cp");
        return query.getResultList();
    }

    public List<CrnoPlacanje> readCrnaPlacanja() {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp");
        return query.getResultList();
    }

    public List<CrnoPlacanje> readSvaCrnaPlacanja() {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp");
        return query.getResultList();
    }

    public List<CrnoPlacanje> readSvaCrnaPlacanjaBezMZ() {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp where cp.naziv<>:m");
        query.setParameter("m", (Object)"Medjuzbir");
        return query.getResultList();
    }

    public String getCrnoPlacanje(String sifra) {
        Query query = this.base.createQuery("SELECT cp.naziv FROM CrnoPlacanje cp WHERE cp.sifra =:sifra");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (String)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public CrnoPlacanje getCrnoNaziv(String sifra) {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp WHERE cp.naziv =:sifra");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (CrnoPlacanje)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public CrnoPlacanje getCrnoPlacanjeObject(String naziv) {
        Query query = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp WHERE cp.naziv =:sifra");
        query.setParameter("sifra", (Object)naziv.trim());
        try {
            return (CrnoPlacanje)query.getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void updateCrnoPlacanje(CrnoPlacanje cp) {
        this.base.getTransaction().begin();
        this.base.merge((Object)cp);
        this.base.getTransaction().commit();
    }

    public void deleteCrnoPlacanje(CrnoPlacanje cp) {
        this.base.getTransaction().begin();
        CrnoPlacanje k = (CrnoPlacanje)this.base.find(CrnoPlacanje.class, (Object)cp.getId());
        this.base.remove((Object)k);
        this.base.getTransaction().commit();
    }

    public Racun addRacunJPA(Racun r) {
        log.info("Unos racuna JPA" + r);
        this.base.getTransaction().begin();
        this.base.persist((Object)r);
        this.base.getTransaction().commit();
        return r;
    }

    public Racun addRacun(Racun r) {
        log.info(new Date() + "-Pamcenje racuna");
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        Long id = null;
        String crnoPlacanje = r.getCrnoPlacanje() != null ? "'" + r.getCrnoPlacanje() + "'" : null;
        String insertString1 = "insert into racun values(null," + r.getBrojFakture() + "," + r.getBrojStola() + "," + crnoPlacanje + ",'" + Konstante.getSQLFormat(r.getDatum()) + "'," + r.getFiskalniOdstampan() + "," + r.getPopust() + "," + false + "," + r.getZatvoren() + "," + r.getKonobar().getId() + "," + (r.getStalniGost() != null ? r.getStalniGost().getId() : "null") + ")";
        String selectString = "select id from racun where racun.id = (select max(id) from racun)";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(insertString1);
            ResultSet rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong("id");
            }
            r.setId(id);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage() + "\n" + ex.getSQLState());
        }
        log.info(new Date() + "-Racun zapamcen");
        return r;
    }

    public void updateRacun(Racun r) {
        this.base.getTransaction().begin();
        this.base.merge((Object)r);
        this.base.getTransaction().commit();
    }

    public void updateBINapomena(String BI, String napomena, Long racunId) {
        String query = "Update racun set brojBI = ?, napomena = ? where id = ? ";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setString(1, BI);
            ps.setString(2, napomena);
            ps.setLong(3, racunId);
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addPlacanjeJPA(Placanje p) {
        log.info("Dodavanje placanja");
        this.base.getTransaction().begin();
        this.base.persist((Object)p);
        this.base.getTransaction().commit();
    }

    public void addPlacanje(Placanje p) {
        log.info(new Date() + "-Pamcenje placanja");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into placanje values(null," + p.getIznos() + ",'" + p.getNacin().name() + "','" + Konstante.getSQLFormat(p.getVreme()) + "'," + p.getRacun().getId() + ")";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            this.warning("Do\u0161lo je do gre\u0161ke prilikom dodavanja pla\u0107anja za ra\u010dun sa ID = " + p.getRacun().getId());
            return;
        }
        log.log(Level.INFO, "{0}-Racun zapamcen", new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long addStorno(Storno s) {
        Long id = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into storno values(null," + s.getBrojStola() + ",'" + Konstante.getSQLFormat(s.getDatum()) + "','" + s.getUser() + "'," + s.getKonobar().getId() + ")";
        String selectString = "select id from storno where id = (select max(id) from storno)";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                id = this.r.getLong("id");
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStornoStavka(StornoStavka s, Long sid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "insert into stornostavka values(null," + s.getBrojTure() + "," + s.getKolicina() + "," + s.getVrednost() + "," + sid + "," + s.getArtikal().getId() + ")";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    public Sto addStoQuery(Sto s) {
        log.info(new Date() + "-Dodavanje stola");
        String insertString1 = "insert into sto values(null,0,?,?)";
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(insertString1);
            stmt.setInt(1, s.getBroj());
            stmt.setLong(2, s.getKonobar().getId());
            stmt.execute();
            stmt.close();
            this.conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "-Sto dodat");
        return s;
    }

    public Sto updateSto(Sto l) {
        this.base.getTransaction().begin();
        Sto s = (Sto)this.base.find(Sto.class, (Object)l.getId());
        this.base.merge((Object)s);
        try {
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            return null;
        }
        return l;
    }

    public void updateStoSetBlokiran(Integer bs) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update sto SET blokiran=" + Boolean.TRUE + " WHERE sto.broj=" + bs;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    public void updateStoSetOdblokiran(Integer bs) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update sto SET blokiran=" + Boolean.FALSE + " WHERE sto.broj=" + bs;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOdblokirajSto(Integer bs) {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String query = "UPDATE sto s SET s.blokiran = FALSE WHERE s.broj = ?";
        try {
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, bs);
            stmt.execute();
            conn.close();
            this.log("Odblokiran medjuzbir, sto broj:" + bs);
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStoKonobar(Integer bs, Long kid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update sto SET KONOBAR_ID=" + kid + " WHERE sto.broj=" + bs;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public void deleteSto(Integer l) {
        log.info(new Date() + "Brisanje stola broj " + l);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM sto WHERE broj=" + l;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "Sto obrisan ");
    }

    public void deleteSR(Long l) {
        log.info(new Date() + "Brisanje stavke broj " + l);
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM stavkaracuna WHERE id=" + l;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            log.severe("SQLException: " + ex.getMessage());
        }
        log.info(new Date() + "stavka obrisana ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sto getSto2(int brojStola) {
        Sto sto = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id,blokiran,KONOBAR_ID from sto where sto.broj=" + brojStola + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                sto = new Sto();
                sto.setBroj(brojStola);
                sto.setId(rs.getLong(1));
                sto.setBlokiran(rs.getBoolean(2));
                Konobar k = new Konobar();
                k.setId(rs.getLong(3));
                sto.setKonobar(k);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return sto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existSto2(int brojStola) {
        boolean b = false;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select id from sto where sto.broj=" + brojStola + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                b = true;
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return b;
    }

    public Kasa getKasaByName(String name) {
        Query query = this.base.createQuery("SELECT k FROM Kasa k where k.oznaka = :name");
        query.setParameter("name", (Object)name);
        return (Kasa)query.getSingleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Kasa getKasa(Long kasaID) {
        Kasa k = new Kasa();
        k.setId(kasaID);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select hostName,opis,oznaka from kasa where kasa.id=" + kasaID + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                k.setHostname(rs.getString("hostName"));
                k.setOpis(rs.getString("opis"));
                k.setOznaka(rs.getString("oznaka"));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Konobar getKonobar(Long konobarID) {
        Konobar k = new Konobar();
        k.setId(konobarID);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select punoIme,sifra,skrIme from konobar where konobar.id=" + konobarID + ";";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                k.setPunoIme(rs.getString(1));
                k.setSifra(rs.getString(2));
                k.setSkrIme(rs.getString(3));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return k;
    }

    public StavkaRacuna getStavkaArtikalJPA(int brojStola, Long artID) throws Exception {
        Artikal art;
        TypedQuery q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.brojStola = :brojStola AND sr.artikal = :artikal AND sr.racun IS NULL", StavkaRacuna.class);
        try {
            art = (Artikal)this.base.find(Artikal.class, (Object)artID);
        }
        catch (Exception e) {
            return null;
        }
        if (art == null) {
            return null;
        }
        q = q.setParameter("artikal", (Object)art);
        q = q.setParameter("brojStola", (Object)brojStola);
        q.setMaxResults(1);
        try {
            return (StavkaRacuna)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja stavke ra\u010duna", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StavkaRacuna getStavkaArtikal(int brojStola, Long aid) {
        StavkaRacuna sr = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id,kolicina,TURA_ID from stavkaracuna where (brojStola=" + brojStola + " and (ARTIKAL_ID = " + aid + " and RACUN_ID IS NULL));";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                sr = new StavkaRacuna();
                sr.setId(this.r.getLong(1));
                sr.setKolicina(this.r.getDouble(2));
                Tura t = new Tura();
                t.setId(this.r.getLong(3));
                t.setPocetak(new Timestamp(0L));
                t.setKraj(new Timestamp(0L));
                sr.setTura(t);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBrojTureStavka(Long sid) {
        int bt = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select brojTure from tura where id =( select TURA_ID from stavkaracuna where stavkaracuna.id = " + sid + ");";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                bt = this.r.getInt(1);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return bt;
    }

    public Sto getSto(int brojStola) {
        TypedQuery query = this.base.createQuery("SELECT o FROM Sto o WHERE o.broj = :broj", Sto.class);
        query.setParameter("broj", (Object)brojStola);
        try {
            List listaStolova = query.getResultList();
            if (listaStolova.isEmpty()) {
                return null;
            }
            Sto sto = (Sto)listaStolova.get(0);
            this.base.refresh((Object)sto);
            return sto;
        }
        catch (NoResultException e) {
            Logger.getLogger(RestoranServer.class.getName()).log(Level.WARNING, "Greska prilikom vracanja stola sa brojem " + brojStola, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getStoIdByBrojStola(Integer brojStola) {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        ResultSet rs = null;
        Integer konobarId = null;
        String selectString = "select id from sto s where broj = " + brojStola;
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                konobarId = rs.getInt(1);
            }
            rs.close();
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
        }
        return konobarId;
    }

    public List<Sto> getSto(Konobar k) {
        Query query = this.base.createQuery("SELECT o FROM Sto o WHERE o.konobar = :k ORDER BY o.broj");
        query.setParameter("k", (Object)k);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Sto> getSto2(Konobar k) {
        ArrayList<Sto> st = new ArrayList<Sto>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String selectString = "select id,blokiran,broj from sto where KONOBAR_ID=" + k.getId() + " order by broj;";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(selectString);
            while (this.r.next()) {
                Sto s = new Sto();
                s.setId(this.r.getLong(1));
                s.setBlokiran(this.r.getBoolean(2));
                s.setBroj(this.r.getInt(3));
                s.setKonobar(k);
                st.add(s);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return st;
    }

    public List<Sto> getStolove() {
        Query query = this.base.createQuery("SELECT o FROM Sto o");
        return query.getResultList();
    }

    public List<StoBMaster> getBMasterZauzetiStolovi() {
        ArrayList<StoBMaster> zauzetiStolovi = new ArrayList<StoBMaster>();
        String query = "SELECT k.punoIme , k.skrIme, r.brojStola FROM racun r \r\nJOIN konobar k ON r.KONOBAR_ID = k.id\r\nWHERE r.zatvoren = 0 AND \r\n(SELECT COUNT(sr.id) FROM stavkaracuna sr \r\nWHERE sr.RACUN_ID = r.id) > 0";
        try {
            Statement st = this.getConnection().createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                StoBMaster sto = new StoBMaster();
                sto.setBrojStola(rs.getInt("brojStola"));
                sto.setImeKonobara(rs.getString("punoIme"));
                sto.setSkrImeKonobara(rs.getString("skrIme"));
                zauzetiStolovi.add(sto);
            }
            return zauzetiStolovi;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return zauzetiStolovi;
        }
    }

    public Konobar konobarZaSto(int brojStola) {
        Sto s = this.getSto(brojStola);
        if (s != null) {
            return s.getKonobar();
        }
        return null;
    }

    public Konobar konobarBySifra(String sifra) {
        Query query = this.base.createQuery("SELECT o FROM Konobar o WHERE o.sifra = :sifra and o.blokiranje<>true");
        query.setParameter("sifra", (Object)sifra);
        try {
            return (Konobar)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Konobar konobarByMeniPromet() {
        Query query = this.base.createQuery("SELECT o FROM Konobar o WHERE o.prometNaMeniPromet = true");
        try {
            return (Konobar)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public StavkaRacuna addStavkaRacuna(StavkaRacuna l) {
        log.info(new Date() + " - Dodavanje stavke racuna " + l.toString());
        Long id = null;
        String racunId = l.getRacun() != null ? l.getRacun().getId().toString() : null;
        String turaId = l.getTura() != null ? l.getTura().getId().toString() : null;
        Connection conn = this.getConnection();
        Object stmt = null;
        Statement tempStmt = null;
        String insertString1 = "insert into stavkaracuna values(null," + l.getBrojStola() + "," + l.getCenaBezPopusta() + "," + l.getKolicina() + ",'" + l.getArtikal().getName() + "'," + l.getArtikal().getId() + "," + racunId + "," + turaId + ")";
        String selectString = "select id from stavkaracuna where stavkaracuna.id = (select max(id) from stavkaracuna)";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(insertString1);
            ResultSet rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                id = Long.valueOf(rs.getString("id"));
            }
            l.setId(id);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe(ex.getMessage());
        }
        log.log(Level.INFO, "{0}-Stavka racuna dodata", new Date());
        return l;
    }

    public StavkaRacuna addStavkaRacunaJPA(StavkaRacuna l) {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.persist((Object)l);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.WARNING, "{0} Stavka racuna nije dodata {1}", new Object[]{new Date(), e.getMessage()});
            return null;
        }
        return l;
    }

    public StavkaRacuna updateStavkaRacunaJPA(StavkaRacuna stavka) {
        EntityTransaction trans = this.getBase().getTransaction();
        try {
            log.info("Izmena stavke racuna: " + stavka.toString());
            trans.begin();
            stavka = (StavkaRacuna)this.base.merge((Object)stavka);
            trans.commit();
            log.info("Stavka racuna izmenjena");
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.WARNING, "Stavka racuna nije izmenjena. Doslo je do greske ", e);
        }
        return stavka;
    }

    public NormativArtikal updateNormativArtikalJPA(NormativArtikal normativArtikal, Date date) {
        EntityTransaction trans = this.getBase().getTransaction();
        EntityManager eManager = this.getBase();
        try {
            log.info("Izmena datuma normativartikla: " + normativArtikal.toString());
            trans.begin();
            normativArtikal = (NormativArtikal)eManager.find(NormativArtikal.class, (Object)normativArtikal.getId());
            normativArtikal.setDatum(date);
            this.base.merge((Object)normativArtikal);
            trans.commit();
            this.base.refresh((Object)normativArtikal);
            log.info("tabela normativArtikal izmenjena");
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.WARNING, "Stavka racuna nije izmenjena. Doslo je do greske ", e);
        }
        return normativArtikal;
    }

    public void updateStavkaRacunaRacun(StavkaRacuna s) {
        log.info(new Date() + "Azuriranje stavke racuna " + s.getNaziv());
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update stavkaracuna SET stavkaracuna.racun_id=" + s.getRacun().getId() + " WHERE stavkaracuna.id=" + s.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info("stavka racuna azurirana");
    }

    public void updateStavkaRacuna(int brojStola, Racun racun) {
        log.info("Azuriranje stavki za racun " + racun);
        Query q = this.base.createQuery("update StavkaRacuna sr set sr.racun = :r where sr.brojStola = :bs and sr.racun is null");
        q.setParameter("r", (Object)racun);
        q.setParameter("bs", (Object)brojStola);
        int updated = q.executeUpdate();
        log.info("Azurirano stavki: " + updated);
    }

    public void updateStavkaRacunaJPA(int brojStola, Racun racun) {
        log.info("Azuriranje stavki za racun " + racun);
        TypedQuery q = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.brojStola = :bs and sr.racun is null", StavkaRacuna.class);
        q.setParameter("bs", (Object)brojStola);
        List lsr = q.getResultList();
        this.base.getTransaction().begin();
        int updated = 0;
        for (StavkaRacuna sr : lsr) {
            ++updated;
            sr.setRacun(racun);
            this.base.merge((Object)sr);
        }
        this.base.getTransaction().commit();
        log.info("Azurirano stavki: " + updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStavkaRacunaRacun(Integer bs, Long rid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update stavkaracuna SET stavkaracuna.racun_id=" + rid + " WHERE stavkaracuna.brojStola=" + bs + " and racun_id IS NULL";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
        log.info("stavka racuna azurirana");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StavkaRacuna> readStavkeRacuna2(Integer bs) {
        ArrayList<StavkaRacuna> stavke = new ArrayList<StavkaRacuna>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "select id,cena,kolicina,naziv FROM stavkaracuna WHERE( brojStola=" + bs + " and RACUN_ID IS NULL);";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(insertString1);
            while (this.r.next()) {
                StavkaRacuna sr = new StavkaRacuna();
                sr.setBrojStola(bs);
                sr.setId(this.r.getLong(1));
                sr.setCena(this.r.getDouble(2));
                sr.setKolicina(this.r.getDouble(3));
                sr.setNaziv(this.r.getString(4));
                stavke.add(sr);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe(ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return stavke;
    }

    public List<StavkaRacuna> readStavkeRacuna2JPA(Integer bs) {
        Query q = this.base.createQuery("SELECT s FROM StavkaRacuna s WHERE s.brojStola = :bs AND s.racun is null");
        q.setParameter("bs", (Object)bs);
        ArrayList<StavkaRacuna> stavke = new ArrayList();
        try {
            stavke = q.getResultList();
        }
        catch (Exception e) {
            log.log(Level.INFO, "{0} JPA - Vra\u0107ena prazna lista za sto broj {1} - {2}", new Object[]{new Date(), bs, e.getMessage()});
        }
        return stavke;
    }

    public void updateTura(int brojStola, Racun racun) {
        log.info("Azuriranje tura za racun " + racun);
        Query q = this.base.createQuery("update Tura t set t.racun = :r where t.brojStola = :bs and t.racun is null");
        q.setParameter("r", (Object)racun);
        q.setParameter("bs", (Object)brojStola);
        int updated = q.executeUpdate();
        log.info("Azurirano tura: " + updated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTuraRacun(Integer bs, Long rid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update tura SET racun_id=" + rid + " WHERE tura.brojStola=" + bs + " and racun_id IS NULL";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
        log.info("stavka racuna azurirana");
    }

    public void updateTuraJPA(int brojStola, Racun racun) {
        log.info("Azuriranje tura za racun " + racun);
        TypedQuery q = this.base.createQuery("SELECT t FROM Tura t WHERE t.brojStola = :bs and t.racun is null", Tura.class);
        q.setParameter("bs", (Object)brojStola);
        List list = q.getResultList();
        int updated = 0;
        this.base.getTransaction().begin();
        for (Tura tura : list) {
            ++updated;
            tura.setRacun(racun);
            this.base.merge((Object)tura);
        }
        this.base.getTransaction().commit();
        log.info("Azurirano tura: " + updated);
    }

    public void updateRacunaNP(Racun r) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update racun SET racun.crnoPlacanje=" + null + ",racun.fiskalniOdstampan = 0 WHERE racun.id=" + r.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info("stavka racuna azurirana");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStavkaRacunaKolicina(StavkaRacuna s, double kolicina) {
        log.info(new Date() + "azuriranje stavke racuna");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update stavkaracuna SET stavkaracuna.kolicina=" + kolicina + " WHERE stavkaracuna.id=" + s.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        log.info("stavka racuna azurirana");
    }

    public void updateStavkaRacunaBrojStola(StavkaRacuna s) {
        log.info(new Date() + "azuriranje stavke racuna");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update stavkaracuna SET stavkaracuna.brojStola=" + s.getBrojStola() + " WHERE stavkaracuna.id=" + s.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info("stavka racuna azurirana");
    }

    public void updateTuraRacun(Tura t, Long racunId) {
        log.info(new Date() + "azuriranje ture");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update tura SET tura.racun_id=" + racunId + " WHERE tura.id=" + t.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info("tura azurirana");
    }

    public void updateTuraBrojStola(Tura t) {
        log.info(new Date() + "azuriranje ture");
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "update tura SET tura.brojStola=" + t.getBrojStola() + " WHERE tura.id=" + t.getId();
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        log.info("tura azurirana");
    }

    public void deleteStavkaRacuna(StavkaRacuna l) {
        this.base.getTransaction().begin();
        StavkaRacuna sr = (StavkaRacuna)this.base.find(StavkaRacuna.class, (Object)l.getId());
        this.base.remove((Object)sr);
        this.base.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStavkaRacuna(Long sid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM stavkaracuna WHERE id=" + sid + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStavkaRacuna(Integer bs) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM stavkaracuna WHERE (brojStola=" + bs + " and RACUN_ID IS NULL);";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTura(Integer bs) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM tura WHERE (brojStola=" + bs + " and RACUN_ID IS NULL);";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTura(Long tid) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "DELETE FROM tura WHERE id =" + tid + ";";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insertString1);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countStavkaRacuna(Integer bs) {
        int i = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "select count(id) FROM stavkaracuna WHERE( brojStola=" + bs + " and RACUN_ID IS NULL);";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(insertString1);
            while (this.r.next()) {
                i = this.r.getInt(1);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe(ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countStavkaRacuna(Long tid) {
        int i = 0;
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insertString1 = "select count(id) FROM stavkaracuna WHERE TURA_ID=" + tid + ";";
        try {
            stmt = conn.createStatement();
            this.r = stmt.executeQuery(insertString1);
            while (this.r.next()) {
                i = this.r.getInt(1);
            }
            this.r.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe(ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
        return i;
    }

    public List<StavkaRacuna> readNenaplaceneStavkeRacuna(Tura l) {
        Query query = this.base.createQuery("SELECT o FROM StavkaRacuna o WHERE (o.tura = :l AND o.racun is null)");
        query.setParameter("l", (Object)l);
        return query.getResultList();
    }

    public List<StavkaRacuna> readNenaplaceneStavkeRacuna() {
        Query query = this.base.createQuery("SELECT o FROM StavkaRacuna o WHERE o.racun is null");
        return query.getResultList();
    }

    public List<StavkaRacuna> readNenaplaceneStavkeRacuna(List<PodgrupaArtikala> podgrupe) {
        Query query = this.base.createQuery("SELECT o FROM StavkaRacuna o WHERE o.racun is null and o.artikal.podgrupa in :p");
        query.setParameter("p", podgrupe);
        return query.getResultList();
    }

    public List<StavkaRacuna> readStavkeRacuna(Integer bs) {
        Query query = this.base.createQuery("SELECT o FROM StavkaRacuna o WHERE (o.brojStola = :bs AND o.racun is null)");
        query.setParameter("bs", (Object)bs);
        List list = query.getResultList();
        for (StavkaRacuna stavkaRacuna : list) {
            System.out.println("----------" + stavkaRacuna.getArtikal().toString());
        }
        return list;
    }

    public List<Tura> readNenaplaceneTure(Integer brojStola) {
        TypedQuery q = this.base.createQuery("SELECT DISTINCT t FROM Tura t WHERE t.racun IS NULL AND t.brojStola = :brojStola", Tura.class);
        q.setParameter("brojStola", (Object)brojStola);
        List ture = q.getResultList();
        return ture;
    }

    public Tura addTura(Tura t) {
        log.info(new Date() + " - Dodavanje ture ");
        String racunId = t.getRacun() != null ? t.getRacun().getId().toString() : null;
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        Tura tura = t;
        Long id = null;
        String insertString1 = "insert into tura values(null," + t.getBrojStola() + "," + t.getBrojTure() + ",'" + Konstante.getSQLFormat(t.getDatum()) + "'," + racunId + ")";
        String selectString = "select id from tura where tura.id = (select max(id) from tura)";
        try {
            tempStmt = conn.createStatement();
            tempStmt.executeUpdate(insertString1);
            ResultSet rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                id = Long.valueOf(rs.getString("id"));
            }
            tura.setId(id);
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            log.severe("SQLException: " + ex.getMessage() + "/n" + ex.getSQLState());
        }
        log.info(new Date() + " - Tura dodata " + tura.toString());
        return tura;
    }

    public Tura addTuraJPA(Tura t) {
        log.info(new Date() + " - Dodavanje ture ");
        try {
            this.base.getTransaction().begin();
            this.base.persist((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            log.warning(new Date() + " - Tura nije dodata ");
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
        log.info(new Date() + " - Tura dodata " + t);
        return t;
    }

    public void deleteTura(Tura l) {
        this.base.getTransaction().begin();
        Tura t = (Tura)this.base.find(Tura.class, (Object)l.getId());
        this.base.remove((Object)t);
        this.base.getTransaction().commit();
        log.info("tura obrisana");
    }

    public List<Tura> getZavrseneTure(Date date) {
        Query query = this.base.createQuery("SELECT t  FROM Tura t WHERE t.kraj <> '1970-01-01 01:00:00' and t.datum > :date and t.racun is null");
        query.setParameter("date", (Object)date);
        return query.getResultList();
    }

    public List<Tura> getNenaplaceneTure(Integer sto) {
        Query query = this.base.createQuery("SELECT t  FROM Tura t WHERE(t.brojStola = :sto AND t.racun IS NULL) ORDER BY t.brojTure ");
        query.setParameter("sto", (Object)sto);
        return query.getResultList();
    }

    public List<Tura> getNenaplaceneTureBMaster(Integer sto) {
        Query query = this.base.createNativeQuery("SELECT * FROM tura t\r\nJOIN racun r ON t.RACUN_ID = r.id\r\nWHERE t.brojStola = ? AND r.zatvoren = 0", Tura.class);
        query.setParameter(1, (Object)sto);
        return query.getResultList();
    }

    public List<Tura> getTureRastavljanje(Integer sto) {
        Query query = this.base.createQuery("SELECT DISTINCT t FROM Tura t LEFT JOIN t.stavke s WHERE (t.brojStola = :sto AND t.racun IS NULL AND s.glavnaStavka IS NULL) ORDER BY t.brojTure ");
        query.setParameter("sto", (Object)sto);
        return query.getResultList();
    }

    public List<Tura> getTureRastavljanjeQuery(Integer sto) {
        String query = "SELECT * FROM tura t WHERE t.brojStola = ? AND t.RACUN_ID IS NULL";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setInt(1, sto);
            ResultSet resultSet = ps.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<Racun> getRacuni(Date d1, List<NacinPlacanja> belap, List<CrnoPlacanje> crnap, List<Kasa> kase, List<Odeljenje> od) {
        LinkedList<Racun> racuni = new LinkedList<Racun>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String pBelap = "";
        String pCrnap = "";
        String pOdeljenja = "";
        String pKase = "";
        if (od != null) {
            for (Odeljenje o : od) {
                pOdeljenja = pOdeljenja.concat(o.getId().toString()).concat(",");
            }
            while (pOdeljenja.endsWith(",")) {
                pOdeljenja = pOdeljenja.substring(0, pOdeljenja.length() - 1);
            }
        }
        if (!belap.isEmpty()) {
            for (NacinPlacanja np : belap) {
                pBelap = pBelap.concat("'").concat(np.name()).concat("'").concat(",");
            }
            while (pBelap.endsWith(",")) {
                pBelap = pBelap.substring(0, pBelap.length() - 1);
            }
        }
        if (!crnap.isEmpty()) {
            for (CrnoPlacanje cp : crnap) {
                if (cp == null) continue;
                pCrnap = pCrnap.concat("'").concat(cp.getNaziv()).concat("'").concat(",");
            }
            while (pCrnap.endsWith(",")) {
                pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
            }
        }
        if (kase == null) {
            kase = this.findAllKasa();
        }
        for (Kasa k : kase) {
            if (k == null || k.getId() == null) continue;
            pKase = pKase.concat(k.getId().toString()).concat(",");
        }
        while (pKase.endsWith(",")) {
            pKase = pKase.substring(0, pKase.length() - 1);
        }
        Date day1 = this.getPocetni(d1);
        Date day2 = this.getKrajnji(d1);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT DISTINCT r.* FROM racun r left join stavkaracuna sr on sr.RACUN_ID = r.id ");
        sb.append("left join artikal_odeljenje ao on ao.ARTIKLI_ID = sr.ARTIKAL_ID ");
        sb.append("left join placanje p on p.RACUN_ID = r.id ");
        sb.append("left join kasa k on k.id = r.KASA_ID ");
        sb.append("WHERE r.datum BETWEEN '" + sdf.format(day1) + "' and '" + sdf.format(day2) + "' ");
        sb.append("and r.KASA_ID in (" + pKase + ") ");
        sb.append("and ao.ODELJENJA_ID in (" + pOdeljenja + ") ");
        sb.append(!pCrnap.isEmpty() ? "and (r.crnoPlacanje in (" + pCrnap + ") or p.nacin in (" + pBelap + ")); " : "and  p.nacin in (" + pBelap + "); ");
        System.out.println(sb.toString());
        Connection conn = this.getConnection();
        try {
            PreparedStatement ps = conn.prepareStatement(sb.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                List<StavkaRacuna> stavke = this.getStavke(rs.getLong("id"));
                Konobar kon = this.getKonobar(rs.getLong("KONOBAR_ID"));
                Kasa kasa = new Kasa();
                Racun r = new Racun();
                r.setId(rs.getLong("id"));
                r.setDatum(rs.getTime("datum"));
                r.setCrnoPlacanje(rs.getString("crnoPlacanje"));
                r.setKonobar(kon);
                r.setBrojStola(rs.getInt("brojStola"));
                r.setStavke1(stavke);
                r.setPopust(rs.getDouble("popust"));
                kasa.setId(rs.getLong("KASA_ID"));
                r.setKasa(kasa);
                racuni.add(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return racuni;
    }

    public List<Racun> getRacuni(Date d1, Date d2, Artikal a, Konobar k) {
        Query query = null;
        if (a == null && k == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE(r.crnoPlacanje=:null AND r.datum BETWEEN :d1 AND :d2 )");
        }
        if (a != null && k == null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE( sr.artikal = :a AND (sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("a", (Object)a);
        }
        if (a == null && k != null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE(( r.crnoPlacanje=:null AND r.konobar=:k) AND r.datum BETWEEN :d1 AND :d2 )");
            query.setParameter("k", (Object)k);
        }
        if (a != null && k != null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun.datum BETWEEN :d1 AND :d2) AND (sr.racun.konobar=:k AND sr.racun.crnoPlacanje=:null))");
            query.setParameter("a", (Object)a);
            query.setParameter("k", (Object)k);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getSviRacuniOdlozeno(Date d1, Date d2, StalniGost sg) {
        Query query = null;
        if (sg == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 AND r.naOsnovno = :o ");
        } else {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 AND r.naOsnovno = :o AND r.stalniGost = :sg ");
            query.setParameter("sg", (Object)sg);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("o", (Object)Boolean.TRUE);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getSviRacuni(Date d1, Date d2, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select * \nfrom racun r \nwhere r.datum BETWEEN ? and ? ";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)d1);
            ppa.setParameter(i++, (Object)d2);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getSveStavke(Date d, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "Select\nsr.ARTIKAL_ID as artid,\nsum(sr.kolicina) as kolicina\nfrom stavkaracuna sr\nleft join racun r on r.id = sr.RACUN_ID\nWHERE r.datum BETWEEN (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 1) \nand (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 0)  \ngroup by sr.ARTIKAL_ID order by sr.ARTIKAL_ID";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)d);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public long getBrojOtvorenihStolovaByKonobar(Konobar k, Date d1, Date d2) {
        String query = "SELECT COUNT(id) AS brOtvorenih FROM(\nSELECT COUNT(s.id) AS id\nfrom sto s \nleft join tura t on t.brojStola = s.broj\nwhere s.KONOBAR_ID = ? and t.RACUN_ID is null  \nGROUP BY s.broj) AS trt";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, k.getId());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getLong("brOtvorenih");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long getBrojOtvorenihStolovaByKonobarBMaster(Konobar k, Date d1, Date d2) {
        String query = "SELECT COUNT(id) AS brOtvorenih  FROM\r\n(SELECT \r\nr.id, \r\nCOUNT(sr.id) as brojStavki \r\nFROM racun r \r\nJOIN stavkaracuna sr ON r.id = sr.RACUN_ID\r\nWHERE r.zatvoren = 0 AND r.konobar_Id = ?\r\nGROUP BY r.id) AS trt";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, k.getId());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return rs.getLong("brOtvorenih");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> nenaplaceniArtikliPoKonobaru(long konobarId, Date d1, Date d2, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select \nsr.naziv as 'artikal',\nsr.cena as 'cena',\nsum(sr.kolicina) as 'kolicina'\nfrom stavkaracuna sr\nleft join sto s on sr.brojStola = s.broj \nleft join tura t on t.id = sr.TURA_ID\nwhere s.KONOBAR_ID = ? and sr.RACUN_ID is null\ngroup by sr.naziv, sr.cena";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> nenaplaceniArtikliPoKonobaruBMaster(long konobarId, Date d1, Date d2, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select \r\nsr.naziv as 'artikal',\r\nsr.cena as 'cena',\r\nsum(sr.kolicina) as 'kolicina'\r\nfrom stavkaracuna sr\r\nJOIN racun r ON sr.RACUN_ID = r.id\r\nwhere r.KONOBAR_ID = ? AND r.zatvoren = 0\r\ngroup by sr.naziv, sr.cena";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoKOnobaru(long zdBrojOd, long ZDBrojDo, long konobarId, String bela, String crna, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select\n(sr.cena-sr.cena * r.popust/100) as 'srCena',\na.jedinicaMere as 'jedMere',\nCOALESCE(pgra.naziv, '')  as 'podgrupa',\nsr.naziv as 'naziv',\nCOALESCE(sum(sr.kolicina),0) as 'kolicina',\nif(r.menipromet, ROUND((sr.cena * (100 - coalesce(r.popust, 0))/100),2), ROUND((sr.cena * (100 - coalesce(r.popust*a.dozvoljenPopust, 0))/100),2)) as 'cena'\nfrom racun r\nleft join stavkaracuna sr on r.id = sr.RACUN_ID\nleft join artikal a on a.id = sr.ARTIKAL_ID\njoin podgrupaartikala pgra on pgra.id = a.PODGRUPA_ID\ninner join konobar k on k.id = r.KONOBAR_ID and r.KONOBAR_ID = ?1\nwhere r.zdBroj BETWEEN\t?2 AND ?3 \nand (r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, ?4) )\nor (find_in_set(r.crnoplacanje, ?5 )))\ngroup by a.PODGRUPA_ID, sr.naziv, srCena \norder by a.PODGRUPA_ID";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            ppa.setParameter(i++, (Object)zdBrojOd);
            ppa.setParameter(i++, (Object)ZDBrojDo);
            ppa.setParameter(i++, (Object)bela);
            ppa.setParameter(i++, (Object)crna);
            System.out.println(ppa);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoKOnobaruPodgrupe(long ZdBrojOd, long ZdBrojDo, long konobarId, String bela, String crna, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select \npgra.naziv as 'podgrupa',\nsum(ROUND((sr.cena * (100 - coalesce(r.popust, 0))/100),2) * sr.kolicina) as 'vrednost'\nfrom stavkaracuna sr\nleft join racun r on r.id = sr.RACUN_ID\nleft join artikal a on a.id = sr.ARTIKAL_ID\nleft join podgrupaartikala pgra on pgra.id = a.PODGRUPA_ID\ninner join konobar k on k.id = r.KONOBAR_ID and r.KONOBAR_ID = ?1\nwhere r.zdBroj BETWEEN ?2 and ?3 \nand sr.RACUN_ID is NOT NULL \nand (r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, ?4 ))\nor (find_in_set(r.crnoplacanje, ?5 )))\ngroup by a.PODGRUPA_ID order by a.PODGRUPA_ID";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            ppa.setParameter(i++, (Object)ZdBrojOd);
            ppa.setParameter(i++, (Object)ZdBrojDo);
            ppa.setParameter(i++, (Object)bela);
            ppa.setParameter(i++, (Object)crna);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoKOnobaruGrupe(long zdBrojOd, long zdBrojDo, long konobarId, String bela, String crna, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select\nga.naziv as 'grupa',\nsum(ROUND((sr.cena * (100 - coalesce(r.popust, 0))/100),2) * sr.kolicina) as 'vrednost'\nfrom racun r \nleft join stavkaracuna sr on r.id = sr.RACUN_ID\nleft join artikal a on a.id = sr.ARTIKAL_ID\nleft join podgrupaartikala pgra on pgra.id = a.PODGRUPA_ID\nleft join grupaartikala ga on ga.id = pgra.GRUPA_ID\ninner join konobar k on k.id = r.KONOBAR_ID and r.KONOBAR_ID = ?1\nwhere r.zdBroj BETWEEN ?2 and ?3 \nand (r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, ?4 ))\nor (find_in_set(r.crnoplacanje, ?5 )))\ngroup by pgra.GRUPA_ID order by pgra.GRUPA_ID";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            ppa.setParameter(i++, (Object)zdBrojOd);
            ppa.setParameter(i++, (Object)zdBrojDo);
            ppa.setParameter(i++, (Object)bela);
            ppa.setParameter(i++, (Object)crna);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoKOnobaruNaciniPlacanja(long zdBrojOd, long zdBrojDo, long konobarId, String bela, String crna, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select nacin, sum(neto) as neto, sum(popust) as popust, sum(servis) as servis, sum(bruto) as bruto FROM ( \nselect \np.nacin as 'nacin',\nsum(sr.kolicina * sr.cena) as 'neto',\nROUND(sum(sr.kolicina * sr.cena)- sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'popust',\nROUND(if(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)) > sum(sr.kolicina * sr.cena), \nsum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100))-sum(sr.kolicina * sr.cena),  0),2) as 'servis',\nROUND(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'bruto'\nfrom racun r\nleft join placanje p on p.RACUN_ID = r.id \nleft join stavkaracuna sr on sr.RACUN_ID = r.id\nleft join artikal a on a.id = sr.ARTIKAL_ID\nINNER JOIN (SELECT RACUN_ID, COUNT(RACUN_ID) as cnt FROM placanje GROUP BY RACUN_ID) c ON r.id = c.RACUN_ID\nwhere r.KONOBAR_ID = ?1 and r.zdBroj BETWEEN ?2 AND ?3 \nand r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, ?4 ) )\nAND c.cnt < 2 \ngroup by p.nacin\n\nunion\n\nselect distinct\np.nacin as 'nacin',\nsum(p.iznos) as 'neto',\nROUND(sum(p.iznos)- sum(p.iznos *( (100 - r.popust)/100)),2) as 'popust',\nROUND(if(sum(p.iznos *( (100 - r.popust)/100)) > sum(p.iznos), \nsum(p.iznos *( (100 - r.popust)/100))-sum(p.iznos),  0),2) as 'servis',\nROUND(sum(p.iznos *( (100 - r.popust)/100)),2) as 'bruto'\nfrom racun r\nLEFT JOIN placanje p ON r.id = p.RACUN_ID AND ( find_in_set(p.nacin,   ?4  ))\nINNER JOIN (SELECT RACUN_ID, COUNT(RACUN_ID) as cnt FROM placanje GROUP BY RACUN_ID) c ON r.id = c.RACUN_ID\nwhere r.KONOBAR_ID = ?1 and r.zdBroj BETWEEN  ?2 AND ?3  \nAND c.cnt > 1 \ngroup by p.nacin \n\nunion\n\nselect \nr.crnoPlacanje as 'nacin',\nsum(sr.kolicina * sr.cena) as 'neto',\nROUND(sum(sr.kolicina * sr.cena)- sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'popust',\nROUND(if(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)) > sum(sr.kolicina * sr.cena), \nsum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100))-sum(sr.kolicina * sr.cena),  0),2) as 'servis',\nROUND(sum(sr.kolicina * (sr.cena * (100 - coalesce(r.popust*(if(r.menipromet, 1 ,a.dozvoljenPopust)), 0))/100)),2) as 'bruto'\nfrom racun r\nleft join stavkaracuna sr on sr.RACUN_ID = r.id\nleft join artikal a on a.id = sr.ARTIKAL_ID\nwhere r.KONOBAR_ID = ?1 and r.zdBroj BETWEEN  ?2 AND ?3  \nAND r.crnoPlacanje IS NOT NULL  and locate(r.crnoPlacanje, ?5 ) > 0\nGROUP BY r.crnoPlacanje\n) as t \ngroup by nacin order by nacin";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            ppa.setParameter(i++, (Object)zdBrojOd);
            ppa.setParameter(i++, (Object)zdBrojDo);
            ppa.setParameter(i++, (Object)bela);
            ppa.setParameter(i++, (Object)crna);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoKonobaruBrojRacunaPoNacinu(long zdBrojOd, long zdBrojDo, long konobarId, String bela, String crna, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select nacin as 'nacin', sum(brojRacuna) as 'brojRacuna' from (\nselect \nif(count(distinct(p.nacin)) > 1, 'KOMBINOVANO', COALESCE(p.nacin, r.crnoplacanje)) AS 'nacin',\nCOUNT(DISTINCT r.id) as 'brojRacuna'\nfrom racun r\nleft join placanje p on r.id = p.RACUN_ID\ninner join konobar k on k.id = r.KONOBAR_ID and r.KONOBAR_ID = ?1\nwhere r.zdBroj BETWEEN ?2 and ?3 \nand (r.id in (select RACUN_ID from placanje where r.id= placanje.RACUN_ID and FIND_IN_SET(placanje.nacin, ?4 ) )\nor (find_in_set(r.crnoplacanje, ?5 )))\ngroup by r.id) as trt\ngroup by nacin";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)konobarId);
            ppa.setParameter(i++, (Object)zdBrojOd);
            ppa.setParameter(i++, (Object)zdBrojDo);
            ppa.setParameter(i++, (Object)bela);
            ppa.setParameter(i++, (Object)crna);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getRealizacija(Date d, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "SELECT \nCOUNT(DISTINCT(sr.RACUN_ID)) as 'brojracuna',\nsum((sr.cena-(sr.cena*(r.popust*a.dozvoljenPopust/100)))*sr.kolicina) as 'promet',\nsum(a.cena*sr.kolicina) - sum((sr.cena-(sr.cena*(r.popust*a.dozvoljenPopust/100)))*sr.kolicina) as 'popust',\n(select COALESCE(SUM(ps.vrednostSPDV), 0) \nfrom prijemnicastavka ps \nleft join prijemnica p on p.id = ps.PRIJEMNICA_ID \nwhere p.datumPrijemnice BETWEEN (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 1) \nand (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 0)) as 'nabavkaNaDan',\n(select\nsum(ts.komad * ts.kolicina) \nfrom trebovanjestavka ts\nleft join trebovanje t on t.id = ts.TREBOVANJE_ID\nwhere t.datumTrebovanja = DATE( ?1 ) and t.tip = 'OTPIS') as 'otpis1', \n(select \nCOALESCE(sum(os.vrednost * \n(CASE\n\tWHEN a.poreskaGrupa = 3 THEN 1.2\n\tWHEN a.poreskaGrupa = 4 THEN 1.1\n\tELSE 1\n\tEND)), 0) \nfrom otpisstavka os \nleft join otpis o on o.id = os.OTPIS_ID \nleft join artikal a on a.id = os.ARTIKAL_ID \nwhere o.datum BETWEEN (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 1) \nand (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 0)) as otpis,\n(select COALESCE(sum(t.iznos), 0) \nfrom trosak t where t.dan BETWEEN (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 1) \nand (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 0)) as 'trosak'\nfrom stavkaracuna sr\nleft join racun r on r.id = sr.RACUN_ID\nleft join artikal a on a.id = sr.ARTIKAL_ID\nwhere r.datum BETWEEN (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 1) and (select z.zakljucenje from zd z where z.datum = DATE(?1) and z.pocetak = 0)";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)d);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getSviRacuni(Date d1, Date d2, Artikal a, Konobar k, String bPlacanje, String cPlacanje, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select\nr.id as id,\nr.popust as popust,\nr.brojStola as sto,\nif(r.menipromet, sum((sr.cena-(sr.cena*(r.popust/100)))*sr.kolicina), sum((sr.cena-(sr.cena*(r.popust*a.dozvoljenPopust/100)))*sr.kolicina)) as total,\nkon.punoIme as 'konobar',\nDATE(r.datum) as datum,\nTIME(r.datum) as vreme,\nr.brojRacuna as broj,\nk.oznaka as 'kasa',\nIFNULL((select p.iznos from placanje p where p.RACUN_ID = r.id and p.nacin ='GOTOVINA') , 0) as gotovina,\nIFNULL((select p.iznos from placanje p where p.RACUN_ID = r.id and p.nacin ='CEK') , 0) as cek,\nIFNULL((select p.iznos from placanje p where p.RACUN_ID = r.id and p.nacin ='KARTICA') , 0) as kartica,\nIFNULL((select p.iznos from placanje p where p.RACUN_ID = r.id and p.nacin ='FAKTURA') , 0) as faktura,\nIFNULL(r.crnoPlacanje, '') as 'crno',\nIFNULL(mp.naziv, '') as 'meni',\nif(r.zatvoren , 'DA' , 'NE') as zatvoren,\nIFNULL(IFNULL(sg.naziv, kom.naziv), '') as 'komitent',\nIFNULL(r.brojBI, '') as brojIsecka\n, IFNULL(imeHotelskogGosta, '') as imeHotelskogGosta from stavkaracuna sr \nleft join racun r on sr.RACUN_ID = r.id\nleft join placanje p on p.RACUN_ID = r.id\nleft join artikal a on a.id = sr.ARTIKAL_ID\nleft join menipromet mp on mp.RACUN_ID = r.id\nleft join kasa k on k.id = r.KASA_ID\nleft join komitent kom on kom.id = r.KOMITENT_ID\nleft join stalnigost sg on sg.id = r.STALNIGOST_ID\nleft join konobar kon on kon.id = r.KONOBAR_ID\nwhere r.datum BETWEEN ?1 and ?2 \nand (( -1 = ?3 ) OR (a.id  = ?3 )) \nand (( -1 = ?4 ) OR (r.KONOBAR_ID  = ?4 )) \nand (FIND_IN_SET(p.nacin, ?5 ) \nor (find_in_set(r.crnoplacanje, ?6 ) OR (p.nacin is null and r.crnoplacanje is null)))\nAND r.zatvoren = 1\ngroup by id";
            d1 = this.getPocetni(d1);
            d2 = this.getKrajnji(d2);
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)d1);
            ppa.setParameter(i++, (Object)d2);
            ppa.setParameter(i++, (Object)(a != null ? a.getId() : -1L));
            ppa.setParameter(i++, (Object)(k != null ? k.getId() : -1L));
            ppa.setParameter(i++, (Object)bPlacanje);
            ppa.setParameter(i++, (Object)cPlacanje);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public List<Racun> getSviRacuni(Date d1, Date d2, Artikal a, Konobar k, String placanje) {
        Query query = null;
        if (a == null && k == null && placanje.equals("")) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2");
        }
        if (a == null && k == null && !placanje.equals("")) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE (r.crnoPlacanje =:p AND r.datum BETWEEN :d1 AND :d2)");
            query.setParameter("p", (Object)placanje);
        }
        if (a != null && k == null && placanje.equals("")) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE sr.artikal = :a AND sr.racun.datum BETWEEN :d1 AND :d2");
            query.setParameter("a", (Object)a);
        }
        if (a != null && k == null && !placanje.equals("")) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun.crnoPlacanje =:p ) AND sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("a", (Object)a);
            query.setParameter("p", (Object)placanje);
        }
        if (a == null && k != null && placanje.equals("")) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 AND r.konobar=:k");
            query.setParameter("k", (Object)k);
        }
        if (a == null && k != null && !placanje.equals("")) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE (r.crnoPlacanje=:p AND r.datum BETWEEN :d1 AND :d2 AND r.konobar=:k)");
            query.setParameter("k", (Object)k);
            query.setParameter("p", (Object)placanje);
        }
        if (a != null && k != null && placanje.equals("")) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun.datum BETWEEN :d1 AND :d2) AND sr.racun.konobar=:k)");
            query.setParameter("a", (Object)a);
            query.setParameter("k", (Object)k);
        }
        if (a != null && k != null && !placanje.equals("")) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun.datum BETWEEN :d1 AND :d2) AND(sr.racun.konobar=:k AND sr.racun.crnoPlacanje=:p)");
            query.setParameter("a", (Object)a);
            query.setParameter("k", (Object)k);
            query.setParameter("p", (Object)placanje);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Tura> getSveTure(Date d1, Date d2, Artikal a, Konobar k, String placanje, boolean n) {
        Query query = null;
        if (n) {
            if (a == null && k == null) {
                query = this.base.createQuery("SELECT t FROM Tura t WHERE( t.racun=:null)");
                query.setParameter("null", null);
            }
            if (a == null && k != null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k AND sr.tura.racun=:null )");
                query.setParameter("k", (Object)k);
            }
            if (a != null && k == null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE (sr.artikal = :a AND sr.tura.racun=:null )");
                query.setParameter("a", (Object)a);
            }
            if (a != null && k != null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun = :null) AND  (SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k)");
                query.setParameter("a", (Object)a);
                query.setParameter("k", (Object)k);
            }
        } else {
            if (a == null && k == null && placanje.equals("")) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE r.datum BETWEEN :d1 AND :d2");
            }
            if (a == null && k == null && !placanje.equals("")) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE (r.racun.crnoPlacanje =:p AND r.datum BETWEEN :d1 AND :d2)");
                query.setParameter("p", (Object)placanje);
            }
            if (a != null && k == null && placanje.equals("")) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE sr.artikal = :a AND sr.tura.datum BETWEEN :d1 AND :d2");
                query.setParameter("a", (Object)a);
            }
            if (a != null && k == null && !placanje.equals("")) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun.crnoPlacanje =:p ) AND sr.tura.datum BETWEEN :d1 AND :d2)");
                query.setParameter("a", (Object)a);
                query.setParameter("p", (Object)placanje);
            }
            if (a == null && k != null && placanje.equals("")) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE r.datum BETWEEN :d1 AND :d2 AND ((r.racun<>:null AND r.racun.konobar=:k) OR (r.racun=:null AND (SELECT s.konobar FROM Sto s WHERE s.broj = r.brojStola)=:k))");
                query.setParameter("k", (Object)k);
            }
            if (a == null && k != null && !placanje.equals("")) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE (r.racun.crnoPlacanje=:p AND r.datum BETWEEN :d1 AND :d2 )AND(r.racun<>:null AND r.racun.konobar=:k)");
                query.setParameter("k", (Object)k);
                query.setParameter("p", (Object)placanje);
            }
            if (a != null && k != null && placanje.equals("")) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.tura.datum BETWEEN :d1 AND :d2) AND((sr.racun<>:null AND sr.racun.konobar=:k) OR (sr.racun=:null AND  (SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k)))");
                query.setParameter("a", (Object)a);
                query.setParameter("k", (Object)k);
            }
            if (a != null && k != null && !placanje.equals("")) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE (sr.artikal = :a AND sr.tura.datum BETWEEN :d1 AND :d2) AND(sr.racun.konobar=:k AND sr.racun.crnoPlacanje=:p)");
                query.setParameter("a", (Object)a);
                query.setParameter("k", (Object)k);
                query.setParameter("p", (Object)placanje);
            }
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<Tura> getTure(Date d1, Date d2, Artikal a, Konobar k, boolean n) {
        Query query = null;
        if (n) {
            if (a == null && k == null) {
                query = this.base.createQuery("SELECT t FROM Tura t WHERE( t.racun=:null)");
                query.setParameter("null", null);
            }
            if (a == null && k != null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k AND sr.tura.racun=:null )");
                query.setParameter("k", (Object)k);
            }
            if (a != null && k == null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE (sr.artikal = :a AND sr.tura.racun=:null )");
                query.setParameter("a", (Object)a);
            }
            if (a != null && k != null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.racun = :null) AND  (SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k)");
                query.setParameter("a", (Object)a);
                query.setParameter("k", (Object)k);
            }
        } else {
            if (a == null && k == null) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE ((r.racun=:null OR r.racun.crnoPlacanje=:null) AND r.datum BETWEEN :d1 AND :d2)");
            }
            if (a != null && k == null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE(sr.racun=:null OR sr.racun.crnoPlacanje=:null) AND  (sr.artikal = :a AND sr.tura.datum BETWEEN :d1 AND :d2)");
                query.setParameter("a", (Object)a);
            }
            if (a == null && k != null) {
                query = this.base.createQuery("SELECT r FROM Tura r WHERE r.datum BETWEEN :d1 AND :d2 AND ((r.racun<>:null AND r.racun.crnoPlacanje=:null AND r.racun.konobar=:k) OR (r.racun=:null AND (SELECT s.konobar FROM Sto s WHERE s.broj = r.brojStola)=:k))");
                query.setParameter("k", (Object)k);
            }
            if (a != null && k != null) {
                query = this.base.createQuery("SELECT DISTINCT sr.tura FROM StavkaRacuna sr WHERE ((sr.artikal = :a AND sr.tura.datum BETWEEN :d1 AND :d2) AND((sr.racun<>:null AND sr.racun.crnoPlacanje=:null AND sr.racun.konobar=:k) OR (sr.racun=:null AND  (SELECT s.konobar FROM Sto s WHERE s.broj = sr.brojStola)=:k)))");
                query.setParameter("a", (Object)a);
                query.setParameter("k", (Object)k);
            }
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<Racun> getSviRacuni(Date d1, Date d2) {
        Query query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 and r.zatvoren = true order by r.datum ");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getSviRacuni(Date d1, Date d2, Odeljenje o) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2");
        } else {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o=:o) AND sr.racun.datum BETWEEN :d1 AND :d2");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getNeodstampaneOtpremnice(Date d1, Date d2) {
        Query query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 and r.crnoPlacanje = 'Otpremnica' AND r.fiskalniOdstampan = false");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getNeodstampaneOtpremniceGost(StalniGostiGrupa grupa, StalniGost komitent, Date d1, Date d2) {
        Query query = null;
        if (grupa != null) {
            if (komitent == null) {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost IN (SELECT s FROM StalniGost s WHERE s.grupa =:g1) and r.datum BETWEEN  :d1 AND :d2 and r.crnoPlacanje = 'Otpremnica'");
                query.setParameter("g1", (Object)grupa);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            } else {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost =:k1 and r.datum BETWEEN :d1 AND :d2 and r.crnoPlacanje = 'Otpremnica'");
                query.setParameter("k1", (Object)komitent);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
        } else {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost IS NOT NULL and(r.datum BETWEEN  :d1 AND :d2) and r.crnoPlacanje = 'Otpremnica'");
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<Racun> getRacuni(Date d1, Date d2, Odeljenje o, boolean belo, boolean crno) {
        Query query = null;
        if (o == null) {
            if (belo && !crno) {
                query = this.base.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.placanja JOIN FETCH r.stavke1 JOIN FETCH r.ture WHERE (r.crnoPlacanje IS NULL AND r.datum BETWEEN :d1 AND :d2)");
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
            if (belo && crno) {
                query = this.base.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.placanja JOIN FETCH r.stavke1 JOIN FETCH r.ture WHERE (r.datum BETWEEN :d1 AND :d2)");
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
            if (!belo && crno) {
                query = this.base.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.placanja JOIN FETCH r.stavke1 JOIN FETCH r.ture WHERE (r.crnoPlacanje IS NOT NULL AND r.datum BETWEEN :d1 AND :d2)");
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
        } else {
            if (belo && !crno) {
                query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr JOIN FETCH sr.racun.placanja JOIN FETCH sr.racun.stavke1 JOIN FETCH sr.racun.ture WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o) AND (sr.racun.crnoPlacanje IS NULL AND sr.racun.datum BETWEEN :d1 AND :d2))");
                query.setParameter("o", (Object)o);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
            if (belo && crno) {
                query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr JOIN FETCH sr.racun.placanja JOIN FETCH sr.racun.stavke1 JOIN FETCH sr.racun.ture WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o) AND (sr.racun.datum BETWEEN :d1 AND :d2))");
                query.setParameter("o", (Object)o);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
            if (!belo && crno) {
                query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr JOIN FETCH sr.racun.placanja JOIN FETCH sr.racun.stavke1 JOIN FETCH sr.racun.ture WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o) AND (sr.racun.crnoPlacanje IS NOT NULL AND sr.racun.datum BETWEEN :d1 AND :d2))");
                query.setParameter("o", (Object)o);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
        }
        if (query != null) {
            return query.getResultList();
        }
        return null;
    }

    public List<ProizvodnjaStavka> getProizvodnjaStavke(Date d1, Odeljenje o, boolean belo, boolean crno) {
        Query query = null;
        if (belo && !crno) {
            query = this.base.createQuery("SELECT s FROM ProizvodnjaStavka s JOIN FETCH s.proizvodnja WHERE s.proizvodnja.datum = :d1 and s.proizvodnja.crno = false and s.proizvodnja.odeljenje = :o");
            query.setParameter("d1", (Object)d1);
            query.setParameter("o", (Object)o);
        }
        if (query != null) {
            return query.getResultList();
        }
        return null;
    }

    public List<Racun> getRacuni(Date d1, Date d2, Odeljenje o) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.placanja JOIN FETCH r.stavke1 JOIN FETCH r.ture WHERE (r.crnoPlacanje IS NULL AND r.datum BETWEEN :d1 AND :d2)");
        } else {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr JOIN FETCH sr.racun.placanja JOIN FETCH sr.racun.stavke1 JOIN FETCH sr.racun.ture WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o) AND (sr.racun.crnoPlacanje IS NULL AND sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getPripadajuciRacuniZbirna(long zbirnaID) {
        Query query = null;
        query = this.base.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.placanja JOIN FETCH r.stavke1 JOIN FETCH r.ture WHERE (r.zbirnaFakturaId =:zbirnaID)");
        query.setParameter("zbirnaID", (Object)zbirnaID);
        return query.getResultList();
    }

    public List<Racun> getRacuniGotovinski(Date d1, Date d2) {
        Query query = null;
        query = this.base.createQuery("SELECT DISTINCT p.racun FROM Placanje p WHERE (p.racun.datum BETWEEN :d1 AND :d2) AND p.nacin<> :f ");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("f", (Object)NacinPlacanja.FAKTURA);
        return query.getResultList();
    }

    public List<Racun> getRacuniKonobari(Date d1, Date d2, Odeljenje o, Konobar k) {
        Query query = null;
        if (o == null && k == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE(r.crnoPlacanje=:null AND r.datum BETWEEN :d1 AND :d2)");
        }
        if (o != null && k == null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND (sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("o", (Object)o);
        }
        if (o == null && k != null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE(r.crnoPlacanje=:null AND (r.konobar =:k AND r.datum BETWEEN :d1 AND :d2))");
            query.setParameter("k", (Object)k);
        }
        if (o != null && k != null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE(( sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.racun.konobar =:k) AND(sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("k", (Object)k);
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getSviRacuniStolovi(Date d1, Date d2, Sto s) {
        Query query = null;
        if (s == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN :d1 AND :d2 AND r.zatvoren = true order by r.datum");
        }
        if (s != null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE (r.brojStola =:s AND r.datum BETWEEN :d1 AND :d2)");
            query.setParameter("s", (Object)s.getId());
        }
        if (s != null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE(( sr.artikal in (SELECT o.artikli FROM Odeljenje o ) AND sr.racun.brojStola =:s) AND sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("s", (Object)s.getId());
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Racun> getSviRacuniKonobari(Date d1, Date d2, Odeljenje o, Konobar k) {
        long zdOd = this.getZDbyDatum(d1).getZdBroj();
        long zdDo = this.getZDbyDatum(d2).getZdBroj();
        Query query = null;
        if (o == null && k == null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.zdBroj BETWEEN :zd1 AND :zd2 and r.zatvoren = true");
            query.setParameter("zd1", (Object)zdOd);
            query.setParameter("zd2", (Object)zdDo);
        }
        if (o != null && k == null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.racun.datum BETWEEN :d1 AND :d2");
            query.setParameter("o", (Object)o);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        if (o == null && k != null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE (r.konobar =:k AND r.datum BETWEEN :d1 AND :d2) and r.zatvoren = true ");
            query.setParameter("k", (Object)k);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        if (o != null && k != null) {
            query = this.base.createQuery("SELECT DISTINCT sr.racun FROM StavkaRacuna sr WHERE(( sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.racun.konobar =:k) AND sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("k", (Object)k);
            query.setParameter("o", (Object)o);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public Map<Double, Integer> getIznos_brojRacunaStalniGost(Date d1, Date d2, List<StalniGost> gosti) {
        HashMap<Double, Integer> mapa = new HashMap<Double, Integer>();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.getConnection();
            ps = con.prepareStatement("select sum(p.iznos) as ukupanIznos, count(r.id) as brojRacuna from racun r left join placanje p on p.RACUN_ID = r.id where r.datum BETWEEN '" + d1 + "' and '" + d2 + "' and r.STALNIGOST_ID in (" + gosti + ")");
            ResultSet rs = ps.executeQuery();
            Double iznos = rs.getDouble("ukupanIznos");
            Integer brRacuna = rs.getInt("brojRacuna");
            mapa.put(iznos, brRacuna);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapa;
    }

    public List<Racun> getRacuniStalni(StalniGost gost, Date d1, Date d2) {
        Query query = null;
        query = this.base.createQuery("SELECT r FROM Racun r WHERE r.datum BETWEEN  :d1 AND :d2 and r.stalniGost = :gost");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter(":gost", (Object)gost);
        return query.getResultList();
    }

    public List<Racun> getRacuniStalni(StalniGostiGrupa grupa, StalniGost komitent, Date d1, Date d2) {
        Query query = null;
        if (grupa != null) {
            if (komitent == null) {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost.grupa = :g1 and r.datum BETWEEN  :d1 AND :d2");
                query.setParameter("g1", (Object)grupa);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            } else {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost = :k1 and r.datum BETWEEN :d1 AND :d2");
                query.setParameter("k1", (Object)komitent);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
        } else {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost IS NOT NULL and(r.datum BETWEEN  :d1 AND :d2)");
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<Racun> getRacuniStalni(StalniGostiGrupa grupa, StalniGost komitent, Konobar konobar, Date d1, Date d2) {
        Query query = null;
        if (grupa != null) {
            if (komitent == null) {
                if (konobar != null) {
                    query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost.grupa = :g1 and r.konobar.punoIme=:k and r.datum BETWEEN  :d1 AND :d2");
                    System.out.println("upit " + query);
                    query.setParameter("g1", (Object)grupa);
                    query.setParameter("k", (Object)konobar.getPunoime());
                    query.setParameter("d1", (Object)d1);
                    query.setParameter("d2", (Object)d2);
                } else {
                    query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost.grupa = :g1 and r.datum BETWEEN  :d1 AND :d2");
                    query.setParameter("g1", (Object)grupa);
                    query.setParameter("d1", (Object)d1);
                    query.setParameter("d2", (Object)d2);
                }
            } else if (konobar != null) {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost = :k1 and r.konobar.punoIme=:k and r.datum BETWEEN :d1 AND :d2");
                query.setParameter("k1", (Object)komitent);
                query.setParameter("k", (Object)konobar.getPunoime());
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
                System.out.println("upit " + query);
            } else {
                query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost = :k1 and r.datum BETWEEN :d1 AND :d2");
                query.setParameter("k1", (Object)komitent);
                query.setParameter("d1", (Object)d1);
                query.setParameter("d2", (Object)d2);
            }
        } else if (konobar != null) {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost IS NOT NULL and r.konobar.punoIme=:k and(r.datum BETWEEN  :d1 AND :d2)");
            query.setParameter("k", (Object)konobar.getPunoime());
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
            System.out.println("upit " + query);
        } else {
            query = this.base.createQuery("SELECT r FROM Racun r WHERE r.stalniGost IS NOT NULL and(r.datum BETWEEN  :d1 AND :d2)");
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<Racun> getFaktureZbirnaFaktura(Date d1, Date d2, StalniGost sg) {
        Query query = null;
        query = sg != null ? this.base.createQuery("SELECT DISTINCT r FROM Racun r WHERE( r.placanja in (select p from Placanje p where p.nacin = :f)  and r.datum BETWEEN :d1 AND :d2 and r.stalniGost = :sg and r.zbirnaFaktura is null )") : this.base.createQuery("SELECT DISTINCT r FROM Racun r WHERE( r.placanja in (select p from Placanje p where p.nacin = :f)  and r.datum BETWEEN :d1 AND :d2 and r.zbirnaFaktura is null )");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("f", (Object)NacinPlacanja.FAKTURA);
        if (sg != null) {
            query.setParameter("sg", (Object)sg);
        }
        return query.getResultList();
    }

    public List<Racun> getFakture(Date d1, Date d2) {
        Query query = this.base.createQuery("SELECT DISTINCT r FROM Racun r WHERE( r.placanja in (select p from Placanje p where p.nacin = :f)  and r.datum BETWEEN :d1 AND :d2)");
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("f", (Object)NacinPlacanja.FAKTURA);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke(Date d1, Date d2, Odeljenje o) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2)");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavkeForKase(Date d1, Date d2, Odeljenje o, List<Kasa> kase) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2)" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE  sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.crnoPlacanje=:null AND sr.racun.datum BETWEEN :d1 AND :d2)" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        if (kase != null) {
            query.setParameter("kase", kase);
        }
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavkeForKase(Date d1, Date d2, Odeljenje o, List<PodgrupaArtikala> podgrupe, List<Kasa> kase) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE " + (kase != null ? "sr.racun.kasa IN :kase AND " : "") + "(sr.racun.crnoPlacanje=:null AND(sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE " + (kase != null ? "sr.racun.kasa IN :kase AND " : "") + " sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.crnoPlacanje=:null AND (sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("p", podgrupe);
        if (kase != null) {
            query.setParameter("kase", kase);
        }
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke(Date d1, Date d2, Odeljenje o, List<PodgrupaArtikala> podgrupe) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(sr.racun.crnoPlacanje=:null AND(sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.crnoPlacanje=:null AND (sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("p", podgrupe);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke(Date d1, Date d2, Odeljenje o, Konobar k) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(((SELECT s.konobar FROM Sto s WHERE s.broj=sr.brojStola)=:k AND (sr.racun=:null AND sr.tura.datum BETWEEN :d1 AND :d2)) OR ((sr.racun.konobar=:k AND sr.racun.crnoPlacanje=:null )AND sr.racun.datum BETWEEN :d1 AND :d2))");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(((SELECT s.konobar FROM Sto s WHERE s.broj=sr.brojStola)=:k AND (sr.racun=:null AND sr.tura.datum BETWEEN :d1 AND :d2)) OR ((sr.racun.konobar=:k AND sr.racun.crnoPlacanje=:null ) AND sr.racun.datum BETWEEN :d1 AND :d2)))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("k", (Object)k);
        return query.getResultList();
    }

    public List<StavkaRacuna> getSveStavke(Date d1, Date d2, Odeljenje o) {
        System.out.println("\u00fclazi u metodu");
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun.datum BETWEEN :d1 AND :d2");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.datum BETWEEN :d1 AND :d2)");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<StavkaRacuna> getSveStavkeForKase(Date d1, Date d2, Odeljenje o, List<Kasa> kase) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun.datum BETWEEN :d1 AND :d2" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(sr.racun.datum BETWEEN :d1 AND :d2)" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        if (kase != null) {
            query.setParameter("kase", kase);
        }
        return query.getResultList();
    }

    public List<StavkaRacuna> getSveStavke(Date d1, Date d2, Odeljenje o, List<PodgrupaArtikala> podgrupe) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE((sr.racun.crnoPlacanje=:null OR sr.racun.crnoPlacanje<>:null) AND(sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(sr.racun.crnoPlacanje=:null OR sr.racun.crnoPlacanje<>:null) AND (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND " + (podgrupe.size() > 0 ? "(sr.artikal.podgrupa in :p AND " : "") + "sr.racun.datum BETWEEN :d1 AND :d2))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        if (podgrupe.size() > 0) {
            query.setParameter("p", podgrupe);
        }
        return query.getResultList();
    }

    public List<StavkaRacuna> getSveStavkeForKase(Date d1, Date d2, Odeljenje o, List<PodgrupaArtikala> podgrupe, List<Kasa> kase) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE((sr.racun.crnoPlacanje=:null OR sr.racun.crnoPlacanje<>:null) AND(sr.artikal.podgrupa in :p AND sr.racun.datum BETWEEN :d1 AND :d2))" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(sr.racun.crnoPlacanje=:null OR sr.racun.crnoPlacanje<>:null) AND (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND " + (podgrupe.size() > 0 ? "(sr.artikal.podgrupa in :p AND " : "") + "sr.racun.datum BETWEEN :d1 AND :d2))" + (kase != null ? " AND sr.racun.kasa IN :kase " : ""));
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        if (podgrupe.size() > 0) {
            query.setParameter("p", podgrupe);
        }
        if (kase != null) {
            query.setParameter("kase", kase);
        }
        return query.getResultList();
    }

    public List<StavkaRacuna> getSveStavkeNovo(Date d1, Date d2, Odeljenje o, Konobar k) {
        LinkedList<StavkaRacuna> list = new LinkedList<StavkaRacuna>();
        String query = "Select distinct * from stavkaracuna sr left join artikal a on a.id = sr.ARTIKAL_ID left join tura t on t.id = sr.TURA_ID left join racun r on r.id = t.RACUN_ID left join sto s on s.broj = t.brojStola left join konobar k on k.id = s.KONOBAR_ID where ((Select s.KONOBAR_ID from sto s where s.broj = sr.brojStola)= " + k.getId() + " and (sr.RACUN_ID = null and t.datum BETWEEN '" + d1 + "' and '" + d2 + "') or (r.KONOBAR_ID = 1 and r.datum BETWEEN '" + d1 + "' and '" + d2 + "'))";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StavkaRacuna sr = new StavkaRacuna();
                sr.setId(rs.getLong(1));
                sr.setBrojStola(rs.getInt(2));
                sr.setCena(rs.getDouble(3));
                sr.setKolicina(rs.getDouble(4));
                sr.setNaziv(rs.getString(5));
                list.add(sr);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public List<StavkaRacuna> getSveStavkePoStalnomGostu(long zdBrojOd, long zdBrojDo, Odeljenje o, Konobar k, StalniGost sg) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE(sr.racun.konobar=:k AND sr.racun.stalniGost = :sg AND sr.racun.zdBroj BETWEEN :zdBrojOd AND :zdBrojDo)");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.racun.stalniGost = :sg AND(((SELECT s.konobar FROM Sto s WHERE s.broj=sr.brojStola)=:k AND (sr.racun=:null AND sr.tura.datum BETWEEN :d1 AND :d2)) OR (sr.racun.konobar=:k AND sr.racun.datum BETWEEN :d1 AND :d2)))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("zdBrojOd", (Object)zdBrojOd);
        query.setParameter("zdBrojDo", (Object)zdBrojDo);
        query.setParameter("k", (Object)k);
        query.setParameter("sg", (Object)sg);
        List list = query.getResultList();
        for (StavkaRacuna stavkaRacuna : list) {
            if (!this.base.contains((Object)stavkaRacuna.getRacun())) {
                this.base.merge((Object)stavkaRacuna.getRacun());
            }
            this.base.refresh((Object)stavkaRacuna);
            System.out.println(stavkaRacuna.getRacun());
        }
        return list;
    }

    public List<StavkaRacuna> getSveStavke(Date d1, Date d2, Odeljenje o, Konobar k) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE((sr.racun.konobar=:k AND sr.racun.datum BETWEEN :d1 AND :d2) OR ((SELECT s.konobar FROM Sto s WHERE s.broj=sr.brojStola)=:k AND (sr.racun=:null AND sr.tura.datum BETWEEN :d1 AND :d2)))");
        } else {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND(((SELECT s.konobar FROM Sto s WHERE s.broj=sr.brojStola)=:k AND (sr.racun=:null AND sr.tura.datum BETWEEN :d1 AND :d2)) OR (sr.racun.konobar=:k AND sr.racun.datum BETWEEN :d1 AND :d2)))");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        query.setParameter("k", (Object)k);
        List list = query.getResultList();
        for (StavkaRacuna stavkaRacuna : list) {
            this.base.refresh((Object)stavkaRacuna);
        }
        return list;
    }

    public List<StavkaRacuna> getStavke(Date d1, Odeljenje o) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.tura.datum = :d1 AND sr.racun = :null)");
        } else {
            query = this.base.createQuery("SELECT DISTINCT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.tura.datum = :d1");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke() {
        Query query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun = :null");
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<UtrosakDocStavke> getUtrosakDocStavke(UtrosakDoc utrosakDoc) {
        Query query = null;
        query = this.base.createQuery("SELECT uds FROM UtrosakDocStavke uds WHERE uds.utrosakDoc = :ud");
        query.setParameter("ud", (Object)utrosakDoc);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<UtrosakDocUtrosak> getUtrosakDocUtrosak(UtrosakDoc utrosakDoc) {
        Query query = null;
        query = this.base.createQuery("SELECT uds FROM UtrosakDocUtrosak uds WHERE uds.utrosakDoc = :ud");
        query.setParameter("ud", (Object)utrosakDoc);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<UtrosakDocStavke> getUtrosakDocStavke(Date datumOd, Date datumDo, Artikal art, boolean belo, boolean crno) {
        Query query = null;
        if (belo && !crno) {
            query = this.base.createQuery("SELECT uds FROM UtrosakDocStavke uds WHERE (uds.utrosakDoc.crno = :crno AND uds.utrosakDoc.datum between :d1 and :d2) and uds.artikal = :a");
        } else if (!belo && crno) {
            query = this.base.createQuery("SELECT uds FROM UtrosakDocStavke uds WHERE (uds.utrosakDoc.crno = :crno AND uds.utrosakDoc.datum between :d1 and :d2) and uds.artikal = :a");
        } else if (belo && crno) {
            query = this.base.createQuery("SELECT uds FROM UtrosakDocStavke uds WHERE (uds.utrosakDoc.datum between :d1 and :d2) and uds.artikal = :a");
        }
        if (crno) {
            query.setParameter("crno", (Object)Boolean.TRUE);
        } else {
            query.setParameter("crno", (Object)Boolean.FALSE);
        }
        query.setParameter("d1", (Object)datumOd);
        query.setParameter("d2", (Object)datumDo);
        query.setParameter("a", (Object)art);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<StavkaRacuna> getStavke(Date datumOd, Date datumDo, Artikal art, boolean belo, boolean crno) {
        Query query = null;
        if (belo && !crno) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.crnoPlacanje = :null AND sr.racun.datum between :d1 and :d2) and sr.artikal = :a");
        } else if (!belo && crno) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun.crnoPlacanje is not null AND sr.racun.datum between :d1 and :d2 and sr.artikal = :a");
        } else if (belo && crno) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.racun.datum between :d1 and :d2) and sr.artikal = :a");
        }
        query.setParameter("d1", (Object)datumOd);
        query.setParameter("d2", (Object)datumDo);
        query.setParameter("a", (Object)art);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<StavkaRacuna> getStavke(long racunId) {
        String select = "SELECT sr.* FROM stavkaracuna sr WHERE sr.RACUN_ID = " + racunId + " ";
        LinkedList<StavkaRacuna> lista = new LinkedList<StavkaRacuna>();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(select);
            rs = ps.executeQuery();
            while (rs.next()) {
                StavkaRacuna sr = new StavkaRacuna();
                String ime = rs.getString("naziv");
                if (ime.startsWith("*")) {
                    ime = ime.substring(2);
                }
                Artikal a = this.getArtikal(rs.getLong("ARTIKAL_ID"));
                sr.setId(rs.getLong("id"));
                sr.setArtikal(a);
                sr.setNaziv(rs.getString("naziv"));
                sr.setCena(rs.getDouble("cena"));
                sr.setKolicina(rs.getDouble("kolicina"));
                sr.setBrojStola(rs.getInt("brojStola"));
                lista.add(sr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return lista;
    }

    public List<StavkaRacuna> getStavke(int sto) {
        Query query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.brojStola = :sto AND sr.racun IS NULL");
        query.setParameter("sto", (Object)sto);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke(Racun racun) {
        Query query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.racun = :racun");
        query.setParameter("racun", (Object)racun);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavke(Tura tura) {
        Query query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.tura = :tura");
        query.setParameter("tura", (Object)tura);
        return query.getResultList();
    }

    public List<StavkaRacuna> getStavkekonobari(Date d1, Date d2, Odeljenje o, Konobar k) {
        Query query = null;
        if (o == null && k == null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE (sr.tura.datum BETWEEN :d1 AND :d2 AND sr.racun = :null)");
        }
        if (o != null && k == null) {
            query = this.base.createQuery("SELECT DISTINCT sr FROM StavkaRacuna sr WHERE sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o ) AND sr.tura.datum BETWEEN :d1 AND :d2");
            query.setParameter("o", (Object)o);
        }
        if (o == null && k != null) {
            query = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE ((sr.brojStola in (SELECT s.broj FROM Sto s WHERE s.konobar=:k)) AND sr.tura.datum BETWEEN :d1 AND :d2 AND sr.racun = :null)");
            query.setParameter("k", (Object)k);
        } else {
            query = this.base.createQuery("SELECT DISTINCT sr FROM StavkaRacuna sr WHERE(( sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o =:o )AND (sr.brojStola in (SELECT s.broj FROM Sto s WHERE s.konobar=:k))) AND sr.tura.datum BETWEEN :d1 AND :d2)");
            query.setParameter("o", (Object)o);
            query.setParameter("k", (Object)k);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        return query.getResultList();
    }

    public List<Storno> getStorna(Date d1, Date d2, Artikal a, Konobar k) {
        Query query = null;
        if (a == null && k == null) {
            query = this.base.createNativeQuery("SELECT * FROM Storno s WHERE Date(s.datum) BETWEEN ? AND ?", Storno.class);
            query.setParameter(1, (Object)d1);
            query.setParameter(2, (Object)d2);
        }
        if (a != null && k == null) {
            query = this.base.createQuery("SELECT DISTINCT sa.storno FROM StornoStavka sa WHERE (sa.artikal = :a AND sa.storno.datum BETWEEN :d1 AND :d2)");
            query.setParameter("a", (Object)a);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        if (a == null && k != null) {
            query = this.base.createQuery("SELECT DISTINCT sa.storno FROM StornoStavka sa WHERE (sa.storno.konobar=:k AND sa.storno.datum BETWEEN :d1 AND :d2)");
            query.setParameter("k", (Object)k);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        if (a != null && k != null) {
            query = this.base.createQuery("SELECT DISTINCT sa.storno FROM StornoStavka sa WHERE(sa.storno.konobar=:k AND (sa.artikal = :a AND sa.storno.datum BETWEEN :d1 AND :d2))");
            query.setParameter("a", (Object)a);
            query.setParameter("k", (Object)k);
            query.setParameter("d1", (Object)d1);
            query.setParameter("d2", (Object)d2);
        }
        return query.getResultList();
    }

    public List<PrometArtikala> getPrometArtikala(Date d1, Date d2, Odeljenje o) {
        Query query = null;
        if (o == null) {
            query = this.base.createQuery("SELECT new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE sr.tura.datum BETWEEN :d1 AND :d2 GROUP BY sr.artikal");
        } else {
            query = this.base.createQuery("SELECT new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o=:o) AND sr.tura.datum BETWEEN :d1 AND :d2)  GROUP BY sr.artikal");
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<PrometArtikala> getPrometArtikalaKonobari(Date d1, Date d2, Odeljenje o, Konobar k) {
        Query query = null;
        if (o == null && k == null) {
            query = this.base.createQuery("SELECT new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE sr.tura.datum BETWEEN :d1 AND :d2 GROUP BY sr.artikal");
        }
        if (o != null && k == null) {
            query = this.base.createQuery("SELECT  new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE (sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o = :o) AND sr.tura.datum BETWEEN :d1 AND :d2)  GROUP BY sr.artikal");
            query.setParameter("o", (Object)o);
        }
        if (o == null && k != null) {
            query = this.base.createQuery("SELECT  new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE (((sr.brojStola in (SELECT s.broj FROM Sto s WHERE s.konobar=:k)) OR sr.racun.konobar=:k)AND sr.tura.datum BETWEEN :d1 AND :d2) GROUP BY sr.artikal");
            query.setParameter("k", (Object)k);
        } else {
            query = this.base.createQuery("SELECT  new PrometArtikala(sr.artikal, sum(sr.kolicina)) FROM StavkaRacuna sr WHERE ((sr.artikal in (SELECT o.artikli FROM Odeljenje o WHERE o = :o) AND sr.tura.datum BETWEEN :d1 AND :d2) AND ((sr.brojStola in (SELECT s.broj FROM Sto s WHERE s.konobar=:k)) OR sr.racun.konobar=:k))GROUP BY sr.artikal");
            query.setParameter("k", (Object)k);
            query.setParameter("o", (Object)o);
        }
        query.setParameter("d1", (Object)d1);
        query.setParameter("d2", (Object)d2);
        try {
            return query.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<PregledStolova> getStolove(Date day1, Date day2) {
        Query query = this.base.createQuery("SELECT new PregledStolova(r.brojStola,count(r)) FROM Racun r WHERE (r.datum BETWEEN :d1 AND :d2) GROUP BY r.brojStola");
        query.setParameter("d1", (Object)day1);
        query.setParameter("d2", (Object)day2);
        return query.getResultList();
    }

    public List<Racun> getRacuneAfterDateJPA(long zdBroj) {
        Query query = this.base.createQuery("SELECT r FROM Racun r WHERE r.zdBroj >= :zdBroj");
        query.setParameter("zdBroj", (Object)zdBroj);
        return query.getResultList();
    }

    public List<Racun> getRacuneAfterDate(long zdBroj) {
        LinkedList<Racun> lista = new LinkedList<Racun>();
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("SELECT * FROM racun r WHERE r.zdBroj >= ?");
            pStatement.setLong(1, zdBroj);
            ResultSet rs = pStatement.executeQuery();
            while (rs.next()) {
                Racun r = new Racun();
                r.setId(rs.getLong("id"));
                r.setDatum(rs.getDate("datum"));
                r.setCrnoPlacanje(rs.getString("crnoPlacanje"));
                r.setKonobar(this.getKonobar(rs.getLong("KONOBAR_ID")));
                r.setBrojStola(rs.getInt("brojStola"));
                r.setStavke1(this.getStavke(r.getId()));
                r.setPopust(rs.getDouble("popust"));
                r.setKasa(this.getKasa(rs.getLong("KASA_ID")));
                r.setZdBroj(rs.getLong("zdBroj"));
                lista.add(r);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return lista;
    }

    public List<Racun> getSviRacuniPosleDatuma(long zdBroj) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList<Racun> lista = new LinkedList<Racun>();
        String update = "SELECT r.id FROM racun r WHERE r.zdBroj >= " + zdBroj;
        try {
            stmt = conn.createStatement();
            System.out.println(update);
            ResultSet rs = stmt.executeQuery(update);
            while (rs.next()) {
                System.out.println("rs.getLong(\"id\")" + rs.getLong("id"));
                Racun racun = this.getRacuneBzID(rs.getLong("id"));
                System.out.println(racun);
                lista.add(racun);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return lista;
    }

    public List<Racun> getRacune(Integer bs) {
        Query query = this.base.createQuery("SELECT r FROM Racun r WHERE r.brojStola = :bs");
        query.setParameter("bs", (Object)bs);
        return query.getResultList();
    }

    public Racun getRacuneBzID(long id) {
        Query query = this.base.createQuery("SELECT r FROM Racun r WHERE r.id = :id");
        query.setParameter("id", (Object)id);
        return (Racun)query.getSingleResult();
    }

    public List<Placanje> getPlacanja(Racun racun) {
        Query query = this.base.createQuery("SELECT p FROM Placanje p WHERE p.racun = :racun");
        query.setParameter("racun", (Object)racun);
        return query.getResultList();
    }

    public List<Placanje> getPlacanja(long racunId) {
        LinkedList<Placanje> pl = new LinkedList<Placanje>();
        String select = "SELECT p.* FROM placanje p WHERE p.RACUN_ID = " + racunId + " ";
        LinkedList lista = new LinkedList();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(select);
            rs = ps.executeQuery();
            while (rs.next()) {
                NacinPlacanja n = NacinPlacanja.findByName(rs.getString("nacin"));
                Placanje p = new Placanje();
                p.setId(rs.getLong("id"));
                p.setIznos(rs.getDouble("iznos"));
                p.setNacin(n);
                p.setVreme(rs.getTimestamp("vreme"));
                pl.add(p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pl;
    }

    public List<Sifra> getSifre() {
        Query query = this.base.createQuery("SELECT s FROM Sifra s");
        return query.getResultList();
    }

    public void addsifra(Sifra l) {
        this.base.getTransaction().begin();
        this.base.persist((Object)l);
        this.base.getTransaction().commit();
    }

    public void updateSifra(Sifra l) {
        this.base.getTransaction().begin();
        this.base.merge((Object)l);
        this.base.getTransaction().commit();
    }

    public Sifra deleteSifra(Sifra grupa) {
        this.base.getTransaction().begin();
        Sifra ga = (Sifra)this.base.find(Sifra.class, (Object)grupa.getId());
        this.base.remove((Object)ga);
        this.base.getTransaction().commit();
        return grupa;
    }

    public Sifra getSifra(String sifra) {
        Sifra s = null;
        try {
            Long sifraId = this.getSifraIdBySifraJPA(sifra);
            if (sifraId != null) {
                s = (Sifra)this.base.find(Sifra.class, (Object)sifraId);
            }
        }
        catch (Exception e) {
            return null;
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSifraIdBySifra(String sifra) {
        Integer sifraId = null;
        Connection conn = this.getConnection();
        ResultSet rs = null;
        Statement tempStmt = null;
        String selectString = "SELECT id FROM sifra s WHERE s.sifra = '" + sifra + "'";
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            sifraId = rs.getInt(1);
            rs.close();
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
        }
        return sifraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSifraIdBySifraJPA(String sifra) {
        Long id = null;
        try {
            Query q = this.base.createQuery("SELECT s.id FROM Sifra s WHERE s.sifra = :kod");
            q.setParameter("kod", (Object)sifra);
            q.setMaxResults(1);
            id = (Long)q.getSingleResult();
            return id;
        }
        catch (NoResultException q) {}
        catch (Exception e) {
            e.printStackTrace(System.out);
            Logger.getLogger(RestoranServer.class.getName()).log(Level.INFO, "Nije pronadjena sifra sa sifrom " + sifra, e);
        }
        finally {
            return id;
        }
    }

    public List<LogRecord> dnevnikZaDan(Date day) {
        Query query = this.base.createQuery("SELECT o FROM LogRecord o WHERE o.dan = :dan ORDER BY o.vreme DESC");
        query.setParameter("dan", (Object)day);
        return query.getResultList();
    }

    public List<CenovnikDetalji> getCenovnikStavkeByCenovniciId(Cenovnici c) {
        Query query = this.base.createQuery("SELECT cd FROM CenovnikDetalji cd WHERE cd.cenovnici = :c");
        query.setParameter("c", (Object)c);
        return query.getResultList();
    }

    public List<LogRecord> dnevnikZaDane(Date day, Date day2) {
        Query query = this.base.createQuery("SELECT o FROM LogRecord o WHERE o.dan BETWEEN :dan AND :dan2 ORDER BY o.dan,o.vreme DESC");
        query.setParameter("dan", (Object)day);
        query.setParameter("dan2", (Object)day2);
        return query.getResultList();
    }

    public void fine(String message) {
        this.fine(message, null);
    }

    public void fine(String message, Class<?> tag) {
        this.writeRecord(tag, message, Level.FINE.getName());
    }

    public void config(String message) {
        this.fine(message, null);
    }

    public void config(String message, Class<?> tag) {
        this.writeRecord(tag, message, Level.FINE.getName());
    }

    public void info(String message) {
        this.fine(message, null);
    }

    public void info(String message, Class<?> tag) {
        this.writeRecord(tag, message, Level.FINE.getName());
    }

    public void warning(String message) {
        this.fine(message, null);
    }

    public void warning(String message, Class<?> tag) {
        this.writeRecord(tag, message, Level.FINE.getName());
    }

    private void writeRecord(Class<?> tag, String message, String level) {
        LogRecord rec = new LogRecord();
        rec.setMessage(message);
        rec.setLogLevel(level);
        Date time = new Date();
        if (tag != null) {
            rec.setTag(tag.getSimpleName());
        }
        this.base.persist((Object)rec);
    }

    void proveriKonekciju(Statement stmt, Connection con, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RestoranServer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void deleteCenovnik(Cenovnik c) {
        this.base.getTransaction().begin();
        this.base.remove((Object)c);
        this.base.getTransaction().commit();
    }

    public void deleteCenovnici(Cenovnici c) {
        this.deleteCenovnikDetalji(c);
        this.deleteCenovniciStavke(c);
        this.base.getTransaction().begin();
        this.base.remove((Object)c);
        this.base.getTransaction().commit();
    }

    public void addCenovnik(Cenovnik c) {
        this.base.getTransaction().begin();
        this.base.persist((Object)c);
        this.base.getTransaction().commit();
    }

    public void updateCenovnik(Cenovnik c) {
        this.base.getTransaction().begin();
        this.base.merge((Object)c);
        this.base.getTransaction().commit();
    }

    public void updateCenovnici(Cenovnici c) {
        this.base.getTransaction().begin();
        this.base.merge((Object)c);
        this.base.getTransaction().commit();
    }

    public void updateCenovnikDetalji(CenovnikDetalji c) {
        this.base.getTransaction().begin();
        this.base.merge((Object)c);
        this.base.getTransaction().commit();
    }

    public void addCenovnikStavka(CenovnikStavka cs) {
        this.base.getTransaction().begin();
        this.base.persist((Object)cs);
        this.base.getTransaction().commit();
    }

    public void addCenovniciStavka(CenovniciStavka cs) {
        this.base.getTransaction().begin();
        this.base.persist((Object)cs);
        this.base.getTransaction().commit();
    }

    public void addCenovnikDetalji(CenovnikDetalji cd) {
        this.base.getTransaction().begin();
        this.base.persist((Object)cd);
        this.base.getTransaction().commit();
    }

    public void addGlavniMeniLogin(GlavniMeniLogin glavniMeniLogin) {
        this.base.getTransaction().begin();
        this.base.persist((Object)glavniMeniLogin);
        this.base.getTransaction().commit();
    }

    public void addGlavniMeniPodgrupaLogin(GlavniMeniPodgrupaLogin glavniMeniPodgrupaLogin) {
        this.base.getTransaction().begin();
        this.base.persist((Object)glavniMeniPodgrupaLogin);
        this.base.getTransaction().commit();
    }

    public CenovnikStavka getArtikalCenovnik(Artikal a, Cenovnik c) {
        Query q = this.base.createQuery("SELECT cs FROM CenovnikStavka cs WHERE cs.cenovnik = :c AND cs.artikal = :a ");
        q.setParameter("a", (Object)a);
        q.setParameter("c", (Object)c);
        return (CenovnikStavka)q.getSingleResult();
    }

    public void deleteCenovnikStavke(Cenovnik c) {
        List<CenovnikStavka> lista = this.getCenovnikStavke(c);
        this.base.getTransaction().begin();
        ListIterator<CenovnikStavka> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            CenovnikStavka cs = liStavke.next();
            this.base.remove((Object)cs);
        }
        this.base.getTransaction().commit();
    }

    public void deleteCenovnikDetalji(Cenovnici c) {
        List<CenovnikDetalji> lista = this.getCenovnikDetalji(c);
        this.base.getTransaction().begin();
        ListIterator<CenovnikDetalji> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            CenovnikDetalji cs = liStavke.next();
            this.base.remove((Object)cs);
        }
        this.base.getTransaction().commit();
    }

    public void brisanjeGlavnogMenijaByLogin(long id) {
        List<GlavniMeniLogin> lista = this.readGlavniMeniLoginByLoginId(id);
        this.base.getTransaction().begin();
        ListIterator<GlavniMeniLogin> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            GlavniMeniLogin glavniMeniLogin = liStavke.next();
            this.base.remove((Object)glavniMeniLogin);
        }
        this.base.getTransaction().commit();
    }

    public void brisanjeGlavnogMenijaPodgrupaByLogin(long id) {
        List<GlavniMeniPodgrupaLogin> lista = this.readGlavniMeniPodgrupaLoginByLoginId(id);
        this.base.getTransaction().begin();
        ListIterator<GlavniMeniPodgrupaLogin> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            GlavniMeniPodgrupaLogin glavniMeniPodgrupaLogin = liStavke.next();
            this.base.remove((Object)glavniMeniPodgrupaLogin);
        }
        this.base.getTransaction().commit();
    }

    public void deleteCenovnikStavke(Cenovnici c) {
        List<CenovnikStavka> lista = this.getCenovnikStavke(c);
        this.base.getTransaction().begin();
        ListIterator<CenovnikStavka> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            CenovnikStavka cs = liStavke.next();
            this.base.remove((Object)cs);
        }
        this.base.getTransaction().commit();
    }

    public void deleteCenovniciStavke(Cenovnici c) {
        List<CenovniciStavka> lista = this.getCenovniciStavke(c);
        this.base.getTransaction().begin();
        ListIterator<CenovniciStavka> liStavke = lista.listIterator();
        while (liStavke.hasNext()) {
            CenovniciStavka cs = liStavke.next();
            this.base.remove((Object)cs);
        }
        this.base.getTransaction().commit();
    }

    public List<CenovnikStavka> getCenovnikStavke(Cenovnik c) {
        Query q = this.base.createQuery("SELECT cs FROM CenovnikStavka cs WHERE cs.cenovnik = :c");
        q.setParameter("c", (Object)c);
        return q.getResultList();
    }

    public List<CenovnikDetalji> getCenovnikDetalji(Cenovnici c) {
        Query q = this.base.createQuery("SELECT cd FROM CenovnikDetalji cd WHERE cd.cenovnici = :c");
        q.setParameter("c", (Object)c);
        return q.getResultList();
    }

    public List<CenovnikStavka> getCenovnikStavke(Cenovnici c) {
        Query q = this.base.createQuery("SELECT cs FROM CenovnikStavka cs WHERE cs.cenovnici = :c");
        q.setParameter("c", (Object)c);
        return q.getResultList();
    }

    public List<CenovniciStavka> getCenovniciStavke(Cenovnici c) {
        Query q = this.base.createQuery("SELECT cs FROM CenovniciStavka cs JOIN cs.artikal a WHERE cs.cenovnici = :c ORDER BY a.name");
        q.setParameter("c", (Object)c);
        return q.getResultList();
    }

    public CenovniciStavka getCenovniciStavka(Artikal a, Cenovnici c) {
        Query q = this.base.createQuery("SELECT cs FROM CenovniciStavka cs JOIN cs.artikal a WHERE cs.cenovnici = :c AND cs.artikal = :a");
        q.setParameter("c", (Object)c);
        q.setParameter("a", (Object)a);
        return (CenovniciStavka)q.getSingleResult();
    }

    public List<Cenovnik> readCenovniciActiv() {
        Query q = this.base.createQuery("SELECT c FROM Cenovnik c WHERE c.aktivan = :aktivan");
        q.setParameter("aktivan", (Object)Boolean.TRUE);
        return q.getResultList();
    }

    public List<Cenovnici> readCenovniciActive() {
        Query q = this.base.createQuery("SELECT c FROM Cenovnici c WHERE c.aktivan = :aktivan ORDER BY c.cenovnikTip");
        q.setParameter("aktivan", (Object)Boolean.TRUE);
        return q.getResultList();
    }

    public Cenovnik readCenovnikByName(String naziv) {
        Query q = this.base.createQuery("SELECT c FROM Cenovnik c WHERE c.naziv = :naziv ");
        q.setParameter("naziv", (Object)naziv);
        return (Cenovnik)q.getSingleResult();
    }

    public List<Cenovnici> readCenovnici() {
        Query q = this.base.createQuery("SELECT c FROM Cenovnici c ");
        return q.getResultList();
    }

    public void loadCene(Artikal artikal) {
        Query q = this.base.createQuery("SELECT c FROM Cena c WHERE c.artikal = :artikal");
        q.setParameter("artikal", (Object)artikal);
        artikal.setCenovnici(q.getResultList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cena> readCene(Artikal artikal) {
        ArrayList<Cena> cene = new ArrayList<Cena>();
        Connection conn = this.getConnection();
        ResultSet rs = null;
        Statement tempStmt = null;
        String selectString = "SELECT * FROM Cena JOIN Cenovnik ON Cena.cenovnikId = Cenovnik.id WHERE Cena.artikalId = " + artikal.getId() + ";";
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                Cena cena = new Cena();
                cena.setArtikalId(rs.getLong(1));
                cena.setArtikal(artikal);
                cena.setCenovnikId(rs.getLong(2));
                cena.setCena(rs.getDouble(3));
                Cenovnik cenovnik = new Cenovnik();
                cenovnik.setId(rs.getLong(4));
                cenovnik.setNaziv(rs.getString(5));
                cenovnik.setAktivan(rs.getBoolean(8));
                cenovnik.setDatumUnosa(rs.getDate(11));
                cenovnik.setMinDo(rs.getInt(12));
                cenovnik.setMinOd(rs.getInt(13));
                cenovnik.setSatDo(rs.getInt(14));
                cenovnik.setSatOd(rs.getInt(15));
                cena.setCenovnik(cenovnik);
                cene.add(cena);
            }
            rs.close();
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
        }
        return cene;
    }

    public List<StavkaPopisa> readStavkePopisa(Popis popis) {
        Query query = this.base.createQuery("SELECT sp FROM StavkaPopisa sp WHERE sp.popis = :popis");
        query.setParameter("popis", (Object)popis);
        return query.getResultList();
    }

    public List<StavkaRacuna> readNenaplaceneStavkeKonobara(List<Integer> stolovi) {
        String selectString = "SELECT sr FROM StavkaRacuna sr WHERE sr.racun IS NULL AND sr.brojStola IN :stolovi";
        Query query = this.base.createQuery(selectString);
        query.setParameter("stolovi", stolovi);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKonobarNameByBrojStola(Integer brojStola) {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        ResultSet rs = null;
        String konobarName = null;
        String selectString = "select skrIme from konobar where id = (select konobar_id from sto where broj = " + brojStola + ")";
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                konobarName = rs.getString(1);
            }
            rs.close();
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
        }
        return konobarName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getKonobarIDByBrojStola(Integer brojStola) {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        ResultSet rs = null;
        Long konobarId = null;
        String selectString = "select id from konobar where id = (select konobar_id from sto where broj = " + brojStola + ")";
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            while (rs.next()) {
                konobarId = rs.getLong(1);
            }
            rs.close();
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
        }
        return konobarId;
    }

    public void flush() {
        this.base.getTransaction().begin();
        this.base.flush();
        this.base.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getNenaplaceniIznos(Konobar k) {
        Connection conn = this.getConnection();
        Statement tempStmt = null;
        ResultSet rs = null;
        Double iznos = 0.0;
        String selectString = k == null || k.getId() == null ? "select sum(cena * kolicina) from stavkaracuna where racun_id is null;" : "select sum(cena * kolicina) from stavkaracuna where racun_id is null and brojStola in (select broj from sto where konobar_id = " + k.getId() + ");";
        try {
            tempStmt = conn.createStatement();
            rs = tempStmt.executeQuery(selectString);
            if (!rs.isClosed()) {
                iznos = rs.first() ? Double.valueOf(rs.getDouble(1)) : Double.valueOf(0.0);
                rs.close();
            }
            tempStmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
            return iznos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getNenaplaceniIznosBMaster(Konobar k, long zdOd, long zdDo) {
        Connection conn = this.getConnection();
        PreparedStatement tempStmt = null;
        ResultSet rs = null;
        Double iznos = 0.0;
        String selectString = k == null || k.getId() == null ? "select  SUM(sr.cena * sr.kolicina) AS ukupno FROM  stavkaracuna sr\r\nJOIN racun r ON sr.RACUN_ID = r.id\r\nWHERE r.zatvoren = 0;" : "select  SUM(sr.cena * sr.kolicina) AS ukupno FROM  stavkaracuna sr\r\nJOIN racun r ON sr.RACUN_ID = r.id \r\nWHERE r.zatvoren = 0 AND r.KONOBAR_ID = ?\r\nAND r.zdBroj BETWEEN ? AND ?";
        try {
            tempStmt = conn.prepareStatement(selectString);
            tempStmt.setLong(1, k.getId());
            tempStmt.setLong(2, zdOd);
            tempStmt.setLong(3, zdDo);
            rs = tempStmt.executeQuery();
            if (!rs.isClosed()) {
                iznos = rs.first() ? Double.valueOf(rs.getDouble(1)) : Double.valueOf(0.0);
                rs.close();
            }
            tempStmt.close();
            conn.close();
            this.proveriKonekciju(tempStmt, conn, rs);
            return iznos;
        }
        catch (SQLException ex) {
            try {
                System.err.println("SQLException: " + ex.getMessage());
            }
            catch (Throwable throwable) {}
        }
        finally {
            this.proveriKonekciju(tempStmt, conn, rs);
            return iznos;
        }
    }

    public void updateRacunaNPJPA(Racun r) {
        this.base.getTransaction().begin();
        List<Placanje> pList = r.getPlacanja();
        r.setPlacanja(new LinkedList<Placanje>());
        r = (Racun)this.base.merge((Object)r);
        for (Placanje p : pList) {
            p.setRacun(r);
            this.base.persist((Object)p);
            r.getPlacanja().add(p);
        }
        r = (Racun)this.base.merge((Object)r);
        this.base.getTransaction().commit();
    }

    public void deletePrijemnicaJPA(Prijemnica p) throws Exception {
        TypedQuery qk = this.base.createQuery("SELECT k FROM Kartica k WHERE k.dokument = :oznakaDokumenta", Kartica.class).setParameter("oznakaDokumenta", (Object)(p.getBrPrijemnice() + " (p)"));
        TypedQuery qps = this.base.createQuery("SELECT ps FROM PrijemnicaStavka ps WHERE ps.prijemnica = :prijemnica", PrijemnicaStavka.class).setParameter("prijemnica", (Object)p);
        TypedQuery qds = this.base.createQuery("SELECT ds FROM DnevnoStanje ds WHERE ds.artikalID = :artikalID and ds.datum = :datum", DnevnoStanje.class).setMaxResults(1);
        this.base.getTransaction().begin();
        try {
            List list = qk.getResultList();
            for (Kartica k : list) {
                this.base.remove((Object)k);
            }
            boolean retroaktivno = p.getDatumPrijemnice().before(Konstante.getOnlyDate(this.getPoslednjiPocetni()));
            for (PrijemnicaStavka ps : p.getStavke()) {
                if (retroaktivno) {
                    try {
                        DnevnoStanje ds = (DnevnoStanje)qds.setParameter("artikalID", (Object)ps.getArtikal().getId()).setParameter("datum", (Object)p.getDatumPrijemnice()).getSingleResult();
                        if (p.getCrno().booleanValue()) {
                            ds.setCrnoUlaz(ds.getCrnoUlaz() - ps.getKolicina());
                        } else {
                            ds.setBeloUlaz(ds.getBeloUlaz());
                        }
                        this.base.merge((Object)ds);
                    }
                    catch (NoResultException noResultException) {
                        // empty catch block
                    }
                }
                this.base.remove((Object)ps);
            }
            this.base.flush();
            this.base.remove((Object)p);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            e.printStackTrace(System.out);
            this.warning("Do\u0161lo je do gre\u0161ke prilikom brisanja prijemnice sa brojem " + p.getBrPrijemnice());
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom brisanja prijemnice sa brojem " + p.getBrPrijemnice(), e);
        }
    }

    public void deleteTrebovanjeJPA(Trebovanje t) throws Exception {
        TypedQuery qk = this.base.createQuery("SELECT k FROM Kartica k WHERE k.dokument = :oznakaDokumenta", Kartica.class).setParameter("oznakaDokumenta", (Object)(t.getBrTrebovanja() + " (tk)"));
        TypedQuery qts = this.base.createQuery("SELECT ts FROM TrebovanjeStavka ts WHERE ts.trebovanje = :trebovanje", TrebovanjeStavka.class).setParameter("trebovanje", (Object)t);
        TypedQuery qds = this.base.createQuery("SELECT ds FROM DnevnoStanje ds WHERE ds.artikalID = :artikalID and ds.datum = :datum", DnevnoStanje.class).setMaxResults(1);
        while (this.base.getTransaction().isActive()) {
        }
        this.base.getTransaction().begin();
        try {
            List list = qk.getResultList();
            for (Kartica k : list) {
                this.base.remove((Object)k);
            }
            boolean retroaktivno = t.getDatumTrebovanja().before(Konstante.getOnlyDate(this.getPoslednjiPocetni()));
            List lts = qts.getResultList();
            for (TrebovanjeStavka ts : lts) {
                if (retroaktivno) {
                    try {
                        DnevnoStanje ds = (DnevnoStanje)qds.setParameter("artikalID", (Object)ts.getArtikal().getId()).setParameter("datum", (Object)t.getDatumTrebovanja()).getSingleResult();
                        if (t.getCrno().booleanValue()) {
                            ds.setCrnoUlaz(ds.getCrnoUlaz() - ts.getKolicina());
                        } else {
                            ds.setBeloUlaz(ds.getBeloUlaz());
                        }
                        this.base.merge((Object)ds);
                    }
                    catch (NoResultException noResultException) {
                        // empty catch block
                    }
                }
                this.base.remove((Object)ts);
            }
            this.base.flush();
            this.base.remove((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            this.warning("Do\u0161lo je do gre\u0161ke prilikom brisanja trebovanja sa brojem " + t.getBrTrebovanja());
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom brisanja trebovanja sa brojem " + t.getBrTrebovanja(), e);
        }
    }

    public List<Prijemnica> readPrijemniceDobavljac(String dobavljac) throws Exception {
        TypedQuery q = this.base.createQuery("SELECT p FROM Prijemnica p WHERE p.dobavljac.naziv = :dobavljac ORDER BY p.datumPrijemnice", Prijemnica.class);
        q = q.setParameter("dobavljac", (Object)dobavljac);
        try {
            return q.getResultList();
        }
        catch (Exception e) {
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja prijemnica po dobavlja\u010du " + dobavljac, e);
        }
    }

    public List<Trebovanje> readTrebovanjaDir(Odeljenje o2) throws Exception {
        TypedQuery q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE (t.u=:o2) ORDER BY t.datumTrebovanja", Trebovanje.class);
        try {
            q.setParameter("o2", (Object)o2);
            return q.getResultList();
        }
        catch (Exception e) {
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja trebovanja direktno iz magacina", e);
        }
    }

    public List<Trebovanje> readTrebovanjaDobavljac(Odeljenje iz, Odeljenje u, StalniGost d) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE (t.u=:u  and t.dobavljac = :d and t.iz = :iz) ORDER BY t.datumTrebovanja");
        q.setParameter("u", (Object)u);
        q.setParameter("iz", (Object)iz);
        q.setParameter("d", (Object)d);
        return q.getResultList();
    }

    public List<Trebovanje> readTrebovanja(Odeljenje iz, Odeljenje u) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE (t.u=:u  and t.iz = :iz) ORDER BY t.datumTrebovanja");
        q.setParameter("u", (Object)u);
        q.setParameter("iz", (Object)iz);
        return q.getResultList();
    }

    public Trebovanje getTrebovanjeByID(long id) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE t.id = :id");
        q.setParameter("id", (Object)id);
        return (Trebovanje)q.getSingleResult();
    }

    public void unosPorudzbine(Sto sto, Tura tura, List<StavkaRacuna> stavke) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        while (trans.isActive()) {
        }
        try {
            trans.begin();
            if (sto != null) {
                this.base.persist((Object)sto);
            }
            this.base.persist((Object)tura);
            for (StavkaRacuna sr : stavke) {
                this.base.persist((Object)sr);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom unosa porud\u017ebine!", e);
        }
    }

    public boolean unosRacuna(Racun racun, List<Placanje> placanja) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        TypedQuery qt = em.createQuery("SELECT t FROM Tura t WHERE t.brojStola = :bs and t.racun is null", Tura.class);
        qt.setParameter("bs", (Object)racun.getBrojStola());
        List lt = qt.getResultList();
        try {
            trans.begin();
            List<Object> pList = racun.getPlacanja() == null ? new LinkedList() : racun.getPlacanja();
            racun.setPlacanja(new LinkedList<Placanje>());
            racun.setStavke1(new LinkedList<StavkaRacuna>());
            racun.setTure(new LinkedList<Tura>());
            if (racun.getMeniPromet() != null) {
                if (racun.getMeniPromet().getMeni().getId() != null) {
                    Meni m = (Meni)em.find(Meni.class, (Object)racun.getMeniPromet().getMeni().getId());
                    racun.getMeniPromet().setMeni(m);
                }
                racun.getMeniPromet().setDatum(racun.getDatum());
                racun.getMeniPromet().setRacun(racun);
            }
            log.info("Upisivanje racuna " + racun);
            Konobar k = racun.getKonobar();
            k = (Konobar)em.find(Konobar.class, (Object)k.getId());
            if (k == null) {
                throw new Exception("Doslo je do greske prilikom unosa racuna, podatak o konobaru je prazan na racunu!!!");
            }
            racun.setKonobar(k);
            if (racun.getStalniGost() != null) {
                StalniGost sg = racun.getStalniGost();
                if ((sg = (StalniGost)em.find(StalniGost.class, (Object)sg.getId())) == null) {
                    throw new Exception("Doslo je do greske prilikom unosa racuna, podatak o stalnom gostu je prazan na racunu iako je definisan sa id-em = " + racun.getStalniGost().getId() + " !!!");
                }
                racun.setStalniGost(sg);
            }
            em.persist((Object)racun);
            log.info("Racun " + racun + " upisan");
            log.info("Azuriranje tura za racun " + racun);
            int updatedT = 0;
            for (Tura tura : lt) {
                ++updatedT;
                em.refresh((Object)tura);
                tura.setRacun(racun);
                tura = (Tura)em.merge((Object)tura);
                log.info("Azuriranje stavki za racun " + racun);
                int n = 0;
                for (StavkaRacuna sr : tura.getStavke()) {
                    if (racun.getPopust() != 0.0 && sr.getArtikal().getDozvoljenPopust().booleanValue()) {
                        sr.setNaziv("* " + sr.getArtikal().getName());
                    }
                    sr.setTura(tura);
                    sr.setRacun(racun);
                    ++n;
                    sr = (StavkaRacuna)em.merge((Object)sr);
                    racun.getStavke1().add(sr);
                    em.persist((Object)sr);
                }
                log.info("Azurirano stavki: " + n);
                racun.getTure().add(tura);
                em.flush();
                em.getEntityManagerFactory().getCache().evictAll();
            }
            log.info("Azurirano tura: " + updatedT);
            if (racun.getMeniPromet() != null) {
                Double meniTotal = racun.getMeniPromet().getTotal();
                racun.setPopust(0.0);
                Double racunTotal = racun.total();
                System.out.println("meniTotal = " + meniTotal);
                System.out.println("racun.total() = " + racun.total());
                Double d2 = meniTotal / racunTotal * 100.0 - 100.0;
                d2 = BigDecimal.valueOf(d2).setScale(6, RoundingMode.HALF_EVEN).doubleValue();
                System.out.println("popust = " + d2);
                racun.setPopust(-d2.doubleValue());
                if (pList.size() > 0 && pList.size() == 1) {
                    ((Placanje)pList.get(0)).setIznos(racun.getMeniPromet().getTotal());
                }
            }
            log.info("Dodavanje placanja");
            int dodatoPL = 0;
            for (Placanje placanje : pList) {
                ++dodatoPL;
                placanje.setRacun(racun);
                placanje.setVreme(new Date());
                em.persist((Object)placanje);
                racun.getPlacanja().add(placanje);
            }
            log.info("Dodato placanja: " + dodatoPL);
            Kasa kkkk = null;
            try {
                if (this.getCurrentCounter() != null && this.getCurrentCounter().getId() != null) {
                    kkkk = (Kasa)em.find(Kasa.class, (Object)this.getCurrentCounter().getId());
                }
                racun.setKasa(kkkk);
            }
            catch (Exception bl) {
                log.log(Level.WARNING, bl.getMessage(), bl);
            }
            racun = (Racun)em.merge((Object)racun);
            trans.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom kreiranja ra\u010duna!!!", e);
        }
        finally {
            em.close();
        }
    }

    public String getNewProcedureQueryStringDeleteAllFromBaseExclArtikal() {
        return Queries.QUERIES.get((Object)QueryName.KREIRANJE_PROCEDURE_DELETE_ALL_EXCL_ARTIKAL);
    }

    public String getNewProcedureQueryStringPoSatima() {
        return Queries.QUERIES.get((Object)QueryName.KREIRANJE_PROCEDURE_ANALIZA_PRODAJE_PO_SATIMA);
    }

    public String getNewProcedureQueryStringPoNedeljama() {
        return Queries.QUERIES.get((Object)QueryName.KREIRANJE_PROCEDURE_ANALIZA_PRODAJE_PO_NEDELJAMA);
    }

    public String getNewProcedureQueryStringKpu_Knjiga() {
        return Queries.QUERIES.get((Object)QueryName.KREIRANJE_PROCEDURE_POSLOVNA_KNJIGA_USLUGA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcedure(String upit) {
        EntityManager em = this.getEM();
        try {
            Query q = em.createNativeQuery("SHOW PROCEDURE STATUS WHERE Db = 'restoran' AND Name = '" + upit + "';");
            boolean bl = !q.getResultList().isEmpty();
            return bl;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void createProcedureDeleteAllFromBaseExclArtikal() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        try {
            Query q = em.createNativeQuery(this.getNewProcedureQueryStringDeleteAllFromBaseExclArtikal());
            q.executeUpdate();
        }
        finally {
            try {
                em.getTransaction().commit();
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void createProcedurePoSatima() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        try {
            Query q = em.createNativeQuery(this.getNewProcedureQueryStringPoSatima());
            q.executeUpdate();
        }
        finally {
            try {
                em.getTransaction().commit();
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void createProcedurePoNedeljama() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        try {
            Query q = em.createNativeQuery(this.getNewProcedureQueryStringPoNedeljama());
            q.executeUpdate();
        }
        finally {
            try {
                em.getTransaction().commit();
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void createProcedureKpu_Knjiga() {
        EntityManager em = this.getEM();
        em.getTransaction().begin();
        try {
            Query q = em.createNativeQuery(this.getNewProcedureQueryStringKpu_Knjiga());
            q.executeUpdate();
        }
        finally {
            try {
                em.getTransaction().commit();
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getAnalizaProdajePoNedeljama(Date datum1, Date datum2, EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap) {
        String procedura = "analiza_prodaje_po_nedeljama";
        LinkedList<Map<String, Object>> ppaArticleData = null;
        EntityManager em = this.getEM();
        if (!this.hasProcedure(procedura)) {
            this.createProcedurePoNedeljama();
        }
        try {
            String pBelap = "";
            String pCrnap = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            StringBuilder qBuilder = new StringBuilder("CALL `" + procedura + "`('" + new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(datum1) + "','" + new SimpleDateFormat("YYYY-MM-dd HH:mm:ss").format(datum2) + "','" + pBelap + "', '" + pCrnap + "')");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            LinkedList<Map<String, Object>> linkedList = ppaArticleData;
            return linkedList;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public List<Konobar> getKonobar_KonobarTarget() {
        Query query = this.base.createQuery("select kt.konobar from KonobarTarget kt GROUP by kt.konobar where kt.konobar.blokiranje = false");
        return query.getResultList();
    }

    public Double getRealizacijaFinansijskogPlana(Date from, Date to, Konobar k) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d1 = this.getPocetni(from);
        Date d2 = this.getKrajnji(to);
        List<Object> list1 = new ArrayList();
        Double rez = 0.0;
        list1 = this.getKonobar_KonobarTarget();
        String query = "select sum(sr.cena * sr.kolicina)as sum from stavkaracuna sr left join racun r on r.id = sr.RACUN_ID left join konobar k on k.id = r.KONOBAR_ID where k.id =" + k.getId() + " and r.datum BETWEEN '" + sdf.format(d1) + "' and '" + sdf.format(d2) + "' ";
        Connection conn = this.getConnection();
        try {
            PreparedStatement ps = conn.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            rs.next();
            rez = rs.getDouble("sum");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rez;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getAnalizaProdajePoDanuUMesecu(String datum, String godina, String datum1, String godina1, EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap) {
        LinkedList<Map<String, Object>> ppaArticleData = null;
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            StringBuilder qBuilder = new StringBuilder("SELECT DAY(r.datum) AS 'Dan',  SUM(sr.cena * sr.kolicina) AS 'Total', COUNT(DISTINCT sr.RACUN_ID) as 'Broj Racuna', ROUND(( SUM(sr.cena * sr.kolicina)/COUNT(DISTINCT sr.RACUN_ID)),2) AS 'Prosecni racun', MONTHNAME(r.datum) AS 'Mesec',  if(MONTH(r.datum)>9,CONCAT(MONTH(r.datum),YEAR(r.datum)),CONCAT('0',MONTH(r.datum),YEAR(r.datum))) AS 'MesecBroj' FROM racun r JOIN stavkaracuna sr ON sr.RACUN_ID = r.id LEFT OUTER JOIN placanje p ON r.id = p.racun_id  WHERE  r.datum BETWEEN ((select max(z.zakljucenje) from zd z where z.pocetak = b'1' and z.datum = DATE(r.datum)))  AND ((select max(z.zakljucenje) from zd z where z.pocetak = b'0' and z.datum = DATE(r.datum))) AND (find_in_set(p.nacin, '" + pBelap + "') OR find_in_set(r.crnoplacanje, '" + pCrnap + "')) AND MONTH(r.datum) = " + datum + " AND YEAR(r.datum) =" + godina + " GROUP BY DAY(r.datum) UNION SELECT DAY(r.datum) AS 'Dan',  SUM(sr.cena * sr.kolicina) AS 'Total', COUNT(DISTINCT sr.RACUN_ID) as 'Broj Racuna', ROUND(( SUM(sr.cena * sr.kolicina)/COUNT(DISTINCT sr.RACUN_ID)),2) AS 'Prosecni racun', MONTHNAME(r.datum) AS 'Mesec',  if(MONTH(r.datum)>9,CONCAT(MONTH(r.datum),YEAR(r.datum)),CONCAT('0',MONTH(r.datum),YEAR(r.datum))) AS 'MesecBroj' FROM racun r JOIN stavkaracuna sr ON sr.RACUN_ID = r.id LEFT OUTER JOIN placanje p ON r.id = p.racun_id  WHERE  r.datum BETWEEN ((select max(z.zakljucenje) from zd z where z.pocetak = b'1' and z.datum = DATE(r.datum)))  AND ((select max(z.zakljucenje) from zd z where z.pocetak = b'0' and z.datum = DATE(r.datum))) AND (find_in_set(p.nacin, '" + pBelap + "') OR find_in_set(r.crnoplacanje, '" + pCrnap + "')) AND MONTH(r.datum) = " + datum1 + " AND YEAR(r.datum) =" + godina1 + " GROUP BY DAY(r.datum)");
            System.out.println(qBuilder.toString());
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            LinkedList<Map<String, Object>> linkedList = ppaArticleData;
            return linkedList;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void makeForcedRacunAndTura(Racun r) throws Exception {
        log.entering(RestoranServer.class.getName(), "makeRacunAndTura");
        EntityTransaction trans = this.base.getTransaction();
        try {
            List<Tura> tList = r.getTure();
            List<StavkaRacuna> srList = r.getStavke1();
            List<Object> pList = r.getPlacanja() == null ? new LinkedList() : r.getPlacanja();
            r.setPlacanja(new LinkedList<Placanje>());
            r.setStavke1(new LinkedList<StavkaRacuna>());
            r.setTure(new LinkedList<Tura>());
            Kasa kasa = this.getCurrentCounter();
            r.setKasa(kasa != null ? (Kasa)this.base.find(Kasa.class, (Object)kasa.getId()) : null);
            trans.begin();
            log.info("persisting " + r.toString());
            this.base.persist((Object)r);
            log.info(r.toString() + " persisted");
            for (Tura tura : tList) {
                srList = tura.getStavke();
                tura.setDatum(new Date());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                tura.setRacun(r);
                log.info("persisting " + tura.toString());
                this.base.merge((Object)tura);
                log.info(tura.toString() + " persisted");
                for (StavkaRacuna sr : srList) {
                    sr.setRacun(r);
                    sr.setTura(tura);
                    log.info("persisting " + sr.toString());
                    this.base.merge((Object)sr);
                    log.info(sr.toString() + " persisted");
                }
            }
            for (Placanje placanje : pList) {
                placanje.setRacun(r);
                log.info("persisting " + placanje.toString());
                this.base.persist((Object)placanje);
                log.info(placanje.toString() + " persisted");
            }
            trans.commit();
            this.base.refresh((Object)r);
            r.getStavke1();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom kreiranja ra\u010duna zajedno sa turom", e);
        }
        log.exiting(RestoranServer.class.getName(), "makeRacunAndTura");
    }

    public void makeRacunAndTura(Racun r) throws Exception {
        log.entering(RestoranServer.class.getName(), "makeRacunAndTura");
        EntityTransaction trans = this.base.getTransaction();
        try {
            List<Object> pList;
            List<Tura> tList = r.getTure();
            List<StavkaRacuna> srList = r.getStavke1();
            List<Object> list = pList = r.getPlacanja() == null ? new LinkedList() : r.getPlacanja();
            if (r.getMeniPromet() != null) {
                if (r.getMeniPromet().getMeni().getId() != null) {
                    Meni m = (Meni)this.base.find(Meni.class, (Object)r.getMeniPromet().getMeni().getId());
                    r.getMeniPromet().setMeni(m);
                }
                r.getMeniPromet().setDatum(r.getDatum());
                r.getMeniPromet().setRacun(r);
            }
            if (r.getMeniPromet() != null) {
                Double meniTotal = r.getMeniPromet().getTotal();
                Double racunTotal = r.total();
                Double d2 = meniTotal / racunTotal * 100.0 - 100.0;
                d2 = BigDecimal.valueOf(d2).setScale(6, RoundingMode.HALF_EVEN).doubleValue();
                System.out.println("popust = " + d2);
                r.setPopust(-d2.doubleValue());
                if (pList.size() > 0 && pList.size() == 1) {
                    ((Placanje)pList.get(0)).setIznos(r.getMeniPromet().getTotal());
                }
            }
            r.setPlacanja(new LinkedList<Placanje>());
            r.setStavke1(new LinkedList<StavkaRacuna>());
            r.setTure(new LinkedList<Tura>());
            Kasa kasa = this.getCurrentCounter();
            r.setKasa(kasa != null ? (Kasa)this.base.find(Kasa.class, (Object)kasa.getId()) : null);
            trans.begin();
            log.info("persisting " + r.toString());
            this.base.persist((Object)r);
            log.info(r.toString() + " persisted");
            for (Tura tura : tList) {
                srList = tura.getStavke();
                tura.setDatum(new Date());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                tura.setRacun(r);
                log.info("persisting " + tura.toString());
                this.base.persist((Object)tura);
                log.info(tura.toString() + " persisted");
                for (StavkaRacuna sr : srList) {
                    sr.setRacun(r);
                    sr.setTura(tura);
                    for (StavkaRacuna stavR : sr.getPodStavke()) {
                        stavR.setRacun(r);
                        stavR.setTura(tura);
                    }
                    log.info("persisting " + sr.toString());
                    this.base.persist((Object)sr);
                    log.info(sr.toString() + " persisted");
                }
            }
            for (Placanje placanje : pList) {
                placanje.setRacun(r);
                log.info("persisting " + placanje.toString());
                this.base.persist((Object)placanje);
                log.info(placanje.toString() + " persisted");
            }
            trans.commit();
            this.base.refresh((Object)r);
            r.getStavke1();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom kreiranja ra\u010duna zajedno sa turom", e);
        }
        log.exiting(RestoranServer.class.getName(), "makeRacunAndTura");
    }

    public void addStavkeRacunJPA(List<StavkaRacuna> stavke) {
        EntityTransaction trans = this.base.getTransaction();
        while (trans.isActive()) {
        }
        try {
            trans.begin();
            for (StavkaRacuna sr : stavke) {
                this.base.persist((Object)sr);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            e.printStackTrace(System.out);
            Logger.getLogger(RestoranServer.class.getCanonicalName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom uno\u0161enja stavki ra\u010duna", e);
            this.log("Do\u0161lo je do gre\u0161ke prilikom uno\u0161enja stavki ra\u010duna");
        }
    }

    public void addPlacanjaJPA(List<Placanje> placanja) {
        EntityTransaction trans = this.base.getTransaction();
        while (trans.isActive()) {
        }
        try {
            trans.begin();
            for (Placanje p : placanja) {
                this.base.persist((Object)p);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            e.printStackTrace(System.out);
            Logger.getLogger(RestoranServer.class.getCanonicalName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom unosa pla\u0107anja u bazu", e);
            this.log("Do\u0161lo je do gre\u0161ke prilikom unosa pla\u0107anja u bazu");
        }
    }

    public List<Rezervacija> getRezervacijeUpozorenje() throws Exception {
        Calendar cal = Calendar.getInstance();
        Calendar calS = Calendar.getInstance();
        Integer upozorenjePrvo = this.getSetting(Option.REZERVACIJA_UPOZORENJE_PRVO) != null ? this.getSetting(Option.REZERVACIJA_UPOZORENJE_PRVO).intValue() : Integer.valueOf(0).intValue();
        Integer trajanjeRezervacije = this.getSetting(Option.TRAJANJE_REZERVACIJE) != null ? this.getSetting(Option.TRAJANJE_REZERVACIJE).intValue() : Integer.valueOf(0).intValue();
        cal.add(12, upozorenjePrvo);
        cal.add(12, trajanjeRezervacije);
        calS.add(12, -trajanjeRezervacije.intValue());
        TypedQuery qr = this.base.createQuery("SELECT r FROM Rezervacija r WHERE r.vreme BETWEEN :d1 AND :d2", Rezervacija.class);
        qr = qr.setParameter("d1", (Object)calS.getTime());
        qr = qr.setParameter("d2", (Object)cal.getTime());
        try {
            return qr.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            Logger.getLogger(RestoranServer.class.getCanonicalName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom tra\u017eenja tra\u017eenja rezervacije", e);
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom \u010ditanja rezervacija", e);
        }
    }

    public double getLastNabavnaCenaBela(Artikal art, Date d) {
        return this.getLastNabavnaCenaBelaForDate(art, d);
    }

    public double getLastNabavnaCenaBelaBezPDV(Artikal art, Date d) {
        return this.getLastNabavnaCenaBelaForDateBezPDV(art, d);
    }

    public double getLastNabavnaCenaBelaForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select t.komad from TrebovanjeStavka t left join trebovanje tr on tr.id = t.TREBOVANJE_ID where t.ARTIKAL_ID = ? and t.komadBPDV <> 0 and tr.datumTrebovanja <= ? order by t.id desc limit 1", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, (Object)date);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
        }
        catch (NoResultException nre) {
            lpq = this.base.createNativeQuery("SELECT t.komad from prijemnicastavka t where t.ARTIKAL_ID = ? order by t.id desc limit 1;", Double.class);
            lpq.setParameter(1, (Object)art.getId());
            try {
                ret = (Double)lpq.getSingleResult();
            }
            catch (NoResultException nree) {
                ret = 0.0;
            }
        }
        catch (Exception e) {
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        return ret;
    }

    public double getLastNabavnaCenaBelaForDateBezPDV(Artikal art, Date date) {
        String query = "select t.komadBPDV from trebovanjestavka t left join trebovanje tr on tr.id = t.TREBOVANJE_ID where t.ARTIKAL_ID = ? and t.komadBPDV <> 0 and tr.datumTrebovanja < NOW() order by t.id desc limit 1";
        double ret = 0.0;
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            pStatement.setLong(1, art.getId());
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            ret = rSet.getDouble("komadBPDV");
        }
        catch (SQLException e) {
            query = "SELECT t.komad from prijemnicastavka t where t.ARTIKAL_ID = ? order by t.id desc limit 1;";
            try {
                PreparedStatement pStatement = this.getConnection().prepareStatement(query);
                pStatement.setLong(1, art.getId());
                ResultSet rSet = pStatement.executeQuery();
                rSet.next();
                ret = rSet.getDouble("komad");
            }
            catch (SQLException e1) {
                ret = 0.0;
            }
        }
        return ret;
    }

    public double getLastNabavnaCenaBelaForDateBezPDVJPA(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select t.komadBPDV from TrebovanjeStavka t left join trebovanje tr on tr.id = t.TREBOVANJE_ID where t.ARTIKAL_ID = ? and t.komadBPDV <> 0 and tr.datumTrebovanja < ? order by t.id desc limit 1", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, (Object)date);
        Double ret = 0.0;
        System.out.println(lpq);
        try {
            ret = (Double)lpq.getSingleResult();
        }
        catch (NoResultException nre) {
            lpq = this.base.createNativeQuery("SELECT t.komad from prijemnicastavka t where t.ARTIKAL_ID = ? order by t.id desc limit 1;", Double.class);
            lpq.setParameter(1, (Object)art.getId());
            try {
                ret = (Double)lpq.getSingleResult();
            }
            catch (NoResultException nree) {
                ret = 0.0;
            }
        }
        catch (Exception e) {
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        return ret;
    }

    public double getLastNabavnaCenaBelaForDateComplexRecursiveMeasure(Long artId, Date date, Double measure) {
        return this.getLastNabavnaCenaBelaForDateComplexRecursiveMeasure((Artikal)this.base.find(Artikal.class, (Object)artId), date, measure);
    }

    public double getLastNabavnaCenaBelaForDateComplexRecursiveMeasure(Artikal art, Date date, Double measure) {
        double ret;
        double m;
        block5: {
            block4: {
                m = measure == null ? 1.0 : measure;
                ret = 0.0;
                if (art.getTip() == null) break block4;
                switch (art.getTip()) {
                    case POLU: 
                    case SLOZ: {
                        for (Map.Entry<Artikal, Double> norm : this.getIngridientsAndMeasure(art).entrySet()) {
                            ret += this.getLastNabavnaCenaBelaForDateComplexRecursiveMeasure(norm.getKey(), date, norm.getValue());
                        }
                        break block5;
                    }
                    default: {
                        ret += this.getLastNabavnaCenaBelaForDate(art, date);
                        break;
                    }
                }
                break block5;
            }
            ret = this.getLastNabavnaCenaBelaForDate(art, date);
        }
        return m * ret;
    }

    public double getLastNabavnaCenaKomboForDateComplexRecursiveMeasure(Long artId, Date date, Double measure) {
        return this.getLastNabavnaCenaKomboForDateComplexRecursiveMeasure((Artikal)this.base.find(Artikal.class, (Object)artId), date, measure);
    }

    public double getLastNabavnaCenaKomboForDateComplexRecursiveMeasure(Artikal art, Date date, Double measure) {
        double ret;
        double m;
        block5: {
            block4: {
                m = measure == null ? 1.0 : measure;
                ret = 0.0;
                if (art.getTip() == null) break block4;
                switch (art.getTip()) {
                    case POLU: 
                    case SLOZ: 
                    case DODA: {
                        for (Map.Entry<Artikal, Double> norm : this.getIngridientsAndMeasure(art).entrySet()) {
                            ret += this.getLastNabavnaCenaKomboForDateComplexRecursiveMeasure(norm.getKey(), date, norm.getValue());
                        }
                        break block5;
                    }
                    default: {
                        ret += this.getLastNabavnaCenaKomboForDateSPDV(art, date);
                        break;
                    }
                }
                break block5;
            }
            ret = this.getLastNabavnaCenaKomboForDate(art, date);
        }
        return m * ret;
    }

    public double getLastNabavnaCenaCrnaForDateComplexRecursiveMeasure(Long artId, Date date, Double measure) {
        return this.getLastNabavnaCenaCrnaForDateComplexRecursiveMeasure((Artikal)this.base.find(Artikal.class, (Object)artId), date, measure);
    }

    public double getLastNabavnaCenaCrnaForDateComplexRecursiveMeasure(Artikal art, Date date, Double measure) {
        double ret;
        double m;
        block5: {
            block4: {
                m = measure == null ? 1.0 : measure;
                ret = 0.0;
                if (art.getTip() == null) break block4;
                switch (art.getTip()) {
                    case POLU: 
                    case SLOZ: {
                        for (Map.Entry<Artikal, Double> norm : this.getIngridientsAndMeasure(art).entrySet()) {
                            ret += this.getLastNabavnaCenaCrnaForDateComplexRecursiveMeasure(norm.getKey(), date, norm.getValue());
                        }
                        break block5;
                    }
                    default: {
                        ret += this.getLastNabavnaCenaCrnaForDate(art, date);
                        break;
                    }
                }
                break block5;
            }
            ret = this.getLastNabavnaCenaCrnaForDate(art, date);
        }
        return m * ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Artikal, Double> getIngridientsAndMeasure(Artikal art) {
        HashMap<Artikal, Double> ret = new HashMap<Artikal, Double>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tq = em.createQuery("SELECT n.sastojak, n.kolicina FROM Normativ n WHERE n.artikal.id = :aid", Object[].class);
            tq.setParameter("aid", (Object)art.getId());
            for (Object[] t : tq.getResultList()) {
                Artikal a = (Artikal)t[0];
                Double m = (Double)t[1];
                m = m == null ? 0.0 : m;
                m = ret.get(a) == null ? m : (Double)ret.get(a) + m;
                ret.put(a, m);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastNabavnaCenaCrnaForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select nabCena from (select round(coalesce(ts.komad / (1 + ts.pdv / 100), 0), 4) as nabCena, t.datumtrebovanja as datum from trebovanje t left join trebovanjestavka ts on t.id = ts.trebovanje_id where t.prijemnica_id is null and ts.pdv is not null and t.crno = true and ts.artikal_id = ? and t.datumtrebovanja <= ? union select round(coalesce(ps.komad, 0), 2) as nabCena, p.datumprijemnice as datum from prijemnica p left join prijemnicastavka ps on p.id = ps.prijemnica_id and p.crno = true where ps.artikal_id = ? and p.datumprijemnice <= ?) as t order by datum desc limit 1;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, date, TemporalType.DATE);
        lpq.setParameter(3, (Object)art.getId());
        lpq.setParameter(4, date, TemporalType.DATE);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProsecnaNabavnaCena(Artikal art) {
        Query lpq = this.base.createNativeQuery("SELECT ROUND(AVG(ts.komadBPDV), 2) AS SrednjaCena FROM trebovanjestavka ts WHERE ts.ARTIKAL_ID = ?", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (NoResultException noResultException) {}
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastNabavnaCenaKomboForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select nabCena from (select round(coalesce(ts.komad / (1 + ts.pdv / 100), 0), 4) as nabCena, t.datumtrebovanja as datum from trebovanje t left join trebovanjestavka ts on t.id = ts.trebovanje_id where t.prijemnica_id is null and ts.pdv is not null and ts.artikal_id = ? and t.datumtrebovanja <= ? union select round(coalesce(ps.komadBPDV, 0), 2) as nabCena, p.datumprijemnice as datum from prijemnica p left join prijemnicastavka ps on p.id = ps.prijemnica_id where ps.artikal_id = ? and p.datumprijemnice <= ?) as t order by datum desc limit 1;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, date, TemporalType.DATE);
        lpq.setParameter(3, (Object)art.getId());
        lpq.setParameter(4, date, TemporalType.DATE);
        System.out.println(lpq);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (NoResultException noResultException) {}
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastNabavnaCenaKomboForDateSPDV(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select nabCena from (select round(coalesce(ts.komad, 0), 4) as nabCena, t.datumtrebovanja as datum from trebovanje t left join trebovanjestavka ts on t.id = ts.trebovanje_id where t.prijemnica_id is null and ts.pdv is not null and ts.artikal_id = ? and t.datumtrebovanja <= ? union select round(coalesce(ps.komadSPDV, 0), 2) as nabCena, p.datumprijemnice as datum from prijemnica p left join prijemnicastavka ps on p.id = ps.prijemnica_id where ps.artikal_id = ? and p.datumprijemnice <= ?) as t order by datum desc limit 1;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, date, TemporalType.DATE);
        lpq.setParameter(3, (Object)art.getId());
        lpq.setParameter(4, date, TemporalType.DATE);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (NoResultException noResultException) {}
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    public double getAvgNabavnaCenaBela(Artikal art) {
        return this.getAvgNabavnaCenaBelaForDate(art, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvgNabavnaCenaBelaForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select round(coalesce((coalesce(sum(ps.komad * ps.kolicina), 0) + coalesce(sum((ts.komad / (1 + ts.pdv / 100)) * ts.kolicina))) / (coalesce(sum(ps.kolicina), 0) + coalesce(sum(ts.kolicina), 0)), 0), 4) as nabCena from prijemnica p left join prijemnicastavka ps on p.id = ps.prijemnica_id, trebovanjestavka ts left join trebovanje t on t.id = ts.trebovanje_id where (t.crno is null or t.crno = false) and (p.crno is null or p.crno = false) and ts.pdv is not null and if((select count(id) from trebovanje where prijemnica_id is null) > 0, t.prijemnica_id is null, true) and ts.artikal_id = ? and ps.artikal_id = ? and p.datumprijemnice <= ? and t.datumtrebovanja <= ?;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, (Object)art.getId());
        lpq.setParameter(3, date, TemporalType.DATE);
        lpq.setParameter(4, date, TemporalType.DATE);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    public double getAvgNabavnaCenaCrna(Artikal art) {
        return this.getAvgNabavnaCenaCrnaForDate(art, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvgNabavnaCenaCrnaForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("SELECT round(coalesce((coalesce(sum(ps.komad * ps.kolicina), 0) + coalesce(sum((ts.komad / (1 + ts.pdv / 100)) * ts.kolicina))) / (coalesce(sum(ps.kolicina), 0) + coalesce(sum(ts.kolicina), 0)), 0), 4) AS nabCena FROM prijemnica p LEFT JOIN prijemnicastavka ps ON p.id = ps.prijemnica_id, trebovanjestavka ts LEFT JOIN trebovanje t ON t.id = ts.trebovanje_id WHERE t.crno = TRUE AND p.crno = TRUE AND ts.pdv IS NOT NULL AND if( (SELECT count(t.id) FROM trebovanje t left join trebovanjestavka ts on t.id = ts.trebovanje_id WHERE t.prijemnica_id IS NULL AND t.crno = TRUE AND ts.artikal_id = ?) > 0, t.prijemnica_id IS NULL, TRUE) AND ts.artikal_id = ? AND ps.artikal_id = ? AND p.datumprijemnice <= ? AND t.datumtrebovanja <= ?;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, (Object)art.getId());
        lpq.setParameter(3, (Object)art.getId());
        lpq.setParameter(4, date, TemporalType.DATE);
        lpq.setParameter(5, date, TemporalType.DATE);
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    public double getAvgNabavnaCenaKombo(Artikal art) {
        return this.getAvgNabavnaCenaKomboForDate(art, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAvgNabavnaCenaKomboForDate(Artikal art, Date date) {
        Query lpq = this.base.createNativeQuery("select coalesce((coalesce(sum(ps.komad * ps.kolicina), 0) + coalesce(sum((ts.komad / (1 + ts.pdv / 100)) * ts.kolicina))) / (coalesce(sum(ps.kolicina), 0) + coalesce(sum(ts.kolicina), 0)), 0) from prijemnica p left join prijemnicastavka ps on p.id = ps.prijemnica_id, trebovanjestavka ts left join trebovanje t on t.id = ts.trebovanje_id where ts.pdv is not null and t.prijemnica_id is null and ts.artikal_id = ? and ps.artikal_id = ?;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        lpq.setParameter(2, (Object)art.getId());
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLastNabavnaCenaCrna(Artikal art) {
        Query lpq = this.base.createNativeQuery("SELECT COALESCE(IF(count(nabcena)  = 0, 0, nabcena), 0) FROM (SELECT ts.komad AS nabcena FROM trebovanjestavka ts LEFT JOIN trebovanje t ON ts.TREBOVANJE_ID = t.id WHERE ts.ARTIKAL_ID = ? AND ts.komad > 0 AND t.crno = TRUE ORDER BY t.datumTrebovanja DESC, ts.id DESC LIMIT 1) AS sq;", Double.class);
        lpq.setParameter(1, (Object)art.getId());
        Double ret = 0.0;
        try {
            ret = (Double)lpq.getSingleResult();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            log.warning("Greska kod trazenja nabavne cene!!!");
        }
        finally {
            return ret;
        }
    }

    public double getProsecnaNabavnaCenaQuery(Artikal art) {
        return this.getProsecnaNabavnaCena(art);
    }

    public double getLastNabavnaCenaKombo(Artikal art) {
        return this.getLastNabavnaCenaKomboForDate(art, new Date());
    }

    public double getLastNabavnaCenaMagacin(Artikal art) {
        return this.getLastNabavnaCenaBela(art, new Date());
    }

    public double getLastNabavnaCenaMagacinKombinovano(Artikal art) {
        return this.getLastNabavnaCenaKombo(art);
    }

    public List<GrupaTroskova> getGrupeTroskovaFirstLevel() {
        Query query = this.base.createQuery("SELECT ga FROM GrupaTroskova ga WHERE ga.nadGrupa IS NULL");
        return query.getResultList();
    }

    public boolean deleteBlackReceiptJPA(Racun r) throws Exception {
        EntityTransaction trans = this.getBase().getTransaction();
        try {
            long rId = r.getId();
            trans.begin();
            this.base.remove((Object)r);
            trans.commit();
            return true;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            e.printStackTrace(System.out);
            throw new Exception("Doslo je do greske prilikom brisanja crnog racuna sa ID = " + r.getId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storniranjeBelogRacuna(Racun r, Storno s, LogRecord log) throws Exception {
        block20: {
            if (r == null) {
                throw new IllegalArgumentException("Racun je null");
            }
            if (r.getId() == null) {
                throw new IllegalArgumentException("racun id je null");
            }
            EntityManager em = this.getEM();
            EntityTransaction trans = em.getTransaction();
            Exception excp = null;
            try {
                if (!em.contains((Object)r)) {
                    r = (Racun)em.find(Racun.class, (Object)r.getId());
                }
                if (!em.contains((Object)s.getKonobar())) {
                    s.setKonobar((Konobar)em.find(Konobar.class, (Object)s.getKonobar().getId()));
                }
                for (StornoStavka stornoStavka : s.getStavke()) {
                    if (em.contains((Object)stornoStavka.getArtikal())) continue;
                    stornoStavka.setArtikal((Artikal)em.find(Artikal.class, (Object)stornoStavka.getArtikal().getId()));
                }
                trans.begin();
                if (r.getPlacanja() != null) {
                    for (Placanje placanje : r.getPlacanja()) {
                        em.remove((Object)placanje);
                        if (!this.base.contains((Object)placanje)) continue;
                        this.base.detach((Object)placanje);
                    }
                }
                if (r.getTure() != null) {
                    for (Tura tura : r.getTure()) {
                        em.remove((Object)tura);
                        if (!this.base.contains((Object)tura)) continue;
                        this.base.detach((Object)tura);
                    }
                }
                if (r.getStavke1() != null) {
                    for (StavkaRacuna stavkaRacuna : r.getStavke1()) {
                        em.remove((Object)stavkaRacuna);
                        if (!this.base.contains((Object)stavkaRacuna)) continue;
                        this.base.detach((Object)stavkaRacuna);
                    }
                }
                em.remove((Object)r);
                em.persist((Object)s);
                if (this.base.contains((Object)r)) {
                    this.base.detach((Object)r);
                }
                if (log != null) {
                    em.persist((Object)log);
                }
                trans.commit();
            }
            catch (Exception ex) {
                if (trans != null && trans.isActive()) {
                    trans.rollback();
                }
                excp = ex;
            }
            finally {
                if (em != null && em.isOpen() && !em.equals(this.base)) {
                    em.close();
                }
                if (excp == null) break block20;
                throw new Exception(excp);
            }
        }
    }

    public boolean hasCommonArticles(Odeljenje o1, Odeljenje o2) {
        Query q = this.base.createNativeQuery("SELECT COUNT(artikli_id) FROM artikal_odeljenje WHERE artikli_id IN (SELECT artikli_id FROM artikal_odeljenje WHERE odeljenja_id = ?1) AND odeljenja_id = ?2");
        try {
            q.setParameter(1, (Object)o1.getId());
            q.setParameter(2, (Object)o2.getId());
            Long bd = (Long)q.getSingleResult();
            return bd > 0L;
        }
        catch (Exception e) {
            Logger.getLogger(RestoranServer.class.getCanonicalName()).log(Level.WARNING, "Do\u0161lo je do gre\u0161ke prilikom proveravanja postojanja zajedni\u010dkih artikala", e);
            e.printStackTrace(System.out);
            return false;
        }
    }

    public List<Artikal> findAllArticlesNoComplexNoBlocked() {
        TypedQuery q = this.base.createQuery("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND a.tip <> :slozTip AND a.tip <> :dodaTip ORDER BY a.name", Artikal.class);
        q.setParameter("slozTip", (Object)TipArtikla.SLOZ);
        q.setParameter("dodaTip", (Object)TipArtikla.DODA);
        return q.getResultList();
    }

    public List<Artikal> findAllArticlesNoComplexNoBlocked(Odeljenje od1, Odeljenje od2) {
        StringBuilder sb = new StringBuilder("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND a.tip <> :slozTip AND a.tip <> :dodaTip");
        HashMap<String, Odeljenje> map = new HashMap<String, Odeljenje>();
        if (od1 != null) {
            sb.append(" AND (:od1 MEMBER OF a.odeljenja)");
            map.put("od1", od1);
        }
        if (od2 != null) {
            sb.append(" AND (:od2 MEMBER OF a.odeljenja)");
            map.put("od2", od2);
        }
        sb.append(" ORDER BY a.name");
        TypedQuery q = this.base.createQuery(sb.toString(), Artikal.class);
        q.setParameter("slozTip", (Object)TipArtikla.SLOZ);
        q.setParameter("dodaTip", (Object)TipArtikla.DODA);
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object object = entry.getValue();
            q.setParameter(string, object);
        }
        return q.getResultList();
    }

    public List<Artikal> findAllArticlesComplexAndHalfProductsNoBlocked() {
        TypedQuery q = this.base.createQuery("SELECT a FROM Artikal a WHERE a.blokiran = FALSE AND (a.tip = :slozTip OR a.tip = :poluTip OR a.tip = :dodTip OR (a.tip = :prodTip AND a.mera <> 1)) ORDER BY a.name", Artikal.class);
        q.setParameter("slozTip", (Object)TipArtikla.SLOZ);
        q.setParameter("poluTip", (Object)TipArtikla.POLU);
        q.setParameter("dodTip", (Object)TipArtikla.DODA);
        q.setParameter("prodTip", (Object)TipArtikla.PROD);
        return q.getResultList();
    }

    public boolean addPrijemnica(Prijemnica p, List<PrijemnicaStavka> psList) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.persist((Object)p);
            trans.commit();
            return true;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom upisivanja prijemnice sa brojem " + p.getBrPrijemnice(), e);
        }
    }

    public List<Rezervacija> findRezervacijaByDate(Calendar od, Calendar doo) {
        Query query = this.base.createQuery("SELECT ga FROM Rezervacija ga WHERE ga.datum BETWEEN :od AND :doo ORDER BY ga.datum ASC");
        query.setParameter("od", od, TemporalType.TIMESTAMP);
        query.setParameter("doo", doo, TemporalType.TIMESTAMP);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Double> getArtikliKolicineMedjuzbir(Date d1, Date d2, Odeljenje o) {
        log.info("Citanje medjuzbira za period " + d1 + " do " + d2 + " za odeljenje " + o);
        HashMap<Long, Double> mapa = new HashMap<Long, Double>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String pomocniString = "(select ARTIKAL_ID,sum(kolicina) from stavkaracuna where TURA_ID in (select id from tura where (tura.datum BETWEEN '" + Konstante.getSQLFormat(d1) + "' AND '" + Konstante.getSQLFormat(d2) + "') and tura.racun_id is null) and artikal_id in (select artikli_id from artikal_odeljenje where odeljenja_id = " + o.getId() + ") GROUP BY ARTIKAL_ID);";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(pomocniString);
            while (rs.next()) {
                mapa.put(rs.getLong(1), rs.getDouble(2));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public void updateStoKonobarJPA(Integer brojStola, Konobar konobar) throws Exception {
        Sto sto;
        if (brojStola == null) {
            throw new IllegalArgumentException("brojStola ne moze biti prazan");
        }
        if (konobar == null) {
            throw new IllegalArgumentException("konobar ne moze biti prazan");
        }
        if (!this.base.contains((Object)konobar)) {
            throw new IllegalArgumentException("dati konobar ne pripada kontekstu otvorenog em-a");
        }
        TypedQuery qs = this.base.createQuery("SELECT s FROM Sto s WHERE s.broj = :brojStola", Sto.class).setParameter("brojStola", (Object)brojStola).setMaxResults(1);
        try {
            sto = (Sto)qs.getSingleResult();
        }
        catch (NoResultException e) {
            throw new IllegalArgumentException("brojStola ne odgovara ni jednom otvorenom stolu", e);
        }
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            sto.setKonobar(konobar);
            this.base.merge((Object)sto);
            this.base.flush();
            this.base.refresh((Object)konobar);
            if (!konobar.getSto().contains(sto)) {
                throw new Exception("Zadatom konobaru nije dodeljen sto");
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<Artikal> readArtikalByPgNoBlocked(PodgrupaArtikala o) {
        TypedQuery query = this.base.createQuery("SELECT o FROM Artikal o WHERE  o.podgrupa = :grupa AND o.blokiran = FALSE ORDER BY o.name", Artikal.class);
        query.setParameter("grupa", (Object)o);
        return query.getResultList();
    }

    public Tura updateTuraJPA(Tura t) {
        log.info("Izmena ture: " + t.toString());
        EntityTransaction trans = this.base.getTransaction();
        trans.begin();
        t = (Tura)this.base.merge((Object)t);
        trans.commit();
        log.info("Tura izmenjena: " + t.toString());
        return t;
    }

    public int deleteStoJPA(int brojStola) {
        TypedQuery query = this.base.createQuery("SELECT s FROM Sto s WHERE s.broj = :brojStola", Sto.class);
        query.setParameter("brojStola", (Object)brojStola);
        EntityTransaction trans = this.base.getTransaction();
        int del = 0;
        try {
            List sList = query.getResultList();
            trans.begin();
            for (Sto sto : sList) {
                this.getBase().remove((Object)sto);
                ++del;
            }
            trans.commit();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return -1;
        }
        return del;
    }

    public void deleteStavkaRacunaJPA(StavkaRacuna sr) {
        log.info(new Date() + "Brisanje stavke broj " + sr.getId());
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.remove((Object)sr);
            trans.commit();
        }
        catch (Exception ex) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.severe("PersistenceException: " + ex.getMessage());
        }
        log.info(new Date() + " stavka obrisana ");
    }

    public void makeRacunAndTuraPretraga(Racun r) throws Exception {
        log.entering(RestoranServer.class.getName(), "makeRacunAndTura");
        EntityTransaction trans = this.base.getTransaction();
        try {
            List<Object> pList;
            List<Tura> tList = r.getTure();
            List<StavkaRacuna> srList = r.getStavke1();
            List<Object> list = pList = r.getPlacanja() == null ? new LinkedList() : r.getPlacanja();
            if (r.getMeniPromet() != null) {
                if (r.getMeniPromet().getMeni().getId() != null) {
                    Meni m = (Meni)this.base.find(Meni.class, (Object)r.getMeniPromet().getMeni().getId());
                    r.getMeniPromet().setMeni(m);
                }
                r.getMeniPromet().setDatum(r.getDatum());
                r.getMeniPromet().setRacun(r);
            }
            if (r.getMeniPromet() != null) {
                Double meniTotal = r.getMeniPromet().getTotal();
                Double racunTotal = r.total();
                Double d2 = meniTotal / racunTotal * 100.0 - 100.0;
                d2 = BigDecimal.valueOf(d2).setScale(6, RoundingMode.HALF_EVEN).doubleValue();
                System.out.println("popust = " + d2);
                r.setPopust(-d2.doubleValue());
                if (pList.size() > 0 && pList.size() == 1) {
                    ((Placanje)pList.get(0)).setIznos(r.getMeniPromet().getTotal());
                }
            }
            r.setPlacanja(new LinkedList<Placanje>());
            r.setStavke1(new LinkedList<StavkaRacuna>());
            r.setTure(new LinkedList<Tura>());
            Kasa kasa = this.getCurrentCounter();
            r.setKasa(kasa != null ? (Kasa)this.base.find(Kasa.class, (Object)kasa.getId()) : null);
            trans.begin();
            log.info("persisting " + r.toString());
            this.base.persist((Object)r);
            log.info(r.toString() + " persisted");
            for (Tura tura : tList) {
                srList = tura.getStavke();
                tura.setDatum(new Date());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                tura.setPocetak(new Timestamp(1L));
                tura.setKraj(new Timestamp(1L));
                tura.setRacun(r);
                log.info("persisting " + tura.toString());
                this.base.persist((Object)tura);
                log.info(tura.toString() + " persisted");
                for (StavkaRacuna sr : srList) {
                    sr.setRacun(r);
                    sr.setTura(tura);
                    log.info("persisting " + sr.toString());
                    this.base.persist((Object)sr);
                    log.info(sr.toString() + " persisted");
                }
            }
            for (Placanje placanje : pList) {
                placanje.setRacun(r);
                log.info("persisting " + placanje.toString());
                this.base.persist((Object)placanje);
                log.info(placanje.toString() + " persisted");
            }
            trans.commit();
            this.base.refresh((Object)r);
            r.getStavke1();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom kreiranja ra\u010duna zajedno sa turom", e);
        }
        log.exiting(RestoranServer.class.getName(), "makeRacunAndTura");
    }

    public List<Izvod> getIzvodi() {
        TypedQuery queru = this.base.createQuery("SELECT izvod FROM Izvod izvod", Izvod.class);
        return queru.getResultList();
    }

    public Izvod getIzvodByBroj(Integer brojIzvoda) {
        TypedQuery queru = this.base.createQuery("SELECT izvod FROM Izvod izvod WHERE izvod.brojIzvoda = :broj", Izvod.class);
        queru.setParameter("broj", (Object)brojIzvoda);
        try {
            return (Izvod)queru.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public List<IzvodStavka> getIzvodi(Integer brojIzvoda, Date datumIzvoda, StalniGost komitent) {
        StringBuilder queryBuilder = new StringBuilder("SELECT izvodStavka FROM IzvodStavka izvodStavka");
        if (brojIzvoda != null || datumIzvoda != null || komitent != null) {
            queryBuilder.append(" WHERE ");
            if (brojIzvoda != null) {
                queryBuilder.append("izvodStavka.izvod.brojIzvoda = :broj");
                if (datumIzvoda != null) {
                    queryBuilder.append(" AND izvodStavka.izvod.datumIzvoda = :datum");
                }
                if (komitent != null) {
                    queryBuilder.append(" AND izvodStavka.komitent = :komitent");
                }
            } else if (datumIzvoda != null) {
                queryBuilder.append("izvodStavka.izvod.datumIzvoda = :datum");
                if (komitent != null) {
                    queryBuilder.append(" AND izvodStavka.komitent = :komitent");
                }
            } else if (komitent != null) {
                queryBuilder.append("izvodStavka.komitent = :komitent");
            }
        }
        TypedQuery queru = this.base.createQuery(queryBuilder.toString(), IzvodStavka.class);
        if (brojIzvoda != null || datumIzvoda != null || komitent != null) {
            queryBuilder.append(" WHERE ");
            if (brojIzvoda != null) {
                queru.setParameter("broj", (Object)brojIzvoda);
                if (datumIzvoda != null) {
                    queru.setParameter("datum", (Object)datumIzvoda);
                }
                if (komitent != null) {
                    queru.setParameter("komitent", (Object)komitent);
                }
            } else if (datumIzvoda != null) {
                queru.setParameter("datum", (Object)datumIzvoda);
                if (komitent != null) {
                    queru.setParameter("komitent", (Object)komitent);
                }
            } else if (komitent != null) {
                queru.setParameter("komitent", (Object)komitent);
            }
        }
        return queru.getResultList();
    }

    public void snimanjeIzvoda(Izvod izvod) {
        log.info(new Date() + "Snimanje izvoda broj " + izvod.getBrojIzvoda());
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.persist((Object)izvod);
            trans.commit();
            log.info(new Date() + " izvod snimljen u bazu podataka ");
        }
        catch (Exception ex) {
            log.severe("PersistenceException: " + ex.getMessage());
        }
    }

    public boolean addRokovnik(Rokovnik rokovnik) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.persist((Object)rokovnik);
            trans.commit();
            return true;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom upisa Rokovnika u bazu", e);
        }
    }

    public List<Rokovnik> findAllRokovnik() {
        TypedQuery tq = this.base.createQuery("SELECT r FROM Rokovnik r", Rokovnik.class);
        return tq.getResultList();
    }

    public List<Rokovnik> findAllRokovnikForDate(Date date) {
        TypedQuery tq = this.base.createQuery("SELECT r FROM Rokovnik r WHERE r.datum = :d", Rokovnik.class).setParameter("d", (Object)date);
        return tq.getResultList();
    }

    public List<Rokovnik> findAllRokovnikForDateRange(Date dateFrom, Date dateTo) {
        TypedQuery tq = this.base.createQuery("SELECT r FROM Rokovnik r WHERE r.datum BETWEEN :d1 AND :d2", Rokovnik.class).setParameter("d1", (Object)dateFrom).setParameter("d2", (Object)dateTo);
        return tq.getResultList();
    }

    public List<Rokovnik> findAllRokovnikForDateRangeByType(Date dateFrom, Date dateTo, RokovnikTipUnosa tip) {
        TypedQuery tq = this.base.createQuery("SELECT r FROM Rokovnik r WHERE r.datum BETWEEN :d1 AND :d2 AND r.tipUnosa = :tip", Rokovnik.class).setParameter("d1", (Object)dateFrom).setParameter("d2", (Object)dateTo).setParameter("tip", (Object)tip);
        return tq.getResultList();
    }

    public List<IDKartica> findAllIDKartica() {
        TypedQuery tqidk = this.base.createQuery("SELECT idk FROM IDKartica idk", IDKartica.class);
        return tqidk.getResultList();
    }

    public void addIDKartica(IDKartica idk) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.persist((Object)idk);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom upisivanja ID kartice", e);
        }
    }

    public IDKartica updateIDKartica(IDKartica idk) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            idk = (IDKartica)this.base.merge((Object)idk);
            trans.commit();
            return idk;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom azuriranja ID kartice", e);
        }
    }

    public void removeIDKartica(IDKartica idk) throws Exception {
        EntityTransaction trans = this.base.getTransaction();
        try {
            trans.begin();
            this.base.remove((Object)idk);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom brisanja ID kartice", e);
        }
    }

    public IDKartica findIDKarticaByKod(String kod) throws Exception {
        TypedQuery tqidk = this.base.createQuery("SELECT idk FROM IDKartica idk WHERE idk.kod = :kod", IDKartica.class);
        try {
            tqidk.setParameter("kod", (Object)kod);
            tqidk.setMaxResults(1);
            return (IDKartica)tqidk.getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
        catch (Exception e) {
            throw new Exception("Doslo je do greske prilikom trazenja ID kartice", e);
        }
    }

    public List<DnevnoStanje> getDnevnaStanjaJPA() {
        TypedQuery tqds = this.base.createQuery("SELECT ds FROM DnevnoStanje ds", DnevnoStanje.class);
        return tqds.getResultList();
    }

    public List<DnevnoStanje> getDnevnaStanjaJPA(Odeljenje od) {
        TypedQuery tqds = this.base.createQuery("SELECT ds FROM DnevnoStanje ds where ds.odeljenje = :od", DnevnoStanje.class);
        tqds.setParameter("od", (Object)od);
        return tqds.getResultList();
    }

    public Map<Long, Artikal> getArtikliZaIzvestajOStanjuZaliha() {
        TypedQuery tqabs = this.base.createQuery("SELECT a.id, a FROM Artikal a WHERE a.tip in :tipovi", Object[].class);
        LinkedList<TipArtikla> tipovi = new LinkedList<TipArtikla>();
        tipovi.add(TipArtikla.PROD);
        tipovi.add(TipArtikla.SIRO);
        tipovi.add(TipArtikla.POLU);
        tqabs.setParameter("tipovi", tipovi);
        List list = tqabs.getResultList();
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        for (Object[] objects : list) {
            mapa.put((Long)objects[0], (Artikal)objects[1]);
        }
        return mapa;
    }

    public Map<Long, Artikal> getArtikliZaIzvestajOStanjuZaliha(Odeljenje o) {
        TypedQuery tqabs = this.base.createQuery("SELECT a.id, a FROM Odeljenje o LEFT JOIN o.artikli a  WHERE o.id = :oid AND a.tip in :tipovi", Object[].class);
        LinkedList<TipArtikla> tipovi = new LinkedList<TipArtikla>();
        tipovi.add(TipArtikla.PROD);
        tipovi.add(TipArtikla.SIRO);
        tipovi.add(TipArtikla.POLU);
        tqabs.setParameter("tipovi", tipovi);
        tqabs.setParameter("oid", (Object)o.getId());
        List list = tqabs.getResultList();
        HashMap<Long, Artikal> mapa = new HashMap<Long, Artikal>();
        for (Object[] objects : list) {
            mapa.put((Long)objects[0], (Artikal)objects[1]);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String[]>> getISZResults(Date from, Date to, List<TipArtikla> exclTypes, List<Odeljenje> dprtmnts, List<PodgrupaArtikala> sbgrps, boolean white, boolean black, boolean lastPrice, boolean lastPriceWithBlack, boolean onlyChanges, boolean warehouse, boolean subGroupsSort) {
        EntityManager em = this.getEM();
        try {
            int i;
            String subGroups = "";
            String departments = "";
            String excludedArtTypes = "";
            for (i = 0; i < sbgrps.size(); ++i) {
                PodgrupaArtikala pg = sbgrps.get(i);
                subGroups = subGroups + pg.getId();
                if (i >= sbgrps.size() - 1) continue;
                subGroups = subGroups + ",";
            }
            for (i = 0; i < dprtmnts.size(); ++i) {
                Odeljenje od = dprtmnts.get(i);
                departments = departments + od.getId();
                if (i >= dprtmnts.size() - 1) continue;
                departments = departments + ",";
            }
            for (i = 0; i < exclTypes.size(); ++i) {
                TipArtikla tip = exclTypes.get(i);
                excludedArtTypes = excludedArtTypes + tip.name();
                if (i >= exclTypes.size() - 1) continue;
                excludedArtTypes = excludedArtTypes + ",";
            }
            String statement = Queries.QUERIES.get((Object)QueryName.IZVESAJ_O_STANJU_ZALIHA);
            String[] queries = statement.split(";");
            Double pgA = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_A);
            Double pgG = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_G);
            Double pgD = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_D);
            Double pgDJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_DJ);
            Double pgE = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_E);
            Double pgZJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_ZJ);
            Double pgI = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_I);
            Double pgJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_J);
            Double pgK = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_K);
            int idx = 1;
            em.getTransaction().begin();
            em.getTransaction().setRollbackOnly();
            em.createNativeQuery(queries[0]).setParameter(idx++, from, TemporalType.DATE).setParameter(idx++, to, TemporalType.DATE).setParameter(idx++, (Object)departments).setParameter(idx++, (Object)warehouse).setParameter(idx++, (Object)subGroups).setParameter(idx++, (Object)subGroupsSort).setParameter(idx++, (Object)excludedArtTypes).setParameter(idx++, (Object)onlyChanges).setParameter(idx++, (Object)white).setParameter(idx++, (Object)black).setParameter(idx++, (Object)lastPrice).setParameter(idx++, (Object)lastPriceWithBlack).setParameter(idx++, (Object)pgA).setParameter(idx++, (Object)pgG).setParameter(idx++, (Object)pgD).setParameter(idx++, (Object)pgDJ).setParameter(idx++, (Object)pgE).setParameter(idx++, (Object)pgZJ).setParameter(idx++, (Object)pgI).setParameter(idx++, (Object)pgJ).setParameter(idx++, (Object)pgK).executeUpdate();
            Query q = em.createNativeQuery(queries[1]);
            HashMap resultMap = new HashMap();
            List result = q.getResultList();
            for (Object[] objects : result) {
                String key = objects[0].toString();
                String[] value = new String[objects.length];
                value[0] = "";
                for (int i2 = 1; i2 < objects.length; ++i2) {
                    value[i2] = objects[i2].toString();
                    System.out.println(objects[i2]);
                }
                if (!resultMap.containsKey(key)) {
                    resultMap.put(key, new LinkedList());
                }
                ((List)resultMap.get(key)).add(value);
            }
            HashMap hashMap = resultMap;
            return hashMap;
        }
        finally {
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public GrafikSale addGrafikSale(GrafikSale grafikSale) {
        LinkedList<GrafikSale> list = new LinkedList<GrafikSale>();
        for (GrafikSale gf : grafikSale.getGraficiSaleLista()) {
            if (gf == null || gf.getId() == null) continue;
            if (!this.base.contains((Object)gf)) {
                gf = (GrafikSale)this.base.find(GrafikSale.class, (Object)gf.getId());
            }
            if (gf == null) continue;
            list.add(gf);
        }
        grafikSale.setGraficiSaleLista(list);
        this.base.getTransaction().begin();
        this.base.persist((Object)grafikSale);
        this.base.getTransaction().commit();
        return grafikSale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGrafikaSale(GrafikSale grafikSale) {
        String query = "UPDATE `grafiksale` SET `naziv`='" + grafikSale.getNaziv() + "', `slika`='" + grafikSale.getSlika() + "' WHERE  `id`=" + grafikSale.getId() + ";";
        String theString = query.replace("\\", "\\\\");
        Connection conn = this.getConnection();
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(theString);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, null);
        }
    }

    public void deleteGrafikSale(GrafikSale grafikSale) {
        this.base.getTransaction().begin();
        GrafikSale gs = (GrafikSale)this.base.find(GrafikSale.class, (Object)grafikSale.getId());
        for (StoPrikaz sp : this.getStolovePrikaz(grafikSale)) {
            this.base.remove((Object)sp);
        }
        this.base.remove((Object)gs);
        this.base.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String[]>> getIOBrutoStanju(Date from, Date to, List<TipArtikla> exclTypes, List<Odeljenje> dprtmnts, List<PodgrupaArtikala> sbgrps, boolean white, boolean black, boolean lastPrice, boolean lastPriceWithBlack, boolean onlyChanges, boolean warehouse, boolean subGroupsSort) {
        EntityManager em = this.getEM();
        List<Odeljenje> odeljenja = dprtmnts;
        if (dprtmnts == null) {
            dprtmnts = this.readOdeljenje();
        }
        try {
            int i;
            String subGroups = "";
            String departments = "";
            String excludedArtTypes = "";
            for (i = 0; i < sbgrps.size(); ++i) {
                PodgrupaArtikala pg = sbgrps.get(i);
                subGroups = subGroups + pg.getId();
                if (i >= sbgrps.size() - 1) continue;
                subGroups = subGroups + ",";
            }
            for (i = 0; i < dprtmnts.size(); ++i) {
                Odeljenje od = dprtmnts.get(i);
                departments = departments + od.getId();
                if (i >= dprtmnts.size() - 1) continue;
                departments = departments + ",";
            }
            for (i = 0; i < exclTypes.size(); ++i) {
                TipArtikla tip = exclTypes.get(i);
                excludedArtTypes = excludedArtTypes + tip.name();
                if (i >= exclTypes.size() - 1) continue;
                excludedArtTypes = excludedArtTypes + ",";
            }
            String statement = Queries.QUERIES.get((Object)QueryName.IZVESTAJ_O_BRUTO_STANJU);
            String[] queries = statement.split(";");
            Double pgA = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_A);
            Double pgG = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_G);
            Double pgD = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_D);
            Double pgDJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_DJ);
            Double pgE = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_E);
            Double pgZJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_ZJ);
            Double pgI = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_I);
            Double pgJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_J);
            Double pgK = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_K);
            int idx = 1;
            em.getTransaction().begin();
            em.getTransaction().setRollbackOnly();
            em.createNativeQuery(queries[0]).setParameter(idx++, from, TemporalType.DATE).setParameter(idx++, to, TemporalType.DATE).setParameter(idx++, (Object)departments).setParameter(idx++, (Object)warehouse).setParameter(idx++, (Object)subGroups).setParameter(idx++, (Object)subGroupsSort).setParameter(idx++, (Object)excludedArtTypes).setParameter(idx++, (Object)onlyChanges).setParameter(idx++, (Object)white).setParameter(idx++, (Object)black).setParameter(idx++, (Object)lastPrice).setParameter(idx++, (Object)lastPriceWithBlack).setParameter(idx++, (Object)pgA).setParameter(idx++, (Object)pgG).setParameter(idx++, (Object)pgD).setParameter(idx++, (Object)pgDJ).setParameter(idx++, (Object)pgE).setParameter(idx++, (Object)pgZJ).setParameter(idx++, (Object)pgI).setParameter(idx++, (Object)pgJ).setParameter(idx++, (Object)pgK).executeUpdate();
            Query q = em.createNativeQuery(queries[1]);
            HashMap resultMap = new HashMap();
            List result = q.getResultList();
            if (odeljenja == null) {
                for (Object[] objects : result) {
                    String key = "SVI MAGACINI";
                    String[] value = new String[objects.length];
                    value[0] = "";
                    for (int i2 = 1; i2 < objects.length; ++i2) {
                        value[i2] = objects[i2].toString();
                        System.out.println(objects[i2]);
                    }
                    if (!resultMap.containsKey(key)) {
                        resultMap.put(key, new LinkedList());
                    }
                    String[] pronadjeni = null;
                    for (String[] s : (List)resultMap.get("SVI MAGACINI")) {
                        if (!value[1].equals(s[1]) || (Double)objects[3] == 0.0) continue;
                        pronadjeni = s;
                        for (int i3 = 3; value.length > i3; ++i3) {
                            pronadjeni[i3] = String.valueOf(Double.parseDouble(value[i3].replace("/", "0")) + Double.parseDouble(s[i3].replace("/", "0")));
                        }
                    }
                    if (pronadjeni != null) continue;
                    ((List)resultMap.get(key)).add(value);
                }
            } else {
                for (Object[] objects : result) {
                    String key = objects[0].toString();
                    String[] value = new String[objects.length];
                    value[0] = "";
                    for (int i4 = 1; i4 < objects.length; ++i4) {
                        value[i4] = objects[i4].toString();
                        System.out.println(objects[i4]);
                    }
                    if (!resultMap.containsKey(key)) {
                        resultMap.put(key, new LinkedList());
                    }
                    ((List)resultMap.get(key)).add(value);
                }
            }
            HashMap hashMap = resultMap;
            return hashMap;
        }
        finally {
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String[]>> getISZResultsBB(Date from, Date to, List<TipArtikla> exclTypes, List<Odeljenje> dprtmnts, List<PodgrupaArtikala> sbgrps, boolean white, boolean black, boolean lastPrice, boolean lastPriceWithBlack, boolean onlyChanges, boolean warehouse, boolean subGroupsSort) {
        EntityManager em = this.getEM();
        List<Odeljenje> odeljenja = dprtmnts;
        if (dprtmnts == null) {
            dprtmnts = this.readOdeljenje();
        }
        try {
            int i;
            String subGroups = "";
            String departments = "";
            String excludedArtTypes = "";
            for (i = 0; i < sbgrps.size(); ++i) {
                PodgrupaArtikala pg = sbgrps.get(i);
                subGroups = subGroups + pg.getId();
                if (i >= sbgrps.size() - 1) continue;
                subGroups = subGroups + ",";
            }
            for (i = 0; i < dprtmnts.size(); ++i) {
                Odeljenje od = dprtmnts.get(i);
                departments = departments + od.getId();
                if (i >= dprtmnts.size() - 1) continue;
                departments = departments + ",";
            }
            for (i = 0; i < exclTypes.size(); ++i) {
                TipArtikla tip = exclTypes.get(i);
                excludedArtTypes = excludedArtTypes + tip.name();
                if (i >= exclTypes.size() - 1) continue;
                excludedArtTypes = excludedArtTypes + ",";
            }
            String statement = Queries.QUERIES.get((Object)QueryName.IZVESTAJ_O_STANJU_ZALIHA_BEZ_BARKODA);
            String[] queries = statement.split(";");
            Double pgA = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_A);
            Double pgG = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_G);
            Double pgD = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_D);
            Double pgDJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_DJ);
            Double pgE = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_E);
            Double pgZJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_ZJ);
            Double pgI = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_I);
            Double pgJ = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_J);
            Double pgK = Konstante.getPdvPoPG(PoreskaGrupa.GRUPA_K);
            int idx = 1;
            em.getTransaction().begin();
            em.getTransaction().setRollbackOnly();
            em.createNativeQuery(queries[0]).setParameter(idx++, from, TemporalType.DATE).setParameter(idx++, to, TemporalType.DATE).setParameter(idx++, (Object)departments).setParameter(idx++, (Object)warehouse).setParameter(idx++, (Object)subGroups).setParameter(idx++, (Object)subGroupsSort).setParameter(idx++, (Object)excludedArtTypes).setParameter(idx++, (Object)onlyChanges).setParameter(idx++, (Object)white).setParameter(idx++, (Object)black).setParameter(idx++, (Object)lastPrice).setParameter(idx++, (Object)lastPriceWithBlack).setParameter(idx++, (Object)pgA).setParameter(idx++, (Object)pgG).setParameter(idx++, (Object)pgD).setParameter(idx++, (Object)pgDJ).setParameter(idx++, (Object)pgE).setParameter(idx++, (Object)pgZJ).setParameter(idx++, (Object)pgI).setParameter(idx++, (Object)pgJ).setParameter(idx++, (Object)pgK).executeUpdate();
            Query q = em.createNativeQuery(queries[1]);
            HashMap resultMap = new HashMap();
            List result = q.getResultList();
            if (odeljenja == null) {
                for (Object[] objects : result) {
                    String key = "SVI MAGACINI";
                    String[] value = new String[objects.length];
                    value[0] = "";
                    for (int i2 = 1; i2 < objects.length; ++i2) {
                        value[i2] = objects[i2].toString();
                        System.out.println(objects[i2]);
                    }
                    if (!resultMap.containsKey(key)) {
                        resultMap.put(key, new LinkedList());
                    }
                    String[] pronadjeni = null;
                    for (String[] s : (List)resultMap.get("SVI MAGACINI")) {
                        if (!value[1].equals(s[1]) || (Double)objects[3] == 0.0) continue;
                        pronadjeni = s;
                        for (int i3 = 3; value.length > i3; ++i3) {
                            pronadjeni[i3] = String.valueOf(Double.parseDouble(value[i3].replace("/", "0")) + Double.parseDouble(s[i3].replace("/", "0")));
                        }
                    }
                    if (pronadjeni != null) continue;
                    ((List)resultMap.get(key)).add(value);
                }
            } else {
                for (Object[] objects : result) {
                    String key = objects[0].toString();
                    String[] value = new String[objects.length];
                    value[0] = "";
                    for (int i4 = 1; i4 < objects.length; ++i4) {
                        value[i4] = objects[i4].toString();
                        System.out.println(objects[i4]);
                    }
                    if (!resultMap.containsKey(key)) {
                        resultMap.put(key, new LinkedList());
                    }
                    ((List)resultMap.get(key)).add(value);
                }
            }
            HashMap hashMap = resultMap;
            return hashMap;
        }
        finally {
            try {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void unosTure(Sto sto, Tura t, List<StavkaRacuna> lsr, Map<StavkaRacuna, String> artikal_opis) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            if (sto.getId() == null) {
                Object k = sto.getKonobar();
                if ((k = (Konobar)em.find(Konobar.class, (Object)((BObject)k).getId())) == null) {
                    throw new Exception("Doslo je do greske prilkom upisivanja ture u bazu. Konobar pretrazen po id-u je prazan. ID pretrtage = " + sto.getKonobar().getId());
                }
                sto.setKonobar((Konobar)k);
                em.persist((Object)sto);
                em.flush();
            }
            em.persist((Object)t);
            em.flush();
            for (StavkaRacuna sr : lsr) {
                Artikal a = (Artikal)em.find(Artikal.class, (Object)sr.getArtikal().getId());
                if (a == null) {
                    throw new Exception("Doslo je do greske prilkom upisivanja ture u bazu. Artikal pretrazen po id-u je prazan. ID pretrtage = " + sr.getArtikal().getId());
                }
                sr.setArtikal(a);
                sr.setBrojStola(sto.getBroj());
                sr.setTura(t);
                if (sr.getPodStavke() != null && !sr.getPodStavke().isEmpty()) {
                    List<Object> lista = new LinkedList();
                    lista = sr.getPodStavke();
                    ListIterator<Object> iter = lista.listIterator();
                    while (iter.hasNext()) {
                        StavkaRacuna as = (StavkaRacuna)iter.next();
                        if (!as.getArtikal().getTip().equals((Object)TipArtikla.OPIS)) continue;
                        iter.remove();
                    }
                    sr.setPodStavke(lista);
                    for (StavkaRacuna child : sr.getPodStavke()) {
                        Artikal aChild = (Artikal)em.find(Artikal.class, (Object)child.getArtikal().getId());
                        if (aChild == null) {
                            throw new Exception("Doslo je do greske prilkom upisivanja ture u bazu. Artikal pretrazen po id-u je prazan. ID pretrtage = " + child.getArtikal().getId());
                        }
                        child.setArtikal(aChild);
                        child.setBrojStola(sto.getBroj());
                        child.setTura(t);
                    }
                }
                Logger.getLogger(FrontOffice3.class.getName()).info("Kreiranje Ture i Stavki :" + sr.getNaziv() + " cena iz stavke:" + sr.getCena() + "cena iz artikla: " + sr.getArtikal().getCena() + "\n--------------------------------------------------------------------------------------------");
                em.persist((Object)sr);
                em.refresh((Object)sr);
                em.flush();
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom unosa ture!", e);
        }
        finally {
            em.close();
        }
    }

    public StalniGostiGrupa getStalniGostGrupa(String naziv) {
        TypedQuery query = this.base.createQuery("SELECT ssg FROM StalniGostiGrupa ssg WHERE ssg.naziv = :naziv ", StalniGostiGrupa.class);
        query.setParameter("naziv", (Object)naziv);
        try {
            return (StalniGostiGrupa)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public StalniGostiGrupa getStalniGostGrupa(Long id) {
        TypedQuery query = this.base.createQuery("SELECT ssg FROM StalniGostiGrupa ssg WHERE ssg.id = :id ", StalniGostiGrupa.class);
        query.setParameter("id", (Object)id);
        try {
            return (StalniGostiGrupa)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public CenovnikTip getCenovnikTip(String naziv) {
        TypedQuery query = this.base.createQuery("SELECT ct FROM CenovnikTip ct WHERE ct.naziv = :naziv ", CenovnikTip.class);
        query.setParameter("naziv", (Object)naziv);
        try {
            return (CenovnikTip)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public StalniGostiGrupa getStalniGostGrupa() {
        TypedQuery queru = this.base.createQuery("SELECT ssg FROM StalniGostiGrupa ssg WHERE ssg.naziv = 'PREDUZECE' ", StalniGostiGrupa.class);
        try {
            return (StalniGostiGrupa)queru.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public StalniGostPretplata getSGpretplata(StalniGost sg) {
        TypedQuery queru = this.base.createQuery("SELECT sgp FROM StalniGostPretplata sgp WHERE sgp.stalniGost = :sg ", StalniGostPretplata.class);
        queru.setParameter("sg", (Object)sg);
        try {
            return (StalniGostPretplata)queru.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public StalniGostPretplata updateStalniPretplata(StalniGostPretplata sgp) {
        this.base.getTransaction().begin();
        try {
            sgp = (StalniGostPretplata)this.base.merge((Object)sgp);
            this.base.getTransaction().commit();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.base.getTransaction().rollback();
        }
        return sgp;
    }

    public StalniGost updateStalni(StalniGost sg) {
        this.base.getTransaction().begin();
        try {
            sg = (StalniGost)this.base.merge((Object)sg);
            this.base.getTransaction().commit();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            this.base.getTransaction().rollback();
        }
        return sg;
    }

    public StalniGost setStalniGostPopust(StalniGost sg) {
        String update = "UPDATE StalniGost set popust = " + sg.getPopust() + " where id=" + sg.getId() + " ";
        Connection con = null;
        Statement st = null;
        try {
            con = this.getConnection();
            st = con.createStatement();
            st.executeUpdate(update);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sg;
    }

    public StalniGost updateStalniGost(StalniGost sg) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (sg == null) {
                throw new NullPointerException("Stalni gost koji se azurira je prazan (null)");
            }
            if (this.base.contains((Object)sg)) {
                this.base.detach((Object)sg);
            }
            StalniGostiGrupa sgg = sg.getGrupa();
            if (sg.getGrupa() != null) {
                if (this.base.contains((Object)sgg)) {
                    this.base.detach((Object)sgg);
                }
                if ((sgg = (StalniGostiGrupa)em.find(StalniGostiGrupa.class, (Object)sgg.getId())) == null) {
                    throw new NullPointerException("Grupa stalnog gosta koji se azurira nije pronadjena u bazi");
                }
            }
            trans.begin();
            sg = (StalniGost)em.merge((Object)sg);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom a\u017euriranja stalnog gosta " + (sg != null ? sg.getNaziv() : ""), e);
        }
        finally {
            em.close();
            return sg;
        }
    }

    public void updateStalniGostPretplata(StalniGostPretplata sgp) throws Exception {
        sgp = (StalniGostPretplata)this.base.find(StalniGostPretplata.class, (Object)sgp.getId());
        try {
            this.base.getTransaction().begin();
            this.base.merge((Object)sgp);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            if (this.base.getTransaction().isActive()) {
                this.base.getTransaction().rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom updateovanja pretplate id=  " + (sgp != null ? sgp.getId() : ""), e);
        }
    }

    public void addStalniGostPretplata(StalniGostPretplata sgp) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (sgp == null) {
                throw new NullPointerException("StalniGpstPretplata  koji se dodaje je prazan (null)");
            }
            if (this.base.contains((Object)sgp)) {
                this.base.detach((Object)sgp);
            }
            this.base.getTransaction().begin();
            this.base.persist((Object)sgp);
            this.base.getTransaction().commit();
            this.base.refresh((Object)sgp);
        }
        catch (Exception e) {
            if (this.base.getTransaction().isActive()) {
                this.base.getTransaction().rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom dodavanja pretplate id=  " + (sgp != null ? sgp.getId() : ""), e);
        }
    }

    public void addStalniGost(StalniGost sg) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (sg == null) {
                throw new NullPointerException("Stalni gost koji se dodaje je prazan (null)");
            }
            if (this.base.contains((Object)sg)) {
                this.base.detach((Object)sg);
            }
            StalniGostiGrupa sgg = sg.getGrupa();
            if (sg.getGrupa() != null) {
                if (this.base.contains((Object)sgg)) {
                    this.base.detach((Object)sgg);
                }
                if ((sgg = (StalniGostiGrupa)em.find(StalniGostiGrupa.class, (Object)sgg.getId())) == null) {
                    throw new NullPointerException("Grupa stalnog gosta koji se azurira nije pronadjena u bazi");
                }
            }
            this.base.getTransaction().begin();
            this.base.persist((Object)sg);
            this.base.getTransaction().commit();
            this.base.refresh((Object)sg);
        }
        catch (Exception e) {
            if (this.base.getTransaction().isActive()) {
                this.base.getTransaction().rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom dodavanja stalnog gosta " + (sg != null ? sg.getNaziv() : ""), e);
        }
    }

    public void addStornoJPA(Storno storno) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (this.base.contains((Object)storno)) {
                this.base.detach((Object)storno);
            }
            for (StornoStavka ss : storno.getStavke()) {
                Artikal art = ss.getArtikal();
                if ((art = (Artikal)em.find(Artikal.class, (Object)art.getId())) == null) {
                    throw new Exception("Artikal sa ID = " + ss.getArtikal().getId() + "nije pronadjen u bazi prilikom unosa storna");
                }
                ss.setArtikal(art);
            }
            Konobar k = storno.getKonobar();
            Konobar nk = (Konobar)em.find(Konobar.class, (Object)k.getId());
            storno.setKonobar(nk);
            trans.begin();
            em.persist((Object)storno);
            trans.commit();
            this.base.refresh((Object)k);
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom unosa storna", e);
        }
        finally {
            em.close();
        }
    }

    public List<Tura> getNenaplacaneTureZaStoJPA(int brojStola) {
        TypedQuery qt = this.base.createQuery("SELECT t FROM Tura t WHERE t.brojStola = :bs AND t.racun IS NULL", Tura.class);
        qt.setParameter("bs", (Object)brojStola);
        List tl = qt.getResultList();
        LinkedList<Tura> retList = new LinkedList<Tura>();
        for (Tura tura : tl) {
            this.base.refresh((Object)tura);
            if (tura.getBrojStola() != brojStola || tura.getRacun() != null) continue;
            retList.add(tura);
        }
        return retList;
    }

    public void deleteListuTuraJPA(List<Tura> tl) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (!tl.isEmpty()) {
                trans.begin();
                for (Tura tura : tl) {
                    if (this.base.contains((Object)tura)) {
                        this.base.detach((Object)tura);
                    }
                    for (StavkaRacuna sr : tura.getStavke()) {
                        if (this.base.contains((Object)sr)) {
                            this.base.detach((Object)sr);
                        }
                        sr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
                        em.remove((Object)sr);
                    }
                    tura = (Tura)em.find(Tura.class, (Object)tura.getId());
                    em.remove((Object)tura);
                }
                trans.commit();
            }
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom brisanja ture", e);
        }
        finally {
            em.close();
        }
    }

    public void deleteTuraJPA(Tura tura) throws Exception {
        log.info(new Date() + "Brisanje ture broj " + tura.getId());
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            if (this.base.contains((Object)tura)) {
                this.base.detach((Object)tura);
                for (StavkaRacuna sr : tura.getStavke()) {
                    if (!this.base.contains((Object)sr)) continue;
                    this.base.detach((Object)sr);
                }
            }
            tura = (Tura)em.find(Tura.class, (Object)tura.getId());
            trans.begin();
            em.remove((Object)tura);
            for (StavkaRacuna sr : tura.getStavke()) {
                log.info(new Date() + "Brisanje stavke racuna broj " + sr.getId() + " -> " + sr.toString());
                em.remove((Object)sr);
                log.info(new Date() + "Obrisana stavka racuna broj " + sr.getId() + " -> " + sr.toString());
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom brisanja ture", e);
        }
        finally {
            em.close();
            log.info(new Date() + " tura obrisana ");
        }
    }

    public void deleteTuraJPA2(Tura t) {
        if (t == null) {
            return;
        }
        EntityManager em = this.base;
        EntityTransaction trans = em.getTransaction();
        if (!em.contains((Object)t)) {
            if ((t = (Tura)em.find(Tura.class, (Object)t.getId())) == null) {
                return;
            }
            trans.begin();
            em.remove((Object)t);
            trans.commit();
            if (this.base.contains((Object)t)) {
                this.base.detach((Object)t);
            }
        }
    }

    public void deleteStavkaRacunaJPA2(StavkaRacuna sr) throws Exception {
        log.info(new Date() + "Brisanje stavke racuna " + sr);
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            if (this.base.contains((Object)sr)) {
                this.base.detach((Object)sr);
            }
            sr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
            trans.begin();
            em.remove((Object)sr);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom brisanja stavke racuna " + sr, e);
        }
        finally {
            em.close();
            log.info(new Date() + " tura obrisana ");
        }
    }

    public StavkaRacuna updateStavkaRacunaJPA2(StavkaRacuna stavka) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            log.info("Izmena stavke racuna: " + stavka.toString());
            if (this.base.contains((Object)stavka)) {
                this.base.detach((Object)stavka);
            }
            trans.begin();
            stavka = (StavkaRacuna)em.merge((Object)stavka);
            trans.commit();
            log.info("Stavka racuna izmenjena");
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            log.log(Level.WARNING, "Stavka racuna nije izmenjena. Doslo je do greske ", e);
            throw new Exception("Stavka racuna nije izmenjena. Doslo je do greske", e);
        }
        finally {
            em.close();
        }
        return stavka;
    }

    public List<StavkaRacuna> getNenaplaceneStavkeJPA(int brojStola) {
        TypedQuery tq = this.base.createQuery("SELECT sr FROM StavkaRacuna sr WHERE sr.brojStola = :bs AND sr.racun IS NULL", null);
        tq.setParameter("bs", (Object)brojStola);
        List lsr = tq.getResultList();
        LinkedList<StavkaRacuna> list = new LinkedList<StavkaRacuna>();
        for (StavkaRacuna sr : lsr) {
            this.base.refresh((Object)sr);
            if (sr.getBrojStola() != brojStola || sr.getRacun() != null) continue;
            list.add(sr);
        }
        return list;
    }

    public void deleteListuStavkiRacuna(List<StavkaRacuna> lsr) throws Exception {
        EntityManager em = this.base.getEntityManagerFactory().createEntityManager();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            for (StavkaRacuna sr : lsr) {
                if (this.base.contains((Object)sr)) {
                    this.base.detach((Object)sr);
                }
                sr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
                em.remove((Object)sr);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Doslo je do greske prilikom brisanja liste stavki racuna ", e);
        }
    }

    public Double getStornoSum(Date dFrom, Date dTo, Konobar waiter) {
        Query tq = this.base.createNativeQuery("SELECT ROUND(COALESCE(SUM(ss.vrednost), 0), 2) FROM stornostavka ss LEFT JOIN storno s ON ss.STORNO_ID = s.id WHERE s.datum BETWEEN ? AND ? AND IF(? IS NULL, TRUE, s.KONOBAR_ID = ?) ;", Double.class);
        tq.setParameter(1, dFrom, TemporalType.TIMESTAMP);
        tq.setParameter(2, dTo, TemporalType.TIMESTAMP);
        tq.setParameter(3, (Object)(waiter == null ? null : waiter.getId()));
        tq.setParameter(4, (Object)(waiter == null ? null : waiter.getId()));
        Double ret = (Double)tq.getSingleResult();
        return ret;
    }

    public Integer getStornoCount(Date dFrom, Date dTo, Konobar waiter) {
        Query tq = this.base.createNativeQuery("SELECT COUNT(s.id) FROM storno s WHERE CAST(s.datum as DATE) BETWEEN ? AND ? AND IF(? IS NULL, TRUE, s.KONOBAR_ID = ?) ;", Integer.class);
        tq.setParameter(1, dFrom, TemporalType.TIMESTAMP);
        tq.setParameter(2, dTo, TemporalType.TIMESTAMP);
        tq.setParameter(3, (Object)(waiter == null ? null : waiter.getId()));
        tq.setParameter(4, (Object)(waiter == null ? null : waiter.getId()));
        Integer ret = (Integer)tq.getSingleResult();
        return ret;
    }

    public double vrednostFakture(Racun r) {
        Query query = this.base.createQuery("SELECT p.iznos FROM Placanje p WHERE p.racun = :r");
        query.setParameter("r", (Object)r);
        try {
            return (Double)query.getSingleResult();
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public List<Racun> findRacunDatumKomitent(Date fromDate, Date toDate, StalniGost sg, boolean n) {
        LinkedList<Racun> list = new LinkedList();
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        StringBuilder sb = new StringBuilder("SELECT DISTINCT r FROM Racun r LEFT JOIN r.knjizenja k").append(" WHERE r.brojFakture IS NOT NULL AND (r.datum BETWEEN :d1 AND :d2)");
        parameters.put("d1", fromDate);
        parameters.put("d2", toDate);
        if (n) {
            sb.append(" AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.racun = r AND k.realizovano = true)");
        }
        if (sg != null) {
            sb.append(" AND r.stalniGost = :SG");
            parameters.put("SG", sg);
        }
        TypedQuery tq = this.base.createQuery(sb.toString(), Racun.class);
        for (Map.Entry param : parameters.entrySet()) {
            String name = (String)param.getKey();
            Object value = param.getValue();
            tq.setParameter(name, value);
        }
        System.out.println("sb = " + tq.toString());
        list = tq.getResultList();
        return list;
    }

    public List<Trebovanje> findTrebovanjaDatumOdeljenjeStalniGost(Date fromDate, Date toDate, List<Odeljenje> fromDep, StalniGost supp, boolean n) {
        LinkedList<Trebovanje> list = new LinkedList();
        System.out.println(fromDep);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT DISTINCT t FROM Trebovanje t LEFT JOIN t.knjizenja k").append(" WHERE (t.datumTrebovanja BETWEEN :d1 AND :d2)");
        parameters.put("d1", fromDate);
        parameters.put("d2", toDate);
        if (n) {
            sb.append(" AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.trebovanje = t AND k.realizovano = true)");
        }
        if (!fromDep.isEmpty()) {
            sb.append(" AND t.u in :fromDep ");
            parameters.put("fromDep", fromDep);
        }
        if (supp != null) {
            sb.append(" AND t.dobavljac = :dobavljacSG");
            parameters.put("dobavljacSG", supp);
        }
        sb.append(" ORDER BY t.datumTrebovanja");
        System.out.println("sb = " + sb);
        TypedQuery tq = this.base.createQuery(sb.toString(), Trebovanje.class);
        for (Map.Entry param : parameters.entrySet()) {
            String name = (String)param.getKey();
            Object value = param.getValue();
            tq.setParameter(name, value);
        }
        list = tq.getResultList();
        return list;
    }

    public List<Trebovanje> findTrebovanja(Date fromDate, Date toDate, TipTrebovanja tip, boolean osnovno, boolean dodatno) {
        Query q = null;
        if (osnovno && dodatno) {
            q = this.base.createQuery("SELECT t from Trebovanje t where t.datumTrebovanja BETWEEN :d1 AND :d2 AND t.tip = :tip ");
            q.setParameter("d1", (Object)fromDate);
            q.setParameter("d2", (Object)toDate);
            q.setParameter("tip", (Object)tip);
        } else if (osnovno) {
            q = this.base.createQuery("SELECT t from Trebovanje t where t.datumTrebovanja BETWEEN :d1 AND :d2 AND t.tip = :tip AND t.crno = FALSE ");
            q.setParameter("d1", (Object)fromDate);
            q.setParameter("d2", (Object)toDate);
            q.setParameter("tip", (Object)tip);
        } else if (dodatno) {
            q = this.base.createQuery("SELECT t from Trebovanje t where t.datumTrebovanja BETWEEN :d1 AND :d2 AND t.tip = :tip AND t.crno = TRUE ");
            q.setParameter("d1", (Object)fromDate);
            q.setParameter("d2", (Object)toDate);
            q.setParameter("tip", (Object)tip);
        }
        return q.getResultList();
    }

    public List<Trebovanje> findTrebovanja(Date fromDate, Date toDate) {
        Query q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE t.datumTrebovanja BETWEEN :d1 AND :d2  ");
        q.setParameter("d1", (Object)fromDate);
        q.setParameter("d2", (Object)toDate);
        return q.getResultList();
    }

    public List<Prijemnica> findPrijemnica(Date fromDate, Date toDate) {
        Query q = this.base.createQuery("SELECT t FROM Prijemnica t WHERE t.datumPrijemnice BETWEEN :d1 AND :d2  ");
        q.setParameter("d1", (Object)fromDate);
        q.setParameter("d2", (Object)toDate);
        return q.getResultList();
    }

    public List<Trebovanje> findTrebovanja(Date fromDate, Date toDate, boolean useFromDep, Odeljenje fromDep, boolean useToDep, Odeljenje toDep, boolean useSupp, StalniGost supp, boolean white, boolean black, TipTrebovanja tip) {
        LinkedList<Trebovanje> list = new LinkedList();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT t FROM Trebovanje t").append(" WHERE (t.datumTrebovanja BETWEEN :d1 AND :d2)");
        parameters.put("d1", fromDate);
        parameters.put("d2", toDate);
        if (useFromDep) {
            if (fromDep != null) {
                sb.append(" AND t.iz = :izOd");
                parameters.put("izOd", fromDep);
            } else {
                sb.append(" AND t.iz IS NOT NULL");
            }
        } else {
            sb.append(" AND t.iz IS NULL");
        }
        if (useToDep) {
            if (toDep != null) {
                sb.append(" AND t.u = :uOd");
                parameters.put("uOd", toDep);
            } else {
                sb.append(" AND t.u IS NOT NULL");
            }
        } else {
            sb.append(" AND t.u IS NULL");
        }
        if (useSupp) {
            if (supp != null) {
                sb.append(" AND t.dobavljac = :dobavljacSG");
                parameters.put("dobavljacSG", supp);
            } else {
                sb.append(" AND t.dobavljac IS NOT NULL");
            }
        } else {
            sb.append(" AND t.dobavljac IS NULL");
        }
        if (white && !black) {
            sb.append(" AND t.crno = FALSE");
        } else if (!white && black) {
            sb.append(" AND t.crno = TRUE");
        }
        if (tip != null && tip.isNovi()) {
            sb.append(" AND t.tip = :tip");
            parameters.put("tip", (Object)tip);
        }
        System.out.println("sb = " + sb);
        TypedQuery tq = this.base.createQuery(sb.toString(), Trebovanje.class);
        for (Map.Entry param : parameters.entrySet()) {
            String name = (String)param.getKey();
            Object value = param.getValue();
            tq.setParameter(name, value);
        }
        list = tq.getResultList();
        return list;
    }

    public String selectNextTrebovanjeNumber(boolean crno, TipTrebovanja tip, Date datumTrebovanja) {
        Query q = this.base.createNativeQuery("SELECT COALESCE(MAX(CAST(SUBSTRING_INDEX(brtrebovanja,'/',1) AS SIGNED)) , 0) + 1 FROM trebovanje t WHERE t.crno = ? AND t.tip LIKE ? AND DATE_FORMAT(t.datumTrebovanja,'%Y') = ?;", Integer.class);
        Calendar c = Calendar.getInstance();
        c.setTime(datumTrebovanja);
        int yr = c.get(1);
        q.setParameter(1, (Object)crno);
        q.setParameter(2, (Object)tip.name());
        q.setParameter(3, (Object)yr);
        int nextNum = 0;
        try {
            Object o = q.getSingleResult();
            if (o instanceof Integer) {
                nextNum = (Integer)o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextNum + "/" + (crno ? yr + "-2" : Integer.valueOf(yr)) + "-" + tip.getDocMark();
    }

    public String selectNextPrijemnicaNumber(boolean crno, TipPrijemnice tip, Date datumTrebovanja) {
        Query q = this.base.createNativeQuery("SELECT COALESCE(MAX(CAST(SUBSTRING_INDEX(brprijemnice,'/',1) AS SIGNED)) , 0) + 1 FROM Prijemnica p WHERE p.crno = ? AND p.tip LIKE ? AND DATE_FORMAT(p.datumPrijemnice,'%Y') = ?;", Integer.class);
        Calendar c = Calendar.getInstance();
        c.setTime(datumTrebovanja);
        int yr = c.get(1);
        q.setParameter(1, (Object)crno);
        q.setParameter(2, (Object)tip.name());
        q.setParameter(3, (Object)yr);
        int nextNum = 0;
        try {
            Object o = q.getSingleResult();
            if (o instanceof Integer) {
                nextNum = (Integer)o;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return nextNum + "/" + (crno ? yr + "-2" : Integer.valueOf(yr)) + "-" + tip.getDocMark();
    }

    public void addTrebovanjeJPA(Trebovanje t) throws Exception {
        try {
            this.base.getTransaction().begin();
            this.base.persist((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom unosa trebovanja", e);
        }
    }

    public void addPrijemnicaJPAWithReconstruct(Prijemnica t) throws Exception {
        Date datum = t.getDatumPrijemnice();
        Date t0 = Konstante.getOnlyDate(datum);
        t.setDatumPrijemnice(t0);
        try {
            this.base.getTransaction().begin();
            this.base.persist((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom unosa dokumenta", e);
        }
    }

    public Trebovanje updateTrebovanjeJPAWithReconstruct(Trebovanje t, String oldDocument, String oldDocument2, List<TrebovanjeStavka> oldItems, Date oldDate, boolean oldBlack) throws Exception {
        DnevnoStanje ds;
        boolean mag;
        Artikal artikal;
        boolean bl;
        boolean crno = t.getCrno();
        Odeljenje magacin = this.returnMagacin();
        Date datum = t.getDatumTrebovanja();
        RestoranServer server = this;
        Date t00 = Konstante.getOnlyDate(oldDate);
        Date t0 = Konstante.getOnlyDate(datum);
        t.setDatumTrebovanja(t0);
        Date t11 = Konstante.getDatumKartica(datum, server, 11);
        Date t12 = Konstante.getDatumKartica(datum, server, 12);
        Date t19 = Konstante.getDatumKartica(datum, server, 19);
        Date t20 = Konstante.getDatumKartica(datum, server, 20);
        Date t21 = Konstante.getDatumKartica(datum, server, 21);
        Date t22 = Konstante.getDatumKartica(datum, server, 22);
        LinkedList<Long> oldIdList = new LinkedList<Long>();
        for (TrebovanjeStavka trebovanjeStavka : oldItems) {
            Artikal art = trebovanjeStavka.getArtikal();
            if (art == null) continue;
            oldIdList.add(art.getId());
        }
        LinkedList<Long> idList = new LinkedList<Long>();
        for (TrebovanjeStavka ts : t.getStavke()) {
            Artikal art = ts.getArtikal();
            if (art == null) continue;
            idList.add(art.getId());
        }
        boolean bl2 = false;
        if (t00.compareTo(t0) == 0) {
            bl = true;
        }
        System.out.println("sameDay = " + bl);
        if (bl) {
            oldIdList.addAll(idList);
        }
        List<Object> oldKTList = oldDocument == null ? new LinkedList() : this.findKarticaForDokument(oldDocument);
        List<Object> oldKPList = oldDocument2 == null ? new LinkedList() : this.findKarticaForDokument(oldDocument2);
        LinkedList<Kartica> kpList = new LinkedList<Kartica>();
        Map<Object, Object> mapaOldIzlaz = new HashMap();
        Map<Object, Object> mapaOldUlaz = new HashMap();
        Map<Object, Object> mapaIzlaz = new HashMap();
        Map<Object, Object> mapaUlaz = new HashMap();
        if (t.getU() != null) {
            mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, t.getU(), t00);
            mapaUlaz = bl ? mapaOldUlaz : this.findDnevnoStanjeByArtikalOdeljenjeDatum(idList, t.getU(), t0);
        }
        if (t.getIz() != null) {
            mapaOldIzlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, t.getIz(), t00);
            mapaIzlaz = bl ? mapaOldIzlaz : this.findDnevnoStanjeByArtikalOdeljenjeDatum(idList, t.getIz(), t0);
        }
        for (TrebovanjeStavka trebovanjeStavka : oldItems) {
            artikal = trebovanjeStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getU() != null) {
                boolean bl3 = mag = magacin != null && t.getU().getId() == magacin.getId();
                if (mapaOldUlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t00);
                    ds.setOdeljenje(t.getU());
                }
                if (oldBlack) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() - trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() - trebovanjeStavka.getKolicina());
                }
                if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                    if (oldBlack) {
                        ds.setCrnoIzlaz(ds.getCrnoIzlaz() - trebovanjeStavka.getKolicina());
                    } else {
                        ds.setBeloIzlaz(ds.getBeloIzlaz() - trebovanjeStavka.getKolicina());
                    }
                }
                mapaOldUlaz.put(artikal.getId(), ds);
            }
            if (t.getIz() == null) continue;
            boolean bl4 = mag = magacin != null && t.getIz().getId() == magacin.getId();
            if (mapaOldIzlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaOldIzlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t00);
                ds.setOdeljenje(t.getIz());
            }
            if (oldBlack) {
                ds.setCrnoIzlaz(ds.getCrnoIzlaz() - trebovanjeStavka.getKolicina());
            } else {
                ds.setBeloIzlaz(ds.getBeloIzlaz() - trebovanjeStavka.getKolicina());
            }
            if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                if (oldBlack) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() - trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() - trebovanjeStavka.getKolicina());
                }
            }
            mapaOldIzlaz.put(artikal.getId(), ds);
        }
        for (TrebovanjeStavka trebovanjeStavka : t.getStavke()) {
            Kartica kp;
            Prijemnica prijemnica;
            PrijemnicaStavka ps;
            Kartica k;
            artikal = trebovanjeStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getU() != null) {
                boolean bl5 = mag = magacin != null && t.getU().getId() == magacin.getId();
                if (mapaUlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaUlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t0);
                    ds.setOdeljenje(t.getU());
                }
                if (crno) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() + trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() + trebovanjeStavka.getKolicina());
                }
                k = new Kartica();
                k.setArtikal(artikal);
                k.setCrno(crno);
                k.setDatum(mag || crno ? t22 : t20);
                k.setDokument(t.getBrTrebovanja());
                k.setKolicina(trebovanjeStavka.getKolicina());
                k.setNabavnaCena(trebovanjeStavka.getKomad());
                k.setOdeljenje(t.getU());
                kpList.add(k);
                if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                    ps = trebovanjeStavka.getStavkaPrijemnice();
                    prijemnica = t.getPrijemnica();
                    if (crno) {
                        ds.setCrnoIzlaz(ds.getCrnoIzlaz() + trebovanjeStavka.getKolicina());
                    } else {
                        ds.setBeloIzlaz(ds.getBeloIzlaz() + trebovanjeStavka.getKolicina());
                    }
                    kp = new Kartica();
                    kp.setArtikal(artikal);
                    kp.setCrno(crno);
                    kp.setDatum(crno ? t12 : t11);
                    kp.setDokument(prijemnica.getBrPrijemnice());
                    kp.setKolicina(ps.getKolicina());
                    kp.setNabavnaCena(ps.getKomad());
                    kp.setOdeljenje(magacin);
                    kpList.add(kp);
                }
                mapaUlaz.put(artikal.getId(), ds);
            }
            if (t.getIz() == null) continue;
            boolean bl6 = mag = magacin != null && t.getIz().getId() == magacin.getId();
            if (mapaIzlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaIzlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t0);
                ds.setOdeljenje(t.getIz());
            }
            if (crno) {
                ds.setCrnoIzlaz(ds.getCrnoIzlaz() + trebovanjeStavka.getKolicina());
            } else {
                ds.setBeloIzlaz(ds.getBeloIzlaz() + trebovanjeStavka.getKolicina());
            }
            k = new Kartica();
            k.setArtikal(artikal);
            k.setCrno(crno);
            k.setDatum(mag || crno ? t21 : t19);
            k.setDokument(t.getBrTrebovanja());
            k.setKolicina(-trebovanjeStavka.getKolicina().doubleValue());
            k.setNabavnaCena(trebovanjeStavka.getKomad());
            k.setOdeljenje(t.getIz());
            kpList.add(k);
            if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                ps = trebovanjeStavka.getStavkaPrijemnice();
                prijemnica = t.getPrijemnica();
                if (crno) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() + trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() + trebovanjeStavka.getKolicina());
                }
                kp = new Kartica();
                kp.setArtikal(artikal);
                kp.setCrno(crno);
                kp.setDatum(crno ? t12 : t11);
                kp.setDokument(prijemnica.getBrPrijemnice());
                kp.setKolicina(ps.getKolicina());
                kp.setNabavnaCena(ps.getKomad());
                kp.setOdeljenje(magacin);
                kpList.add(kp);
            }
            mapaIzlaz.put(artikal.getId(), ds);
        }
        try {
            DnevnoStanje ds2;
            this.base.getTransaction().begin();
            for (Kartica kartica : oldKPList) {
                this.base.remove((Object)kartica);
            }
            for (Kartica kartica : oldKTList) {
                this.base.remove((Object)kartica);
            }
            if (!bl) {
                for (Map.Entry entry : mapaOldUlaz.entrySet()) {
                    DnevnoStanje ds22 = (DnevnoStanje)entry.getValue();
                    if (ds22.getId() != null) {
                        ds22 = (DnevnoStanje)this.base.merge((Object)ds22);
                        continue;
                    }
                    this.base.persist((Object)ds22);
                }
                for (Map.Entry entry : mapaOldIzlaz.entrySet()) {
                    ds2 = (DnevnoStanje)entry.getValue();
                    if (ds2.getId() != null) {
                        ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                        continue;
                    }
                    this.base.persist((Object)ds2);
                }
            }
            for (TrebovanjeStavka trebovanjeStavka : t.getStavke()) {
                if (trebovanjeStavka.getId() != null) continue;
                this.base.persist((Object)trebovanjeStavka);
            }
            t = (Trebovanje)this.base.merge((Object)t);
            for (Map.Entry entry : mapaUlaz.entrySet()) {
                ds2 = (DnevnoStanje)entry.getValue();
                if (ds2.getId() != null) {
                    ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                    continue;
                }
                this.base.persist((Object)ds2);
            }
            for (Map.Entry entry : mapaIzlaz.entrySet()) {
                ds2 = (DnevnoStanje)entry.getValue();
                if (ds2.getId() != null) {
                    ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                    continue;
                }
                this.base.persist((Object)ds2);
            }
            for (Kartica kartica : kpList) {
                this.base.persist((Object)kartica);
            }
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom izmene dokumenta", e);
        }
        return t;
    }

    public Prijemnica updatePrijemnicaJPAWithReconstruct(Prijemnica t, String oldDocument, List<PrijemnicaStavka> oldItems, Date oldDate, boolean oldBlack) throws Exception {
        DnevnoStanje ds;
        Artikal artikal;
        boolean bl;
        boolean crno = t.getCrno();
        Odeljenje magacin = this.returnMagacin();
        Date datum = t.getDatumPrijemnice();
        RestoranServer server = this;
        Date t00 = Konstante.getOnlyDate(oldDate);
        Date t0 = Konstante.getOnlyDate(datum);
        t.setDatumPrijemnice(t0);
        Date t11 = Konstante.getDatumKartica(datum, server, 11);
        Date t12 = Konstante.getDatumKartica(datum, server, 12);
        LinkedList<Long> oldIdList = new LinkedList<Long>();
        for (PrijemnicaStavka prijemnicaStavka : oldItems) {
            Artikal art = prijemnicaStavka.getArtikal();
            if (art == null) continue;
            oldIdList.add(art.getId());
        }
        LinkedList<Long> idList = new LinkedList<Long>();
        for (PrijemnicaStavka ts : t.getStavke()) {
            Artikal art = ts.getArtikal();
            if (art == null) continue;
            idList.add(art.getId());
        }
        boolean bl2 = false;
        if (t00.compareTo(t0) == 0) {
            bl = true;
        }
        System.out.println("sameDay = " + bl);
        if (bl) {
            oldIdList.addAll(idList);
        }
        List<Object> oldKPList = oldDocument == null ? new LinkedList() : this.findKarticaForDokument(oldDocument);
        LinkedList<Kartica> kpList = new LinkedList<Kartica>();
        Map<Object, Object> mapaOldIzlaz = new HashMap();
        Map<Object, Object> mapaOldUlaz = new HashMap();
        Map<Object, Object> mapaIzlaz = new HashMap();
        Map<Object, Object> mapaUlaz = new HashMap();
        if (t.getTip() != null) {
            if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t00);
                mapaUlaz = bl ? mapaOldUlaz : this.findDnevnoStanjeByArtikalOdeljenjeDatum(idList, magacin, t0);
            }
            if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.IZLAZNI) {
                mapaOldIzlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t00);
                mapaIzlaz = bl ? mapaOldIzlaz : this.findDnevnoStanjeByArtikalOdeljenjeDatum(idList, magacin, t0);
            }
        } else {
            mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t00);
            mapaUlaz = bl ? mapaOldUlaz : this.findDnevnoStanjeByArtikalOdeljenjeDatum(idList, magacin, t0);
        }
        for (PrijemnicaStavka prijemnicaStavka : oldItems) {
            artikal = prijemnicaStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getTip() != null) {
                if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                    if (mapaOldUlaz.containsKey(artikal.getId())) {
                        ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
                    } else {
                        ds = new DnevnoStanje();
                        ds.setArtikal(artikal.getName());
                        ds.setArtikalID(artikal.getId());
                        ds.setBeloIzlaz(0.0);
                        ds.setBeloUlaz(0.0);
                        ds.setCrnoIzlaz(0.0);
                        ds.setCrnoUlaz(0.0);
                        ds.setDatum(t00);
                        ds.setOdeljenje(magacin);
                    }
                    if (oldBlack) {
                        ds.setCrnoUlaz(ds.getCrnoUlaz() - prijemnicaStavka.getKolicina());
                    } else {
                        ds.setBeloUlaz(ds.getBeloUlaz() - prijemnicaStavka.getKolicina());
                    }
                }
                if (t.getTip().getTip() != TipTrebovanja.DokumentAtribut.IZLAZNI) continue;
                if (mapaOldIzlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaOldIzlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t00);
                    ds.setOdeljenje(magacin);
                }
                if (oldBlack) {
                    ds.setCrnoIzlaz(ds.getCrnoIzlaz() - prijemnicaStavka.getKolicina());
                } else {
                    ds.setBeloIzlaz(ds.getBeloIzlaz() - prijemnicaStavka.getKolicina());
                }
                mapaOldIzlaz.put(artikal.getId(), ds);
                continue;
            }
            if (mapaOldUlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t00);
                ds.setOdeljenje(magacin);
            }
            if (oldBlack) {
                ds.setCrnoUlaz(ds.getCrnoUlaz() - prijemnicaStavka.getKolicina());
                continue;
            }
            ds.setBeloUlaz(ds.getBeloUlaz() - prijemnicaStavka.getKolicina());
        }
        for (PrijemnicaStavka prijemnicaStavka : t.getStavke()) {
            Kartica kp;
            artikal = prijemnicaStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getTip() != null) {
                if (t.getTip() == TipPrijemnice.PRIJEMNICA) {
                    if (mapaUlaz.containsKey(artikal.getId())) {
                        ds = (DnevnoStanje)mapaUlaz.get(artikal.getId());
                    } else {
                        ds = new DnevnoStanje();
                        ds.setArtikal(artikal.getName());
                        ds.setArtikalID(artikal.getId());
                        ds.setBeloIzlaz(0.0);
                        ds.setBeloUlaz(0.0);
                        ds.setCrnoIzlaz(0.0);
                        ds.setCrnoUlaz(0.0);
                        ds.setDatum(t0);
                        ds.setOdeljenje(magacin);
                    }
                    if (crno) {
                        ds.setCrnoUlaz(ds.getCrnoUlaz() + prijemnicaStavka.getKolicina());
                    } else {
                        ds.setBeloUlaz(ds.getBeloUlaz() + prijemnicaStavka.getKolicina());
                    }
                    kp = new Kartica();
                    kp.setArtikal(artikal);
                    kp.setCrno(crno);
                    kp.setDatum(crno ? t12 : t11);
                    kp.setDokument(t.getBrPrijemnice());
                    kp.setKolicina(prijemnicaStavka.getKolicina());
                    kp.setNabavnaCena(prijemnicaStavka.getKomadSPDV());
                    kp.setOdeljenje(magacin);
                    kpList.add(kp);
                    mapaUlaz.put(artikal.getId(), ds);
                }
                if (t.getTip() == TipPrijemnice.POVRATNICA) {
                    if (mapaIzlaz.containsKey(artikal.getId())) {
                        ds = (DnevnoStanje)mapaIzlaz.get(artikal.getId());
                    } else {
                        ds = new DnevnoStanje();
                        ds.setArtikal(artikal.getName());
                        ds.setArtikalID(artikal.getId());
                        ds.setBeloIzlaz(0.0);
                        ds.setBeloUlaz(0.0);
                        ds.setCrnoIzlaz(0.0);
                        ds.setCrnoUlaz(0.0);
                        ds.setDatum(t0);
                        ds.setOdeljenje(magacin);
                    }
                    if (crno) {
                        ds.setCrnoIzlaz(ds.getCrnoIzlaz() + prijemnicaStavka.getKolicina());
                    } else {
                        ds.setBeloIzlaz(ds.getBeloIzlaz() + prijemnicaStavka.getKolicina());
                    }
                    kp = new Kartica();
                    kp.setArtikal(artikal);
                    kp.setCrno(crno);
                    kp.setDatum(crno ? t12 : t11);
                    kp.setDokument(t.getBrPrijemnice());
                    kp.setKolicina(prijemnicaStavka.getKolicina());
                    kp.setNabavnaCena(prijemnicaStavka.getKomadSPDV());
                    kp.setOdeljenje(magacin);
                    kpList.add(kp);
                    mapaIzlaz.put(artikal.getId(), ds);
                }
                if (t.getTip() != TipPrijemnice.OTPREMNICA) continue;
                if (mapaIzlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaIzlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t0);
                    ds.setOdeljenje(magacin);
                }
                if (crno) {
                    ds.setCrnoIzlaz(ds.getCrnoIzlaz() + prijemnicaStavka.getKolicina());
                } else {
                    ds.setBeloIzlaz(ds.getBeloIzlaz() + prijemnicaStavka.getKolicina());
                }
                kp = new Kartica();
                kp.setArtikal(artikal);
                kp.setCrno(crno);
                kp.setDatum(crno ? t12 : t11);
                kp.setDokument(t.getBrPrijemnice());
                kp.setKolicina(prijemnicaStavka.getKolicina());
                kp.setNabavnaCena(prijemnicaStavka.getKomadSPDV());
                kp.setOdeljenje(magacin);
                kpList.add(kp);
                mapaIzlaz.put(artikal.getId(), ds);
                continue;
            }
            if (mapaUlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaUlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t0);
                ds.setOdeljenje(magacin);
            }
            if (crno) {
                ds.setCrnoUlaz(ds.getCrnoUlaz() + prijemnicaStavka.getKolicina());
            } else {
                ds.setBeloUlaz(ds.getBeloUlaz() + prijemnicaStavka.getKolicina());
            }
            kp = new Kartica();
            kp.setArtikal(artikal);
            kp.setCrno(crno);
            kp.setDatum(crno ? t12 : t11);
            kp.setDokument(t.getBrPrijemnice());
            kp.setKolicina(prijemnicaStavka.getKolicina());
            kp.setNabavnaCena(prijemnicaStavka.getKomadSPDV());
            kp.setOdeljenje(magacin);
            kpList.add(kp);
            mapaUlaz.put(artikal.getId(), ds);
        }
        try {
            DnevnoStanje ds2;
            this.base.getTransaction().begin();
            for (Kartica kartica : oldKPList) {
                this.base.remove((Object)kartica);
            }
            if (!bl) {
                for (Map.Entry entry : mapaOldUlaz.entrySet()) {
                    DnevnoStanje ds22 = (DnevnoStanje)entry.getValue();
                    if (ds22.getId() != null) {
                        ds22 = (DnevnoStanje)this.base.merge((Object)ds22);
                        continue;
                    }
                    this.base.persist((Object)ds22);
                }
                for (Map.Entry entry : mapaOldIzlaz.entrySet()) {
                    ds2 = (DnevnoStanje)entry.getValue();
                    if (ds2.getId() != null) {
                        ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                        continue;
                    }
                    this.base.persist((Object)ds2);
                }
            }
            t = (Prijemnica)this.base.merge((Object)t);
            for (Map.Entry entry : mapaUlaz.entrySet()) {
                ds2 = (DnevnoStanje)entry.getValue();
                if (ds2.getId() != null) {
                    ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                    continue;
                }
                this.base.persist((Object)ds2);
            }
            for (Map.Entry entry : mapaIzlaz.entrySet()) {
                ds2 = (DnevnoStanje)entry.getValue();
                if (ds2.getId() != null) {
                    ds2 = (DnevnoStanje)this.base.merge((Object)ds2);
                    continue;
                }
                this.base.persist((Object)ds2);
            }
            for (Kartica kartica : kpList) {
                this.base.persist((Object)kartica);
            }
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom izmene dokumenta", e);
        }
        return t;
    }

    public Map<Long, DnevnoStanje> findDnevnoStanjeByArtikalOdeljenjeDatum(List<Long> aIDList, Odeljenje o, Date d) {
        TypedQuery tq = this.base.createQuery("SELECT ds FROM DnevnoStanje ds WHERE ds.artikalID IN :artIDs AND ds.odeljenje = :od AND ds.datum = :dat", DnevnoStanje.class);
        tq.setParameter("artIDs", aIDList);
        tq.setParameter("od", (Object)o);
        tq.setParameter("dat", d, TemporalType.DATE);
        List dsList = tq.getResultList();
        HashMap<Long, DnevnoStanje> map = new HashMap<Long, DnevnoStanje>();
        for (DnevnoStanje ds : dsList) {
            map.put(ds.getId(), ds);
        }
        return map;
    }

    public List<Kartica> findKarticaForDokument(String dokument) {
        TypedQuery tq = this.base.createQuery("SELECT k FROM Kartica k WHERE k.dokument = :dokument", Kartica.class);
        tq.setParameter("dokument", (Object)dokument);
        return tq.getResultList();
    }

    public void deleteTrebovanjeJPAWithReconstruct(Trebovanje t) throws Exception {
        boolean crno = t.getCrno();
        Odeljenje magacin = this.returnMagacin();
        Date datum = t.getDatumTrebovanja();
        RestoranServer server = this;
        Date t0 = Konstante.getOnlyDate(datum);
        t.setDatumTrebovanja(t0);
        Date t11 = Konstante.getDatumKartica(datum, server, 11);
        Date t12 = Konstante.getDatumKartica(datum, server, 12);
        Date t19 = Konstante.getDatumKartica(datum, server, 19);
        Date t20 = Konstante.getDatumKartica(datum, server, 20);
        Date t21 = Konstante.getDatumKartica(datum, server, 21);
        Date t22 = Konstante.getDatumKartica(datum, server, 22);
        LinkedList<Long> oldIdList = new LinkedList<Long>();
        for (TrebovanjeStavka ts : t.getStavke()) {
            Artikal art = ts.getArtikal();
            if (art == null) continue;
            oldIdList.add(art.getId());
        }
        String oldDocument = null;
        String oldDocument2 = null;
        oldDocument = t.getTip() == null ? t.getBrTrebovanja() + " (tk)" : t.getBrTrebovanja();
        if (t.getPrijemnica() != null) {
            oldDocument2 = t.getPrijemnica().getBrPrijemnice();
        }
        List<Object> oldKTList = oldDocument == null ? new LinkedList() : this.findKarticaForDokument(oldDocument);
        List<Object> oldKPList = oldDocument2 == null ? new LinkedList() : this.findKarticaForDokument(oldDocument2);
        Map<Object, Object> mapaOldIzlaz = new HashMap();
        Map<Object, Object> mapaOldUlaz = new HashMap();
        if (t.getU() != null) {
            mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, t.getU(), t0);
        }
        if (t.getIz() != null) {
            mapaOldIzlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, t.getIz(), t0);
        }
        for (TrebovanjeStavka trebovanjeStavka : t.getStavke()) {
            DnevnoStanje ds;
            boolean mag;
            Artikal artikal = trebovanjeStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getU() != null) {
                boolean bl = mag = magacin != null && t.getU().getId() == magacin.getId();
                if (mapaOldUlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t0);
                    ds.setOdeljenje(t.getU());
                }
                if (crno) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() - trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() - trebovanjeStavka.getKolicina());
                }
                if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                    if (crno) {
                        ds.setCrnoIzlaz(ds.getCrnoIzlaz() - trebovanjeStavka.getKolicina());
                    } else {
                        ds.setBeloIzlaz(ds.getBeloIzlaz() - trebovanjeStavka.getKolicina());
                    }
                }
                mapaOldUlaz.put(artikal.getId(), ds);
            }
            if (t.getIz() == null) continue;
            boolean bl = mag = magacin != null && t.getIz().getId() == magacin.getId();
            if (mapaOldIzlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaOldIzlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t0);
                ds.setOdeljenje(t.getIz());
            }
            if (crno) {
                ds.setCrnoIzlaz(ds.getCrnoIzlaz() - trebovanjeStavka.getKolicina());
            } else {
                ds.setBeloIzlaz(ds.getBeloIzlaz() - trebovanjeStavka.getKolicina());
            }
            if (trebovanjeStavka.getStavkaPrijemnice() != null && mag) {
                if (crno) {
                    ds.setCrnoUlaz(ds.getCrnoUlaz() - trebovanjeStavka.getKolicina());
                } else {
                    ds.setBeloUlaz(ds.getBeloUlaz() - trebovanjeStavka.getKolicina());
                }
            }
            mapaOldIzlaz.put(artikal.getId(), ds);
        }
        try {
            DnevnoStanje ds;
            this.base.getTransaction().begin();
            for (Kartica kartica : oldKPList) {
                this.base.remove((Object)kartica);
            }
            for (Kartica kartica : oldKTList) {
                this.base.remove((Object)kartica);
            }
            for (Map.Entry entry : mapaOldUlaz.entrySet()) {
                ds = (DnevnoStanje)entry.getValue();
                if (ds.getId() != null) {
                    ds = (DnevnoStanje)this.base.merge((Object)ds);
                    continue;
                }
                this.base.persist((Object)ds);
            }
            for (Map.Entry entry : mapaOldIzlaz.entrySet()) {
                ds = (DnevnoStanje)entry.getValue();
                if (ds.getId() != null) {
                    ds = (DnevnoStanje)this.base.merge((Object)ds);
                    continue;
                }
                this.base.persist((Object)ds);
            }
            this.base.remove((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom izmene dokumenta", e);
        }
    }

    public String selectNextSifra() {
        Query q = this.base.createNativeQuery("SELECT COALESCE(MAX(CAST(sifra AS SIGNED)) , 0) + 1 FROM Artikal;", Integer.class);
        int nextNum = 0;
        try {
            Object o = q.getSingleResult();
            if (o instanceof Integer) {
                nextNum = (Integer)o;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return "" + nextNum;
    }

    public List<Prijemnica> findPrijemnice(Date fromDate, Date toDate, StalniGost supp, boolean white, boolean black, TipPrijemnice tip) {
        LinkedList<Prijemnica> list = new LinkedList();
        System.out.println("fromDate = " + fromDate);
        System.out.println("toDate = " + toDate);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT p FROM Prijemnica p").append(" WHERE (p.datumPrijemnice BETWEEN :d1 AND :d2)");
        parameters.put("d1", fromDate);
        parameters.put("d2", toDate);
        if (supp != null) {
            sb.append(" AND p.dobavljac = :dobavljacSG");
            parameters.put("dobavljacSG", supp);
        } else {
            sb.append(" AND p.dobavljac IS NOT NULL");
        }
        if (white && !black) {
            sb.append(" AND p.crno = FALSE");
        } else if (!white && black) {
            sb.append(" AND p.crno = TRUE");
        }
        if (tip != null) {
            if (tip == TipPrijemnice.PRIJEMNICA) {
                sb.append(" AND (p.tip = :tip OR p.tip IS NULL)");
            } else {
                sb.append(" AND p.tip = :tip");
            }
            parameters.put("tip", (Object)tip);
        }
        TypedQuery tq = this.base.createQuery(sb.toString(), Prijemnica.class);
        for (Map.Entry param : parameters.entrySet()) {
            String name = (String)param.getKey();
            Object value = param.getValue();
            tq.setParameter(name, value);
        }
        list = tq.getResultList();
        return list;
    }

    public void deletePrijemnicaJPAWithReconstruct(Prijemnica t) throws Exception {
        boolean crno = t.getCrno();
        Odeljenje magacin = this.returnMagacin();
        Date datum = t.getDatumPrijemnice();
        RestoranServer server = this;
        Date t0 = Konstante.getOnlyDate(datum);
        t.setDatumPrijemnice(t0);
        LinkedList<Long> oldIdList = new LinkedList<Long>();
        for (PrijemnicaStavka ts : t.getStavke()) {
            Artikal art = ts.getArtikal();
            if (art == null) continue;
            oldIdList.add(art.getId());
        }
        String oldDocument = null;
        oldDocument = t.getTip() == null ? t.getBrPrijemnice() + " (p)" : t.getBrPrijemnice();
        List<Object> oldKPList = oldDocument == null ? new LinkedList() : this.findKarticaForDokument(oldDocument);
        Map<Object, Object> mapaOldIzlaz = new HashMap();
        Map<Object, Object> mapaOldUlaz = new HashMap();
        if (t.getTip() != null) {
            if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t0);
            }
            if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.IZLAZNI) {
                mapaOldIzlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t0);
            }
        } else {
            mapaOldUlaz = this.findDnevnoStanjeByArtikalOdeljenjeDatum(oldIdList, magacin, t0);
        }
        for (PrijemnicaStavka prijemnicaStavka : t.getStavke()) {
            DnevnoStanje ds;
            Artikal artikal = prijemnicaStavka.getArtikal();
            if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.SIRO && artikal.getTip() != TipArtikla.POLU) continue;
            if (t.getTip() != null) {
                if (t.getTip().getTip() == TipTrebovanja.DokumentAtribut.ULAZNI) {
                    if (mapaOldUlaz.containsKey(artikal.getId())) {
                        ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
                    } else {
                        ds = new DnevnoStanje();
                        ds.setArtikal(artikal.getName());
                        ds.setArtikalID(artikal.getId());
                        ds.setBeloIzlaz(0.0);
                        ds.setBeloUlaz(0.0);
                        ds.setCrnoIzlaz(0.0);
                        ds.setCrnoUlaz(0.0);
                        ds.setDatum(t0);
                        ds.setOdeljenje(magacin);
                    }
                    if (crno) {
                        ds.setCrnoUlaz(ds.getCrnoUlaz() - prijemnicaStavka.getKolicina());
                    } else {
                        ds.setBeloUlaz(ds.getBeloUlaz() - prijemnicaStavka.getKolicina());
                    }
                    mapaOldUlaz.put(artikal.getId(), ds);
                }
                if (t.getTip().getTip() != TipTrebovanja.DokumentAtribut.IZLAZNI) continue;
                if (mapaOldIzlaz.containsKey(artikal.getId())) {
                    ds = (DnevnoStanje)mapaOldIzlaz.get(artikal.getId());
                } else {
                    ds = new DnevnoStanje();
                    ds.setArtikal(artikal.getName());
                    ds.setArtikalID(artikal.getId());
                    ds.setBeloIzlaz(0.0);
                    ds.setBeloUlaz(0.0);
                    ds.setCrnoIzlaz(0.0);
                    ds.setCrnoUlaz(0.0);
                    ds.setDatum(t0);
                    ds.setOdeljenje(magacin);
                }
                if (crno) {
                    ds.setCrnoIzlaz(ds.getCrnoIzlaz() - prijemnicaStavka.getKolicina());
                } else {
                    ds.setBeloIzlaz(ds.getBeloIzlaz() - prijemnicaStavka.getKolicina());
                }
                mapaOldIzlaz.put(artikal.getId(), ds);
                continue;
            }
            if (mapaOldUlaz.containsKey(artikal.getId())) {
                ds = (DnevnoStanje)mapaOldUlaz.get(artikal.getId());
            } else {
                ds = new DnevnoStanje();
                ds.setArtikal(artikal.getName());
                ds.setArtikalID(artikal.getId());
                ds.setBeloIzlaz(0.0);
                ds.setBeloUlaz(0.0);
                ds.setCrnoIzlaz(0.0);
                ds.setCrnoUlaz(0.0);
                ds.setDatum(t0);
                ds.setOdeljenje(magacin);
            }
            if (crno) {
                ds.setCrnoUlaz(ds.getCrnoUlaz() - prijemnicaStavka.getKolicina());
                continue;
            }
            ds.setBeloUlaz(ds.getBeloUlaz() - prijemnicaStavka.getKolicina());
        }
        try {
            DnevnoStanje ds;
            this.base.getTransaction().begin();
            for (Kartica kartica : oldKPList) {
                this.base.remove((Object)kartica);
            }
            for (Map.Entry entry : mapaOldUlaz.entrySet()) {
                ds = (DnevnoStanje)entry.getValue();
                if (ds.getId() != null) {
                    ds = (DnevnoStanje)this.base.merge((Object)ds);
                    continue;
                }
                this.base.persist((Object)ds);
            }
            for (Map.Entry entry : mapaOldIzlaz.entrySet()) {
                ds = (DnevnoStanje)entry.getValue();
                if (ds.getId() != null) {
                    ds = (DnevnoStanje)this.base.merge((Object)ds);
                    continue;
                }
                this.base.persist((Object)ds);
            }
            this.base.remove((Object)t);
            this.base.getTransaction().commit();
        }
        catch (Exception e) {
            this.base.getTransaction().rollback();
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom izmene dokumenta", e);
        }
    }

    public List<Tura> updateTuraRastavljanje(List<Tura> ture, List<StavkaRacuna> stavkeZaBrisanje, Sto stoZaBrisanje) throws Exception {
        LinkedList<Tura> retList = new LinkedList<Tura>();
        EntityManager em = this.base;
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            if (stoZaBrisanje != null) {
                if (!em.equals(this.base) && this.base.contains((Object)stoZaBrisanje)) {
                    this.base.detach((Object)stoZaBrisanje);
                }
                em.remove((Object)stoZaBrisanje);
            }
            Tura temp = null;
            for (Tura tura : ture) {
                if (!em.equals(this.base) && this.base.contains((Object)tura)) {
                    this.base.detach((Object)tura);
                }
                LinkedList<StavkaRacuna> list = new LinkedList<StavkaRacuna>(tura.getStavke());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                if (tura.getId() == null) {
                    em.persist((Object)tura);
                } else {
                    if (!em.contains((Object)tura)) {
                        Tura tempTura = (Tura)em.find(Tura.class, (Object)tura.getId());
                        tempTura.setBrojStola(tura.getBrojStola());
                        tempTura.setBrojTure(tura.getBrojTure());
                        tempTura.setDatum(temp.getDatum());
                        tempTura.setPripremljena(temp.isPripremljena());
                        tempTura.setRacun(temp.getRacun());
                        tempTura.setStavke(tura.getStavke());
                        tempTura.setuPripremi(temp.isuPripremi());
                        tura = tempTura;
                    }
                    temp = tura;
                    tura = (Tura)em.merge((Object)tura);
                }
                for (StavkaRacuna sr : list) {
                    if (!em.equals(this.base) && this.base.contains((Object)sr)) {
                        this.base.detach((Object)sr);
                    }
                    sr.setTura(tura);
                    Artikal art = sr.getArtikal();
                    if (!em.contains((Object)art)) {
                        art = (Artikal)em.find(Artikal.class, (Object)art.getId());
                    }
                    art.setCena(this.getArtikalCena(art.getId()));
                    sr.setArtikal(art);
                    if (sr.getId() == null) {
                        em.persist((Object)sr);
                    } else {
                        if (!em.contains((Object)sr)) {
                            StavkaRacuna tempSr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
                            tempSr.setArtikal(sr.getArtikal());
                            tempSr.setBrojStola(sr.getBrojStola());
                            tempSr.setCena(sr.getCena());
                            tempSr.setKolicina(sr.getKolicina());
                            tempSr.setNaziv(sr.getNaziv());
                            tempSr.setRacun(sr.getRacun());
                            tempSr.setTura(sr.getTura());
                            sr = tempSr;
                        }
                        sr = (StavkaRacuna)em.merge((Object)sr);
                    }
                    tura.getStavke().add(sr);
                }
                tura = (Tura)em.merge((Object)tura);
                for (StavkaRacuna sr : stavkeZaBrisanje) {
                    if (!em.equals(this.base) && this.base.contains((Object)sr)) {
                        this.base.detach((Object)sr);
                    }
                    em.remove((Object)sr);
                }
                retList.add(tura);
            }
            trans.commit();
            if (em.equals(this.base)) {
                for (Tura tura : retList) {
                    if (!em.contains((Object)tura)) continue;
                    em.refresh((Object)tura);
                }
            }
            Iterator iterator = retList;
            return iterator;
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom a\u017euriranja rastavljenih tura", e);
        }
        finally {
            if (em != this.base) {
                em.close();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Racun makeRacunUpdateTureRastavljanje(Racun r, List<Tura> tureUpdate, List<Tura> tureRacun, List<StavkaRacuna> stavkeZaBrisanje, Sto stoZaBrisanje) throws Exception {
        log.entering(RestoranServer.class.getName(), "makeRacunUpdateTureRastavljanje");
        LinkedList<Tura> retList = new LinkedList<Tura>();
        EntityManager em = this.base;
        EntityTransaction trans = em.getTransaction();
        try {
            void var10_21;
            trans.begin();
            if (stoZaBrisanje != null) {
                if (!em.equals(this.base) && this.base.contains((Object)stoZaBrisanje)) {
                    this.base.detach((Object)stoZaBrisanje);
                }
                em.remove((Object)stoZaBrisanje);
            }
            for (Tura tura : tureUpdate) {
                void var10_16;
                if (!em.equals(this.base) && this.base.contains((Object)tura)) {
                    this.base.detach((Object)tura);
                }
                LinkedList<StavkaRacuna> linkedList = new LinkedList<StavkaRacuna>(tura.getStavke());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                if (tura.getId() == null) {
                    em.persist((Object)tura);
                } else {
                    void var10_14;
                    if (!em.contains((Object)tura)) {
                        Tura tura2 = (Tura)em.find(Tura.class, (Object)tura.getId());
                        tura2.setBrojStola(tura.getBrojStola());
                        tura2.setBrojTure(tura.getBrojTure());
                        tura2.setDatum(tura.getDatum());
                        tura2.setPripremljena(tura.isPripremljena());
                        tura2.setRacun(tura.getRacun());
                        tura2.setStavke(tura.getStavke());
                        tura2.setuPripremi(tura.isuPripremi());
                        Tura tura3 = tura2;
                    }
                    Tura tura4 = (Tura)em.merge((Object)var10_14);
                }
                for (StavkaRacuna sr : linkedList) {
                    if (!em.equals(this.base) && this.base.contains((Object)sr)) {
                        this.base.detach((Object)sr);
                    }
                    sr.setTura((Tura)var10_16);
                    Artikal art = sr.getArtikal();
                    if (!em.contains((Object)art)) {
                        art = (Artikal)em.find(Artikal.class, (Object)art.getId());
                    }
                    sr.setArtikal(art);
                    if (sr.getId() == null) {
                        em.persist((Object)sr);
                    } else {
                        if (!em.contains((Object)sr)) {
                            StavkaRacuna tempSr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
                            tempSr.setArtikal(sr.getArtikal());
                            tempSr.setBrojStola(sr.getBrojStola());
                            tempSr.setCena(sr.getCena());
                            tempSr.setKolicina(sr.getKolicina());
                            tempSr.setNaziv(sr.getNaziv());
                            tempSr.setRacun(sr.getRacun());
                            tempSr.setTura(sr.getTura());
                            sr = tempSr;
                        }
                        sr = (StavkaRacuna)em.merge((Object)sr);
                    }
                    var10_16.getStavke().add(sr);
                }
                Tura tura5 = (Tura)em.merge((Object)var10_16);
                retList.add(tura5);
            }
            LinkedList<Object> placanja = r.getPlacanja() != null ? new LinkedList<Placanje>(r.getPlacanja()) : new LinkedList();
            r.setTure(new LinkedList<Tura>());
            r.setStavke1(new LinkedList<StavkaRacuna>());
            r.setPlacanja(new LinkedList<Placanje>());
            em.persist((Object)r);
            for (Placanje placanje : placanja) {
                placanje.setRacun(r);
                em.persist((Object)placanje);
                r.getPlacanja().add(placanje);
            }
            for (Tura tura : tureRacun) {
                void var11_30;
                if (!em.equals(this.base) && this.base.contains((Object)tura)) {
                    this.base.detach((Object)tura);
                }
                LinkedList<StavkaRacuna> linkedList = new LinkedList<StavkaRacuna>(tura.getStavke());
                tura.setStavke(new LinkedList<StavkaRacuna>());
                tura.setRacun(r);
                if (tura.getId() == null) {
                    em.persist((Object)tura);
                } else {
                    void var11_28;
                    if (!em.contains((Object)tura)) {
                        Tura tempTura = (Tura)em.find(Tura.class, (Object)tura.getId());
                        tempTura.setBrojStola(tura.getBrojStola());
                        tempTura.setBrojTure(tura.getBrojTure());
                        tempTura.setDatum(tura.getDatum());
                        tempTura.setPripremljena(tura.isPripremljena());
                        tempTura.setRacun(tura.getRacun());
                        tempTura.setStavke(tura.getStavke());
                        tempTura.setuPripremi(tura.isuPripremi());
                        Tura tura6 = tempTura;
                    }
                    Tura tura7 = (Tura)em.merge((Object)var11_28);
                }
                for (StavkaRacuna sr : linkedList) {
                    if (!em.equals(this.base) && this.base.contains((Object)sr)) {
                        this.base.detach((Object)sr);
                    }
                    sr.setTura((Tura)var11_30);
                    sr.setRacun(r);
                    Artikal art = sr.getArtikal();
                    if (!em.contains((Object)art)) {
                        art = (Artikal)em.find(Artikal.class, (Object)art.getId());
                    }
                    sr.setArtikal(art);
                    if (sr.getId() == null) {
                        em.persist((Object)sr);
                    } else {
                        if (!em.contains((Object)sr)) {
                            StavkaRacuna tempSr = (StavkaRacuna)em.find(StavkaRacuna.class, (Object)sr.getId());
                            tempSr.setArtikal(sr.getArtikal());
                            tempSr.setBrojStola(sr.getBrojStola());
                            tempSr.setCena(sr.getCena());
                            tempSr.setKolicina(sr.getKolicina());
                            tempSr.setNaziv(sr.getNaziv());
                            tempSr.setRacun(sr.getRacun());
                            tempSr.setTura(sr.getTura());
                            sr = tempSr;
                        }
                        sr = (StavkaRacuna)em.merge((Object)sr);
                    }
                    var11_30.getStavke().add(sr);
                    r.getStavke1().add(sr);
                }
                Tura tura8 = (Tura)em.merge((Object)var11_30);
                r.getTure().add(tura8);
                retList.add(tura8);
            }
            Object var10_19 = null;
            try {
                if (this.getCurrentCounter() != null && this.getCurrentCounter().getId() != null) {
                    Kasa kasa = (Kasa)em.find(Kasa.class, (Object)this.getCurrentCounter().getId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            r.setKasa((Kasa)var10_21);
            r = (Racun)em.merge((Object)r);
            for (StavkaRacuna stavkaRacuna : stavkeZaBrisanje) {
                if (!em.equals(this.base) && this.base.contains((Object)stavkaRacuna)) {
                    this.base.detach((Object)stavkaRacuna);
                }
                em.remove((Object)stavkaRacuna);
            }
            trans.commit();
            if (em.equals(this.base)) {
                for (Tura tura : retList) {
                    if (!em.contains((Object)tura)) continue;
                    em.refresh((Object)tura);
                }
                if (em.contains((Object)r)) {
                    em.refresh((Object)r);
                }
            }
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            throw new Exception("Do\u0161lo je do gre\u0161ke prilikom a\u017euriranja rastavljenih tura", e);
        }
        if (!em.equals(this.base)) {
            em.close();
        }
        log.exiting(RestoranServer.class.getName(), "makeRacunUpdateTureRastavljanje");
        return r;
    }

    public Map<Integer, String> getNaziviStolova() {
        TypedQuery tq = this.base.createQuery("SELECT sn FROM StoNaziv sn ORDER BY sn.broj", StoNaziv.class);
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        List list = tq.getResultList();
        for (StoNaziv stoNaziv : list) {
            map.put(stoNaziv.getBroj(), stoNaziv.getNaziv());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MeniPromet getMeniPromet(Long racunId) {
        MeniPromet k = null;
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String selectString = "select mp.* from menipromet mp where mp.RACUN_ID= " + racunId + " ";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                k = new MeniPromet();
                k.setCena(rs.getDouble("cena"));
                k.setDatum(rs.getDate("datum"));
                k.setKolicina(rs.getDouble("kolicina"));
                k.setNaziv(rs.getString(rs.getString("naziv")));
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return k;
    }

    public MeniPromet getMeniPromet(Racun r) {
        TypedQuery tq = this.base.createQuery("SELECT m FROM MeniPromet m where m.racun = :r ", MeniPromet.class);
        tq.setParameter("r", (Object)r);
        return (MeniPromet)tq.getSingleResult();
    }

    public List<MeniPromet> getMeni(Date d1) {
        Query tq = this.base.createNativeQuery("SELECT m.id,m.cena,m.datum,m.kolicina,m.naziv from menipromet m\nleft join racun r on m.RACUN_ID=r.id\njoin zd z on r.zdBroj=z.zdBroj and z.pocetak=1\nwhere z.zdBroj=(select zdbroj from zd where datum =? order by id limit 1) ", MeniPromet.class);
        tq.setParameter(1, (Object)d1);
        return tq.getResultList();
    }

    public List<MeniPromet> getMeni() {
        TypedQuery tq = this.base.createQuery("SELECT m FROM MeniPromet m ", MeniPromet.class);
        return tq.getResultList();
    }

    public List<HacapMagacini> getAllHmagacini() {
        Query q = this.base.createQuery("SELECT hm FROM HacapMagacini hm");
        return q.getResultList();
    }

    public List<Meni> getAllMenus() {
        Query query = this.base.createQuery("SELECT m FROM Meni m WHERE m.blokiran = :blk ");
        query.setParameter("blk", (Object)Boolean.FALSE);
        return query.getResultList();
    }

    public void addHasapMagacin(HacapMagacini hm) {
        this.base.getTransaction().begin();
        this.base.persist((Object)hm);
        this.base.getTransaction().commit();
    }

    public void addMeni(Meni newMeni) {
        this.base.getTransaction().begin();
        this.base.persist((Object)newMeni);
        this.base.getTransaction().commit();
    }

    public void updateHasapMagacini(HacapMagacini hm) {
        hm = (HacapMagacini)this.base.find(HacapMagacini.class, (Object)hm.getId());
        this.base.getTransaction().begin();
        this.base.merge((Object)hm);
        this.base.getTransaction().commit();
    }

    public void updateMeni(Meni newMeni) {
        newMeni = (Meni)this.base.find(Meni.class, (Object)newMeni.getId());
        this.base.getTransaction().begin();
        this.base.merge((Object)newMeni);
        this.base.getTransaction().commit();
    }

    public void incrementSledeciBrojZajednickeFakture() {
        Setting nextPlu = this.getSetting(Option.ZBIRNA_FAKTURA_SLEDECI_BROJ);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.ZBIRNA_FAKTURA_SLEDECI_BROJ.getName());
            nextPlu.setActual(Option.ZBIRNA_FAKTURA_SLEDECI_BROJ.getDiefault());
        }
        nextPlu.setActual("" + (Integer.valueOf(nextPlu.getActual()) + 1));
        this.changeSetting(nextPlu);
    }

    public void incrementSledeciBrojVPFakture() {
        Setting nextPlu = this.getSetting(Option.SLEDECI_BROJ_VP_FAKTURE);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.SLEDECI_BROJ_VP_FAKTURE.getName());
            nextPlu.setActual(Option.SLEDECI_BROJ_VP_FAKTURE.getDiefault());
        }
        nextPlu.setActual("" + (Integer.valueOf(nextPlu.getActual()) + 1));
        this.changeSetting(nextPlu);
    }

    public void insertVpFakturaNaslov() {
        Setting nextPlu = this.getSetting(Option.NASLOV_VPFAKTURA);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.NASLOV_VPFAKTURA.getName());
            nextPlu.setActual(Option.NASLOV_VPFAKTURA.getDiefault());
            this.changeSetting(nextPlu);
        }
    }

    public void incrementSledeciPLUMenija() {
        Setting nextPlu = this.getSetting(Option.SLEDECI_PLU_MENIJA);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.SLEDECI_PLU_MENIJA.getName());
            nextPlu.setActual(Option.SLEDECI_PLU_MENIJA.getDiefault());
        }
        nextPlu.setActual("" + (Integer.valueOf(nextPlu.getActual()) + 1));
        this.changeSetting(nextPlu);
    }

    public void resetSledeciPLUMenija() {
        Setting nextPlu = this.getSetting(Option.SLEDECI_PLU_MENIJA);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.SLEDECI_PLU_MENIJA.getName());
        }
        nextPlu.setActual(Option.SLEDECI_PLU_MENIJA.getDiefault());
        this.changeSetting(nextPlu);
    }

    public Integer getSledeciPLUMenija() {
        Setting nextPlu = this.getSetting(Option.SLEDECI_PLU_MENIJA);
        if (nextPlu == null) {
            nextPlu = new Setting();
            nextPlu.setName(Option.SLEDECI_PLU_MENIJA.getName());
            nextPlu.setActual(Option.SLEDECI_PLU_MENIJA.getDiefault());
        }
        return Integer.valueOf(nextPlu.getActual());
    }

    public Integer nextFiscalBillNumber() {
        Query q = this.base.createNativeQuery("SELECT (COALESCE(MAX(brojRacuna), 0) + 1) FROM racun WHERE crnoplacanje IS NULL;", Integer.class);
        return (Integer)q.getResultList().get(0);
    }

    public Integer nextNonFiscalBillNumber() {
        Query q = this.base.createNativeQuery("SELECT (COALESCE(MAX(brojRacuna), 0) + 1) FROM racun WHERE crnoplacanje IS NOT NULL;", Integer.class);
        return (Integer)q.getResultList().get(0);
    }

    public Trebovanje findTrebovanjeByDocMark(String docMark, TipTrebovanja tt) {
        TypedQuery q = this.base.createQuery("SELECT t FROM Trebovanje t WHERE t.brTrebovanja = :docMark AND t.tip = :tt ORDER BY t.datumTrebovanja DESC", Trebovanje.class);
        q.setParameter("docMark", (Object)docMark);
        q.setParameter("tt", (Object)tt);
        List tList = q.getResultList();
        return tList.isEmpty() ? null : (Trebovanje)tList.get(0);
    }

    public Prijemnica findPrijemnicaByDocMark(String docMark, TipPrijemnice tp) {
        TypedQuery q = this.base.createQuery("SELECT p FROM Prijemnica p WHERE p.brPrijemnice = :docMark AND p.tip = :tp ORDER BY p.datumPrijemnice DESC", Prijemnica.class);
        q.setParameter("docMark", (Object)docMark);
        q.setParameter("tp", (Object)tp);
        List pList = q.getResultList();
        return pList.isEmpty() ? null : (Prijemnica)pList.get(0);
    }

    public CrnoPlacanje findCrnoPlacanjeBySifra(String sifra) {
        TypedQuery tq = this.base.createQuery("SELECT cp FROM CrnoPlacanje cp WHERE cp.sifra = :sifra", CrnoPlacanje.class);
        tq.setParameter("sifra", (Object)sifra);
        CrnoPlacanje cp = null;
        try {
            cp = (CrnoPlacanje)tq.getSingleResult();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return cp;
    }

    public List<MeniPromet> findAllMeniPrometCrno(Date from, Date to, List<Meni> mList, List<String> bpm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT DISTINCT mp FROM MeniPromet mp JOIN mp.racun r WHERE mp.datum BETWEEN :from AND :to AND mp.meni IN :mList AND (r.crnoPlacanje IS NOT NULL AND r.crnoPlacanje IN :bpm) ORDER BY mp.datum");
        params.put("from", from);
        params.put("to", to);
        params.put("mList", mList);
        params.put("bpm", bpm);
        TypedQuery tqmp = this.base.createQuery(sb.toString(), MeniPromet.class);
        for (Map.Entry entry : params.entrySet()) {
            String string = (String)entry.getKey();
            Object object = entry.getValue();
            tqmp.setParameter(string, object);
        }
        if (bpm.isEmpty()) {
            return null;
        }
        return tqmp.getResultList();
    }

    public List<MeniPromet> findAllMeniPrometBelo(Date from, Date to, List<Meni> mList, List<NacinPlacanja> wpm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT DISTINCT mp FROM MeniPromet mp JOIN mp.racun r JOIN r.placanja p WHERE mp.datum BETWEEN :from AND :to AND mp.meni IN :mList AND ((r.crnoPlacanje IS NULL AND p.nacin IN :wpm)) ORDER BY mp.datum");
        params.put("from", from);
        params.put("to", to);
        params.put("mList", mList);
        params.put("wpm", wpm);
        TypedQuery tqmp = this.base.createQuery(sb.toString(), MeniPromet.class);
        for (Map.Entry entry : params.entrySet()) {
            String string = (String)entry.getKey();
            Object object = entry.getValue();
            tqmp.setParameter(string, object);
        }
        if (wpm.isEmpty()) {
            return null;
        }
        return tqmp.getResultList();
    }

    public MeniPromet findLastMPbyName(Meni meni) {
        Query q = this.base.createQuery("SELECT mp  from MeniPromet mp where mp.naziv = :naziv order by mp.datum desc limit 1");
        q.setParameter("naziv", (Object)meni.getNaziv());
        return (MeniPromet)q.getSingleResult();
    }

    public List<MeniPromet> findAllMeniPromet(Date from, Date to, List<Meni> mList, List<NacinPlacanja> wpm, List<String> bpm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sb = new StringBuilder("SELECT DISTINCT mp FROM MeniPromet mp JOIN mp.racun r JOIN r.placanja p WHERE mp.datum BETWEEN :from AND :to AND mp.meni IN :mList AND (");
        params.put("from", from);
        params.put("to", to);
        params.put("mList", mList);
        if (!wpm.isEmpty() && !bpm.isEmpty()) {
            sb.append("(r.crnoPlacanje IS NULL AND r.placanja.nacin IN (:wpm)) OR (r.crnoPlacanje IS NOT NULL AND r.crnoPlacanje IN (:bpm))");
            params.put("wpm", wpm);
            params.put("bpm", bpm);
        } else if (!wpm.isEmpty()) {
            sb.append("(r.crnoPlacanje IS NULL AND r.placanja.nacin IN :wpm)");
            params.put("wpm", wpm);
        } else if (!bpm.isEmpty()) {
            sb.append("(r.crnoPlacanje IS NOT NULL AND r.crnoPlacanje IN :bpm)");
            params.put("bpm", bpm);
        }
        sb.append(") ORDER BY mp.datum");
        TypedQuery tqmp = this.base.createQuery(sb.toString(), MeniPromet.class);
        for (Map.Entry entry : params.entrySet()) {
            String string = (String)entry.getKey();
            Object object = entry.getValue();
            tqmp.setParameter(string, object);
        }
        return tqmp.getResultList();
    }

    public List<GrupaOA> findGrupaOANotInList(List<GrupaOA> list) {
        List<GrupaOA> retList = new LinkedList<GrupaOA>();
        LinkedList<Long> paramList = new LinkedList<Long>();
        EntityManager em = this.getEM();
        if (list != null) {
            for (GrupaOA goa : list) {
                paramList.add(goa.getId());
            }
            System.out.println("sve u redu");
            TypedQuery tqgoa = em.createQuery("SELECT goa FROM GrupaOA goa WHERE goa.id NOT IN (:goaList)", GrupaOA.class);
            tqgoa.setParameter("goaList", paramList);
            retList = tqgoa.getResultList();
            for (GrupaOA grupaOA : retList) {
                grupaOA.getAtributi();
            }
            System.out.println("retlist.size() = " + retList.size());
        }
        em.close();
        return retList;
    }

    public List<Atribut> findAtributNotInList(List<Atribut> list) {
        List<Atribut> retList = new LinkedList<Atribut>();
        LinkedList<Long> paramList = new LinkedList<Long>();
        EntityManager em = this.getEM();
        if (list != null) {
            for (Atribut at : list) {
                paramList.add(at.getId());
            }
            System.out.println("sve u redu");
            TypedQuery tqat = em.createQuery("SELECT at FROM Atribut at WHERE at.id NOT IN (:atList)", Atribut.class);
            tqat.setParameter("atList", paramList);
            retList = tqat.getResultList();
            for (Atribut atributi : retList) {
                atributi.getAtributi();
            }
            System.out.println("retlist.size() = " + retList.size());
        }
        em.close();
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Brojac getBrojac(TipBrojaca tip, Date datum) {
        EntityManager em = this.getEM();
        TypedQuery tqb = em.createQuery("SELECT b FROM Brojac b WHERE b.tip = :tip AND b.datumPocetka <= :datum ORDER BY b.datumPocetka DESC", Brojac.class);
        tqb.setParameter("tip", (Object)tip);
        tqb.setParameter("datum", datum, TemporalType.TIMESTAMP);
        tqb.setMaxResults(1);
        Brojac brojac = null;
        try {
            brojac = (Brojac)tqb.getResultList().get(0);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            em.close();
        }
        return brojac;
    }

    public Integer getVrednostBrojaca(TipBrojaca tip, Date datum) {
        Integer broj = 1;
        Brojac brojac = this.getBrojac(tip, datum);
        if (brojac != null) {
            broj = brojac.getVrednost();
        }
        return broj;
    }

    private Date getPocetniJPA(Date datum, EntityManager em) {
        TypedQuery tqzdp = em.createQuery("SELECT MIN(z.zakljucenje) FROM ZD z WHERE z.datum >= :d AND z.pocetak = TRUE", Date.class);
        tqzdp.setParameter("d", (Object)datum);
        Date ret = (Date)tqzdp.getSingleResult();
        if (ret == null) {
            tqzdp = em.createQuery("SELECT MAX(z.zakljucenje) FROM ZD z", Date.class);
            ret = (Date)tqzdp.getSingleResult();
        }
        return ret != null ? ret : new Date();
    }

    private Date getKrajnjiJPA(Date datum, EntityManager em) {
        TypedQuery tqzdp = em.createQuery("SELECT MAX(z.zakljucenje) FROM ZD z WHERE z.datum = :d AND z.pocetak = FALSE", Date.class);
        tqzdp.setParameter("d", (Object)datum);
        Date ret = (Date)tqzdp.getSingleResult();
        return ret != null ? ret : new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getPocetniDatumJPA(Date datum) {
        Date ret = null;
        try (EntityManager em = this.getEM();){
            ret = this.getPocetniJPA(datum, em);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getKrajnjiDatumJPA(Date datum) {
        Date ret = null;
        try (EntityManager em = this.getEM();){
            ret = this.getKrajnjiJPA(datum, em);
        }
        return ret;
    }

    public Placanje findIznosRacun(Racun r) {
        EntityManager em = this.getEM();
        Placanje placanje = null;
        TypedQuery query = em.createQuery("Select p from Placanje p where p.racun = :r ", Placanje.class);
        query.setParameter("r", (Object)r);
        placanje = (Placanje)query.getSingleResult();
        return placanje;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Racun> findIzlazniRacuniForPeriodAndStalniGosti(Date from, Date to, List<StalniGost> partneri, boolean samoNerealizovani) {
        List<Racun> list = new LinkedList<Racun>();
        EntityManager em = this.getEM();
        try {
            Date d1 = this.getPocetniJPA(from, em);
            Date d2 = this.getKrajnjiJPA(to, em);
            if (d2 == null) {
                d2 = new Date();
            }
            System.out.println("d1 = " + d1);
            System.out.println("d2 = " + d2);
            TypedQuery tqr = em.createQuery("SELECT DISTINCT r FROM Racun r JOIN FETCH r.stavke1 LEFT JOIN FETCH r.knjizenja LEFT JOIN r.placanja pl WHERE pl.nacin = :faktura AND r.datum BETWEEN :d1 AND :d2" + (partneri != null && !partneri.isEmpty() ? " AND r.stalniGost IN :partneri" : "") + (samoNerealizovani ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.racun = r AND k.realizovano = TRUE)" : ""), Racun.class);
            tqr.setParameter("d1", (Object)d1);
            tqr.setParameter("d2", (Object)d2);
            tqr.setParameter("faktura", (Object)NacinPlacanja.FAKTURA);
            if (partneri != null && !partneri.isEmpty()) {
                tqr.setParameter("partneri", partneri);
            }
            list = tqr.getResultList();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StalniGost> findAllPartneri() {
        LinkedList<StalniGost> partneri = new LinkedList<StalniGost>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqsg = em.createQuery("SELECT sg FROM StalniGost sg", StalniGost.class);
            partneri.addAll(tqsg.getResultList());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        return partneri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> findBeliUlazniRacuniForPeriodAndStalniGosti(Date from, Date to, List<StalniGost> partneri, boolean sviPartneri, boolean samoNerealizovani) {
        LinkedList<Object> list = new LinkedList<Object>();
        EntityManager em = this.getEM();
        try {
            System.out.println("partneri.size() = " + partneri.size());
            System.out.println("from = " + from);
            System.out.println("to = " + to);
            for (StalniGost sg : partneri) {
                System.out.println("sg = " + sg);
            }
            TypedQuery tqr = em.createQuery("SELECT DISTINCT t FROM Trebovanje t LEFT JOIN FETCH t.knjizenja WHERE (t.crno IS NULL OR t.crno = FALSE) AND t.datumTrebovanja BETWEEN :d1 AND :d2 AND t.dobavljac IN :partneri" + (samoNerealizovani ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.trebovanje = t AND k.realizovano = TRUE)" : ""), Trebovanje.class);
            tqr.setParameter("d1", (Object)from);
            tqr.setParameter("d2", (Object)to);
            tqr.setParameter("partneri", partneri);
            list.addAll(tqr.getResultList());
            TypedQuery tqp = em.createQuery("SELECT DISTINCT p FROM Prijemnica p LEFT JOIN FETCH p.knjizenja WHERE (p.crno IS NULL OR p.crno = FALSE) AND p.datumPrijemnice BETWEEN :d1 AND :d2 AND p.dobavljac IN :partneri AND p.trebovanje IS NULL" + (samoNerealizovani ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.prijemnica = p AND k.realizovano = TRUE)" : ""), Prijemnica.class);
            tqp.setParameter("d1", (Object)from);
            tqp.setParameter("d2", (Object)to);
            tqp.setParameter("partneri", partneri);
            list.addAll(tqp.getResultList());
            TypedQuery tqt = em.createQuery("SELECT DISTINCT t FROM Trosak t LEFT JOIN FETCH t.knjizenja WHERE t.dan BETWEEN :d1 AND :d2" + (sviPartneri ? "" : " AND t.partner IN :partneri") + (samoNerealizovani ? " AND NOT EXISTS (SELECT k FROM Knjizenje k WHERE k.trosak = t AND k.realizovano = TRUE)" : ""), Trosak.class);
            tqt.setParameter("d1", (Object)from);
            tqt.setParameter("d2", (Object)to);
            if (!sviPartneri) {
                tqt.setParameter("partneri", partneri);
            }
            list.addAll(tqt.getResultList());
            System.out.println("list.size() = " + list.size());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getNaciniRealizacije() {
        LinkedList<String> naciniRealizacije = new LinkedList<String>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqnr = em.createQuery("SELECT DISTINCT(k.nacinRealizacije) FROM Knjizenje k WHERE k.nacinRealizacije IS NOT NULL AND k.nacinRealizacije <> '' ORDER BY k.nacinRealizacije", String.class);
            naciniRealizacije.addAll(tqnr.getResultList());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        return naciniRealizacije;
    }

    public void CreateKnjizenje(Knjizenje k) {
        Connection conn = null;
        Statement stmt = null;
        String query = "";
        SimpleDateFormat s1 = new SimpleDateFormat("YYYY-MM-dd");
        SimpleDateFormat s2 = new SimpleDateFormat(" HH:mm:ss");
        if (k.getTrebovanje() != null) {
            query = "INSERT INTO Knjizenje (datumRealizacije, datumUnosa ,realizovaniIznos, realizovano, TREBOVANJE_ID) VALUES ('" + s1.format(new Date()) + "','" + s1.format(new Date()) + s2.format(new Date()) + "', " + k.getRealizovaniIznos() + ",true, " + k.getTrebovanje().getId() + ")";
        }
        if (k.getPrijemnica() != null) {
            query = "INSERT INTO Knjizenje (datumRealizacije, datumUnosa ,realizovaniIznos, realizovano, PRIJEMNICA_ID) VALUES ('" + s1.format(new Date()) + "','" + s1.format(new Date()) + s2.format(new Date()) + "', " + k.getRealizovaniIznos() + ",true, " + k.getPrijemnica().getId() + ")";
        }
        if (k.getRacun() != null) {
            query = "INSERT INTO Knjizenje (datumRealizacije, datumUnosa ,realizovaniIznos, realizovano, RACUN_ID) VALUES ('" + s1.format(new Date()) + "','" + s1.format(new Date()) + s2.format(new Date()) + "', " + k.getRealizovaniIznos() + ",true, " + k.getRacun().getId() + ")";
        }
        System.out.println(query);
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
            stmt.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Knjizenje updateOrCreateKnjizenje(Knjizenje knjizenje) throws Exception {
        Exception thr = null;
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            BObject temp;
            trans.begin();
            if (knjizenje.getId() == null) {
                em.persist((Object)knjizenje);
            } else {
                knjizenje = (Knjizenje)em.merge((Object)knjizenje);
            }
            em.flush();
            if (knjizenje.getRacun() != null && knjizenje.getRacun().getId() != null && (temp = (Racun)em.find(Racun.class, (Object)knjizenje.getRacun().getId())) != null) {
                em.refresh((Object)temp);
                ((Racun)temp).getKnjizenja();
                ((Racun)temp).getStavke1();
                ((Racun)temp).getPlacanja();
                knjizenje.setRacun((Racun)temp);
            }
            if (knjizenje.getTrebovanje() != null && knjizenje.getTrebovanje().getId() != null && (temp = (Trebovanje)em.find(Trebovanje.class, (Object)knjizenje.getTrebovanje().getId())) != null) {
                em.refresh((Object)temp);
                ((Trebovanje)temp).getKnjizenja();
                ((Trebovanje)temp).getStavke();
                knjizenje.setTrebovanje((Trebovanje)temp);
            }
            if (knjizenje.getPrijemnica() != null && knjizenje.getPrijemnica().getId() != null && (temp = (Prijemnica)em.find(Prijemnica.class, (Object)knjizenje.getPrijemnica().getId())) != null) {
                em.refresh((Object)temp);
                ((Prijemnica)temp).getKnjizenja();
                ((Prijemnica)temp).getStavke();
                knjizenje.setPrijemnica((Prijemnica)temp);
            }
            if (knjizenje.getTrosak() != null && knjizenje.getTrosak().getId() != null && (temp = (Trosak)em.find(Trosak.class, (Object)knjizenje.getTrosak().getId())) != null) {
                em.refresh((Object)temp);
                ((Trosak)temp).getKnjizenja();
                knjizenje.setTrosak((Trosak)temp);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            thr = e;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        if (thr == null) {
            return knjizenje;
        }
        throw thr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnevniCenovnik createOrUpdateCenovnik(DnevniCenovnik cenovnik) throws Exception {
        Exception excp = null;
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            if (cenovnik.getId() == null) {
                for (DnevniCenovnikStavka dcs : cenovnik.getStavke()) {
                    dcs.setArtikal((Artikal)em.find(Artikal.class, (Object)dcs.getArtikal().getId()));
                }
                em.persist((Object)cenovnik);
            } else {
                DnevniCenovnik tempCen = (DnevniCenovnik)em.find(DnevniCenovnik.class, (Object)cenovnik.getId());
                tempCen.setZaDan(cenovnik.getZaDan());
                tempCen.setStavke(cenovnik.getStavke());
                cenovnik = tempCen;
                LinkedList<DnevniCenovnikStavka> list = new LinkedList<DnevniCenovnikStavka>();
                for (DnevniCenovnikStavka dcs : cenovnik.getStavke()) {
                    dcs.setCenovnik(cenovnik);
                    Artikal art = (Artikal)em.find(Artikal.class, (Object)dcs.getArtikal().getId());
                    dcs.setArtikal(art);
                    if (dcs.getId() == null) {
                        em.persist((Object)dcs);
                    } else {
                        DnevniCenovnikStavka tDcs = (DnevniCenovnikStavka)em.find(DnevniCenovnikStavka.class, (Object)dcs.getId());
                        tDcs.setArtikal(dcs.getArtikal());
                        tDcs.setCenovnik(cenovnik);
                        tDcs.setNabavnaCenaPoslednja(StatLogic.round(dcs.getNabavnaCenaPoslednja(), 2));
                        tDcs.setNabavnaCenaDodatnaPoslednja(StatLogic.round(dcs.getNabavnaCenaPoslednja(), 2));
                        tDcs.setNabavnaCenaProsecna(StatLogic.round(dcs.getNabavnaCenaProsecna(), 2));
                        tDcs.setNabavnaCenaDodatnaProsecna(StatLogic.round(dcs.getNabavnaCenaProsecna(), 2));
                        tDcs.setProdajnaCena(StatLogic.round(dcs.getProdajnaCena(), 2));
                        dcs = tDcs;
                    }
                    list.add(dcs);
                }
                cenovnik.setStavke(list);
                cenovnik = (DnevniCenovnik)em.merge((Object)cenovnik);
            }
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            excp = e;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
        if (excp == null) {
            return cenovnik;
        }
        throw excp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnevniCenovnik findDnevniCenovnikForDate(Date forDate) {
        DnevniCenovnik dc = null;
        EntityManager em = this.getEM();
        TypedQuery tqdc = em.createQuery("SELECT DISTINCT dc FROM DnevniCenovnik dc LEFT JOIN FETCH dc.stavke LEFT JOIN FETCH dc.stavke.artikal WHERE dc.zaDan = :forDate", DnevniCenovnik.class);
        tqdc.setParameter("forDate", (Object)forDate);
        try {
            List retList = tqdc.getResultList();
            if (!retList.isEmpty()) {
                dc = (DnevniCenovnik)retList.get(0);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            em.close();
        }
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DnevniCenovnik> findAllDnevniCenovnik() {
        LinkedList<DnevniCenovnik> list = new LinkedList();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqdc = em.createQuery("SELECT DISTINCT dc FROM DnevniCenovnik dc LEFT JOIN FETCH dc.stavke LEFT JOIN FETCH dc.stavke.artikal ORDER BY dc.zaDan", DnevniCenovnik.class);
            list = tqdc.getResultList();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Stampac> getZbirnaStampaci() {
        LinkedList<Stampac> list = new LinkedList<Stampac>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqs = em.createQuery("SELECT s FROM Stampac s WHERE s.stampaZbirnu = TRUE AND s.brojKopijaZbirne > 0", Stampac.class);
            list.addAll(tqs.getResultList());
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrupaOdeljenja> findAllGrupeOdeljenja() {
        LinkedList<GrupaOdeljenja> grupe = new LinkedList<GrupaOdeljenja>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqgo = em.createQuery("SELECT DISTINCT go FROM GrupaOdeljenja go LEFT JOIN go.odeljenja od LEFT JOIN od.artikli art LEFT JOIN od.prodajnaMesta pm ORDER BY go.naziv", GrupaOdeljenja.class);
            grupe.addAll(tqgo.getResultList());
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
            return grupe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Kasa> findAllKasa() {
        LinkedList<Kasa> kase = new LinkedList<Kasa>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqk = em.createQuery("SELECT k FROM Kasa k ORDER BY k.oznaka", Kasa.class);
            kase.addAll(tqk.getResultList());
        }
        catch (Exception ex) {
            this.warn(ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception ex) {
                this.error(ex.getMessage(), ex);
            }
        }
        return kase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Kasa findKasaByHostName(String hostName) {
        Kasa ret = null;
        EntityManager em = this.getEM();
        try {
            TypedQuery tqk = em.createQuery("SELECT k FROM Kasa k WHERE k.hostname = :hn", Kasa.class);
            tqk.setParameter("hn", (Object)hostName);
            ret = (Kasa)tqk.getSingleResult();
        }
        catch (NoResultException ex) {
        }
        catch (Exception ex) {
            this.warn(ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception ex) {
                this.error(ex.getMessage(), ex);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProdajnoMesto> findAllProdajnoMestoByOdeljenje(Long o) {
        LinkedList<ProdajnoMesto> ret = new LinkedList<ProdajnoMesto>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqpm = em.createQuery("SELECT pmo FROM prodajnomesto_odeljenje pmo WHERE pmo.ODELJENJA_ID = :o ORDER BY pmo.PRODAJNAMESTA_ID", ProdajnoMesto.class);
            tqpm.setParameter("o", (Object)o);
            ret.addAll(tqpm.getResultList());
        }
        catch (Exception ex) {
            this.warn(ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception ex) {
                this.error(ex.getMessage(), ex);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProdajnoMesto> findAllProdajnoMesto() {
        LinkedList<ProdajnoMesto> ret = new LinkedList<ProdajnoMesto>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqpm = em.createQuery("SELECT pm FROM ProdajnoMesto pm ORDER BY pm.naziv", ProdajnoMesto.class);
            ret.addAll(tqpm.getResultList());
        }
        catch (Exception ex) {
            this.warn(ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception ex) {
                this.error(ex.getMessage(), ex);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProdajnoMesto createOrUpdateProdajnoMesto(ProdajnoMesto pm) throws Exception {
        Exception excp = null;
        if (pm == null) {
            throw new IllegalArgumentException("Argument pm cannot be null");
        }
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            LinkedList<Kasa> kase = new LinkedList<Kasa>();
            for (Kasa kasa : pm.getKase()) {
                if (kasa == null) continue;
                if (!em.contains((Object)kasa)) {
                    if (kasa.getId() == null) {
                        em.persist((Object)kasa);
                    } else {
                        kasa = (Kasa)em.find(Kasa.class, (Object)kasa.getId());
                    }
                }
                if (kasa == null) continue;
                kase.add(kasa);
            }
            pm.setKase(kase);
            LinkedList<Odeljenje> odeljenja = new LinkedList<Odeljenje>();
            for (Odeljenje od : pm.getOdeljenja()) {
                if (od == null) continue;
                if (!em.contains((Object)od)) {
                    if (od.getId() == null) {
                        em.persist((Object)od);
                    } else {
                        od = (Odeljenje)em.find(Odeljenje.class, (Object)od.getId());
                    }
                }
                if (od == null) continue;
                odeljenja.add(od);
            }
            pm.setOdeljenja(odeljenja);
            pm = (ProdajnoMesto)em.merge((Object)pm);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            excp = e;
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        if (excp == null) {
            return pm;
        }
        throw excp;
    }

    public Kasa getCurrentCounter() {
        return KasaController.getCurrentCounter();
    }

    public void setCurrentCounter(Kasa currentCounter) {
        KasaController.setCurrentCounter(currentCounter);
    }

    public Kasa updateKasa(Kasa k) {
        this.base.getTransaction().begin();
        this.base.merge((Object)k);
        this.base.getTransaction().commit();
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Kasa createOrUpdateKasa(Kasa kasa) throws Exception {
        Exception excp = null;
        if (kasa == null) {
            throw new IllegalArgumentException("Argument pm cannot be null");
        }
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            LinkedList<Konobar> konobari = new LinkedList<Konobar>();
            for (Konobar konobar : kasa.getKonobari()) {
                if (konobar == null || konobar.getId() == null) continue;
                if (!em.contains((Object)konobar)) {
                    konobar = (Konobar)em.find(Konobar.class, (Object)konobar.getId());
                }
                konobari.add(konobar);
            }
            kasa.setKonobari(konobari);
            ProdajnoMesto pm = kasa.getProdajnoMesto();
            if (pm != null && pm.getId() != null) {
                if (!em.contains((Object)pm)) {
                    pm = (ProdajnoMesto)em.find(ProdajnoMesto.class, (Object)pm.getId());
                }
            } else {
                throw new IllegalArgumentException("Argument prodajno mesto cannot be null");
            }
            kasa.setProdajnoMesto(pm);
            kasa = (Kasa)em.merge((Object)kasa);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            excp = e;
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        if (excp == null) {
            return kasa;
        }
        throw excp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrupaOdeljenja createOrUpdateGrupaOdeljenja(GrupaOdeljenja grupa) throws Exception {
        Exception excp = null;
        if (grupa == null) {
            throw new IllegalArgumentException("Argument pm cannot be null");
        }
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            LinkedList<Odeljenje> list = new LinkedList<Odeljenje>();
            for (Odeljenje od : grupa.getOdeljenja()) {
                if (od == null || od.getId() == null) continue;
                if (!em.contains((Object)od)) {
                    od = (Odeljenje)em.find(Odeljenje.class, (Object)od.getId());
                }
                list.add(od);
            }
            grupa.setOdeljenja(list);
            grupa = (GrupaOdeljenja)em.merge((Object)grupa);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            excp = e;
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        if (excp == null) {
            return grupa;
        }
        throw excp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Odeljenje createOrUpdateOdeljenje(Odeljenje odeljenje) throws Exception {
        Exception excp = null;
        if (odeljenje == null) {
            throw new IllegalArgumentException("Argument pm cannot be null");
        }
        EntityManager em = this.getEM();
        EntityTransaction trans = em.getTransaction();
        try {
            trans.begin();
            if (odeljenje.getStampac() != null) {
                Stampac s = null;
                if (odeljenje.getStampac().getId() != null) {
                    s = odeljenje.getStampac();
                    if (!em.contains((Object)odeljenje.getStampac())) {
                        s = (Stampac)em.find(Stampac.class, (Object)odeljenje.getStampac().getId());
                    }
                }
                odeljenje.setStampac(s);
            }
            if (odeljenje.getGrupaOdeljenja() != null) {
                GrupaOdeljenja go = null;
                if (odeljenje.getGrupaOdeljenja().getId() != null) {
                    go = odeljenje.getGrupaOdeljenja();
                    if (!em.contains((Object)odeljenje.getGrupaOdeljenja())) {
                        go = (GrupaOdeljenja)em.find(GrupaOdeljenja.class, (Object)odeljenje.getGrupaOdeljenja().getId());
                    }
                }
                odeljenje.setGrupaOdeljenja(go);
            }
            LinkedList<Artikal> artikli = new LinkedList<Artikal>();
            for (Artikal art : odeljenje.getArtikli()) {
                if (art == null || art.getId() == null) continue;
                art = (Artikal)em.find(Artikal.class, (Object)art.getId());
                artikli.add(art);
            }
            odeljenje.setArtikli(artikli);
            LinkedList<ProdajnoMesto> pmList = new LinkedList<ProdajnoMesto>();
            for (ProdajnoMesto pm : odeljenje.getProdajnaMesta()) {
                if (pm == null || pm.getId() == null) continue;
                pm = (ProdajnoMesto)em.find(ProdajnoMesto.class, (Object)pm.getId());
                pmList.add(pm);
            }
            odeljenje.setProdajnaMesta(pmList);
            odeljenje = (Odeljenje)em.merge((Object)odeljenje);
            trans.commit();
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            excp = e;
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        if (excp == null) {
            return odeljenje;
        }
        throw excp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Odeljenje> findDepartmentsWithoutGroups() {
        LinkedList<Odeljenje> list = new LinkedList<Odeljenje>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tqo = em.createQuery("SELECT DISTINCT o FROM Odeljenje o LEFT JOIN FETCH o.artikli LEFT JOIN FETCH o.prodajnaMesta WHERE o.grupaOdeljenja IS NULL", Odeljenje.class);
            list.addAll(tqo.getResultList());
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteGrupaOdeljenja(GrupaOdeljenja grupa) throws Exception {
        if (grupa == null) {
            throw new IllegalArgumentException("Argument grupa cannot be null");
        }
        if (grupa.getId() == null) {
            throw new IllegalArgumentException("Argument grupa must have valid id");
        }
        Exception excp = null;
        EntityManager em = this.getEM();
        EntityTransaction trans = null;
        try {
            trans = em.getTransaction();
            if (this.base != null && this.base.contains((Object)grupa)) {
                this.base.detach((Object)grupa);
            }
            if (!em.contains((Object)grupa)) {
                grupa = (GrupaOdeljenja)em.find(GrupaOdeljenja.class, (Object)grupa.getId());
            }
            if (grupa != null) {
                trans.begin();
                em.remove((Object)grupa);
                trans.commit();
            }
        }
        catch (Exception ex) {
            try {
                if (trans.isActive()) {
                    trans.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            excp = ex;
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        if (excp != null) {
            throw excp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, TwoTypeWrapper<Double, Double>> getArtikliStanjeZaDatumJPA(List<Artikal> artikli, Odeljenje odeljenje, Date date) {
        LinkedHashMap<Long, TwoTypeWrapper<Double, Double>> retList = new LinkedHashMap<Long, TwoTypeWrapper<Double, Double>>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tq = em.createQuery("SELECT new com.dev63.restoran.sistem.parts.ThreeTypeWrapper(ds.artikalID, SUM(ds.beloUlaz - ds.beloIzlaz), SUM(ds.crnoUlaz - ds.crnoIzlaz)) FROM DnevnoStanje ds WHERE ds.artikalID IN :artikli AND ds.odeljenje.id = :odId AND ds.datum < :date AND ds.artikal IS NOT NULL AND ds.beloIzlaz IS NOT NULL AND ds.beloUlaz IS NOT NULL GROUP BY ds.artikalID", ThreeTypeWrapper.class);
            LinkedList<Long> list = new LinkedList<Long>();
            for (Artikal artikal : artikli) {
                if (artikal.getId() == null) continue;
                list.add(artikal.getId());
            }
            tq.setParameter("artikli", list);
            tq.setParameter("odId", (Object)odeljenje.getId());
            tq.setParameter("date", date, TemporalType.DATE);
            for (ThreeTypeWrapper threeTypeWrapper : tq.getResultList()) {
                try {
                    ThreeTypeWrapper ttw = threeTypeWrapper;
                    if (!retList.containsKey(ttw.getA())) {
                        retList.put((Long)ttw.getA(), new TwoTypeWrapper<Double, Double>(0.0, 0.0));
                    }
                    ((TwoTypeWrapper)retList.get(ttw.getA())).setA((Double)((TwoTypeWrapper)retList.get(ttw.getA())).getA() + (Double)ttw.getB());
                    ((TwoTypeWrapper)retList.get(ttw.getA())).setB((Double)((TwoTypeWrapper)retList.get(ttw.getA())).getB() + (Double)ttw.getC());
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, TwoTypeWrapper<Double, Double>> getArtikliStanjeKarticeZaDatumJPA(List<Artikal> artikli, Odeljenje odeljenje, Date date) {
        LinkedHashMap<Long, TwoTypeWrapper<Double, Double>> retList = new LinkedHashMap<Long, TwoTypeWrapper<Double, Double>>();
        EntityManager em = this.getEM();
        try {
            TypedQuery tq = em.createQuery("SELECT new com.dev63.restoran.sistem.parts.ThreeTypeWrapper(k.artikal.id, SUM(CASE WHEN (k.crno IS NULL OR k.crno = FALSE) THEN k.kolicina ELSE 0 END), SUM(CASE WHEN (k.crno IS NOT NULL AND k.crno = TRUE) THEN k.kolicina ELSE 0 END)) FROM Kartica k WHERE k.artikal.id IN :artikli AND k.odeljenje.id = :odId AND k.datum < :date AND k.artikal IS NOT NULL AND k.kolicina IS NOT NULL GROUP BY k.artikal.id", ThreeTypeWrapper.class);
            LinkedList<Long> list = new LinkedList<Long>();
            for (Artikal artikal : artikli) {
                if (artikal.getId() == null) continue;
                list.add(artikal.getId());
            }
            tq.setParameter("artikli", list);
            tq.setParameter("odId", (Object)odeljenje.getId());
            tq.setParameter("date", (Object)date);
            for (ThreeTypeWrapper threeTypeWrapper : tq.getResultList()) {
                try {
                    ThreeTypeWrapper ttw = threeTypeWrapper;
                    if (!retList.containsKey(ttw.getA())) {
                        retList.put((Long)ttw.getA(), new TwoTypeWrapper<Double, Double>(0.0, 0.0));
                    }
                    ((TwoTypeWrapper)retList.get(ttw.getA())).setA((Double)((TwoTypeWrapper)retList.get(ttw.getA())).getA() + (Double)ttw.getB());
                    ((TwoTypeWrapper)retList.get(ttw.getA())).setB((Double)((TwoTypeWrapper)retList.get(ttw.getA())).getB() + (Double)ttw.getC());
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
        finally {
            if (em != null && em != this.base && em.isOpen()) {
                em.close();
            }
        }
        return retList;
    }

    public Country getCurrentCountry() {
        Setting ss = this.getSetting(Option.OBJEKAT_DRZAVA);
        if (ss == null || ss.stringValue() == null || ss.stringValue().length() == 0 || Country.findByEnumName(ss.stringValue()) == null) {
            return null;
        }
        return Country.findByEnumName(ss.stringValue());
    }

    public List<StoPrikaz> getPrikazStolovaForGrafikSale(GrafikSale gs) throws Exception {
        if (gs == null || gs.getId() == null) {
            return new ArrayList<StoPrikaz>(0);
        }
        EntityManager em = this.getEM();
        TypedQuery tq = em.createQuery("SELECT DISTINCT sp FROM StoPrikaz sp LEFT OUTER JOIN FETCH sp.rezervacije LEFT OUTER JOIN FETCH sp.sto WHERE sp.grafik.id = :gsid", StoPrikaz.class);
        tq.setParameter("gsid", (Object)gs.getId());
        List resultList = tq.getResultList();
        em.close();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getPrometPoStopama(Date d1, Date d2, boolean blic, List<Map<String, Object>> mapa) {
        EntityManager em = this.getEM();
        try {
            String query = "select\nsum(sr.kolicina) as kolicina, \n(sr.cena - (sr.cena * r.popust / 100)) as cenaKom,\nsum(sr.kolicina * (sr.cena - (sr.cena * r.popust / 100))) as vrednost, \na.poreskaGrupa as poreska_grupa,\na.trgovackaRoba as trgovacka,\nsr.naziv as naziv\nfrom stavkaracuna sr\nleft join racun r on r.id = sr.RACUN_ID\nleft join artikal a on a.id = sr.ARTIKAL_ID\nwhere r.datum BETWEEN ? and ? \nand r.zatvoren = 1 \ngroup by sr.naziv, a.poreskaGrupa, a.trgovackaRoba, (sr.cena - (sr.cena * r.popust / 100)) order by a.trgovackaRoba desc";
            Query ppa = em.createNativeQuery(query, Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)d1);
            ppa.setParameter(i++, (Object)d2);
            System.out.println(d1);
            System.out.println(d2);
            System.out.println(ppa);
            if (mapa == null) {
                mapa = new LinkedList<Map<String, Object>>();
            } else {
                mapa.clear();
            }
            mapa.addAll(ppa.getResultList());
            List<Map<String, Object>> list = mapa;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCombinedPayments(Date from, Date to) throws Exception {
        EntityManager em = this.getEM();
        try {
            Query q = em.createNativeQuery("select r.id, count(distinct(p.nacin)) as placanja from racun r inner join placanje p on r.id = p.racun_id where r.datum between (select min(zakljucenje) from zd where pocetak = 1 and datum >= ?) and (select max(zakljucenje) from zd where pocetak = 0 and datum <= ?) group by r.id having placanja > 1;");
            q.setParameter(1, from, TemporalType.DATE);
            q.setParameter(2, to, TemporalType.DATE);
            boolean bl = !q.getResultList().isEmpty();
            return bl;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    private void log(Level level, String message, Throwable thrown) {
        log.logp(level, Thread.currentThread().getStackTrace()[2].getClassName(), Thread.currentThread().getStackTrace()[2].getMethodName(), message, thrown);
    }

    private void error(String message, Throwable thrown) {
        this.log(Level.SEVERE, message, thrown);
    }

    private void error(String message) {
        this.error(message, null);
    }

    private void warn(String message, Throwable thrown) {
        this.log(Level.WARNING, message, thrown);
    }

    private void warn(String message) {
        this.warn(message, null);
    }

    public String getNewRevenueReportsNestedQueryStringPoSatima() {
        return Queries.QUERIES.get((Object)QueryName.PROMET_PO_ARTIKLIMA_NESTED_PO_SATIMA);
    }

    public String getNewRevenueReportsNestedQueryStringNow() {
        return Queries.QUERIES.get((Object)QueryName.PROMET_PO_ARTIKLIMA_NESTED_NOW);
    }

    public String getNewRevenueReportsNestedQueryString() {
        return Queries.QUERIES.get((Object)QueryName.PROMET_PO_ARTIKLIMA_NESTED);
    }

    public String getNewRevenueReportsNestedQueryStringTopArtikli() {
        return Queries.QUERIES.get((Object)QueryName.PROMET_PO_ARTIKLIMA_NESTED_TOP_ARTIKLI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesArticleData(EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArticleData, boolean sifre, boolean sifre1, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pKase = "";
            String pPodgrupe = "";
            String odeljenjaId = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            for (Odeljenje o : odeljenja) {
                odeljenjaId = odeljenjaId.concat(o.getId().toString()).concat(",");
            }
            while (odeljenjaId.endsWith(",")) {
                odeljenjaId = odeljenjaId.substring(0, odeljenjaId.length() - 1);
            }
            StringBuilder qBuilder = new StringBuilder().append("SELECT").append("    podgrupa,").append(sifre ? "    artikalsifra as sifra," : "").append(sifre1 ? "    sifra as sifraArtikla," : "").append("    artikalnaziv AS artikal,").append("    mera as normativmera,").append("    jedinica,").append("    artikalid as artid,").append("    sum(kolicina) AS kolicina,").append("    prodajnacenapopust AS cena,").append("    sum(kolicina) * prodajnacenapopust AS vrednost").append("  FROM (").append(this.getNewRevenueReportsNestedQueryString()).append("  ) AS tmpppa").append("  GROUP BY").append("    artikalid,").append("    prodajnacenapopust").append("  ORDER BY").append("    podgrupa,").append("    artikal,").append("    prodajnacenapopust desc;");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            boolean i = true;
            ppa.setParameter(1, (Object)pBelap);
            ppa.setParameter(2, (Object)pCrnap);
            ppa.setParameter(3, (Object)medjuzbir);
            ppa.setParameter(4, from, TemporalType.DATE);
            ppa.setParameter(5, to, TemporalType.DATE);
            ppa.setParameter(6, from, TemporalType.DATE);
            ppa.setParameter(7, to, TemporalType.DATE);
            ppa.setParameter(8, (Object)pKase);
            ppa.setParameter(9, (Object)pPodgrupe);
            ppa.setParameter(10, (Object)odeljenjaId);
            System.out.println("1: " + pBelap);
            System.out.println("2: " + pCrnap);
            System.out.println("3: " + medjuzbir);
            System.out.println("4: " + from);
            System.out.println("5: " + to);
            System.out.println("6: " + pKase);
            System.out.println("7: " + pPodgrupe);
            System.out.println("8: " + odeljenjaId);
            System.out.println(ppa);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaArticleData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesArticleData(EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArticleData, boolean sifre, boolean sifre1, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pKase = "";
            String pPodgrupe = "";
            String odeljenjaId = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            for (Odeljenje o : odeljenja) {
                odeljenjaId = odeljenjaId.concat(o.getId().toString()).concat(",");
            }
            while (odeljenjaId.endsWith(",")) {
                odeljenjaId = odeljenjaId.substring(0, odeljenjaId.length() - 1);
            }
            StringBuilder qBuilder = new StringBuilder().append("SELECT").append("    podgrupa,").append(sifre ? "    artikalsifra as sifra," : "").append(sifre1 ? "    sifra as sifraArtikla," : "").append("    artikalnaziv AS artikal,").append("    mera as normativmera,").append("    jedinica,").append("    artikalid as artid,").append("    sum(kolicina) AS kolicina,").append("    prodajnacenapopust AS cena,").append("    sum(kolicina) * prodajnacenapopust AS vrednost").append("  FROM (").append(this.getNewRevenueReportsNestedQueryStringNow()).append("  ) AS tmpppa").append("  GROUP BY").append("    artikalid,").append("    prodajnacenapopust").append("  ORDER BY").append("    podgrupa,").append("    artikal,").append("    prodajnacenapopust desc;");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            boolean i = true;
            ppa.setParameter(1, (Object)pBelap);
            ppa.setParameter(2, (Object)pCrnap);
            ppa.setParameter(3, (Object)medjuzbir);
            ppa.setParameter(4, new Date(), TemporalType.DATE);
            ppa.setParameter(5, new Date(), TemporalType.DATE);
            ppa.setParameter(6, new Date(), TemporalType.DATE);
            ppa.setParameter(7, new Date(), TemporalType.DATE);
            ppa.setParameter(8, (Object)pKase);
            ppa.setParameter(9, (Object)pPodgrupe);
            ppa.setParameter(10, (Object)odeljenjaId);
            System.out.println("1: " + pBelap);
            System.out.println("2: " + pCrnap);
            System.out.println("3: " + medjuzbir);
            System.out.println("6: " + pKase);
            System.out.println("7: " + pPodgrupe);
            System.out.println("8: " + odeljenjaId);
            System.out.println(ppa);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaArticleData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesArticleDataPoSatima(EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArticleData, boolean sifre, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pOdeljenja = "";
            String pKase = "";
            String pPodgrupe = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (odeljenja == null) {
                odeljenja = this.readOdeljenjeBezMag();
            }
            for (Odeljenje od : odeljenja) {
                if (od == null || od.getId() == null || od.getMagacin() != null && od.getMagacin().booleanValue()) continue;
                pOdeljenja = pOdeljenja.concat(od.getId().toString()).concat(",");
            }
            while (pOdeljenja.endsWith(",")) {
                pOdeljenja = pOdeljenja.substring(0, pOdeljenja.length() - 1);
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            StringBuilder qBuilder = new StringBuilder().append("SELECT").append("    racunid AS racunid,").append(sifre ? "    artikalsifra as sifra," : "").append("    artikalnaziv AS artikal,").append("    mera as normativmera,").append("    artikalid as artid,").append("    sum(kolicina) AS kolicina,").append("    prodajnacenapopust AS cena,").append("    sum(kolicina) * prodajnacenapopust AS vrednost,").append(" TIME(datum) as vreme").append("  FROM (").append(this.getNewRevenueReportsNestedQueryStringPoSatima()).append("  ) AS tmpppa").append("  GROUP BY").append("    racunid, artikalsifra, artikalnaziv, mera, artikalid, prodajnacenapopust, datum").append("  ORDER BY").append("    vreme;");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)pBelap);
            ppa.setParameter(i++, (Object)pCrnap);
            ppa.setParameter(i++, (Object)medjuzbir);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, (Object)pOdeljenja);
            ppa.setParameter(i++, (Object)pKase);
            ppa.setParameter(i++, (Object)pPodgrupe);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaArticleData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesArticleData(String opadajuciRastuci, EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaArticleData, boolean sifre, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pOdeljenja = "";
            String pKase = "";
            String pPodgrupe = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (odeljenja == null) {
                odeljenja = this.readOdeljenjeBezMag();
            }
            for (Odeljenje od : odeljenja) {
                if (od == null || od.getId() == null || od.getMagacin() != null && od.getMagacin().booleanValue()) continue;
                pOdeljenja = pOdeljenja.concat(od.getId().toString()).concat(",");
            }
            while (pOdeljenja.endsWith(",")) {
                pOdeljenja = pOdeljenja.substring(0, pOdeljenja.length() - 1);
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            StringBuilder qBuilder = new StringBuilder().append("SELECT").append("    podgrupa,").append(sifre ? "    artikalsifra as sifra," : "").append("    artikalnaziv AS artikal,").append("    mera as normativmera,").append("    artikalid as artid,").append("    sum(kolicina) AS kolicina,").append("    prodajnacenapopust AS cena,").append("    sum(kolicina) * prodajnacenapopust AS vrednost").append("  FROM (").append(this.getNewRevenueReportsNestedQueryString()).append("  ) AS tmpppa").append("  GROUP BY").append("    artikalid,").append("    prodajnacenapopust").append("  ORDER BY kolicina " + opadajuciRastuci + ";");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)pBelap);
            ppa.setParameter(i++, (Object)pCrnap);
            ppa.setParameter(i++, (Object)medjuzbir);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, (Object)pOdeljenja);
            ppa.setParameter(i++, (Object)pKase);
            ppa.setParameter(i++, (Object)pPodgrupe);
            System.out.println(ppa.toString());
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaArticleData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesArticleDataTopArtikli(String opadajuciRastuci, EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<Map<String, Object>> ppaArticleData, boolean sifre, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pOdeljenja = "";
            String pKase = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (odeljenja == null) {
                odeljenja = this.readOdeljenjeBezMag();
            }
            for (Odeljenje od : odeljenja) {
                if (od == null || od.getId() == null || od.getMagacin() != null && od.getMagacin().booleanValue()) continue;
                pOdeljenja = pOdeljenja.concat(od.getId().toString()).concat(",");
            }
            while (pOdeljenja.endsWith(",")) {
                pOdeljenja = pOdeljenja.substring(0, pOdeljenja.length() - 1);
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            StringBuilder qBuilder = new StringBuilder().append("SELECT").append(sifre ? "    artikalsifra as sifra," : "").append("    artikalnaziv AS artikal,").append("    mera as normativmera,").append("    artikalid as artid,").append("    sum(kolicina) AS kolicina,").append("    prodajnacenapopust AS cena,").append("    sum(kolicina) * prodajnacenapopust AS vrednost").append("  FROM (").append(this.getNewRevenueReportsNestedQueryStringTopArtikli()).append("  ) AS tmpppa").append("    GROUP BY ").append("    artikalid, ").append("    prodajnacenapopust").append("    ORDER BY kolicina " + opadajuciRastuci + ";");
            Query ppa = em.createNativeQuery(qBuilder.toString(), Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)pBelap);
            ppa.setParameter(i++, (Object)pCrnap);
            ppa.setParameter(i++, (Object)medjuzbir);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, (Object)pOdeljenja);
            ppa.setParameter(i++, (Object)pKase);
            if (ppaArticleData == null) {
                ppaArticleData = new LinkedList<Map<String, Object>>();
            } else {
                ppaArticleData.clear();
            }
            ppaArticleData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaArticleData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesFinanceData(EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaFinanceData, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pKase = "";
            String pPodgrupe = "";
            String odeljenjaId = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            for (Odeljenje o : odeljenja) {
                odeljenjaId = odeljenjaId.concat(o.getId().toString()).concat(",");
            }
            while (odeljenjaId.endsWith(",")) {
                odeljenjaId = odeljenjaId.substring(0, odeljenjaId.length() - 1);
            }
            Query ppa = em.createNativeQuery("SELECT brojbelihplacanja, beloplacanje, crnoplacanje, count(distinct(racunid)) as brojracuna, round(sum(kolicina * prodajnacena), 2) as neto,  round(sum(kolicina * if(prodajnacenapopust < prodajnacena, (prodajnacena - prodajnacenapopust),0)),2) as popust,  round(sum(kolicina * if(prodajnacenapopust > prodajnacena, (prodajnacenapopust - prodajnacena),0)),2) as servis, round(sum(kolicina * prodajnacenapopust), 2) as bruto from (" + this.getNewRevenueReportsNestedQueryStringNow() + ") as tmp group by brojbelihplacanja, beloplacanje, crnoplacanje order by beloplacanje, crnoplacanje", Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)pBelap);
            ppa.setParameter(i++, (Object)pCrnap);
            ppa.setParameter(i++, (Object)medjuzbir);
            ppa.setParameter(i++, new Date(), TemporalType.DATE);
            ppa.setParameter(i++, new Date(), TemporalType.DATE);
            ppa.setParameter(i++, new Date(), TemporalType.DATE);
            ppa.setParameter(i++, new Date(), TemporalType.DATE);
            ppa.setParameter(i++, (Object)pKase);
            ppa.setParameter(i++, (Object)pPodgrupe);
            ppa.setParameter(i++, (Object)odeljenjaId);
            if (ppaFinanceData == null) {
                ppaFinanceData = new LinkedList<Map<String, Object>>();
            } else {
                ppaFinanceData.clear();
            }
            ppaFinanceData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaFinanceData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getNewRevenueByArticlesFinanceData(EnumSet<NacinPlacanja> belap, List<CrnoPlacanje> crnap, Date from, Date to, List<Odeljenje> odeljenja, List<Kasa> kase, List<PodgrupaArtikala> podgrupe, List<Map<String, Object>> ppaFinanceData, boolean medjuzbir) throws Exception {
        EntityManager em = this.getEM();
        try {
            String pBelap = "";
            String pCrnap = "";
            String pKase = "";
            String pPodgrupe = "";
            String odeljenjaId = "";
            if (belap != null) {
                for (NacinPlacanja np : belap) {
                    pBelap = pBelap.concat(np.name()).concat(",");
                }
                while (pBelap.endsWith(",")) {
                    pBelap = pBelap.substring(0, pBelap.length() - 1);
                }
            }
            if (crnap != null) {
                for (CrnoPlacanje cp : crnap) {
                    if (cp == null) continue;
                    pCrnap = pCrnap.concat(cp.getNaziv()).concat(",");
                }
                while (pCrnap.endsWith(",")) {
                    pCrnap = pCrnap.substring(0, pCrnap.length() - 1);
                }
            }
            if (kase == null) {
                kase = this.findAllKasa();
            }
            for (Kasa k : kase) {
                if (k == null || k.getId() == null) continue;
                pKase = pKase.concat(k.getId().toString()).concat(",");
            }
            while (pKase.endsWith(",")) {
                pKase = pKase.substring(0, pKase.length() - 1);
            }
            if (podgrupe == null) {
                podgrupe = this.readPodgrupeArtikala();
            }
            for (PodgrupaArtikala pg : podgrupe) {
                if (pg == null || pg.getId() == null) continue;
                pPodgrupe = pPodgrupe.concat(pg.getId().toString()).concat(",");
            }
            while (pPodgrupe.endsWith(",")) {
                pPodgrupe = pPodgrupe.substring(0, pPodgrupe.length() - 1);
            }
            for (Odeljenje o : odeljenja) {
                odeljenjaId = odeljenjaId.concat(o.getId().toString()).concat(",");
            }
            while (odeljenjaId.endsWith(",")) {
                odeljenjaId = odeljenjaId.substring(0, odeljenjaId.length() - 1);
            }
            Query ppa = em.createNativeQuery("SELECT brojbelihplacanja, beloplacanje, crnoplacanje, count(distinct(racunid)) as brojracuna, round(sum(kolicina * prodajnacena), 2) as neto,  round(sum(kolicina * if(prodajnacenapopust < prodajnacena, (prodajnacena - prodajnacenapopust),0)),2) as popust,  round(sum(kolicina * if(prodajnacenapopust > prodajnacena, (prodajnacenapopust - prodajnacena),0)),2) as servis, round(sum(kolicina * prodajnacenapopust), 2) as bruto from (" + this.getNewRevenueReportsNestedQueryString() + ") as tmp group by brojbelihplacanja, beloplacanje, crnoplacanje order by beloplacanje, crnoplacanje", Map.class);
            int i = 1;
            ppa.setParameter(i++, (Object)pBelap);
            ppa.setParameter(i++, (Object)pCrnap);
            ppa.setParameter(i++, (Object)medjuzbir);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, from, TemporalType.DATE);
            ppa.setParameter(i++, to, TemporalType.DATE);
            ppa.setParameter(i++, (Object)pKase);
            ppa.setParameter(i++, (Object)pPodgrupe);
            ppa.setParameter(i++, (Object)odeljenjaId);
            if (ppaFinanceData == null) {
                ppaFinanceData = new LinkedList<Map<String, Object>>();
            } else {
                ppaFinanceData.clear();
            }
            ppaFinanceData.addAll(ppa.getResultList());
            List<Map<String, Object>> list = ppaFinanceData;
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception e) {
                this.error(e.getMessage(), e);
            }
        }
    }

    public void cistacica(Date datum) {
        try {
            this.glasnaCistacica(datum);
        }
        catch (Exception ex) {
            Logger.getLogger(RestoranServer.class.getName()).warning("Cleaner closed dirty!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void glasnaCistacica(Date datum) throws Exception {
        if (datum == null) {
            datum = new Date();
        }
        for (Handler h : log.getHandlers()) {
            ((FileHandler)h).close();
            log.removeHandler(h);
        }
        File logsRoot = Logs.getLogsRootFolder();
        for (File lf : logsRoot.listFiles()) {
            try {
                File lft = File.createTempFile(lf.getName(), ".log");
                if (lf.renameTo(lft)) continue;
                lf.delete();
            }
            catch (IOException ex) {
                try {
                    lf.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        EntityManager em = this.getEM();
        try {
            Date vreme = this.getKrajnjiJPA(datum, em);
            if (vreme == null) {
                vreme = new Date();
            }
            Query cistacica1 = em.createNativeQuery("update dnevnostanje ds set ds.crnoUlaz = 0, ds.crnoIzlaz = 0 where ds.datum <= ?;");
            Query cistacica2 = em.createNativeQuery("delete from kartica where crno = 1 and datum <= ?;");
            Query cistacica3 = em.createNativeQuery("delete from otpis where crno = 1 and datum <= ?;");
            Query cistacica4 = em.createNativeQuery("delete from otpisstavka where otpis_id not in (select id from otpis);");
            Query cistacica5 = em.createNativeQuery("delete from prijemnica where crno = 1 and datumprijemnice <= ?;");
            Query cistacica6 = em.createNativeQuery("delete from prijemnicastavka where prijemnica_id not in (select id from prijemnica);");
            Query cistacica7 = em.createNativeQuery("delete from trebovanje where crno = 1 and datumtrebovanja <= ?;");
            Query cistacica8 = em.createNativeQuery("delete from trebovanjestavka where trebovanje_id not in (select id from trebovanje);");
            Query cistacica9 = em.createNativeQuery("delete from popis where crno = 1 and datum <= ?;");
            Query cistacica10 = em.createNativeQuery("delete from stavkapopisa where popis_id not in (select id from popis);");
            Query cistacica11 = em.createNativeQuery("delete from racun where crnoplacanje is not null and crnoplacanje not like '%hotel%' and datum <= ?;");
            Query cistacica12 = em.createNativeQuery("delete from tura where racun_id is not null and racun_id not in (select id from racun);");
            Query cistacica13 = em.createNativeQuery("delete from stavkaracuna where racun_id is not null and racun_id not in (select id from racun);");
            int i = 1;
            Calendar vremeKartica = Calendar.getInstance();
            vremeKartica.setTime(vreme);
            vremeKartica.set(13, 59);
            cistacica1.setParameter(i++, datum, TemporalType.DATE);
            int n = --i;
            ++i;
            cistacica2.setParameter(n, vremeKartica.getTime(), TemporalType.TIMESTAMP);
            int n2 = --i;
            ++i;
            cistacica3.setParameter(n2, datum, TemporalType.DATE);
            int n3 = --i;
            ++i;
            cistacica5.setParameter(n3, datum, TemporalType.DATE);
            int n4 = --i;
            ++i;
            cistacica7.setParameter(n4, datum, TemporalType.DATE);
            int n5 = --i;
            ++i;
            cistacica9.setParameter(n5, datum, TemporalType.DATE);
            int n6 = --i;
            ++i;
            cistacica11.setParameter(n6, vreme, TemporalType.TIMESTAMP);
            --i;
            em.getTransaction().begin();
            cistacica1.executeUpdate();
            cistacica2.executeUpdate();
            cistacica3.executeUpdate();
            cistacica4.executeUpdate();
            cistacica5.executeUpdate();
            cistacica6.executeUpdate();
            cistacica7.executeUpdate();
            cistacica8.executeUpdate();
            cistacica9.executeUpdate();
            cistacica10.executeUpdate();
            cistacica11.executeUpdate();
            cistacica12.executeUpdate();
            cistacica13.executeUpdate();
            em.getTransaction().commit();
            this.refresh();
        }
        finally {
            if (em != null && em.getTransaction() != null && em.getTransaction().isActive()) {
                try {
                    em.getTransaction().rollback();
                }
                catch (Exception exception) {}
            }
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GrafikSale> findGrafiksForKonobar(Konobar konobar) throws PersistenceException {
        EntityManager em = this.getEM();
        try {
            if (!em.contains((Object)konobar)) {
                konobar = (Konobar)em.find(Konobar.class, (Object)konobar.getId());
            }
            TypedQuery fgfkQ = em.createNamedQuery("GrafikSale.findGrafiksForKonobar", GrafikSale.class);
            fgfkQ.setParameter("konobar", (Object)konobar);
            List list = fgfkQ.getResultList();
            return list;
        }
        finally {
            try {
                em.close();
            }
            catch (Exception exception) {}
        }
    }

    public void storno(double id) {
        String brisi = "DELETE FROM stavkaracuna WHERE  id = " + id + " or GLAVNASTAVKA_ID = " + id + "";
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement(brisi);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void stornoStavke(Storno storno) {
        try {
            new StampaStorna(storno, this.restoran);
        }
        catch (Exception ex) {
            MessageBox mb = new MessageBox(this.shell, 40);
            mb.setText(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("TEXT_BARMASTER"));
            mb.setMessage(ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale()).getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_STORNIRANJA"));
            mb.open();
            Logger.getLogger(FrontOffice3.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storno processStorno(List<Tura> ture, Storno storno) {
        try {
            Sto sto;
            LinkedList tureZaSto = new LinkedList(this.base.createNamedQuery("Tura.findOpenByTableNumber", Tura.class).setParameter("brojStola", (Object)storno.getBrojStola()).getResultList());
            this.base.getTransaction().begin();
            if (!storno.getStavke().isEmpty()) {
                this.base.merge((Object)storno);
            }
            this.base.flush();
            for (Tura tura : ture) {
                ListIterator<StavkaRacuna> liStavke = tura.getStavke().listIterator();
                while (liStavke.hasNext()) {
                    StavkaRacuna sr = liStavke.next();
                    if (sr.getKolicina() <= 0.0) {
                        this.base.remove((Object)sr);
                        liStavke.remove();
                        continue;
                    }
                    this.base.merge((Object)sr);
                    this.base.flush();
                    this.base.refresh((Object)sr);
                }
                if (tura.getStavke().isEmpty()) {
                    boolean contains = this.base.contains((Object)tura);
                    Tura tura1 = null;
                    if (!contains) {
                        tura1 = (Tura)this.base.merge((Object)tura);
                        contains = this.base.contains((Object)tura1);
                    }
                    this.base.remove((Object)tura);
                    this.base.flush();
                    tureZaSto.remove(tura);
                    continue;
                }
                this.base.refresh((Object)tura);
            }
            ListIterator turaIterator = tureZaSto.listIterator();
            while (turaIterator.hasNext()) {
                Tura tura;
                tura = (Tura)turaIterator.next();
                if (!tura.getStavke().isEmpty()) continue;
                boolean contains = this.base.contains((Object)tura);
                if (!contains) {
                    Tura tura1 = (Tura)this.base.merge((Object)tura);
                    contains = this.base.contains((Object)tura1);
                }
                this.base.remove((Object)tura);
                turaIterator.remove();
            }
            if (tureZaSto.isEmpty() && (sto = this.getSto(storno.getBrojStola())) != null) {
                this.deleteSto(sto.getBroj());
            }
            this.base.getTransaction().commit();
            Storno storno2 = storno;
            return storno2;
        }
        finally {
            if (this.base.getTransaction() != null && this.base.getTransaction().isActive()) {
                this.base.getTransaction().rollback();
            }
        }
    }

    public void killKomitent(Komitent k) {
        this.base.getTransaction().begin();
        this.base.remove((Object)k);
        this.base.getTransaction().commit();
    }

    public void killStalniGost(StalniGost k) {
        this.base.getTransaction().begin();
        this.base.remove((Object)k);
        this.base.getTransaction().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Storno processStorno(StavkaRacuna stavka, Storno storno) {
        EntityManager em = this.base;
        EntityTransaction transaction = null;
        try {
            Sto sto;
            LinkedList tureZaSto = new LinkedList(em.createNamedQuery("Tura.findOpenByTableNumber", Tura.class).setParameter("brojStola", (Object)storno.getBrojStola()).getResultList());
            Tura tura = stavka.getTura();
            transaction = em.getTransaction();
            transaction.begin();
            List<StornoStavka> stavke = storno.getStavke();
            storno.setStavke(Collections.emptyList());
            storno.setStavke(stavke);
            em.merge((Object)storno);
            em.flush();
            if (stavka.getKolicina() <= 0.0) {
                if (!stavka.getPodStavke().isEmpty()) {
                    for (StavkaRacuna podstavka : stavka.getPodStavke()) {
                        em.remove((Object)podstavka);
                        tura.getStavke().remove(podstavka);
                    }
                }
                em.remove((Object)stavka);
                tura.getStavke().remove(stavka);
                em.flush();
                if (stavka.getGlavnaStavka() != null && em.contains((Object)stavka.getGlavnaStavka())) {
                    stavka.getGlavnaStavka().getPodStavke().remove(stavka);
                    em.refresh((Object)stavka.getGlavnaStavka());
                }
                em.refresh((Object)tura);
            } else {
                em.merge((Object)stavka);
                em.flush();
                em.refresh((Object)stavka);
            }
            if (tura.getStavke().isEmpty()) {
                tureZaSto.remove(tura);
                em.remove((Object)tura);
                em.flush();
            }
            if (tureZaSto.isEmpty() && (sto = this.getSto(storno.getBrojStola())) != null) {
                em.remove((Object)sto);
                em.flush();
            }
            transaction.commit();
            Storno storno2 = storno;
            return storno2;
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CenaZaDan> findAllCenaZaDan() {
        EntityManager em = this.getEM();
        try {
            TypedQuery qAllPrice = em.createNamedQuery("CenaZaDan.getAllCena", CenaZaDan.class);
            List list = qAllPrice.getResultList();
            return list;
        }
        finally {
            JPAUtil.closeEmQuiet(em);
        }
    }

    public List<NivelacijaRow> nivelacija(Date date) {
        Pattern p = Pattern.compile("\\?");
        String query = Queries.QUERIES.get((Object)QueryName.NIVELACIJA);
        Matcher matcher = p.matcher(query);
        query = matcher.replaceFirst(String.format("'%1$tY-%1$tm-%1$td'", date));
        String[] queries = query.split(";");
        LinkedList<NivelacijaRow> results = new LinkedList<NivelacijaRow>();
        try (Connection conn = this.getConnection();
             Statement ps = conn.createStatement();){
            ps.executeUpdate(queries[0]);
            ResultSet rs = ps.executeQuery(queries[1]);
            while (rs.next()) {
                NivelacijaRow row = new NivelacijaRow();
                row.redniBroj = rs.getInt("redni_broj");
                row.naziv = rs.getString("artikal_naziv");
                row.jedinicaMere = rs.getString("jedinica_mere");
                row.kolicina = rs.getBigDecimal("kolicina");
                row.staraCena = rs.getBigDecimal("stara_cena");
                row.novaCena = rs.getBigDecimal("nova_cena");
                row.povecanjeCene = rs.getBigDecimal("povecanje_cene");
                row.PDV = rs.getBigDecimal("pdv");
                row.povecanjePDVa = rs.getBigDecimal("povecanje_pdva");
                row.staraCenaSaPDVom = rs.getBigDecimal("stara_cena_sa_pdv");
                row.novaCenaSaPDVom = rs.getBigDecimal("nova_cena_sa_pdv");
                row.povecanjeRazlikeUCeni = rs.getBigDecimal("povecanje_razlike_u_ceni");
                row.povecanjePoreza = rs.getBigDecimal("povecanje_poreza");
                results.add(row);
            }
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Greska kod ucitavanja podataka o nivelaciji", ex);
            throw new RuntimeException("Greska kod ucitavanja podataka o nivelaciji");
        }
        return results;
    }

    public static void main(String ... args) {
        System.out.println("Test");
        EntityManagerFactory emf = JPAUtil.getRestEmf();
        EntityManager em = emf.createEntityManager();
        SingletonEmReference emRef = new SingletonEmReference(em);
        RestoranServer server = new RestoranServer(emf, em, emRef, "localhost", null, "root", "928374", "restoran");
        em.close();
        emf.close();
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public List<CenovnikTip> getCenovnikTipOld() {
        Query query = this.base.createQuery("SELECT o FROM CenovnikTip o");
        return query.getResultList();
    }

    public void insertCenovnikTip() {
        if (this.getCenovnikTipOld().isEmpty()) {
            this.base.getTransaction().begin();
            CenovnikTip cTipJednokratni = new CenovnikTip("Jednokratni");
            CenovnikTip cTipDnevni = new CenovnikTip("Dnevni");
            CenovnikTip cTipPeriodicni = new CenovnikTip("Periodi\u010dni");
            this.base.persist((Object)cTipJednokratni);
            this.base.persist((Object)cTipDnevni);
            this.base.persist((Object)cTipPeriodicni);
            this.base.getTransaction().commit();
        }
    }

    public boolean getZdBrojIsNull() {
        Query query = this.base.createNativeQuery("SELECT zd.id FROM zd WHERE zd.zdBroj IS NULL ORDER BY zd.id DESC LIMIT 1", Long.class);
        try {
            return query.getSingleResult() != null;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    public boolean getRacunZdBrojIsNull() {
        Query query = this.base.createNativeQuery("SELECT r.id FROM racun r WHERE r.zdBroj IS NULL ORDER BY r.id DESC LIMIT 1", Long.class);
        try {
            return query.getSingleResult() != null;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    public void updateRacunZdBroj() {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String update = "UPDATE racun r\nset r.zdBroj = (select z.zdBroj from zd z where z.zakljucenje < r.datum and z.pocetak = 1\ngroup by z.id \norder by z.zakljucenje desc limit 1)";
        System.out.println(update);
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(update);
            stmt.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void updateZD(ZD zd) {
        this.base.getTransaction().begin();
        this.base.merge((Object)zd);
        this.base.flush();
        this.base.getTransaction().commit();
    }

    public boolean upisDnevnogUtroska(Racun racun) {
        System.out.println("ovde kreiram utroske");
        for (DnevniUtrosak dUtrosak : Utrosci.utrosciPoRacunu(this, racun)) {
            System.out.println(dUtrosak.getArtikal().getName() + " " + dUtrosak.getKolicina());
        }
        Logger.getLogger(FrontOffice3.class.getName()).info("Kreiranje utro\u0161aka za racun broj:" + racun.getBrojRacuna() + " datum:" + racun.getDatum() + " \n --------------------------------------------------------------------------------------------");
        ZD zd = this.getZDbyID(racun.getZdBroj());
        boolean upis = false;
        List<Object> listaDU = new LinkedList();
        try {
            listaDU = this.getDnevniUtrosakList(zd.getZdBroj());
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            HashMap<Artikal, Double> artikal_kolicina = new HashMap<Artikal, Double>();
            HashMap<Artikal, Double> normativ_kolicina = new HashMap<Artikal, Double>();
            HashMap konacnaLista = new HashMap();
            boolean prolazi = false;
            for (StavkaRacuna sr : racun.getStavke()) {
                artikal_kolicina.put(sr.getArtikal(), sr.getKolicina());
            }
            ArrayList<Kartica> karticaList = new ArrayList<Kartica>();
            for (Artikal artikal : artikal_kolicina.keySet()) {
                if (artikal.getOdeljenje() == null) continue;
                for (Odeljenje o : artikal.getOdeljenja()) {
                    Kasa kasa = this.getCurrentCounter();
                    if (kasa == null) {
                        kasa = racun.getKasa();
                    }
                    if (kasa.getOdeljenja().contains(o)) {
                        prolazi = true;
                    }
                    if (!prolazi || artikal.getTip() != TipArtikla.SLOZ && artikal.getTip() != TipArtikla.DODA) continue;
                    for (Kartica k : SkidanjeNormativa.napraviKarticeOdeljenjeRekPoOdeljenju(SkidanjeNormativa.razloziArtikalPoOdeljenju(artikal, (Double)artikal_kolicina.get(artikal), this, artikal.getOdeljenje(), racun.getDatum()), this, o, racun.getDatum())) {
                        boolean b = true;
                        for (Kartica k2 : karticaList) {
                            if (k.getArtikal().getId() != k2.getArtikal().getId() || k.getArtikal().getOdeljenje().getId() != k2.getArtikal().getOdeljenje().getId()) continue;
                            k2.setKolicina(BigDecimal.valueOf(k2.getKolicina() + k.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                            b = false;
                        }
                        if (!b) continue;
                        k.setDokument("");
                        k.setCrno(false);
                        karticaList.add(k);
                    }
                }
            }
            if (prolazi) {
                for (Kartica kartica : karticaList) {
                    if (kartica.getArtikal().getTip() == TipArtikla.SLOZ || kartica.getArtikal().getTip() == TipArtikla.DODA) continue;
                    normativ_kolicina.put(kartica.getArtikal(), kartica.getKolicina() * -1.0);
                }
                for (Artikal artikal : normativ_kolicina.keySet()) {
                    konacnaLista.put(artikal, normativ_kolicina.get(artikal));
                }
                for (Artikal artikal : artikal_kolicina.keySet()) {
                    if (artikal.getTip() != TipArtikla.PROD && artikal.getTip() != TipArtikla.POLU) continue;
                    if (!konacnaLista.containsKey(artikal)) {
                        konacnaLista.put(artikal, (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                        continue;
                    }
                    konacnaLista.put(artikal, (Double)konacnaLista.get(artikal) + (Double)artikal_kolicina.get(artikal) * artikal.getMera());
                }
                for (Artikal artikal : konacnaLista.keySet()) {
                    boolean isti = false;
                    DnevniUtrosak dUtrosak = null;
                    for (DnevniUtrosak dnevniUtrosak : listaDU) {
                        boolean osnovnoDodatno = false;
                        if (racun.getCrnoPlacanje() != null) {
                            boolean bl = osnovnoDodatno = !racun.getCrnoPlacanje().equals("") && racun.getNaOsnovno() == false;
                        }
                        if (artikal.getId() != dnevniUtrosak.getArtikal().getId() || artikal.getOdeljenje() != dnevniUtrosak.getOdeljenje() || !String.valueOf(osnovnoDodatno).equals(String.valueOf(dnevniUtrosak.isDodatno()))) continue;
                        isti = true;
                        dnevniUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(dnevniUtrosak.getArtikal()) + dnevniUtrosak.getKolicina()).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                        dUtrosak = dnevniUtrosak;
                        break;
                    }
                    if (isti) {
                        this.updateDU(dUtrosak);
                        continue;
                    }
                    dUtrosak = new DnevniUtrosak();
                    dUtrosak.setArtikal(artikal);
                    dUtrosak.setOdeljenje(artikal.getOdeljenje());
                    dUtrosak.setZdBroj(zd.getZdBroj());
                    dUtrosak.setKolicina(BigDecimal.valueOf((Double)konacnaLista.get(artikal)).setScale(4, RoundingMode.HALF_EVEN).doubleValue());
                    dUtrosak.setNabavnaCena(artikal.getTip() != TipArtikla.POLU ? this.getLastNabavnaCenaBelaBezPDV(artikal, racun.getDatum()) : this.getNabavnaCenaPoluproizvodBezPDV(artikal, 1.0));
                    if (racun.getCrnoPlacanje() != null) {
                        dUtrosak.setDodatno(!racun.getCrnoPlacanje().equals("") && racun.getNaOsnovno() == false);
                    } else {
                        dUtrosak.setDodatno(false);
                    }
                    this.insertDU(dUtrosak);
                }
                upis = true;
            }
        }
        catch (Exception e) {
            upis = false;
            e.printStackTrace();
        }
        return upis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDU(DnevniUtrosak dnevniUtrosak) {
        Logger.getLogger(FrontOffice3.class.getName()).info("Insert dnevnog utro\u0161ka za Artikal:" + dnevniUtrosak.getArtikal().getName() + " koli\u010dina:" + dnevniUtrosak.getKolicina() + " odeljenje:" + dnevniUtrosak.getOdeljenje() + "\n--------------------------------------------------------------------------------------------");
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String insert = "INSERT INTO `dnevniutrosak` (`dodatno`, `kolicina`, `nabavnaCena`, `zdBroj`, `ARTIKAL_ID`, `ODELJENJE_ID`) VALUES (?, ?, ?, ?, ?, ?);";
        try {
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(insert);
            stmt.setBoolean(1, dnevniUtrosak.isDodatno());
            stmt.setDouble(2, dnevniUtrosak.getKolicina());
            stmt.setDouble(3, dnevniUtrosak.getNabavnaCena());
            stmt.setLong(4, dnevniUtrosak.getZdBroj());
            stmt.setLong(5, dnevniUtrosak.getArtikal().getId());
            stmt.setLong(6, dnevniUtrosak.getOdeljenje().getId());
            int brojRedova = stmt.executeUpdate();
            conn.commit();
            Logger.getLogger(FrontOffice3.class.getName()).info("Broj insertovanih redova:" + brojRedova + "\n--------------------------------------------------------------------------------------------");
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            Logger.getLogger(FrontOffice3.class.getName()).info("Greska kod insert-a dnevnog utroska:\n--------------------------------------------------------------------------------------------\n" + ex.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDU(DnevniUtrosak dnevniUtrosak) {
        Logger.getLogger(FrontOffice3.class.getName()).info("Update dnevnog utroska za artikal:" + dnevniUtrosak.getArtikal().getName() + " kolicina:" + dnevniUtrosak.getKolicina() + " odeljenje:" + dnevniUtrosak.getOdeljenje() + "\n--------------------------------------------------------------------------------------------");
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String insert = "UPDATE `dnevniutrosak` SET `dodatno`= ?, `kolicina`= ?, `zdBroj`= ?, `nabavnaCena`= ?, `ARTIKAL_ID`= ?, `ODELJENJE_ID` = ? WHERE  `id` = ?;";
        try {
            conn.setAutoCommit(false);
            stmt = conn.prepareStatement(insert);
            stmt.setBoolean(1, dnevniUtrosak.isDodatno());
            stmt.setDouble(2, dnevniUtrosak.getKolicina());
            stmt.setLong(3, dnevniUtrosak.getZdBroj());
            stmt.setDouble(4, dnevniUtrosak.getNabavnaCena());
            stmt.setLong(5, dnevniUtrosak.getArtikal().getId());
            stmt.setLong(6, dnevniUtrosak.getOdeljenje().getId());
            stmt.setLong(7, dnevniUtrosak.getId());
            int brojRedova = stmt.executeUpdate();
            Logger.getLogger(FrontOffice3.class.getName()).info("Broj upadate redova:" + brojRedova + "\n--------------------------------------------------------------------------------------------");
            conn.commit();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
            Logger.getLogger(FrontOffice3.class.getName()).info("Greska kod update dnevnog utroska:\n--------------------------------------------------------------------------------------------\n" + ex.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    public List<DnevniUtrosak> getDnevniUtrosakListByArtikal(long zdBroj, Artikal a, Odeljenje odeljenje, boolean crno) {
        Query q = this.base.createQuery("SELECT d FROM DnevniUtrosak d WHERE d.zdBroj = :zdBroj AND d.artikal = :a AND d.odeljenje = :o and d.dodatno = :crno");
        q.setParameter("zdBroj", (Object)zdBroj);
        q.setParameter("a", (Object)a);
        q.setParameter("o", (Object)odeljenje);
        q.setParameter("crno", (Object)crno);
        return q.getResultList() != null ? q.getResultList() : null;
    }

    public List<DnevniUtrosak> getDnevniUtrosakListByArtikal(long zdBroj, Artikal a) {
        Query q = this.base.createQuery("SELECT d FROM DnevniUtrosak d WHERE d.zdBroj = :zdBroj AND d.artikal = :a");
        q.setParameter("zdBroj", (Object)zdBroj);
        q.setParameter("a", (Object)a);
        return q.getResultList() != null ? q.getResultList() : null;
    }

    public List<DnevniUtrosak> getDnevniUtrosakList(long zdBroj) {
        Query q = this.base.createQuery("SELECT d FROM DnevniUtrosak d WHERE d.zdBroj = :zdBroj");
        q.setParameter("zdBroj", (Object)zdBroj);
        return q.getResultList() != null ? q.getResultList() : null;
    }

    public List<ProizvodnjaUtrosak> getProizvodnjaUtrosakList(long proizvodnjaID) {
        Query q = this.base.createQuery("SELECT pu FROM ProizvodnjaUtrosak pu WHERE pu.proizvodnja.id = :proizvodnjaID");
        q.setParameter("proizvodnjaID", (Object)proizvodnjaID);
        return q.getResultList() != null ? q.getResultList() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertIntoKasa_Odeljenje(Kasa k, Odeljenje o) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        String insert = "INSERT INTO `restoran`.`kasa_odeljenje` (`KASA_ID`, `ODELJENJA_ID`) VALUES (" + k.getId() + ", " + o.getId() + ");";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(insert);
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    public void deleteKasaOdeljenje(Odeljenje o) {
        String query = "Delete from kasa_odeljenje where ODELJENJA_ID=?";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, o.getId());
            ps.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isKasaOdeljenjeEmpty() {
        String query = "SELECT * from kasa_odeljenje";
        try {
            Statement st = this.getConnection().createStatement();
            ResultSet rs = st.executeQuery(query);
            return !rs.next();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public double getNabavnaCenaPoluproizvodBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.POLU)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += this.getLastNabavnaCenaBelaBezPDV(a, new Date());
            }
        }
        return trNv;
    }

    public List<NormativArtikal> getNormativArtiaklList() {
        Query q = this.base.createQuery("SELECT na FROM NormativArtikal na");
        return q.getResultList();
    }

    public NormativArtikal getNormativArtikal(long id) {
        try {
            Query q = this.base.createQuery("SELECT na FROM NormativArtikal na where na.id = :id");
            q.setParameter("id", (Object)id);
            return (NormativArtikal)q.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public NormativArtikal getNormativArtikalLastByArtikalID(long id, Date datum) {
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("SELECT na.* FROM normativartikal na where na.ARTIKAL_ID = ? and DATE(na.datum) <= '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' order by na.id desc LIMIT 1");
            pStatement.setLong(1, id);
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            NormativArtikal normativArtikal = new NormativArtikal();
            normativArtikal.setId(rSet.getLong("id"));
            normativArtikal.setDatum(rSet.getDate("datum"));
            normativArtikal.setUname(rSet.getString("uname"));
            normativArtikal.setArtikal(this.getArtikal(rSet.getLong("ARTIKAL_ID")));
            return normativArtikal;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void addNormativArtikal(NormativArtikal normativArtikal) {
        this.base.getTransaction().begin();
        this.base.persist((Object)normativArtikal);
        this.base.getTransaction().commit();
    }

    public void updateZdBrojNUllzaPeriod(Date result) {
        java.sql.Date queryDate = new java.sql.Date(result.getTime());
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        PreparedStatement stmt = null;
        String update = "update racun set racun.zdBroj = NULL where racun.zdBroj IN (select zd.zdBroj from zd where zd.datum >= CAST(? AS DATE))";
        try {
            stmt = conn.prepareStatement(update);
            stmt.setDate(1, queryDate);
            System.out.println(stmt);
            stmt.execute();
            conn.commit();
        }
        catch (SQLException ex) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ex.printStackTrace();
        }
        update = "update zd set zd.zdBroj = null where zd.datum >= CAST(? AS DATE)";
        System.out.println(update);
        try {
            stmt = conn.prepareStatement(update);
            stmt.setDate(1, queryDate);
            System.out.println(stmt);
            stmt.execute();
            conn.commit();
            stmt.close();
        }
        catch (SQLException ex) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ex.printStackTrace();
        }
    }

    public void deleteUtrosciNUllzaPeriod(Date result) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        System.out.println("result " + new java.sql.Date(result.getTime()));
        String update = "delete from dnevniutrosak where dnevniutrosak.zdBroj in (select zd.zdBroj from zd where zd.datum >= DATE('" + new java.sql.Date(result.getTime()) + "'))";
        try {
            stmt = conn.createStatement();
            stmt.executeUpdate(update);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void deleteProizvodnjaUtrosakNullByProizvodnja(Proizvodnja proizvodnja) {
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("DELETE FROM `restoran`.`proizvodnjautrosak` WHERE  `PROIZVODNJA_ID` = ?;");
            pStatement.setLong(1, proizvodnja.getId());
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteUtrosakDocUtrosakNullByUtrosakDoc(UtrosakDoc utrosakDoc) {
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("DELETE FROM `restoran`.`utrosakdocutrosak` WHERE  `UTROSAKDOC_ID` = ?;");
            pStatement.setLong(1, utrosakDoc.getId());
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteOtpisUtrosakNullByOtpis(Otpis otpis) {
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("DELETE FROM `restoran`.`otpisutrosak` WHERE  `OTPIS_ID` = ?;");
            pStatement.setLong(1, otpis.getId());
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<String[]> getNewLagerLista(Odeljenje o, java.sql.Date datum, boolean isCrno, boolean isBelo) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList<String[]> lista = new LinkedList<String[]>();
        String update = "";
        if (o.getId() != 1L) {
            update = "SELECT ao.ARTIKLI_ID, du.dodatno, a.jedinicaMere as JM, skrNaziv as Artikal, COALESCE(IF(du.dodatno = 0, ROUND(sum(du.kolicina), 4), 0), 0) AS UtrosciNula, COALESCE(IF(du.dodatno = 1, ROUND(sum(du.kolicina), 4), 0), 0) AS UtrosciJedan, COALESCE(ROUND((select sum(ts.kolicina) as Kolicina from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = ao.ARTIKLI_ID and t.tip IN ('IZ_MAGACINA' , 'DIREKTNO_SA_KNJIZ') and t.crno = du.dodatno and t.datumTrebovanja <= '" + datum + "' and t.U_ID = ao.ODELJENJA_ID), 4), 0) AS UlazPlus, COALESCE(ROUND((select sum(ts.kolicina) as Kolicina from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = ao.ARTIKLI_ID and t.tip IN ('POVRAT_U_MAGACIN') and t.datumTrebovanja <= '" + datum + "' and t.crno = du.dodatno and t.IZ_ID = ao.ODELJENJA_ID), 4), 0) AS UlazMinus \nFROM artikal_odeljenje ao \nLEFT JOIN dnevniutrosak du ON du.ARTIKAL_ID = ao.ARTIKLI_ID \nLEFT JOIN artikal a on a.id = ao.ARTIKLI_ID\nWHERE ao.ODELJENJA_ID = " + o.getId() + " and du.dodatno = " + !isBelo + " and du.zdBroj <= (select zd1.zdBroj from zd zd1 where zd1.datum = DATE('" + datum + "') and zd1.pocetak = 1) and \nao.ARTIKLI_ID not in (((select a.ID from artikal a where a.tip in ('SLOZ', 'POTR', 'DODA'))))\ngroup by ao.ARTIKLI_ID, du.dodatno\n\nunion \n\nSELECT ao.ARTIKLI_ID, du.dodatno, a.jedinicaMere as JM, skrNaziv as Artikal, COALESCE(IF(du.dodatno = 0, ROUND(sum(du.kolicina), 4), 0), 0) AS UtrosciNula, COALESCE(IF(du.dodatno = 1, ROUND(sum(du.kolicina), 4), 0), 0) AS UtrosciJedan, COALESCE(ROUND((select sum(ts.kolicina) as Kolicina from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = ao.ARTIKLI_ID and t.tip IN ('IZ_MAGACINA' , 'DIREKTNO_SA_KNJIZ') and t.crno = du.dodatno and t.datumTrebovanja <= '" + datum + "' and t.U_ID = ao.ODELJENJA_ID), 4), 0) AS UlazPlus, COALESCE(ROUND((select sum(ts.kolicina) as Kolicina from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = ao.ARTIKLI_ID and t.tip IN ('POVRAT_U_MAGACIN') and t.datumTrebovanja <= '" + datum + "' and t.crno = du.dodatno and t.IZ_ID = ao.ODELJENJA_ID), 4), 0) AS UlazMinus \nFROM artikal_odeljenje ao \nLEFT JOIN dnevniutrosak du ON du.ARTIKAL_ID = ao.ARTIKLI_ID \nLEFT JOIN artikal a on a.id = ao.ARTIKLI_ID\nWHERE ao.ODELJENJA_ID = " + o.getId() + " and du.dodatno = " + isCrno + " and du.zdBroj <= (select zd1.zdBroj from zd zd1 where zd1.datum = '" + datum + "' and zd1.pocetak = 1) and \nao.ARTIKLI_ID not in (((select a.ID from artikal a where a.tip in ('SLOZ', 'POTR', 'DODA'))))\ngroup by ao.ARTIKLI_ID, du.dodatno \norder by Artikal";
        }
        try {
            stmt = conn.createStatement();
            System.out.println(update);
            ResultSet rs = stmt.executeQuery(update);
            while (rs.next()) {
                String artikalID = rs.getLong("ARTIKLI_ID") + "";
                String jm = rs.getString("JM");
                String artikal = rs.getString("Artikal");
                String osnovno = null;
                String dodatno = null;
                if (!rs.getBoolean("dodatno")) {
                    osnovno = String.valueOf(this.round(rs.getDouble("UlazPlus"), 4) - this.round(rs.getDouble("UlazMinus"), 4) - this.round(rs.getDouble("UtrosciNula"), 4));
                } else {
                    dodatno = String.valueOf(this.round(rs.getDouble("UlazPlus"), 4) - this.round(rs.getDouble("UlazMinus"), 4) - this.round(rs.getDouble("UtrosciJedan"), 4));
                }
                String ukupno = String.valueOf(this.round(Double.parseDouble(osnovno == null ? (osnovno = "0") : osnovno), 4) + this.round(Double.parseDouble(dodatno == null ? (dodatno = "0") : dodatno), 4));
                String[] toppings = new String[]{artikalID, jm, artikal, osnovno, dodatno, ukupno};
                lista.add(toppings);
            }
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return lista;
    }

    public double getLagerZaArtikal(Artikal artikal, boolean crno, Odeljenje o, Date d) {
        return this.getSumBelo(d, o, artikal, crno, false);
    }

    public double getSumBelo(Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno, boolean pocetnoStanje) {
        Popis popis;
        java.sql.Date datumzaQuery = new java.sql.Date(datum.getTime());
        java.sql.Date datumzaPopis = new java.sql.Date(datum.getTime());
        if (pocetnoStanje) {
            datumzaPopis = new java.sql.Date(Konstante.getTomorrowDate(datum).getTime());
        }
        Date datumPopisa = (popis = this.getPopisLager(datumzaPopis, o, dodatnoOsnovno)) != null ? popis.getDatum() : this.getDatumisNotNUll();
        Date datumZD = this.getZDbyDatum(datumPopisa).getZakljucenje();
        double utrosak = this.getLagerListaZaArtikal(popis != null ? datumPopisa : datumZD, datumzaQuery, o, artikal, dodatnoOsnovno);
        double pocetno = 0.0;
        if (popis != null) {
            pocetno = this.getPocetnoStanje(popis, dodatnoOsnovno, artikal);
        }
        double proizvodnjaUtrosak = this.getProizvodnjaUtrosakLager(datumPopisa, datumzaQuery, o, artikal, dodatnoOsnovno);
        double otpisUtrosak = this.getOtpisUtrosak(datumPopisa, datumzaQuery, o, artikal, dodatnoOsnovno);
        double utrosakDocUtrosak = this.getUtrosakDocUtrosak(datumPopisa, datumzaQuery, o, artikal, dodatnoOsnovno);
        double proizvodnjaStavka = this.getProizvodnjaStavke(datumPopisa, datumzaQuery, o, artikal, dodatnoOsnovno);
        return this.round(pocetno + utrosak - proizvodnjaUtrosak - otpisUtrosak - utrosakDocUtrosak + proizvodnjaStavka, 4);
    }

    private double getProizvodnjaStavke(Date datumPopisa, Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList lista = new LinkedList();
        String upit = "SELECT COALESCE(SUM(ps.kolicina), 0) AS 'ProizvodnjaStavka' FROM proizvodnjastavka ps LEFT JOIN proizvodnja p ON p.id = ps.PROIZVODNJA_ID\nWHERE p.ODELJENJE_ID = " + o.getId() + " AND p.crno = " + dodatnoOsnovno + " AND ps.ARTIKAL_ID = " + artikal.getId() + " AND p.datum BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' AND '" + datum + "'";
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(upit);
            if (rs.next()) {
                return rs.getDouble("ProizvodnjaStavka");
            }
            return 0.0;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    private double getPocetnoStanje(Popis popis, boolean dodatnoOsnovno, Artikal artikal) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList lista = new LinkedList();
        String upit = "SELECT sp.stanje1 AS PocetnoStanje  FROM stavkapopisa sp WHERE sp.ARTIKAL_ID = " + artikal.getId() + " AND sp.POPIS_ID = " + popis.getId();
        try {
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(upit);
            if (rs.next()) {
                return rs.getDouble("PocetnoStanje");
            }
            return 0.0;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public double getProizvodnjaUtrosakLager(Date datumPopisa, Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno) {
        Connection conn = this.getConnection();
        PreparedStatement pStmt = null;
        LinkedList lista = new LinkedList();
        String upit = "SELECT COALESCE(SUM(pu.kolicina), 0) AS ProizvodnjaUtrosak FROM proizvodnjaUtrosak pu LEFT JOIN proizvodnja p ON p.id = pu.PROIZVODNJA_ID WHERE pu.ODELJENJE_ID =? AND pu.ARTIKAL_ID =? AND DATE(p.datum) BETWEEN ? AND ? AND p.crno =? ";
        try {
            pStmt = conn.prepareStatement(upit);
            pStmt.setLong(1, o.getId());
            pStmt.setLong(2, artikal.getId());
            pStmt.setString(3, new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa));
            pStmt.setDate(4, new java.sql.Date(datum.getTime()));
            pStmt.setBoolean(5, dodatnoOsnovno);
            ResultSet rs = pStmt.executeQuery();
            if (rs.next()) {
                System.out.println(rs.getDouble("ProizvodnjaUtrosak"));
                return rs.getDouble("ProizvodnjaUtrosak");
            }
            return 0.0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getOtpisUtrosak(Date datumPopisa, Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList lista = new LinkedList();
        String upit = "SELECT COALESCE(SUM(ou.kolicina), 0) AS 'OtpisUtrosak' FROM otpisutrosak ou LEFT JOIN otpis o ON o.id = ou.OTPIS_ID\nWHERE ou.ODELJENJE_ID = " + o.getId() + " AND o.crno = " + dodatnoOsnovno + " AND ou.ARTIKAL_ID = " + artikal.getId() + " AND DATE(o.datum) BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' AND '" + datum + "'";
        try {
            stmt = conn.createStatement();
            System.out.println(upit);
            ResultSet rs = stmt.executeQuery(upit);
            if (rs.next()) {
                return rs.getDouble("OtpisUtrosak");
            }
            return 0.0;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public double getUtrosakDocUtrosak(Date datumPopisa, Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList lista = new LinkedList();
        String upit = "SELECT COALESCE(SUM(udu.kolicina), 0) AS 'UtrosakDocUtrosak' FROM utrosakdocutrosak udu LEFT JOIN utrosakdoc ud ON ud.id = udu.UTROSAKDOC_ID\nWHERE udu.ODELJENJE_ID = " + o.getId() + " AND ud.crno = " + dodatnoOsnovno + " AND udu.ARTIKAL_ID = " + artikal.getId() + " AND DATE(ud.datum) BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' AND '" + datum + "'";
        try {
            stmt = conn.createStatement();
            System.out.println(upit);
            ResultSet rs = stmt.executeQuery(upit);
            if (rs.next()) {
                return rs.getDouble("UtrosakDocUtrosak");
            }
            return 0.0;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    private double getLagerListaZaArtikal(Date datumPopisa, Date datum, Odeljenje o, Artikal artikal, boolean dodatnoOsnovno) {
        Connection conn = this.getConnection();
        Statement stmt = null;
        LinkedList lista = new LinkedList();
        String upit = "";
        upit = o.getId() == 1L ? "select COALESCE(sum(ps.kolicina), 0) + (select COALESCE(sum(ts.kolicina), 0) from trebovanjestavka ts\nleft join trebovanje t on t.id = ts.TREBOVANJE_ID\nwhere ts.ARTIKAL_ID = " + artikal.getId() + "\nand t.datumTrebovanja BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' and '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "'\nand (t.U_ID = 1\n or t.tip IN ('POVRAT_U_MAGACIN', 'OTPREM_SA_KNJIZ')) and t.crno = " + dodatnoOsnovno + ")  - (select COALESCE(sum(ts.kolicina), 0) from trebovanjestavka ts\nleft join trebovanje t on t.id = ts.TREBOVANJE_ID\nwhere ts.ARTIKAL_ID = " + artikal.getId() + "\nand t.datumTrebovanja BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' and '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "'\nand t.IZ_ID = 1\nand t.crno = " + dodatnoOsnovno + ") as UtrosakSum\nfrom prijemnicastavka ps \nleft join prijemnica p on p.id = ps.PRIJEMNICA_ID\nwhere ps.ARTIKAL_ID = " + artikal.getId() + "\nand p.crno = " + dodatnoOsnovno + "\nand p.datumPrijemnice BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' and '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "'" : "SELECT COALESCE(\nCOALESCE(ROUND((select sum(ts.kolicina) as Kolicina from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = " + artikal.getId() + " and t.tip IN ('IZ_MAGACINA' , 'DIREKTNO_SA_KNJIZ', 'DIREKTNO_BEZ_KNJIZ', 'MEDJUTREBOVANJE') and t.crno = " + dodatnoOsnovno + " and t.datumTrebovanja BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' and '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' and t.U_ID = " + o.getId() + "), 4),0) \n- \nCOALESCE(ROUND(SUM(du.kolicina),4),0) - COALESCE(ROUND((select sum(ts.kolicina) as Kolicina  from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = " + artikal.getId() + " and t.tip IN ('POVRAT_U_MAGACIN', 'OTPIS', 'OTPREM_BEZ_KNJIZ' , 'OTPREM_SA_KNJIZ', 'POVRAT_BEZ_KNJIZ', 'POVRAT_SA_KNJIZ', 'MEDJUTREBOVANJE') and t.datumTrebovanja BETWEEN '" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "' and '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' and t.crno = " + dodatnoOsnovno + " and t.IZ_ID = " + o.getId() + "), 4), 0)\n, 0)  AS UtrosakSum\nFROM dnevniutrosak du \nwhere du.ARTIKAL_ID = " + artikal.getId() + "\nand du.ODELJENJE_ID = " + o.getId() + "\nand du.dodatno = " + dodatnoOsnovno + "\nand du.zdBroj >= (select zd1.zdBroj from zd zd1 where zd1.datum = DATE('" + new SimpleDateFormat("yyyy-MM-dd").format(datumPopisa) + "') and zd1.pocetak = 1) and du.zdBroj <= (select zd1.zdBroj from zd zd1 where zd1.datum = DATE('" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "') and zd1.pocetak = 1)";
        try {
            stmt = conn.createStatement();
            System.out.println(upit);
            ResultSet rs = stmt.executeQuery(upit);
            if (rs.next()) {
                return rs.getDouble("UtrosakSum");
            }
            return 0.0;
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    public List<OtpisUtrosak> readOtpisUtrosak(Otpis o) {
        Query q = this.base.createQuery("SELECT ou FROM OtpisUtrosak ou WHERE ou.otpis = :o");
        q.setParameter("o", (Object)o);
        return q.getResultList();
    }

    public void deleteOtpisUtrosak(OtpisUtrosak ou) {
        this.base.getTransaction().begin();
        this.base.remove((Object)ou);
        this.base.getTransaction().commit();
    }

    public void updateNormativArtikalUNormativu(Normativ normativ, NormativArtikal normativArtikal) {
        String query = "UPDATE normativ n SET n.NORMATIVARTIKAL_ID = ? WHERE n.id = ?";
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement(query);
            pStatement.setLong(1, normativArtikal.getId());
            pStatement.setLong(2, normativ.getId());
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<Kasa> getKaseAll() {
        Query q = this.base.createQuery("SELECT k FROM Kasa k");
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOtpisUtrosak(OtpisUtrosak oUtrosak) {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String insert = "INSERT INTO `restoran`.`otpisutrosak` (`kolicina`, `nabavnaCena`, `OTPIS_ID`, `ARTIKAL_ID`, `ODELJENJE_ID`) VALUES (?, ?, ?, ?, ?);";
        try {
            stmt = conn.prepareStatement(insert);
            stmt.setDouble(1, oUtrosak.getKolicina());
            stmt.setDouble(2, oUtrosak.getNabavnaCena());
            stmt.setLong(3, oUtrosak.getOtpis().getId());
            stmt.setLong(4, oUtrosak.getArtikal().getId());
            stmt.setLong(5, oUtrosak.getOdeljenje().getId());
            stmt.executeUpdate();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertPU(ProizvodnjaUtrosak proizvodnjaUtrosak) {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String insert = "INSERT INTO `restoran`.`proizvodnjautrosak` (`kolicina`, `nabavnaCena`, `PROIZVODNJA_ID`, `ARTIKAL_ID`, `ODELJENJE_ID`) VALUES (?, ?, ?, ?, ?);";
        try {
            stmt = conn.prepareStatement(insert);
            stmt.setDouble(1, proizvodnjaUtrosak.getKolicina());
            stmt.setDouble(2, proizvodnjaUtrosak.getNabavnaCena());
            stmt.setLong(3, proizvodnjaUtrosak.getProizvodnja().getId());
            stmt.setLong(4, proizvodnjaUtrosak.getArtikal().getId());
            stmt.setLong(5, proizvodnjaUtrosak.getOdeljenje().getId());
            stmt.executeUpdate();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUDocUtrosak(UtrosakDocUtrosak utrosak) {
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        String insert = "INSERT INTO `restoran`.`utrosakdocutrosak` (`kolicina`, `nabavnaCena`, `UTROSAKDOC_ID`, `ARTIKAL_ID`, `ODELJENJE_ID`) VALUES (?, ?, ?, ?, ?);";
        try {
            stmt = conn.prepareStatement(insert);
            stmt.setDouble(1, utrosak.getKolicina());
            stmt.setDouble(2, utrosak.getNabavnaCena());
            stmt.setLong(3, utrosak.getUtrosakDoc().getId());
            stmt.setLong(4, utrosak.getArtikal().getId());
            stmt.setLong(5, utrosak.getOdeljenje().getId());
            stmt.executeUpdate();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, this.r);
        }
    }

    public List<Kartica> readKarticeNova(Artikal artikal, Odeljenje odeljenje, Date datum) {
        LinkedList<Kartica> lista = new LinkedList<Kartica>();
        for (ZD zd : this.getAllZDListGroupByZDBroj(datum)) {
            List<DnevniUtrosak> list;
            List<DnevniUtrosak> dnevniUtrosciBelo;
            List<UtrosakDoc> list2;
            List<UtrosakDoc> utrosciDocBelo;
            List<Otpis> list3;
            List<Otpis> otpisiBelo;
            List<Proizvodnja> proizvodnjeCrno;
            List<Proizvodnja> proizvodnjeBelo;
            List<Trebovanje> list4;
            List<Trebovanje> list5;
            List<Trebovanje> trebovanjaUlaznaCrno;
            List<Trebovanje> list6;
            double kolicina;
            Object prijemniceCrne;
            List<Popis> popisiCrno;
            List<Popis> popisiBelo = this.getPopisiSravnjeniZaDatum(zd.getDatum(), odeljenje, false);
            if (!popisiBelo.isEmpty()) {
                for (Popis popis : popisiBelo) {
                    Kartica kartica2 = new Kartica();
                    kartica2.setArtikal(artikal);
                    kartica2.setCrno(popis.getCrno());
                    kartica2.setDatum(popis.getDatum());
                    kartica2.setDokument("Popis/" + String.valueOf(popis.getBroj()));
                    kartica2.setIzlazKOM(null);
                    kartica2.setKolicina(this.getKolicinaArtiklaZaPopis(artikal, popis));
                    kartica2.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica2.setOdeljenje(odeljenje);
                    lista.add(kartica2);
                }
            }
            if (!(popisiCrno = this.getPopisiSravnjeniZaDatum(zd.getDatum(), odeljenje, true)).isEmpty()) {
                for (Object popis2 : popisiCrno) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(((Popis)popis2).getCrno());
                    kartica.setDatum(((Popis)popis2).getDatum());
                    kartica.setDokument("Popis/" + String.valueOf(((Popis)popis2).getBroj()));
                    kartica.setIzlazKOM(null);
                    kartica.setKolicina(this.getKolicinaArtiklaZaPopis(artikal, (Popis)popis2));
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (odeljenje.getNaziv().equals("MAGACIN")) {
                List<Prijemnica> list7 = this.readPrijemnice(zd.getDatum(), false);
                if (!list7.isEmpty()) {
                    Object popis2;
                    popis2 = list7.iterator();
                    while (popis2.hasNext()) {
                        Prijemnica prijemnica = (Prijemnica)popis2.next();
                        Kartica kartica = new Kartica();
                        kartica.setArtikal(artikal);
                        kartica.setCrno(prijemnica.getCrno());
                        kartica.setDatum(prijemnica.getDatumPrijemnice());
                        kartica.setDokument(prijemnica.getBrPrijemnice());
                        kartica.setIzlazKOM(null);
                        double kolicina2 = 0.0;
                        for (PrijemnicaStavka prijemnicaStavka : this.readStavkePrijemnice(prijemnica)) {
                            if (!prijemnicaStavka.getArtikal().equals(artikal)) continue;
                            kolicina2 += prijemnicaStavka.getKolicina().doubleValue();
                        }
                        kartica.setKolicina(kolicina2);
                        kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                        kartica.setOdeljenje(odeljenje);
                        lista.add(kartica);
                    }
                }
                if (!(prijemniceCrne = this.readPrijemnice(zd.getDatum(), true)).isEmpty()) {
                    Iterator iterator = prijemniceCrne.iterator();
                    while (iterator.hasNext()) {
                        Prijemnica prijemnica = (Prijemnica)iterator.next();
                        Kartica kartica4 = new Kartica();
                        kartica4.setArtikal(artikal);
                        kartica4.setCrno(prijemnica.getCrno());
                        kartica4.setDatum(prijemnica.getDatumPrijemnice());
                        kartica4.setDokument(prijemnica.getBrPrijemnice());
                        kartica4.setIzlazKOM(null);
                        kolicina = 0.0;
                        for (PrijemnicaStavka pStavka2 : this.readStavkePrijemnice(prijemnica)) {
                            if (!pStavka2.getArtikal().equals(artikal)) continue;
                            kolicina += pStavka2.getKolicina().doubleValue();
                        }
                        kartica4.setKolicina(kolicina);
                        kartica4.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                        kartica4.setOdeljenje(odeljenje);
                        lista.add(kartica4);
                    }
                }
            }
            if (!(list6 = this.readUlaznaTrebovanja(odeljenje, zd.getDatum(), false)).isEmpty()) {
                prijemniceCrne = list6.iterator();
                while (prijemniceCrne.hasNext()) {
                    Trebovanje trebovanje = (Trebovanje)prijemniceCrne.next();
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(trebovanje.getCrno());
                    kartica.setDatum(trebovanje.getDatumTrebovanja());
                    kartica.setDokument(trebovanje.getBrTrebovanja());
                    kartica.setIzlazKOM(null);
                    double kolicina3 = 0.0;
                    for (TrebovanjeStavka trebovanjeStavka : trebovanje.getStavke()) {
                        if (!trebovanjeStavka.getArtikal().equals(artikal)) continue;
                        kolicina3 += trebovanjeStavka.getKolicina().doubleValue();
                    }
                    kartica.setKolicina(kolicina3);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(trebovanjaUlaznaCrno = this.readUlaznaTrebovanja(odeljenje, zd.getDatum(), true)).isEmpty()) {
                for (Trebovanje trebovanje : trebovanjaUlaznaCrno) {
                    Kartica kartica5 = new Kartica();
                    kartica5.setArtikal(artikal);
                    kartica5.setCrno(trebovanje.getCrno());
                    kartica5.setDatum(trebovanje.getDatumTrebovanja());
                    kartica5.setDokument(trebovanje.getBrTrebovanja());
                    kartica5.setIzlazKOM(null);
                    kolicina = 0.0;
                    for (Object tStavka2 : trebovanje.getStavke()) {
                        if (!((TrebovanjeStavka)tStavka2).getArtikal().equals(artikal)) continue;
                        kolicina += ((TrebovanjeStavka)tStavka2).getKolicina().doubleValue();
                    }
                    kartica5.setKolicina(kolicina);
                    kartica5.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica5.setOdeljenje(odeljenje);
                    lista.add(kartica5);
                }
            }
            if (!(list5 = this.readIzlaznaTrebovanja(odeljenje, zd.getDatum(), false)).isEmpty()) {
                for (Trebovanje trebovanje2 : list5) {
                    Object tStavka2;
                    Kartica kartica6 = new Kartica();
                    kartica6.setArtikal(artikal);
                    kartica6.setCrno(trebovanje2.getCrno());
                    kartica6.setDatum(trebovanje2.getDatumTrebovanja());
                    kartica6.setDokument(trebovanje2.getBrTrebovanja());
                    kartica6.setIzlazKOM(null);
                    double kolicina4 = 0.0;
                    tStavka2 = trebovanje2.getStavke().iterator();
                    while (tStavka2.hasNext()) {
                        TrebovanjeStavka trebovanjeStavka = (TrebovanjeStavka)tStavka2.next();
                        if (!trebovanjeStavka.getArtikal().equals(artikal)) continue;
                        kolicina4 += trebovanjeStavka.getKolicina() * -1.0;
                    }
                    kartica6.setKolicina(kolicina4);
                    kartica6.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica6.setOdeljenje(odeljenje);
                    lista.add(kartica6);
                }
            }
            if (!(list4 = this.readIzlaznaTrebovanja(odeljenje, zd.getDatum(), true)).isEmpty()) {
                for (Trebovanje trebovanje : list4) {
                    Kartica kartica7 = new Kartica();
                    kartica7.setArtikal(artikal);
                    kartica7.setCrno(trebovanje.getCrno());
                    kartica7.setDatum(trebovanje.getDatumTrebovanja());
                    kartica7.setDokument(trebovanje.getBrTrebovanja());
                    kartica7.setIzlazKOM(null);
                    double d = 0.0;
                    for (Object tStavka3 : trebovanje.getStavke()) {
                        if (!((TrebovanjeStavka)tStavka3).getArtikal().equals(artikal)) continue;
                        d += ((TrebovanjeStavka)tStavka3).getKolicina() * -1.0;
                    }
                    kartica7.setKolicina(d);
                    kartica7.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica7.setOdeljenje(odeljenje);
                    lista.add(kartica7);
                }
            }
            if (!(proizvodnjeBelo = this.readProizvodnjaByZD(odeljenje, zd.getDatum(), false)).isEmpty()) {
                for (Proizvodnja proizvodnja : proizvodnjeBelo) {
                    Object tStavka3;
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(proizvodnja.getCrno());
                    kartica.setDatum(proizvodnja.getDatum());
                    kartica.setDokument("Proizvodnja");
                    kartica.setIzlazKOM(null);
                    double kolicina6 = 0.0;
                    tStavka3 = proizvodnja.getStavke().iterator();
                    while (tStavka3.hasNext()) {
                        ProizvodnjaStavka proizvodnjaStavka = (ProizvodnjaStavka)tStavka3.next();
                        if (!proizvodnjaStavka.getArtikal().equals(artikal)) continue;
                        kolicina6 += proizvodnjaStavka.getKolicina();
                    }
                    kartica.setKolicina(kolicina6);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(proizvodnjeCrno = this.readProizvodnjaByZD(odeljenje, zd.getDatum(), true)).isEmpty()) {
                for (Proizvodnja proizvodnja : proizvodnjeCrno) {
                    Kartica kartica9 = new Kartica();
                    kartica9.setArtikal(artikal);
                    kartica9.setCrno(proizvodnja.getCrno());
                    kartica9.setDatum(proizvodnja.getDatum());
                    kartica9.setDokument("Proizvodnja");
                    kartica9.setIzlazKOM(null);
                    double d = 0.0;
                    for (Object stavka2 : proizvodnja.getStavke()) {
                        if (!((ProizvodnjaStavka)stavka2).getArtikal().equals(artikal)) continue;
                        d += ((ProizvodnjaStavka)stavka2).getKolicina();
                    }
                    kartica9.setKolicina(d);
                    kartica9.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica9.setOdeljenje(odeljenje);
                    lista.add(kartica9);
                }
            }
            if (!(otpisiBelo = this.readOtpis(zd.getDatum(), odeljenje, false)).isEmpty()) {
                for (Otpis otpis : otpisiBelo) {
                    Object stavka2;
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(otpis.isCrno());
                    kartica.setDatum(otpis.getDatum());
                    kartica.setDokument("Otpis/" + otpis.getBroj());
                    kartica.setIzlazKOM(null);
                    double kolicina8 = 0.0;
                    stavka2 = this.readOtpisUtrosak(otpis).iterator();
                    while (stavka2.hasNext()) {
                        OtpisUtrosak otpisUtrosak = (OtpisUtrosak)stavka2.next();
                        if (!otpisUtrosak.getArtikal().equals(artikal)) continue;
                        kolicina8 += otpisUtrosak.getKolicina() * -1.0;
                    }
                    kartica.setKolicina(kolicina8);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(list3 = this.readOtpis(zd.getDatum(), odeljenje, true)).isEmpty()) {
                for (Otpis otpis : list3) {
                    Kartica kartica11 = new Kartica();
                    kartica11.setArtikal(artikal);
                    kartica11.setCrno(otpis.isCrno());
                    kartica11.setDatum(otpis.getDatum());
                    kartica11.setDokument("Otpis/" + otpis.getBroj());
                    kartica11.setIzlazKOM(null);
                    double d = 0.0;
                    for (Object otpisUtrosak2 : this.readOtpisUtrosak(otpis)) {
                        if (!((OtpisUtrosak)otpisUtrosak2).getArtikal().equals(artikal)) continue;
                        d += ((OtpisUtrosak)otpisUtrosak2).getKolicina() * -1.0;
                    }
                    kartica11.setKolicina(d);
                    kartica11.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica11.setOdeljenje(odeljenje);
                    lista.add(kartica11);
                }
            }
            if (!(utrosciDocBelo = this.readUtrosakDoc(zd.getDatum(), odeljenje, false)).isEmpty()) {
                for (UtrosakDoc utrosakDoc : utrosciDocBelo) {
                    Object otpisUtrosak2;
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(utrosakDoc.isCrno());
                    kartica.setDatum(utrosakDoc.getDatum());
                    kartica.setDokument("UtrosakDoc/" + utrosakDoc.getBroj());
                    kartica.setIzlazKOM(null);
                    double kolicina10 = 0.0;
                    otpisUtrosak2 = this.getUtrosakDocUtrosak(utrosakDoc).iterator();
                    while (otpisUtrosak2.hasNext()) {
                        UtrosakDocUtrosak utrosakDocUtrosak = (UtrosakDocUtrosak)otpisUtrosak2.next();
                        if (!utrosakDocUtrosak.getArtikal().equals(artikal)) continue;
                        kolicina10 += utrosakDocUtrosak.getKolicina() * -1.0;
                    }
                    kartica.setKolicina(kolicina10);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(list2 = this.readUtrosakDoc(zd.getDatum(), odeljenje, true)).isEmpty()) {
                for (UtrosakDoc utrosakDoc : list2) {
                    Kartica kartica13 = new Kartica();
                    kartica13.setArtikal(artikal);
                    kartica13.setCrno(utrosakDoc.isCrno());
                    kartica13.setDatum(utrosakDoc.getDatum());
                    kartica13.setDokument("UtrosakDoc/" + utrosakDoc.getBroj());
                    kartica13.setIzlazKOM(null);
                    double d = 0.0;
                    for (UtrosakDocUtrosak utrosakDocUtrosak : this.getUtrosakDocUtrosak(utrosakDoc)) {
                        if (!utrosakDocUtrosak.getArtikal().equals(artikal)) continue;
                        d += utrosakDocUtrosak.getKolicina() * -1.0;
                    }
                    kartica13.setKolicina(d);
                    kartica13.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica13.setOdeljenje(odeljenje);
                    lista.add(kartica13);
                }
            }
            if (!(dnevniUtrosciBelo = this.getDnevniUtrosakListByArtikal(zd.getZdBroj(), artikal, odeljenje, false)).isEmpty()) {
                for (DnevniUtrosak dnevniUtrosak : dnevniUtrosciBelo) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(dnevniUtrosak.isDodatno());
                    kartica.setDatum(zd.getDatum());
                    kartica.setDokument("Dnevni promet");
                    kartica.setIzlazKOM(null);
                    kartica.setKolicina(dnevniUtrosak.getKolicina() * -1.0);
                    kartica.setNabavnaCena(dnevniUtrosak.getNabavnaCena());
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if ((list = this.getDnevniUtrosakListByArtikal(zd.getZdBroj(), artikal, odeljenje, true)).isEmpty()) continue;
            for (DnevniUtrosak dnevniUtrosak : list) {
                Kartica kartica15 = new Kartica();
                kartica15.setArtikal(artikal);
                kartica15.setCrno(dnevniUtrosak.isDodatno());
                kartica15.setDatum(zd.getDatum());
                kartica15.setDokument("Dnevni promet");
                kartica15.setIzlazKOM(null);
                kartica15.setKolicina(dnevniUtrosak.getKolicina() * -1.0);
                kartica15.setNabavnaCena(dnevniUtrosak.getNabavnaCena());
                kartica15.setOdeljenje(odeljenje);
                lista.add(kartica15);
            }
        }
        return lista;
    }

    public List<Kartica> readKarticeNovaCrno(Artikal artikal, Odeljenje odeljenje, Date datum) {
        LinkedList<Kartica> lista = new LinkedList<Kartica>();
        for (ZD zd : this.getAllZDListGroupByZDBroj(datum)) {
            List<DnevniUtrosak> dnevniUtrosciCrno;
            List<UtrosakDoc> utrosciDocCrno;
            List<Otpis> list;
            List<Proizvodnja> proizvodnjeCrno;
            List<Trebovanje> list2;
            List<Trebovanje> trebovanjaUlaznaCrno;
            double kolicina;
            List<Prijemnica> prijemnice;
            List<Popis> popisiCrno = this.getPopisiSravnjeniZaDatum(zd.getDatum(), odeljenje, true);
            if (!popisiCrno.isEmpty()) {
                for (Popis popis : popisiCrno) {
                    Kartica kartica2 = new Kartica();
                    kartica2.setArtikal(artikal);
                    kartica2.setCrno(popis.getCrno());
                    kartica2.setDatum(popis.getDatum());
                    kartica2.setDokument("Popis/" + String.valueOf(popis.getBroj()));
                    kartica2.setIzlazKOM(null);
                    kartica2.setKolicina(this.getKolicinaArtiklaZaPopis(artikal, popis));
                    kartica2.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica2.setOdeljenje(odeljenje);
                    lista.add(kartica2);
                }
            }
            if (odeljenje.getNaziv().equals("MAGACIN") && !(prijemnice = this.readPrijemnice(zd.getDatum(), true)).isEmpty()) {
                for (Prijemnica prijemnica : prijemnice) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(prijemnica.getCrno());
                    kartica.setDatum(prijemnica.getDatumPrijemnice());
                    kartica.setDokument(prijemnica.getBrPrijemnice());
                    kartica.setIzlazKOM(null);
                    kolicina = 0.0;
                    for (PrijemnicaStavka prijemnicaStavka : this.readStavkePrijemnice(prijemnica)) {
                        if (!prijemnicaStavka.getArtikal().equals(artikal)) continue;
                        kolicina += prijemnicaStavka.getKolicina().doubleValue();
                    }
                    kartica.setKolicina(kolicina);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(trebovanjaUlaznaCrno = this.readUlaznaTrebovanja(odeljenje, zd.getDatum(), true)).isEmpty()) {
                for (Object trebovanje : trebovanjaUlaznaCrno) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(((Trebovanje)trebovanje).getCrno());
                    kartica.setDatum(((Trebovanje)trebovanje).getDatumTrebovanja());
                    kartica.setDokument(((Trebovanje)trebovanje).getBrTrebovanja());
                    kartica.setIzlazKOM(null);
                    kolicina = 0.0;
                    for (TrebovanjeStavka trebovanjeStavka : ((Trebovanje)trebovanje).getStavke()) {
                        if (!trebovanjeStavka.getArtikal().equals(artikal)) continue;
                        kolicina += trebovanjeStavka.getKolicina().doubleValue();
                    }
                    kartica.setKolicina(kolicina);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(list2 = this.readIzlaznaTrebovanja(odeljenje, zd.getDatum(), true)).isEmpty()) {
                Object trebovanje;
                trebovanje = list2.iterator();
                while (trebovanje.hasNext()) {
                    Trebovanje trebovanje2 = (Trebovanje)trebovanje.next();
                    Kartica kartica3 = new Kartica();
                    kartica3.setArtikal(artikal);
                    kartica3.setCrno(trebovanje2.getCrno());
                    kartica3.setDatum(trebovanje2.getDatumTrebovanja());
                    kartica3.setDokument(trebovanje2.getBrTrebovanja());
                    kartica3.setIzlazKOM(null);
                    double kolicina2 = 0.0;
                    for (Object tStavka2 : trebovanje2.getStavke()) {
                        if (!((TrebovanjeStavka)tStavka2).getArtikal().equals(artikal)) continue;
                        kolicina2 += ((TrebovanjeStavka)tStavka2).getKolicina() * -1.0;
                    }
                    kartica3.setKolicina(kolicina2);
                    kartica3.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica3.setOdeljenje(odeljenje);
                    lista.add(kartica3);
                }
            }
            if (!(proizvodnjeCrno = this.readProizvodnjaByZD(odeljenje, zd.getDatum(), true)).isEmpty()) {
                for (Proizvodnja proizvodnja : proizvodnjeCrno) {
                    Object tStavka2;
                    Kartica kartica4 = new Kartica();
                    kartica4.setArtikal(artikal);
                    kartica4.setCrno(proizvodnja.getCrno());
                    kartica4.setDatum(proizvodnja.getDatum());
                    kartica4.setDokument("Proizvodnja");
                    kartica4.setIzlazKOM(null);
                    double kolicina3 = 0.0;
                    tStavka2 = proizvodnja.getStavke().iterator();
                    while (tStavka2.hasNext()) {
                        ProizvodnjaStavka stavka = (ProizvodnjaStavka)tStavka2.next();
                        if (!stavka.getArtikal().equals(artikal)) continue;
                        kolicina3 += stavka.getKolicina();
                    }
                    kartica4.setKolicina(kolicina3);
                    kartica4.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica4.setOdeljenje(odeljenje);
                    lista.add(kartica4);
                }
            }
            if (!(list = this.readOtpis(zd.getDatum(), odeljenje, true)).isEmpty()) {
                for (Otpis otpis : list) {
                    Kartica kartica5 = new Kartica();
                    kartica5.setArtikal(artikal);
                    kartica5.setCrno(otpis.isCrno());
                    kartica5.setDatum(otpis.getDatum());
                    kartica5.setDokument("Otpis/" + otpis.getBroj());
                    kartica5.setIzlazKOM(null);
                    double d = 0.0;
                    for (OtpisUtrosak otpisUtrosak : this.readOtpisUtrosak(otpis)) {
                        if (!otpisUtrosak.getArtikal().equals(artikal)) continue;
                        d += otpisUtrosak.getKolicina() * -1.0;
                    }
                    kartica5.setKolicina(d);
                    kartica5.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica5.setOdeljenje(odeljenje);
                    lista.add(kartica5);
                }
            }
            if (!(utrosciDocCrno = this.readUtrosakDoc(zd.getDatum(), odeljenje, true)).isEmpty()) {
                for (UtrosakDoc utrosakDoc : utrosciDocCrno) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(utrosakDoc.isCrno());
                    kartica.setDatum(utrosakDoc.getDatum());
                    kartica.setDokument("UtrosakDoc/" + utrosakDoc.getBroj());
                    kartica.setIzlazKOM(null);
                    double kolicina5 = 0.0;
                    for (UtrosakDocUtrosak utrosakDocUtrosak : this.getUtrosakDocUtrosak(utrosakDoc)) {
                        if (!utrosakDocUtrosak.getArtikal().equals(artikal)) continue;
                        kolicina5 += utrosakDocUtrosak.getKolicina() * -1.0;
                    }
                    kartica.setKolicina(kolicina5);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if ((dnevniUtrosciCrno = this.getDnevniUtrosakListByArtikal(zd.getZdBroj(), artikal, odeljenje, true)).isEmpty()) continue;
            for (DnevniUtrosak dnevniUtrosak : dnevniUtrosciCrno) {
                Kartica kartica7 = new Kartica();
                kartica7.setArtikal(artikal);
                kartica7.setCrno(dnevniUtrosak.isDodatno());
                kartica7.setDatum(zd.getDatum());
                kartica7.setDokument("Dnevni promet");
                kartica7.setIzlazKOM(null);
                kartica7.setKolicina(dnevniUtrosak.getKolicina() * -1.0);
                kartica7.setNabavnaCena(dnevniUtrosak.getNabavnaCena());
                kartica7.setOdeljenje(odeljenje);
                lista.add(kartica7);
            }
        }
        return lista;
    }

    public List<Kartica> readKarticeNovaBela(Artikal artikal, Odeljenje odeljenje, Date datum) {
        LinkedList<Kartica> lista = new LinkedList<Kartica>();
        for (ZD zd : this.getAllZDListGroupByZDBroj(datum)) {
            List<DnevniUtrosak> dnevniUtrosciBelo;
            List<UtrosakDoc> utrosciDocBelo;
            List<Otpis> list;
            List<Proizvodnja> proizvodnjeBelo;
            List<Trebovanje> list2;
            List<Trebovanje> trebovanjaUlaznaBelo;
            double kolicina;
            List<Prijemnica> prijemnice;
            List<Popis> popisi = this.getPopisiSravnjeniZaDatum(zd.getDatum(), odeljenje, false);
            if (!popisi.isEmpty()) {
                for (Popis popis : popisi) {
                    Kartica kartica2 = new Kartica();
                    kartica2.setArtikal(artikal);
                    kartica2.setCrno(popis.getCrno());
                    kartica2.setDatum(popis.getDatum());
                    kartica2.setDokument("Popis/" + String.valueOf(popis.getBroj()));
                    kartica2.setIzlazKOM(null);
                    kartica2.setKolicina(this.getKolicinaArtiklaZaPopis(artikal, popis));
                    kartica2.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica2.setOdeljenje(odeljenje);
                    lista.add(kartica2);
                }
            }
            if (odeljenje.getNaziv().equals("MAGACIN") && !(prijemnice = this.readPrijemnice(zd.getDatum(), false)).isEmpty()) {
                for (Prijemnica prijemnica : prijemnice) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(prijemnica.getCrno());
                    kartica.setDatum(prijemnica.getDatumPrijemnice());
                    kartica.setDokument(prijemnica.getBrPrijemnice());
                    kartica.setIzlazKOM(null);
                    kolicina = 0.0;
                    for (PrijemnicaStavka prijemnicaStavka : this.readStavkePrijemnice(prijemnica)) {
                        if (!prijemnicaStavka.getArtikal().equals(artikal)) continue;
                        kolicina += prijemnicaStavka.getKolicina().doubleValue();
                    }
                    kartica.setKolicina(kolicina);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(trebovanjaUlaznaBelo = this.readUlaznaTrebovanja(odeljenje, zd.getDatum(), false)).isEmpty()) {
                for (Object trebovanje : trebovanjaUlaznaBelo) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(((Trebovanje)trebovanje).getCrno());
                    kartica.setDatum(((Trebovanje)trebovanje).getDatumTrebovanja());
                    kartica.setDokument(((Trebovanje)trebovanje).getBrTrebovanja());
                    kartica.setIzlazKOM(null);
                    kolicina = 0.0;
                    for (TrebovanjeStavka trebovanjeStavka : ((Trebovanje)trebovanje).getStavke()) {
                        if (!trebovanjeStavka.getArtikal().equals(artikal)) continue;
                        kolicina += trebovanjeStavka.getKolicina().doubleValue();
                    }
                    kartica.setKolicina(kolicina);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if (!(list2 = this.readIzlaznaTrebovanja(odeljenje, zd.getDatum(), false)).isEmpty()) {
                Object trebovanje;
                trebovanje = list2.iterator();
                while (trebovanje.hasNext()) {
                    Trebovanje trebovanje2 = (Trebovanje)trebovanje.next();
                    Kartica kartica3 = new Kartica();
                    kartica3.setArtikal(artikal);
                    kartica3.setCrno(trebovanje2.getCrno());
                    kartica3.setDatum(trebovanje2.getDatumTrebovanja());
                    kartica3.setDokument(trebovanje2.getBrTrebovanja());
                    kartica3.setIzlazKOM(null);
                    double kolicina2 = 0.0;
                    for (Object tStavka2 : trebovanje2.getStavke()) {
                        if (!((TrebovanjeStavka)tStavka2).getArtikal().equals(artikal)) continue;
                        kolicina2 += ((TrebovanjeStavka)tStavka2).getKolicina() * -1.0;
                    }
                    kartica3.setKolicina(kolicina2);
                    kartica3.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica3.setOdeljenje(odeljenje);
                    lista.add(kartica3);
                }
            }
            if (!(proizvodnjeBelo = this.readProizvodnjaByZD(odeljenje, zd.getDatum(), false)).isEmpty()) {
                for (Proizvodnja proizvodnja : proizvodnjeBelo) {
                    Object tStavka2;
                    Kartica kartica4 = new Kartica();
                    kartica4.setArtikal(artikal);
                    kartica4.setCrno(proizvodnja.getCrno());
                    kartica4.setDatum(proizvodnja.getDatum());
                    kartica4.setDokument("Proizvodnja");
                    kartica4.setIzlazKOM(null);
                    double kolicina3 = 0.0;
                    if (artikal.getTip().equals((Object)TipArtikla.POLU)) {
                        tStavka2 = proizvodnja.getStavke().iterator();
                        while (tStavka2.hasNext()) {
                            ProizvodnjaStavka ps = (ProizvodnjaStavka)((Object)tStavka2.next());
                            if (!ps.getArtikal().equals(artikal)) continue;
                            kolicina3 += ps.getKolicina();
                        }
                        kartica4.setKolicina(kolicina3);
                    } else {
                        tStavka2 = this.readProizvodnjaUtrosak(proizvodnja).iterator();
                        while (tStavka2.hasNext()) {
                            ProizvodnjaUtrosak proizvodnjaUtrosak = tStavka2.next();
                            if (!proizvodnjaUtrosak.getArtikal().equals(artikal)) continue;
                            kolicina3 += proizvodnjaUtrosak.getKolicina();
                        }
                        kartica4.setKolicina(kolicina3 * -1.0);
                    }
                    kartica4.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica4.setOdeljenje(odeljenje);
                    lista.add(kartica4);
                }
            }
            if (!(list = this.readOtpis(zd.getDatum(), odeljenje, false)).isEmpty()) {
                for (Otpis otpis : list) {
                    Kartica kartica5 = new Kartica();
                    kartica5.setArtikal(artikal);
                    kartica5.setCrno(otpis.isCrno());
                    kartica5.setDatum(otpis.getDatum());
                    kartica5.setDokument("Otpis/" + otpis.getBroj());
                    kartica5.setIzlazKOM(null);
                    double d = 0.0;
                    for (OtpisUtrosak otpisUtrosak : this.readOtpisUtrosak(otpis)) {
                        if (!otpisUtrosak.getArtikal().equals(artikal)) continue;
                        d += otpisUtrosak.getKolicina() * -1.0;
                    }
                    kartica5.setKolicina(d);
                    kartica5.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica5.setOdeljenje(odeljenje);
                    lista.add(kartica5);
                }
            }
            if (!(utrosciDocBelo = this.readUtrosakDoc(zd.getDatum(), odeljenje, false)).isEmpty()) {
                for (UtrosakDoc utrosakDoc : utrosciDocBelo) {
                    Kartica kartica = new Kartica();
                    kartica.setArtikal(artikal);
                    kartica.setCrno(utrosakDoc.isCrno());
                    kartica.setDatum(utrosakDoc.getDatum());
                    kartica.setDokument("UtrosakDoc/" + utrosakDoc.getBroj());
                    kartica.setIzlazKOM(null);
                    double kolicina5 = 0.0;
                    for (UtrosakDocUtrosak utrosakDocUtrosak : this.getUtrosakDocUtrosak(utrosakDoc)) {
                        if (!utrosakDocUtrosak.getArtikal().equals(artikal)) continue;
                        kolicina5 += utrosakDocUtrosak.getKolicina() * -1.0;
                    }
                    kartica.setKolicina(kolicina5);
                    kartica.setNabavnaCena(this.getLastNabavnaCenaBelaBezPDV(artikal, zd.getZakljucenje()));
                    kartica.setOdeljenje(odeljenje);
                    lista.add(kartica);
                }
            }
            if ((dnevniUtrosciBelo = this.getDnevniUtrosakListByArtikal(zd.getZdBroj(), artikal, odeljenje, false)).isEmpty()) continue;
            for (DnevniUtrosak dnevniUtrosak : dnevniUtrosciBelo) {
                Kartica kartica7 = new Kartica();
                kartica7.setArtikal(artikal);
                kartica7.setCrno(dnevniUtrosak.isDodatno());
                kartica7.setDatum(zd.getDatum());
                kartica7.setDokument("Dnevni promet");
                kartica7.setIzlazKOM(null);
                kartica7.setKolicina(dnevniUtrosak.getKolicina() * -1.0);
                kartica7.setNabavnaCena(dnevniUtrosak.getNabavnaCena());
                kartica7.setOdeljenje(odeljenje);
                lista.add(kartica7);
            }
        }
        return lista;
    }

    public double getKolicinaArtiklaZaPopis(Artikal artikal, Popis popis) {
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("SELECT sp.stanje1 FROM stavkapopisa sp WHERE sp.ARTIKAL_ID = ? and sp.POPIS_ID = ?");
            pStatement.setLong(1, artikal.getId());
            pStatement.setLong(2, popis.getId());
            ResultSet rs = pStatement.executeQuery();
            rs.next();
            return rs.getDouble("stanje1");
        }
        catch (SQLException e) {
            return 0.0;
        }
    }

    private List<Popis> getPopisiSravnjeniZaDatum(Date datum, Odeljenje odeljenje, boolean crno) {
        LinkedList<Popis> popisi = new LinkedList<Popis>();
        try {
            PreparedStatement pStatement = this.getConnection().prepareStatement("SELECT p.* FROM popis p WHERE DATE(p.datum) = '" + new SimpleDateFormat("yyyy-MM-dd").format(datum) + "' AND p.sravnjenje IS TRUE AND p.crno = ? AND p.ODELJENJE_ID = ?");
            pStatement.setBoolean(1, crno);
            pStatement.setLong(2, odeljenje.getId());
            ResultSet rs = pStatement.executeQuery();
            if (rs.next()) {
                Popis popis = new Popis();
                popis.setId(rs.getLong("id"));
                popis.setBroj(rs.getInt("broj"));
                popis.setCrno(rs.getBoolean("crno"));
                popis.setDatum(rs.getDate("datum"));
                popis.setObaStanja(rs.getBoolean("obaStanja"));
                popis.setOdeljenje(this.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                popis.setSravnjenje(rs.getBoolean("sravnjenje"));
                popis.setUser(rs.getString("user"));
                popisi.add(popis);
                return popisi;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return popisi;
    }

    public List<ProizvodnjaUtrosak> getProizvodnjaUtrosakRadniNalog(Date datumIzZDa, Odeljenje od) {
        LinkedList<ProizvodnjaUtrosak> list = new LinkedList<ProizvodnjaUtrosak>();
        LinkedList lista = new LinkedList();
        String upit = "SELECT pu.* FROM proizvodnjautrosak pu LEFT JOIN proizvodnja p ON p.id = pu.PROIZVODNJA_ID WHERE pu.ODELJENJE_ID =? AND DATE(p.datum) = ? ";
        try {
            PreparedStatement stmt = this.getConnection().prepareStatement(upit);
            stmt.setLong(1, od.getId());
            stmt.setDate(2, (java.sql.Date)datumIzZDa);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                ProizvodnjaUtrosak pUtrosak = new ProizvodnjaUtrosak();
                pUtrosak.setId(rs.getLong("id"));
                pUtrosak.setKolicina(rs.getDouble("kolicina"));
                pUtrosak.setNabavnaCena(rs.getDouble("nabavnaCena"));
                pUtrosak.setProizvodnja(this.readProizvodnja(rs.getLong("PROIZVODNJA_ID")));
                pUtrosak.setArtikal(this.getArtikal(rs.getLong("ARTIKAL_ID")));
                pUtrosak.setOdeljenje(this.getOdeljenje(rs.getLong("ODELJENJE_ID")));
                list.add(pUtrosak);
            }
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public double getNabavljenaKolicina(Artikal artikal, Date datumOd, Date datumDo, Odeljenje ode, Boolean crno) {
        java.sql.Date datumOdZaQuery = new java.sql.Date(datumOd.getTime());
        java.sql.Date datumDoZaQuery = new java.sql.Date(datumDo.getTime());
        String query = ode.getNaziv().equals("MAGACIN") ? "SELECT SUM(nabavka1) AS nabavka FROM  (select COALESCE(sum(ps.kolicina), 0) AS nabavka1, 1 AS trt from prijemnicastavka ps left join prijemnica p on p.id = ps.PRIJEMNICA_ID where ps.ARTIKAL_ID =? and p.datumPrijemnice BETWEEN ? AND ? AND p.crno = ? union select COALESCE(sum(ts.kolicina), 0) AS nabavka1, 2 AS trt from trebovanjestavka ts left join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID =? and t.datumTrebovanja BETWEEN ? AND ? AND t.crno = ? AND t.tip IN ('POVRAT_U_MAGACIN', 'OTPREM_SA_KNJIZ')) AS unija" : "SELECT SUM(nabavka) AS nabavka\r\nFROM(select COALESCE(sum(ts.kolicina), 0) AS nabavka from trebovanjestavka ts\r\nleft join trebovanje t on t.id = ts.TREBOVANJE_ID where ts.ARTIKAL_ID = ? and\r\nt.datumTrebovanja BETWEEN  ? AND ? and t.crno =? and t.U_ID =?\r\nUNION\r\nSELECT COALESCE(( SUM(ps.kolicina)),0) AS nabavka FROM proizvodnjastavka ps\r\nJOIN proizvodnja p ON ps.PROIZVODNJA_ID = p.id \r\nWHERE ps.ARTIKAL_ID = ? AND p.datum BETWEEN ? AND ? AND p.crno = ? AND p.ODELJENJE_ID = ?) AS trt";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);
            preparedStatement.setLong(1, artikal.getId());
            preparedStatement.setDate(2, datumOdZaQuery);
            preparedStatement.setDate(3, datumDoZaQuery);
            preparedStatement.setBoolean(4, crno);
            if (!ode.getNaziv().equals("MAGACIN")) {
                preparedStatement.setLong(5, ode.getId());
                preparedStatement.setLong(6, artikal.getId());
                preparedStatement.setDate(7, datumOdZaQuery);
                preparedStatement.setDate(8, datumDoZaQuery);
                preparedStatement.setBoolean(9, crno);
                preparedStatement.setLong(10, ode.getId());
            } else {
                preparedStatement.setLong(5, artikal.getId());
                preparedStatement.setDate(6, datumOdZaQuery);
                preparedStatement.setDate(7, datumDoZaQuery);
                preparedStatement.setBoolean(8, crno);
            }
            System.out.println(preparedStatement);
            ResultSet rSet = preparedStatement.executeQuery();
            rSet.next();
            return rSet.getDouble("nabavka");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public List<StavkaRacuna> getStavkeZaDPU(java.sql.Date d, Artikal artikal, long odeljenje_id) {
        String query = "SELECT sr.naziv as naziv, if(a.dozvoljenPopust = 1,sr.cena - (sr.cena *  COALESCE(r.popust,0)/100), sr.cena) as cena,SUM(sr.kolicina) as kolicina, sr.ARTIKAL_ID as id, COALESCE(r.popust,0) as popust, r.zdBroj,r.menipromet,coalesce(r.crnoPlacanje,'') as crnoPlacanje  from stavkaracuna sr  LEFT join racun r on r.id=sr.RACUN_ID  LEFT JOIN artikal a ON  sr.ARTIKAL_ID = a.id JOIN kasa_odeljenje ko ON r.KASA_ID = ko.KASA_ID WHERE (COALESCE(r.crnoPlacanje,'') ='' OR r.crnoPlacanje = 'HOTELSKI GOST'  OR r.naOsnovno = 1) and r.zdBroj = (select zdBroj from zd as z where z.datum=? limit 1)and sr.ARTIKAL_ID=? and ko.ODELJENJA_ID = ? group by r.menipromet, (sr.cena - (sr.cena *  COALESCE(r.popust,0)/100)), r.crnoPlacanje";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);
            preparedStatement.setDate(1, d);
            preparedStatement.setLong(2, artikal.getId());
            preparedStatement.setLong(3, odeljenje_id);
            System.out.println(preparedStatement);
            ResultSet rSet = preparedStatement.executeQuery();
            ArrayList<StavkaRacuna> stavkeRacuna = new ArrayList<StavkaRacuna>();
            while (rSet.next()) {
                StavkaRacuna stavka = new StavkaRacuna();
                stavka.setId(rSet.getLong("id"));
                stavka.setNaziv(rSet.getString("naziv"));
                stavka.setCena(rSet.getDouble("cena"));
                stavka.setKolicina(rSet.getDouble("kolicina"));
                stavka.setMenipromet(rSet.getBoolean("menipromet"));
                stavka.setOpis(rSet.getString("crnoPlacanje"));
                stavkeRacuna.add(stavka);
            }
            return stavkeRacuna;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Normativ> getPoslednjiNormativ(Artikal a) {
        String query = "select * from normativ n where n.ARTIKAL_ID=? and n.NORMATIVARTIKAL_ID=(select max(NORMATIVARTIKAL_ID) from normativ where artikal_id = n.ARTIKAL_ID )";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);
            preparedStatement.setLong(1, a.getId());
            ResultSet rSet = preparedStatement.executeQuery();
            ArrayList<Normativ> normativZaArtikal = new ArrayList<Normativ>();
            while (rSet.next()) {
                Normativ n = new Normativ();
                n.setId(rSet.getLong("id"));
                n.setKolicina(rSet.getDouble("kolicina"));
                n.setArtikal(a);
                n.setOdeljenje(this.getOdeljenje(rSet.getLong("ODELJENJE_id")));
                n.setSastojak(this.getArtikal(rSet.getLong("SASTOJAK_ID")));
                n.setNormativArtikal(this.getNormativArtikal(rSet.getLong("NORMATIVARTIKAL_ID")));
                normativZaArtikal.add(n);
            }
            return normativZaArtikal;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Long najveciNormativArtikalId(Artikal a) {
        String query = "select max(id) as id  from normativartikal where artikal_id=?";
        try {
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(query);
            preparedStatement.setLong(1, a.getId());
            ResultSet rSet = preparedStatement.executeQuery();
            rSet.next();
            return rSet.getLong("id");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public double getProdajnaCenaBezPDV(PoreskaGrupa poreskaGrupa, Double prodajnaCena) {
        return prodajnaCena / (Konstante.getPGStopaProcenat(poreskaGrupa) / 100.0 + 1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Long> getArtikliZadpu(Long odeljenjeID, boolean prikazSirovina) {
        LinkedHashMap<String, Long> mapa = new LinkedHashMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "";
        selectString = prikazSirovina ? "select id, name,  tip from artikal where artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID = " + odeljenjeID + ") and blokiran = 0 order by field (tip, 'SLOZ','DODA','PROD','POLU', 'SIRO'),name" : "select id, name,  tip from artikal where artikal.id in (select ARTIKLI_ID from artikal_odeljenje where ODELJENJA_ID =" + odeljenjeID + ") AND artikal.tip != 'SIRO'order by field (tip, 'SLOZ','DODA','PROD','POLU'),name ";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Long> getArtikliZadpu() {
        LinkedHashMap<String, Long> mapa = new LinkedHashMap<String, Long>();
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        Long id = null;
        String naziv = "";
        String selectString = "select id, name,tip from artikal where  artikal.blokiran = false order by field \n\t\t\t\t(tip, 'SLOZ','DODA','PROD','POLU', 'SIRO'),name";
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(selectString);
            while (rs.next()) {
                id = rs.getLong(1);
                naziv = rs.getString(2);
                mapa.put(naziv, id);
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            System.err.println("SQLException: " + ex.getMessage());
        }
        finally {
            this.proveriKonekciju(stmt, conn, rs);
        }
        return mapa;
    }

    public double getIznosRacuna(Racun r) {
        double iznos = 0.0;
        for (StavkaRacuna st : r.getStavke()) {
            iznos += st.getVrednostSaPopustom().doubleValue();
        }
        return iznos;
    }

    public GrupaArtikala getGrupaById(long podgrupaId) {
        String query = "select * from grupaartikala where id = ?";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, podgrupaId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            GrupaArtikala ga = new GrupaArtikala();
            ga.setId(rs.getLong("id"));
            ga.setNaziv(rs.getString("naziv"));
            return ga;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public PodgrupaArtikala getpodgrupaById(long podgrupaId) {
        String query = "select * from podgrupaartikala where id = ?";
        try {
            PreparedStatement ps = this.getConnection().prepareStatement(query);
            ps.setLong(1, podgrupaId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PodgrupaArtikala pa = new PodgrupaArtikala();
            pa.setId(rs.getLong("id"));
            pa.setNaziv(rs.getString("naziv"));
            pa.setGrupa(this.getGrupaById(rs.getLong("GRUPA_ID")));
            pa.setSkrNaziv(rs.getString("skrNaziv"));
            return pa;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

