/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.fiscal.DummyFiscalPrinetImpl;
import com.dev63.fiscal.FiscalException;
import com.dev63.fiscal.FiscalPrinter;
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.fiscal.fp550.SerialIOException;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.LoadingScreen;
import com.dev63.restoran.LoginWindow;
import com.dev63.restoran.Logs;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.RestoranServerBO;
import com.dev63.restoran.backoffice.odeljenja.OdabirGrupeOdeljenjaZaOdeljenje;
import com.dev63.restoran.backoffice.prodajnamesta.UpravljanjeKasom;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.db.BMDBConnectionPool;
import com.dev63.restoran.fiscalprint.einis.EINisWriter;
import com.dev63.restoran.frontoffice.FrontOfficeRemoteServiceServer;
import com.dev63.restoran.frontoffice.FrontOfficeServer;
import com.dev63.restoran.hosts.Host;
import com.dev63.restoran.hosts.HostChoiceNew;
import com.dev63.restoran.jpa.SingletonEmReference;
import com.dev63.restoran.license.LicControl;
import com.dev63.restoran.license.LicLogic;
import com.dev63.restoran.license.LicenseInput;
import com.dev63.restoran.license.exceptions.LicenseNotValid;
import com.dev63.restoran.license.exceptions.MacAddressReadException;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Country;
import com.dev63.restoran.model.DnevniCenovnik;
import com.dev63.restoran.model.DnevniCenovnikStavka;
import com.dev63.restoran.model.EvidencijaZaposlenih;
import com.dev63.restoran.model.Kasa;
import com.dev63.restoran.model.Konobar;
import com.dev63.restoran.model.Normativ;
import com.dev63.restoran.model.NormativArtikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostPretplata;
import com.dev63.restoran.model.Sto;
import com.dev63.restoran.model.TipFiskalnogPrintera;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.model.ZD;
import com.dev63.restoran.model.dao.DAOProducer;
import com.dev63.restoran.parts.ObjectWrapper;
import com.dev63.restoran.parts.XMLWriter;
import com.dev63.restoran.parts.XMLWriterHCP;
import com.dev63.restoran.sistem.FiskalneFunkcije;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.sistem.fpProtocols.FLinkProtocol;
import com.dev63.restoran.sistem.fpProtocols.metalink.MetaLinkProtocol;
import com.dev63.restoran.swt.components.SWTMessage;
import com.dev63.restoran.swt.resources.BrandingCache;
import com.dev63.restoran.swt.resources.BrandingData;
import com.dev63.restoran.swt.resources.FontCache;
import com.dev63.restoran.swt.resources.ImageCache;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Persistence;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.json.JSONObject;

public class Restoran {
    private static final String NO_FISCAL = "demo";
    private static final Logger log = Logger.getLogger(Restoran.class.getPackage().getName());
    private RestoranServer server;
    private FiscalPrinter fiscal;
    private Connection conn;
    private Display display;
    private LoadingScreen ldngScr;
    private Shell shell;
    private String host;
    private String name;
    private RestoranServerBO serverBO;
    private String schemaName = "restoran";
    private String dbUser = "root";
    private String dbPass = "928374";
    private boolean bezKasa = false;
    private List<StalniGost> listaGostiju;
    Restoran restoran;
    private Map<Integer, String> naziviStolova = new HashMap<Integer, String>();
    private Kasa kasa;
    private boolean backoffice;

    public Restoran(String[] args) throws SQLException {
        this.display = new Display();
        this.display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                BrandingCache.dispose();
                ImageCache.dispose();
                FontCache.dispose();
                if (Restoran.this.server != null) {
                    Restoran.this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                    Restoran.this.server.fine("Izlazak iz programa", this.getClass());
                }
                System.exit(0);
            }
        });
        List<String> arguments = Arrays.asList(args);
        boolean bpl = false;
        if (arguments.contains("madagaskarskamaglaprstpredokomnevidim")) {
            bpl = true;
        }
        if (arguments.contains("trade")) {
            BrandingCache.setBrand(BrandingData.TRADEMASTER);
        } else {
            BrandingCache.setBrand(BrandingData.BARMASTER);
        }
        bpl = true;
        this.izbor1();
        this.izbor2(bpl);
    }

    private void inicijalniIzbor(final Restoran restoran) {
        String[] fiskali = new String[TipFiskalnogPrintera.values().length];
        for (int i = 0; i < TipFiskalnogPrintera.values().length; ++i) {
            TipFiskalnogPrintera tfp = TipFiskalnogPrintera.values()[i];
            fiskali[i] = tfp.getName();
        }
        final Shell shell = new Shell(this.display);
        FormLayout form = new FormLayout();
        form.marginHeight = 8;
        form.marginWidth = 8;
        shell.setLayout((Layout)form);
        Label labelAdresa = new Label((Composite)shell, 0);
        labelAdresa.setText("Adresa: ");
        final Text text = new Text((Composite)shell, 18436);
        text.forceFocus();
        text.setText("localhost");
        text.selectAll();
        FormData textData = new FormData();
        textData.left = new FormAttachment((Control)labelAdresa, 10);
        textData.top = new FormAttachment((Control)labelAdresa, 0, 128);
        text.setLayoutData((Object)textData);
        Composite radioKasaBO = new Composite((Composite)shell, 0);
        radioKasaBO.setLayout((Layout)new RowLayout());
        final Button kasaButton = new Button(radioKasaBO, 16);
        kasaButton.setText("Kasa");
        final Button boButton = new Button(radioKasaBO, 16);
        boButton.setText("BackOffice");
        kasaButton.setSelection(true);
        FormData compData = new FormData();
        compData.top = new FormAttachment((Control)text, 10);
        radioKasaBO.setLayoutData((Object)compData);
        Label labelRadBezStolova = new Label((Composite)shell, 0);
        labelRadBezStolova.setText("Rad bez stolova: ");
        FormData labelRadBezStolovaData = new FormData();
        labelRadBezStolovaData.top = new FormAttachment((Control)radioKasaBO, 10);
        labelRadBezStolova.setLayoutData((Object)labelRadBezStolovaData);
        final Button radBezStolovaCheck = new Button((Composite)shell, 32);
        FormData radBezStolovaCheckData = new FormData();
        radBezStolovaCheckData.left = new FormAttachment((Control)labelRadBezStolova, 5);
        radBezStolovaCheckData.top = new FormAttachment((Control)labelRadBezStolova, 0, 128);
        radBezStolovaCheck.setLayoutData((Object)radBezStolovaCheckData);
        Label labelPomocniBrojStola = new Label((Composite)shell, 0);
        labelPomocniBrojStola.setText("Pomocni broj stola: ");
        FormData labelPomocniBrojStolaData = new FormData();
        labelPomocniBrojStolaData.top = new FormAttachment((Control)labelRadBezStolova, 10);
        labelPomocniBrojStola.setLayoutData((Object)labelPomocniBrojStolaData);
        final Text pomocniBrojStolaInput = new Text((Composite)shell, 18436);
        pomocniBrojStolaInput.setText("10000");
        pomocniBrojStolaInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((Text)e.widget).setText(((Text)e.widget).getText().replaceAll("\\D+", ""));
                ((Text)e.widget).setSelection(((Text)e.widget).getText().length() + 1);
            }
        });
        radBezStolovaCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                pomocniBrojStolaInput.setEnabled(!radBezStolovaCheck.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                pomocniBrojStolaInput.setEnabled(!radBezStolovaCheck.getSelection());
            }
        });
        FormData pomocniBrojStolaInputData = new FormData();
        pomocniBrojStolaInputData.left = new FormAttachment((Control)labelPomocniBrojStola, 5);
        pomocniBrojStolaInputData.top = new FormAttachment((Control)labelPomocniBrojStola, -3, 128);
        pomocniBrojStolaInput.setLayoutData((Object)pomocniBrojStolaInputData);
        Label labelSZ = new Label((Composite)shell, 0);
        labelSZ.setText("Softversko zakljucenje: ");
        FormData labelSZData = new FormData();
        labelSZData.top = new FormAttachment((Control)labelPomocniBrojStola, 10);
        labelSZ.setLayoutData((Object)labelSZData);
        final Button szCheck = new Button((Composite)shell, 32);
        szCheck.setSelection(true);
        FormData szCheckData = new FormData();
        szCheckData.left = new FormAttachment((Control)labelSZ, 5);
        szCheckData.top = new FormAttachment((Control)labelSZ, 0, 128);
        szCheck.setLayoutData((Object)szCheckData);
        Label labelFZ = new Label((Composite)shell, 0);
        labelFZ.setText("Fiskalno zakljucenje: ");
        FormData labelFZData = new FormData();
        labelFZData.top = new FormAttachment((Control)labelSZ, 10);
        labelFZ.setLayoutData((Object)labelFZData);
        final Button fzCheck = new Button((Composite)shell, 32);
        fzCheck.setSelection(true);
        FormData fzCheckData = new FormData();
        fzCheckData.left = new FormAttachment((Control)labelFZ, 5);
        fzCheckData.top = new FormAttachment((Control)labelFZ, 0, 128);
        fzCheck.setLayoutData((Object)fzCheckData);
        Label labelAFZ = new Label((Composite)shell, 0);
        labelAFZ.setText("Automatsko fiskalno zakljucenje: ");
        FormData labelAFZData = new FormData();
        labelAFZData.top = new FormAttachment((Control)labelFZ, 10);
        labelAFZ.setLayoutData((Object)labelAFZData);
        final Button afzCheck = new Button((Composite)shell, 32);
        FormData afzCheckData = new FormData();
        afzCheckData.left = new FormAttachment((Control)labelAFZ, 5);
        afzCheckData.top = new FormAttachment((Control)labelAFZ, 0, 128);
        afzCheck.setLayoutData((Object)afzCheckData);
        Label labelFiskal = new Label((Composite)shell, 0);
        labelFiskal.setText("Fiskal: ");
        FormData labelFiskalData = new FormData();
        labelFiskalData.top = new FormAttachment((Control)labelAFZ, 10);
        labelFiskal.setLayoutData((Object)labelFiskalData);
        final Combo fiskalCombobox = new Combo((Composite)shell, 12);
        fiskalCombobox.setItems(fiskali);
        fiskalCombobox.select(0);
        FormData fiskalComboboxData = new FormData();
        fiskalComboboxData.left = new FormAttachment((Control)labelFiskal, 5);
        fiskalComboboxData.top = new FormAttachment((Control)labelFiskal, 0, 128);
        fiskalCombobox.setLayoutData((Object)fiskalComboboxData);
        Button okButton = new Button((Composite)shell, 8);
        okButton.setText("&OK");
        FormData okButtonData = new FormData();
        okButtonData.top = new FormAttachment((Control)labelFiskal, 10);
        okButton.setLayoutData((Object)okButtonData);
        okButton.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Setting adresa = new Setting();
                adresa.setActual(text.getText());
                adresa.setName("adresa");
                restoran.getServerBO().changeSetting(adresa);
                Setting backOffice = new Setting();
                backOffice.setActual("" + boButton.getSelection());
                backOffice.setName("back.office");
                restoran.getServerBO().changeSetting(backOffice);
                Setting kasa = new Setting();
                kasa.setActual("" + kasaButton.getSelection());
                kasa.setName("kasa");
                restoran.getServerBO().changeSetting(kasa);
                Setting radBezStolova = new Setting();
                radBezStolova.setActual("" + radBezStolovaCheck.getSelection());
                radBezStolova.setName("rad.bez.stolova");
                restoran.getServerBO().changeSetting(radBezStolova);
                Setting pomocniBrojStola = new Setting();
                pomocniBrojStola.setActual("" + pomocniBrojStolaInput.getText());
                pomocniBrojStola.setName("pomocni.broj.stola");
                restoran.getServerBO().changeSetting(pomocniBrojStola);
                Setting pomocniBrojStolaPocetni = new Setting();
                pomocniBrojStolaPocetni.setActual("" + pomocniBrojStolaInput.getText());
                pomocniBrojStolaPocetni.setName("pomocni.broj.stola.pocetni");
                restoran.getServerBO().changeSetting(pomocniBrojStolaPocetni);
                Setting softveskoZakljucenje = new Setting();
                softveskoZakljucenje.setActual("" + szCheck.getSelection());
                softveskoZakljucenje.setName("softversko.zakljucenje");
                restoran.getServerBO().changeSetting(softveskoZakljucenje);
                Setting fiskalnoZakljucenje = new Setting();
                fiskalnoZakljucenje.setActual("" + fzCheck.getSelection());
                fiskalnoZakljucenje.setName("fiskalno.zakljucenje");
                restoran.getServerBO().changeSetting(fiskalnoZakljucenje);
                Setting automatskoZakljucenje = new Setting();
                automatskoZakljucenje.setActual("" + afzCheck.getSelection());
                automatskoZakljucenje.setName("automatsko.zakljucenje.fiskala");
                restoran.getServerBO().changeSetting(automatskoZakljucenje);
                Setting fiskal = new Setting();
                fiskal.setName(OptionBO.FISKALNI_PRINTER.getName());
                Setting fiskalPrinterTip = new Setting();
                fiskalPrinterTip.setName(OptionBO.TIP_FISKALNOG_PRINTERA.getName());
                String fp = fiskalCombobox.getItem(fiskalCombobox.getSelectionIndex());
                for (TipFiskalnogPrintera tfp : TipFiskalnogPrintera.values()) {
                    if (!tfp.getName().equals(fp)) continue;
                    fiskal.setActual("" + tfp.getTipStampacaOld());
                    fiskalPrinterTip.setActual(tfp.getName());
                }
                if (fiskal.getActual() == null || fiskal.getActual().length() == 0) {
                    fiskal.setActual("1");
                    fiskalPrinterTip.setActual(TipFiskalnogPrintera.values()[0].getName());
                }
                restoran.getServerBO().changeSetting(fiskal);
                restoran.getServerBO().changeSetting(fiskalPrinterTip);
                shell.close();
                Setting gotovina = new Setting();
                gotovina.setActual("true");
                gotovina.setName("gotovina");
                restoran.getServerBO().changeSetting(gotovina);
                Setting faktura = new Setting();
                faktura.setActual("true");
                faktura.setName("faktura");
                restoran.getServerBO().changeSetting(faktura);
                Setting kartica = new Setting();
                kartica.setActual("true");
                kartica.setName("kartica");
                restoran.getServerBO().changeSetting(kartica);
                Setting cek = new Setting();
                cek.setActual("true");
                cek.setName("cek");
                restoran.getServerBO().changeSetting(cek);
            }
        });
        shell.setDefaultButton(okButton);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void izbor1() throws SQLException {
        EntityManager manager = null;
        if (!BMTerminalSettings.isNoviTipPodesavanja().booleanValue()) {
            try {
                Properties props = new Properties();
                props.setProperty("openjpa.ConnectionUserName", "root");
                props.setProperty("openjpa.ConnectionPassword", "928374");
                props.setProperty("openjpa.ConnectionURL", "jdbc:mysql://localhost/restoranbo");
                props.setProperty("openjpa.ConnectionDriverName", "com.mysql.jdbc.Driver");
                props.setProperty("openjpa.jdbc.DBDictionary", "TableType=innodb,blobTypeName=mediumblob");
                props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema");
                EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"restoranbo", (Map)props);
                manager = emf.createEntityManager();
            }
            catch (Exception ex) {
                BMTerminalSettings.setSetting(OptionBO.NOVI_TIP_PODESAVANJA, Boolean.TRUE.toString());
            }
        }
        this.serverBO = new RestoranServerBO(manager, log, "localhost");
        if (manager != null) {
            List<Setting> sList = this.serverBO.getSettingsOld();
            for (Setting s : sList) {
                if (s == null || s.getActual() == null) continue;
                BMTerminalSettings.setSetting(s);
            }
            List<String> grupe = this.serverBO.getActual2("grupe");
            BMTerminalSettings.setGrupe(grupe);
            BMTerminalSettings.setSetting(OptionBO.NOVI_TIP_PODESAVANJA, Boolean.TRUE.toString());
        }
        if (this.serverBO.getSetting(OptionBO.FISKALNI_PRINTER).intValue() == 0) {
            this.inicijalniIzbor(this);
        }
        Konstante.setTipStampaca(this.serverBO.getSetting(OptionBO.FISKALNI_PRINTER).intValue());
        for (Map.Entry<PoreskaGrupa, PoreskaStopa> entry : PoreskeStope.getRates().entrySet()) {
            PoreskaGrupa poreskaGrupa = entry.getKey();
            PoreskaStopa poreskaStopa = entry.getValue();
            System.out.println("poreskaGrupa = " + poreskaGrupa.name());
            System.out.println("poreskaStopa = " + poreskaStopa.getPersistValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void izbor2(boolean bpl) {
        this.host = BMTerminalSettings.getSetting(OptionBO.ADRESA).stringValue();
        this.schemaName = BMTerminalSettings.getSetting(OptionBO.BAZA).stringValue();
        this.dbUser = BMTerminalSettings.getSetting(OptionBO.USER).stringValue();
        this.dbPass = BMTerminalSettings.getSetting(OptionBO.PASS).stringValue();
        this.backoffice = BMTerminalSettings.getSetting(OptionBO.BACK_OFFICE).booleanValue();
        if (BMTerminalSettings.getSetting(OptionBO.BACK_OFFICE).booleanValue() && BMTerminalSettings.getSetting(OptionBO.BACK_OFFICE_VISE_HOSTOVA).booleanValue()) {
            HostChoiceNew newHosts = new HostChoiceNew(this.server);
            Host mainHost = newHosts.getHost();
            if (mainHost != null) {
                this.host = mainHost.getHostAddress();
                BMTerminalSettings.setSetting(OptionBO.ADRESA, this.host);
                this.schemaName = mainHost.getHostShemaName();
                BMTerminalSettings.setSetting(OptionBO.BAZA, this.schemaName);
                this.dbUser = mainHost.getHostUser();
                BMTerminalSettings.setSetting(OptionBO.USER, this.dbUser);
                this.dbPass = mainHost.getHostPassword();
                BMTerminalSettings.setSetting(OptionBO.PASS, this.dbPass);
            } else {
                if (this.display != null && !this.display.isDisposed()) {
                    this.display.dispose();
                }
                this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                this.server.fine("Izlazak iz programa", this.getClass());
                System.exit(0);
            }
        }
        try {
            if (!bpl) {
                Setting s = BMTerminalSettings.getSetting(OptionBO.TRENUTNI_TIP_LICENCE);
                int licT = 0;
                if (s != null) {
                    licT = s.intValue();
                }
                this.checkLicType(licT);
            }
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Restoran.this.ldngScr = new LoadingScreen(Restoran.this.display);
                }
            });
            this.bootLog();
            this.bootOpenJPA(bpl);
            this.bootDerby();
            this.bootStartData();
            this.listaGostiju = this.server.readStalniGosti();
            this.server.insertCenovnikTip();
            boolean Bmaster = this.server.getSetting(Option.B_MASTER).booleanValue();
            if (this.backoffice && Bmaster) {
                bpl = true;
            }
            if (!this.serverBO.getSetting(OptionBO.BACK_OFFICE).booleanValue()) {
                this.bootFiscal();
            }
            this.licenceCheck();
            this.bezKasa = this.server.findAllKasa().isEmpty();
            if (!this.serverBO.getSetting(OptionBO.BACK_OFFICE).booleanValue() || this.bezKasa) {
                this.zakljucenjeDana();
                if (this.server.getZdBrojIsNull()) {
                    Date firstPrviZd = this.server.getFirstDateZD();
                    boolean prodji = true;
                    long zdBroj = 0L;
                    for (ZD zd : this.server.getAllZDList()) {
                        if (firstPrviZd.compareTo(zd.getDatum()) != 0) {
                            firstPrviZd = zd.getDatum();
                            prodji = true;
                        }
                        if (prodji) {
                            zd.setZdBroj(++zdBroj);
                            prodji = false;
                        } else {
                            zd.setZdBroj(zdBroj);
                        }
                        this.server.updateZD(zd);
                    }
                }
                if (this.server.getRacunZdBrojIsNull()) {
                    this.server.updateRacunZdBroj();
                }
            }
            this.fillNormativArtikalTable();
            this.srediTrebovanjeIndexDatum();
            if (!bpl) {
                this.licCheck();
            }
            Konstante.vremeOtvaranjaDana = this.server.getPoslednjiPocetni();
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Restoran.this.ldngScr.close();
                }
            });
            this.server.log(Konstante.getBundle().getString("LOG_POKRETANJE_BARMASTERA") + " kasa: " + (this.kasa == null ? " backOffice" : this.kasa.getOznaka()));
            new LoginWindow(this, this.display, null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            log.log(Level.SEVERE, null, ex);
            log.severe("BAILING OUT !!!");
            String msg = ex.getMessage();
            msg = msg != null && msg.length() > 128 ? msg.substring(0, 127) : msg;
            JOptionPane.showMessageDialog(null, "Sistemska greska: " + ex.getClass().getSimpleName() + " => " + msg, "Error", 0);
            if (this.display != null && !this.display.isDisposed()) {
                this.display.dispose();
            }
            System.exit(1);
        }
        finally {
            FontCache.dispose();
            ImageCache.dispose();
            try {
                DAOProducer.instance().close();
            }
            catch (Exception Bmaster) {}
        }
    }

    private void licCheck() {
        Date lastZD = this.server.getLastDateZD();
        Setting pibs = this.server.getSetting(Option.OBJEKAT_PIB);
        Setting cntrys = this.server.getSetting(Option.OBJEKAT_DRZAVA);
        Country c = Country.findByEnumName(cntrys.stringValue());
        if (c == null) {
            cntrys.setActual("");
            this.server.changeSetting(pibs);
            if (this.display != null && !this.display.isDisposed()) {
                this.display.dispose();
            }
            this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA") + " kasa " + (this.kasa == null ? "BackOffice" : this.kasa.getOznaka()));
            this.server.fine("Izlazak iz programa", this.getClass());
            System.exit(0);
        }
        String pib = pibs.stringValue();
        this.licenceFromWEb(c);
        try {
            Date licExp = null;
            try {
                licExp = LicControl.getLicenseValidity(pibs.stringValue(), c.getCode());
            }
            catch (MacAddressReadException | NullPointerException ex) {
                log.log(Level.SEVERE, null, ex);
                this.licInput(pib, c.getCode(), lastZD);
                this.licCheck();
            }
            if (lastZD == null) {
                lastZD = new Date();
            }
            if (licExp != null) {
                if (licExp.compareTo(lastZD) < 0) {
                    this.licInput(pib, c.getCode(), lastZD);
                    this.licCheck();
                    return;
                }
                int leftDays = StatLogic.daysBetween(lastZD, licExp);
                if (leftDays >= 0 && leftDays < 8) {
                    this.licNotify(pib, c.getCode(), lastZD, leftDays);
                }
            } else {
                this.licInput(pib, c.getCode(), lastZD);
                this.licCheck();
            }
            int licType = -1;
            try {
                licType = LicControl.getLicenseType(pib, c.getCode());
            }
            catch (MacAddressReadException ex) {
                Logger.getLogger(Restoran.class.getName()).log(Level.SEVERE, null, ex);
                SWTMessage.showLocalizedMessageDialog(null, String.format(Konstante.getBundle().getString("PORUKA_DOSLO_JE_DO_GRESKE_PRILIKOM_OCITAVANJA_MAC_ADRESE"), new Object[0]), String.format(Konstante.getBundle().getString("TEXT_BARMASTER"), new Object[0]), 4);
                System.exit(1);
            }
            if (licType < 0) {
                this.licInput(pib, c.getCode(), lastZD);
                this.licCheck();
            }
            this.checkLicType(licType);
        }
        catch (FileNotFoundException ex) {
            log.log(Level.SEVERE, null, ex);
            this.licInput(pib, c.getCode(), lastZD);
            this.licCheck();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            this.licInput(pib, c.getCode(), lastZD);
            this.licCheck();
        }
        catch (LicenseNotValid ex) {
            log.log(Level.SEVERE, null, ex);
            this.licInput(pib, c.getCode(), lastZD);
            this.licCheck();
        }
    }

    private void checkLicType(int licType) {
        System.out.println("licType = " + licType);
        switch (licType) {
            case 0: {
                break;
            }
            case 1: {
                BrandingCache.setBrand(BrandingData.BARMASTER);
                break;
            }
            case 2: {
                BrandingCache.setBrand(BrandingData.TRADEMASTER);
                break;
            }
            default: {
                SWTMessage.showMessageDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_PRONADJENA_LICENCA_NIJE_VALIDNA_ZA_OVU_APLIKACIJU"), new Object[0]));
                if (this.display != null && !this.display.isDisposed()) {
                    this.display.dispose();
                }
                this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
                this.server.fine("Izlazak iz programa", this.getClass());
                System.exit(0);
            }
        }
    }

    private void licInput(String in, byte cc, Date lastZD) {
        LicenseInput licin = new LicenseInput(this.display, in, cc, true, lastZD);
    }

    private void licNotify(final String in, final byte cc, final Date lastZD, int daysLeft) {
        final Shell s = new Shell(this.display, 34912);
        s.setText(String.format(Konstante.getBundle().getString("TEXT_INFO"), new Object[0]));
        s.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.horizontalSpan = 2;
        gd.widthHint = 400;
        gd.verticalIndent = 40;
        Font f = FontCache.getFont("Arial", 12, 0);
        Label info = new Label((Composite)s, 0x1000040);
        info.setLayoutData((Object)gd);
        info.setFont(f);
        if (daysLeft > 1) {
            info.setText(String.format(Konstante.getBundle().getString("PORUKA_PREOSTALO_DANA_DO_ISTEKA_LICENCE"), "" + daysLeft));
        } else if (daysLeft == 1) {
            info.setText(String.format(Konstante.getBundle().getString("TEXT_PREOSTAO_JEDAN_DAN_DO_ISTEKA_LICENCE"), new Object[0]));
        } else if (daysLeft == 0) {
            info.setText(String.format(Konstante.getBundle().getString("PORUKA_VASA_LICENCA_ISTICE_DANAS"), new Object[0]));
        }
        GridData gdb = new GridData(0x1000000, 0x1000000, true, true);
        gdb.widthHint = 120;
        gdb.heightHint = 50;
        gdb.verticalIndent = 40;
        Button bExtend = new Button((Composite)s, 72);
        bExtend.setLayoutData((Object)gdb);
        bExtend.setText(String.format(Konstante.getBundle().getString("TEXT_PRODUZI_LICENCU"), new Object[0]));
        bExtend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                s.dispose();
                LicenseInput licIn = new LicenseInput(Restoran.this.display, in, cc, false, lastZD);
                Restoran.this.licCheck();
            }
        });
        Button bContinue = new Button((Composite)s, 72);
        bContinue.setLayoutData((Object)gdb);
        bContinue.setText(String.format(Konstante.getBundle().getString("TEXT_NASTAVI"), new Object[0]));
        bContinue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                s.dispose();
            }
        });
        s.pack();
        Konstante.centerShellOnDisplay(s);
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
    }

    private void intro(final Image image, Shell shell) {
        for (Control c : shell.getChildren()) {
            c.dispose();
        }
        shell.setSize(800, 610);
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
        shell.setBackgroundImage(image);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        if (shell.isVisible()) {
            shell.update();
        } else {
            shell.open();
        }
    }

    private void bootLog() {
        try {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Restoran.this.ldngScr.setStep(1);
                }
            });
            File logs = Logs.getLogsRootFolder();
            if (!logs.isDirectory()) {
                logs.mkdirs();
            }
            log.setLevel(Level.ALL);
            FileHandler hand = new FileHandler(logs.getAbsolutePath() + "/main%g.txt", 1000000, 30, true);
            hand.setFormatter(new SimpleFormatter());
            log.addHandler(hand);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, "Sistemska greska: " + ex.getClass().getSimpleName() + " => " + ex.getMessage(), "Error", 0);
            if (this.display != null && !this.display.isDisposed()) {
                this.display.dispose();
            }
            System.exit(1);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void bootOpenJPA(boolean bpl) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Restoran.this.ldngScr.setStep(2);
            }
        });
        StringBuilder connOptionBuilder = new StringBuilder();
        connOptionBuilder.append("?").append("useUnicode=true");
        connOptionBuilder.append("&").append("connectionCollation=utf8_general_ci");
        connOptionBuilder.append("&").append("characterSetResults=utf8");
        connOptionBuilder.append("&").append("characterEncoding=utf8");
        String connOptions = connOptionBuilder.toString();
        String connStringFormat = "jdbc:mysql://%1$s/%2$s%3$s";
        try {
            System.out.println(String.format(connStringFormat, this.host, "", connOptions));
            this.conn = DriverManager.getConnection(String.format(connStringFormat, this.host, "", connOptions), this.dbUser, this.dbPass);
            try (PreparedStatement stat = this.conn.prepareStatement("CREATE DATABASE IF NOT EXISTS " + this.schemaName + " DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci");){
                stat.execute();
            }
        }
        catch (SQLException sqle) {
            log.log(Level.SEVERE, "Greska kod kreiranja seme", sqle);
        }
        Properties props = new Properties();
        props.setProperty("openjpa.ConnectionUserName", this.dbUser);
        props.setProperty("openjpa.ConnectionPassword", this.dbPass);
        System.out.println(String.format(connStringFormat, this.host, this.schemaName, connOptions));
        props.setProperty("openjpa.ConnectionURL", String.format(connStringFormat, this.host, this.schemaName, connOptions));
        props.setProperty("openjpa.ConnectionDriverName", "com.mysql.jdbc.Driver");
        props.setProperty("openjpa.jdbc.DBDictionary", "TableType=innoDB,blobTypeName=mediumblob");
        props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(SchemaAction='add',ForeignKeys=true)");
        props.setProperty("openjpa.RuntimeUnenhancedClasses", "unsupported");
        props.setProperty("openjpa.Multithreaded", "true");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"restoran", (Map)props);
        EntityManager manager = emf.createEntityManager();
        manager.setFlushMode(FlushModeType.AUTO);
        SingletonEmReference emReference = new SingletonEmReference(manager);
        DAOProducer.instantiate(emf, emReference);
        try {
            BMDBConnectionPool.init(String.format(connStringFormat, this.host, this.schemaName, connOptions), this.dbUser, this.dbPass.toCharArray());
        }
        catch (ClassNotFoundException | SQLException e) {
            log.log(Level.SEVERE, "Greska kod kreiranja connection pool-a", e);
        }
        this.server = new RestoranServer(emf, manager, emReference, this.host, this, this.dbUser, this.dbPass, this.schemaName);
        this.kasa = this.server.getCurrentCounter();
        FrontOfficeServer fos = new FrontOfficeServer(emf);
        try {
            FrontOfficeRemoteServiceServer forss = new FrontOfficeRemoteServiceServer(fos);
            try {
                Registry registry = LocateRegistry.getRegistry(1299);
                registry.rebind("FrontOfficeRemoteService", forss);
            }
            catch (RemoteException rex) {
                Registry registry = LocateRegistry.createRegistry(1299);
                registry.rebind("FrontOfficeRemoteService", forss);
            }
            System.out.println("FrontOfficeRemoteService bound");
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            Logger.getLogger(Restoran.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public RestoranServer getServer() {
        return this.server;
    }

    public RestoranServerBO getServerBO() {
        return this.serverBO;
    }

    public static void main(String[] argv) throws SQLException, RemoteException {
        System.setProperty("user.language", "en");
        System.setProperty("user.country", "US");
        System.setProperty("user.region", "US");
        Locale.setDefault(Locale.US);
        Restoran restoran = new Restoran(argv);
    }

    private void bootFiscal() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Restoran.this.ldngScr.setStep(4);
            }
        });
        String port = this.server.getSetting(Option.FISCAL_PORT).stringValue();
        boolean pdv = this.server.getSetting(Option.U_SISTEMU_PDV).booleanValue();
        if (NO_FISCAL.equals(port)) {
            this.fiscal = new DummyFiscalPrinetImpl(pdv);
            return;
        }
    }

    private void odabirGrupeOdeljenja(Odeljenje od, int cancelCount) {
        OdabirGrupeOdeljenjaZaOdeljenje ogozo = new OdabirGrupeOdeljenjaZaOdeljenje(this.shell);
        ogozo.setPrimaryModal(true);
        ogozo.setBlockOnOpen(true);
        ogozo.setServer(this.server);
        ogozo.setInput(od);
        ogozo.setGrupe(this.server.findAllGrupeOdeljenja());
        if (ogozo.open() == 0) {
            return;
        }
        if (cancelCount < 3) {
            SWTMessage.showLocalizedWarningDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_MORATE_IZABRATI_GRUPU_ODELJENJA_ZA_DATO_ODELJENJE"), new Object[0]));
            this.odabirGrupeOdeljenja(od, ++cancelCount);
        } else {
            this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
            this.server.fine("Izlazak iz programa", this.getClass());
            this.display.dispose();
            System.exit(0);
        }
    }

    private Kasa unosNoveKase(String hostName, int cancelCount) {
        Kasa k = new Kasa();
        k.setHostname(hostName);
        k.setOdeljenja(new LinkedList<Odeljenje>());
        UpravljanjeKasom uk = new UpravljanjeKasom(this.shell);
        uk.setHostNameDisabled(true);
        uk.setServer(this.server);
        uk.setInput(k);
        uk.setBlockOnOpen(true);
        uk.create();
        if (uk.open() == 0) {
            return uk.getInput();
        }
        if (cancelCount < 3) {
            SWTMessage.showLocalizedWarningDialog(this.shell, String.format(Konstante.getBundle().getString("PORUKA_MORATE_UNETI_NOVU_KASU_U_SISTEM"), new Object[0]));
            return this.unosNoveKase(hostName, ++cancelCount);
        }
        this.server.log(Konstante.getBundle().getString("LOG_IZLAZAK_IZ_PROGRAMA"));
        this.server.fine("Izlazak iz programa", this.getClass());
        this.display.dispose();
        System.exit(0);
        return null;
    }

    private void bootStartData() {
        List<Odeljenje> odeljenja = this.server.findDepartmentsWithoutGroups();
        for (Odeljenje od : odeljenja) {
            this.odabirGrupeOdeljenja(od, 0);
        }
        Setting bo = BMTerminalSettings.getSetting(OptionBO.BACK_OFFICE);
        if (!bo.booleanValue()) {
            Kasa k;
            String hostName = null;
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (hostName == null) {
                hostName = "localHost";
            }
            if ((k = this.server.findKasaByHostName(hostName)) == null) {
                k = this.unosNoveKase(hostName, 0);
            }
            boolean kasaempty = this.server.isKasaOdeljenjeEmpty();
            if (k != null) {
                this.server.setCurrentCounter(k);
                if (kasaempty) {
                    for (Kasa kasa : this.server.findAllKasa()) {
                        for (Odeljenje odeljenje : this.server.getOdeljenjaBezMagacina()) {
                            if (kasa.getOdeljenja().contains(odeljenje)) continue;
                            this.server.insertIntoKasa_Odeljenje(kasa, odeljenje);
                        }
                    }
                }
            } else {
                SWTMessage.showLocalizedWarningDialog(this.shell, String.format(Konstante.getBundle().getString("TEXT_DOSLO_JE_DO_GRESKE_KOD_CITANJA_KASE"), new Object[0]));
            }
        }
    }

    private void bootDerby() throws SQLException {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Restoran.this.ldngScr.setStep(3);
            }
        });
        this.conn = DriverManager.getConnection("jdbc:mysql://" + this.host + "/" + this.schemaName + "?autoReconnect=true", this.dbUser, this.dbPass);
    }

    private void licenceCheck() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Restoran.this.ldngScr.setStep(5);
            }
        });
        if (this.fiscal == null) {
            return;
        }
    }

    private void zakljucenjeCenovnika(Date datumZakljucivanja) {
        this.server.findAllCenaZaDan();
    }

    public FiscalPrinter getFiscal() {
        return this.fiscal;
    }

    public boolean licenceTimeCheck(Shell shell, boolean exit) {
        if (this.fiscal == null) {
            return false;
        }
        Date exp = this.fiscal.licenceExpiresIn();
        int style = 65600;
        if (exp == null) {
            MessageBox messageBox = new MessageBox(shell, style);
            messageBox.setText("Greska");
            messageBox.setMessage("Licenca je istekla.");
            messageBox.open();
            if (exit) {
                if (this.display != null && !this.display.isDisposed()) {
                    this.display.dispose();
                }
                System.exit(0);
            }
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(exp);
        if (cal.get(1) - 1970 > 0) {
            return true;
        }
        int days = cal.get(6);
        if (days > 10) {
            return true;
        }
        if (days > 3) {
            MessageBox messageBox = new MessageBox(shell, style);
            messageBox.setText("Upozorenje");
            messageBox.setMessage("Licenca istice za " + days + " dana " + cal.get(11) + " sati i " + cal.get(12) + " minuta.");
            messageBox.open();
        } else {
            MessageBox messageBox = new MessageBox(shell, style);
            messageBox.setText("Upozorenje");
            messageBox.setMessage("Licenca istice za " + days + " dana " + cal.get(11) + " sati i " + cal.get(12) + " minuta.\nNakon toga PROGRAM VISE NECETE MOCI KORISTITI.");
            messageBox.open();
        }
        return true;
    }

    public Logger getLog() {
        return log;
    }

    public void ioException(Shell owner, SerialIOException ex) {
        log.log(Level.SEVERE, null, ex);
        this.getPoruka(owner, "Greska pri pristupu stampacu.");
    }

    public void fiscalException(Shell owner, FiscalException ex) {
        log.log(Level.SEVERE, null, ex);
        this.getPoruka(owner, "Greska u komunikaciji sa stampacem.");
    }

    public void sqlException(Shell owner, SQLException ex) {
        log.log(Level.SEVERE, null, ex);
        this.getPoruka(owner, "Greska u pristupu bazi podataka.");
    }

    public void getPoruka(Shell shell, String poruka) {
        int style = 1;
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText("Greska");
        messageBox.setMessage(poruka);
        messageBox.open();
    }

    public synchronized void zakljucenjeDana() {
        boolean pretplata = this.serverBO.getSetting(OptionBO.PRETPLATA).booleanValue();
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                Restoran.this.ldngScr.setStep(6);
            }
        });
        Date lastZD = this.server.getLastDateZD();
        Date bcurrent = new Date();
        Calendar current = Calendar.getInstance();
        current.setTime(bcurrent);
        Calendar vremeZatvaranja = Calendar.getInstance();
        if (lastZD == null) {
            log.info("Prvo pokretanje programa");
            ZD zd = new ZD();
            zd.setDatum(new Date());
            zd.setZakljucenje(new Date());
            zd.setPocetak(true);
            zd.setZdBroj(1L);
            zd.setRekonstrukcija(false);
            this.server.addZD(zd);
        } else {
            System.out.println("------Poslednji ZD je  " + lastZD.toString());
            System.out.println("------Trenutni datum je   " + bcurrent.toString());
            System.out.println("------Vreme je " + vremeZatvaranja.toString());
            Date lastZdDate = lastZD;
            System.out.println("------bdate = " + lastZdDate);
            System.out.println("dosao vamo");
            Date zdCloseTime = this.server.getSetting(Option.ZAKLJUCENJE_DANA_VREME).timeValue();
            this.ukljuciIndex();
            this.ukljuciIndexRacun();
            this.ukljuciIndexRacunKomitent();
            this.ukljuciIndexRacunZdBroj();
            this.ukljuciIndexStavkaGlavnaStavka();
            this.ukljuciIndexTrebovanjeNarudz();
            this.ukljuciIndexRacunC();
            this.iskljuciIndexKomitentPib();
            this.popuniProdajnuCenu();
            this.srediTura();
            System.out.println("dosao ovde 1");
            log.log(Level.INFO, "Vreme zakljucenja dana: {0}, poslednji ZD: {1}", new Object[]{zdCloseTime, lastZdDate});
            vremeZatvaranja.setTime(zdCloseTime);
            System.out.println("dosao do ovde");
            System.out.println(vremeZatvaranja);
            Calendar lastZdDatum = Calendar.getInstance();
            System.out.println("Last ZD" + lastZdDatum.getTime());
            lastZdDatum.setTime(lastZdDate);
            System.out.println("Last ZD" + lastZdDatum.getTime());
            boolean zakljcenjePrethodnogDana = Boolean.parseBoolean(this.server.getSetting(Option.ZAKLJUCENJE_U_PRETHODNOM_DANU).getActual());
            Calendar reference = Calendar.getInstance();
            reference.set(1, lastZdDatum.get(1));
            reference.set(2, lastZdDatum.get(2));
            if (zakljcenjePrethodnogDana) {
                if (vremeZatvaranja.get(11) > 11) {
                    reference.set(5, lastZdDatum.get(5));
                } else {
                    reference.set(5, lastZdDatum.get(5) + 1);
                }
            } else {
                reference.set(5, lastZdDatum.get(5) + 1);
            }
            reference.set(11, vremeZatvaranja.get(11));
            reference.set(12, vremeZatvaranja.get(12));
            System.out.println("reference.getTime() = " + reference.getTime());
            System.out.println("bcurrent = " + bcurrent);
            if (reference.getTime().before(bcurrent)) {
                if (Konstante.getTipStampaca() == 2) {
                    try {
                        XMLWriterHCP.writeArtikle();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(Restoran.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (this.serverBO.getSetting(OptionBO.SOFTVERSKO_ZAKLJUCENJE).booleanValue() || this.bezKasa) {
                    Calendar kalendarRacun;
                    Date datumRacun;
                    System.out.println("Zapo\u010deto softversko zaklju\u010denje");
                    List<Sto> stolovi = this.server.getStolove();
                    ZD zd = new ZD();
                    zd.setDatum(lastZD);
                    Calendar refCCal = Calendar.getInstance();
                    refCCal.setTime(lastZD);
                    refCCal.set(11, vremeZatvaranja.get(11));
                    refCCal.set(12, vremeZatvaranja.get(12));
                    refCCal.set(13, vremeZatvaranja.get(13));
                    refCCal.set(14, vremeZatvaranja.get(14));
                    if (vremeZatvaranja.get(9) == 0) {
                        refCCal.add(5, 1);
                    }
                    if (Konstante.getOnlyDate(Konstante.dateAfter(lastZD)).before(Konstante.getOnlyDate(bcurrent))) {
                        zd.setZakljucenje(refCCal.getTime());
                    } else {
                        for (Sto s : stolovi) {
                            List<Tura> list = this.server.getNenaplaceneTure(s.getBroj());
                        }
                        Date datumRacun2 = new Date();
                        Calendar kalendarRacun2 = Calendar.getInstance();
                        kalendarRacun2.setTime(datumRacun2);
                        kalendarRacun2.set(11, vremeZatvaranja.get(11));
                        kalendarRacun2.set(12, vremeZatvaranja.get(12) - 1);
                        kalendarRacun2.set(13, 0);
                        if (stolovi.size() > 0) {
                            zd.setZakljucenje(kalendarRacun2.getTime());
                        } else {
                            zd.setZakljucenje(datumRacun2);
                        }
                    }
                    zd.setPocetak(false);
                    zd.setZdBroj(this.server.getLastOpenZD().getZdBroj());
                    zd.setRekonstrukcija(false);
                    this.server.addZD(zd);
                    for (EvidencijaZaposlenih ez : this.server.readNeodjavljeneZaposlene()) {
                        ez.setOdlazak(refCCal.getTime());
                        ez.setOdjavljen(true);
                        this.server.updateEZ(ez);
                    }
                    this.server.refresh();
                    lastZD = Konstante.dateAfter(lastZD);
                    boolean pretpl = true;
                    while (Konstante.getOnlyDate(lastZD).before(Konstante.getOnlyDate(bcurrent))) {
                        pretpl = false;
                        if (pretplata) {
                            this.proveraPretplate(lastZD);
                        }
                        System.out.println("Otvaranje dana " + lastZD.toString());
                        zd = new ZD();
                        zd.setDatum(lastZD);
                        refCCal = Calendar.getInstance();
                        refCCal.setTime(lastZD);
                        refCCal.set(11, vremeZatvaranja.get(11));
                        refCCal.set(12, vremeZatvaranja.get(12));
                        refCCal.set(13, vremeZatvaranja.get(13));
                        refCCal.set(14, vremeZatvaranja.get(14));
                        if (vremeZatvaranja.get(9) == 1) {
                            refCCal.add(5, -1);
                        }
                        zd.setZakljucenje(refCCal.getTime());
                        zd.setPocetak(true);
                        zd.setZdBroj(this.server.getLastOpenZD().getZdBroj() + 1L);
                        zd.setRekonstrukcija(false);
                        this.server.addZD(zd);
                        System.out.println("Zatvaranje dana " + lastZD.toString());
                        zd = new ZD();
                        zd.setDatum(lastZD);
                        refCCal.add(5, 1);
                        if (Konstante.getOnlyDate(Konstante.dateAfter(lastZD)).before(Konstante.getOnlyDate(bcurrent))) {
                            zd.setZakljucenje(refCCal.getTime());
                        } else {
                            datumRacun = lastZD;
                            kalendarRacun = Calendar.getInstance();
                            kalendarRacun.setTime(datumRacun);
                            kalendarRacun.set(11, vremeZatvaranja.get(11));
                            kalendarRacun.set(12, vremeZatvaranja.get(12) - 1);
                            zd.setZakljucenje(kalendarRacun.getTime());
                        }
                        zd.setPocetak(false);
                        zd.setZdBroj(this.server.getLastOpenZD().getZdBroj());
                        zd.setRekonstrukcija(false);
                        this.server.addZD(zd);
                        lastZD = Konstante.dateAfter(lastZD);
                    }
                    zd = new ZD();
                    if (pretplata && pretpl) {
                        this.proveraPretplate(lastZD);
                    }
                    if (Konstante.getOnlyDate(Konstante.dateAfter(lastZD)).before(Konstante.getOnlyDate(bcurrent))) {
                        zd.setZakljucenje(refCCal.getTime());
                    } else {
                        datumRacun = new Date();
                        kalendarRacun = Calendar.getInstance();
                        kalendarRacun.setTime(datumRacun);
                        kalendarRacun.set(11, vremeZatvaranja.get(11));
                        kalendarRacun.set(12, vremeZatvaranja.get(12) - 1);
                        if (stolovi.size() > 0) {
                            zd.setZakljucenje(kalendarRacun.getTime());
                        } else {
                            zd.setZakljucenje(datumRacun);
                        }
                    }
                    zd.setPocetak(true);
                    zd.setZdBroj(this.server.getLastOpenZD().getZdBroj() + 1L);
                    Date d = null;
                    try {
                        d = (this.server.getSetting(Option.RADNO_VREME).booleanValue() || vremeZatvaranja.get(11) > 11) && this.serverBO.getSetting(OptionBO.SOFTVERSKO_ZAKLJUCENJE).booleanValue() ? Konstante.dateAfter(this.server.getLastDateZD()) : new Date();
                    }
                    catch (Exception e) {
                        d = new Date();
                    }
                    zd.setDatum(d);
                    zd.setRekonstrukcija(false);
                    this.server.addZD(zd);
                    Setting bt = this.server.getSetting(Option.TURA_SLEDECI_BROJ);
                    bt.setActual("1");
                    this.server.changeSetting(bt);
                    System.out.println("Zavr\u0161eno softversko zaklju\u010denje");
                    System.out.println("Zaklju\u010denje dnevnog cenovnika zapo\u010deto!!!");
                } else {
                    this.getPoruka(new Shell(), "Na serveru nije zaklju\u010den dan");
                    if (this.display != null && !this.display.isDisposed()) {
                        this.display.dispose();
                    }
                    System.exit(1);
                }
                boolean fZaklj = this.serverBO.getSetting(OptionBO.FISKALNO_ZAKLJUCENJE).booleanValue();
                boolean autoZaklj = this.serverBO.getSetting(OptionBO.AUTOMATSKO_ZAKLJUCENJE_FISKALA).booleanValue();
                log.info("fiskalno zakljucenje: " + fZaklj + ", Automatsko zakljucenje: " + autoZaklj);
                if (fZaklj && autoZaklj) {
                    log.info("Zakljucivanje stolova.");
                    List<Sto> stolovi = this.server.getStolove();
                    log.info("Zakljucivanje stolova zavrseno.");
                    try {
                        this.getServerBO().resetPomocniBrojStola();
                        this.getServer().resetSledeciPLUMenija();
                        log.info("Pomo\u0107ni broj stola resetovan");
                    }
                    catch (Exception e) {
                        log.warning("Do\u0161lo je do gre\u0161ke prilikom resetovanja pomo\u0107nog broja stola.");
                    }
                    try {
                        this.server.deleteRezervacijaDatum(new Date());
                        if (Konstante.getTipStampaca() == 1) {
                            if (this.server.getSetting(Option.TRGOVINA) != null && this.server.getSetting(Option.TRGOVINA).booleanValue()) {
                                this.server.log("Zatvori dan (Z izvestaj)");
                                XMLWriter.writeReport(5);
                            } else {
                                this.server.log("Zatvori dan (Z izvestaj)");
                                XMLWriter.writeReport(4);
                            }
                        } else if (Konstante.getTipStampaca() == 2) {
                            XMLWriterHCP.writeDnevniIzvestajIPresekStanja();
                        } else if (Konstante.getTipStampaca() == 3) {
                            EINisWriter.printArticleReportWithClearing(1, 60000);
                            EINisWriter.printXReport();
                            EINisWriter.printZReport();
                            EINisWriter.emptyArticles();
                        } else if (Konstante.getTipStampaca() == 21) {
                            FLinkProtocol.getInstance().stampaPresekaStanja();
                            FLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                        } else if (Konstante.getTipStampaca() == 22) {
                            MetaLinkProtocol.getInstance().stampaPresekaStanja();
                            MetaLinkProtocol.getInstance().stampaDnevnogIzvestaja();
                        }
                        FiskalneFunkcije.setPoslednjiZ();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                boolean automatischeDepositen = false;
                try {
                    automatischeDepositen = BMTerminalSettings.getSetting(OptionBO.DEPOZIT_AUTOMATSKI_UNOS).booleanValue();
                }
                catch (Exception e) {
                    automatischeDepositen = false;
                }
                if (automatischeDepositen) {
                    Double d = 0.0;
                    try {
                        String depositen = BMTerminalSettings.getSetting(OptionBO.DEPOIZT_IZNOS).stringValue();
                        if (depositen != null && depositen.length() > 0) {
                            NumberFormat nf;
                            if (depositen.contains(",")) {
                                try {
                                    nf = NumberFormat.getInstance(Locale.GERMAN);
                                    nf.setGroupingUsed(false);
                                    Number nn = nf.parse(depositen);
                                    d = nn.doubleValue();
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.out);
                                }
                            } else if (depositen.contains(".")) {
                                try {
                                    nf = NumberFormat.getInstance(Locale.UK);
                                    nf.setGroupingUsed(false);
                                    Number nn = nf.parse(depositen);
                                    d = nn.doubleValue();
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.out);
                                }
                            } else {
                                try {
                                    nf = NumberFormat.getIntegerInstance();
                                    nf.setGroupingUsed(false);
                                    Number nn = nf.parse(depositen);
                                    d = nn.doubleValue();
                                }
                                catch (Exception e) {
                                    e.printStackTrace(System.out);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                    if (d > 0.0) {
                        try {
                            if (Konstante.getTipStampaca() == 1) {
                                XMLWriter.writeDeposit(d);
                            } else if (Konstante.getTipStampaca() == 21) {
                                FLinkProtocol.getInstance().uplataDepozita(d);
                            } else if (Konstante.getTipStampaca() == 22) {
                                MetaLinkProtocol.getInstance().uplataDepozita(d);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(Restoran.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
    }

    private void proveraPretplate(Date lastZD) {
        Calendar zaGoste = Calendar.getInstance();
        zaGoste.setTime(lastZD);
        for (StalniGost sg : this.listaGostiju) {
            StalniGostPretplata sgp = this.server.getSGpretplata(sg);
            if (sgp == null || !sgp.isUkljuceno() || !sgp.isAktivna()) continue;
            switch (sgp.getTipPretplate().name()) {
                case "DNEVNI": {
                    sgp.setPretplata(sgp.getIznosAktPretplate());
                    try {
                        this.server.updateStalniGostPretplata(sgp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "NEDELJNI": {
                    if (zaGoste.get(7) != 1) break;
                    sgp.setPretplata(sgp.getIznosAktPretplate());
                    try {
                        this.server.updateStalniGostPretplata(sgp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "MESECNI": {
                    if (zaGoste.get(5) != 1) break;
                    sgp.setPretplata(sgp.getIznosAktPretplate());
                    try {
                        this.server.updateStalniGostPretplata(sgp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "GODISNJI": {
                    if (zaGoste.get(6) != 1) break;
                    sgp.setPretplata(sgp.getIznosAktPretplate());
                    try {
                        this.server.updateStalniGostPretplata(sgp);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case "PERIODICNI": {
                    Calendar period = Calendar.getInstance();
                    period.setTime(sgp.getOdVremena());
                    period.add(5, (int)sgp.getNaBrojDana());
                    boolean isSameDay = DateUtils.isSameDay((Calendar)zaGoste, (Calendar)period);
                    if (!isSameDay) break;
                    sgp.setPretplata(sgp.getIznosAktPretplate());
                    sgp.setOdVremena(new Timestamp(new Date().getTime()));
                    try {
                        this.server.updateStalniGostPretplata(sgp);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void srediTura() {
        Connection conn = this.server.getConnection();
        String index = "update tura set pocetak = '1970-01-01 01:00:00', kraj = '1970-01-01 01:00:00' where kraj = '0000-00-00 00:00:00'";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void popuniProdajnuCenu() {
        this.server.setProdajnuCenu();
    }

    private void ukljuciIndexZD() {
        Connection conn = this.server.getConnection();
        String index = "ALTER TABLE `zd` ADD INDEX `i_datum`(`datum`,`pocetak`)USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndex() {
        for (Konobar k : this.server.readSveKonobar()) {
            if (k.getBlokiranje() == null) {
                k.setBlokiranje(false);
            }
            if (k.getMozeStorno() == null) {
                k.setMozeStorno(false);
            }
            if (k.getMedjuzirBezSifre() == null) {
                k.setMedjuzirBezSifre(false);
            }
            if (k.getOtvaraKomitenta() == null) {
                k.setOtvaraKomitenta(false);
            }
            if (k.getOtvaraPreduzece() == null) {
                k.setOtvaraPreduzece(false);
            }
            if (k.getOtvaraMeni() == null) {
                k.setOtvaraMeni(false);
            }
            if (k.getPrometNaMeniPromet() == null) {
                k.setPrometNaMeniPromet(false);
            }
            if (k.getAdministracijaPopusta() == null) {
                k.setAdministracijaPousta(false);
            }
            this.server.updateKonobar(k);
        }
        String upit = "select count(*) c from setting group by name HAVING c>1 limit 1";
        String delete = "delete s2 from setting s1, setting s2 where s1.name = s2.name and s1.id<s2.id";
        String index = "CREATE INDEX I_STVKRCN_GSTVKID ON restoran.stavkaracuna(GLAVNASTAVKA_ID) USING BTREE;";
        String index2 = "SELECT * FROM information_schema.STATISTICS\nWHERE TABLE_SCHEMA = 'restoran' AND TABLE_NAME = 'setting' AND INDEX_NAME = 'U_SETTING_NAME' ";
        String index1 = "ALTER TABLE `setting`\tADD UNIQUE INDEX `U_SETTING_NAME` (`name`)";
        try {
            Statement st = this.server.getConnection().createStatement();
            ResultSet rs = null;
            rs = st.executeQuery(upit);
            if (rs.next()) {
                st.execute(delete);
            }
            if (!(rs = st.executeQuery(index2)).next()) {
                st.executeUpdate(index1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void iskljuciIndexKomitentPib() {
        Connection conn = this.server.getConnection();
        String index1 = "ALTER TABLE `komitent` DROP INDEX `U_KOMITNT_PIB`;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexRacunC() {
        Connection conn = this.server.getConnection();
        String index1 = "CREATE INDEX I_RACUN_DATUM_C ON restoran.racun(crnoPlacanje,datum) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexRacun() {
        Connection conn = this.server.getConnection();
        String index1 = "CREATE INDEX I_RACUN_DATUM ON restoran.racun(datum) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexRacunZdBroj() {
        Statement st2;
        Connection conn = this.server.getConnection();
        String index2 = "CREATE INDEX I_RACUN_ZD_BROJ ON restoran.racun(zdBroj) USING BTREE;";
        try {
            st2 = conn.createStatement();
            st2.executeUpdate(index2);
        }
        catch (SQLException st2) {
            // empty catch block
        }
        index2 = "CREATE INDEX I_ZD_BROJ ON restoran.zd(zdBroj) USING BTREE;";
        try {
            st2 = conn.createStatement();
            st2.executeUpdate(index2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexRacunKomitent() {
        Connection conn = this.server.getConnection();
        String index2 = "CREATE INDEX I_RACUN_KOMITENT ON restoran.racun(KOMITENT_ID) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index2);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexStavkaGlavnaStavka() {
        Connection conn = this.server.getConnection();
        String index3 = "CREATE INDEX I_STVKRCN_GLAVNASTAVKA ON restoran.stavkaracuna(GLAVNASTAVKA_ID) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index3);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void ukljuciIndexTrebovanjeNarudz() {
        Connection conn = this.server.getConnection();
        String index4 = "CREATE INDEX I_TREBOVNJ_NARUDZ ON restoran.trebovanje(NARUDZ_ID) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index4);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void fillNormativArtikalTable() {
        List<NormativArtikal> lista = this.server.getNormativArtiaklList();
        if (lista.isEmpty()) {
            for (Artikal artikal : this.server.sviArtikli()) {
                List<Normativ> normativList = this.server.getNormativi(artikal.getId());
                if (normativList.isEmpty()) continue;
                NormativArtikal normativArtikal = new NormativArtikal();
                normativArtikal.setArtikal(artikal);
                normativArtikal.setDatum(this.server.getFirstDateZD());
                normativArtikal.setUname("admin");
                this.server.addNormativArtikal(normativArtikal);
                for (Normativ normativ : normativList) {
                    this.server.updateNormativArtikalUNormativu(normativ, normativArtikal);
                }
            }
        }
    }

    private void proveriIndex() {
        Connection conn = this.server.getConnection();
        String index = "CREATE INDEX I_STVKRCN_GSTVKID ON restoran.stavkaracuna(GLAVNASTAVKA_ID) USING BTREE;";
        try {
            Statement st = conn.createStatement();
            st.executeUpdate(index);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void srediTrebovanjeIndexDatum() {
        Connection conn = this.server.getConnection();
        String indexQuery = "SHOW INDEXES FROM trebovanje WHERE Key_name = 'I_TREBOVNJ_DATTREB'";
        try {
            Statement indexStatement = conn.createStatement();
            ResultSet rs = indexStatement.executeQuery(indexQuery);
            if (!rs.next()) {
                indexQuery = "ALTER TABLE `trebovanje`ADD INDEX `I_TREBOVNJ_DATTREB` (`datumTrebovanja`) USING BTREE ";
                indexStatement.execute(indexQuery);
                System.out.println("Ubacio sam index");
            } else {
                System.out.println("Vec postoji Index");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void zakljuciDnevniCenovnik(RestoranServer server, Date zaDan) throws Exception {
        DnevniCenovnik dc = server.findDnevniCenovnikForDate(zaDan);
        if (dc == null) {
            dc = new DnevniCenovnik();
        }
        dc.setZaDan(zaDan);
        List<Artikal> aList = server.sviArtikli();
        LinkedList<DnevniCenovnikStavka> dcsList = new LinkedList<DnevniCenovnikStavka>();
        for (Artikal a : aList) {
            DnevniCenovnikStavka dcs = new DnevniCenovnikStavka();
            dcs.setCenovnik(dc);
            dcs.setArtikal(a);
            dcs.setProdajnaCena(a.getCena());
            dcs.setNabavnaCenaPoslednja(server.getLastNabavnaCenaBelaForDate(a, zaDan));
            dcs.setNabavnaCenaDodatnaPoslednja(server.getLastNabavnaCenaCrnaForDate(a, zaDan));
            dcs.setNabavnaCenaKombinovanaPoslednja(server.getLastNabavnaCenaKomboForDate(a, zaDan));
            dcs.setNabavnaCenaProsecna(server.getAvgNabavnaCenaBelaForDate(a, zaDan));
            dcs.setNabavnaCenaDodatnaProsecna(server.getAvgNabavnaCenaCrnaForDate(a, zaDan));
            dcs.setNabavnaCenaKombinovanaProsecna(server.getAvgNabavnaCenaKomboForDate(a, zaDan));
            dcsList.add(dcs);
        }
        dc.setStavke(dcsList);
        server.createOrUpdateCenovnik(dc);
    }

    public List<ObjectWrapper> getStope() {
        ArrayList<ObjectWrapper> stope = new ArrayList<ObjectWrapper>();
        for (PoreskaGrupa pg : PoreskaGrupa.values()) {
            PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
            if (!ps.isUsed()) continue;
            ObjectWrapper ow = new ObjectWrapper(pg, ps.getNaziv(), (int)Math.round(ps.getStopa()));
            stope.add(ow);
        }
        return stope;
    }

    public void licenceFromWEb(Country county) {
        try {
            String ctrlCode = LicLogic.getControlCode(this.server.getSetting(Option.OBJEKAT_PIB).stringValue(), county.getCode());
            System.out.println(ctrlCode);
            System.out.println(ctrlCode);
            JSONObject json = Restoran.readJsonFromUrl("http://licence.petcom.rs/preuzmilicencu.php?ZaKljuc=" + ctrlCode);
            for (int i = 0; i < 10; ++i) {
                int c;
                BufferedWriter bufwriter;
                if (json == null) continue;
                String licenca = json.getString("licenca");
                String licFolder = "./license";
                InputStreamReader fr = null;
                File licFold = new File(licFolder);
                if (!licFold.exists()) {
                    licFold.mkdir();
                }
                for (File file : new File(licFolder).listFiles()) {
                    if (file.isDirectory()) continue;
                    file.delete();
                }
                File f = new File(licFolder + File.separator + ctrlCode + ".lic");
                if (!f.canRead()) {
                    f.createNewFile();
                    try {
                        bufwriter = new BufferedWriter(new FileWriter(f));
                        if (licenca.trim().equals("nemakreiranihlicenca")) {
                            bufwriter.write("");
                        } else {
                            bufwriter.write(licenca);
                        }
                        bufwriter.close();
                    }
                    catch (Exception e) {
                        System.out.println("Error occured while attempting to write to file: " + e.getMessage());
                    }
                } else {
                    try {
                        bufwriter = new BufferedWriter(new FileWriter(f));
                        bufwriter.write(licenca);
                        bufwriter.close();
                    }
                    catch (Exception e) {
                        System.out.println("Error occured while attempting to write to file: " + e.getMessage());
                    }
                }
                if (f.exists()) {
                    fr = new FileReader(f);
                }
                while ((c = fr.read()) > -1) {
                    licenca = licenca + (char)c;
                }
                fr.close();
                System.out.println(i);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static JSONObject readJsonFromUrl(String url) {
        JSONObject json = null;
        InputStream is = null;
        try {
            is = new URL(url).openStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = Restoran.readAll(rd).replace("mycallback(", "").replace(");", "");
            json = new JSONObject(jsonText);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return json;
    }

    private class DerbyShutdown
    extends Thread {
        private DerbyShutdown() {
        }

        @Override
        public void run() {
            try {
                String url = "jdbc:derby:restoran;shutdown=true";
                DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                log.info(e.getMessage());
            }
        }
    }
}

