/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.UpdateThread;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Kartica;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.TipArtikla;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;

public class RacunNit
extends UpdateThread {
    private Boolean crno;
    String dokument = null;

    public RacunNit(RestoranServer s, Map<Artikal, Double> m, Date d, String dok, Boolean c, Odeljenje o) {
        super(s, m, d, o);
        this.crno = c;
        this.dokument = dok;
        this.em = this.server.getBase().getEntityManagerFactory().createEntityManager();
    }

    @Override
    public void run() {
        ArrayList<Kartica> createList = new ArrayList<Kartica>();
        ArrayList<Kartica> updateList = new ArrayList<Kartica>();
        for (Artikal a1 : this.mapa.keySet()) {
            Artikal a = this.server.getArtikal(a1.getName());
            a.setNijeDeoSlozenog(a1.getNijeDeoSlozenog());
            Kartica kartica = this.server.getLastKartica(a1, this.odeljenje, this.datum, this.crno);
            if (kartica == null) {
                kartica = new Kartica();
                kartica.setArtikal(a);
                kartica.setOdeljenje(this.odeljenje);
                kartica.setCrno(this.crno);
                kartica.setKolicina(-((Double)this.mapa.get(a)).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getTip().equals((Object)TipArtikla.DODA) && a.getNijeDeoSlozenog().booleanValue()) {
                    kartica.setIzlazKOM((int)((Double)this.mapa.get(a) / a.getMera()));
                }
                kartica.setDatum(this.datum);
                kartica.setNabavnaCena(a.getTrenutnaNV());
                kartica.setDokument(this.dokument);
                createList.add(kartica);
            } else {
                double kol = kartica.getKolicina();
                kartica.setKolicina(kol -= ((Double)this.mapa.get(a)).doubleValue());
                if (a.getTip().equals((Object)TipArtikla.PROD) && a.getTip().equals((Object)TipArtikla.DODA) && a.getNijeDeoSlozenog().booleanValue()) {
                    int d = kartica.getIzlazKOM() != null ? kartica.getIzlazKOM() : 0;
                    kartica.setIzlazKOM(d + (int)((Double)this.mapa.get(a) / a.getMera()));
                }
                kartica.setNabavnaCena(a.getTrenutnaNV());
                updateList.add(kartica);
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.datum);
            calendar.set(13, 34);
            this.datum = calendar.getTime();
            Kartica nullKartica = this.server.getLastNullKartica(a1, this.odeljenje, this.datum);
            if (nullKartica == null) continue;
            double kolicina = nullKartica.getKolicina();
            nullKartica.setKolicina(kolicina + (Double)this.mapa.get(a));
            if (a.getTip().equals((Object)TipArtikla.PROD) && a.getNijeDeoSlozenog().booleanValue()) {
                int d = nullKartica.getIzlazKOM() != null ? nullKartica.getIzlazKOM() : 0;
                nullKartica.setIzlazKOM(d - (int)((Double)this.mapa.get(a) / a.getMera()));
            }
            updateList.add(nullKartica);
        }
        this.server.updateKartice(updateList);
        this.server.addKartice(createList);
        this.em.close();
        System.gc();
    }

    private void updateKartice(List<Kartica> updateList) {
        EntityTransaction trans = this.em.getTransaction();
        try {
            while (trans.isActive()) {
                RacunNit.sleep(200L);
            }
            trans.begin();
            int i = 0;
            for (Kartica k : updateList) {
                k = (Kartica)this.em.merge((Object)k);
                if (++i % 500 != 0) continue;
                this.em.flush();
            }
            trans.commit();
        }
        catch (InterruptedException ie) {
            if (trans.isActive()) {
                trans.rollback();
            }
            Logger.getLogger(RacunNit.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom azuriranja kartica", ie);
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            Logger.getLogger(RacunNit.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom azuriranja kartica", e);
        }
    }

    private void createKartice(List<Kartica> createList) {
        EntityTransaction trans = this.em.getTransaction();
        try {
            while (trans.isActive()) {
                RacunNit.sleep(200L);
            }
            trans.begin();
            int i = 0;
            for (Kartica k : createList) {
                this.em.persist((Object)k);
                if (++i % 500 != 0) continue;
                this.em.flush();
            }
            trans.commit();
        }
        catch (InterruptedException ie) {
            if (trans.isActive()) {
                trans.rollback();
            }
            Logger.getLogger(RacunNit.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom azuriranja kartica", ie);
        }
        catch (Exception e) {
            if (trans.isActive()) {
                trans.rollback();
            }
            Logger.getLogger(RacunNit.class.getName()).log(Level.WARNING, "Doslo je do greske prilikom azuriranja kartica", e);
        }
    }

    private Artikal findArtikalByName(String name) throws Exception {
        TypedQuery tqa = this.em.createQuery("SELECT a FROM Artikal a WHERE a.name = :name", Artikal.class);
        tqa.setParameter("name", (Object)name);
        tqa.setMaxResults(1);
        try {
            return (Artikal)tqa.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
        catch (Exception e) {
            String message = "Doslo je do greske prilikom trazenja artikla sa nazivom " + name;
            Logger.getLogger(RacunNit.class.getName()).log(Level.WARNING, message, e);
            throw new Exception(message, e);
        }
    }

    public Kartica getLastKartica(Artikal artikal, Odeljenje o, Date date, Boolean crno) {
        Kartica returnKartica = null;
        TypedQuery qGetLastKartica = this.em.createQuery("SELECT k FROM Kartica k WHERE k.artikal = :artikal AND k.odeljenje = :o AND k.crno = :c and k.datum=:date", Kartica.class);
        try {
            qGetLastKartica.setParameter("artikal", (Object)artikal);
            qGetLastKartica.setParameter("o", (Object)o);
            qGetLastKartica.setParameter("date", (Object)date);
            qGetLastKartica.setParameter("c", (Object)crno);
            returnKartica = (Kartica)qGetLastKartica.getSingleResult();
        }
        catch (Exception nre) {
            Logger.getLogger(RacunNit.class.getName()).warning("Kartica nije pronadjena! Vraca se null referenca.");
        }
        return returnKartica;
    }
}

