/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTList;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.izvestaji.SettingException;
import com.dev63.restoran.izvestaji.StampaPrijemnice;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.stampa.UskaStampa;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PrijemnicaPregled {
    private SWTList lista;
    private DefaultListModel listModel;
    private Restoran restoran;
    private RestoranServer server;
    private SWTContainer parent;
    private Shell shell;
    private Prijemnica active;

    public PrijemnicaPregled(SWTContainer owner, Restoran hostel) {
        this.parent = owner;
        this.restoran = hostel;
        this.server = hostel.getServer();
        this.shell = this.parent.getControl().getShell();
        this.listModel = new DefaultListModel();
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List((Composite)this.shell, 512);
        this.lista = new SWTList(list);
        this.lista.setModel(this.listModel);
        this.lista.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = PrijemnicaPregled.this.lista.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                PrijemnicaPregled.this.setActivePrijemnica((Prijemnica)PrijemnicaPregled.this.listModel.getElementAt(index));
            }
        });
        this.reload();
        this.shell.setLayout((Layout)new FillLayout());
    }

    private void reload() {
        this.listModel.clear();
        List<Prijemnica> prijemnice = this.server.readPrijemnice();
        for (Prijemnica p : prijemnice) {
            this.listModel.addElement(p);
        }
        this.active = null;
    }

    private void setActivePrijemnica(Prijemnica p) {
        this.active = p;
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.parent.getControl().getDisplay());
        PrijemnicaDialog pd = new PrijemnicaDialog(SWTContainerClass.makeContainer(shell2, "Pregled prijemnice"), this.active, this.restoran);
        SWTContainerClass.makeEnd(shell2);
    }

    public static class PrijemnicaDialog {
        SWTContainer parent;
        Table table;
        Button plus;
        Button minus;
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy.");
        DecimalFormat format = new DecimalFormat("#.##");
        Prijemnica prijemnica;
        RestoranServer server;
        Restoran restoran;

        public PrijemnicaDialog(SWTContainer owner, Prijemnica prijem, Restoran s) {
            this.restoran = s;
            this.server = this.restoran.getServer();
            this.parent = owner;
            this.prijemnica = prijem;
            final Shell shell = this.parent.getControl().getShell();
            shell.setLocation(10, 1);
            Label bp = new Label((Composite)shell, 0);
            bp.setText("Broj prijemnice:");
            bp.setBackground(shell.getDisplay().getSystemColor(22));
            Label brojPr = new Label((Composite)shell, 0);
            brojPr.setText(this.prijemnica.getBrPrijemnice());
            brojPr.setBackground(shell.getDisplay().getSystemColor(22));
            Label pm = new Label((Composite)shell, 0);
            pm.setText("Proizvodno mesto:");
            pm.setBackground(shell.getDisplay().getSystemColor(22));
            Label ma = new Label((Composite)shell, 0);
            ma.setText("MAGACIN");
            ma.setBackground(shell.getDisplay().getSystemColor(22));
            Label d = new Label((Composite)shell, 0);
            d.setText("Dobavljac:");
            d.setBackground(shell.getDisplay().getSystemColor(22));
            Label dobav = new Label((Composite)shell, 0);
            dobav.setText(this.prijemnica.getDobavljac().getSkrNaziv());
            dobav.setBackground(shell.getDisplay().getSystemColor(22));
            Label dat = new Label((Composite)shell, 0);
            dat.setText("Datum prijema:");
            dat.setBackground(shell.getDisplay().getSystemColor(22));
            Label datum = new Label((Composite)shell, 0);
            datum.setText(this.dateFormat.format(this.prijemnica.getDatumPrijemnice()));
            datum.setBackground(shell.getDisplay().getSystemColor(22));
            Label dat2 = new Label((Composite)shell, 0);
            dat2.setText("Datum azuriranja:");
            dat2.setBackground(shell.getDisplay().getSystemColor(22));
            Label datum2 = new Label((Composite)shell, 0);
            datum2.setText(this.dateFormat.format(this.prijemnica.getDatumUnosa()));
            datum2.setBackground(shell.getDisplay().getSystemColor(22));
            Label opisL = new Label((Composite)shell, 0);
            opisL.setText("Opis:");
            opisL.setBackground(shell.getDisplay().getSystemColor(22));
            Text opis = new Text((Composite)shell, 2560);
            opis.setText(this.prijemnica.getOpis());
            Label separator1 = new Label((Composite)shell, 258);
            this.table = new Table((Composite)shell, 68356);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
            nazivArtikla.setText("Artikal");
            nazivArtikla.setWidth(180);
            TableColumn kolicina = new TableColumn(this.table, 0x1000000);
            kolicina.setText("Kol.");
            kolicina.setWidth(110);
            TableColumn jm = new TableColumn(this.table, 0x1000000);
            jm.setText("J.M.");
            jm.setWidth(110);
            TableColumn ck = new TableColumn(this.table, 0x1000000);
            ck.setText("Cena J.M. bez poreza");
            ck.setWidth(110);
            TableColumn nv = new TableColumn(this.table, 0x1000000);
            nv.setText("Nab. vred. bez poreza");
            nv.setWidth(110);
            for (PrijemnicaStavka ps : this.server.readStavkePrijemnice(this.prijemnica)) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(new String[]{ps.getArtikal().getName(), this.format.format(ps.getKolicina()), ps.getArtikal().getJedinicaMere(), this.format.format(ps.getKomad()), this.format.format(ps.getVrednost())});
            }
            Label separator2 = new Label((Composite)shell, 258);
            Label t = new Label((Composite)shell, 0);
            t.setText("Ukupna vrednost prijemnice:");
            t.setBackground(shell.getDisplay().getSystemColor(22));
            Label total = new Label((Composite)shell, 0);
            total.setText(this.format.format(this.prijemnica.getTotal()));
            total.setBackground(shell.getDisplay().getSystemColor(22));
            Label separator3 = new Label((Composite)shell, 258);
            Button printButt = new Button((Composite)shell, 8);
            printButt.setText("Stampa");
            printButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Shell shell2 = new Shell(shell.getDisplay());
                    try {
                        new StampaPrijemnice(SWTContainerClass.makeContainer(shell2, "Stampa prijemnice"), prijemnica, restoran);
                        SWTContainerClass.makeEnd(shell2);
                    }
                    catch (SettingException ex) {
                        Logger.getLogger(PrijemnicaPregled.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            });
            Button uska = new Button((Composite)shell, 8);
            uska.setText("Uska stampa");
            uska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UskaStampa(prijemnica, restoran);
                }
            });
            Button cancelButt = Dugmici.getCancelButton(shell);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    parent.getControl().getShell().close();
                }
            });
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.heightHint = 25;
            bp.setLayoutData((Object)data);
            brojPr.setLayoutData((Object)data);
            pm.setLayoutData((Object)data);
            ma.setLayoutData((Object)data);
            d.setLayoutData((Object)data);
            dat.setLayoutData((Object)data);
            datum.setLayoutData((Object)data);
            dat2.setLayoutData((Object)data);
            datum2.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 120;
            data.heightHint = 40;
            printButt.setLayoutData((Object)data);
            uska.setLayoutData((Object)data);
            total.setLayoutData((Object)data);
            dobav.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 150;
            data.horizontalSpan = 2;
            data = new GridData();
            data.horizontalSpan = 2;
            opisL.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            separator1.setLayoutData((Object)data);
            separator2.setLayoutData((Object)data);
            separator3.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 600;
            data.heightHint = 150;
            this.table.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.heightHint = 60;
            opis.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 250;
            data.horizontalAlignment = 131072;
            t.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }
    }
}

