/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import Stampa.core.GridPrinter;
import Stampa.test.PrintHandler;
import Stampa.test.TableWrapper;
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTOptionPane;
import com.dev63.restoran.Dugmici;
import com.dev63.restoran.ImagePath;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.PopisProvera;
import com.dev63.restoran.Restoran;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.SWTContainerClass;
import com.dev63.restoran.SkidanjeNormativa;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.Otpis;
import com.dev63.restoran.model.OtpisStavka;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import com.dev63.restoran.sistem.UnosOtpisa;
import com.dev63.restoran.stampa.UskaStampa;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PregledOtpisa {
    private final ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    Shell shella;
    Restoran restoran;
    RestoranServer server;
    Display display;
    List list;
    private Date day;
    private Date day2;
    private Otpis active;
    private OtpisStavka activeStavka;
    private Odeljenje odeljenje;
    boolean isCrno;
    Table table;
    private TableColumnLayout tcl;
    private TableViewer tableRacuni2V;
    List<Otpis> otpisi = new LinkedList<Otpis>();
    public Label total;
    public Label total1;

    public PregledOtpisa(Display display, final Shell shell, Restoran r, Date day1, Date day2, final Odeljenje o, Boolean crno) {
        this.restoran = r;
        this.server = this.restoran.getServer();
        this.shella = new Shell(shell, 1264);
        display = this.shella.getDisplay();
        this.shella.setText("Pregled otpisa za odeljenje " + o.getNaziv());
        this.shella.setLayout((Layout)new GridLayout(2, false));
        this.shella.setBackground(display.getSystemColor(1));
        this.day = day1;
        this.day2 = day2;
        this.odeljenje = o;
        this.isCrno = crno;
        Composite tclc = new Composite((Composite)this.shella, 0);
        this.tcl = new TableColumnLayout();
        tclc.setLayout((Layout)this.tcl);
        this.table = new Table(tclc, 65796);
        this.table.setFont(Konstante.getFont(display, 8, 0));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableRacuni2V = new TableViewer(this.table);
        this.tableRacuni2V.setContentProvider((IContentProvider)new PregledOtpisaContentProvider());
        this.tableRacuni2V.setInput(this.otpisi);
        final Button izmenaTreb = new Button((Composite)this.shella, 72);
        this.tableRacuni2V.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableItem[] items = PregledOtpisa.this.table.getSelection();
                TableItem item = items[0];
                try {
                    Date datumOd = new SimpleDateFormat("dd.MM.yyyy").parse(item.getText(0));
                    PopisProvera provera = new PopisProvera(PregledOtpisa.this.server, shell, datumOd, o, false);
                    if (provera.isPopis()) {
                        izmenaTreb.setEnabled(false);
                    } else {
                        izmenaTreb.setEnabled(true);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
        this.makeHeaders();
        this.reload();
        Font buttonFont = FontCache.getFont("Arial", 18, 0);
        izmenaTreb.setText(String.format(this.barmasterText.getString("TEXT_IZMENA"), new Object[0]));
        izmenaTreb.setFont(buttonFont);
        izmenaTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledOtpisa.this.table.getSelectionIndex() < 0) {
                    PregledOtpisa.this.active = null;
                    return;
                }
                if (PregledOtpisa.this.table.getSelectionIndex() > PregledOtpisa.this.otpisi.size() - 1) {
                    return;
                }
                PregledOtpisa.this.active = PregledOtpisa.this.otpisi.get(PregledOtpisa.this.table.getSelectionIndex());
                PregledOtpisa.this.setActiveOtpis(PregledOtpisa.this.active, o, true);
            }
        });
        Button brisanjeTreb = new Button((Composite)this.shella, 72);
        brisanjeTreb.setText(String.format(this.barmasterText.getString("TEXT_BRISANJE"), new Object[0]));
        brisanjeTreb.setFont(buttonFont);
        brisanjeTreb.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledOtpisa.this.table.getSelectionIndex() < 0) {
                    PregledOtpisa.this.active = null;
                    return;
                }
                PregledOtpisa.this.active = PregledOtpisa.this.otpisi.get(PregledOtpisa.this.table.getSelectionIndex());
                boolean potvrda = Konstante.getPorukaDaNe(PregledOtpisa.this.shella, "Da li ste sigurni da hocete da obrisete otpis?").isOdgovorPozitivan();
                if (potvrda) {
                    PregledOtpisa.this.server.deleteOtpis(PregledOtpisa.this.active);
                    int broj = PregledOtpisa.this.server.sledeciBrojOtpisa();
                    PregledOtpisa.this.server.setBrojOtpisa(broj);
                    PregledOtpisa.this.reload();
                }
            }
        });
        Button potvrda = new Button((Composite)this.shella, 72);
        potvrda.setText(String.format(Konstante.getBundle().getString("TEXT_POTVRDI"), new Object[0]));
        potvrda.setFont(buttonFont);
        potvrda.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (PregledOtpisa.this.table.getSelectionIndex() < 0) {
                    PregledOtpisa.this.active = null;
                    return;
                }
                PregledOtpisa.this.active = PregledOtpisa.this.otpisi.get(PregledOtpisa.this.table.getSelectionIndex());
                PregledOtpisa.this.setActivePrijemnica(PregledOtpisa.this.active, false);
            }
        });
        Button gore = new Button((Composite)this.shella, 132);
        gore.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledOtpisa.this.table.getSelectionIndex();
                if (index == -1) {
                    if (PregledOtpisa.this.table.getItemCount() != 0) {
                        PregledOtpisa.this.table.setSelection(0);
                    }
                } else if (index != 0) {
                    PregledOtpisa.this.table.setSelection(--index);
                }
            }
        });
        Button dole = new Button((Composite)this.shella, 1028);
        dole.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = PregledOtpisa.this.table.getSelectionIndex();
                if (index == -1) {
                    PregledOtpisa.this.table.setSelection(PregledOtpisa.this.table.getItemCount() - 1);
                } else if (index != PregledOtpisa.this.table.getItemCount() - 1) {
                    PregledOtpisa.this.table.setSelection(++index);
                }
            }
        });
        Button button = new Button((Composite)this.shella, 72);
        button.setText(String.format(Konstante.getBundle().getString("TEXT_IZLAZ"), new Object[0]));
        button.setFont(buttonFont);
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PregledOtpisa.this.shella.close();
            }
        });
        this.table.addListener(12, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 0;
        data.verticalSpan = 7;
        tclc.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, true);
        data.widthHint = 164;
        data.heightHint = 80;
        potvrda.setLayoutData((Object)data);
        button.setLayoutData((Object)data);
        data = new GridData(0x1000000, 0x1000008, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        gore.setLayoutData((Object)data);
        dole.setLayoutData((Object)data);
        data = new GridData(0x1000000, 1, false, false);
        data.widthHint = 164;
        data.heightHint = 80;
        izmenaTreb.setLayoutData((Object)data);
        brisanjeTreb.setLayoutData((Object)data);
        this.shella.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)buttonFont));
        this.shella.open();
        while (!this.shella.isDisposed()) {
            if (this.shella.getDisplay().readAndDispatch()) continue;
            this.shella.getDisplay().sleep();
        }
    }

    private void makeHeaders() {
        TableColumn t1 = new TableColumn(this.table, 131072);
        t1.setText(String.format(this.barmasterText.getString("TEXT_DATUM"), new Object[0]));
        this.tcl.setColumnData((Widget)t1, (ColumnLayoutData)new ColumnWeightData(110, true));
        TableViewerColumn tvc1 = new TableViewerColumn(this.tableRacuni2V, t1);
        tvc1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Otpis) {
                    Otpis t = (Otpis)element;
                    return StatLogic.getDateString(t.getDatum());
                }
                return "";
            }
        });
        TableColumn t5 = new TableColumn(this.table, 131072);
        t5.setText(String.format(this.barmasterText.getString("TEXT_BROJ"), new Object[0]));
        this.tcl.setColumnData((Widget)t5, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc5 = new TableViewerColumn(this.tableRacuni2V, t5);
        tvc5.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Otpis) {
                    Otpis t = (Otpis)element;
                    return t.getBroj();
                }
                return "";
            }
        });
        TableColumn t6 = new TableColumn(this.table, 131072);
        t6.setText(String.format(this.barmasterText.getString("TEXT_VREDNOST"), new Object[0]));
        this.tcl.setColumnData((Widget)t6, (ColumnLayoutData)new ColumnWeightData(140, true));
        TableViewerColumn tvc6 = new TableViewerColumn(this.tableRacuni2V, t6);
        tvc6.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Otpis) {
                    Otpis t = (Otpis)element;
                    Double total = 0.0;
                    for (OtpisStavka os : PregledOtpisa.this.server.readStavkeOtpisa(t)) {
                        total = total + os.getKolicina() * os.getArtikal().getCena();
                    }
                    return StatLogic.getNumber02(total);
                }
                return "";
            }
        });
        TableColumn t7 = new TableColumn(this.table, 131072);
        t7.setText(String.format(this.barmasterText.getString("TEXT_OPERATER"), new Object[0]));
        this.tcl.setColumnData((Widget)t7, (ColumnLayoutData)new ColumnWeightData(100, true));
        TableViewerColumn tvc7 = new TableViewerColumn(this.tableRacuni2V, t7);
        tvc7.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Otpis) {
                    Otpis t = (Otpis)element;
                    return t.getUname() != null ? t.getUname() : "";
                }
                return "";
            }
        });
        if (this.isCrno) {
            TableColumn t4 = new TableColumn(this.table, 0x1000000);
            t4.setText("Dodatno");
            t4.setWidth(100);
            this.tcl.setColumnData((Widget)t4, (ColumnLayoutData)new ColumnWeightData(100, true));
            TableViewerColumn tvc4 = new TableViewerColumn(this.tableRacuni2V, t4);
            tvc4.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    if (element instanceof Otpis) {
                        Otpis t = (Otpis)element;
                        return PregledOtpisa.this.isCrno ? String.format(PregledOtpisa.this.barmasterText.getString("TEXT_DA"), new Object[0]) : String.format(PregledOtpisa.this.barmasterText.getString("TEXT_NE"), new Object[0]);
                    }
                    return "";
                }
            });
        }
    }

    private void reload() {
        this.otpisi.clear();
        this.otpisi.addAll(this.server.readOtpisa(this.day, this.day2, this.odeljenje, this.isCrno));
        this.tableRacuni2V.refresh();
        this.active = null;
    }

    private void setActivePrijemnica(Otpis p, boolean pregled) {
        this.active = p;
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell();
        shell2.setFullScreen(true);
        new OtpisDialog(SWTContainerClass.makeContainer(shell2, ""), p, pregled);
    }

    public double getNabavnaCena(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                System.out.println("Nabavne cene sa PDCom: " + a.getId() + ": " + a + " - " + this.server.getLastNabavnaCenaBela(a, new Date()) * mapa.get(a));
                trNv += this.server.getLastNabavnaCenaBela(a, new Date()) * mapa.get(a);
            }
        } else {
            trNv = this.server.getLastNabavnaCenaBela(art, new Date()) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    public double getNabavnaCenaBezPDV(Artikal art, double kolicina) {
        double trNv = 0.0;
        if (art.getTip().equals((Object)TipArtikla.SLOZ) || art.getTip().equals((Object)TipArtikla.POLU) || art.getTip().equals((Object)TipArtikla.DODA)) {
            Map<Artikal, Double> mapa = SkidanjeNormativa.razloziSlozeni2(art, new HashMap<Artikal, Double>(), kolicina, this.server, null, null);
            for (Artikal a : mapa.keySet()) {
                trNv += this.server.getLastNabavnaCenaBelaBezPDV(a, this.active != null ? this.active.getDatum() : new Date()) * mapa.get(a);
            }
        } else {
            trNv = this.server.getLastNabavnaCenaBelaBezPDV(art, this.active != null ? this.active.getDatum() : new Date()) * kolicina;
            trNv *= art.getMera().doubleValue();
        }
        return trNv;
    }

    private void setActiveOtpis(Otpis otpis, Odeljenje o, boolean pregled) {
        this.active = otpis;
        if (this.active == null) {
            return;
        }
        Shell shell2 = new Shell(this.shella.getDisplay());
        new UnosOtpisa(SWTContainerClass.makeContainer(shell2, String.format(this.barmasterText.getString("TEXT_UNOS_PROIZVODNJE_POLUPROIZVODA"), new Object[0])), this.restoran, o, false, this.active);
        this.reload();
    }

    private class OtpisDialog {
        SWTContainer parent;
        Table table;
        Button plus;
        Button minus;
        Otpis otpis;
        boolean sifre;
        boolean pregled;

        public OtpisDialog(SWTContainer owner, Otpis treb, boolean pregled) {
            PregledOtpisa.this.server = PregledOtpisa.this.restoran.getServer();
            this.parent = owner;
            this.otpis = treb;
            this.pregled = pregled;
            final Shell shell = this.parent.getControl().getShell();
            shell.setMaximized(true);
            try {
                this.sifre = PregledOtpisa.this.restoran.getServer().getSetting(Option.STAMPA_SIFARA_DOKUMENTI).booleanValue();
            }
            catch (Exception e) {
                this.sifre = false;
            }
            Composite sve = new Composite((Composite)shell, 0);
            Label pm = new Label(sve, 0);
            pm.setText(PregledOtpisa.this.odeljenje != null ? PregledOtpisa.this.odeljenje.getNaziv() : "");
            pm.setBackground(shell.getDisplay().getSystemColor(22));
            Label bo = new Label(sve, 0);
            bo.setText("Broj otpisa:");
            bo.setBackground(shell.getDisplay().getSystemColor(22));
            Label brojPr = new Label(sve, 0);
            brojPr.setText(treb.getBroj());
            brojPr.setBackground(shell.getDisplay().getSystemColor(22));
            Label dat = new Label(sve, 0);
            dat.setText("Datum otpisa:");
            dat.setBackground(shell.getDisplay().getSystemColor(22));
            Label datum = new Label(sve, 0);
            datum.setText(Konstante.getDate(this.otpis.getDatum()));
            datum.setBackground(shell.getDisplay().getSystemColor(22));
            Label opisL = new Label(sve, 0);
            opisL.setText("Opis:");
            opisL.setBackground(shell.getDisplay().getSystemColor(22));
            Text opis = new Text(sve, 2560);
            opis.setText(this.otpis.getOpis());
            opis.setEnabled(false);
            Label separator1 = new Label(sve, 258);
            this.table = new Table(sve, 68356);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            this.table.addListener(3, new Listener(){

                public void handleEvent(Event e) {
                    if (OtpisDialog.this.table.getSelectionIndex() > -1) {
                        for (OtpisStavka os : PregledOtpisa.this.server.readStavkeOtpisa(OtpisDialog.this.otpis)) {
                            if (!os.getArtikal().getName().equals(OtpisDialog.this.table.getSelection()[0].getText().trim().substring(1, OtpisDialog.this.table.getSelection()[0].getText().length() - 2))) continue;
                            PregledOtpisa.this.activeStavka = os;
                        }
                    }
                }
            });
            TableColumn nazivArtikla = new TableColumn(this.table, 0x1000000);
            nazivArtikla.setText("Artikal");
            nazivArtikla.setWidth(180);
            TableColumn jm = new TableColumn(this.table, 0x1000000);
            jm.setText("J.M.");
            jm.setWidth(70);
            TableColumn kolicina = new TableColumn(this.table, 0x1000000);
            kolicina.setText("Kol.");
            kolicina.setWidth(90);
            TableColumn ck = new TableColumn(this.table, 0x1000000);
            ck.setText("Nab.Cena J.M.");
            ck.setWidth(90);
            TableColumn nv = new TableColumn(this.table, 0x1000000);
            nv.setText("NabVred.");
            nv.setWidth(90);
            TableColumn ck1 = new TableColumn(this.table, 0x1000000);
            ck1.setText("Prod.Cena J.M.");
            ck1.setWidth(100);
            TableColumn nv1 = new TableColumn(this.table, 0x1000000);
            nv1.setText("Prod.Vred.");
            nv1.setWidth(90);
            Label separator2 = new Label(sve, 258);
            Label t = new Label(sve, 0);
            t.setText("Ukupna nab.vrednost:");
            t.setBackground(shell.getDisplay().getSystemColor(22));
            PregledOtpisa.this.total = new Label(sve, 0);
            PregledOtpisa.this.total.setBackground(shell.getDisplay().getSystemColor(22));
            Label t1 = new Label(sve, 0);
            t1.setText("Ukupna prod.vrednost:");
            t1.setBackground(shell.getDisplay().getSystemColor(22));
            PregledOtpisa.this.total1 = new Label(sve, 0);
            PregledOtpisa.this.total1.setBackground(shell.getDisplay().getSystemColor(22));
            this.reloadTable();
            Label separator3 = new Label(sve, 258);
            GridLayout layoutSve = new GridLayout(2, false);
            layoutSve.marginHeight = 10;
            layoutSve.marginWidth = 10;
            layoutSve.verticalSpacing = 10;
            layoutSve.horizontalSpacing = 10;
            sve.setLayout((Layout)layoutSve);
            Composite dugmici = new Composite((Composite)shell, 0);
            Button printButt = new Button(dugmici, 8);
            printButt.setText(String.format(PregledOtpisa.this.barmasterText.getString("TEXT_STAMPA"), new Object[0]));
            printButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Shell shell2 = new Shell(shell.getDisplay());
                    GridPrinter gp = new GridPrinter(new PrintHandler());
                    gp.printTable(new TableWrapper(OtpisDialog.this.table), false, true, "Otpis slozenih artikala " + OtpisDialog.this.otpis.getBroj() + "\nDatum: " + Konstante.getDate(OtpisDialog.this.otpis.getDatum()) + "\nNapomena:" + OtpisDialog.this.otpis.getOpis(), shell, PregledOtpisa.this.server);
                }
            });
            Button uska = new Button(dugmici, 8);
            uska.setText(String.format(PregledOtpisa.this.barmasterText.getString("TEXT_USKA_STAMPA"), new Object[0]));
            uska.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UskaStampa(OtpisDialog.this.otpis, PregledOtpisa.this.restoran);
                }
            });
            Button del = new Button(dugmici, 8);
            del.setEnabled(pregled);
            del.setText(String.format(PregledOtpisa.this.barmasterText.getString("TEXT_OBRISI_STAVKU"), new Object[0]));
            del.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (PregledOtpisa.this.activeStavka != null) {
                        boolean potvrda = Konstante.getPorukaDaNe(shell, "Brisanje stavke otpisa. Nastavi?").isOdgovorPozitivan();
                        if (potvrda) {
                            PregledOtpisa.this.server.deleteOtpisStavka(PregledOtpisa.this.activeStavka);
                        }
                    } else {
                        return;
                    }
                    OtpisDialog.this.reloadTable();
                }
            });
            Button delAll = new Button(dugmici, 8);
            delAll.setEnabled(pregled);
            delAll.setText(String.format(PregledOtpisa.this.barmasterText.getString("TEXT_OBRISI_OTPIS"), new Object[0]));
            delAll.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    if (PregledOtpisa.this.active != null) {
                        boolean potvrda = Konstante.getPorukaDaNe(shell, "Da li ste sigurni da hocete da obrisete otpis?").isOdgovorPozitivan();
                        if (potvrda) {
                            PregledOtpisa.this.server.deleteOtpis(OtpisDialog.this.otpis);
                            int broj = PregledOtpisa.this.server.sledeciBrojOtpisa();
                            PregledOtpisa.this.server.setBrojOtpisa(broj);
                            OtpisDialog.this.parent.getControl().getShell().close();
                            PregledOtpisa.this.reload();
                        }
                    } else {
                        return;
                    }
                }
            });
            Button cancelButt = Dugmici.getCancelButton(dugmici);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    OtpisDialog.this.parent.getControl().getShell().close();
                }
            });
            GridLayout layout1 = new GridLayout(1, false);
            layout1.marginHeight = 10;
            layout1.marginWidth = 10;
            layout1.verticalSpacing = 10;
            layout1.horizontalSpacing = 10;
            dugmici.setLayout((Layout)layout1);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 10;
            layout.marginWidth = 10;
            layout.verticalSpacing = 10;
            layout.horizontalSpacing = 10;
            shell.setLayout((Layout)layout);
            GridData data = new GridData();
            data.widthHint = 150;
            data.horizontalAlignment = 16384;
            bo.setLayoutData((Object)data);
            brojPr.setLayoutData((Object)data);
            dat.setLayoutData((Object)data);
            datum.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            opisL.setLayoutData((Object)data);
            pm.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            separator1.setLayoutData((Object)data);
            separator2.setLayoutData((Object)data);
            separator3.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalSpan = 2;
            data.widthHint = 750;
            data.heightHint = 300;
            this.table.setLayoutData((Object)data);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.heightHint = 60;
            opis.setLayoutData((Object)data);
            data = new GridData();
            data.horizontalAlignment = 16384;
            t.setLayoutData((Object)data);
            PregledOtpisa.this.total.setLayoutData((Object)data);
            t1.setLayoutData((Object)data);
            PregledOtpisa.this.total1.setLayoutData((Object)data);
            data.widthHint = 120;
            data.heightHint = 40;
            printButt.setLayoutData((Object)data);
            uska.setLayoutData((Object)data);
            del.setLayoutData((Object)data);
            delAll.setLayoutData((Object)data);
            cancelButt.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
            while (!shell.isDisposed()) {
                if (shell.getDisplay().readAndDispatch()) continue;
                shell.getDisplay().sleep();
            }
        }

        protected void reloadTable() {
            this.table.removeAll();
            double ukupnoNabavna = 0.0;
            double ukupnoProdajna = 0.0;
            LinkedList<OtpisStavka> deset = new LinkedList<OtpisStavka>();
            LinkedList<OtpisStavka> dvadeset = new LinkedList<OtpisStavka>();
            double nabavnaCena = 0.0;
            double nabavnaCenaSaPDV = 0.0;
            for (OtpisStavka os : PregledOtpisa.this.server.readStavkeOtpisa(this.otpis)) {
                String n;
                if (os.getArtikal().getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_DJ)) {
                    dvadeset.add(os);
                } else if (os.getArtikal().getPoreskaGrupa().equals((Object)PoreskaGrupa.GRUPA_E)) {
                    deset.add(os);
                }
                TableItem item = new TableItem(this.table, 0);
                nabavnaCena = PregledOtpisa.this.getNabavnaCenaBezPDV(os.getArtikal(), 1.0);
                nabavnaCenaSaPDV = PregledOtpisa.this.getNabavnaCena(os.getArtikal(), 1.0);
                if (this.sifre) {
                    String s = os.getArtikal().getBarCode() != null ? os.getArtikal().getBarCode() : "";
                    n = " (" + os.getArtikal().getName() + ")";
                } else {
                    n = os.getArtikal().getName();
                }
                item.setText(new String[]{n, os.getArtikal().getJedinicaMere(), Konstante.getNumber4(os.getKolicina()), Konstante.getNumber4(nabavnaCena), os.getVrednost() != null ? Konstante.getNumber4(nabavnaCena * os.getKolicina()) : "/", os.getArtikal().getCena() != null ? Konstante.getNumber4(os.getArtikal().getCena()) : "0", os.getArtikal().getCena() != null ? Konstante.getNumber4(os.getArtikal().getCena() * os.getKolicina()) : "0"});
                ukupnoNabavna += nabavnaCena * os.getKolicina();
                ukupnoProdajna += os.getArtikal().getCena() * os.getKolicina();
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{"", "", "", "UKUPNO: ", Konstante.getNumber4(ukupnoNabavna), "", Konstante.getNumber4(ukupnoProdajna)});
            TableItem ti = new TableItem(this.table, 0);
            ti.setText("");
            ti = new TableItem(this.table, 0);
            ti.setText("");
            ti = new TableItem(this.table, 0);
            ti.setText("REKAPITULACIJA");
            ti = new TableItem(this.table, 0);
            ti = new TableItem(this.table, 0);
            double nabavna = 0.0;
            double nabSaPDV = 0.0;
            double prodajna = 0.0;
            double prodajnaSaPDV = 0.0;
            double nabPDV = 0.0;
            double prodPDV = 0.0;
            for (OtpisStavka o : deset) {
                o.setVrednost(nabavnaCena * o.getKolicina());
                nabavna += o.getVrednost() / o.getKolicina();
                nabSaPDV += o.getVrednost() * 1.1 / o.getKolicina();
                nabPDV += o.getVrednost() * 1.1 / o.getKolicina() - o.getVrednost() / o.getKolicina();
                prodajna += o.getArtikal().getCena() != null ? o.getArtikal().getCena() / 1.1 * o.getKolicina() : 0.0;
                prodajnaSaPDV += o.getArtikal().getCena() != null ? o.getArtikal().getCena() * o.getKolicina() : 0.0;
                prodPDV += o.getArtikal().getCena() != null ? o.getArtikal().getCena() * o.getKolicina() - o.getArtikal().getCena() / 1.1 * o.getKolicina() : 0.0;
            }
            double nabavna1 = 0.0;
            double nabSaPDV1 = 0.0;
            double prodajna1 = 0.0;
            double prodajnaSaPDV1 = 0.0;
            double nabPDV1 = 0.0;
            double prodPDV1 = 0.0;
            for (OtpisStavka o : dvadeset) {
                o.setVrednost(nabavnaCena * o.getKolicina());
                nabavna1 += o.getVrednost() / o.getKolicina();
                nabSaPDV1 += o.getVrednost() * 1.2 / o.getKolicina();
                nabPDV1 += o.getVrednost() * 1.2 / o.getKolicina() - o.getVrednost() / o.getKolicina();
                prodajna1 += o.getArtikal().getCena() != null ? o.getArtikal().getCena() / 1.2 * o.getKolicina() : 0.0;
                prodajnaSaPDV1 += o.getArtikal().getCena() != null ? o.getArtikal().getCena() * o.getKolicina() : 0.0;
                prodPDV1 += o.getArtikal().getCena() != null ? o.getArtikal().getCena() * o.getKolicina() - o.getArtikal().getCena() / 1.2 * o.getKolicina() : 0.0;
            }
            ti.setText(new String[]{"stope", "Nab.VrednostBezPDV.", "Nab.Vrednost", "NabPDV", "Prod.VrednostBezPDV", "Prod.Vrednost", "Prod.PDV"});
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"10%", Konstante.getNumber4(nabavna), Konstante.getNumber4(nabSaPDV), Konstante.getNumber4(nabPDV), Konstante.getNumber4(prodajna), Konstante.getNumber4(prodajnaSaPDV), Konstante.getNumber4(prodPDV)});
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"20%", Konstante.getNumber4(nabavna1), Konstante.getNumber4(nabSaPDV1), Konstante.getNumber4(nabPDV1), Konstante.getNumber4(prodajna1), Konstante.getNumber4(prodajnaSaPDV1), Konstante.getNumber4(prodPDV1)});
            ti = new TableItem(this.table, 0);
            ti.setText(new String[]{"Ukupno: ", Konstante.getNumber4(nabavna1 + nabavna), Konstante.getNumber4(nabSaPDV1 + nabSaPDV), Konstante.getNumber4(nabPDV1 + nabPDV), Konstante.getNumber4(prodajna1 + prodajna), Konstante.getNumber4(prodajnaSaPDV1 + prodajnaSaPDV), Konstante.getNumber4(prodPDV1 + prodPDV)});
            if (PregledOtpisa.this.server.readStavkeOtpisa(this.otpis).isEmpty()) {
                this.parent.getControl().getShell().close();
                PregledOtpisa.this.server.deleteOtpis(this.otpis);
                PregledOtpisa.this.reload();
            }
            PregledOtpisa.this.activeStavka = null;
            PregledOtpisa.this.total.setText(ukupnoNabavna != 0.0 ? Konstante.getNumber2(ukupnoNabavna) : "/");
            PregledOtpisa.this.total1.setText(ukupnoProdajna != 0.0 ? Konstante.getNumber2(ukupnoProdajna) : "/");
        }
    }

    public static class PregledOtpisaContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof List)) {
                return new Object[0];
            }
            List trebList = (List)inputElement;
            if (trebList.isEmpty()) {
                return new Object[0];
            }
            LinkedList ret = new LinkedList();
            SummaryWrapper total = new SummaryWrapper(0.0, 0.0);
            for (Object o : trebList) {
                if (!(o instanceof Otpis)) continue;
                Otpis t = (Otpis)o;
                double totalBPDV = 0.0;
                double totalSPDV = 0.0;
                for (OtpisStavka ts : t.getStavke()) {
                    Double komadBPDV = ts.getVrednost();
                    if (komadBPDV == null) {
                        komadBPDV = Konstante.getOsnovicaFromBruto(ts.getArtikal().getPoreskaGrupa(), ts.getVrednost());
                    }
                    totalBPDV += komadBPDV * ts.getKolicina();
                    totalSPDV += ts.getVrednost() * ts.getKolicina();
                }
                total.addTotalBPDV(totalBPDV);
                total.addTotal(totalSPDV);
                ret.add(o);
            }
            ret.add(total);
            return ret.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public static class SummaryWrapper {
            private double total;
            private double totalBPDV;

            public SummaryWrapper(double total, double totalBPDV) {
                this.total = total;
                this.totalBPDV = totalBPDV;
            }

            public double getTotal() {
                return this.total;
            }

            public double getTotalBPDV() {
                return this.totalBPDV;
            }

            public double addTotal(double total) {
                this.total += total;
                return this.total;
            }

            public double addTotalBPDV(double total) {
                this.totalBPDV += total;
                return this.totalBPDV;
            }
        }
    }

    public static class PregledOtpisInput {
        private DateInput2 odDatuma;
        private DateInput2 doDatuma;
        private Restoran restoran;
        private RestoranServer server;
        Date day1;
        Date day2;
        Odeljenje o;
        Button crno;
        SWTContainer parent;
        boolean inspektor = false;
        boolean crn = false;

        public PregledOtpisInput(SWTContainer owner, Restoran r, Odeljenje ode, boolean inspektor) {
            this.parent = owner;
            this.restoran = r;
            this.server = this.restoran.getServer();
            this.o = ode;
            this.inspektor = inspektor;
            Shell shell = this.parent.getControl().getShell();
            shell.setLayout((Layout)new GridLayout(1, false));
            Composite panel1 = new Composite((Composite)shell, 0);
            panel1.setLayout((Layout)new GridLayout(3, false));
            GridData data = new GridData();
            Composite panel2 = new Composite((Composite)shell, 0);
            panel2.setLayout((Layout)new GridLayout(1, false));
            data = new GridData();
            Label slika = new Label(panel1, 0);
            slika.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/dpuV.gif"));
            slika.setLayoutData((Object)data);
            data = new GridData();
            data.heightHint = 90;
            data.widthHint = 440;
            Group grupaText = new Group(panel1, 0);
            grupaText.setText("Pregled otpisa");
            grupaText.setLayout((Layout)new FillLayout());
            grupaText.setLayoutData((Object)data);
            Label text = new Label((Composite)grupaText, 64);
            text.setText("");
            Button uputstvo = new Button(panel1, 0);
            uputstvo.setImage(new Image((Device)shell.getDisplay(), ImagePath.getPath() + "/uputstvoV.gif"));
            data = new GridData();
            data.widthHint = 115;
            data.heightHint = 100;
            uputstvo.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            Group grupa1 = new Group(panel2, 0x1000000);
            grupa1.setLayout((Layout)new GridLayout(2, false));
            grupa1.setText("Unos datuma");
            grupa1.setLayoutData((Object)data);
            data = new GridData();
            data.widthHint = 670;
            data.heightHint = 60;
            Group grupa3 = new Group(panel2, 0);
            grupa3.setLayout((Layout)new GridLayout(2, false));
            grupa3.setText("");
            grupa3.setLayoutData((Object)data);
            SWTContainer parent2 = new SWTContainer((Composite)grupa1);
            Label od = new Label((Composite)grupa1, 0);
            Label dod = new Label((Composite)grupa1, 0);
            od.setText("Za dan:");
            dod.setText("Do dana:");
            this.odDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.odDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.odDatuma, shell));
            this.doDatuma = new DateInput2(parent2, "Za dan", new Date(this.server.getLastDateZD().getTime()), false, this.server);
            this.doDatuma.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.doDatuma, shell));
            Label cr = null;
            cr = new Label((Composite)grupa1, 0);
            cr.setText("Popis dodatnog stanja:");
            this.crno = new Button((Composite)grupa1, 32);
            Button cancelButt = Dugmici.getCancelButton((Composite)grupa3);
            cancelButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.cancel();
                }
            });
            Button okButt = Dugmici.getOkButton((Composite)grupa3);
            okButt.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    this.ok();
                }
            });
            data = new GridData();
            data.horizontalAlignment = 16384;
            data.horizontalIndent = 10;
            data.widthHint = 150;
            data.heightHint = 30;
            od.setLayoutData((Object)data);
            dod.setLayoutData((Object)data);
            if (inspektor) {
                cr.setLayoutData((Object)data);
            }
            this.odDatuma.getControl().setLayoutData((Object)data);
            this.doDatuma.getControl().setLayoutData((Object)data);
            this.crno.setLayoutData((Object)data);
            SWTContainerClass.setDimension(shell);
            shell.open();
        }

        private void cancel() {
            this.parent.getControl().getShell().close();
        }

        private void ok() {
            try {
                this.day1 = this.odDatuma.getResult();
                this.day2 = this.doDatuma.getResult();
                if (this.inspektor) {
                    this.crn = this.crno.getSelection();
                }
                Shell shell2 = new Shell(this.parent.getControl().getShell().getDisplay());
                new PregledOtpisa(shell2.getDisplay(), shell2, this.restoran, this.day1, this.day2, this.o, this.crn);
            }
            catch (InputException ex) {
                SWTOptionPane.showMessageDialog(this.parent, (Object)ex.getMessage(), "Greska", 2);
            }
        }
    }
}

