/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran.Pregled;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Izvod;
import com.dev63.restoran.model.IzvodStavka;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.parts.DateInput2;
import com.dev63.restoran.parts.InputException;
import com.dev63.restoran.sistem.CalendarAdapter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PregledIzvoda {
    private Shell shell;
    private RestoranServer dbServer;
    private Table tableIzvodi;
    private Table tableDobavljaci;
    private Text izvodText;
    private DateInput2 datumText;
    private Text sifraKomitentaText;
    private Text nazivKomitentaText;
    private Text iznosText;
    private Text napomenaText;
    private List<IzvodStavka> izvodStavke;
    private List<StalniGost> dobavljaci;
    private StalniGost selectedDobavljac;
    private Text pretragaDobavljacaText;
    private List<StalniGost> filteredDobavljaci;

    public PregledIzvoda(Shell shell, RestoranServer dbServer) {
        this.shell = shell;
        this.dbServer = dbServer;
        this.dobavljaci = new ArrayList<StalniGost>(dbServer.allDobavljaci());
        this.initComponents();
        this.filterDobavljaciByNaziv("");
    }

    public PregledIzvoda(Display display, RestoranServer dbServer) {
        this.shell = new Shell(display, 64);
        this.dbServer = dbServer;
        this.dobavljaci = new ArrayList<StalniGost>(dbServer.allDobavljaci());
        this.initComponents();
        this.filterDobavljaciByNaziv("");
    }

    private void initComponents() {
        this.shell.setText("Pregled izvoda");
        Monitor monitor = this.shell.getMonitor();
        Rectangle screenSize = monitor.getBounds();
        this.shell.setBounds(290, 30, screenSize.width - 290, screenSize.height - 30);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.horizontalSpacing = 30;
        this.shell.setLayout((Layout)gridLayout);
        Group dobavljaciComp = new Group((Composite)this.shell, 64);
        GridData dobavljaciCompData = new GridData();
        dobavljaciCompData.horizontalAlignment = 4;
        dobavljaciCompData.heightHint = (screenSize.height - 30) / 2;
        dobavljaciComp.setLayoutData((Object)dobavljaciCompData);
        GridLayout dobavljaciCompLayout = new GridLayout();
        dobavljaciCompLayout.numColumns = 3;
        dobavljaciComp.setLayout((Layout)dobavljaciCompLayout);
        Label nazivDobavljacaLabel = new Label((Composite)dobavljaciComp, 0);
        nazivDobavljacaLabel.setText("Naziv dobavljaca:");
        this.pretragaDobavljacaText = new Text((Composite)dobavljaciComp, 2048);
        this.pretragaDobavljacaText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.keyCode == 13 || ke.keyCode == 0x1000050) {
                    PregledIzvoda.this.filterDobavljaciByNaziv(PregledIzvoda.this.pretragaDobavljacaText.getText());
                }
            }
        });
        GridData nazivDobavljacaTextData = new GridData();
        nazivDobavljacaTextData.widthHint = 200;
        this.pretragaDobavljacaText.setLayoutData((Object)nazivDobavljacaTextData);
        Button pretragaDobavljaca = new Button((Composite)dobavljaciComp, 8);
        pretragaDobavljaca.setText("Pretraga");
        pretragaDobavljaca.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PregledIzvoda.this.filterDobavljaciByNaziv(PregledIzvoda.this.pretragaDobavljacaText.getText());
            }
        });
        this.tableDobavljaci = new Table((Composite)dobavljaciComp, 66052);
        this.tableDobavljaci.setHeaderVisible(true);
        this.tableDobavljaci.setLinesVisible(true);
        GridData dobavljaciTableData = new GridData();
        dobavljaciTableData.horizontalSpan = 3;
        dobavljaciTableData.horizontalAlignment = 4;
        dobavljaciTableData.verticalAlignment = 4;
        dobavljaciTableData.grabExcessHorizontalSpace = true;
        dobavljaciTableData.grabExcessVerticalSpace = true;
        this.tableDobavljaci.setLayoutData((Object)dobavljaciTableData);
        this.tableDobavljaci.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent me) {
                if (PregledIzvoda.this.tableDobavljaci.getSelectionIndex() >= 0 && PregledIzvoda.this.tableDobavljaci.getSelectionIndex() < PregledIzvoda.this.filteredDobavljaci.size()) {
                    PregledIzvoda.this.selectedDobavljac = (StalniGost)PregledIzvoda.this.filteredDobavljaci.get(PregledIzvoda.this.tableDobavljaci.getSelectionIndex());
                    PregledIzvoda.this.sifraKomitentaText.setText(PregledIzvoda.this.selectedDobavljac.getSifra());
                    PregledIzvoda.this.nazivKomitentaText.setText(PregledIzvoda.this.selectedDobavljac.getNaziv());
                }
            }
        });
        TableColumn sifraDobavljacaColumn = new TableColumn(this.tableDobavljaci, 16384);
        sifraDobavljacaColumn.setText("Sifra");
        TableColumn nazivDobavljacaColumn = new TableColumn(this.tableDobavljaci, 16384);
        nazivDobavljacaColumn.setText("Naziv dobavljaca");
        TableColumn gradDobavljacaColumn = new TableColumn(this.tableDobavljaci, 16384);
        gradDobavljacaColumn.setText("Grad");
        Button odaberiDobavljaca = new Button((Composite)dobavljaciComp, 8);
        odaberiDobavljaca.setText("Odabir");
        odaberiDobavljaca.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                if (PregledIzvoda.this.tableDobavljaci.getSelectionIndex() >= 0 && PregledIzvoda.this.tableDobavljaci.getSelectionIndex() < PregledIzvoda.this.filteredDobavljaci.size()) {
                    PregledIzvoda.this.selectedDobavljac = (StalniGost)PregledIzvoda.this.filteredDobavljaci.get(PregledIzvoda.this.tableDobavljaci.getSelectionIndex());
                    PregledIzvoda.this.sifraKomitentaText.setText(PregledIzvoda.this.selectedDobavljac.getSifra());
                    PregledIzvoda.this.nazivKomitentaText.setText(PregledIzvoda.this.selectedDobavljac.getNaziv());
                }
            }
        });
        GridData odaberiDobavljacaData = new GridData();
        odaberiDobavljacaData.horizontalAlignment = 0x1000008;
        odaberiDobavljacaData.horizontalSpan = 3;
        odaberiDobavljacaData.widthHint = 120;
        odaberiDobavljacaData.heightHint = 40;
        odaberiDobavljaca.setLayoutData((Object)odaberiDobavljacaData);
        this.tableIzvodi = new Table((Composite)this.shell, 66052);
        this.tableIzvodi.setHeaderVisible(true);
        this.tableIzvodi.setLinesVisible(true);
        GridData tableData = new GridData();
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.verticalAlignment = 4;
        tableData.horizontalAlignment = 4;
        tableData.verticalSpan = 2;
        this.tableIzvodi.setLayoutData((Object)tableData);
        TableColumn izvodColumn = new TableColumn(this.tableIzvodi, 16384);
        izvodColumn.setText("Izvod");
        TableColumn datumColumn = new TableColumn(this.tableIzvodi, 16384);
        datumColumn.setText("Datum");
        TableColumn komitentColumn = new TableColumn(this.tableIzvodi, 16384);
        komitentColumn.setText("Komitent");
        TableColumn iznosColumn = new TableColumn(this.tableIzvodi, 131072);
        iznosColumn.setText("Iznos");
        this.tableIzvodi.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent me) {
                IzvodStavka stavka = (IzvodStavka)PregledIzvoda.this.izvodStavke.get(PregledIzvoda.this.tableIzvodi.getSelectionIndex());
                PregledIzvoda.this.selectStavkaIzvoda(stavka);
            }
        });
        Group izvodComp = new Group((Composite)this.shell, 64);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 10;
        izvodComp.setLayout((Layout)formLayout);
        GridData izvodCompData = new GridData();
        izvodCompData.horizontalAlignment = 4;
        izvodCompData.heightHint = (screenSize.height - 30) / 2;
        izvodComp.setLayoutData((Object)izvodCompData);
        Label izvodLabel = new Label((Composite)izvodComp, 0);
        izvodLabel.setText("Izvod:");
        FormData izvodLabelData = new FormData();
        izvodLabelData.left = new FormAttachment(0, 0);
        izvodLabelData.top = new FormAttachment(0, 0);
        izvodLabelData.width = 80;
        izvodLabel.setLayoutData((Object)izvodLabelData);
        Label datumLabel = new Label((Composite)izvodComp, 0);
        datumLabel.setText("Datum:");
        FormData datumLabelData = new FormData();
        datumLabelData.left = new FormAttachment((Control)izvodLabel);
        datumLabelData.top = new FormAttachment(0, 0);
        datumLabelData.width = 80;
        datumLabel.setLayoutData((Object)datumLabelData);
        this.izvodText = new Text((Composite)izvodComp, 2048);
        FormData izvodTextData = new FormData();
        izvodTextData.left = new FormAttachment(0, 0);
        izvodTextData.top = new FormAttachment((Control)izvodLabel);
        izvodTextData.width = 80;
        this.izvodText.setLayoutData((Object)izvodTextData);
        this.datumText = new DateInput2(new SWTContainer((Composite)izvodComp), "datum_izvoda", this.dbServer);
        this.datumText.getControl().addMouseListener((MouseListener)new CalendarAdapter(this.datumText, this.shell));
        FormData datumTextData = new FormData();
        datumTextData.left = new FormAttachment((Control)this.izvodText);
        datumTextData.top = new FormAttachment((Control)datumLabel);
        datumTextData.width = 80;
        this.datumText.getControl().setLayoutData((Object)datumTextData);
        Label komitentLabel = new Label((Composite)izvodComp, 0);
        komitentLabel.setText("Komitent:");
        FormData komitentLabelData = new FormData();
        komitentLabelData.left = new FormAttachment(0, 0);
        komitentLabelData.top = new FormAttachment((Control)this.izvodText);
        komitentLabelData.width = 80;
        komitentLabel.setLayoutData((Object)komitentLabelData);
        this.sifraKomitentaText = new Text((Composite)izvodComp, 2048);
        this.sifraKomitentaText.setEditable(false);
        FormData sifraKomitentaData = new FormData();
        sifraKomitentaData.left = new FormAttachment(0, 0);
        sifraKomitentaData.top = new FormAttachment((Control)komitentLabel);
        sifraKomitentaData.width = 80;
        this.sifraKomitentaText.setLayoutData((Object)sifraKomitentaData);
        this.nazivKomitentaText = new Text((Composite)izvodComp, 2048);
        this.nazivKomitentaText.setEditable(false);
        FormData nazivKomitentaData = new FormData();
        nazivKomitentaData.left = new FormAttachment((Control)this.sifraKomitentaText);
        nazivKomitentaData.top = new FormAttachment((Control)komitentLabel);
        nazivKomitentaData.width = 200;
        this.nazivKomitentaText.setLayoutData((Object)nazivKomitentaData);
        Label iznosLabel = new Label((Composite)izvodComp, 0);
        iznosLabel.setText("Iznos:");
        FormData iznosLabelData = new FormData();
        iznosLabelData.left = new FormAttachment(0, 0);
        iznosLabelData.top = new FormAttachment((Control)this.sifraKomitentaText);
        iznosLabelData.width = 80;
        iznosLabel.setLayoutData((Object)iznosLabelData);
        this.iznosText = new Text((Composite)izvodComp, 2048);
        FormData iznosTextData = new FormData();
        iznosTextData.left = new FormAttachment(0, 0);
        iznosTextData.top = new FormAttachment((Control)iznosLabel);
        iznosTextData.width = 100;
        this.iznosText.setLayoutData((Object)iznosTextData);
        Label napomenaLabel = new Label((Composite)izvodComp, 0);
        napomenaLabel.setText("Napomena:");
        FormData napomenaLabelData = new FormData();
        napomenaLabelData.left = new FormAttachment(0, 0);
        napomenaLabelData.top = new FormAttachment((Control)this.iznosText);
        napomenaLabelData.width = 80;
        napomenaLabel.setLayoutData((Object)napomenaLabelData);
        this.napomenaText = new Text((Composite)izvodComp, 2048);
        FormData napomenaTextData = new FormData();
        napomenaTextData.left = new FormAttachment(0, 0);
        napomenaTextData.top = new FormAttachment((Control)napomenaLabel);
        napomenaTextData.width = 300;
        this.napomenaText.setLayoutData((Object)napomenaTextData);
        Button pretragaIzvoda = new Button((Composite)izvodComp, 8);
        pretragaIzvoda.setText("Pretraga");
        FormData pretragaIzvodaData = new FormData(120, 40);
        pretragaIzvodaData.left = new FormAttachment(80);
        pretragaIzvodaData.top = new FormAttachment((Control)komitentLabel);
        pretragaIzvodaData.right = new FormAttachment(100, -5);
        pretragaIzvoda.setLayoutData((Object)pretragaIzvodaData);
        pretragaIzvoda.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PregledIzvoda.this.filterStavkeIzvoda();
            }
        });
        Button snimanjeIzvoda = new Button((Composite)izvodComp, 8);
        snimanjeIzvoda.setText("Sacuvaj");
        FormData snimanjeIzvodaData = new FormData(120, 40);
        snimanjeIzvodaData.left = new FormAttachment(80);
        snimanjeIzvodaData.top = new FormAttachment((Control)this.iznosText);
        snimanjeIzvodaData.right = new FormAttachment(100, -5);
        snimanjeIzvoda.setLayoutData((Object)snimanjeIzvodaData);
        snimanjeIzvoda.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PregledIzvoda.this.snimanjeIzvoda();
            }
        });
    }

    private void filterStavkeIzvoda() {
        Date datum = null;
        Integer brojIzvoda = null;
        try {
            datum = this.datumText.getResult();
        }
        catch (InputException ex) {
            Logger.getLogger(PregledIzvoda.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            if (!this.izvodText.getText().equals("")) {
                brojIzvoda = Integer.parseInt(this.izvodText.getText());
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        this.izvodStavke = this.dbServer.getIzvodi(brojIzvoda, datum, this.selectedDobavljac);
        DateFormat dateFormat = DateFormat.getDateInstance(2, Konstante.getCurLocale());
        NumberFormat nf = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        DecimalFormat numberFormat = (DecimalFormat)nf;
        numberFormat.applyPattern("###,###.##");
        this.tableIzvodi.removeAll();
        for (IzvodStavka stavka : this.izvodStavke) {
            TableItem ti = new TableItem(this.tableIzvodi, 0);
            ti.setText(new String[]{"" + stavka.getIzvod().getBrojIzvoda(), dateFormat.format(stavka.getIzvod().getDatumIzvoda()), stavka.getKomitent().getNaziv(), numberFormat.format(stavka.getIznos())});
        }
        for (TableColumn tc : this.tableIzvodi.getColumns()) {
            tc.pack();
        }
    }

    private void filterDobavljaciByNaziv(String naziv) {
        this.filteredDobavljaci = new LinkedList<StalniGost>();
        this.tableDobavljaci.removeAll();
        if (naziv.equals("")) {
            this.filteredDobavljaci = new ArrayList<StalniGost>(this.dobavljaci);
        } else {
            for (StalniGost dobavljac : this.dobavljaci) {
                if (!dobavljac.getNaziv().toLowerCase().contains(naziv.toLowerCase())) continue;
                this.filteredDobavljaci.add(dobavljac);
            }
        }
        for (StalniGost dobavljac : this.filteredDobavljaci) {
            TableItem ti = new TableItem(this.tableDobavljaci, 0);
            ti.setText(new String[]{dobavljac.getSifra(), dobavljac.getNaziv(), dobavljac.getMesto()});
        }
        for (TableColumn tc : this.tableDobavljaci.getColumns()) {
            tc.pack();
        }
    }

    private void selectStavkaIzvoda(IzvodStavka stavkaIzvoda) {
        NumberFormat nf = NumberFormat.getNumberInstance(Konstante.getCurLocale());
        DecimalFormat numberFormat = (DecimalFormat)nf;
        numberFormat.applyPattern("###,###.##");
        this.izvodText.setText("" + stavkaIzvoda.getIzvod().getBrojIzvoda());
        this.datumText.setResult(stavkaIzvoda.getIzvod().getDatumIzvoda());
        this.iznosText.setText(numberFormat.format(stavkaIzvoda.getIznos()));
        this.napomenaText.setText(stavkaIzvoda.getNapomena());
        this.selectedDobavljac = stavkaIzvoda.getKomitent();
        this.sifraKomitentaText.setText(this.selectedDobavljac.getSifra());
        this.nazivKomitentaText.setText(this.selectedDobavljac.getNaziv());
    }

    private void snimanjeIzvoda() {
        if (this.selectedDobavljac != null) {
            try {
                Date datum = this.datumText.getResult();
                Integer brojIzvoda = Integer.parseInt(this.izvodText.getText());
                Double iznos = Double.parseDouble(this.iznosText.getText());
                IzvodStavka stavka = new IzvodStavka();
                stavka.setIznos(iznos);
                stavka.setKomitent(this.selectedDobavljac);
                stavka.setNapomena(this.napomenaText.getText());
                Izvod izvod = this.dbServer.getIzvodByBroj(brojIzvoda);
                if (izvod == null) {
                    izvod = new Izvod();
                    izvod.setBrojIzvoda(brojIzvoda);
                    izvod.setDatumIzvoda(datum);
                    izvod.setStavkeIzvoda(new ArrayList<IzvodStavka>());
                    izvod.addStavkaIzvoda(stavka);
                } else {
                    stavka.setIzvod(izvod);
                }
                this.dbServer.snimanjeIzvoda(izvod);
            }
            catch (InputException ex) {
                System.out.println("jfaksfjkajfkl");
            }
            catch (NumberFormatException ex) {
                System.out.println("bbbbbb");
            }
        }
        this.filterStavkeIzvoda();
    }
}

