/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.model.ProtelReservation;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.StavkaRacuna;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PostExample {
    private List<ProtelReservation> protelReservationsList = new ArrayList<ProtelReservation>();
    private Document document;
    private boolean success;
    private String ipAddress;

    public List<ProtelReservation> getProtelReservationsList() {
        NodeList errNodes = this.document.getElementsByTagName("Reservation");
        for (int i = 0; i < errNodes.getLength(); ++i) {
            if (errNodes.getLength() <= 0) continue;
            Element element = (Element)errNodes.item(i);
            ProtelReservation protelReservation = new ProtelReservation();
            protelReservation.setResNo(element.getElementsByTagName("ResNo").item(0).getTextContent());
            protelReservation.setBlocked(Boolean.parseBoolean(element.getElementsByTagName("Blocked").item(0).getTextContent()));
            protelReservation.setRoom(element.getElementsByTagName("Room").item(0).getTextContent());
            protelReservation.setmPeHotel(Integer.parseInt(element.getElementsByTagName("MPEHotel").item(0).getTextContent()));
            protelReservation.setProfile(Integer.parseInt(element.getElementsByTagName("Profile").item(0).getTextContent()));
            protelReservation.setSalutation(element.getElementsByTagName("Salutation").item(0) != null ? element.getElementsByTagName("Salutation").item(0).getTextContent() : "");
            protelReservation.setFirstName(element.getElementsByTagName("FirstName").item(0).getTextContent());
            protelReservation.setLastname(element.getElementsByTagName("LastName").item(0).getTextContent());
            protelReservation.setArrival(element.getElementsByTagName("Arrival").item(0) != null ? new Date(Long.parseLong(element.getElementsByTagName("Arrival").item(0).getTextContent())) : new Date());
            protelReservation.setDeparture(new Date(Long.parseLong(element.getElementsByTagName("Departure").item(0).getTextContent())));
            protelReservation.setRoomRate(element.getElementsByTagName("RoomRate").item(0).getTextContent());
            protelReservation.setBalance(Double.parseDouble(element.getElementsByTagName("Balance").item(0).getTextContent()));
            protelReservation.setCreditLimit(Double.parseDouble(element.getElementsByTagName("CreditLimit").item(0).getTextContent()));
            this.protelReservationsList.add(protelReservation);
        }
        return this.protelReservationsList;
    }

    public ProtelReservation getProtelReservations() {
        NodeList errNodes = this.document.getElementsByTagName("Reservation");
        ProtelReservation protelReservation = null;
        if (errNodes.getLength() > 0) {
            Element element = (Element)errNodes.item(0);
            protelReservation = new ProtelReservation();
            protelReservation.setResNo(element.getElementsByTagName("ResNo").item(0).getTextContent());
            protelReservation.setBlocked(Boolean.parseBoolean(element.getElementsByTagName("Blocked").item(0).getTextContent()));
            protelReservation.setRoom(element.getElementsByTagName("Room").item(0).getTextContent());
            protelReservation.setmPeHotel(Integer.parseInt(element.getElementsByTagName("MPEHotel").item(0).getTextContent()));
            protelReservation.setProfile(Integer.parseInt(element.getElementsByTagName("Profile").item(0).getTextContent()));
            protelReservation.setSalutation(element.getElementsByTagName("Salutation").item(0) != null ? element.getElementsByTagName("Salutation").item(0).getTextContent() : "");
            protelReservation.setFirstName(element.getElementsByTagName("FirstName").item(0).getTextContent());
            protelReservation.setLastname(element.getElementsByTagName("LastName").item(0).getTextContent());
            protelReservation.setArrival(element.getElementsByTagName("Arrival").item(0) != null ? new Date(Long.parseLong(element.getElementsByTagName("Arrival").item(0).getTextContent())) : new Date());
            protelReservation.setDeparture(new Date(Long.parseLong(element.getElementsByTagName("Departure").item(0).getTextContent())));
            protelReservation.setRoomRate(element.getElementsByTagName("RoomRate").item(0).getTextContent());
            protelReservation.setBalance(Double.parseDouble(element.getElementsByTagName("Balance").item(0).getTextContent()));
            protelReservation.setCreditLimit(Double.parseDouble(element.getElementsByTagName("CreditLimit").item(0).getTextContent()));
        }
        return protelReservation;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setProtelReservationsList(List<ProtelReservation> protelReservationsList) {
        this.protelReservationsList = protelReservationsList;
    }

    public void getPOSTFindReservationByRoom(String roomNumber, int mpeHotel, String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<Body><Room>" + roomNumber + "</Room><Mpehotel>" + String.valueOf(mpeHotel) + "</Mpehotel></Body> ";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/FindReservationByRoom");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-length", String.valueOf(51));
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            String inputLine = in.readLine();
            if (inputLine != null) {
                response.append(inputLine);
            }
            in.close();
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(response.toString())));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.out.println("error" + e.getMessage());
        }
    }

    public void getPOSTFindReservationByName(String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<Body>\r\n<Search></Search>\r\n</Body>";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/FindReservationByName");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-length", String.valueOf(30));
            con.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            String inputLine = in.readLine();
            if (inputLine != null) {
                response.append(inputLine);
            }
            in.close();
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(response.toString())));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            System.out.println("error" + e.getMessage());
        }
    }

    public void sendPOSTCloseInvoiceFromBarMaster(Racun racun, String placanje, Double iznos, String payment, String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(racun.getDatum()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + outlet + "</Outlet>\r\n\t<User>" + String.valueOf(racun.getKonobar().getId()) + "</User>\r\n\t<Invoice>" + racun.getBrojRacuna() + "</Invoice>\r\n";
        for (StavkaRacuna stavkaRacuna : racun.getStavke()) {
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(stavkaRacuna.getKolicina() * stavkaRacuna.getCena()) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + stavkaRacuna.getNaziv() + "</Text>\r\n\t\t<Productgroup>" + stavkaRacuna.getArtikal().getPodgrupa().getId() + "</Productgroup>\r\n\t\t<TaxClassification>" + 2 + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(stavkaRacuna.getCena()) + "</SingleAmount>\r\n\t\t<Quantity>" + stavkaRacuna.getKolicina() + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(iznos) + "</TotalAmount>\r\n\t\t<Type>" + placanje + "</Type>\r\n\t\t<Payment>" + payment + "</Payment>\r\n\t</Item>\r\n</Body>";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void sendPOSTCloseInvoice(Racun racun, String placanje, Double iznos, long resNo, String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(racun.getDatum()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + outlet + "</Outlet>\r\n\t<User>" + String.valueOf(racun.getKonobar().getId()) + "</User>\r\n\t<Invoice>" + racun.getBrojRacuna() + "</Invoice>\r\n\t<MPEHotel>1</MPEHotel>\r\n";
        for (StavkaRacuna stavkaRacuna : racun.getStavke()) {
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(stavkaRacuna.getKolicina() * stavkaRacuna.getCena()) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + stavkaRacuna.getNaziv() + "</Text>\r\n\t\t<Productgroup>" + stavkaRacuna.getArtikal().getPodgrupa().getId() + "</Productgroup>\r\n\t\t<TaxClassification>" + 2 + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(stavkaRacuna.getCena()) + "</SingleAmount>\r\n\t\t<Quantity>" + stavkaRacuna.getKolicina() + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(iznos) + "</TotalAmount>\r\n\t\t<Type>" + placanje + "</Type>\r\n\t\t<ResNo>" + String.valueOf(resNo) + "</ResNo>\r\n\t</Item>\r\n</Body>";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void sendPOSTCloseInvoiceStorno(Racun racun, String placanje, Double iznos, String resNo, String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(racun.getDatum()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + outlet + "</Outlet>\r\n\t<User>" + String.valueOf(racun.getKonobar().getId()) + "</User>\r\n\t<Invoice>" + racun.getBrojRacuna() + "</Invoice>\r\n";
        for (StavkaRacuna stavkaRacuna : racun.getStavke()) {
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(stavkaRacuna.getKolicina() * stavkaRacuna.getCena()) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + stavkaRacuna.getNaziv() + "</Text>\r\n\t\t<Productgroup>" + stavkaRacuna.getArtikal().getPodgrupa().getId() + "</Productgroup>\r\n\t\t<TaxClassification>" + 2 + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(stavkaRacuna.getCena()) + "</SingleAmount>\r\n\t\t<Quantity>" + stavkaRacuna.getKolicina() + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(iznos) + "</TotalAmount>\r\n\t\t<Type>" + placanje + "</Type>\r\n\t\t<ResNo>" + resNo + "</ResNo>\r\n\t</Item>\r\n</Body>";
        System.out.println(inputXML);
        System.out.println("sledeci korak konekcija");
        try {
            String output;
            System.out.println("adresa: http://" + this.ipAddress + "/CloseInvoice");
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            System.out.println("da li prodje konekciju");
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            System.out.println("Response CODE: " + con.getResponseCode());
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
            BufferedReader bReader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((output = bReader.readLine()) != null) {
                sb.append(output);
            }
            System.out.println(sb.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }

    public void sendPOSTCloseInvoiceStornoNova(Racun racun, String placanje, Double iznos, String payment, String outlet) throws IOException {
        int dayOfYear = Calendar.getInstance().get(6);
        int secOfDay = LocalTime.now(ZoneId.systemDefault()).toSecondOfDay();
        String inputXML = "<?xml version=\"1.0\" encoding=\"windows-1250\"?>\r\n<Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\r\n\t<Creation>" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(racun.getDatum()).replace("-", "").replace(":", "").replace(" ", "") + "</Creation>\r\n\t<Outlet>" + outlet + "</Outlet>\r\n\t<User>" + String.valueOf(racun.getKonobar().getId()) + "</User>\r\n\t<Invoice>" + racun.getBrojRacuna() + "</Invoice>\r\n";
        for (StavkaRacuna stavkaRacuna : racun.getStavke()) {
            inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(stavkaRacuna.getKolicina() * stavkaRacuna.getCena() * -1.0) + "</TotalAmount>\r\n\t\t<Type>Revenue</Type>\r\n\t\t<Text>" + stavkaRacuna.getNaziv() + "</Text>\r\n\t\t<Productgroup>" + stavkaRacuna.getArtikal().getPodgrupa().getId() + "</Productgroup>\r\n\t\t<TaxClassification>" + 2 + "</TaxClassification>\r\n\t\t<SingleAmount>" + String.valueOf(stavkaRacuna.getCena()) + "</SingleAmount>\r\n\t\t<Quantity>" + stavkaRacuna.getKolicina() * -1.0 + "</Quantity>\r\n\t</Item>\r\n";
        }
        inputXML = inputXML + "\t<Item>\r\n\t\t<TotalAmount>" + String.valueOf(iznos * -1.0) + "</TotalAmount>\r\n\t\t<Type>" + placanje + "</Type>\r\n\t\t<Payment>" + payment + "</Payment>\r\n\t</Item>\r\n</Body>";
        try {
            URL obj = new URL("http://" + this.ipAddress + "/CloseInvoice");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/xml;charset=windows-1250");
            con.setRequestProperty("Transaction", String.valueOf(dayOfYear * 1000 + secOfDay));
            con.setRequestProperty("Outlet", outlet);
            con.setRequestProperty("Content-Length", Integer.toString(inputXML.getBytes().length));
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(10000);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes(inputXML);
            wr.flush();
            wr.close();
            Map<String, List<String>> map = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                System.out.println(entry.getKey() + " : " + entry.getValue().get(0));
                if (entry.getKey() == null || !entry.getKey().trim().equals("Success") || Integer.valueOf(entry.getValue().get(0)) != 0) continue;
                this.success = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Error: " + e.getMessage());
        }
    }
}

