/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.restoran.Konstante;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.parts.DateInput2;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.swt.widgets.Shell;

public class PopisProvera {
    private ResourceBundle barmasterText;
    private RestoranServer server;
    private Shell shell;
    private Date odDatuma;
    private Odeljenje odeljenje;
    boolean isPoruka;

    public PopisProvera(RestoranServer server, Shell shell, Date odDatuma, Odeljenje odeljenje, boolean isPoruka) {
        this.server = server;
        this.odDatuma = odDatuma;
        this.shell = shell;
        this.barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        this.odeljenje = odeljenje;
        this.isPoruka = isPoruka;
    }

    public boolean isPopis() {
        int brojPopisa = 0;
        Connection conn = this.server.getConnection();
        String query = "SELECT COUNT(p.id) as brojPopisa FROM  popis p \r\nWHERE CAST(p.datum  as DATE) > CAST(? AS Date) AND CAST( p.datum  as DATE) <= CAST(NOW() AS DATE) AND p.sravnjenje =1";
        if (this.odeljenje != null) {
            query = query + " and p.ODELJENJE_ID = ?";
        }
        try {
            PreparedStatement st = conn.prepareStatement(query);
            st.setDate(1, new java.sql.Date(this.odDatuma.getTime()));
            if (this.odeljenje != null) {
                st.setLong(2, this.odeljenje.getId());
            }
            ResultSet rs = st.executeQuery();
            rs.next();
            brojPopisa = rs.getInt("brojPopisa");
            if (brojPopisa > 0) {
                if (this.isPoruka) {
                    Konstante.prikaziMessageBox(this.shell, this.barmasterText.getString("PROVERA_POPISA_TEXT"));
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private Date getDatumPoslednjegPopisa() {
        Connection conn = this.server.getConnection();
        String query = "SELECT CAST(p.datum AS DATE) AS datum  FROM  popis p \r\nWHERE CAST( p.datum  as DATE) BETWEEN CAST(? AS Date) AND  CAST(NOW() AS DATE)\r\nAND p.sravnjenje =1 \r\n";
        if (this.odeljenje != null) {
            query = query + " and p.ODELJENJE_ID = ?";
        }
        query = query + " ORDER BY p.id DESC LIMIT 1 ";
        try {
            PreparedStatement st = conn.prepareStatement(query);
            st.setDate(1, new java.sql.Date(this.odDatuma.getTime()));
            if (this.odeljenje != null) {
                st.setLong(2, this.odeljenje.getId());
            }
            ResultSet rs = st.executeQuery();
            rs.next();
            return new Date(rs.getDate("datum").getTime());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getPoslednjiPopisId(boolean dodatno) {
        Connection conn = this.server.getConnection();
        String query = "SELECT P.ID  FROM  popis p \r\nWHERE CAST( p.datum  as DATE) BETWEEN CAST(? AS Date) AND  CAST(NOW() AS DATE)\r\nAND p.sravnjenje =1 AND p.crno =?   \r\n";
        if (this.odeljenje != null) {
            query = query + " and p.ODELJENJE_ID = ?";
        }
        query = query + " ORDER BY p.id DESC LIMIT 1 ";
        try {
            PreparedStatement st = conn.prepareStatement(query);
            st.setDate(1, new java.sql.Date(this.odDatuma.getTime()));
            st.setBoolean(2, dodatno);
            if (this.odeljenje != null) {
                st.setLong(3, this.odeljenje.getId());
            }
            System.out.println(st);
            ResultSet rs = st.executeQuery();
            rs.next();
            return rs.getLong("id");
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void setValidDate(DateInput2 datum) {
        datum.setResult(this.getDatumPoslednjegPopisa());
    }
}

