/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.restoran;

import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.BMTerminalSettings;
import com.dev63.restoran.RestoranServer;
import com.dev63.restoran.constants.StatLogic;
import com.dev63.restoran.lang.Language;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Cenovnik;
import com.dev63.restoran.model.JedMere;
import com.dev63.restoran.model.MeniPromet;
import com.dev63.restoran.model.NacinPlacanja;
import com.dev63.restoran.model.Option;
import com.dev63.restoran.model.OptionBO;
import com.dev63.restoran.model.Popust;
import com.dev63.restoran.model.Racun;
import com.dev63.restoran.model.Setting;
import com.dev63.restoran.model.StavkaRacuna;
import com.dev63.restoran.model.TrebovanjeStavka;
import com.dev63.restoran.model.Tura;
import com.dev63.restoran.sistem.PoreskaStopa;
import com.dev63.restoran.sistem.PoreskeStope;
import com.dev63.restoran.sistem.PorukaDaNe;
import com.dev63.restoran.swt.components.SWTResourceDisposeListener;
import com.dev63.restoran.swt.resources.FontCache;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Konstante {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy.");
    static SimpleDateFormat dateFormatDdMm = new SimpleDateFormat("dd. MM.");
    static SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
    static SimpleDateFormat fullTimeFormat = new SimpleDateFormat("HH:mm:ss");
    static DecimalFormat df4 = new DecimalFormat("#.####");
    static DecimalFormat df14 = new DecimalFormat("#.####");
    static DecimalFormat df2 = new DecimalFormat("#.##");
    static DecimalFormat df1 = new DecimalFormat("#");
    static DecimalFormat df02 = new DecimalFormat("#.##");
    static DecimalFormat df03 = new DecimalFormat("#.###");
    static SimpleDateFormat fullFormat = new SimpleDateFormat("dd.MM.yyyy. HH:mm");
    static SimpleDateFormat sql = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.sss");
    static SimpleDateFormat sqlDate = new SimpleDateFormat("yyyy-MM-dd");
    static Boolean stampa = false;
    static Boolean ok = false;
    public static final double GRUPA_DJ_STOPA = 20.0;
    public static final double GRUPA_E_STOPA = 8.0;
    public static final double GRUPA_A_STOPA = 0.0;
    public static final double GRUPA_G_STOPA = 0.0;
    public static final char GRUPA_DJ_OZNAKA = '\u0110';
    public static final char GRUPA_E_OZNAKA = 'E';
    public static final char GRUPA_A_OZNAKA = 'A';
    public static final char GRUPA_G_OZNAKA = 'G';
    private static int tipStampaca = 1;
    public static ExecutorService executor = Executors.newFixedThreadPool(1);
    public static ExecutorService executorTura = Executors.newFixedThreadPool(1);
    public static ExecutorService PRINT_EXECUTOR = Executors.newFixedThreadPool(1);
    public static ExecutorService ORDER_EXECUTOR = Executors.newFixedThreadPool(1);
    private static ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(1);
    private static volatile Boolean isHappy = null;
    public static Cenovnik aktivniCenovnik = null;
    public static Date vremeOtvaranjaDana = null;
    private static Setting HAPPY_USED_SETTING;
    private static Calendar calendar;

    public static boolean saveSettings() {
        return BMTerminalSettings.saveSettings();
    }

    public static boolean setCurLanguage(String langName) {
        return BMTerminalSettings.setCurLanguage(langName);
    }

    public static Language getCurLanguage() {
        return BMTerminalSettings.getCurLanguage();
    }

    public static Locale getCurLocale() {
        return BMTerminalSettings.getCurLocale();
    }

    public static ExecutorService getExecutorTura() {
        return executorTura;
    }

    public static void setExecutorTura(ExecutorService executorTura) {
        Konstante.executorTura = executorTura;
    }

    public static String getDate(Date date) {
        return dateFormat.format(date);
    }

    public static String getDayMonth(Date date) {
        return dateFormatDdMm.format(date);
    }

    public static String getTime(Date date) {
        return timeFormat.format(date);
    }

    public static String getfullTime(Date date) {
        return fullTimeFormat.format(date);
    }

    public static String getNumber4(Double d) {
        df4.setMinimumFractionDigits(4);
        df4.setMaximumFractionDigits(4);
        if (Double.parseDouble(df4.format(d)) == -0.0) {
            d = 0.0;
        }
        return df4.format(d);
    }

    public static String getNumber2(Double d) {
        df2.setMinimumFractionDigits(2);
        df2.setMaximumFractionDigits(2);
        return df2.format(d);
    }

    public static String getNumber1(Double d) {
        df1.setMinimumFractionDigits(0);
        df1.setMaximumFractionDigits(1);
        return df1.format(d);
    }

    public static String getNumber02(Double d) {
        df02.setMinimumFractionDigits(0);
        df02.setMaximumFractionDigits(2);
        return df02.format(d);
    }

    public static String getNumber03(Double d) {
        df03.setMinimumFractionDigits(0);
        df03.setMaximumFractionDigits(3);
        return df03.format(d);
    }

    public static String getNumber14(Double d) {
        df14.setMinimumFractionDigits(1);
        df14.setMaximumFractionDigits(4);
        return df14.format(d);
    }

    public static String getFullFormat(Date d) {
        return fullFormat.format(d);
    }

    public static String getSQLFormat(Date d) {
        return sql.format(d);
    }

    public static String getSQLDateFormat(Date d) {
        return sqlDate.format(d);
    }

    public static Font getFont(Display display, int size, int stile) {
        int style;
        String fontName = "Arial";
        Font font = null;
        switch (stile) {
            case 0: {
                style = 0;
                break;
            }
            case 1: {
                style = 1;
                break;
            }
            case 2: {
                style = 2;
                break;
            }
            case 3: {
                style = 3;
                break;
            }
            default: {
                style = 0;
            }
        }
        font = FontCache.getFont(fontName, size, style);
        return font;
    }

    public static boolean isHappyHour(final RestoranServer server) {
        boolean used = HAPPY_USED_SETTING.booleanValue();
        if (!used) {
            return false;
        }
        Runnable happyChecker = new Runnable(){

            @Override
            public void run() {
                isHappy = false;
                Calendar cal = Calendar.getInstance();
                for (Popust happy : server.getHH()) {
                    server.getBase().refresh((Object)happy);
                    Calendar calOd = Calendar.getInstance();
                    Calendar calDo = Calendar.getInstance();
                    calOd.set(7, happy.getDanOd());
                    calOd.set(11, happy.getSatOd());
                    calOd.set(12, happy.getMinOd());
                    calOd.set(13, 0);
                    calDo.set(7, happy.getDanDo());
                    calDo.set(11, happy.getSatDo());
                    calDo.set(12, happy.getMinDo());
                    calDo.set(13, 0);
                    if (calOd.after(calDo)) {
                        if (cal.after(calOd)) {
                            calDo.add(6, 7);
                        } else {
                            calOd.add(6, -7);
                        }
                    }
                    if (!cal.after(calOd) || !cal.before(calDo)) continue;
                    isHappy = true;
                }
            }
        };
        if (isHappy == null) {
            happyChecker.run();
            Calendar firstStart = Calendar.getInstance();
            int minToAdd = 15 - firstStart.get(12) % 15;
            firstStart.add(12, minToAdd);
            firstStart.set(13, 1);
            ScheduledFuture<?> scheduledFuture = scheduledExecutor.scheduleAtFixedRate(happyChecker, firstStart.getTimeInMillis() - System.currentTimeMillis(), 60000L, TimeUnit.MILLISECONDS);
        }
        return isHappy;
    }

    public static void getPorukaPrijavaZaposlenih(Shell shellica, String poruka) {
        boolean newShell = false;
        Shell shell = shellica;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (shell == null) {
            if (Display.getCurrent().getShells().length > 0) {
                shell = Display.getCurrent().getShells()[0];
            } else if (Display.getCurrent() != null) {
                shell = new Shell(Display.getCurrent());
                newShell = true;
            } else {
                shell = new Shell(Display.getDefault());
                newShell = true;
            }
        }
        ResourceBundle barmasterText = Konstante.getBundle();
        Shell dark = new Shell(shell, 32768);
        dark.setBounds(shell.getDisplay().getPrimaryMonitor().getBounds());
        dark.setAlpha(128);
        dark.setBackground(shell.getDisplay().getSystemColor(2));
        final Shell shell2 = new Shell(dark, 32768);
        if (newShell) {
            final Shell[] ns = new Shell[]{shell};
            shell2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ns[0] != null && !ns[0].isDisposed()) {
                        ns[0].dispose();
                    }
                }
            });
        }
        Rectangle bounds = shell2.getDisplay().getPrimaryMonitor().getBounds();
        int w = 700;
        int h = 300;
        shell2.setSize(w, h);
        shell2.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
        shell2.setText(String.format(barmasterText.getString("TEXT_PRIJAVA_ZAPOSLENIH"), new Object[0]));
        shell2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Color red = shell.getDisplay().getSystemColor(3);
        Label l1 = new Label((Composite)shell2, 0);
        l1.setText(String.format(barmasterText.getString("TEXT_PRIJAVA_ZAPOSLENIH"), new Object[0]));
        l1.setFont(FontCache.getFont("Klavika Md", 14, 1));
        l1.setForeground(red);
        l1.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Label text = new Label((Composite)shell2, 64);
        text.setText(poruka);
        text.setFont(FontCache.getFont("Klavika Md", 14, 1));
        text.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 0x1000000;
        data.heightHint = 80;
        data.widthHint = 80;
        data.verticalIndent = 30;
        Button b = new Button((Composite)shell2, 8);
        b.setLayoutData((Object)data);
        b.setText(String.format(barmasterText.getString("TEXT_OK"), new Object[0]));
        b.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                shell2.close();
            }
        });
        dark.open();
        shell2.open();
        b.forceFocus();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        dark.close();
    }

    public static void getPoruka(Shell shellica, String poruka) {
        boolean newShell = false;
        Shell shell = shellica;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (shell == null) {
            if (Display.getCurrent().getShells().length > 0) {
                shell = Display.getCurrent().getShells()[0];
            } else if (Display.getCurrent() != null) {
                shell = new Shell(Display.getCurrent());
                newShell = true;
            } else {
                shell = new Shell(Display.getDefault());
                newShell = true;
            }
        }
        ResourceBundle barmasterText = Konstante.getBundle();
        Shell dark = new Shell(shell, 32768);
        dark.setBounds(shell.getDisplay().getPrimaryMonitor().getBounds());
        dark.setAlpha(128);
        dark.setBackground(shell.getDisplay().getSystemColor(2));
        final Shell shell2 = new Shell(dark, 32768);
        if (newShell) {
            final Shell[] ns = new Shell[]{shell};
            shell2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ns[0] != null && !ns[0].isDisposed()) {
                        ns[0].dispose();
                    }
                }
            });
        }
        Rectangle bounds = shell2.getDisplay().getPrimaryMonitor().getBounds();
        int w = 700;
        int h = 300;
        shell2.setSize(w, h);
        shell2.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
        shell2.setText(String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]));
        shell2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Color red = shell.getDisplay().getSystemColor(3);
        Label l1 = new Label((Composite)shell2, 0);
        l1.setText(String.format(barmasterText.getString("TEXT_GRESKA"), new Object[0]));
        l1.setFont(FontCache.getFont("Arial", 12, 1));
        l1.setForeground(red);
        l1.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Label text = new Label((Composite)shell2, 64);
        text.setText(poruka);
        text.setFont(FontCache.getFont("Arial", 12, 1));
        text.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 0x1000000;
        data.heightHint = 80;
        data.widthHint = 80;
        data.verticalIndent = 30;
        Button b = new Button((Composite)shell2, 8);
        b.setLayoutData((Object)data);
        b.setText(String.format(barmasterText.getString("TEXT_OK"), new Object[0]));
        b.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                shell2.close();
            }
        });
        dark.open();
        shell2.open();
        b.forceFocus();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
        dark.close();
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static ResourceBundle getBundle() {
        return ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
    }

    public static void getPoruka3(Shell shellica, String poruka) {
        Shell shell = shellica;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (shell == null) {
            shell = Display.getCurrent().getShells().length > 0 ? Display.getCurrent().getShells()[0] : (Display.getCurrent() != null ? new Shell(Display.getCurrent()) : new Shell(Display.getDefault()));
        }
        final Shell shell2 = new Shell(shell, 32768);
        Rectangle bounds = shell2.getDisplay().getPrimaryMonitor().getBounds();
        int w = 700;
        int h = 300;
        shell2.setSize(w, h);
        shell2.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
        shell2.setText(String.format(Konstante.getBundle().getString("TEXT_OBAVESTENJE"), new Object[0]));
        shell2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Color blue = shell.getDisplay().getSystemColor(6);
        Label l1 = new Label((Composite)shell2, 0);
        l1.setText(String.format(Konstante.getBundle().getString("TEXT_OBAVESTENJE"), new Object[0]));
        l1.setFont(Konstante.getFont(shell.getDisplay(), 12, 1));
        l1.setForeground(blue);
        l1.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Label text = new Label((Composite)shell2, 64);
        text.setText(poruka);
        text.setFont(Konstante.getFont(shell.getDisplay(), 12, 1));
        text.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 0x1000000;
        data.heightHint = 80;
        data.widthHint = 80;
        data.verticalIndent = 30;
        Button b = new Button((Composite)shell2, 8);
        b.setLayoutData((Object)data);
        b.setText(String.format(Konstante.getBundle().getString("TEXT_OK"), new Object[0]));
        b.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                shell2.close();
            }
        });
        shell2.open();
        while (!shell2.isDisposed()) {
            if (shell2.getDisplay().readAndDispatch()) continue;
            shell2.getDisplay().sleep();
        }
    }

    public static Shell getPoruka2(Shell shellica) {
        boolean newShell = false;
        Shell shell = shellica;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (shell == null) {
            if (Display.getCurrent().getShells().length > 0) {
                shell = Display.getCurrent().getShells()[0];
            } else if (Display.getCurrent() != null) {
                shell = new Shell(Display.getCurrent());
                newShell = true;
            } else {
                shell = new Shell(Display.getDefault());
                newShell = true;
            }
        }
        ResourceBundle barmasterText = ResourceBundle.getBundle("barmasterText", Konstante.getCurLocale());
        Shell shell2 = new Shell(shell, 32768);
        if (newShell) {
            final Shell[] ns = new Shell[]{shell};
            shell2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ns[0] != null && !ns[0].isDisposed()) {
                        ns[0].dispose();
                    }
                }
            });
        }
        Rectangle bounds = shell2.getDisplay().getPrimaryMonitor().getBounds();
        int w = 500;
        int h = 300;
        shell2.setSize(w, h);
        shell2.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
        shell2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Label text = new Label((Composite)shell2, 64);
        text.setAlignment(0x1000000);
        text.setText(String.format(barmasterText.getString("TEXT_MOLIMO_SACEKAJTE"), new Object[0]) + "...");
        text.setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
        text.setLayoutData((Object)data);
        shell2.open();
        return shell2;
    }

    public static Shell getPoruka2(Shell shellica, String poruka) {
        boolean newShell = false;
        Shell shell = shellica;
        if (shell == null || shell.isDisposed()) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (shell == null) {
            if (Display.getCurrent().getShells().length > 0) {
                shell = Display.getCurrent().getShells()[0];
            } else if (Display.getCurrent() != null) {
                shell = new Shell(Display.getCurrent());
                newShell = true;
            } else {
                shell = new Shell(Display.getDefault());
                newShell = true;
            }
        }
        Shell shell2 = new Shell(shell, 32768);
        if (newShell) {
            final Shell[] ns = new Shell[]{shell};
            shell2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (ns[0] != null && !ns[0].isDisposed()) {
                        ns[0].dispose();
                    }
                }
            });
        }
        Rectangle bounds = shell2.getDisplay().getPrimaryMonitor().getBounds();
        int w = 500;
        int h = 300;
        shell2.setSize(w, h);
        shell2.setLocation(bounds.width / 2 - w / 2, bounds.height / 2 - h / 2);
        shell2.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        data = new GridData(768);
        data.horizontalAlignment = 0x1000000;
        data.verticalIndent = 30;
        Label text = new Label((Composite)shell2, 64);
        text.setAlignment(0x1000000);
        text.setText(poruka);
        text.setFont(Konstante.getFont(shell2.getDisplay(), 12, 1));
        text.setLayoutData((Object)data);
        shell2.open();
        return shell2;
    }

    public static PorukaDaNe getPorukaDaNe(Shell shell, String poruka) {
        PorukaDaNe porukaDaNe = new PorukaDaNe(shell, poruka);
        return porukaDaNe;
    }

    public static void endShell(Shell s) {
        s.open();
        while (!s.isDisposed()) {
            if (s.getDisplay().readAndDispatch()) continue;
            s.getDisplay().sleep();
        }
    }

    public static void centerShellOnDisplay(Shell s) {
        Rectangle sBounds = s.getBounds();
        Rectangle dBounds = s.getDisplay().getPrimaryMonitor().getBounds();
        Point p = new Point((dBounds.width - sBounds.width) / 2, (dBounds.height - sBounds.height) / 2);
        s.setLocation(p);
    }

    public static Shell makeShell(Shell shell, String title) {
        shell.setText(title);
        shell.setBackground(shell.getDisplay().getSystemColor(22));
        Monitor primary = shell.getDisplay().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
        return shell;
    }

    public static Boolean isEmptyZD(Date date1, Date date2, RestoranServer server) {
        return server.isEmptyDateZD(date1, date2);
    }

    public static Date getPocetniDatum(Date date, RestoranServer server) {
        boolean sata24;
        Setting opcija = server.getSetting(Option.RADNO_VREME);
        boolean bl = sata24 = opcija == null ? false : opcija.booleanValue();
        if (vremeOtvaranjaDana == null || (sata24 ? date.before(vremeOtvaranjaDana) : date.compareTo(Konstante.getOnlyDate(vremeOtvaranjaDana)) <= 0)) {
            return server.getPocetni(date);
        }
        return vremeOtvaranjaDana;
    }

    public static Date getKrajnjiDatum(Date date, RestoranServer server) {
        return server.getKrajnji(date);
    }

    public static Date getDatumKartica(Date date, RestoranServer server, int sekunde) {
        Date a = server.getPocetni(date);
        Date d = a == null || a.getTime() < date.getTime() ? date : a;
        Calendar datum = Calendar.getInstance();
        datum.setTime(d);
        Calendar reference = Calendar.getInstance();
        reference.set(5, datum.get(5));
        reference.set(2, datum.get(2));
        reference.set(1, datum.get(1));
        reference.set(11, datum.get(11));
        reference.set(12, datum.get(12));
        reference.set(13, sekunde);
        return reference.getTime();
    }

    public static Date getOnlyDate(Date date) {
        Calendar reference = Calendar.getInstance();
        reference.setTime(date);
        reference.set(11, 0);
        reference.set(12, 0);
        reference.set(13, 0);
        reference.set(14, 0);
        return reference.getTime();
    }

    public static Date dateAfter(Date date) {
        Calendar reference = Calendar.getInstance();
        reference.setTime(date);
        reference.set(6, reference.get(6) + 1);
        return reference.getTime();
    }

    public static Date dateBefore(Date date) {
        Calendar reference = Calendar.getInstance();
        reference.setTime(date);
        reference.add(6, -1);
        return reference.getTime();
    }

    public static Date getDateIzvestaji(StavkaRacuna sr) {
        Date date;
        try {
            date = sr.getRacun().getDatum();
        }
        catch (Exception e) {
            date = sr.getTura().getDatum();
        }
        return date;
    }

    public static double getPdvPoPG(PoreskaGrupa pg) {
        PoreskaStopa ps = PoreskeStope.getPoreskaStopa(pg);
        return ps.getStopa() / 100.0;
    }

    public static double getKontraPorez(double porez) {
        return 1.0 / (1.0 + porez) * porez;
    }

    public static double getKontraPdvPoPG(PoreskaGrupa pg) {
        double stopa = Konstante.getPdvPoPG(pg);
        return Konstante.getKontraPorez(stopa);
    }

    public static String getNazivStola(int broj, RestoranServer server) {
        String ret = server.getNazivStola(broj);
        if (ret != null) {
            return ret;
        }
        return String.valueOf(broj);
    }

    public static double getVrednostTrebovanja(List<TrebovanjeStavka> stavke) {
        double d = 0.0;
        for (TrebovanjeStavka ts : stavke) {
            d += ts.getVrednost().doubleValue();
        }
        return d;
    }

    public static NacinPlacanja getNacin(String s) {
        for (NacinPlacanja np : NacinPlacanja.values()) {
            if (!np.name().equals(s)) continue;
            return np;
        }
        return null;
    }

    public static Double decimals2(double d) {
        return StatLogic.round(d, 2);
    }

    public static double getPorezFromBruto(double brutto, PoreskaGrupa pg) {
        return brutto - Konstante.getOsnovicaFromBruto(pg, brutto);
    }

    public static double getOsnovicaFromBruto(PoreskaGrupa pg, double bruto) {
        double stopa = Konstante.getPGStopaProcenat(pg);
        return bruto / (1.0 + stopa / 100.0);
    }

    public static double getOsnovicaFromBruto(PoreskaGrupa pg, double bruto, Date datum) {
        double stopa = Konstante.getPGStopaProcenat(pg, datum);
        return bruto / (1.0 + stopa / 100.0);
    }

    public static double getBrutoFromOsnovica(PoreskaGrupa pg, double osnovica) {
        double stopa = Konstante.getPGStopaProcenat(pg);
        return osnovica * (1.0 + stopa / 100.0);
    }

    public static BigDecimal getBrutoFromOsnovica(PoreskaGrupa pg, BigDecimal osnovica) {
        double stopa = Konstante.getPGStopaProcenat(pg);
        return osnovica.multiply(BigDecimal.valueOf(1.0 + stopa / 100.0));
    }

    public static double getBrutoFromOsnovica(PoreskaGrupa pg, double osnovica, Date datum) {
        double stopa = Konstante.getPGStopaProcenat(pg, datum);
        return osnovica * (1.0 + stopa / 100.0);
    }

    public static double getPGStopaProcenat(PoreskaGrupa pg) {
        double stopa = PoreskeStope.getPoreskaStopa(pg).getStopa();
        return stopa;
    }

    public static BigDecimal getPGStopaProcenatBD(PoreskaGrupa pg) {
        BigDecimal stopa = PoreskeStope.getPoreskaStopa(pg).getStopaBD();
        return stopa;
    }

    public static double getPGStopaProcenat(PoreskaGrupa pg, Date datum) {
        double stopa = PoreskeStope.getPoreskaStopa(pg, datum).getStopa();
        return stopa;
    }

    public static int getPGStopaProcenatCeoBroj(PoreskaGrupa pg) {
        int stopa = (int)Math.round(PoreskeStope.getPoreskaStopa(pg).getStopa());
        return stopa;
    }

    public static String getPGNaziv(PoreskaGrupa pg) {
        String stopa = PoreskeStope.getPoreskaStopa(pg).getNaziv();
        return stopa;
    }

    public static char getPGOznaka(PoreskaGrupa pg) {
        return PoreskeStope.getPoreskaStopa(pg).getOznaka();
    }

    public static Racun createStavkaFromMeniPromet(MeniPromet mp, Racun r, Integer sledeciPluMenija, PoreskaGrupa pg) {
        Artikal art = new Artikal();
        art.setName(mp.getNaziv());
        art.setSkrNaziv(mp.getNaziv());
        art.setCena(mp.getCena());
        art.setDozvoljenPopust(true);
        art.setPoreskaGrupa(pg);
        art.setJedinicaMere(JedMere.KOM.name());
        art.setId((long)sledeciPluMenija);
        StavkaRacuna sr = new StavkaRacuna();
        sr.setArtikal(art);
        sr.setCena(mp.getCena());
        sr.setKolicina(mp.getKolicina());
        sr.setBrojStola(r.getBrojStola());
        sr.setNaziv(mp.getNaziv());
        sr.setRacun(r);
        Tura t = new Tura();
        t.setBrojStola(r.getBrojStola());
        t.setDatum(mp.getDatum());
        t.setBrojTure(0);
        t.setPocetak(new Timestamp(0L));
        t.setKraj(new Timestamp(0L));
        t.setRacun(r);
        t.setStavke(new LinkedList<StavkaRacuna>());
        sr.setTura(t);
        t.getStavke().add(sr);
        r.setTure(new LinkedList<Tura>());
        r.getTure().add(t);
        r.setStavke1(new LinkedList<StavkaRacuna>());
        r.getStavke1().add(sr);
        r.setPopust(0.0);
        return r;
    }

    public static String getMagacinName() {
        return String.format(Konstante.getBundle().getString("OD_MAGACIN"), new Object[0]);
    }

    public static String getHotelskiGostGrupaName() {
        return String.format(Konstante.getBundle().getString("SGG_HOTELSKI_GOST"), new Object[0]);
    }

    public static String getNepozeljniGostGrupaName() {
        return String.format(Konstante.getBundle().getString("SGG_NEPOZELJNI_GOST"), new Object[0]);
    }

    public static void addImageDispListener(Control b) {
        if (b != null && !b.isDisposed() && b instanceof Button) {
            Button button = (Button)b;
            button.addDisposeListener((DisposeListener)new SWTResourceDisposeListener((Resource)button.getImage()));
        }
    }

    public static String getFontDir() {
        String systemRoot = System.getenv().get("SystemRoot");
        String fs = System.getProperty("file.separator");
        return systemRoot + fs + "Fonts" + fs;
    }

    public static String getServicePassword() {
        return "928374";
    }

    public static int getTipStampaca() {
        try {
            tipStampaca = BMTerminalSettings.getSetting(OptionBO.FISKALNI_PRINTER).intValue();
            return tipStampaca;
        }
        catch (Exception ex) {
            Logger.getLogger(Konstante.class.getName()).log(Level.WARNING, "Greska kod citanja tipa stampaca: " + ex.getMessage(), ex);
            return tipStampaca;
        }
    }

    public static void setTipStampaca(int aTipStampaca) {
        tipStampaca = aTipStampaca;
    }

    public static Date getYesterdayDate(Date d) {
        calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    public static Date getTomorrowDate(Date d) {
        calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getDatefromString(String format, String dateStr) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = formatter.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(date);
        return date;
    }

    public static String getDateForJson(String format, Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String result = formatter.format(date);
        System.out.println(result);
        return result;
    }

    public static void setDateOnDTWidget(DateTime dt, String input, String spliter) {
        if (!input.equals("") || !spliter.equals("")) {
            String[] inputArr = input.split(spliter);
            dt.setYear(Integer.parseInt(inputArr[0]));
            dt.setMonth(Integer.parseInt(inputArr[1]) - 1);
            dt.setDay(Integer.parseInt(inputArr[2]));
        }
    }

    public static void setTimeOnDTWidget(DateTime dt, String input, String spliter) {
        if (!input.equals("") || !spliter.equals("")) {
            String[] inputArr = input.split(spliter);
            dt.setHours(Integer.parseInt(inputArr[0]));
            dt.setMinutes(Integer.parseInt(inputArr[1]));
            dt.setSeconds(Integer.parseInt(inputArr[2].replace(".0", "")));
        }
    }

    public static Date readDatefromWidgets(DateTime dtDate, DateTime dtTime) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, dtDate.getYear());
        cal.set(2, dtDate.getMonth());
        cal.set(5, dtDate.getDay());
        cal.set(11, dtTime.getHours());
        cal.set(12, dtTime.getMinutes());
        cal.set(13, dtTime.getSeconds());
        Date date = cal.getTime();
        return date;
    }

    public static void prikaziMessageBox(Shell shell, String poruka) {
        int style = 34;
        MessageBox dia = new MessageBox(shell, style);
        dia.setText("Poruka");
        dia.setMessage(poruka);
        dia.open();
    }

    public static int[] OsDodParam(boolean isBelo, boolean isCrno) {
        int[] params = new int[2];
        if (isBelo && !isCrno) {
            params[0] = 0;
            params[1] = -1;
            return params;
        }
        if (!isBelo && isCrno) {
            params[0] = 1;
            params[1] = -1;
            return params;
        }
        if (isBelo && isCrno) {
            params[0] = 0;
            params[1] = 1;
            return params;
        }
        return null;
    }
}

