/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.vafada.swtcalendar;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.vafada.swtcalendar.SWTCalendarDialog;
import com.dev63.hotel.vafada.swtcalendar.SWTCalendarEvent;
import com.dev63.hotel.vafada.swtcalendar.SWTCalendarListener;
import com.dev63.restoran.parts.DateInput2;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogDemo {
    private static DateInput2 kartica;
    static Shell shell;
    private static Font font;

    public static void main(String[] args) {
        Display display = new Display();
        shell = new Shell(display);
        SWTContainer owner = new SWTContainer((Composite)shell);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        font = new Font((Device)shell.getDisplay(), "Arial", 18, 0);
        kartica = new DateInput2(owner, "Kartica", true, null);
        kartica.getControl().addKeyListener((KeyListener)new RestAdapter(font));
        kartica.getControl().addMouseListener((MouseListener)new FillInAdapter(kartica, font));
        shell.open();
        shell.pack();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (font != null && !font.isDisposed()) {
            font.dispose();
        }
        display.dispose();
    }

    private static class FillInAdapter
    extends MouseAdapter {
        private DateInput2 input;
        private Font font;

        public FillInAdapter(DateInput2 input) {
            this.input = input;
        }

        public FillInAdapter(DateInput2 input, Font font) {
            this.input = input;
            this.font = font;
        }

        public void mouseDown(MouseEvent e) {
            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy");
            final SWTCalendarDialog cal = new SWTCalendarDialog(shell.getDisplay());
            if (this.font != null) {
                cal.setFont(this.font);
            }
            cal.addDateChangedListener(new SWTCalendarListener(){

                @Override
                public void dateChanged(SWTCalendarEvent calendarEvent) {
                    kartica.setResult(calendarEvent.getCalendar().getTime());
                    cal.close();
                }
            });
            if (kartica.getText() != null && kartica.getText().length() > 0) {
                try {
                    Date d = formatter.parse(kartica.getText());
                    cal.setDate(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            cal.open();
        }
    }

    private static class RestAdapter
    extends KeyAdapter {
        private Font font;

        public RestAdapter() {
        }

        public RestAdapter(Font font) {
            this.font = font;
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 13) {
                SimpleDateFormat formatter = new SimpleDateFormat("MMM dd yyyy");
                SWTCalendarDialog cal = new SWTCalendarDialog(shell.getDisplay());
                if (this.font != null) {
                    cal.setFont(this.font);
                }
                cal.addDateChangedListener(new SWTCalendarListener(){

                    @Override
                    public void dateChanged(SWTCalendarEvent calendarEvent) {
                        kartica.setResult(calendarEvent.getCalendar().getTime());
                    }
                });
                if (kartica.getText() != null && kartica.getText().length() > 0) {
                    try {
                        Date d = formatter.parse(kartica.getText());
                        cal.setDate(d);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                cal.open();
            }
        }
    }
}

