/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.layout;

import com.dev63.hotel.swt.swing2swt.layout.AWTLayout;
import java.awt.ComponentOrientation;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FlowLayout
extends AWTLayout {
    public static final int CENTER = 1;
    public static final int LEADING = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int TRAILING = 5;
    private int hgap;
    private int vgap;
    private int align;
    private Vector currentLine = new Vector();

    public FlowLayout() {
        this(1);
    }

    public FlowLayout(int align) {
        this(align, 5, 5);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        if (align == 2 || align == 5) {
            ComponentOrientation orientation = ComponentOrientation.getOrientation(Locale.getDefault());
            align = align == 2 ? (orientation.isLeftToRight() ? 3 : 4) : (orientation.isLeftToRight() ? 4 : 3);
        }
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Point size = new Point(0, 0);
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Point childSize = this.getPreferredSize(children[i], wHint, hHint, flushCache);
            size.x += childSize.x;
            size.y = Math.max(childSize.y, size.y);
        }
        if (children.length > 0) {
            size.x += (children.length + 1) * this.hgap;
            size.y += this.vgap;
        }
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control[] children = composite.getChildren();
        int x = clientArea.x + this.hgap;
        int y = clientArea.y + this.vgap;
        int lineWidth = this.hgap;
        int lineHeight = 0;
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Point childSize = this.getPreferredSize(child, -1, -1, flushCache);
            if (lineWidth + childSize.x > clientArea.width && this.currentLine.size() > 0) {
                this.alignCurrentLine(clientArea, lineWidth, lineHeight);
                this.currentLine.clear();
                x = clientArea.x + this.hgap;
                y += lineHeight + this.vgap;
                lineHeight = this.hgap;
                lineWidth = 0;
            }
            child.setBounds(x, y, childSize.x, childSize.y);
            this.currentLine.add(child);
            lineWidth += childSize.x + this.hgap;
            lineHeight = Math.max(lineHeight, childSize.y);
            x += childSize.x + this.hgap;
        }
        this.alignCurrentLine(clientArea, lineWidth, lineHeight);
        this.currentLine.clear();
    }

    private void alignCurrentLine(Rectangle clientArea, int lineWidth, int lineHeight) {
        for (int j = 0; j < this.currentLine.size(); ++j) {
            Control c = (Control)this.currentLine.get(j);
            Rectangle bounds = c.getBounds();
            int x = bounds.x;
            if (this.align == 1) {
                x += (clientArea.width - lineWidth) / 2;
            } else if (this.align == 4) {
                x += clientArea.width - lineWidth;
            }
            int y = bounds.y + (lineHeight - bounds.height) / 2;
            c.setLocation(x, y);
        }
    }
}

