/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.layout;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.layout.AWTLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CardLayout
extends AWTLayout {
    private int hgap;
    private int vgap;
    int currentIndex;

    public CardLayout() {
        this(0, 0);
    }

    public CardLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void first(SWTContainer container) {
        this.setCurrentIndex(container, 0);
    }

    public void last(SWTContainer container) {
        this.setCurrentIndex(container, container.getComposite().getChildren().length - 1);
    }

    public void next(SWTContainer container) {
        this.setCurrentIndex(container, (this.currentIndex + 1) % container.getComposite().getChildren().length);
    }

    public void previous(SWTContainer container) {
        int index = this.currentIndex - 1;
        if (index < 0) {
            index = container.getComposite().getChildren().length - 1;
        }
        this.setCurrentIndex(container, index);
    }

    public void show(SWTContainer container, String name) {
        Control[] children = container.getComposite().getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!name.equals(children[i].getLayoutData())) continue;
            this.setCurrentIndex(container, i);
            return;
        }
    }

    private void setCurrentIndex(SWTContainer container, int index) {
        this.currentIndex = index;
        container.getComposite().layout();
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        Point size = new Point(0, 0);
        for (int i = 0; i < children.length; ++i) {
            Point childSize = this.getPreferredSize(children[i], -1, -1, flushCache);
            if (childSize.x > size.x) {
                size.x = childSize.x;
            }
            if (childSize.y <= size.y) continue;
            size.y = childSize.y;
        }
        return size;
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle clientArea = composite.getClientArea();
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (i == this.currentIndex) {
                children[i].setBounds(clientArea.x + this.hgap, clientArea.y + this.vgap, clientArea.width - 2 * this.hgap, clientArea.height - 2 * this.vgap);
                children[i].setVisible(true);
                continue;
            }
            children[i].setVisible(false);
        }
    }
}

