/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.awt.Dimension;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTViewport
extends SWTContainer {
    public SWTViewport(ScrolledComposite scrolledComposite) {
        super((Composite)scrolledComposite);
    }

    public SWTViewport(SWTContainer parent) {
        this(new ScrolledComposite(parent.getComposite(), 0));
    }

    public ScrolledComposite getScrolledComposite() {
        return (ScrolledComposite)this.getControl();
    }

    public Point getViewPosition() {
        return this.getScrolledComposite().getOrigin();
    }

    public Rectangle getViewRect() {
        Point origin = this.getScrolledComposite().getOrigin();
        Rectangle clientArea = this.getScrolledComposite().getClientArea();
        return new Rectangle(origin.x, origin.y, clientArea.width, clientArea.height);
    }

    public Dimension getViewSize() {
        Point size = this.getScrolledComposite().getContent().getSize();
        return new Dimension(size.x, size.y);
    }

    public void scrollRectToVisible(Rectangle rect) {
        this.getScrolledComposite().setOrigin(rect.x, rect.y);
    }

    public void setViewPosition(Point p) {
        this.getScrolledComposite().setOrigin(p);
    }

    public void setViewSize(Dimension newSize) {
        this.getScrolledComposite().setMinSize(newSize.width, newSize.height);
    }

    public void setView(SWTComponent view) {
        Control content = view.getControl();
        ScrolledComposite scrolledComposite = this.getScrolledComposite();
        scrolledComposite.setContent(content);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Dimension preferredSize = view.getPreferredSize();
        scrolledComposite.setMinSize(preferredSize.width, preferredSize.height);
        this.setPreferredSize(preferredSize);
    }
}

