/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTCellRenderer;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SWTTree
extends SWTComponent
implements SelectionListener,
TreeSelectionListener,
ITreeViewerListener,
RowMapper {
    private TreeViewer treeViewer;
    private TreeModel model;
    private TreeSelectionModel selectionModel;
    private SWTCellRenderer renderer;
    private boolean rootVisible = true;
    private transient boolean ignoreSelectionChange = false;

    public SWTTree(Tree tree) {
        super((Control)tree);
        tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new TreeModelContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeModelLabelProvider());
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.setSelectionModel(new DefaultTreeSelectionModel());
    }

    public SWTTree(SWTContainer parent) {
        this(parent, new DefaultMutableTreeNode("root"));
    }

    public SWTTree(SWTContainer parent, Hashtable values) {
        this(parent, SWTTree.createTreeModel(values));
    }

    public SWTTree(SWTContainer parent, Object[] values) {
        this(parent, SWTTree.createTreeModel(values));
    }

    public SWTTree(SWTContainer parent, TreeModel model) {
        this(new Tree(parent.getComposite(), 2818));
        this.setModel(model);
    }

    public SWTTree(SWTContainer parent, TreeNode root) {
        this(parent, new DefaultTreeModel(root));
    }

    public SWTTree(SWTContainer parent, TreeNode root, boolean asksAllowsChildren) {
        this(parent, new DefaultTreeModel(root, asksAllowsChildren));
    }

    public SWTTree(SWTContainer parent, Vector values) {
        this(parent, SWTTree.createTreeModel(values));
    }

    private static TreeModel createTreeModel(Object values) {
        DefaultMutableTreeNode root;
        block4: {
            block5: {
                block3: {
                    root = new DefaultMutableTreeNode("root");
                    if (!(values instanceof Object[])) break block3;
                    Object[] array = (Object[])values;
                    for (int i = 0; i < array.length; ++i) {
                        root.add(new DefaultMutableTreeNode(array[i]));
                    }
                    break block4;
                }
                if (!(values instanceof Vector)) break block5;
                Vector v = (Vector)values;
                for (int i = 0; i < v.size(); ++i) {
                    root.add(new DefaultMutableTreeNode(v.get(i)));
                }
                break block4;
            }
            if (!(values instanceof Hashtable)) break block4;
            Hashtable table = (Hashtable)values;
            Enumeration keys = table.keys();
            while (keys.hasMoreElements()) {
                root.add(new DefaultMutableTreeNode(table.get(keys.nextElement())));
            }
        }
        return new DefaultTreeModel(root);
    }

    public final Tree getTree() {
        return (Tree)this.getControl();
    }

    public final TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public final void addSelectionInterval(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index0;
            index0 = index1;
            index1 = tmp;
        }
        Vector<TreePath> v = new Vector<TreePath>();
        for (int i = index0; i <= index1; ++i) {
            TreePath path = this.getPathForRow(i);
            if (path == null) continue;
            v.add(path);
        }
        TreePath[] paths = new TreePath[v.size()];
        v.toArray(paths);
        this.addSelectionPaths(paths);
    }

    public final void addSelectionPath(TreePath path) {
        this.selectionModel.addSelectionPath(path);
    }

    public final void addSelectionPaths(TreePath[] paths) {
        this.selectionModel.addSelectionPaths(paths);
    }

    public final void addSelectionRow(int row) {
        this.addSelectionRows(new int[]{row});
    }

    public final void addSelectionRows(int[] rows) {
        Vector<TreePath> v = new Vector<TreePath>();
        for (int i = 0; i < rows.length; ++i) {
            TreePath path = this.getPathForRow(rows[i]);
            if (path == null) continue;
            v.add(path);
        }
        TreePath[] paths = new TreePath[v.size()];
        v.toArray(paths);
        this.addSelectionPaths(paths);
    }

    public final void clearSelection() {
        this.getTree().deselectAll();
    }

    public final void collapsePath(TreePath path) {
        this.collapseRow(this.getRowForPath(path));
    }

    public final void collapseRow(int row) {
        TreeItem treeItem = this.getTreeItemAtRow(row);
        if (treeItem != null) {
            treeItem.setExpanded(false);
        }
    }

    public final void expandPath(TreePath path) {
        this.expandRow(this.getRowForPath(path));
    }

    public final void expandRow(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.treeViewer.setExpandedState(path.getLastPathComponent(), true);
        }
    }

    public final TreePath getAnchorSelectionPath() {
        TreePath[] paths = this.selectionModel.getSelectionPaths();
        if (paths.length == 0) {
            return null;
        }
        return paths[0];
    }

    public final SWTCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public final TreePath getClosestPathForLocation(int x, int y) {
        return this.getPathForLocation(x, y);
    }

    public final int getClosestRowForLocation(int x, int y) {
        return this.getRowForLocation(x, y);
    }

    public final Object getLastSelectedPathComponent() {
        TreePath selectionPath = this.selectionModel.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return selectionPath.getLastPathComponent();
    }

    public final TreePath getLeadSelectionPath() {
        return this.selectionModel.getLeadSelectionPath();
    }

    public final int getLeadSelectionRow() {
        return this.selectionModel.getLeadSelectionRow();
    }

    public final int getMaxSelectionRow() {
        return this.selectionModel.getMaxSelectionRow();
    }

    public final int getMinSelectionRow() {
        return this.selectionModel.getMinSelectionRow();
    }

    public final void setModel(TreeModel model) {
        this.model = model;
        this.treeViewer.setInput((Object)model);
    }

    public final TreeModel getModel() {
        return this.model;
    }

    public final Rectangle getPathBounds(TreePath path) {
        return this.getRowBounds(this.getRowForPath(path));
    }

    public final TreePath getPathForLocation(int x, int y) {
        TreeItem treeItem = this.getTree().getItem(new Point(x, y));
        if (treeItem == null) {
            return null;
        }
        return this.getTreePath(treeItem);
    }

    public final TreePath getPathForRow(int row) {
        TreeItem item = this.getTreeItemAtRow(row);
        if (item == null) {
            return null;
        }
        return this.getTreePath(item);
    }

    public final Rectangle getRowBounds(int row) {
        TreeItem treeItem = this.getTreeItemAtRow(row);
        if (treeItem == null) {
            return null;
        }
        return treeItem.getBounds();
    }

    public final int getRowCount() {
        return this.getTree().getItemCount();
    }

    public final int getRowForLocation(int x, int y) {
        TreeItem treeItem = this.getTree().getItem(new Point(x, y));
        if (treeItem == null) {
            return -1;
        }
        return this.getRowForTreeItem(treeItem);
    }

    public final int getRowForPath(TreePath path) {
        TreeItem[] treeItems = this.getTreeItems();
        for (int i = 0; i < treeItems.length; ++i) {
            if (!this.getTreePath(treeItems[i]).equals(path)) continue;
            return i;
        }
        return -1;
    }

    public final int getRowHeight() {
        return this.getTree().getItemHeight();
    }

    public final int getSelectionCount() {
        return this.getTree().getSelectionCount();
    }

    public final TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public final void setSelectionModel(TreeSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this);
            this.selectionModel.setRowMapper(null);
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            selectionModel.addTreeSelectionListener(this);
            selectionModel.setRowMapper(this);
            if ((this.getTree().getStyle() & 2) != 0) {
                selectionModel.setSelectionMode(4);
            } else {
                selectionModel.setSelectionMode(1);
            }
        }
    }

    public final TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    public final TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    public final int[] getSelectionRows() {
        return this.selectionModel.getSelectionRows();
    }

    public final int getVisibleRowCount() {
        Tree tree = this.getTree();
        return Math.min(this.getTreeItems().length, tree.getClientArea().height / tree.getItemHeight());
    }

    public final boolean isCollapsed(int row) {
        return !this.isExpanded(row);
    }

    public final boolean isCollapsed(TreePath path) {
        return !this.isExpanded(path);
    }

    public final boolean isExpanded(int row) {
        TreeItem treeItem = this.getTreeItemAtRow(row);
        if (treeItem == null) {
            return false;
        }
        return treeItem.getExpanded();
    }

    public final boolean isExpanded(TreePath path) {
        return this.isExpanded(this.getRowForPath(path));
    }

    public final boolean isPathSelected(TreePath path) {
        return this.selectionModel.isPathSelected(path);
    }

    public final boolean isRootVisible() {
        return this.rootVisible;
    }

    public final boolean isRowSelected(int row) {
        return this.selectionModel.isRowSelected(row);
    }

    public final boolean isSelectionEmpty() {
        return this.getTree().getSelectionCount() == 0;
    }

    public final boolean isVisible(TreePath path) {
        TreeItem treeItem = this.getTreeItemForPath(path);
        if (treeItem == null) {
            return false;
        }
        for (treeItem = treeItem.getParentItem(); treeItem != null; treeItem = treeItem.getParentItem()) {
            if (treeItem.getExpanded()) continue;
            return false;
        }
        return true;
    }

    public final void makeVisible(TreePath path) {
        TreeItem treeItem = this.getTreeItemForPath(path);
        if (treeItem == null) {
            return;
        }
        for (treeItem = treeItem.getParentItem(); treeItem != null; treeItem = treeItem.getParentItem()) {
            if (treeItem.getExpanded()) continue;
            treeItem.setExpanded(true);
        }
    }

    public final void removeSelectionInterval(int index0, int index1) {
        if (index0 > index1) {
            int tmp = index0;
            index0 = index1;
            index1 = tmp;
        }
        Vector<TreePath> v = new Vector<TreePath>();
        for (int i = index0; i < index1; ++i) {
            TreePath path = this.getPathForRow(i);
            if (path == null) continue;
            v.add(path);
        }
        TreePath[] paths = new TreePath[v.size()];
        v.toArray(paths);
        this.removeSelectionPaths(paths);
    }

    public final void removeSelectionPath(TreePath path) {
        this.removeSelectionPaths(new TreePath[]{path});
    }

    public final void removeSelectionPaths(TreePath[] paths) {
        int[] rows = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            rows[i] = this.getRowForPath(paths[i]);
        }
        this.removeSelectionRows(rows);
    }

    public final void removeSelectionRow(int row) {
        this.removeSelectionRows(new int[]{row});
    }

    public final void removeSelectionRows(int[] rows) {
        Vector<TreePath> v = new Vector<TreePath>();
        for (int i = 0; i < rows.length; ++i) {
            TreePath path = this.getPathForRow(rows[i]);
            if (path == null) continue;
            v.add(path);
        }
        TreePath[] paths = new TreePath[v.size()];
        v.toArray(paths);
        this.removeSelectionPaths(paths);
    }

    public final void scrollPathToVisible(TreePath path) {
        this.treeViewer.reveal(path.getLastPathComponent());
    }

    public final void scrollRowToVisible(int row) {
        TreeItem item = this.getTreeItemAtRow(row);
        if (item != null) {
            this.treeViewer.reveal(item.getData());
        }
    }

    public final void setCellRenderer(SWTCellRenderer renderer) {
        this.renderer = renderer;
        this.treeViewer.refresh();
    }

    public final void setRootVisible(boolean rootVisible) {
        this.rootVisible = rootVisible;
        this.treeViewer.refresh();
    }

    public final void setSelectionInterval(int index0, int index1) {
        TreeItem[] items;
        if (index0 > index1) {
            int buffer = index0;
            index0 = index1;
            index1 = buffer;
        }
        if (index1 >= (items = this.getTreeItems()).length) {
            index1 = items.length - 1;
        }
        TreeItem[] itemsToSelect = new TreeItem[index1 - index0 + 1];
        for (int i = 0; i <= itemsToSelect.length; ++i) {
            itemsToSelect[i] = items[i + index0];
        }
        this.getTree().setSelection(itemsToSelect);
    }

    public final void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    public final void setSelectionPaths(TreePath[] paths) {
        this.selectionModel.setSelectionPaths(paths);
    }

    public final void setSelectionRow(int row) {
        this.setSelectionRows(new int[row]);
    }

    public final void setSelectionRows(int[] rows) {
        TreeItem[] items = this.getTreeItems();
        Vector<TreeItem> v = new Vector<TreeItem>();
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] >= items.length) continue;
            v.add(items[rows[i]]);
        }
        items = new TreeItem[v.size()];
        v.toArray(items);
        this.getTree().setSelection(items);
    }

    private TreeItem getTreeItemAtRow(int row) {
        if (row < 0) {
            return null;
        }
        TreeItem[] items = this.getTreeItems();
        if (row >= items.length) {
            return null;
        }
        return items[row];
    }

    private TreeItem getTreeItemForPath(TreePath path) {
        return this.getTreeItemAtRow(this.getRowForPath(path));
    }

    private int getRowForTreeItem(TreeItem item) {
        TreeItem[] items = this.getTreeItems();
        for (int i = 0; i < items.length; ++i) {
            if (item != items[i]) continue;
            return i;
        }
        return -1;
    }

    private TreePath getTreePath(TreeItem item) {
        Vector<Object> v = new Vector<Object>();
        do {
            v.add(0, item.getData());
        } while ((item = item.getParentItem()) != null);
        return new TreePath(v.toArray());
    }

    private TreeItem[] getTreeItems() {
        Vector v = new Vector();
        TreeItem[] items = this.getTree().getItems();
        for (int i = 0; i < items.length; ++i) {
            this.searchTreeItems(items[i], v);
        }
        TreeItem[] result = new TreeItem[v.size()];
        v.toArray(result);
        return result;
    }

    private void searchTreeItems(TreeItem parentItem, Vector items) {
        if (parentItem.getData() == null) {
            return;
        }
        items.add(parentItem);
        if (parentItem.getExpanded()) {
            TreeItem[] children = parentItem.getItems();
            for (int i = 0; i < children.length; ++i) {
                this.searchTreeItems(children[i], items);
            }
        }
    }

    @Override
    public int[] getRowsForPaths(TreePath[] paths) {
        TreeItem[] allTreeItems = this.getTreeItems();
        TreePath[] allTreePaths = new TreePath[allTreeItems.length];
        for (int i = 0; i < allTreePaths.length; ++i) {
            allTreePaths[i] = this.getTreePath(allTreeItems[i]);
        }
        int[] rows = new int[paths.length];
        block1: for (int i = 0; i < paths.length; ++i) {
            for (int j = 0; j < allTreePaths.length; ++j) {
                if (!paths[i].equals(allTreePaths[j])) continue;
                rows[i] = j;
                continue block1;
            }
            rows[i] = -1;
        }
        return rows;
    }

    public final void addTreeExpansionListener(TreeExpansionListener tel) {
        this.eventListenerList.add(TreeExpansionListener.class, tel);
    }

    public final void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.eventListenerList.add(TreeSelectionListener.class, tsl);
    }

    public final void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.eventListenerList.remove(TreeExpansionListener.class, tel);
    }

    public final void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.eventListenerList.remove(TreeSelectionListener.class, tsl);
    }

    private final void fireValueChanged(TreeSelectionEvent e) {
        EventListener[] listeners = this.eventListenerList.getListeners(TreeSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((TreeSelectionListener)listeners[i]).valueChanged(e);
        }
    }

    private void fireTreeCollapsed(TreePath path) {
        EventListener[] listeners = this.eventListenerList.getListeners(TreeExpansionListener.class);
        if (listeners.length == 0) {
            return;
        }
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        for (int i = 0; i < listeners.length; ++i) {
            ((TreeExpansionListener)listeners[i]).treeCollapsed(event);
        }
    }

    private void fireTreeExpanded(TreePath path) {
        EventListener[] listeners = this.eventListenerList.getListeners(TreeExpansionListener.class);
        if (listeners.length == 0) {
            return;
        }
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        for (int i = 0; i < listeners.length; ++i) {
            ((TreeExpansionListener)listeners[i]).treeExpanded(event);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Tree tree = this.getTree();
        TreeItem[] selectedItems = tree.getSelection();
        TreePath[] pathsToSelect = new TreePath[selectedItems.length];
        for (int i = 0; i < pathsToSelect.length; ++i) {
            pathsToSelect[i] = this.getTreePath(selectedItems[i]);
        }
        this.ignoreSelectionChange = true;
        this.selectionModel.setSelectionPaths(pathsToSelect);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (e.getSource() == this.selectionModel) {
            Tree tree = this.getTree();
            if (!this.ignoreSelectionChange) {
                tree.removeSelectionListener((SelectionListener)this);
                try {
                    int[] selectedRows = this.selectionModel.getSelectionRows();
                    TreeItem[] itemsToSelect = new TreeItem[selectedRows.length];
                    TreeItem[] allItems = this.getTreeItems();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        itemsToSelect[i] = allItems[selectedRows[i]];
                    }
                    tree.setSelection(itemsToSelect);
                }
                finally {
                    tree.addSelectionListener((SelectionListener)this);
                }
            }
            this.ignoreSelectionChange = false;
            this.fireValueChanged((TreeSelectionEvent)e.cloneWithSource(this));
        }
    }

    public void treeCollapsed(org.eclipse.jface.viewers.TreeExpansionEvent event) {
        Object element = event.getElement();
        Vector<Object> v = new Vector<Object>();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        do {
            v.add(0, element);
        } while ((element = contentProvider.getParent(element)) != null);
        this.fireTreeCollapsed(new TreePath(v.toArray()));
    }

    public void treeExpanded(org.eclipse.jface.viewers.TreeExpansionEvent event) {
        Object element = event.getElement();
        Vector<Object> v = new Vector<Object>();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        do {
            v.add(0, element);
        } while ((element = contentProvider.getParent(element)) != null);
        this.fireTreeExpanded(new TreePath(v.toArray()));
    }

    public class TreeModelLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (SWTTree.this.renderer == null) {
                return super.getImage(element);
            }
            return SWTTree.this.renderer.getCellImage(element, 0, 0);
        }

        public String getText(Object element) {
            if (SWTTree.this.renderer == null) {
                return super.getText(element);
            }
            return SWTTree.this.renderer.getCellText(element, 0, 0);
        }
    }

    private class TreeModelContentProvider
    implements ITreeContentProvider {
        private TreeModelContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            int childrenCount = SWTTree.this.model.getChildCount(parentElement);
            Object[] children = new Object[childrenCount];
            for (int i = 0; i < childrenCount; ++i) {
                children[i] = SWTTree.this.model.getChild(parentElement, i);
            }
            return children;
        }

        public Object getParent(Object element) {
            if (element instanceof TreeNode) {
                return ((TreeNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return !SWTTree.this.model.isLeaf(element);
        }

        public Object[] getElements(Object inputElement) {
            Object root = SWTTree.this.model.getRoot();
            if (SWTTree.this.rootVisible) {
                return new Object[]{root};
            }
            Object[] elements = new Object[SWTTree.this.model.getChildCount(root)];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = SWTTree.this.model.getChild(root, i);
            }
            return elements;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

