/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import com.dev63.hotel.swt.swing2swt.components.SWTIcon;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.SwingConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SWTToolBar
extends SWTContainer
implements SwingConstants {
    public SWTToolBar(ToolBar toolBar) {
        super((Composite)toolBar);
    }

    public SWTToolBar(SWTContainer parent) {
        this(parent, 0);
    }

    public SWTToolBar(SWTContainer parent, int orientation) {
        this(new ToolBar(parent.getComposite(), 0x40 | (orientation == 1 ? 512 : 256)));
    }

    public SWTToolBar(SWTContainer parent, String name) {
        this(parent);
    }

    public SWTToolBar(SWTContainer parent, String name, int orientation) {
        this(parent, orientation);
    }

    public ToolBar getToolBar() {
        return (ToolBar)this.getControl();
    }

    public ToolItem add(final Action a) {
        Object icon;
        ToolItem item = new ToolItem(this.getToolBar(), 8);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, (String)a.getValue("ActionCommandKey")));
            }
        });
        String tooltip = (String)a.getValue("LongDescription");
        if (tooltip == null) {
            tooltip = (String)a.getValue("ShortDescription");
        }
        if (tooltip == null) {
            tooltip = (String)a.getValue("Name");
        }
        if ((icon = a.getValue("SmallIcon")) instanceof Image) {
            item.setImage((Image)icon);
        } else if (icon instanceof SWTIcon) {
            item.setImage(((SWTIcon)icon).getImage());
        }
        return item;
    }

    @Override
    public SWTComponent add(String name, SWTComponent component) {
        return this.add(component);
    }

    @Override
    public void add(SWTComponent component, Object constraints) {
        this.add(component);
    }

    @Override
    public SWTComponent add(SWTComponent component) {
        ToolItem item = new ToolItem(this.getToolBar(), 2);
        item.setControl(component.getControl());
        item.setWidth(component.getPreferredSize().width);
        return component;
    }

    public final void addSeparator() {
        new ToolItem(this.getToolBar(), 2);
    }

    public final SWTComponent getComponentAt(int index) {
        return SWTComponent.getSWTComponent(this.getToolBar().getItem(index).getControl());
    }

    public final int getComponentIndex(SWTComponent c) {
        for (int i = 0; i < this.getToolBar().getItemCount(); ++i) {
            if (c != this.getComponentAt(i)) continue;
            return i;
        }
        return -1;
    }

    public final int getOrientation() {
        return this.getControl().getStyle() == 512 ? 1 : 0;
    }

    @Override
    public final void remove(SWTComponent component) {
        this.remove(this.getComponentIndex(component));
    }

    @Override
    public final void remove(int index) {
        this.getToolBar().getItem(index).dispose();
    }

    @Override
    public void removeAll() {
        ToolItem[] items = this.getToolBar().getItems();
        for (int i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
    }
}

