/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import java.util.EventListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SWTTextComponent
extends SWTComponent
implements ModifyListener,
VerifyListener,
FocusListener {
    private transient VerifyEvent lastVerifyEvent;

    public SWTTextComponent(Text text) {
        super((Control)text);
        this.addListeners();
    }

    private void addListeners() {
        this.getTextControl().addModifyListener((ModifyListener)this);
        this.getTextControl().addVerifyListener((VerifyListener)this);
        this.getTextControl().addFocusListener((FocusListener)this);
    }

    public final Text getTextControl() {
        return (Text)this.getControl();
    }

    public final void copy() {
        this.getTextControl().copy();
    }

    public final void cut() {
        this.getTextControl().cut();
    }

    public final int getCaretPosition() {
        return this.getTextControl().getCaretPosition();
    }

    public final String getSelectedText() {
        String text = this.getTextControl().getSelectionText();
        return text.length() > 0 ? text : null;
    }

    public final int getSelectionEnd() {
        return this.getTextControl().getSelection().y;
    }

    public final int getSelectionStart() {
        return this.getTextControl().getSelection().x;
    }

    public final String getText() {
        return this.getTextControl().getText();
    }

    public final String getText(int offs, int len) {
        return this.getTextControl().getText(offs, offs + len - 1);
    }

    public final void setEditable(boolean editable) {
        this.getTextControl().setEditable(editable);
    }

    public final boolean isEditable() {
        return this.getTextControl().getEditable();
    }

    public final void replaceSelection(String content) {
        this.getTextControl().insert(content);
    }

    public final void select(int selectionStart, int selectionEnd) {
        this.getTextControl().setSelection(selectionStart, selectionEnd);
    }

    public final void selectAll() {
        this.getTextControl().selectAll();
    }

    public final void setCaretPosition(int pos) {
        this.getTextControl().setSelection(pos);
    }

    public SWTTextComponent getDocument() {
        return this;
    }

    public final void addDocumentListener(DocumentListener listener) {
        this.eventListenerList.add(DocumentListener.class, listener);
    }

    public final void removeDocumentListener(DocumentListener listener) {
        this.eventListenerList.remove(DocumentListener.class, listener);
    }

    public void verifyText(VerifyEvent e) {
        this.lastVerifyEvent = e;
    }

    public void modifyText(ModifyEvent e) {
        if (this.lastVerifyEvent != null) {
            boolean inserted = this.lastVerifyEvent.start == this.lastVerifyEvent.end;
            DocumentEvent documentEvent = null;
            EventListener[] documentListeners = this.eventListenerList.getListeners(DocumentListener.class);
            if (documentListeners.length > 0) {
                documentEvent = new DocumentEvent(){

                    @Override
                    public int getOffset() {
                        return ((SWTTextComponent)SWTTextComponent.this).lastVerifyEvent.start;
                    }

                    @Override
                    public int getLength() {
                        return ((SWTTextComponent)SWTTextComponent.this).lastVerifyEvent.text.length();
                    }

                    @Override
                    public Document getDocument() {
                        return null;
                    }

                    @Override
                    public DocumentEvent.EventType getType() {
                        if (((SWTTextComponent)SWTTextComponent.this).lastVerifyEvent.start == ((SWTTextComponent)SWTTextComponent.this).lastVerifyEvent.end) {
                            return DocumentEvent.EventType.INSERT;
                        }
                        return DocumentEvent.EventType.REMOVE;
                    }

                    @Override
                    public DocumentEvent.ElementChange getChange(Element elem) {
                        return null;
                    }
                };
            }
            for (int i = 0; i < documentListeners.length; ++i) {
                if (documentEvent.getType().equals(DocumentEvent.EventType.INSERT)) {
                    ((DocumentListener)documentListeners[i]).insertUpdate(documentEvent);
                    continue;
                }
                ((DocumentListener)documentListeners[i]).removeUpdate(documentEvent);
            }
            this.lastVerifyEvent = null;
        }
    }

    public void focusGained(FocusEvent e) {
        this.getTextControl().selectAll();
    }

    public void focusLost(FocusEvent e) {
    }
}

