/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTCellEditor;
import com.dev63.hotel.swt.swing2swt.components.SWTCellRenderer;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SWTTable
extends SWTComponent
implements TableColumnModelListener,
ListSelectionListener,
SelectionListener,
PropertyChangeListener,
ControlListener {
    private TableViewer tableViewer;
    private TableModel model;
    private TableColumnModel columnModel;
    private ListSelectionModel selectionModel;
    private Hashtable swingColumnToSWTColumn = new Hashtable();
    private Hashtable swtColumnToSwingColumn = new Hashtable();
    private Hashtable defaultRenderers = null;
    private Hashtable defaultEditors = null;

    public SWTTable(Table table) {
        super((Control)table);
        table.addSelectionListener((SelectionListener)this);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new TableModelContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableModelLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new TableModelCellModifier());
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
    }

    public SWTTable(SWTContainer parent) {
        this(parent, new DefaultTableModel());
    }

    public SWTTable(SWTContainer parent, int numRows, int numColumns) {
        this(parent, new DefaultTableModel(numRows, numColumns));
    }

    public SWTTable(SWTContainer parent, Object[][] rowData, Object[] columnNames) {
        this(parent, new DefaultTableModel(rowData, columnNames));
    }

    public SWTTable(SWTContainer parent, TableModel model) {
        this(parent, model, null);
        this.setColumnModel(this.createDefaultColumnModel());
        this.createDefaultColumnsFromModel();
    }

    public SWTTable(SWTContainer parent, TableModel model, TableColumnModel columnModel) {
        this(parent, model, columnModel, null);
    }

    public SWTTable(SWTContainer parent, TableModel model, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        this(new Table(parent.getComposite(), 68354));
        this.setModel(model);
        this.setColumnModel(columnModel);
        this.setSelectionModel(selectionModel);
    }

    public SWTTable(SWTContainer parent, Vector rowData, Vector columnNames) {
        this(parent, new DefaultTableModel(rowData, columnNames));
    }

    public final Table getTable() {
        return (Table)this.getControl();
    }

    public final TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public final void addRowSelectionInterval(int index0, int index1) {
        this.getTable().select(index0, index1);
    }

    public final void clearSelection() {
        this.getTable().deselectAll();
    }

    public final int convertColumnIndexToModel(int viewColumnIndex) {
        try {
            return this.getColumnModel().getColumn(viewColumnIndex).getModelIndex();
        }
        catch (Exception exc) {
            return viewColumnIndex;
        }
    }

    public int convertColumnIndexToView(int modelColumnIndex) {
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            if (cm.getColumn(i).getModelIndex() != modelColumnIndex) continue;
            return i;
        }
        return modelColumnIndex;
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public final boolean editCellAt(int row, int column) {
        this.getTableViewer().editElement(this.getTableViewer().getElementAt(row), column);
        return this.getModel().isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public final boolean editCellAt(int row, int column, EventObject e) {
        return this.editCellAt(row, column);
    }

    public final Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle rect = this.getTable().getItem(row).getBounds(column);
        if (includeSpacing) {
            int gridLineWidth = this.getTable().getGridLineWidth();
            if (row > 0) {
                rect.y -= gridLineWidth;
                rect.height += gridLineWidth;
            }
            if (row < this.getTable().getItemCount()) {
                rect.height += gridLineWidth;
            }
            if (column > 0) {
                rect.x -= gridLineWidth;
                rect.width += gridLineWidth;
            }
            if (column < this.getTable().getColumnCount()) {
                rect.width += gridLineWidth;
            }
        }
        return rect;
    }

    public SWTCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor;
        TableColumnModel cm = this.getColumnModel();
        if (cm != null && (editor = cm.getColumn(column).getCellEditor()) instanceof SWTCellEditor) {
            return (SWTCellEditor)editor;
        }
        return this.getDefaultEditor(this.getColumnClass(column));
    }

    public SWTCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer;
        TableColumnModel cm = this.getColumnModel();
        if (cm != null && (renderer = cm.getColumn(column).getCellRenderer()) instanceof SWTCellRenderer) {
            return (SWTCellRenderer)renderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(column));
    }

    public final TableColumn getColumn(Object identifier) {
        TableColumnModel cm = this.getColumnModel();
        return cm.getColumn(cm.getColumnIndex(identifier));
    }

    public final Class getColumnClass(int column) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(column));
    }

    public final int getColumnCount() {
        return this.getTable().getColumnCount();
    }

    public final int getColumnMargin() {
        return this.getTable().getGridLineWidth();
    }

    public final String getColumnName(int column) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(column));
    }

    public final boolean getColumnSelectionAllowed() {
        return false;
    }

    public final SWTCellEditor getDefaultEditor(Class columnClass) {
        if (this.defaultEditors == null || columnClass == null) {
            return null;
        }
        SWTCellEditor editor = (SWTCellEditor)this.defaultEditors.get(columnClass);
        if (editor != null) {
            return editor;
        }
        return this.getDefaultEditor(columnClass.getSuperclass());
    }

    public final SWTCellRenderer getDefaultRenderer(Class columnClass) {
        if (this.defaultRenderers == null || columnClass == null) {
            return null;
        }
        SWTCellRenderer renderer = (SWTCellRenderer)this.defaultRenderers.get(columnClass);
        if (renderer != null) {
            return renderer;
        }
        return this.getDefaultRenderer(columnClass.getSuperclass());
    }

    public final Dimension getIntercellSpacing() {
        int gridLineWidth = this.getTable().getGridLineWidth();
        return new Dimension(gridLineWidth, gridLineWidth);
    }

    public final TableModel getModel() {
        return this.model;
    }

    public final int getRowCount() {
        return this.getTable().getItemCount();
    }

    public final int getRowHeight() {
        return this.getTable().getItemHeight();
    }

    public final int getRowHeight(int row) {
        return this.getRowHeight();
    }

    public final int getRowMargin() {
        return this.getTable().getGridLineWidth();
    }

    public final boolean getRowSelectionAllowed() {
        return (this.getTable().getStyle() & 0x8000) == 0;
    }

    public final int getSelectedRow() {
        return this.getTable().getSelectionIndex();
    }

    public final int getSelectedRowCount() {
        return this.getTable().getSelectionCount();
    }

    public final int[] getSelectedRows() {
        return this.getTable().getSelectionIndices();
    }

    public final void moveColumn(int column, int targetColumn) {
        this.getColumnModel().moveColumn(column, targetColumn);
    }

    public final void setModel(TableModel model) {
        this.model = model;
        this.tableViewer.setInput((Object)model);
        this.createDefaultColumnsFromModel();
    }

    public final ListSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            this.setSelectionModel(new DefaultListSelectionModel());
        }
        return this.selectionModel;
    }

    public final void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this);
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this);
            if ((this.getTable().getStyle() & 2) != 0) {
                selectionModel.setSelectionMode(2);
            } else {
                selectionModel.setSelectionMode(0);
            }
        }
    }

    public final boolean getShowHorizontalLines() {
        return this.getTable().getLinesVisible();
    }

    public final boolean getShowVerticalLines() {
        return this.getTable().getLinesVisible();
    }

    public final boolean isCellEditable(int row, int column) {
        return this.getModel().isCellEditable(row, this.convertColumnIndexToModel(column));
    }

    public final boolean isEditing() {
        return this.getTableViewer().isCellEditorActive();
    }

    public final boolean isRowSelected(int row) {
        return this.getTable().isSelected(row);
    }

    public final void removeColumn(TableColumn column) {
        this.getColumnModel().removeColumn(column);
    }

    public final void removeEditor() {
        this.getTableViewer().cancelEditing();
    }

    public final int rowAtPoint(Point point) {
        TableItem item = this.getTable().getItem(point);
        if (item == null) {
            return -1;
        }
        TableItem[] items = this.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (item != items[i]) continue;
            return i;
        }
        return -1;
    }

    public final void selectAll() {
        this.getTable().selectAll();
    }

    public final void setDefaultEditor(Class columnClass, SWTCellEditor cellEditor) {
        if (this.defaultEditors == null) {
            this.defaultEditors = new Hashtable();
        }
        this.defaultEditors.put(columnClass, cellEditor);
        this.updateCellEditors();
    }

    public final void setDefaultRenderer(Class columnClass, SWTCellRenderer cellRenderer) {
        if (this.defaultRenderers == null) {
            this.defaultRenderers = new Hashtable();
        }
        this.defaultRenderers.put(columnClass, cellRenderer);
        this.getTableViewer().refresh();
    }

    public final void setShowGrid(boolean showGrid) {
        this.getTable().setLinesVisible(showGrid);
    }

    public final void setShowHorizontalLines(boolean showHorizontalLines) {
        this.getTable().setLinesVisible(showHorizontalLines);
    }

    public final void setShowVerticalLines(boolean showVerticalLines) {
        this.getTable().setLinesVisible(showVerticalLines);
    }

    public final void setValueAt(Object value, int row, int column) {
        this.getModel().setValueAt(value, row, this.convertColumnIndexToModel(column));
        TableViewer tv = this.getTableViewer();
        tv.refresh(tv.getElementAt(column), false);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    public void createDefaultColumnsFromModel() {
        TableColumnModel columnModel = this.getColumnModel();
        if (columnModel == null) {
            return;
        }
        while (columnModel.getColumnCount() > 0) {
            columnModel.removeColumn(columnModel.getColumn(0));
        }
        if (this.model != null) {
            for (int i = 0; i < this.model.getColumnCount(); ++i) {
                TableColumn swingColumn = new TableColumn(i);
                swingColumn.setHeaderValue(this.model.getColumnName(i));
                this.addColumn(swingColumn);
            }
        }
        this.getTableViewer().refresh();
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(TableColumnModel columnModel) {
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this);
        }
        this.columnModel = columnModel;
        if (columnModel != null) {
            columnModel.addColumnModelListener(this);
        }
    }

    public void addColumn(TableColumn column) {
        this.getColumnModel().addColumn(column);
    }

    private void mapColumn(TableColumn swingTableColumn, org.eclipse.swt.widgets.TableColumn swtTableColumn) {
        this.swingColumnToSWTColumn.put(swingTableColumn, swtTableColumn);
        this.swtColumnToSwingColumn.put(swtTableColumn, swingTableColumn);
        swingTableColumn.addPropertyChangeListener(this);
        swtTableColumn.addControlListener((ControlListener)this);
    }

    private void unmapColumn(TableColumn swingTableColumn) {
        org.eclipse.swt.widgets.TableColumn swtColumn = this.getSWTTableColumn(swingTableColumn);
        this.swingColumnToSWTColumn.remove(swingTableColumn);
        if (swtColumn != null) {
            this.swtColumnToSwingColumn.remove(swtColumn);
        }
        swingTableColumn.removePropertyChangeListener(this);
        swtColumn.removeControlListener((ControlListener)this);
    }

    private TableColumn getSwingTableColumn(org.eclipse.swt.widgets.TableColumn swtTableColumn) {
        return (TableColumn)this.swtColumnToSwingColumn.get(swtTableColumn);
    }

    private org.eclipse.swt.widgets.TableColumn getSWTTableColumn(TableColumn swingTableColumn) {
        return (org.eclipse.swt.widgets.TableColumn)this.swingColumnToSWTColumn.get(swingTableColumn);
    }

    private org.eclipse.swt.widgets.TableColumn createSWTColumnFor(TableColumn swingTableColumn) {
        int columnIndex = swingTableColumn.getModelIndex();
        org.eclipse.swt.widgets.TableColumn swtColumn = new org.eclipse.swt.widgets.TableColumn(this.getTable(), 0, columnIndex);
        Object columnHeader = swingTableColumn.getHeaderValue();
        if (columnHeader != null) {
            swtColumn.setText(columnHeader.toString());
        } else {
            swtColumn.setText(this.getModel().getColumnName(columnIndex));
        }
        swtColumn.setWidth(swingTableColumn.getWidth());
        swtColumn.setResizable(swingTableColumn.getResizable());
        this.mapColumn(swingTableColumn, swtColumn);
        return swtColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent e) {
        if (this.selectionModel != null) {
            try {
                this.selectionModel.removeListSelectionListener(this);
                Table table = this.getTable();
                if (this.selectionModel.getSelectionMode() == 0) {
                    int selectedIndex = table.getSelectionIndex();
                    if (selectedIndex < 0) {
                        this.selectionModel.clearSelection();
                    } else {
                        this.selectionModel.setSelectionInterval(selectedIndex, selectedIndex);
                    }
                } else {
                    this.selectionModel.setValueIsAdjusting(true);
                    for (int i = 0; i < table.getItemCount(); ++i) {
                        boolean selected = table.isSelected(i);
                        if (this.selectionModel.isSelectedIndex(i) == selected) continue;
                        if (selected) {
                            this.selectionModel.addSelectionInterval(i, i);
                            continue;
                        }
                        this.selectionModel.removeSelectionInterval(i, i);
                    }
                    this.selectionModel.setValueIsAdjusting(false);
                }
            }
            finally {
                this.selectionModel.addListSelectionListener(this);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.selectionModel) {
            Table table = this.getTable();
            try {
                table.removeSelectionListener((SelectionListener)this);
                for (int i = e.getFirstIndex(); i <= e.getLastIndex() && i < table.getItemCount(); ++i) {
                    boolean selected = this.selectionModel.isSelectedIndex(i);
                    if (table.isSelected(i) == selected) continue;
                    if (selected) {
                        table.select(i);
                        continue;
                    }
                    table.deselect(i);
                }
            }
            finally {
                table.addSelectionListener((SelectionListener)this);
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        TableColumnModel cm = this.getColumnModel();
        this.createSWTColumnFor(cm.getColumn(e.getToIndex()));
        this.updateCellEditors();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        int index = e.getFromIndex();
        org.eclipse.swt.widgets.TableColumn swtColumn = this.getTable().getColumn(index);
        TableColumn swingColumn = this.getSwingTableColumn(swtColumn);
        if (swingColumn != null) {
            this.unmapColumn(swingColumn);
        }
        swtColumn.dispose();
        this.updateCellEditors();
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        TableColumnModel cm = this.getColumnModel();
        Table table = this.getTable();
        org.eclipse.swt.widgets.TableColumn col1 = table.getColumn(e.getFromIndex());
        org.eclipse.swt.widgets.TableColumn col2 = table.getColumn(e.getToIndex());
        int int_buffer = col1.getWidth();
        col1.setWidth(col2.getWidth());
        col2.setWidth(int_buffer);
        int_buffer = col1.getAlignment();
        col1.setAlignment(col2.getAlignment());
        col2.setAlignment(int_buffer);
        String string_buffer = col1.getText();
        col1.setText(col2.getText());
        col2.setText(string_buffer);
        boolean bool_buffer = col1.getResizable();
        col1.setResizable(col2.getResizable());
        col2.setResizable(bool_buffer);
        Image img_buffer = col1.getImage();
        col1.setImage(col2.getImage());
        col2.setImage(img_buffer);
        TableColumn swingColumn1 = this.getSwingTableColumn(col1);
        TableColumn swingColumn2 = this.getSwingTableColumn(col2);
        this.mapColumn(swingColumn2, col1);
        this.mapColumn(swingColumn1, col2);
        this.getTableViewer().refresh();
    }

    private void updateCellEditors() {
        TableColumnModel cm = this.getColumnModel();
        String[] columnProperties = new String[cm.getColumnCount()];
        CellEditor[] editors = new CellEditor[cm.getColumnCount()];
        for (int i = 0; i < columnProperties.length; ++i) {
            columnProperties[i] = String.valueOf(i);
            SWTCellEditor e = this.getCellEditor(0, i);
            editors[i] = e == null ? null : e.getCellEditor();
        }
        this.getTableViewer().setColumnProperties(columnProperties);
        this.getTableViewer().setCellEditors(editors);
    }

    private int getColumnIndex(Object columnProperty) {
        int columnIndex = -1;
        Object[] columnProperties = this.getTableViewer().getColumnProperties();
        for (int i = 0; i < columnProperties.length && columnIndex < 0; ++i) {
            if (!columnProperty.equals(columnProperties[i])) continue;
            columnIndex = i;
        }
        return columnIndex;
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof TableColumn) {
            String propName = evt.getPropertyName();
            if (propName.equals("width")) {
                TableColumn swingTableColumn = (TableColumn)evt.getSource();
                org.eclipse.swt.widgets.TableColumn swtTableColumn = this.getSWTTableColumn(swingTableColumn);
                swtTableColumn.setWidth(swingTableColumn.getWidth());
            } else if (propName.equals("cellRenderer")) {
                this.getTableViewer().refresh();
            } else if (propName.equals("cellEditor")) {
                this.updateCellEditors();
            }
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (e.getSource() instanceof org.eclipse.swt.widgets.TableColumn) {
            org.eclipse.swt.widgets.TableColumn swtColumn = (org.eclipse.swt.widgets.TableColumn)e.getSource();
            TableColumn swingColumn = this.getSwingTableColumn(swtColumn);
            swingColumn.setPreferredWidth(swtColumn.getWidth());
            swingColumn.setWidth(swtColumn.getWidth());
        }
    }

    private int getRowIndex(Object element) {
        int rowIndex = -1;
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getTableViewer().getContentProvider();
        Object[] rows = contentProvider.getElements(this.getTableViewer().getInput());
        for (int i = 0; i < rows.length && rowIndex < 0; ++i) {
            if (!element.equals(rows[i])) continue;
            rowIndex = i;
        }
        return rowIndex;
    }

    private class TableModelCellModifier
    implements ICellModifier {
        private TableModelCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            int columnIndex = SWTTable.this.getColumnIndex(property);
            int rowIndex = SWTTable.this.getRowIndex(element);
            return SWTTable.this.getModel().isCellEditable(rowIndex, SWTTable.this.convertColumnIndexToModel(columnIndex));
        }

        public Object getValue(Object element, String property) {
            int columnIndex = SWTTable.this.getColumnIndex(property);
            int rowIndex = SWTTable.this.getRowIndex(element);
            return SWTTable.this.getModel().getValueAt(rowIndex, SWTTable.this.convertColumnIndexToModel(columnIndex));
        }

        public void modify(Object element, String property, Object value) {
            int columnIndex = SWTTable.this.getColumnIndex(property);
            int rowIndex = -1;
            if (element instanceof TableItem) {
                rowIndex = SWTTable.this.getTable().indexOf((TableItem)element);
                element = ((TableItem)element).getData();
            } else {
                rowIndex = SWTTable.this.getRowIndex(element);
            }
            SWTTable.this.getModel().setValueAt(value, rowIndex, SWTTable.this.convertColumnIndexToModel(columnIndex));
            SWTTable.this.getTableViewer().update(element, new String[]{property});
        }
    }

    private class TableModelLabelProvider
    implements ITableLabelProvider {
        private TableModelLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof Vector) {
                Object item = ((Vector)element).get(SWTTable.this.convertColumnIndexToModel(columnIndex));
                if (item == null) {
                    return null;
                }
                int rowIndex = SWTTable.this.getRowIndex(element);
                SWTCellRenderer renderer = SWTTable.this.getCellRenderer(rowIndex, columnIndex);
                if (renderer != null) {
                    return renderer.getCellImage(item, rowIndex, columnIndex);
                }
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Vector) {
                Object item = ((Vector)element).get(SWTTable.this.convertColumnIndexToModel(columnIndex));
                if (item == null) {
                    return "";
                }
                int rowIndex = SWTTable.this.getRowIndex(element);
                SWTCellRenderer renderer = SWTTable.this.getCellRenderer(rowIndex, columnIndex);
                if (renderer != null) {
                    return renderer.getCellText(item, rowIndex, columnIndex);
                }
                return item.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class TableModelContentProvider
    implements IStructuredContentProvider {
        public Object[] cachedElements;

        private TableModelContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.cachedElements != null) {
                return this.cachedElements;
            }
            if (inputElement instanceof DefaultTableModel) {
                DefaultTableModel dtm = (DefaultTableModel)inputElement;
                this.cachedElements = dtm.getDataVector().toArray();
            } else if (inputElement instanceof TableModel) {
                TableModel tm = (TableModel)inputElement;
                Vector[] rows = new Vector[tm.getRowCount()];
                for (int i = 0; i < tm.getRowCount(); ++i) {
                    rows[i] = new Vector(tm.getColumnCount());
                    for (int j = 0; j < tm.getColumnCount(); ++j) {
                        rows[i].add(tm.getValueAt(i, j));
                    }
                }
                this.cachedElements = rows;
            }
            return this.cachedElements;
        }

        public void dispose() {
            this.cachedElements = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.cachedElements = null;
        }
    }
}

