/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SWTTabbedPane
extends SWTContainer
implements SelectionListener {
    private static final String SWT_COMP_KEY = "SWTComponent";

    public SWTTabbedPane(TabFolder tabFolder) {
        super((Composite)tabFolder);
        tabFolder.addSelectionListener((SelectionListener)this);
    }

    public SWTTabbedPane(SWTContainer parent) {
        this(new TabFolder(parent.getComposite(), 0));
    }

    public final TabFolder getTabFolder() {
        return (TabFolder)this.getControl();
    }

    @Override
    public SWTComponent add(SWTComponent component) {
        return this.add("", component);
    }

    public SWTComponent add(SWTComponent component, int index) {
        this.add(component, "", index);
        return component;
    }

    @Override
    public void add(SWTComponent component, Object constraints) {
        this.add(component, constraints, this.getTabFolder().getItemCount());
    }

    public void add(SWTComponent component, Object constraints, int index) {
        TabItem tabItem = new TabItem(this.getTabFolder(), 0, index);
        tabItem.setControl(component.getControl());
        tabItem.setText(constraints == null ? "" : constraints.toString());
        tabItem.setData(SWT_COMP_KEY, (Object)component);
    }

    @Override
    public SWTComponent add(String title, SWTComponent component) {
        this.add(component, title);
        return component;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.eventListenerList.add(ChangeListener.class, listener);
    }

    public void addTab(String title, SWTComponent component) {
        this.add(title, component);
    }

    public void addTab(String title, Image icon, SWTComponent component) {
        TabFolder tabFolder = this.getTabFolder();
        this.add(title, component);
        tabFolder.getItem(tabFolder.getItemCount() - 1).setImage(icon);
    }

    public void addTab(String title, Image icon, SWTComponent component, String tip) {
        TabFolder tabFolder = this.getTabFolder();
        this.add(title, component);
        TabItem tabItem = tabFolder.getItem(tabFolder.getItemCount() - 1);
        tabItem.setImage(icon);
        tabItem.setToolTipText(tip);
    }

    public final SWTComponent getComponentAt(int index) {
        return (SWTComponent)this.getTabFolder().getItem(index).getData(SWT_COMP_KEY);
    }

    public final Image getIconAt(int index) {
        return this.getTabFolder().getItem(index).getImage();
    }

    public final SWTComponent getSelectedComponent() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return (SWTComponent)this.getTabFolder().getItem(index).getData(SWT_COMP_KEY);
    }

    public final int getSelectedIndex() {
        return this.getTabFolder().getSelectionIndex();
    }

    public final int getTabCount() {
        return this.getTabFolder().getItemCount();
    }

    public final String getTitleAt(int index) {
        return this.getTabFolder().getItem(index).getText();
    }

    public final String getToolTipTextAt(int index) {
        return this.getTabFolder().getItem(index).getToolTipText();
    }

    public final int indexOfComponent(SWTComponent component) {
        TabItem[] tabItems = this.getTabFolder().getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            if (!tabItems[i].getData(SWT_COMP_KEY).equals(component)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfTab(Image icon) {
        TabItem[] tabItems = this.getTabFolder().getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            if (!tabItems[i].getImage().equals((Object)icon)) continue;
            return i;
        }
        return -1;
    }

    public final int indexOfTab(String title) {
        TabItem[] tabItems = this.getTabFolder().getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            if (!tabItems[i].getText().equals(title)) continue;
            return i;
        }
        return -1;
    }

    public final void insertTab(String title, Image icon, SWTComponent component, String tip, int index) {
        this.add(component, title, index);
        TabItem tabItem = this.getTabFolder().getItem(index);
        tabItem.setImage(icon);
        tabItem.setToolTipText(tip);
    }

    @Override
    public final void remove(SWTComponent component) {
        TabItem[] tabItems = this.getTabFolder().getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            if (!tabItems[i].getData(SWT_COMP_KEY).equals(component)) continue;
            tabItems[i].dispose();
            return;
        }
    }

    @Override
    public final void remove(int index) {
        this.getTabFolder().getItem(index).dispose();
    }

    @Override
    public final void removeAll() {
        TabItem[] tabItems = this.getTabFolder().getItems();
        for (int i = 0; i < tabItems.length; ++i) {
            tabItems[i].dispose();
        }
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.eventListenerList.remove(ChangeListener.class, listener);
    }

    public final void removeTabAt(int index) {
        this.remove(index);
    }

    public final void setComponentAt(int index, SWTComponent component) {
        TabItem tabItem = this.getTabFolder().getItem(index);
        tabItem.setControl(component.getControl());
        tabItem.setData(SWT_COMP_KEY, (Object)component);
    }

    public final void setIconAt(int index, Image icon) {
        TabItem tabItem = this.getTabFolder().getItem(index);
        tabItem.setImage(icon);
    }

    public final void setSelectedComponent(SWTComponent component) {
        this.setSelectedIndex(this.indexOfComponent(component));
    }

    public final void setSelectedIndex(int index) {
        this.getTabFolder().setSelection(index);
    }

    public final void setTitleAt(int index, String title) {
        TabItem tabItem = this.getTabFolder().getItem(index);
        tabItem.setText(title);
    }

    public final void setToolTipTextAt(int index, String toolTipText) {
        TabItem tabItem = this.getTabFolder().getItem(index);
        tabItem.setToolTipText(toolTipText);
    }

    public void widgetSelected(SelectionEvent e) {
        EventListener[] listeners = this.eventListenerList.getListeners(ChangeListener.class);
        if (listeners.length == 0) {
            return;
        }
        ChangeEvent awtEvent = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            ((ChangeListener)listeners[i]).stateChanged(awtEvent);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

