/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTSplitPane
extends SWTContainer {
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;

    public SWTSplitPane(SashForm sashForm) {
        super((Composite)sashForm);
    }

    public SWTSplitPane(SWTContainer parent) {
        this(new SashForm(parent.getComposite(), 256));
    }

    public SWTSplitPane(SWTContainer parent, int orientation) {
        this(parent);
        this.setOrientation(orientation);
    }

    public SashForm getSashForm() {
        return (SashForm)this.getControl();
    }

    public int getOrientation() {
        if (this.getSashForm().getOrientation() == 512) {
            return 0;
        }
        return 1;
    }

    public void setOrientation(int orientation) {
        if (orientation == 0) {
            this.getSashForm().setOrientation(512);
        } else {
            this.getSashForm().setOrientation(256);
        }
    }

    public SWTComponent getTopComponent() {
        Control[] children = this.getSashForm().getChildren();
        if (children.length > 0) {
            return new SWTComponent(children[0]);
        }
        return null;
    }

    public SWTComponent getBottomComponent() {
        Control[] children = this.getSashForm().getChildren();
        if (children.length > 1) {
            return new SWTComponent(children[1]);
        }
        return null;
    }

    public SWTComponent getLeftComponent() {
        return this.getTopComponent();
    }

    public SWTComponent getRightComponent() {
        return this.getBottomComponent();
    }

    public int getDividerLocation() {
        Control[] children = this.getSashForm().getChildren();
        if (children.length == 0) {
            return 0;
        }
        if (this.getSashForm().getOrientation() == 256) {
            return children[0].getSize().x;
        }
        return children[0].getSize().y;
    }

    public int getMaximumDividerLocation() {
        return this.getSashForm().getClientArea().width;
    }

    public int getMinimumDividerLocation() {
        return 0;
    }

    public void resetToPreferredSizes() {
        Control[] children = this.getSashForm().getChildren();
        if (children.length < 2) {
            return;
        }
        int[] weights = new int[children.length];
        if (this.getSashForm().getOrientation() == 256) {
            for (int i = 0; i < children.length; ++i) {
                weights[i] = children[i].computeSize((int)-1, (int)-1).x;
            }
        } else {
            for (int i = 0; i < children.length; ++i) {
                weights[i] = children[i].computeSize((int)-1, (int)-1).y;
            }
        }
        this.getSashForm().setWeights(weights);
    }

    public void setDividerLocation(double proportionalLocation) {
        int[] weights = new int[]{(int)Math.round(proportionalLocation * 100.0), (int)Math.round((1.0 - proportionalLocation) * 100.0)};
        this.getSashForm().setWeights(weights);
    }

    public void setDividerLocation(int dividerLocation) {
        int[] weights = new int[]{dividerLocation, this.getSashForm().getClientArea().width - dividerLocation};
        this.getSashForm().setWeights(weights);
    }
}

