/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;

public class SWTSlider
extends SWTComponent
implements SwingConstants,
ChangeListener,
SelectionListener {
    private BoundedRangeModel model;
    private transient ChangeEvent changeEvent = null;
    private transient boolean ignoreModelChange = false;

    public SWTSlider(Slider slider) {
        super((Control)slider);
        slider.addSelectionListener((SelectionListener)this);
    }

    public SWTSlider(SWTContainer parent) {
        this(parent, 0);
    }

    public SWTSlider(SWTContainer parent, BoundedRangeModel model) {
        this(new Slider(parent.getComposite(), 256));
        this.setModel(model);
    }

    public SWTSlider(SWTContainer parent, int orient) {
        this(parent, orient, 0, 100, 50);
    }

    public SWTSlider(SWTContainer parent, int min, int max) {
        this(parent, 0, min, max, 50);
    }

    public SWTSlider(SWTContainer parent, int min, int max, int value) {
        this(parent, 0, min, max, value);
    }

    public SWTSlider(SWTContainer parent, int orient, int min, int max, int value) {
        this(new Slider(parent.getComposite(), 0x10000 | (orient == 1 ? 512 : 256)));
        this.setModel(new DefaultBoundedRangeModel(value, 0, min, max));
    }

    public Slider getSlider() {
        return (Slider)this.getControl();
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public final void setModel(BoundedRangeModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this);
        }
        this.model = model;
        int extent = model.getExtent();
        if (extent < 1) {
            extent = 1;
        }
        this.getSlider().setValues(model.getValue(), model.getMinimum(), model.getMaximum(), extent, 1, this.getSlider().getPageIncrement());
        model.addChangeListener(this);
    }

    public final int getExtent() {
        return this.getSlider().getThumb();
    }

    public final int getMaximum() {
        return this.getSlider().getMaximum();
    }

    public final int getMinimum() {
        return this.getSlider().getMinimum();
    }

    public final int getOrientation() {
        return (this.getSlider().getStyle() & 0x200) != 0 ? 1 : 0;
    }

    public final int getValue() {
        return this.getSlider().getSelection();
    }

    public final void setExtent(int n) {
        if (n < 0) {
            n = 1;
        }
        if (this.model == null) {
            this.getSlider().setThumb(n);
        } else {
            this.model.setExtent(n);
        }
    }

    public final void setMaximum(int n) {
        if (this.model == null) {
            this.getSlider().setMaximum(n);
        } else {
            this.model.setMaximum(n);
        }
    }

    public final void setMinimum(int n) {
        if (this.model == null) {
            this.getSlider().setMinimum(n);
        } else {
            this.model.setMinimum(n);
        }
    }

    public final void setValue(int n) {
        if (this.model == null) {
            this.getSlider().setSelection(n);
        } else {
            this.model.setValue(n);
        }
    }

    public final void addChangeListener(ChangeListener listener) {
        this.eventListenerList.add(ChangeListener.class, listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.eventListenerList.remove(ChangeListener.class, listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.model) {
            if (!this.ignoreModelChange) {
                int extent = this.model.getExtent();
                if (extent < 1) {
                    extent = 1;
                }
                this.getSlider().setValues(this.model.getValue(), this.model.getMinimum(), this.model.getMaximum(), extent, 1, this.getSlider().getPageIncrement());
            }
            EventListener[] changeListeners = this.eventListenerList.getListeners(ChangeListener.class);
            for (int i = 0; i < changeListeners.length; ++i) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)changeListeners[i]).stateChanged(this.changeEvent);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Slider slider = this.getSlider();
        if (e.getSource() == slider && this.model != null) {
            this.ignoreModelChange = true;
            this.model.setRangeProperties(slider.getSelection(), slider.getThumb(), slider.getMinimum(), slider.getMaximum(), false);
            this.ignoreModelChange = false;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

