/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ProgressBar;

public class SWTProgressBar
extends SWTComponent
implements SwingConstants,
ChangeListener {
    private BoundedRangeModel model;
    private transient ChangeEvent changeEvent = null;

    public SWTProgressBar(ProgressBar progressBar) {
        super((Control)progressBar);
    }

    public SWTProgressBar(SWTContainer parent) {
        this(parent, 0);
    }

    public SWTProgressBar(SWTContainer parent, BoundedRangeModel model) {
        this(new ProgressBar(parent.getComposite(), 256));
        this.setModel(model);
    }

    public SWTProgressBar(SWTContainer parent, int orient) {
        this(parent, orient, 0, 100);
    }

    public SWTProgressBar(SWTContainer parent, int min, int max) {
        this(parent, 0, min, max);
    }

    public SWTProgressBar(SWTContainer parent, int orient, int min, int max) {
        this(new ProgressBar(parent.getComposite(), 0x10000 | (orient == 1 ? 512 : 256)));
        this.setModel(new DefaultBoundedRangeModel(0, 0, min, max));
    }

    public ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl();
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public final void setModel(BoundedRangeModel model) {
        if (this.model != null) {
            this.model.removeChangeListener(this);
        }
        this.model = model;
        this.getProgressBar().setMaximum(model.getMaximum());
        this.getProgressBar().setMinimum(model.getMinimum());
        this.getProgressBar().setSelection(model.getValue());
        model.addChangeListener(this);
    }

    public final int getMaximum() {
        return this.getProgressBar().getMaximum();
    }

    public final int getMinimum() {
        return this.getProgressBar().getMinimum();
    }

    public final int getOrientation() {
        return (this.getProgressBar().getStyle() & 0x200) != 0 ? 1 : 0;
    }

    public final double getPercentComplete() {
        return (this.getValue() - this.getMinimum()) / (this.getMaximum() - this.getMinimum());
    }

    public final int getValue() {
        return this.getProgressBar().getSelection();
    }

    public final void setMaximum(int n) {
        if (this.model == null) {
            this.getProgressBar().setMaximum(n);
        } else {
            this.model.setMaximum(n);
        }
    }

    public final void setMinimum(int n) {
        if (this.model == null) {
            this.getProgressBar().setMinimum(n);
        } else {
            this.model.setMinimum(n);
        }
    }

    public final void setValue(int n) {
        if (this.model == null) {
            this.getProgressBar().setSelection(n);
        } else {
            this.model.setValue(n);
        }
    }

    public final void addChangeListener(ChangeListener listener) {
        this.eventListenerList.add(ChangeListener.class, listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.eventListenerList.remove(ChangeListener.class, listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.model) {
            ProgressBar progressBar = this.getProgressBar();
            progressBar.setMinimum(this.model.getMinimum());
            progressBar.setMaximum(this.model.getMaximum());
            progressBar.setSelection(this.model.getValue());
            EventListener[] changeListeners = this.eventListenerList.getListeners(ChangeListener.class);
            for (int i = 0; i < changeListeners.length; ++i) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)changeListeners[i]).stateChanged(this.changeEvent);
            }
        }
    }
}

