/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTCellRenderer;
import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;

public class SWTList
extends SWTComponent
implements SelectionListener,
ListSelectionListener,
ListDataListener {
    private ListModel model;
    private ListSelectionModel selectionModel;
    private ListViewer listViewer;
    private SWTCellRenderer renderer;
    private transient boolean ignoreSelectionChange = false;

    public SWTList(List list) {
        super((Control)list);
        list.addSelectionListener((SelectionListener)this);
        this.listViewer = new ListViewer(list);
        this.listViewer.setContentProvider((IContentProvider)new ListModelContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ListModelLabelProvider());
    }

    public SWTList(SWTContainer parent) {
        this(parent, false);
    }

    public SWTList(SWTContainer parent, boolean singleSelection) {
        this(parent, singleSelection, new DefaultListModel());
    }

    public SWTList(SWTContainer parent, Object[] listData) {
        this(parent, false, listData);
    }

    public SWTList(SWTContainer parent, boolean singleSelection, final Object[] listData) {
        this(parent, singleSelection, new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return listData[index];
            }

            @Override
            public int getSize() {
                return listData.length;
            }
        });
    }

    public SWTList(SWTContainer parent, Vector listData) {
        this(parent, false, listData);
    }

    public SWTList(SWTContainer parent, boolean singleSelection, final Vector listData) {
        this(parent, singleSelection, new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return listData.get(index);
            }

            @Override
            public int getSize() {
                return listData.size();
            }
        });
    }

    public SWTList(SWTContainer parent, ListModel dataModel) {
        this(parent, false, dataModel);
    }

    public SWTList(SWTContainer parent, boolean singleSelection, ListModel dataModel) {
        this(new List(parent.getComposite(), 0xB00 | (singleSelection ? 4 : 2)));
        this.setModel(dataModel);
    }

    public final List getList() {
        return (List)this.getControl();
    }

    public final ListViewer getListViewer() {
        return this.listViewer;
    }

    public final void addListSelectionListener(ListSelectionListener listener) {
        this.eventListenerList.add(ListSelectionListener.class, listener);
        this.getSelectionModel();
    }

    public final void removeListSelectionListener(ListSelectionListener listener) {
        this.eventListenerList.remove(ListSelectionListener.class, listener);
    }

    private final void fireValueChanged(ListSelectionEvent e) {
        EventListener[] listeners = this.eventListenerList.getListeners(ListSelectionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ListSelectionListener)listeners[i]).valueChanged(e);
        }
    }

    public final void addSelectionInterval(int anchor, int lead) {
        this.getList().select(Math.min(anchor, lead), Math.max(anchor, lead));
    }

    public final void clearSelection() {
        this.getList().deselectAll();
    }

    public final void ensureIndexIsVisible(int index) {
        this.listViewer.reveal(this.listViewer.getElementAt(index));
    }

    public final int getAnchorSelectionIndex() {
        if (this.selectionModel != null) {
            return this.selectionModel.getAnchorSelectionIndex();
        }
        int[] selectionIndices = this.getList().getSelectionIndices();
        if (selectionIndices.length == 0) {
            return -1;
        }
        return selectionIndices[0];
    }

    public final SWTCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public final int getFirstVisibleIndex() {
        return this.getList().getTopIndex();
    }

    public final int getFixedCellHeight() {
        return this.getList().getItemHeight();
    }

    public final int getLastVisibleIndex() {
        List list = this.getList();
        Rectangle clientArea = list.getClientArea();
        return list.getTopIndex() + clientArea.height / list.getItemHeight() - 1;
    }

    public final int getLeadSelectionIndex() {
        if (this.selectionModel != null) {
            return this.selectionModel.getLeadSelectionIndex();
        }
        int[] selectionIndices = this.getList().getSelectionIndices();
        if (selectionIndices.length == 0) {
            return -1;
        }
        return selectionIndices[selectionIndices.length - 1];
    }

    public final int getMaxSelectionIndex() {
        int[] indices = this.getList().getSelectionIndices();
        if (indices.length == 0) {
            return -1;
        }
        int max = indices[0];
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] <= max) continue;
            max = indices[i];
        }
        return max;
    }

    public final int getMinSelectionIndex() {
        int[] indices = this.getList().getSelectionIndices();
        if (indices.length == 0) {
            return -1;
        }
        int min = indices[0];
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] >= min) continue;
            min = indices[i];
        }
        return min;
    }

    public final int getSelectedIndex() {
        return this.getList().getSelectionIndex();
    }

    public final int[] getSelectedIndices() {
        return this.getList().getSelectionIndices();
    }

    public final Object getSelectedValue() {
        int idx = this.getList().getSelectionIndex();
        if (idx < 0) {
            return null;
        }
        return this.getListViewer().getElementAt(idx);
    }

    public final Object[] getSelectedValues() {
        int[] indices = this.getList().getSelectionIndices();
        Object[] selection = new Object[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            selection[i] = this.listViewer.getElementAt(indices[i]);
        }
        return selection;
    }

    public final int getSelectionMode() {
        if ((this.getList().getStyle() & 2) != 0) {
            return 2;
        }
        return 0;
    }

    public final int getVisibleRowCount() {
        List list = this.getList();
        return list.getClientArea().height / list.getItemHeight();
    }

    public final boolean isSelectedIndex(int index) {
        return this.getList().isSelected(index);
    }

    public final boolean isSelectionEmpty() {
        return this.getList().getSelectionCount() > 0;
    }

    public final void removeSelectionInterval(int index0, int index1) {
        this.getList().deselect(index0, index1);
    }

    public final void setCellRenderer(SWTCellRenderer renderer) {
        this.renderer = renderer;
        this.listViewer.refresh();
    }

    public final ListModel getModel() {
        return this.model;
    }

    public final void setModel(ListModel model) {
        if (this.model != null) {
            this.model.removeListDataListener(this);
        }
        this.model = model;
        this.listViewer.setInput((Object)model);
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
        model.addListDataListener(this);
    }

    public final void setListData(final Object[] listData) {
        this.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return listData[index];
            }

            @Override
            public int getSize() {
                return listData.length;
            }
        });
    }

    public final void setListData(final Vector listData) {
        this.setModel(new AbstractListModel(){

            @Override
            public Object getElementAt(int index) {
                return listData.get(index);
            }

            @Override
            public int getSize() {
                return listData.size();
            }
        });
    }

    public final ListSelectionModel getSelectionModel() {
        if (this.selectionModel == null) {
            this.setSelectionModel(new DefaultListSelectionModel());
        }
        return this.selectionModel;
    }

    public final void setSelectionModel(ListSelectionModel selectionModel) {
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this);
        }
        this.selectionModel = selectionModel;
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this);
            if ((this.getList().getStyle() & 2) != 0) {
                selectionModel.setSelectionMode(2);
            } else {
                selectionModel.setSelectionMode(0);
            }
        }
    }

    public final void setSelectedIndex(int index) {
        this.getList().setSelection(index);
    }

    public final void setSelectedIndices(int[] indices) {
        this.getList().setSelection(indices);
    }

    public final void setSelectedValue(Object value, boolean shouldScroll) {
        int index = this.getItemIndex(value);
        if (index < 0) {
            return;
        }
        this.getList().setSelection(index);
        if (shouldScroll) {
            this.getListViewer().reveal(value);
        }
    }

    public final void setSelectionInterval(int anchor, int lead) {
        this.getList().setSelection(anchor, lead);
    }

    public final void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.getSelectionModel().setValueIsAdjusting(valueIsAdjusting);
    }

    public final boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public final int getItemIndex(Object item) {
        Object[] elements = ((ListModelContentProvider)this.getListViewer().getContentProvider()).getElements(this.model);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.selectionModel != null) {
            List list = this.getList();
            this.ignoreSelectionChange = true;
            if (this.selectionModel.getSelectionMode() == 0) {
                int selectedIndex = list.getSelectionIndex();
                if (selectedIndex < 0) {
                    this.selectionModel.clearSelection();
                } else {
                    this.selectionModel.setSelectionInterval(selectedIndex, selectedIndex);
                }
            } else {
                this.selectionModel.setValueIsAdjusting(true);
                for (int i = 0; i < list.getItemCount(); ++i) {
                    boolean selected = list.isSelected(i);
                    if (this.selectionModel.isSelectedIndex(i) == selected) continue;
                    if (selected) {
                        this.selectionModel.addSelectionInterval(i, i);
                        continue;
                    }
                    this.selectionModel.removeSelectionInterval(i, i);
                }
                this.selectionModel.setValueIsAdjusting(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.selectionModel) {
            List list = this.getList();
            if (!this.ignoreSelectionChange) {
                try {
                    list.removeSelectionListener((SelectionListener)this);
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex() && i < list.getItemCount(); ++i) {
                        boolean selected = this.selectionModel.isSelectedIndex(i);
                        if (list.isSelected(i) == selected) continue;
                        if (selected) {
                            list.select(i);
                            continue;
                        }
                        list.deselect(i);
                    }
                }
                finally {
                    list.addSelectionListener((SelectionListener)this);
                }
            }
            this.ignoreSelectionChange = false;
            this.fireValueChanged(new ListSelectionEvent(this, e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting()));
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.listViewer.setInput((Object)this.model);
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.listViewer.setInput((Object)this.model);
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.listViewer.setInput((Object)this.model);
        if (this.selectionModel != null) {
            this.selectionModel.clearSelection();
        }
    }

    private class ListModelLabelProvider
    extends LabelProvider {
        private ListModelLabelProvider() {
        }

        public Image getImage(Object element) {
            if (SWTList.this.renderer == null) {
                return super.getImage(element);
            }
            return SWTList.this.renderer.getCellImage(element, SWTList.this.getItemIndex(element), 0);
        }

        public String getText(Object element) {
            if (SWTList.this.renderer == null) {
                return super.getText(element);
            }
            return SWTList.this.renderer.getCellText(element, SWTList.this.getItemIndex(element), 0);
        }
    }

    private class ListModelContentProvider
    implements IStructuredContentProvider {
        public Object[] cachedElements;

        private ListModelContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.cachedElements != null) {
                return this.cachedElements;
            }
            if (inputElement instanceof DefaultListModel) {
                DefaultListModel dlm = (DefaultListModel)inputElement;
                this.cachedElements = new Object[dlm.getSize()];
                dlm.copyInto(this.cachedElements);
            } else if (inputElement instanceof ListModel) {
                ListModel model = (ListModel)inputElement;
                this.cachedElements = new Object[model.getSize()];
                for (int i = 0; i < this.cachedElements.length; ++i) {
                    this.cachedElements[i] = model.getElementAt(i);
                }
            }
            return this.cachedElements;
        }

        public void dispose() {
            this.cachedElements = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.cachedElements = null;
        }
    }
}

