/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.awt.Dimension;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SWTComponent {
    public static final String KEY_PREFERRED_SIZE = "preferredSize";
    protected static final String KEY_SWT_COMPONENT = "SWTComponent";
    protected static final String KEY_COMPONENT_NAME = "name";
    protected Control control;
    protected EventListenerList eventListenerList = new EventListenerList();

    public SWTComponent(Control control) {
        this.control = control;
        control.setData(KEY_SWT_COMPONENT, (Object)this);
    }

    public final Control getControl() {
        return this.control;
    }

    public final Rectangle getBounds() {
        return this.control.getBounds();
    }

    public final int getHeight() {
        return this.control.getSize().y;
    }

    public final Point getLocation() {
        return this.control.getLocation();
    }

    public final Point getLocation(Point rv) {
        Point loc = this.control.getLocation();
        rv.x = loc.x;
        rv.y = loc.y;
        return rv;
    }

    public final Point getLocationOnScreen() {
        return this.control.toDisplay(0, 0);
    }

    public final String getName() {
        return (String)this.control.getData(KEY_COMPONENT_NAME);
    }

    public final SWTContainer getParent() {
        return (SWTContainer)SWTComponent.getSWTComponent((Control)this.control.getParent());
    }

    public final Dimension getSize() {
        Point dim = this.control.getSize();
        return new Dimension(dim.x, dim.y);
    }

    public final Dimension getSize(Dimension rv) {
        Point dim = this.control.getSize();
        rv.setSize(dim.x, dim.y);
        return rv;
    }

    public final int getWidth() {
        return this.control.getSize().x;
    }

    public final int getX() {
        return this.control.getLocation().x;
    }

    public final int getY() {
        return this.control.getLocation().y;
    }

    public final boolean hasFocus() {
        return this.control.isFocusControl();
    }

    public final boolean isEnabled() {
        return this.control.isEnabled();
    }

    public final boolean isOpaque() {
        return true;
    }

    public final boolean isShowing() {
        return this.control.isVisible();
    }

    public final boolean isVisible() {
        return this.control.isVisible();
    }

    public final void requestFocus() {
        this.control.setFocus();
    }

    public final void setBounds(int x, int y, int w, int h) {
        this.control.setBounds(x, y, w, h);
    }

    public final void setBounds(Rectangle r) {
        this.control.setBounds(r.x, r.y, r.width, r.height);
    }

    public final void setEnabled(boolean enabled) {
        this.control.setEnabled(enabled);
    }

    public final void setLocation(int x, int y) {
        this.control.setLocation(x, y);
    }

    public final void setLocation(Point p) {
        this.control.setLocation(p);
    }

    public final void setName(String name) {
        this.control.setData(KEY_COMPONENT_NAME, (Object)name);
    }

    public final void setSize(Dimension d) {
        this.control.setSize(d.width, d.height);
    }

    public final void setSize(int width, int height) {
        this.control.setSize(width, height);
    }

    public final void setVisible(boolean visible) {
        this.control.setVisible(visible);
    }

    public final void setPreferredSize(Dimension preferredSize) {
        this.getControl().setData(KEY_PREFERRED_SIZE, (Object)preferredSize);
    }

    public final Dimension getPreferredSize() {
        Dimension preferredSize = (Dimension)this.getControl().getData(KEY_PREFERRED_SIZE);
        if (preferredSize == null) {
            Point size = this.getControl().computeSize(-1, -1);
            preferredSize = new Dimension(size.x, size.y);
        }
        return preferredSize;
    }

    public final void transferFocus() {
        Composite parent = this.control.getParent();
        if (parent == null) {
            return;
        }
        Control[] focusOrder = parent.getTabList();
        for (int i = 0; i < focusOrder.length; ++i) {
            if (focusOrder[i] != this.control) continue;
            focusOrder[(i + 1) % focusOrder.length].setFocus();
            return;
        }
    }

    public static SWTComponent getSWTComponent(Control control) {
        return (SWTComponent)control.getData(KEY_SWT_COMPONENT);
    }
}

