/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt.swing2swt.components;

import com.dev63.hotel.swt.swing2swt.components.SWTComponent;
import com.dev63.hotel.swt.swing2swt.components.SWTContainer;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

public class SWTComboBox
extends SWTComponent
implements ListDataListener,
SelectionListener,
ItemSelectable {
    private ComboBoxModel model;
    private Action action = null;
    private String actionCommand = null;

    public SWTComboBox(Combo combo) {
        super((Control)combo);
        combo.addSelectionListener((SelectionListener)this);
    }

    public SWTComboBox(SWTContainer parent) {
        this(parent, new DefaultComboBoxModel());
    }

    public SWTComboBox(SWTContainer parent, ComboBoxModel model) {
        this(new Combo(parent.getComposite(), 2056));
        this.setModel(model);
    }

    public SWTComboBox(SWTContainer parent, Object[] items) {
        this(parent, new DefaultComboBoxModel<Object>(items));
    }

    public SWTComboBox(SWTContainer parent, Vector items) {
        this(parent, new DefaultComboBoxModel(items));
    }

    public final Combo getCombo() {
        return (Combo)this.getControl();
    }

    public final void setModel(ComboBoxModel model) {
        if (this.model != null) {
            this.model.removeListDataListener(this);
        }
        this.model = model;
        model.addListDataListener(this);
        this.refreshContent();
    }

    protected String getLabelForItem(Object item) {
        return item.toString();
    }

    private void refreshContent() {
        int selectionIndex = -1;
        String[] items = new String[this.model.getSize()];
        for (int i = 0; i < this.model.getSize(); ++i) {
            Object item = this.model.getElementAt(i);
            items[i] = this.getLabelForItem(item);
            if (!item.equals(this.model.getSelectedItem())) continue;
            selectionIndex = i;
        }
        this.getCombo().setItems(items);
        if (selectionIndex < 0) {
            this.getCombo().clearSelection();
        } else {
            this.getCombo().select(selectionIndex);
        }
    }

    public final ComboBoxModel getModel() {
        return this.model;
    }

    public final void addItem(Object item) {
        if (this.model instanceof MutableComboBoxModel) {
            ((MutableComboBoxModel)this.model).addElement(item);
        } else {
            this.getCombo().add(this.getLabelForItem(item));
        }
    }

    public final Object getItemAt(int index) {
        if (this.model == null) {
            return this.getCombo().getItem(index);
        }
        return this.model.getElementAt(index);
    }

    public final int getItemCount() {
        return this.getCombo().getItemCount();
    }

    public final int getSelectedIndex() {
        return this.getCombo().getSelectionIndex();
    }

    public final Object getSelectedItem() {
        if (this.model == null) {
            return this.getCombo().getText();
        }
        return this.model.getSelectedItem();
    }

    public final void insertItemAt(Object item, int index) {
        if (this.model instanceof MutableComboBoxModel) {
            ((MutableComboBoxModel)this.model).insertElementAt(item, index);
        } else {
            this.getCombo().add(this.getLabelForItem(item), index);
        }
    }

    public final boolean isEditable() {
        return (this.getCombo().getStyle() & 8) == 0;
    }

    public final void removeAllItems() {
        if (this.model instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.model).removeAllElements();
        } else if (this.model instanceof MutableComboBoxModel) {
            MutableComboBoxModel mcbm = (MutableComboBoxModel)this.model;
            while (mcbm.getSize() > 0) {
                mcbm.removeElementAt(0);
            }
        } else {
            this.getCombo().removeAll();
        }
    }

    public final void removeItem(Object item) {
        if (this.model instanceof MutableComboBoxModel) {
            ((MutableComboBoxModel)this.model).removeElement(item);
        } else {
            this.getCombo().remove(this.getLabelForItem(item));
        }
    }

    public final void removeItemAt(int index) {
        if (this.model instanceof MutableComboBoxModel) {
            ((MutableComboBoxModel)this.model).removeElementAt(index);
        } else {
            this.getCombo().remove(index);
        }
    }

    public final void setSelectedIndex(int index) {
        if (this.model == null) {
            this.getCombo().select(index);
        } else {
            this.model.setSelectedItem(this.model.getElementAt(index));
        }
    }

    public final void setSelectedItem(Object item) {
        if (this.model == null) {
            this.getCombo().setText(this.getLabelForItem(item));
        } else {
            this.model.setSelectedItem(item);
        }
    }

    public final void setAction(Action action) {
        this.action = action;
    }

    public final Action getAction() {
        return this.action;
    }

    public final void setActionCommand(String actionCommand) {
        this.actionCommand = actionCommand;
    }

    public final String getActionCommand() {
        return this.actionCommand;
    }

    public void addActionListener(ActionListener listener) {
        this.eventListenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.eventListenerList.remove(ActionListener.class, listener);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.eventListenerList.add(ItemListener.class, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.eventListenerList.remove(ItemListener.class, listener);
    }

    @Override
    public final Object[] getSelectedObjects() {
        return new Object[]{this.getSelectedItem()};
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.refreshContent();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.refreshContent();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.refreshContent();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        ActionEvent actionEvent = null;
        EventListener[] actionListeners = this.eventListenerList.getListeners(ActionListener.class);
        for (int i = 0; i < actionListeners.length; ++i) {
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this.actionCommand != null ? this.actionCommand : this.getCombo().getText());
            }
            ((ActionListener)actionListeners[i]).actionPerformed(actionEvent);
        }
        ItemEvent awtEvent = new ItemEvent(this, 701, this.getSelectedItem(), 1);
        EventListener[] itemListeners = this.eventListenerList.getListeners(ItemListener.class);
        for (int i = 0; i < itemListeners.length; ++i) {
            ((ItemListener)itemListeners[i]).itemStateChanged(awtEvent);
        }
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 1001, (String)this.action.getValue("Name")));
        }
    }
}

