/*
 * Decompiled with CFR 0.152.
 */
package com.dev63.hotel.swt;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SwingSamplePanel
extends JPanel
implements ListSelectionListener {
    private JList leftList;
    private JList rightList;
    private JButton selectButton;
    private JButton selectAllButton;
    private JButton deselectButton;
    private JButton deselectAllButton;
    private DefaultListModel leftListModel = new DefaultListModel();
    private DefaultListModel rightListModel = new DefaultListModel();

    public SwingSamplePanel() {
        JPanel content = new JPanel(new BorderLayout(5, 5));
        this.add(content);
        content.add("South", this.createButtonsPanel());
        content.add("Center", this.createSoshPanel());
        this.initContent();
    }

    protected JComponent createSoshPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        JPanel leftPanel = new JPanel(new BorderLayout(5, 5));
        leftPanel.add("North", new JLabel("Available items:"));
        this.leftList = new JList(this.leftListModel);
        this.leftList.setPreferredSize(new Dimension(100, 150));
        this.leftList.getSelectionModel().addListSelectionListener(this);
        leftPanel.add(new JScrollPane(this.leftList));
        mainPanel.add("West", leftPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        mainPanel.add(centerPanel);
        JPanel p1 = new JPanel();
        centerPanel.add("South", p1);
        JPanel p2 = new JPanel(new BorderLayout());
        p1.add(p2);
        JPanel buttonsPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        p2.add("North", buttonsPanel);
        this.selectButton = new JButton(">");
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedItems = SwingSamplePanel.this.leftList.getSelectedValues();
                for (int i = 0; i < selectedItems.length; ++i) {
                    SwingSamplePanel.this.rightListModel.addElement(selectedItems[i]);
                    SwingSamplePanel.this.leftListModel.removeElement(selectedItems[i]);
                    SwingSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.selectButton);
        this.selectAllButton = new JButton(">>");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] items = SwingSamplePanel.this.leftListModel.toArray();
                for (int i = 0; i < items.length; ++i) {
                    SwingSamplePanel.this.rightListModel.addElement(items[i]);
                    SwingSamplePanel.this.leftListModel.removeElement(items[i]);
                    SwingSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.selectAllButton);
        this.deselectButton = new JButton("<");
        this.deselectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] selectedItems = SwingSamplePanel.this.rightList.getSelectedValues();
                for (int i = 0; i < selectedItems.length; ++i) {
                    SwingSamplePanel.this.leftListModel.addElement(selectedItems[i]);
                    SwingSamplePanel.this.rightListModel.removeElement(selectedItems[i]);
                    SwingSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.deselectButton);
        this.deselectAllButton = new JButton("<<");
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] items = SwingSamplePanel.this.rightListModel.toArray();
                for (int i = 0; i < items.length; ++i) {
                    SwingSamplePanel.this.leftListModel.addElement(items[i]);
                    SwingSamplePanel.this.rightListModel.removeElement(items[i]);
                    SwingSamplePanel.this.updateButtonsState();
                }
            }
        });
        buttonsPanel.add(this.deselectAllButton);
        JPanel rightPanel = new JPanel(new BorderLayout(5, 5));
        rightPanel.add("North", new JLabel("Chosen items:"));
        this.rightList = new JList(this.rightListModel);
        this.rightList.setPreferredSize(new Dimension(100, 150));
        this.rightList.getSelectionModel().addListSelectionListener(this);
        rightPanel.add(new JScrollPane(this.rightList));
        mainPanel.add("East", rightPanel);
        this.updateButtonsState();
        return mainPanel;
    }

    protected JComponent createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add("North", new JSeparator());
        JPanel subPanel = new JPanel(new FlowLayout(2));
        buttonsPanel.add("Center", subPanel);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingSamplePanel.this.performOK();
            }
        });
        subPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingSamplePanel.this.performCancel();
            }
        });
        subPanel.add(cancelButton);
        return buttonsPanel;
    }

    protected void initContent() {
        for (int i = 0; i < 10; ++i) {
            this.leftListModel.addElement("Item " + (i + 1));
        }
        this.rightListModel.addElement("Item 11");
    }

    protected void performOK() {
    }

    protected void performCancel() {
    }

    private void updateButtonsState() {
        this.selectButton.setEnabled(!this.leftList.getSelectionModel().isSelectionEmpty());
        this.selectAllButton.setEnabled(!this.leftListModel.isEmpty());
        this.deselectButton.setEnabled(!this.rightList.getSelectionModel().isSelectionEmpty());
        this.deselectAllButton.setEnabled(!this.rightListModel.isEmpty());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.leftList.getSelectionModel() || e.getSource() == this.rightList.getSelectionModel()) {
            this.updateButtonsState();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(new SwingSamplePanel());
        frame.pack();
        frame.setVisible(true);
    }
}

