/*
 * Decompiled with CFR 0.152.
 */
import com.dev63.fiscal.fp550.PoreskaGrupa;
import com.dev63.restoran.model.Artikal;
import com.dev63.restoran.model.Atribut;
import com.dev63.restoran.model.GrupaOA;
import com.dev63.restoran.model.Knjizenje;
import com.dev63.restoran.model.Odeljenje;
import com.dev63.restoran.model.PodgrupaArtikala;
import com.dev63.restoran.model.Prijemnica;
import com.dev63.restoran.model.PrijemnicaStavka;
import com.dev63.restoran.model.StalniGost;
import com.dev63.restoran.model.StalniGostiGrupa;
import com.dev63.restoran.model.TipArtikla;
import com.dev63.restoran.model.TipPrijemnice;
import com.dev63.restoran.model.Trebovanje;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class TestDataBuilder {

    public static class ArtikalBuilder {
        private Artikal result;

        public void setPodgrupa(PodgrupaArtikala podgrupa) {
            this.result.setPodgrupa(podgrupa);
        }

        public void setName(String name) {
            this.result.setName(name);
        }

        public void setTip(TipArtikla tip) {
            this.result.setTip(tip);
        }

        public void setBarCode(String barCode) {
            this.result.setBarCode(barCode);
        }

        public void setJkl(String jkl) {
            this.result.setJkl(jkl);
        }

        public void setJedinicaMere(String jedinicaMere) {
            this.result.setJedinicaMere(jedinicaMere);
        }

        public void setPoreskaGrupa(PoreskaGrupa poreskaGrupa) {
            this.result.setPoreskaGrupa(poreskaGrupa);
        }

        public void setMinLager(Double minLager) {
            this.result.setMinLager(minLager);
        }

        public void setMera(Double mera) {
            this.result.setMera(mera);
        }

        public void setTrenutnaNV(Double trenutnaNV) {
            this.result.setTrenutnaNV(trenutnaNV);
        }

        public void setSkrNaziv(String skrNaziv) {
            this.result.setSkrNaziv(skrNaziv);
        }

        public void setSlika(String slika) {
            this.result.setSlika(slika);
        }

        public void setCena(Double cena) {
            this.result.setCena(cena);
        }

        public void setNijeDeoSlozenog(Boolean nijeDeoSlozenog) {
            this.result.setNijeDeoSlozenog(nijeDeoSlozenog);
        }

        public void setOdeljenjeNormativ(Odeljenje odeljenjeNormativ) {
            this.result.setOdeljenjeNormativ(odeljenjeNormativ);
        }

        public void setOdeljenja(List<Odeljenje> odeljenja) {
            this.result.setOdeljenja(odeljenja);
        }

        public void setJelo(Boolean jelo) {
            this.result.setJelo(jelo);
        }

        public void setPice(Boolean pice) {
            this.result.setPice(pice);
        }

        public void setBlokiran(Boolean blokiran) {
            this.result.setBlokiran(blokiran);
        }

        public void setPrioritet(Integer prioritet) {
            this.result.setPrioritet(prioritet);
        }

        public void setDozvoljenPopust(Boolean dozvoljenPopust) {
            this.result.setDozvoljenPopust(dozvoljenPopust);
        }

        public void setSifra(String sifra) {
            this.result.setSifra(sifra);
        }

        public void setOpisniAtributi(List<Atribut> opisniAtributi) {
            this.result.setOpisniAtributi(opisniAtributi);
        }

        public void setGrupeOA(List<GrupaOA> grupeOA) {
            this.result.setGrupeOA(grupeOA);
        }
    }

    public static class PrijemnicaStavkaBuilder {
        private final PrijemnicaStavka result = new PrijemnicaStavka();

        private PrijemnicaStavkaBuilder() {
        }

        public static PrijemnicaStavkaBuilder create() {
            return new PrijemnicaStavkaBuilder();
        }

        public PrijemnicaStavka build() {
            return this.result;
        }

        public PrijemnicaStavkaBuilder setArtikal(Artikal artikal) {
            this.result.setArtikal(artikal);
            return this;
        }

        public PrijemnicaStavkaBuilder setKolicina(Double kolicina) {
            this.result.setKolicina(kolicina);
            return this;
        }

        public PrijemnicaStavkaBuilder setVrednost(Double vrednost) {
            this.result.setVrednost(vrednost);
            return this;
        }

        public PrijemnicaStavkaBuilder setKomad(Double komad) {
            this.result.setKomad(komad);
            return this;
        }

        public PrijemnicaStavkaBuilder setPdvStopa(Double pdvStopa) {
            this.result.setPdvStopa(pdvStopa);
            return this;
        }

        public PrijemnicaStavkaBuilder setRedniBroj(Integer redniBroj) {
            this.result.setRedniBroj(redniBroj);
            return this;
        }

        public PrijemnicaStavkaBuilder setKomadSPDV(Double komadSPDV) {
            this.result.setKomadSPDV(komadSPDV);
            return this;
        }

        public PrijemnicaStavkaBuilder setVrednostSPDV(Double vrednostSPDV) {
            this.result.setVrednostSPDV(vrednostSPDV);
            return this;
        }

        public PrijemnicaStavkaBuilder setPrijemnica(Prijemnica prijemnica) {
            this.result.setPrijemnica(prijemnica);
            return this;
        }
    }

    public static class PrijemnicaBuilder {
        private final Prijemnica result = new Prijemnica();

        private PrijemnicaBuilder() {
        }

        public static PrijemnicaBuilder create() {
            return new PrijemnicaBuilder();
        }

        public PrijemnicaBuilder setBrPrijemnice(String brPrijemnice) {
            this.result.setBrPrijemnice(brPrijemnice);
            return this;
        }

        public PrijemnicaBuilder setDobavljac(StalniGost dobavljac) {
            this.result.setDobavljac(dobavljac);
            return this;
        }

        public PrijemnicaBuilder setDatumUnosa(Date datumUnosa) {
            this.result.setDatumUnosa(datumUnosa);
            return this;
        }

        public PrijemnicaBuilder setDatumPrijemnice(Date datumPrijemnice) {
            this.result.setDatumPrijemnice(datumPrijemnice);
            return this;
        }

        public PrijemnicaBuilder setUname(String uname) {
            this.result.setUname(uname);
            return this;
        }

        public PrijemnicaBuilder addStavka(PrijemnicaStavka stavka) {
            if (this.result.getStavke() == null) {
                this.result.setStavke(new LinkedList<PrijemnicaStavka>());
            }
            if (stavka != null) {
                stavka.setPrijemnica(this.result);
            }
            this.result.getStavke().add(stavka);
            return this;
        }

        public PrijemnicaBuilder setOpis(String opis) {
            this.result.setOpis(opis);
            return this;
        }

        public PrijemnicaBuilder setTotal(Double total) {
            this.result.setTotal(total);
            return this;
        }

        public PrijemnicaBuilder setCrno(Boolean crno) {
            this.result.setCrno(crno);
            return this;
        }

        public PrijemnicaBuilder setTip(TipPrijemnice tip) {
            this.result.setTip(tip);
            return this;
        }

        public PrijemnicaBuilder setTrebovanje(Trebovanje trebovanje) {
            this.result.setTrebovanje(trebovanje);
            return this;
        }

        public PrijemnicaBuilder addKnjizenje(Knjizenje knjizenje) {
            if (this.result.getKnjizenja() == null) {
                this.result.setKnjizenja(new LinkedList<Knjizenje>());
            }
            if (knjizenje != null) {
                knjizenje.setPrijemnica(this.result);
                knjizenje.setRacun(null);
                knjizenje.setTrebovanje(null);
                knjizenje.setTrosak(null);
            }
            this.result.getKnjizenja().add(knjizenje);
            return this;
        }
    }

    public static class StalniGostiGrupaBuilder {
        private final StalniGostiGrupa result = new StalniGostiGrupa();

        private StalniGostiGrupaBuilder() {
        }

        public static StalniGostiGrupaBuilder create() {
            return new StalniGostiGrupaBuilder();
        }

        public StalniGostiGrupa build() {
            return this.result;
        }

        public void naziv(String naziv) {
            this.result.setNaziv(naziv);
        }

        public void setPreduzece(Boolean preduzece) {
            this.result.setPreduzece(preduzece);
        }

        public void addStalniGost(StalniGost stalniGost) {
            if (this.result.getStalniGosti() == null) {
                this.result.setStalniGosti(new LinkedList<StalniGost>());
            }
            if (stalniGost != null) {
                stalniGost.setGrupa(this.result);
            }
            this.result.getStalniGosti().add(stalniGost);
        }
    }

    public static class StalniGostBuilder {
        private final StalniGost result = new StalniGost();

        private StalniGostBuilder() {
            this.result.setBlokiran(false);
        }

        public static StalniGostBuilder create() {
            return new StalniGostBuilder();
        }

        public StalniGost build() {
            return this.result;
        }

        public StalniGostBuilder blokiran(boolean blokiran) {
            this.result.setBlokiran(blokiran);
            return this;
        }

        public StalniGostBuilder sifra(String sifra) {
            this.result.setSifra(sifra);
            return this;
        }

        public StalniGostBuilder naziv(String naziv) {
            this.result.setNaziv(naziv);
            return this;
        }

        public StalniGostBuilder skrNaziv(String skrNaziv) {
            this.result.setSkrNaziv(skrNaziv);
            return this;
        }

        public StalniGostBuilder liceZaKontakt(String liceZaKontakt) {
            this.result.setLiceZaKontakt(liceZaKontakt);
            return this;
        }

        public StalniGostBuilder adresa(String adersa) {
            this.result.setAdersa(adersa);
            return this;
        }

        public StalniGostBuilder pib(String pib) {
            this.result.setPib(pib);
            return this;
        }

        public StalniGostBuilder mesto(String mesto) {
            this.result.setMesto(mesto);
            return this;
        }

        public StalniGostBuilder telefon(String telefon) {
            this.result.setTelefon(telefon);
            return this;
        }

        public StalniGostBuilder fax(String fax) {
            this.result.setFax(fax);
            return this;
        }

        public StalniGostBuilder mob(String mob) {
            this.result.setMob(mob);
            return this;
        }

        public StalniGostBuilder email(String email) {
            this.result.setEmail(email);
            return this;
        }

        public StalniGostBuilder web(String web) {
            this.result.setWeb(web);
            return this;
        }

        public StalniGostBuilder maticniBroj(String maticniBroj) {
            this.result.setMaticniBroj(maticniBroj);
            return this;
        }

        public StalniGostBuilder sifraDelatnosti(String sifraDelatnosti) {
            this.result.setSifraDelatnosti(sifraDelatnosti);
            return this;
        }

        public StalniGostBuilder tekuciRacun1(String tekuciRacun1) {
            this.result.setTekuciRacun1(tekuciRacun1);
            return this;
        }

        public StalniGostBuilder tekuciRacun2(String tekuciRacun2) {
            this.result.setTekuciRacun2(tekuciRacun2);
            return this;
        }

        public StalniGostBuilder tekuciRacun3(String tekuciRacun3) {
            this.result.setTekuciRacun3(tekuciRacun3);
            return this;
        }

        public StalniGostBuilder banka1(String banka1) {
            this.result.setBanka1(banka1);
            return this;
        }

        public StalniGostBuilder banka2(String banka2) {
            this.result.setBanka2(banka2);
            return this;
        }

        public StalniGostBuilder banka3(String banka3) {
            this.result.setBanka3(banka3);
            return this;
        }

        public StalniGostBuilder pretplata(Double pretplata) {
            this.result.setPretplata(pretplata);
            return this;
        }

        public StalniGostBuilder popust(Double popust) {
            this.result.setPopust(popust);
            return this;
        }

        public StalniGostBuilder napomena(String napomena) {
            this.result.setNapomena(napomena);
            return this;
        }

        public StalniGostBuilder valutaPlacanja(Integer valutaPlacanja) {
            this.result.setValutaPlacanja(valutaPlacanja);
            return this;
        }

        public StalniGostBuilder brlk(String brlk) {
            this.result.setBrlk(brlk);
            return this;
        }

        public StalniGostBuilder jmbg(String jmbg) {
            this.result.setJmbg(jmbg);
            return this;
        }

        public StalniGostBuilder poreskiObveznik(Boolean poreskiObveznik) {
            this.result.setPoreskiObveznik(poreskiObveznik);
            return this;
        }

        public StalniGostBuilder regBrUSudu(String regBrUSudu) {
            this.result.setRegBrUSudu(regBrUSudu);
            return this;
        }

        public StalniGostBuilder dobavljac(Boolean dobavljac) {
            this.result.setDobavljac(dobavljac);
            return this;
        }

        public StalniGostBuilder stampaPregleda(Boolean stampaPregleda) {
            this.result.setStampaPregleda(stampaPregleda);
            return this;
        }

        public StalniGostBuilder brojKopijaPregleda(Integer brojKopijaPregleda) {
            this.result.setBrojKopijaPregleda(brojKopijaPregleda);
            return this;
        }

        public StalniGostBuilder nacinPlacanja(String nacinPlacanja) {
            this.result.setNacinPlacanja(nacinPlacanja);
            return this;
        }

        public StalniGostBuilder oznakaSobe(String oznakaSobe) {
            this.result.setOznakaSobe(oznakaSobe);
            return this;
        }

        public StalniGostBuilder grupa(StalniGostiGrupa grupa) {
            this.result.setGrupa(grupa);
            if (grupa != null && grupa.getStalniGosti() != null && !grupa.getStalniGosti().contains(this.result)) {
                grupa.getStalniGosti().add(this.result);
            }
            return this;
        }

        public static StalniGost sampleKalkulacijaBA() {
            return StalniGostBuilder.create().adresa("KARA\u0110OR\u0110EVA BB").mesto("DVOROVI").naziv("TRIMIX D.O.O. DVOROVI").build();
        }
    }
}

