/*
 * Decompiled with CFR 0.152.
 */
package Stampa.test;

import Stampa.core.IPrintHandler;
import Stampa.core.ImageCache;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PrintHandler
implements IPrintHandler {
    private FontData fCell = new FontData();
    private boolean pHorLines = false;
    private boolean pVerLines = false;

    public PrintHandler() {
        this.fCell.setStyle(0);
        this.fCell.setHeight(10);
    }

    public PrintHandler(int cellFontHeight, boolean printHorLines, boolean printVerLines) {
        this.fCell.setStyle(0);
        this.fCell.setHeight(cellFontHeight);
        this.pHorLines = printHorLines;
        this.pVerLines = printVerLines;
    }

    @Override
    public Image getActivePrintLogo() {
        return this.getDefaultPrintLogo();
    }

    @Override
    public FontData getCellFontData() {
        return this.fCell;
    }

    @Override
    public Image getDefaultPrintLogo() {
        return ImageCache.getImage("chart48.png");
    }

    @Override
    public String getFooterText() {
        return "";
    }

    @Override
    public FontData getHeaderFontData() {
        return Display.getDefault().getSystemFont().getFontData()[0];
    }

    @Override
    public Image getImage(String fileName) {
        return ImageCache.getImage(fileName);
    }

    @Override
    public String getPrintJobName() {
        return "Print Job Name";
    }

    @Override
    public Image getPrintPreviewShellIcon() {
        return ImageCache.getImage("chart16.png");
    }

    @Override
    public boolean isPrintColumnHeaders() {
        return true;
    }

    @Override
    public boolean isPrintHorizontalLines() {
        return this.pHorLines;
    }

    @Override
    public boolean isPrintRowHeaders() {
        return false;
    }

    @Override
    public boolean isPrintVerticalLines() {
        return this.pVerLines;
    }
}

