/*
 * Decompiled with CFR 0.152.
 */
package Stampa.core;

import Stampa.core.IPrintHandler;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintJob;
import org.eclipse.nebula.paperclips.widgets.PrintPreview;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class PrintPreviewDialog {
    private PrintJob _printJob;
    private Shell _shell;
    private Button _previousPage;
    private Label _pageNumber;
    private Button _nextPage;
    private ScrolledComposite _scroll;
    private PrintPreview _preview;
    private double[] _scrollingPosition;
    private Print _print;
    private Shell _parentShell;
    private String _printJobName;
    private IPrintHandler _fetcher;
    private Image _shellImage;

    public PrintPreviewDialog(Print print, Shell parentShell, IPrintHandler fetcher) {
        this._print = print;
        this._parentShell = parentShell;
        this._printJobName = fetcher.getPrintJobName();
        this._fetcher = fetcher;
        this._shellImage = fetcher.getPrintPreviewShellIcon();
    }

    public Shell open() throws Exception {
        this._printJob = new PrintJob(this._printJobName, this._print).setMargins(36).setOrientation(512);
        this._shell = new Shell(this._parentShell, 1264);
        this._shell.setImage(this._shellImage);
        this._shell.setText("Print Preview");
        this._shell.setBounds(100, 100, 800, 600);
        this._shell.setLayout((Layout)new GridLayout(1, false));
        this.createButtonPanel((Composite)this._shell).setLayoutData((Object)new GridData(4, 4, true, false));
        this.createScrollingPreview((Composite)this._shell).setLayoutData((Object)new GridData(4, 4, true, true));
        this._preview.setPrintJob(this._printJob);
        this.updatePreviewSize();
        this.updatePageNumber();
        this._shell.setVisible(true);
        return this._shell;
    }

    private Control createButtonPanel(Composite parent) throws Exception {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(16, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this._previousPage = this.createIconButton(composite, "previous_page.gif", "Previous Page", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.setPreviewPageIndex(PrintPreviewDialog.this._preview.getPageIndex() - PrintPreviewDialog.this._preview.getHorizontalPageCount() * PrintPreviewDialog.this._preview.getVerticalPageCount());
            }
        });
        this._pageNumber = new Label(composite, 0);
        this._nextPage = this.createIconButton(composite, "next_page.gif", "Next Page", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.setPreviewPageIndex(PrintPreviewDialog.this._preview.getPageIndex() + PrintPreviewDialog.this._preview.getHorizontalPageCount() * PrintPreviewDialog.this._preview.getVerticalPageCount());
            }
        });
        this.createIconButton(composite, "fit_horizontal.png", "Fit Width", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._preview.setFitHorizontal(true);
                PrintPreviewDialog.this._preview.setFitVertical(false);
                PrintPreviewDialog.this.rememberScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.restoreScrollingPosition();
            }
        });
        this.createIconButton(composite, "fit_vertical.png", "Fit Height", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._preview.setFitVertical(true);
                PrintPreviewDialog.this._preview.setFitHorizontal(false);
                PrintPreviewDialog.this.rememberScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.restoreScrollingPosition();
            }
        });
        this.createIconButton(composite, "fit_best.png", "Fit Window", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._preview.setFitVertical(true);
                PrintPreviewDialog.this._preview.setFitHorizontal(true);
                PrintPreviewDialog.this.rememberScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.restoreScrollingPosition();
            }
        });
        this.createIconButton(composite, "zoom_in.gif", "Zoom In", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.setPreviewScale(PrintPreviewDialog.this._preview.getAbsoluteScale() * 1.1f);
            }
        });
        this.createIconButton(composite, "zoom_out.gif", "Zoom Out", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.setPreviewScale(PrintPreviewDialog.this._preview.getAbsoluteScale() / 1.1f);
            }
        });
        this.createIconButton(composite, "zoom_scale.gif", "Zoom to Scale", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this.setPreviewScale(1.0f);
            }
        });
        this.createTextButton(composite, "Port", "Portrait Orientation", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._printJob.setOrientation(512);
                PrintPreviewDialog.this._preview.setPrintJob(PrintPreviewDialog.this._printJob);
                PrintPreviewDialog.this.forgetScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.updatePageNumber();
            }
        });
        this.createTextButton(composite, "Land", "Landscape Orientation", new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._printJob.setOrientation(256);
                PrintPreviewDialog.this._preview.setPrintJob(PrintPreviewDialog.this._printJob);
                PrintPreviewDialog.this.forgetScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.updatePageNumber();
            }
        });
        this.createIconButton(composite, "print.gif", "Print", new Listener(){

            public void handleEvent(Event event) {
                PrintDialog dialog = new PrintDialog(PrintPreviewDialog.this._shell, 0);
                PrinterData printerData = dialog.open();
                if (printerData != null) {
                    PaperClips.print((PrintJob)PrintPreviewDialog.this._printJob, (PrinterData)printerData);
                    PrintPreviewDialog.this._preview.setPrinterData(printerData);
                }
            }
        });
        this.createLabel(composite, "Horz Pages");
        this.createPageCountSpinner(composite, new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._preview.setHorizontalPageCount(((Spinner)event.widget).getSelection());
                PrintPreviewDialog.this.forgetScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.updatePageNumber();
            }
        });
        this.createLabel(composite, "Vert Pages");
        this.createPageCountSpinner(composite, new Listener(){

            public void handleEvent(Event event) {
                PrintPreviewDialog.this._preview.setVerticalPageCount(((Spinner)event.widget).getSelection());
                PrintPreviewDialog.this.forgetScrollingPosition();
                PrintPreviewDialog.this.updatePreviewSize();
                PrintPreviewDialog.this.updatePageNumber();
            }
        });
        return composite;
    }

    private Control createScrollingPreview(Composite parent) throws Exception {
        this._scroll = new ScrolledComposite(parent, 2816);
        this._scroll.setExpandHorizontal(true);
        this._scroll.setExpandVertical(true);
        this._preview = new PrintPreview((Composite)this._scroll, 0);
        this._scroll.setContent((Control)this._preview);
        this._scroll.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = PrintPreviewDialog.this._scroll.getClientArea();
                PrintPreviewDialog.this._scroll.getHorizontalBar().setPageIncrement(bounds.width * 2 / 3);
                PrintPreviewDialog.this._scroll.getVerticalBar().setPageIncrement(bounds.height * 2 / 3);
                if (PrintPreviewDialog.this._preview.isFitHorizontal() ^ PrintPreviewDialog.this._preview.isFitVertical()) {
                    PrintPreviewDialog.this.rememberScrollingPosition();
                    PrintPreviewDialog.this.updatePreviewSize();
                    PrintPreviewDialog.this.restoreScrollingPosition();
                }
            }
        });
        this._preview.setFitVertical(true);
        this._preview.setFitHorizontal(true);
        Listener dragListener = new Listener(){
            private final Point dpi = Display.getDefault().getDPI();
            private boolean scrollable = false;
            private boolean dragging = false;
            private Point dragStartScrollOrigin = null;
            private Point dragStartMouseAnchor = null;

            public void handleEvent(Event event) {
                try {
                    switch (event.type) {
                        case 11: {
                            PrintPreviewDialog.this.forgetScrollingPosition();
                            Rectangle bounds = PrintPreviewDialog.this._scroll.getClientArea();
                            Point size = PrintPreviewDialog.this._preview.getSize();
                            boolean bl = this.scrollable = size.x > bounds.width || size.y > bounds.height;
                            if (this.scrollable || !this.dragging) break;
                            this.endDragging();
                            break;
                        }
                        case 3: {
                            PrintPreviewDialog.this.forgetScrollingPosition();
                            if (!this.scrollable || event.button != 1) break;
                            this.beginDragging(event);
                            break;
                        }
                        case 5: {
                            if (!this.dragging) break;
                            PrintPreviewDialog.this.forgetScrollingPosition();
                            Point point = PrintPreviewDialog.this._preview.toDisplay(event.x, event.y);
                            PrintPreviewDialog.this._scroll.setOrigin(this.dragStartScrollOrigin.x + this.dragStartMouseAnchor.x - point.x, this.dragStartScrollOrigin.y + this.dragStartMouseAnchor.y - point.y);
                            break;
                        }
                        case 4: {
                            PrintPreviewDialog.this.forgetScrollingPosition();
                            if (!this.dragging) break;
                            this.endDragging();
                            break;
                        }
                        case 6: {
                            Display.getDefault().addFilter(37, (Listener)this);
                            break;
                        }
                        case 37: {
                            if (event.count == 0) break;
                            if (this.scrollable && !this.dragging && (event.stateMask == 0 || event.stateMask == 131072)) {
                                int direction;
                                PrintPreviewDialog.this.forgetScrollingPosition();
                                Rectangle bounds = PrintPreviewDialog.this._scroll.getClientArea();
                                Point size = PrintPreviewDialog.this._preview.getSize();
                                Point origin = PrintPreviewDialog.this._scroll.getOrigin();
                                int n = direction = event.count > 0 ? -1 : 1;
                                if (size.y > bounds.height && event.stateMask == 0) {
                                    origin.y += direction * Math.min(this.dpi.y, bounds.height / 4);
                                } else if (size.x > bounds.width) {
                                    origin.x += direction * Math.min(this.dpi.x, bounds.width / 4);
                                }
                                PrintPreviewDialog.this._scroll.setOrigin(origin);
                                event.doit = false;
                                break;
                            }
                            if (event.stateMask != 262144) break;
                            float scale = PrintPreviewDialog.this._preview.getAbsoluteScale();
                            PrintPreviewDialog.this.setPreviewScale(event.count > 0 ? scale * 1.1f : scale / 1.1f);
                            break;
                        }
                        case 7: {
                            Display.getDefault().removeFilter(37, (Listener)this);
                        }
                    }
                }
                catch (Exception err) {
                    err.printStackTrace();
                }
                catch (Error err) {
                    err.printStackTrace();
                }
            }

            private void beginDragging(Event event) {
                this.dragStartScrollOrigin = PrintPreviewDialog.this._scroll.getOrigin();
                this.dragStartMouseAnchor = PrintPreviewDialog.this._preview.toDisplay(event.x, event.y);
                this.dragging = true;
            }

            private void endDragging() {
                this.dragging = false;
                this.dragStartMouseAnchor = null;
                this.dragStartScrollOrigin = null;
            }
        };
        this._scroll.addListener(11, dragListener);
        this._preview.addListener(3, dragListener);
        this._preview.addListener(5, dragListener);
        this._preview.addListener(4, dragListener);
        this._preview.addListener(6, dragListener);
        this._preview.addListener(7, dragListener);
        return this._scroll;
    }

    private Button createIconButton(Composite parent, String imageFilename, String toolTipText, Listener selectionListener) {
        Button button = this.createButton(parent, toolTipText, selectionListener);
        button.setImage(this.createImage(imageFilename));
        return button;
    }

    private Button createTextButton(Composite parent, String text, String toolTipText, Listener selectionListener) {
        Button button = this.createButton(parent, toolTipText, selectionListener);
        button.setText(text);
        return button;
    }

    private Button createButton(Composite parent, String toolTipText, Listener selectionListener) {
        Button button = new Button(parent, 8);
        button.setToolTipText(toolTipText);
        button.setLayoutData((Object)new GridData(4, 4, false, false));
        button.addListener(13, selectionListener);
        return button;
    }

    private Spinner createPageCountSpinner(Composite parent, Listener selectionListener) {
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setMinimum(1);
        spinner.setMaximum(99);
        spinner.addListener(13, selectionListener);
        return spinner;
    }

    private void createLabel(Composite parent, String text) {
        new Label(parent, 0).setText(text);
    }

    private Image createImage(String filename) {
        return this._fetcher.getImage(filename);
    }

    private void updatePageNumber() {
        int pageIndex = this._preview.getPageIndex();
        int pageCount = this._preview.getPageCount();
        int visiblePageCount = this._preview.getHorizontalPageCount() * this._preview.getVerticalPageCount();
        String text = (visiblePageCount > 1 ? "Pages " + (pageIndex + 1) + "-" + Math.min(pageCount, pageIndex + visiblePageCount) : "Page " + (pageIndex + 1)) + " of " + pageCount;
        this._pageNumber.setText(text);
        this._previousPage.setEnabled(pageIndex > 0);
        this._nextPage.setEnabled(pageIndex < pageCount - visiblePageCount);
        this._shell.layout(new Control[]{this._pageNumber});
    }

    private void rememberScrollingPosition() {
        Point size = this._preview.getSize();
        if (size.x == 0 || size.y == 0) {
            this.forgetScrollingPosition();
        } else if (this._scrollingPosition == null) {
            Point origin = this._scroll.getOrigin();
            this._scrollingPosition = new double[]{(double)origin.x / (double)size.x, (double)origin.y / (double)size.y};
        }
    }

    private void forgetScrollingPosition() {
        this._scrollingPosition = null;
    }

    private void restoreScrollingPosition() {
        if (this._scrollingPosition != null) {
            Point size = this._preview.getSize();
            this._scroll.setOrigin((int)Math.round(this._scrollingPosition[0] * (double)size.x), (int)Math.round(this._scrollingPosition[1] * (double)size.y));
        }
    }

    private void updatePreviewSize() {
        Rectangle bounds = this._scroll.getClientArea();
        Point minSize = this._preview.isFitHorizontal() ? (this._preview.isFitVertical() ? new Point(0, 0) : new Point(0, this._preview.computeSize((int)bounds.width, (int)-1).y)) : (this._preview.isFitVertical() ? new Point(this._preview.computeSize((int)-1, (int)bounds.height).x, 0) : this._preview.computeSize(-1, -1));
        this._scroll.setMinSize(minSize);
    }

    private void setPreviewScale(float scale) {
        this._preview.setFitVertical(false);
        this._preview.setFitHorizontal(false);
        this._preview.setScale(scale);
        this.rememberScrollingPosition();
        this.updatePreviewSize();
        this.restoreScrollingPosition();
    }

    private void setPreviewPageIndex(int pageIndex) {
        this._preview.setPageIndex(Math.max(Math.min(pageIndex, this._preview.getPageCount() - 1), 0));
        this.updatePageNumber();
    }
}

