/*
 * Decompiled with CFR 0.152.
 */
package com.github.anastaciocintra.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIpOutputStream
extends PipedOutputStream {
    protected final PipedInputStream pipedInputStream = new PipedInputStream();
    protected final Thread threadPrint;

    public TcpIpOutputStream(String host, int port) throws IOException {
        super.connect(this.pipedInputStream);
        Thread.UncaughtExceptionHandler uncaughtException = (t, e) -> Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
        Runnable runnablePrint = () -> {
            try (Socket socket = new Socket(host, port);){
                int n;
                OutputStream outputStream = socket.getOutputStream();
                byte[] buf = new byte[1024];
                while ((n = this.pipedInputStream.read(buf)) >= 0) {
                    outputStream.write(buf, 0, n);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
        this.threadPrint = new Thread(runnablePrint);
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
        this.threadPrint.start();
    }

    public TcpIpOutputStream(String host) throws IOException {
        this(host, 9100);
    }

    public void setUncaughtException(Thread.UncaughtExceptionHandler uncaughtException) {
        this.threadPrint.setUncaughtExceptionHandler(uncaughtException);
    }
}

