/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.api.model.AuditPackage;
import com.dmi.sdccore.api.model.TaxRate;
import com.dmi.sdccore.api.model.TaxRateCategory;
import com.dmi.sdccore.api.model.TaxRateCategoryType;
import com.dmi.sdccore.api.model.TaxRateGroup;
import com.dmi.sdccore.api.model.invoice.Invoice;
import com.dmi.sdccore.api.model.invoice.InvoiceItem;
import com.dmi.sdccore.api.model.invoice.InvoiceRequest;
import com.dmi.sdccore.api.model.invoice.InvoiceResult;
import com.dmi.sdccore.api.model.invoice.InvoiceResultTaxItem;
import com.dmi.sdccore.api.model.invoice.InvoiceTransactionType;
import com.dmi.sdccore.api.model.invoice.InvoiceType;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.model.TaxCardCertificateSubject;
import com.dmi.sdccore.model.invoice.CalculatedInvoice;
import com.dmi.sdccore.model.invoice.CalculatedTaxCategoryAmount;
import com.dmi.sdccore.model.invoice.CalculatedTaxRateAmount;
import com.dmi.sdccore.model.invoice.SignInvoiceResponse;
import com.dmi.sdccore.utils.ApduUtil;
import com.dmi.sdccore.utils.CryptoUtil;
import com.google.gson.GsonBuilder;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import javax.crypto.SecretKey;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaxUtil {
    private static final Logger logger = LogManager.getLogger(TaxUtil.class);
    public static final RoundingMode TAX_ROUNDING_MODE = RoundingMode.HALF_UP;
    public static final MathContext MC_TAX_CALC = new MathContext(64, TAX_ROUNDING_MODE);
    public static final int TAX_DECIMALS = 4;
    public static final int PRINT_DECIMALS = 2;
    public static final BigDecimal DECIMAL_10K = new BigDecimal(10000);
    public static final BigDecimal DECIMAL_100 = new BigDecimal(100);
    public static final int VAT_CATEGORY_ORDER_ID = 6;

    public static BigDecimal round(BigDecimal value, int decimals, RoundingMode roundingMode) {
        return value.setScale(decimals, roundingMode);
    }

    public static BigDecimal round(BigDecimal value) {
        return TaxUtil.round(value, 4, TAX_ROUNDING_MODE);
    }

    public static BigDecimal round(BigDecimal value, int decimals) {
        return TaxUtil.round(value, decimals, TAX_ROUNDING_MODE);
    }

    public static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        return dividend.divide(divisor, MC_TAX_CALC);
    }

    public static BigDecimal toDecimalTaxAmount(long amountLong) {
        return TaxUtil.divide(new BigDecimal(amountLong), DECIMAL_10K);
    }

    public static TaxRateGroup getTaxRateGroup(List<TaxRateGroup> allGroups, ZonedDateTime currentDateTime) {
        if (allGroups == null) {
            return null;
        }
        Comparator<TaxRateGroup> comparatorValidFrom = Comparator.comparing(TaxRateGroup::getValidFrom).reversed();
        Comparator<TaxRateGroup> comparatorGroupId = Comparator.comparing(TaxRateGroup::getGroupId).reversed();
        Comparator<TaxRateGroup> comparator = comparatorValidFrom.thenComparing(comparatorGroupId);
        return allGroups.stream().filter(trg -> !trg.getValidFrom().isAfter(currentDateTime)).min(comparator).orElse(null);
    }

    public static TaxRateGroup getCurrentTaxRateGroup(List<TaxRateGroup> allGroups) {
        return TaxUtil.getTaxRateGroup(allGroups, ZonedDateTime.now(ZoneId.of("UTC")));
    }

    public static TaxRate getTaxRateByLabel(String label, TaxRateGroup taxRateGroup) {
        for (TaxRateCategory taxRateCategory : taxRateGroup.getTaxCategories()) {
            for (TaxRate taxRate : taxRateCategory.getTaxRates()) {
                if (!label.equalsIgnoreCase(taxRate.getLabel())) continue;
                return taxRate;
            }
        }
        return null;
    }

    public static TaxRateCategory getTaxRateCategoryByLabel(String label, TaxRateGroup taxRateGroup) {
        for (TaxRateCategory taxRateCategory : taxRateGroup.getTaxCategories()) {
            for (TaxRate taxRate : taxRateCategory.getTaxRates()) {
                if (!label.equalsIgnoreCase(taxRate.getLabel())) continue;
                return taxRateCategory;
            }
        }
        return null;
    }

    private static List<TaxRate> getTaxRatesFromLabelsByCategory(List<String> labels, TaxRateCategoryType categoryType, TaxRateGroup taxRateGroup) {
        ArrayList<TaxRate> taxRates = new ArrayList<TaxRate>();
        for (String label : labels) {
            TaxRateCategory taxRateCategory = TaxUtil.getTaxRateCategoryByLabel(label, taxRateGroup);
            if (!categoryType.equals((Object)taxRateCategory.getCategoryType())) continue;
            TaxRate taxRate = TaxUtil.getTaxRateByLabel(label, taxRateGroup);
            taxRates.add(taxRate);
        }
        return taxRates;
    }

    public static CalculatedInvoice calculateInvoice(InvoiceRequest invoiceRequest, TaxRateGroup taxRateGroup) {
        CalculatedInvoice calculatedInvoice = new CalculatedInvoice();
        List<InvoiceItem> invoiceItems = invoiceRequest.getItems();
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        for (InvoiceItem invoiceItem : invoiceItems) {
            invoiceAmount = invoiceAmount.add(invoiceItem.getTotalAmount());
        }
        calculatedInvoice.setInvoiceAmount(invoiceAmount);
        List<CalculatedTaxRateAmount> calculatedTaxRateAmounts = TaxUtil.createTaxRateAmounts(invoiceItems, taxRateGroup);
        for (InvoiceItem invoiceItem : invoiceItems) {
            CalculatedTaxRateAmount calculatedTaxRateAmount;
            BigDecimal taxAmount;
            List<String> invoiceItemLabels = invoiceItem.getLabels();
            List<TaxRate> taxOnNetRates = TaxUtil.getTaxRatesFromLabelsByCategory(invoiceItemLabels, TaxRateCategoryType.TaxOnNet, taxRateGroup);
            List<TaxRate> taxOnTotalRates = TaxUtil.getTaxRatesFromLabelsByCategory(invoiceItemLabels, TaxRateCategoryType.TaxOnTotal, taxRateGroup);
            List<TaxRate> amountPerQuantityRates = TaxUtil.getTaxRatesFromLabelsByCategory(invoiceItemLabels, TaxRateCategoryType.AmountPerQuantity, taxRateGroup);
            BigDecimal itemTotalAmount = invoiceItem.getTotalAmount();
            if (!amountPerQuantityRates.isEmpty()) {
                BigDecimal amountPerQuantityTotalTaxAmount = BigDecimal.ZERO;
                for (TaxRate amountPerQuantityTaxRate : amountPerQuantityRates) {
                    BigDecimal amountPerQuantityTaxAmount = invoiceItem.getQuantity().multiply(amountPerQuantityTaxRate.getRate());
                    CalculatedTaxRateAmount calculatedTaxRateAmount2 = calculatedTaxRateAmounts.stream().filter(ctra -> amountPerQuantityTaxRate.getLabel().equals(ctra.getTaxRate().getLabel())).findAny().orElse(null);
                    if (calculatedTaxRateAmount2 != null && BigDecimal.ZERO.equals(calculatedTaxRateAmount2.getTaxAmount())) {
                        calculatedTaxRateAmount2.setTaxAmount(calculatedTaxRateAmount2.getTaxAmount().add(amountPerQuantityTaxAmount));
                    }
                    amountPerQuantityTotalTaxAmount = amountPerQuantityTaxAmount.add(amountPerQuantityTotalTaxAmount);
                }
                itemTotalAmount = itemTotalAmount.subtract(amountPerQuantityTotalTaxAmount);
            }
            if (taxOnTotalRates.isEmpty()) {
                for (TaxRate taxRateToCalculate : taxOnNetRates) {
                    taxAmount = TaxUtil.calculateTaxOnNetAmount(itemTotalAmount, taxRateToCalculate, taxOnNetRates);
                    calculatedTaxRateAmount = calculatedTaxRateAmounts.stream().filter(ctra -> taxRateToCalculate.getLabel().equals(ctra.getTaxRate().getLabel())).findAny().orElse(null);
                    if (calculatedTaxRateAmount == null) continue;
                    calculatedTaxRateAmount.setTaxAmount(taxAmount.add(calculatedTaxRateAmount.getTaxAmount()));
                }
                continue;
            }
            for (TaxRate taxRateToCalculate : taxOnTotalRates) {
                taxAmount = TaxUtil.calculateTaxOnTotalAmount(itemTotalAmount, taxRateToCalculate, taxOnTotalRates);
                calculatedTaxRateAmount = calculatedTaxRateAmounts.stream().filter(ctra -> taxRateToCalculate.getLabel().equals(ctra.getTaxRate().getLabel())).findAny().orElse(null);
                if (calculatedTaxRateAmount == null) continue;
                calculatedTaxRateAmount.setTaxAmount(taxAmount.add(calculatedTaxRateAmount.getTaxAmount()));
            }
            for (TaxRate taxRateToCalculate : taxOnNetRates) {
                taxAmount = TaxUtil.calculateTaxOnNetAmountWithTaxOnNet(itemTotalAmount, taxRateToCalculate, taxOnTotalRates, taxOnNetRates);
                calculatedTaxRateAmount = calculatedTaxRateAmounts.stream().filter(ctra -> taxRateToCalculate.getLabel().equals(ctra.getTaxRate().getLabel())).findAny().orElse(null);
                if (calculatedTaxRateAmount == null) continue;
                calculatedTaxRateAmount.setTaxAmount(taxAmount.add(calculatedTaxRateAmount.getTaxAmount()));
            }
        }
        calculatedInvoice.setTaxRateAmounts(calculatedTaxRateAmounts);
        ArrayList<CalculatedTaxCategoryAmount> arrayList = new ArrayList<CalculatedTaxCategoryAmount>();
        for (CalculatedTaxRateAmount taxRateAmount : calculatedInvoice.getTaxRateAmounts()) {
            CalculatedTaxCategoryAmount calculatedTaxCategoryAmount = arrayList.stream().filter(tca -> tca.getCategory().getOrderId() == taxRateAmount.getTaxRateCategory().getOrderId()).findAny().orElse(null);
            if (calculatedTaxCategoryAmount == null) {
                CalculatedTaxCategoryAmount newCalculatedTaxCategoryAmount = new CalculatedTaxCategoryAmount(taxRateAmount.getTaxRateCategory(), taxRateAmount.getTaxAmount());
                arrayList.add(newCalculatedTaxCategoryAmount);
                continue;
            }
            BigDecimal categoryTaxAmount = calculatedTaxCategoryAmount.getTaxAmount().add(taxRateAmount.getTaxAmount());
            calculatedTaxCategoryAmount.setTaxAmount(categoryTaxAmount);
        }
        calculatedInvoice.setTaxCategoryAmounts(arrayList);
        calculatedInvoice.setNumberOfTaxCategories(arrayList.size());
        return calculatedInvoice;
    }

    public static BigDecimal calculateTaxOnNetAmount(BigDecimal totalAmount, TaxRate taxRateToCalculate, List<TaxRate> taxRates) {
        BigDecimal ratesSum = BigDecimal.ZERO;
        for (TaxRate taxRate : taxRates) {
            ratesSum = ratesSum.add(taxRate.getRate());
        }
        return TaxUtil.round(TaxUtil.divide(totalAmount.multiply(taxRateToCalculate.getRate()), DECIMAL_100.add(ratesSum)));
    }

    public static BigDecimal calculateTaxOnTotalAmount(BigDecimal itemTotalAmount, TaxRate taxRateToCalculate, List<TaxRate> taxOnTotalTaxRates) {
        BigDecimal ratesSum = BigDecimal.ZERO;
        for (TaxRate taxRate : taxOnTotalTaxRates) {
            ratesSum = ratesSum.add(taxRate.getRate());
        }
        BigDecimal part1 = TaxUtil.divide(itemTotalAmount, BigDecimal.ONE.add(TaxUtil.divide(ratesSum, DECIMAL_100)));
        BigDecimal part2 = TaxUtil.divide(taxRateToCalculate.getRate(), DECIMAL_100);
        return TaxUtil.round(part1.multiply(part2));
    }

    public static BigDecimal calculateTaxOnNetAmountWithTaxOnNet(BigDecimal itemTotalAmount, TaxRate taxRateToCalculate, List<TaxRate> taxOnTotalTaxRates, List<TaxRate> taxOnNetTaxRates) {
        BigDecimal taxOnTotalRatesSum = BigDecimal.ZERO;
        for (TaxRate taxRate : taxOnTotalTaxRates) {
            taxOnTotalRatesSum = taxOnTotalRatesSum.add(taxRate.getRate());
        }
        BigDecimal taxOnNetRatesSum = BigDecimal.ZERO;
        for (TaxRate taxRate : taxOnNetTaxRates) {
            taxOnNetRatesSum = taxOnNetRatesSum.add(taxRate.getRate());
        }
        BigDecimal bigDecimal = TaxUtil.divide(itemTotalAmount, BigDecimal.ONE.add(TaxUtil.divide(taxOnTotalRatesSum, DECIMAL_100)));
        BigDecimal part2 = TaxUtil.divide(taxRateToCalculate.getRate(), DECIMAL_100.add(taxOnNetRatesSum));
        return TaxUtil.round(bigDecimal.multiply(part2));
    }

    private static List<CalculatedTaxRateAmount> createTaxRateAmounts(List<InvoiceItem> invoiceItems, TaxRateGroup taxRateGroup) {
        ArrayList<CalculatedTaxRateAmount> calculatedTaxRateAmounts = new ArrayList<CalculatedTaxRateAmount>();
        for (InvoiceItem invoiceItem : invoiceItems) {
            for (String label : invoiceItem.getLabels()) {
                boolean labelExists = calculatedTaxRateAmounts.stream().anyMatch(ctra -> label.equalsIgnoreCase(ctra.getTaxRate().getLabel()));
                if (labelExists) continue;
                TaxRateCategory taxRateCategory = TaxUtil.getTaxRateCategoryByLabel(label, taxRateGroup);
                TaxRate taxRate = TaxUtil.getTaxRateByLabel(label, taxRateGroup);
                calculatedTaxRateAmounts.add(new CalculatedTaxRateAmount(taxRate, taxRateCategory));
            }
        }
        return calculatedTaxRateAmounts;
    }

    public static String getInvoiceCounterExtension(InvoiceType invoiceType, InvoiceTransactionType invoiceTransactionType) {
        String invoiceTypeExtension = I18N.text("text.invoice.type.short." + invoiceType.name());
        String invoiceTransactionTypeExtension = I18N.text("text.trans.type.short." + invoiceTransactionType.name());
        return invoiceTypeExtension.concat(invoiceTransactionTypeExtension);
    }

    public static byte[] generateQrCodeBytes(String text, int width, int height) {
        byte[] qrCodeBytes = null;
        try {
            BufferedImage bufferedImage = TaxUtil.generateQRCodeImage(text, width, height);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "GIF", outputStream);
            qrCodeBytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qrCodeBytes;
    }

    public static BufferedImage generateQRCodeImage(String barcodeText, int width, int height) throws Exception {
        QRCodeWriter barcodeWriter = new QRCodeWriter();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
    }

    public static SignInvoiceResponse parseSignInvoiceCardResponse(byte[] cardResponseBytes) {
        byte[] signatureBytes;
        byte[] encDataBytes;
        SignInvoiceResponse signInvoiceResponse = new SignInvoiceResponse();
        byte[] sdcDateTimeBytes = ApduUtil.copyOfRange(cardResponseBytes, 0, 8);
        long millis = ApduUtil.bytesBEToLong(sdcDateTimeBytes);
        ZonedDateTime sdcDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(millis / 1000L), ZoneId.systemDefault());
        String sdcDatetimeFormatted = sdcDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        signInvoiceResponse.setSdcDateTime(sdcDateTime);
        signInvoiceResponse.setSdcDateTimeFormatted(sdcDatetimeFormatted);
        byte[] tinBytes = ApduUtil.copyOfRange(cardResponseBytes, 8, 28);
        String tin = new String(tinBytes).replace('\u0000', ' ').trim();
        signInvoiceResponse.setTin(tin);
        byte[] buyerIdBytes = ApduUtil.copyOfRange(cardResponseBytes, 28, 48);
        String buyerId = new String(buyerIdBytes).replace('\u0000', ' ').trim();
        signInvoiceResponse.setBuyerId(buyerId);
        signInvoiceResponse.setInvoiceType(Integer.valueOf(cardResponseBytes[48]));
        signInvoiceResponse.setTransactionType(Integer.valueOf(cardResponseBytes[49]));
        byte[] invoiceAmountBytes = ApduUtil.copyOfRange(cardResponseBytes, 50, 57);
        long invoiceAmountLong = ApduUtil.bytesBEToLong(invoiceAmountBytes, true);
        BigDecimal invoiceAmount = TaxUtil.toDecimalTaxAmount(invoiceAmountLong);
        signInvoiceResponse.setInvoiceAmount(invoiceAmount);
        byte[] transactionTypeCounterBytes = ApduUtil.copyOfRange(cardResponseBytes, 57, 61);
        byte[] totalCounterBytes = ApduUtil.copyOfRange(cardResponseBytes, 61, 65);
        int transactionTypeCounter = ApduUtil.bytesBEToInt(transactionTypeCounterBytes);
        int totalCounter = ApduUtil.bytesBEToInt(totalCounterBytes);
        signInvoiceResponse.setTransactionCounter(transactionTypeCounter);
        signInvoiceResponse.setTotalCounter(totalCounter);
        if (cardResponseBytes.length == 577) {
            encDataBytes = ApduUtil.copyOfRange(cardResponseBytes, 65, 321);
            signatureBytes = ApduUtil.copyOfRange(cardResponseBytes, 321, 577);
        } else {
            encDataBytes = ApduUtil.copyOfRange(cardResponseBytes, 65, 577);
            signatureBytes = ApduUtil.copyOfRange(cardResponseBytes, 321, 833);
        }
        String encDataBase64 = Base64.getEncoder().encodeToString(encDataBytes);
        String signatureBase64 = Base64.getEncoder().encodeToString(signatureBytes);
        signInvoiceResponse.setInternalData(encDataBase64);
        signInvoiceResponse.setDigitalSignature(signatureBase64);
        return signInvoiceResponse;
    }

    public static void calculateInvoiceResultTaxItems(CalculatedInvoice calculatedInvoice, InvoiceResult invoiceResult) {
        ArrayList<InvoiceResultTaxItem> invoiceResultTaxItems = new ArrayList<InvoiceResultTaxItem>();
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        for (CalculatedTaxRateAmount calculatedTaxRateAmount : calculatedInvoice.getTaxRateAmounts()) {
            InvoiceResultTaxItem existingInvoiceResultTaxItem = invoiceResultTaxItems.stream().filter(irti -> irti.getLabel().equals(calculatedTaxRateAmount.getTaxRate().getLabel())).findAny().orElse(null);
            if (existingInvoiceResultTaxItem == null) {
                InvoiceResultTaxItem invoiceResultTaxItem = new InvoiceResultTaxItem();
                invoiceResultTaxItem.setLabel(calculatedTaxRateAmount.getTaxRate().getLabel());
                invoiceResultTaxItem.setRate(calculatedTaxRateAmount.getTaxRate().getRate());
                invoiceResultTaxItem.setAmount(calculatedTaxRateAmount.getTaxAmount());
                invoiceResultTaxItem.setCategoryType(calculatedTaxRateAmount.getTaxRateCategory().getCategoryType().getValue());
                invoiceResultTaxItem.setCategoryName(calculatedTaxRateAmount.getTaxRateCategory().getName());
                invoiceResultTaxItems.add(invoiceResultTaxItem);
            } else {
                existingInvoiceResultTaxItem.setAmount(existingInvoiceResultTaxItem.getAmount().add(calculatedTaxRateAmount.getTaxAmount()));
            }
            totalTaxAmount = totalTaxAmount.add(calculatedTaxRateAmount.getTaxAmount());
        }
        invoiceResult.setTaxItems(invoiceResultTaxItems);
        invoiceResult.setTotalTaxAmount(totalTaxAmount);
    }

    public static InvoiceResult createInvoiceResult(AppState appState, InvoiceRequest invoiceRequest, CalculatedInvoice calculatedInvoice, SignInvoiceResponse signInvoiceResponse) throws Exception {
        InvoiceResult invoiceResult = new InvoiceResult();
        TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
        TaxCardCertificateSubject taxCardCertificateSubject = taxCardCertificate.getSubject();
        invoiceResult.setRequestedBy(taxCardCertificateSubject.getSerialNumber());
        invoiceResult.setSignedBy(taxCardCertificateSubject.getSerialNumber());
        invoiceResult.setSdcDateTime(signInvoiceResponse.getSdcDateTimeFormatted());
        String invoiceCounterExtension = TaxUtil.getInvoiceCounterExtension(invoiceRequest.getInvoiceType(), invoiceRequest.getTransactionType());
        invoiceResult.setInvoiceCounterExtension(invoiceCounterExtension);
        invoiceResult.setTotalCounter(signInvoiceResponse.getTotalCounter());
        invoiceResult.setTransactionTypeCounter(signInvoiceResponse.getTransactionCounter());
        invoiceResult.setInvoiceCounter(String.format("%d/%d%s", invoiceResult.getTransactionTypeCounter(), invoiceResult.getTotalCounter(), invoiceResult.getInvoiceCounterExtension()));
        invoiceResult.setInvoiceNumber(String.format("%s-%s-%d", invoiceResult.getRequestedBy(), invoiceResult.getSignedBy(), signInvoiceResponse.getTotalCounter()));
        invoiceResult.setEncryptedInternalData(signInvoiceResponse.getInternalData());
        invoiceResult.setSignature(signInvoiceResponse.getDigitalSignature());
        invoiceResult.setTotalAmount(calculatedInvoice.getInvoiceAmount());
        TaxUtil.calculateInvoiceResultTaxItems(calculatedInvoice, invoiceResult);
        invoiceResult.setBusinessName(taxCardCertificateSubject.getO());
        invoiceResult.setLocationName(taxCardCertificateSubject.getOu());
        invoiceResult.setAddress(taxCardCertificateSubject.getStreet());
        invoiceResult.setDistrict(taxCardCertificateSubject.getL());
        invoiceResult.setTin(taxCardCertificate.getTaxpayerTin());
        invoiceResult.setTaxGroupRevision(calculatedInvoice.getTaxRateGroup().getGroupId());
        invoiceResult.setMrc(AppSettings.getInstance().getDeviceSerialNumberMrc());
        invoiceResult.setMessages(null);
        String verUrlPart = TaxUtil.createVerificationUrlPart(invoiceRequest, invoiceResult);
        String verificationUrl = appState.getTaxCoreVerificationUrl() + verUrlPart;
        invoiceResult.setVerificationUrl(verificationUrl);
        return invoiceResult;
    }

    public static AuditPackage createAuditPackage(Invoice invoice, RSAPublicKey rsaPublicKey) throws Exception {
        SecretKey secretKey = CryptoUtil.generateRandomAES256SecretKey();
        byte[] aesKey = secretKey.getEncoded();
        byte[] iv = CryptoUtil.generateRandomIVForAES();
        String invoiceJson = new GsonBuilder().setPrettyPrinting().create().toJson((Object)invoice);
        byte[] aesEncodedInvoice = CryptoUtil.encodeWithAES(invoiceJson.getBytes(StandardCharsets.UTF_8), aesKey, iv);
        byte[] rsaEncodedAesKey = CryptoUtil.encodeWithRSA(aesKey, rsaPublicKey);
        byte[] rsaEncodedIv = CryptoUtil.encodeWithRSA(iv, rsaPublicKey);
        String aesEncodedInvoiceBase64 = Base64.getEncoder().encodeToString(aesEncodedInvoice);
        String rsaEncodedAesKeyBase64 = Base64.getEncoder().encodeToString(rsaEncodedAesKey);
        String rsaEncodedIvBase64 = Base64.getEncoder().encodeToString(rsaEncodedIv);
        AuditPackage auditPackage = new AuditPackage(rsaEncodedAesKeyBase64, rsaEncodedIvBase64, aesEncodedInvoiceBase64);
        return auditPackage;
    }

    public static String createVerificationUrlPart(InvoiceRequest invoiceRequest, InvoiceResult invoiceResult) throws Exception {
        byte version = 3;
        byte[] uid = invoiceResult.getRequestedBy().getBytes(StandardCharsets.US_ASCII);
        byte[] totalCounter = ApduUtil.convertToLEByteArray(invoiceResult.getTotalCounter());
        byte[] transactionCounter = ApduUtil.convertToLEByteArray(invoiceResult.getTransactionTypeCounter());
        byte[] totalAmount = ApduUtil.convertAmountToLE8ByteApduPacket(invoiceResult.getTotalAmount());
        byte[] sdcDatetime = ApduUtil.toUnixTimestamp(ZonedDateTime.parse(invoiceResult.getSdcDateTime()));
        byte invoiceType = (byte)invoiceRequest.getInvoiceType().getValue();
        byte transactionType = (byte)invoiceRequest.getTransactionType().getValue();
        byte buyerIdLen = 0;
        byte[] buyerId = new byte[]{};
        if (invoiceRequest.getBuyerId() != null && !invoiceRequest.getBuyerId().isEmpty()) {
            buyerIdLen = (byte)invoiceRequest.getBuyerId().length();
            buyerId = invoiceRequest.getBuyerId().getBytes(StandardCharsets.US_ASCII);
        }
        byte[] encryptedData = Base64.getDecoder().decode(invoiceResult.getEncryptedInternalData());
        byte[] signature = Base64.getDecoder().decode(invoiceResult.getSignature());
        int len = 44 + buyerIdLen + encryptedData.length + 256;
        ByteBuffer outBuffer = ByteBuffer.allocate(len);
        outBuffer.order(ByteOrder.BIG_ENDIAN);
        outBuffer.put(version).put(uid).put(uid).put(totalCounter).put(transactionCounter).put(totalAmount).put(sdcDatetime).put(invoiceType).put(transactionType).put(buyerIdLen);
        if (buyerIdLen != 0) {
            outBuffer.put(buyerId);
        }
        outBuffer.put(encryptedData).put(signature);
        byte[] previousBytes = outBuffer.array();
        byte[] md5Hash = CryptoUtil.generateMD5Hash(previousBytes);
        ByteBuffer finalOutBuffer = ByteBuffer.allocate(previousBytes.length + md5Hash.length);
        outBuffer.order(ByteOrder.BIG_ENDIAN);
        finalOutBuffer.put(previousBytes).put(md5Hash);
        String urlBase64 = Base64.getEncoder().encodeToString(finalOutBuffer.array());
        return urlBase64;
    }

    public static void addQRCodeToResultIfNeeded(Invoice invoice) {
        byte[] qrCodeBytes;
        InvoiceRequest invoiceRequest = invoice.getRequest();
        InvoiceResult invoiceResult = invoice.getResult();
        if (!invoiceRequest.shouldOmitQRCodeGen() && (qrCodeBytes = TaxUtil.generateQrCodeBytes(invoiceResult.getVerificationUrl(), 388, 388)) != null) {
            String verificationQRCode = new String(Base64.getEncoder().encode(qrCodeBytes));
            invoiceResult.setVerificationQRCode(verificationQRCode);
        }
    }
}

