/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.utils;

import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.model.TaxCardCertificateIssuer;
import com.dmi.sdccore.model.TaxCardCertificateSubject;
import com.dmi.sdccore.utils.DateTimeUtil;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.commons.text.StringEscapeUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import sun.security.x509.CertificateSerialNumber;

public class CertificateUtil {
    private static final Logger logger = Logger.getLogger(CertificateUtil.class.getName());

    private CertificateUtil() {
    }

    public static TaxCardCertificate toTaxCardCertificate(byte[] derFormatBytes) throws CertificateException {
        X509Certificate x509Cert = CertificateUtil.parseCertificateFromDER(derFormatBytes);
        TaxCardCertificate taxCardCertificate = new TaxCardCertificate();
        taxCardCertificate.setX509Certificate(x509Cert);
        taxCardCertificate.setSubject(CertificateUtil.parseCertificateSubject(x509Cert));
        taxCardCertificate.setIssuer(CertificateUtil.parseCertificateIssuer(x509Cert));
        CertificateSerialNumber certSerialNumber = new CertificateSerialNumber(x509Cert.getSerialNumber());
        String var1 = x509Cert.getSerialNumber().toString(16);
        ArrayList serNoParts = Collections.list(certSerialNumber.getElements());
        taxCardCertificate.setSerialNumber(CertificateUtil.serialToUID(x509Cert.getSerialNumber()));
        taxCardCertificate.setAlgorithm(x509Cert.getSigAlgName());
        taxCardCertificate.setVersion(String.valueOf(x509Cert.getVersion()));
        taxCardCertificate.setValidFrom(DateTimeUtil.dateToLocalDateTime(x509Cert.getNotBefore()));
        taxCardCertificate.setValidTo(DateTimeUtil.dateToLocalDateTime(x509Cert.getNotAfter()));
        taxCardCertificate.setRsaPublicKey((RSAPublicKey)x509Cert.getPublicKey());
        Set<String> allOids = x509Cert.getCriticalExtensionOIDs();
        allOids.addAll(x509Cert.getNonCriticalExtensionOIDs());
        String apiUrlOid = allOids.stream().filter(oid -> oid.endsWith(".5")).findFirst().orElse(null);
        String taxApiServerBaseUrl = CertificateUtil.getExtensionValueByOID(x509Cert, apiUrlOid);
        taxCardCertificate.setTaxApiServerBaseUrl(taxApiServerBaseUrl);
        String environmentOid = x509Cert.getExtendedKeyUsage().get(0);
        String[] fields = environmentOid.split("\\.");
        String taxpayerTinOid = String.format("1.3.6.1.4.1.49952.%s.%s.6", fields[fields.length - 4], fields[fields.length - 3]);
        String taxpayerTin = CertificateUtil.getExtensionValueByOID(x509Cert, taxpayerTinOid);
        taxCardCertificate.setTaxpayerTin(taxpayerTin);
        return taxCardCertificate;
    }

    public static X509Certificate parseCertificateFromDER(byte[] derFormatBytes) throws CertificateException {
        ByteArrayInputStream in = new ByteArrayInputStream(derFormatBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(in);
    }

    public static TaxCardCertificateSubject parseCertificateSubject(X509Certificate x509Cert) throws CertificateEncodingException {
        TaxCardCertificateSubject subject = new TaxCardCertificateSubject();
        X500Name x500name = new JcaX509CertificateHolder(x509Cert).getSubject();
        subject.setCn(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.CN));
        subject.setSerialNumber(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.SERIALNUMBER));
        subject.setOu(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.OU));
        subject.setO(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.O));
        subject.setStreet(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.STREET));
        subject.setL(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.L));
        subject.setSt(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.ST));
        subject.setC(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.C));
        return subject;
    }

    public static TaxCardCertificateIssuer parseCertificateIssuer(X509Certificate x509Cert) throws CertificateEncodingException {
        TaxCardCertificateIssuer issuer = new TaxCardCertificateIssuer();
        X500Name x500name = new JcaX509CertificateHolder(x509Cert).getIssuer();
        issuer.setCn(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.CN));
        issuer.setO(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.O));
        issuer.setC(CertificateUtil.getASN1ObjectValue(x500name, BCStyle.C));
        return issuer;
    }

    public static String getExtensionValueByOID(X509Certificate x509Cert, String oid) {
        return new String(ASN1OctetString.getInstance((Object)x509Cert.getExtensionValue(oid)).getOctets(), StandardCharsets.UTF_8);
    }

    public static String getASN1ObjectValue(X500Name x500name, ASN1ObjectIdentifier asn1ObjectIdentifier) {
        RDN rdn;
        RDN[] rdns = x500name.getRDNs(asn1ObjectIdentifier);
        if (rdns.length > 0 && (rdn = rdns[0]) != null) {
            return StringEscapeUtils.unescapeJava((String)IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()));
        }
        return null;
    }

    public static String toUuidString(byte[] bytes) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(16);
            for (int zeroesToAdd = 16 - bytes.length; zeroesToAdd > 0; --zeroesToAdd) {
                bb.put((byte)0);
            }
            bb.put(bytes);
            bb.position(0);
            long high = bb.getLong();
            long low = bb.getLong();
            UUID uuid = new UUID(high, low);
            return uuid.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serialToUID(BigInteger var0) {
        String var1 = var0.toString(16);
        StringBuilder var2 = new StringBuilder(var1.length() * 2);
        if (var1.length() % 2 != 0) {
            var1 = "0" + var1;
        }
        int var3 = 0;
        while (var3 < var1.length()) {
            var2.append(var1.substring(var3, var3 + 2));
            if ((var3 += 2) == var1.length() || var3 % 64 == 0 || var3 % 8 != 0) continue;
            var2.append("-");
        }
        return var2.toString();
    }
}

