/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.ui;

import com.dmi.sdccore.I18N;
import com.dmi.sdccore.ui.UiUtil;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class MainMenuBar
extends HBox {
    MenuItem menuItemServiceSettings;
    Button buttonStartLocalAudit;
    Button buttonLoadCommands;
    Button buttonExportLogFile;
    Button buttonEnterPin;
    Button buttonRestart;

    public MainMenuBar() {
        this.setStyle("-fx-padding: 5 5 5 5;");
        this.setSpacing(10.0);
        this.createComponents();
    }

    private void createComponents() {
        Menu menuService = new Menu("");
        menuService.setGraphic((Node)UiUtil.createIcon(FontAwesome.Glyph.GEAR, Color.DARKGREY, 20));
        this.menuItemServiceSettings = new MenuItem(I18N.text("text.menu.item.settings"));
        menuService.getItems().add((Object)this.menuItemServiceSettings);
        MenuBar menubarRight = new MenuBar();
        menubarRight.setStyle("-fx-padding: 1; -fx-background-color: none ;");
        menubarRight.getMenus().add((Object)menuService);
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.SOMETIMES);
        this.buttonStartLocalAudit = new Button(I18N.text("text.button.local.audit"));
        this.buttonStartLocalAudit.setTooltip(new Tooltip(I18N.text("text.tooltip.local.audit")));
        this.buttonLoadCommands = new Button(I18N.text("text.button.load.commands"));
        this.buttonLoadCommands.setTooltip(new Tooltip(I18N.text("text.tooltip.load.commands")));
        this.buttonExportLogFile = new Button(I18N.text("text.button.log.history"));
        this.buttonExportLogFile.setTooltip(new Tooltip(I18N.text("text.tooltip.log.history")));
        this.buttonEnterPin = new Button(I18N.text("text.button.enter.pin"));
        this.buttonEnterPin.setTooltip(new Tooltip(I18N.text("text.tooltip.enter.pin")));
        this.buttonRestart = new Button("Restart");
        this.buttonEnterPin.setTooltip(new Tooltip("Restart"));
        this.getChildren().addAll((Object[])new Node[]{this.buttonStartLocalAudit, this.buttonLoadCommands, this.buttonExportLogFile, this.buttonEnterPin, this.buttonRestart, spacer, menubarRight});
    }

    public void setShowSettingsAction(EventHandler<ActionEvent> value) {
        this.menuItemServiceSettings.setOnAction(value);
    }

    public void setStartAuditAction(EventHandler<ActionEvent> actionHandler) {
        this.buttonStartLocalAudit.setOnAction(actionHandler);
    }

    public void setLoadCommandsAction(EventHandler<ActionEvent> actionHandler) {
        this.buttonLoadCommands.setOnAction(actionHandler);
    }

    public void setExportLogFileAction(EventHandler<ActionEvent> actionHandler) {
        this.buttonExportLogFile.setOnAction(actionHandler);
    }

    public void setEnterPinAction(EventHandler<ActionEvent> actionHandler) {
        this.buttonEnterPin.setOnAction(actionHandler);
    }

    public void setEnterrestartAction(EventHandler<ActionEvent> actionHandler) {
        this.buttonRestart.setOnAction(actionHandler);
    }
}

