/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxcard;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.protocols.taxapi.TaxApiClient;
import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import com.dmi.sdccore.protocols.taxcard.CardCommand;
import com.dmi.sdccore.protocols.taxcard.CardOpCode;
import com.dmi.sdccore.protocols.taxcard.CardPresenceNotifier;
import com.dmi.sdccore.protocols.taxcard.CardResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import javax.smartcardio.TerminalFactory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.security.pkcs11.SunPKCS11;

public final class CardReader {
    private static final Logger logger = LogManager.getLogger(CardReader.class);
    private static final TerminalFactory terminalFactory = TerminalFactory.getDefault();
    private static final CardReader INSTANCE = new CardReader();
    private CardTerminal cardTerminal;
    private CardPresenceNotifier cardPresenceNotifier;
    final Object syncObject = new Object();

    private CardReader() {
    }

    public static CardReader getInstance() {
        return INSTANCE;
    }

    public static void tryToSetCardReader() {
        try {
            List<CardTerminal> terminals;
            if (StringUtils.isBlank((CharSequence)AppSettings.getInstance().getDefaultSmartCardReaderName()) && !(terminals = CardReader.getCardTerminals()).isEmpty()) {
                String cardReaderName = null;
                for (CardTerminal terminal : terminals) {
                    if (!terminal.isCardPresent()) continue;
                    cardReaderName = terminal.getName();
                    break;
                }
                if (cardReaderName == null) {
                    cardReaderName = terminals.get(0).getName();
                }
                AppSettings.getInstance().setPropertyAndSave("smartCardReaderName", cardReaderName);
            }
        }
        catch (Exception exception) {
            logger.error("Setting card reader failed", (Throwable)exception);
        }
    }

    public synchronized ResponseAPDU sendCommand(String commandHexString) {
        try {
            return this.sendCommand(Hex.decodeHex((String)commandHexString));
        }
        catch (DecoderException e) {
            logger.error("Smart card command hex format error: ", (Throwable)e);
            throw new RuntimeException("Smart card command hex format error");
        }
    }

    public synchronized ResponseAPDU sendCommand(byte[] commandBytes) {
        return this.sendCommand(new CommandAPDU(commandBytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ResponseAPDU sendCommand(CommandAPDU command) {
        Object object = this.syncObject;
        synchronized (object) {
            try {
                if (this.isCardPresent()) {
                    Card card = this.cardTerminal.connect("*");
                    CardChannel channel = card.getBasicChannel();
                    ResponseAPDU response = channel.transmit(command);
                    if (response.getSW() != 36864) {
                        logger.error("Card error-> APDU command: {}, response: {}", (Object)Hex.encodeHexString((byte[])command.getBytes()), (Object)Hex.encodeHexString((byte[])response.getBytes()));
                    }
                    card.disconnect(false);
                    return response;
                }
            }
            catch (CardException e) {
                logger.error("Send APDU command error: ", (Throwable)e);
            }
            return null;
        }
    }

    public void resetCard() {
        try {
            if (this.isCardPresent()) {
                Card card = this.cardTerminal.connect("*");
                card.disconnect(true);
            }
        }
        catch (CardException e) {
            logger.error("Reset card error: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ApiResponse readTaxCardPkiAppletAndGetApiToken(AppState appState) throws Exception {
        Object object = this.syncObject;
        synchronized (object) {
            CardReader.getInstance().resetCard();
            CardReader.getInstance().readTaxCardPkiApplet(appState);
            TaxApiClient.getInstance().initializeCardProtectedSsl(appState);
            return TaxApiClient.getInstance().getTaxCoreApiToken(appState);
        }
    }

    public synchronized boolean isCardPresent() {
        boolean cardPresent = false;
        if (this.cardTerminal != null) {
            try {
                cardPresent = this.cardTerminal.isCardPresent();
            }
            catch (CardException e) {
                logger.error("isCardPresent()", (Throwable)e);
            }
        }
        return cardPresent;
    }

    public static List<CardTerminal> getCardTerminals() {
        List<CardTerminal> terminals = Collections.emptyList();
        try {
            terminals = terminalFactory.terminals().list();
        }
        catch (CardException e) {
            Throwable cause = e.getCause();
            if (cause == null || !"SCARD_E_NO_READERS_AVAILABLE".equals(cause.getMessage())) {
                logger.error("getCardTerminals()", (Throwable)e);
            }
            try {
                CardReader.closeCardTerminals();
            }
            catch (Exception ex) {
                logger.error("Error while closing terminals", (Throwable)e);
            }
        }
        return terminals;
    }

    public static CardTerminal getCardTerminalByName(String systemName) {
        List<CardTerminal> terminals = CardReader.getCardTerminals();
        return terminals.stream().filter(t -> t.getName().equalsIgnoreCase(systemName)).findAny().orElse(null);
    }

    public static boolean cardTerminalExists(String systemName) {
        List<CardTerminal> terminals = CardReader.getCardTerminals();
        return terminals.stream().anyMatch(t -> t.getName().equalsIgnoreCase(systemName));
    }

    public static void closeCardTerminals() throws Exception {
        Class<?> pcscterminal = Class.forName("sun.security.smartcardio.PCSCTerminals");
        Field contextId = pcscterminal.getDeclaredField("contextId");
        contextId.setAccessible(true);
        if (contextId.getLong(pcscterminal) != 0L) {
            Class<?> pcsc = Class.forName("sun.security.smartcardio.PCSC");
            Method SCardEstablishContext = pcsc.getDeclaredMethod("SCardEstablishContext", Integer.TYPE);
            SCardEstablishContext.setAccessible(true);
            Field SCARD_SCOPE_USER = pcsc.getDeclaredField("SCARD_SCOPE_USER");
            SCARD_SCOPE_USER.setAccessible(true);
            long newId = (Long)SCardEstablishContext.invoke(pcsc, SCARD_SCOPE_USER.getInt(pcsc));
            contextId.setLong(pcscterminal, newId);
            TerminalFactory factory = TerminalFactory.getDefault();
            CardTerminals terminals = factory.terminals();
            Field fieldTerminals = pcscterminal.getDeclaredField("terminals");
            fieldTerminals.setAccessible(true);
            Class<?> classMap = Class.forName("java.util.Map");
            Method clearMap = classMap.getDeclaredMethod("clear", new Class[0]);
            clearMap.invoke(fieldTerminals.get(terminals), new Object[0]);
        }
    }

    public void start() {
        CardReader.tryToSetCardReader();
        this.cardPresenceNotifier = new CardPresenceNotifier();
        this.cardPresenceNotifier.start();
    }

    public void stop() {
        this.cardPresenceNotifier.setRunning(false);
    }

    public CardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    public void setCardTerminal(CardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
    }

    public CardPresenceNotifier getCardPresenceNotifier() {
        return this.cardPresenceNotifier;
    }

    public synchronized boolean readTaxCardInfo(AppState appState) {
        logger.info("Reading card info");
        try {
            CardResponse cardResponse = CardCommand.getInstance().selectApplet();
            if (CardOpCode.OK != cardResponse.getOpCode()) {
                return false;
            }
            cardResponse = CardCommand.getInstance().exportCertificate(appState);
            if (CardOpCode.OK != cardResponse.getOpCode()) {
                return false;
            }
            cardResponse = CardCommand.getInstance().exportTaxCorePublicKey(appState);
            if (CardOpCode.OK != cardResponse.getOpCode()) {
                return false;
            }
            cardResponse = CardCommand.getInstance().getCardSecureElementVersion(appState);
            if (CardOpCode.OK != cardResponse.getOpCode()) {
                return false;
            }
            cardResponse = CardCommand.getInstance().getCardAmountStatus(appState);
            if (CardOpCode.OK != cardResponse.getOpCode()) {
                return false;
            }
            if (appState.getTaxCardCertificate().isCardCertificateExpired()) {
                logger.warn("Card certificate expired: validFrom: {}, validTo: {}", (Object)appState.getTaxCardCertificate().getValidFrom(), (Object)appState.getTaxCardCertificate().getValidTo());
            }
        }
        catch (Exception exc) {
            logger.error("Reading card info error", (Throwable)exc);
            return false;
        }
        logger.info("Reading card info success");
        return true;
    }

    public synchronized void readTaxCardPkiApplet(AppState appState) throws Exception {
        if (appState == null || !appState.isCardInserted() || appState.getPinCode() == null) {
            return;
        }
        logger.info("Reading PKI applet");
        if (Security.getProvider("SunPKCS11-SrTaxSmartCard") != null) {
            Security.removeProvider("SunPKCS11-SrTaxSmartCard");
        }
        if (Security.getProvider("SunPKCS11-SrTaxSmartCard") == null) {
            CardReader.addPkcs11Provider();
        }
        Provider provider = Security.getProvider("SunPKCS11-SrTaxSmartCard");
        KeyStore.CallbackHandlerProtection chp = new KeyStore.CallbackHandlerProtection(callbacks -> {
            for (Callback callback : callbacks) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                passwordCallback.setPassword(AppState.getInstance().getPinCode().toCharArray());
                logger.info("PIN used in password callback");
            }
        });
        KeyStore.Builder builder = KeyStore.Builder.newInstance("PKCS11", provider, chp);
        KeyStore keyStore = builder.getKeyStore();
        ByteArrayOutputStream secureKeyStoreOutputStream = new ByteArrayOutputStream();
        keyStore.store(secureKeyStoreOutputStream, appState.getPinCode().toCharArray());
        appState.setSecureKeyStoreByteArray(secureKeyStoreOutputStream.toByteArray());
        appState.setSecureKeyStoreOutputStream(secureKeyStoreOutputStream);
        secureKeyStoreOutputStream.close();
        logger.info("Secure key stored (type={})", (Object)keyStore.getType());
    }

    private static void addPkcs11Provider() {
        String pkcs11nativeLibrary = System.getProperty("user.dir") + "\\resources\\opensc-pkcs11.dll";
        String pkcs11ConfigSettings = "name = SrTaxSmartCard\nlibrary = " + pkcs11nativeLibrary;
        byte[] pkcs11ConfigBytes = pkcs11ConfigSettings.getBytes();
        ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigBytes);
        SunPKCS11 pkcs11Provider = new SunPKCS11((InputStream)confStream);
        Security.addProvider(pkcs11Provider);
    }
}

