/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxcard;

import com.dmi.sdccore.AppSettings;
import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.protocols.taxapi.TaxApiClient;
import com.dmi.sdccore.protocols.taxcard.CardReader;
import com.dmi.sdccore.utils.FsUtil;
import javax.smartcardio.CardTerminal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CardPresenceNotifier
extends Thread {
    private static final Logger logger = LogManager.getLogger(CardPresenceNotifier.class);
    boolean running = true;
    boolean firstPass = true;
    long iteration = 0L;

    @Override
    public void run() {
        while (this.running) {
            AppState appState = AppState.getInstance();
            CardReader cardReader = CardReader.getInstance();
            boolean cardTerminalExists = CardReader.cardTerminalExists(AppSettings.getInstance().getDefaultSmartCardReaderName());
            if (appState.isTerminalConnected() && !cardTerminalExists) {
                CardReader.getInstance().setCardTerminal(null);
                appState.setTerminalConnected(false);
                appState.clearDataOnCardRemoval();
                logger.warn("Card terminal disconnected");
                EventManager.getInstance().postErrorNotification(I18N.text("message.card.terminal.disconnected"));
            } else if (!appState.isTerminalConnected() && cardTerminalExists) {
                CardTerminal cardTerminal = CardReader.getCardTerminalByName(AppSettings.getInstance().getDefaultSmartCardReaderName());
                CardReader.getInstance().setCardTerminal(cardTerminal);
                appState.setTerminalConnected(true);
                if (!this.firstPass) {
                    EventManager.getInstance().postInfoNotification(I18N.text("message.card.terminal.connected"));
                }
            }
            if (appState.isTerminalConnected()) {
                if (appState.isCardInserted() && !cardReader.isCardPresent()) {
                    appState.clearDataOnCardRemoval();
                    logger.warn("Tax card removed");
                    EventManager.getInstance().postWarningNotification(I18N.text("message.card.disconnected"));
                } else if (!(!cardReader.isCardPresent() || appState.isCardInserted() && appState.isTaxCardInfoRead())) {
                    appState.setCardInserted(true);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException cardTerminal) {
                        // empty catch block
                    }
                    int retry = 0;
                    while (cardReader.isCardPresent() && retry < 3) {
                        boolean isTaxCardInfoRead = CardReader.getInstance().readTaxCardInfo(appState);
                        appState.setTaxCardInfoRead(isTaxCardInfoRead);
                        if (isTaxCardInfoRead) {
                            try {
                                TaxApiClient.getInstance().initializeSsl(appState);
                                appState.setTaxApiSslInitialized(true);
                                logger.info("Tax core API initialized");
                            }
                            catch (Exception e) {
                                logger.error("Tax API initialization error", (Throwable)e);
                                appState.setTaxApiSslInitialized(false);
                            }
                            if (appState.getTaxCardCertificate().isCardCertificateExpired()) {
                                logger.warn("Card certificate is expired");
                                EventManager.getInstance().postInfoNotification(I18N.text("message.card.certificate.expired"));
                                break;
                            }
                            if (appState.isSdcInitialized()) {
                                logger.warn("Tax card is ready. PIN required");
                                EventManager.getInstance().postInfoNotification(I18N.text("message.card.connected.pin.required"));
                                break;
                            }
                            logger.warn("Tax card is ready. SDC not configured. PIN required.");
                            EventManager.getInstance().postInfoNotification(I18N.text("message.card.connected.sdc.not.init"));
                            break;
                        }
                        logger.error("Tax card is not initialized. Retrying ...");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (++retry != 3) continue;
                        EventManager.getInstance().postWarningNotification(I18N.text("message.card.init.failed.retrying"));
                    }
                }
            }
            if (this.firstPass) {
                if (!appState.isSdcSerialNumberDefined()) {
                    logger.warn("SDC serial number is not defined.");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.sdc.serial.number.not.defined"));
                } else if (!appState.isTerminalConnected()) {
                    logger.warn("Card terminal is missing");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.card.terminal.not.present"));
                } else if (!appState.isCardInserted()) {
                    logger.warn("Tax card is missing");
                    EventManager.getInstance().postErrorNotification(I18N.text("message.card.not.present"));
                }
                this.firstPass = false;
            }
            if (this.iteration > 5L && this.iteration % 3L == 0L) {
                boolean isExternalDiskPresent = FsUtil.isExternalDiskPresent();
                if (!appState.isExternalDiskPresent() && isExternalDiskPresent) {
                    appState.setExternalDiskPresent(true);
                    EventManager.getInstance().postInfoNotification(I18N.text("text.external.drive.present.true"));
                } else if (appState.isExternalDiskPresent() && !isExternalDiskPresent) {
                    appState.setExternalDiskPresent(false);
                    EventManager.getInstance().postWarningNotification(I18N.text("text.external.drive.present.false"));
                }
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++this.iteration;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isFirstPass() {
        return this.firstPass;
    }

    public void setFirstPass(boolean firstPass) {
        this.firstPass = firstPass;
    }
}

