/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.protocols.taxapi;

import com.dmi.sdccore.AppState;
import com.dmi.sdccore.EventManager;
import com.dmi.sdccore.I18N;
import com.dmi.sdccore.events.NotificationSeverity;
import com.dmi.sdccore.events.SystemEventType;
import com.dmi.sdccore.model.Licenca;
import com.dmi.sdccore.model.TaxCardCertificate;
import com.dmi.sdccore.protocols.taxapi.AuditExecutor;
import com.dmi.sdccore.protocols.taxapi.TaxApiClient;
import com.dmi.sdccore.protocols.taxapi.model.ApiResponse;
import com.dmi.sdccore.protocols.taxcard.CardReader;
import com.dmi.sdccore.ui.BoolStatusUiItem;
import com.dmi.sdccore.ui.StatusTabPanel;
import com.dmi.sdccore.utils.FsUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.scene.control.Alert;
import javafx.scene.control.DialogPane;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnlineStatusNotifier
extends Thread {
    private static final Logger logger = LogManager.getLogger(OnlineStatusNotifier.class);
    boolean running = true;
    boolean sdcOnline = true;
    private AtomicInteger atomicInteger = new AtomicInteger(0);
    private final StatusTabPanel statusTabPanel;
    private static final long TOKEN_API_EXPIRED_LOG_PERIOD = 120L;
    private static final long SUBMIT_AUDIT_PACKAGES_PERIOD = 12L;

    public OnlineStatusNotifier(StatusTabPanel statusTabPanel) {
        this.statusTabPanel = statusTabPanel;
    }

    @Override
    public void run() {
        long iteration = 0L;
        LocalTime localTime = LocalTime.now().plusMinutes(15L);
        logger.info("Vreme trenutno je " + localTime.toString());
        LocalTime localTimeLicence = LocalTime.now().plusMinutes(10L);
        LocalDateTime neposlatiRacun = LocalDateTime.now();
        while (this.running) {
            block30: {
                AppState appState;
                LocalTime localDate1 = LocalTime.of(3, 30);
                logger.info("Running  je " + localDate1.toString());
                if (localDate1.getHour() == LocalTime.now().getHour() && localDate1.getMinute() == LocalTime.now().getMinute()) {
                    logger.info("restart  je " + localDate1.toString());
                    appState = AppState.getInstance();
                    CardReader.getInstance().setCardTerminal(null);
                    appState.setTerminalConnected(false);
                    appState.clearDataOnCardRemoval();
                    CardReader.getInstance().getCardPresenceNotifier().setFirstPass(true);
                    EventManager.getInstance().postSystemEvent(SystemEventType.RestartApiServer);
                }
                appState = AppState.getInstance();
                try {
                    if (appState.isTaxApiSslInitialized() && appState.getTaxCoreApiToken() == null) {
                        TaxApiClient.getInstance().notifyOnlineStatus(this.sdcOnline, "", AppState.getInstance());
                    }
                    if (appState.getTaxCoreApiToken() != null && appState.getTaxCoreApiToken().isExpired() && iteration % 120L == 0L) {
                        logger.warn("Tax API token has expired");
                    }
                    if (appState.isCardPinCodeEntered() && (appState.getTaxCoreApiToken() == null || appState.getTaxCoreApiToken().isExpired()) && appState.isInternetAvailable()) {
                        boolean success = OnlineStatusNotifier.initializeSDC(appState);
                        EventManager.getInstance().postUpdateUIEvent();
                    }
                    if (appState.getTaxCoreApiToken() != null && appState.isTaxApiSslInitialized()) {
                        ApiResponse response = TaxApiClient.getInstance().notifyOnlineStatus(this.sdcOnline, appState.getTaxCoreApiToken().getToken(), AppState.getInstance());
                        if (401 == response.getCode() && iteration % 120L == 0L) {
                            logger.warn("notifyOnlineStatus response: {}", (Object)response.toString());
                        }
                        if (200 == response.getCode() && appState.isSdcInitialized() && appState.isInternetAvailable()) {
                            AuditExecutor.getInstance().tryAuditPackagesSubmit(appState);
                            if (AuditExecutor.getInstance().canRemoteAuditStart()) {
                                boolean auditSuccess = false;
                                try {
                                    auditSuccess = AuditExecutor.getInstance().tryRemoteAuditStart(appState);
                                }
                                catch (Exception exception) {
                                    logger.error("Remote audit start failed", (Throwable)exception);
                                }
                            }
                        }
                    }
                    Thread.sleep(100L);
                    if (appState.getTaxCardCertificate() == null) {
                        EventManager.getInstance().postNotification("Upozorenje ", "Molim vas ubacite karticu!!!", NotificationSeverity.Error);
                    }
                    File[] availableAuditPackages = null;
                    if (appState != null && appState.getTaxCardCertificate() != null && appState.getTaxCardCertificate().getSubject() != null && appState.getTaxCardCertificate().getSubject().getSerialNumber() != null) {
                        availableAuditPackages = FsUtil.getAuditPackagesForSubmittingByUid(appState.getTaxCardCertificate().getSubject().getSerialNumber());
                    }
                    if (availableAuditPackages == null) {
                        String itemCode = "text.file.number.contect.";
                        logger.info("availableAuditPackages " + availableAuditPackages);
                        break block30;
                    }
                    if (availableAuditPackages == null) break block30;
                    String lastDate = "";
                    logger.info("availableAuditPackages else " + availableAuditPackages.length);
                    for (File file : availableAuditPackages) {
                        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
                        try {
                            FileTime fileTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                            if (!OnlineStatusNotifier.printFileTime(fileTime)) continue;
                            LocalDate localDate = Instant.ofEpochMilli(fileTime.toMillis()).atZone(ZoneId.systemDefault()).toLocalDate();
                            lastDate = String.valueOf(localDate);
                            EventManager.getInstance().postNotification("Greska ", "Imate racune starije od 4 dana!!!", NotificationSeverity.Error);
                            appState.removeTaxCoreConfigurationData();
                            appState.setCardPinCodeEntered(true);
                            String itemCode = "text.file.bill.contect.";
                            logger.info("Racun stariji od 4 dana");
                            if (neposlatiRacun.getHour() != LocalDateTime.now().getHour() || neposlatiRacun.getMinute() != LocalDateTime.now().getMinute() || !this.netIsAvailable()) continue;
                            logger.info("Dijalog - Racun stariji od 4 dana");
                            neposlatiRacun.plusHours(2L);
                            Alert alert = new Alert(Alert.AlertType.WARNING);
                            alert.setTitle("Upozorenje o Ra\u010dunima");
                            alert.setHeaderText("Imate racune starije od 4 dana!!");
                            alert.setContentText("Molimo proverite  ra\u010dune.");
                            DialogPane dialogPane = alert.getDialogPane();
                            dialogPane.setPrefSize(100.0, 200.0);
                            alert.showAndWait();
                        }
                        catch (IOException e) {
                            System.err.println("Cannot get the last modified time - " + e);
                        }
                    }
                    int length = availableAuditPackages.length;
                    if (localTimeLicence.getHour() == LocalTime.now().getHour() && localTimeLicence.getMinute() == LocalTime.now().getMinute()) {
                        localTimeLicence = localTimeLicence.plusHours(24L);
                        this.licence();
                    }
                    if (length < 0) break block30;
                    if (length > 0) {
                        String itemCode = "text.file.number.contect.";
                        BoolStatusUiItem item1 = this.statusTabPanel.findItem(itemCode);
                        item1.updateStatus1(true, " Broj neposlatih racuna je: " + length);
                        item1.setVisible(true);
                    }
                    if (localTime.getHour() != LocalTime.now().getHour() || localTime.getMinute() != LocalTime.now().getMinute()) break block30;
                    localTime = localTime.plusHours(8L);
                    logger.info("Obavestenje  " + length + ", naredno vreme je " + localTime);
                    TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
                    if (taxCardCertificate != null && this.netIsAvailable()) {
                        ObjectMapper mapper = new ObjectMapper();
                        OkHttpClient client = new OkHttpClient();
                        FormBody formBody = new FormBody.Builder().add("lastDate", lastDate).add("unsentBills", String.valueOf(length)).add("cardNumber", taxCardCertificate.getSubject().getSerialNumber()).add("lpfrVersion", "1.1").build();
                        Request request = new Request.Builder().url("https://licence.mastersoftware.rs/api/status/lpfr").post((RequestBody)formBody).header("Authorization", "Bearer 4dd8e53310a2e3be2553893e4ac945dd004577d44a296027d3877c183e200cba").build();
                        try {
                            Response response1 = client.newCall(request).execute();
                            if (200 == response1.code()) {
                                logger.info("Response status lprf " + response1.message());
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (length > 0) {
                        EventManager.getInstance().postInfoNotification(I18N.text("text.file.number.contect.false") + length);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++iteration;
        }
        try {
            TaxApiClient.getInstance().notifyOnlineStatus(this.sdcOnline, AppState.getInstance().getTaxCoreApiToken().getToken(), AppState.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean netIsAvailable() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isSdcOnline() {
        return this.sdcOnline;
    }

    public void setSdcOnline(boolean sdcOnline) {
        this.sdcOnline = sdcOnline;
    }

    public static synchronized boolean initializeSDC(AppState appState) throws Exception {
        boolean initSuccess = false;
        ApiResponse response = CardReader.getInstance().readTaxCardPkiAppletAndGetApiToken(appState);
        if (200 == response.getCode()) {
            response = TaxApiClient.getInstance().getInitializationCommands(appState.getTaxCoreApiToken().getToken(), AppState.getInstance());
            if (200 == response.getCode()) {
                logger.info("SDC is initialized and configured.");
                initSuccess = true;
            } else {
                logger.warn("getInitializationCommands response could not be retrieved: " + response.toString());
            }
        } else {
            logger.warn("getTaxCoreApiToken() response could not be retrieved: " + response.toString());
        }
        return initSuccess;
    }

    public void licence() {
        if (this.netIsAvailable()) {
            System.out.println("Dostupan internet ");
            AppState appState = AppState.getInstance();
            TaxCardCertificate taxCardCertificate = appState.getTaxCardCertificate();
            if (taxCardCertificate != null) {
                ObjectMapper mapper = new ObjectMapper();
                OkHttpClient client = new OkHttpClient();
                System.out.println("Issuer " + taxCardCertificate.getSubject() + " " + taxCardCertificate.getIssuer());
                FormBody formBody = new FormBody.Builder().add("vatNumber", String.valueOf(taxCardCertificate.getTaxpayerTin())).add("validTo", String.valueOf(taxCardCertificate.getValidTo())).add("note", String.valueOf(taxCardCertificate.getSubject().getO() + " ," + taxCardCertificate.getSubject().getStreet()) + ", " + taxCardCertificate.getSubject().getL()).add("cardNumber", taxCardCertificate.getSubject().getSerialNumber()).build();
                Request request = new Request.Builder().url("https://licence.mastersoftware.rs/api/licence/lpfr").post((RequestBody)formBody).header("Authorization", "Bearer 4dd8e53310a2e3be2553893e4ac945dd004577d44a296027d3877c183e200cba").build();
                try {
                    Response response = client.newCall(request).execute();
                    if (200 == response.code()) {
                        Licenca licenca = (Licenca)mapper.readValue(response.body().byteStream(), Licenca.class);
                        if (!licenca.getLicence().booleanValue()) {
                            logger.error("Licena je " + licenca);
                            EventManager.getInstance().postNotification("Greska ", licenca.getMessage(), NotificationSeverity.Error);
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else if (licenca.getMessage() != null && !licenca.getMessage().isEmpty()) {
                            EventManager.getInstance().postNotification("Upozorenje ", "Upozorenje " + licenca.getMessage(), NotificationSeverity.Warning);
                        }
                    } else {
                        EventManager.getInstance().postNotification("Upozorenje ", "Nema odgovora od licence servisa!!!", NotificationSeverity.Warning);
                        logger.error("Greska  " + response.code());
                        System.out.println("Response code je " + response.code());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean printFileTime(FileTime fileTime) {
        LocalDate localDate = Instant.ofEpochMilli(fileTime.toMillis()).atZone(ZoneId.systemDefault()).toLocalDate();
        logger.info("Datum racuna je " + localDate);
        LocalDate now = LocalDate.now().minusDays(4L);
        logger.info("datum racuna isteka racuna je " + localDate.isBefore(now));
        return localDate.isBefore(now);
    }
}

