/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.printimage;

import com.dmi.sdccore.printimage.NPrintUtil;

public class ContentProporties {
    protected static String makeLineWithString(String string, int numOfCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfCharacters - 1; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String taxMarkNameLineImage(String mark, String name, int numberChar) {
        int value = 15;
        if (numberChar <= 30) {
            value = 12;
        }
        return ContentProporties.textWithSpaceBetween(mark, name, value);
    }

    public static String taxRateVatLineImage(String rate, String vat, int numberChar) {
        int value = 14;
        if (numberChar <= 30) {
            value = 10;
        }
        int rLength = rate.length();
        return ContentProporties.textWithSpaceBetween(rate, vat, rLength + value);
    }

    public static String makeLineWithChar(char lineChar, int printerNumOfCharacters) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < printerNumOfCharacters - 1; ++i) {
            sb.append(lineChar);
        }
        return sb.toString();
    }

    public static String contentInTheMiddle(String content, int printerNumOfCharacters) {
        int numOfChars = (printerNumOfCharacters - content.length()) / 2 + content.length() - 1;
        return String.format("%" + numOfChars + "s", content);
    }

    public String contentAtTheEnd(String content, int printerNumOfCharacters) {
        int numOfChars = printerNumOfCharacters - 2;
        return String.format("%" + numOfChars + "s", content);
    }

    public String makeMultiRowContent(String content, int printerNumOfCharacters) {
        StringBuilder multiContent = new StringBuilder();
        while (content.length() != 0) {
            if (content.length() > printerNumOfCharacters) {
                multiContent.append(" ");
                multiContent.append(content.substring(0, printerNumOfCharacters - 2));
                multiContent.append(ContentProporties.newRow());
                content = content.substring(printerNumOfCharacters - 2);
                continue;
            }
            multiContent.append(" ");
            multiContent.append(content);
            content = "";
        }
        return multiContent.toString();
    }

    public static String textInTheMiddleWithSigns(String text, char sign, int printerNumOfCharaxters) {
        int i;
        int rest = printerNumOfCharaxters - text.length();
        int before = rest / 2;
        int after = before++;
        if (rest % 2 != 0) {
            // empty if block
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < before; ++i) {
            result.append(sign);
        }
        result.append(text);
        for (i = 0; i < after; ++i) {
            result.append(sign);
        }
        return result.toString();
    }

    public static String textWithSpaceBetween(String left, String right, int printerNumOfCharaxters) {
        int rest = printerNumOfCharaxters - left.length() - right.length();
        StringBuilder result = new StringBuilder();
        result.append(" ");
        result.append(left);
        for (int i = 0; i < rest - 2; ++i) {
            result.append(" ");
        }
        result.append(right);
        return result.toString();
    }

    public String textWithSpaceBetween1(String left, String right, int printerNumOfCharaxters) {
        int rest = printerNumOfCharaxters - left.length() - right.length();
        String result = "";
        result = result + " ";
        result = result + left;
        for (int i = 0; i < rest - 2; ++i) {
            result = result + " ";
        }
        result = result + right;
        return result;
    }

    public static String qunatitySumLine(String quantity, String sum) {
        int qLength = quantity.length();
        return ContentProporties.textWithSpaceBetween(quantity, sum, qLength + 15);
    }

    public static String priceLine(String empty, String price) {
        return ContentProporties.textWithSpaceBetween(empty, price, 14);
    }

    public String taxMarkNameLine(String mark, String name) {
        return ContentProporties.textWithSpaceBetween(mark, name, 15);
    }

    public String taxRateVatLine(String rate, String vat) {
        int rLength = rate.length();
        return ContentProporties.textWithSpaceBetween(rate, vat, rLength + 14);
    }

    public static String formatOnThree(double value) {
        return NPrintUtil.decimalFormatOnThree(value);
    }

    public static String formatOnTwo(double value) {
        return NPrintUtil.decimalFormatOnTwoWithZero(value);
    }

    public static String methodName(String key) {
        if (key.toLowerCase().equals("cash")) {
            return "Gotovina:";
        }
        if (key.toLowerCase().equals("card")) {
            return "Platna Kartica:";
        }
        if (key.toLowerCase().equals("check")) {
            return "Cek:";
        }
        if (key.toLowerCase().equals("wiretransfer")) {
            return "Prenos na ra\u010dun:";
        }
        if (key.toLowerCase().equals("voucher")) {
            return "Vaucer:";
        }
        if (key.toLowerCase().equals("mobilemoney")) {
            return "Instant placanje:";
        }
        if (key.toLowerCase().equals("other")) {
            return "Ostalo:";
        }
        return "";
    }

    public static String newRow() {
        return "\n";
    }

    public String spaces(int spacesCount) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < spacesCount - 1; ++i) {
            result.append(" ");
        }
        return result.toString();
    }
}

