/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.invoice;

import java.util.HashMap;
import java.util.Map;

public enum InvoiceType {
    Normal(0),
    Proforma(1),
    Copy(2),
    Training(3),
    Advance(4);

    private final int value;
    private static final Map<Integer, InvoiceType> byValue;

    private InvoiceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static InvoiceType getByValue(int value) {
        return byValue.get(value);
    }

    public static boolean isValueSupported(int value) {
        return byValue.get(value) != null;
    }

    static {
        byValue = new HashMap<Integer, InvoiceType>();
        for (InvoiceType p : InvoiceType.values()) {
            if (byValue.put(p.getValue(), p) == null) continue;
            throw new IllegalArgumentException("duplicated value: " + p.value);
        }
    }
}

