/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.invoice;

import java.util.HashMap;
import java.util.Map;

public enum InvoiceTransactionType {
    Sale(0),
    Refund(1);

    private final int value;
    private static final Map<Integer, InvoiceTransactionType> byValue;

    private InvoiceTransactionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static InvoiceTransactionType getByValue(int value) {
        return byValue.get(value);
    }

    public static boolean isValueSupported(int value) {
        return byValue.get(value) != null;
    }

    static {
        byValue = new HashMap<Integer, InvoiceTransactionType>();
        for (InvoiceTransactionType p : InvoiceTransactionType.values()) {
            if (byValue.put(p.getValue(), p) == null) continue;
            throw new IllegalArgumentException("duplicated value: " + p.value);
        }
    }
}

