/*
 * Decompiled with CFR 0.152.
 */
package com.dmi.sdccore.api.model.invoice;

import java.util.HashMap;
import java.util.Map;

public enum InvoicePaymentType {
    Other(0),
    Cash(1),
    Card(2),
    Check(3),
    WireTransfer(4),
    Voucher(5),
    MobileMoney(6);

    private final int value;
    private static final Map<Integer, InvoicePaymentType> byValue;

    private InvoicePaymentType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static InvoicePaymentType getByValue(int value) {
        return byValue.get(value);
    }

    public static boolean isValueSupported(int value) {
        return byValue.get(value) != null;
    }

    static {
        byValue = new HashMap<Integer, InvoicePaymentType>();
        for (InvoicePaymentType p : InvoicePaymentType.values()) {
            if (byValue.put(p.getValue(), p) == null) continue;
            throw new IllegalArgumentException("duplicated value: " + p.value);
        }
    }
}

